# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from xtrf_python_api.api_client import ApiClient


class ReportsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete4(self, report_id, **kwargs):  # noqa: E501
        """Removes a report.  # noqa: E501

        Removes a report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete4(report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int report_id: report's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete4_with_http_info(report_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete4_with_http_info(report_id, **kwargs)  # noqa: E501
            return data

    def delete4_with_http_info(self, report_id, **kwargs):  # noqa: E501
        """Removes a report.  # noqa: E501

        Removes a report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete4_with_http_info(report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int report_id: report's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['report_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete4" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'report_id' is set
        if ('report_id' not in params or
                params['report_id'] is None):
            raise ValueError("Missing the required parameter `report_id` when calling `delete4`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'report_id' in params:
            path_params['reportId'] = params['report_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/reports/{reportId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def duplicate1(self, report_id, **kwargs):  # noqa: E501
        """Duplicates a report.  # noqa: E501

        Duplicates a report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.duplicate1(report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int report_id: report's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.duplicate1_with_http_info(report_id, **kwargs)  # noqa: E501
        else:
            (data) = self.duplicate1_with_http_info(report_id, **kwargs)  # noqa: E501
            return data

    def duplicate1_with_http_info(self, report_id, **kwargs):  # noqa: E501
        """Duplicates a report.  # noqa: E501

        Duplicates a report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.duplicate1_with_http_info(report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int report_id: report's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['report_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method duplicate1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'report_id' is set
        if ('report_id' not in params or
                params['report_id'] is None):
            raise ValueError("Missing the required parameter `report_id` when calling `duplicate1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'report_id' in params:
            path_params['reportId'] = params['report_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/reports/{reportId}/duplicate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_to_xml(self, body, **kwargs):  # noqa: E501
        """Exports reports definition to XML.  # noqa: E501

        Exports reports definition to XML.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_to_xml(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ExportRequestDTO body: Exported reports definition to XML. (required)
        :return: ReportResultDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_to_xml_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.export_to_xml_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def export_to_xml_with_http_info(self, body, **kwargs):  # noqa: E501
        """Exports reports definition to XML.  # noqa: E501

        Exports reports definition to XML.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_to_xml_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ExportRequestDTO body: Exported reports definition to XML. (required)
        :return: ReportResultDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_to_xml" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `export_to_xml`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/reports/export/xml', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReportResultDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generate_csv(self, report_id, **kwargs):  # noqa: E501
        """Generates CSV content for a report.  # noqa: E501

        Generates CSV content for a report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_csv(report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int report_id: report's internal identifier (required)
        :return: ReportResultDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.generate_csv_with_http_info(report_id, **kwargs)  # noqa: E501
        else:
            (data) = self.generate_csv_with_http_info(report_id, **kwargs)  # noqa: E501
            return data

    def generate_csv_with_http_info(self, report_id, **kwargs):  # noqa: E501
        """Generates CSV content for a report.  # noqa: E501

        Generates CSV content for a report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_csv_with_http_info(report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int report_id: report's internal identifier (required)
        :return: ReportResultDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['report_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_csv" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'report_id' is set
        if ('report_id' not in params or
                params['report_id'] is None):
            raise ValueError("Missing the required parameter `report_id` when calling `generate_csv`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'report_id' in params:
            path_params['reportId'] = params['report_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/reports/{reportId}/result/csv', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReportResultDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generate_printer_friendly(self, report_id, **kwargs):  # noqa: E501
        """Generates printer friendly content for a report.  # noqa: E501

        Generates printer friendly content for a report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_printer_friendly(report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int report_id: report's internal identifier (required)
        :return: ReportResultDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.generate_printer_friendly_with_http_info(report_id, **kwargs)  # noqa: E501
        else:
            (data) = self.generate_printer_friendly_with_http_info(report_id, **kwargs)  # noqa: E501
            return data

    def generate_printer_friendly_with_http_info(self, report_id, **kwargs):  # noqa: E501
        """Generates printer friendly content for a report.  # noqa: E501

        Generates printer friendly content for a report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_printer_friendly_with_http_info(report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int report_id: report's internal identifier (required)
        :return: ReportResultDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['report_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_printer_friendly" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'report_id' is set
        if ('report_id' not in params or
                params['report_id'] is None):
            raise ValueError("Missing the required parameter `report_id` when calling `generate_printer_friendly`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'report_id' in params:
            path_params['reportId'] = params['report_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/reports/{reportId}/result/printerFriendly', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReportResultDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_from_xml(self, body, **kwargs):  # noqa: E501
        """Imports reports definition from XML.  # noqa: E501

        Imports a report definition from an XML using a file token. To obtain the token, you first need to upload a temporary XML file, as specified in the Files section. Note that the name of the imported report must be unique.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_from_xml(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImportRequestDTO body: Imported reports definition from XML. (required)
        :return: ImportResultDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_from_xml_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.import_from_xml_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def import_from_xml_with_http_info(self, body, **kwargs):  # noqa: E501
        """Imports reports definition from XML.  # noqa: E501

        Imports a report definition from an XML using a file token. To obtain the token, you first need to upload a temporary XML file, as specified in the Files section. Note that the name of the imported report must be unique.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_from_xml_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImportRequestDTO body: Imported reports definition from XML. (required)
        :return: ImportResultDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_from_xml" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `import_from_xml`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/reports/import/xml', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportResultDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_preferred(self, body, report_id, **kwargs):  # noqa: E501
        """Marks report as preferred or not.  # noqa: E501

        Marks report as preferred or not.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_preferred(body, report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PreferredRequestDTO body: Marked report as preferred or not. (required)
        :param int report_id: report's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_preferred_with_http_info(body, report_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_preferred_with_http_info(body, report_id, **kwargs)  # noqa: E501
            return data

    def set_preferred_with_http_info(self, body, report_id, **kwargs):  # noqa: E501
        """Marks report as preferred or not.  # noqa: E501

        Marks report as preferred or not.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_preferred_with_http_info(body, report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PreferredRequestDTO body: Marked report as preferred or not. (required)
        :param int report_id: report's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'report_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_preferred" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_preferred`")  # noqa: E501
        # verify the required parameter 'report_id' is set
        if ('report_id' not in params or
                params['report_id'] is None):
            raise ValueError("Missing the required parameter `report_id` when calling `set_preferred`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'report_id' in params:
            path_params['reportId'] = params['report_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/reports/{reportId}/preferred', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
