# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from xtrf_python_api.api_client import ApiClient


class ProjectsClassicApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create1(self, body, **kwargs):  # noqa: E501
        """Creates a new Classic Project.  # noqa: E501

        Creates a new Classic Project. If the specified service ID refers to Smart Project, 400 Bad Request is returned instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create1(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectCreateDTO body: Created a new Classic Project. (required)
        :return: ProjectDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create1_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create1_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create1_with_http_info(self, body, **kwargs):  # noqa: E501
        """Creates a new Classic Project.  # noqa: E501

        Creates a new Classic Project. If the specified service ID refers to Smart Project, 400 Bad Request is returned instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create1_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectCreateDTO body: Created a new Classic Project. (required)
        :return: ProjectDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create1`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/projects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_language_combination(self, body, project_id, **kwargs):  # noqa: E501
        """Creates a new language combination for a given project without creating a task.  # noqa: E501

        Creates a new language combination for a given project without creating a task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_language_combination(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LanguageCombinationDTO body: Created language combination for a given project without creating a task. (required)
        :param str project_id: project's internal identifier (required)
        :return: LanguageCombinationDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_language_combination_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_language_combination_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def create_language_combination_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """Creates a new language combination for a given project without creating a task.  # noqa: E501

        Creates a new language combination for a given project without creating a task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_language_combination_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LanguageCombinationDTO body: Created language combination for a given project without creating a task. (required)
        :param str project_id: project's internal identifier (required)
        :return: LanguageCombinationDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_language_combination" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_language_combination`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `create_language_combination`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{projectId}/languageCombinations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LanguageCombinationDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_task(self, body, project_id, **kwargs):  # noqa: E501
        """Creates a new task for a given project.  # noqa: E501

        Creates a new task for a given project. Required fields are presented in the example.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_task(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaskDTO body: Created new task for a given project. (required)
        :param str project_id: project's internal identifier (required)
        :return: TaskDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_task_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_task_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def create_task_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """Creates a new task for a given project.  # noqa: E501

        Creates a new task for a given project. Required fields are presented in the example.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_task_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaskDTO body: Created new task for a given project. (required)
        :param str project_id: project's internal identifier (required)
        :return: TaskDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_task`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `create_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{projectId}/tasks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete5(self, project_id, **kwargs):  # noqa: E501
        """Removes a project.  # noqa: E501

        Removes a project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete5(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete5_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete5_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def delete5_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """Removes a project.  # noqa: E501

        Removes a project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete5_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete5" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `delete5`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{projectId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_ids6(self, **kwargs):  # noqa: E501
        """Returns projects' internal identifiers.  # noqa: E501

        Returns projects' internal identifiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_ids6(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updated_since: only projects modified since this timestamp
        :return: list[int]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_ids6_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_ids6_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_ids6_with_http_info(self, **kwargs):  # noqa: E501
        """Returns projects' internal identifiers.  # noqa: E501

        Returns projects' internal identifiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_ids6_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updated_since: only projects modified since this timestamp
        :return: list[int]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['updated_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_ids6" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'updated_since' in params:
            query_params.append(('updatedSince', params['updated_since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/projects/ids', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[int]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_by_id7(self, project_id, **kwargs):  # noqa: E501
        """Returns project details.  # noqa: E501

        Returns project details. If the specified project ID refers to Smart Project, 400 Bad Request is returned instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id7(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project's internal identifier (required)
        :param str embed: list of adittional fields which should be embedded in the response (ie. tasks)
        :return: ProjectDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_by_id7_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_by_id7_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def get_by_id7_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """Returns project details.  # noqa: E501

        Returns project details. If the specified project ID refers to Smart Project, 400 Bad Request is returned instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id7_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project's internal identifier (required)
        :param str embed: list of adittional fields which should be embedded in the response (ie. tasks)
        :return: ProjectDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'embed']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_id7" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_by_id7`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []
        if 'embed' in params:
            query_params.append(('embed', params['embed']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{projectId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_contacts(self, project_id, **kwargs):  # noqa: E501
        """Returns contacts of a given project.  # noqa: E501

        Returns contacts of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contacts(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project's internal identifier (required)
        :return: ContactsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_contacts_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_contacts_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def get_contacts_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """Returns contacts of a given project.  # noqa: E501

        Returns contacts of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contacts_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project's internal identifier (required)
        :return: ContactsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contacts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_contacts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{projectId}/contacts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContactsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_custom_fields5(self, project_id, **kwargs):  # noqa: E501
        """Returns custom fields of a given project.  # noqa: E501

        Returns custom fields of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_custom_fields5(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_custom_fields5_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_custom_fields5_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def get_custom_fields5_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """Returns custom fields of a given project.  # noqa: E501

        Returns custom fields of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_custom_fields5_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_custom_fields5" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_custom_fields5`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{projectId}/customFields', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFieldsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dates1(self, project_id, **kwargs):  # noqa: E501
        """Returns dates of a given project.  # noqa: E501

        Returns dates of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dates1(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project's internal identifier (required)
        :return: ProjectDatesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dates1_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dates1_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def get_dates1_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """Returns dates of a given project.  # noqa: E501

        Returns dates of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dates1_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project's internal identifier (required)
        :return: ProjectDatesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dates1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_dates1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{projectId}/dates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectDatesDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_finance(self, project_id, **kwargs):  # noqa: E501
        """Returns finance of a given project.  # noqa: E501

        Returns finance of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_finance(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project's internal identifier (required)
        :return: FinanceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_finance_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_finance_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def get_finance_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """Returns finance of a given project.  # noqa: E501

        Returns finance of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_finance_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project's internal identifier (required)
        :return: FinanceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_finance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_finance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{projectId}/finance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FinanceDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instructions(self, project_id, **kwargs):  # noqa: E501
        """Returns instructions of a given project.  # noqa: E501

        Returns instructions of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instructions(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project's internal identifier (required)
        :return: InstructionsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instructions_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instructions_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def get_instructions_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """Returns instructions of a given project.  # noqa: E501

        Returns instructions of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instructions_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project's internal identifier (required)
        :return: InstructionsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instructions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_instructions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{projectId}/instructions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstructionsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_contacts(self, body, project_id, **kwargs):  # noqa: E501
        """Updates contacts of a given project.  # noqa: E501

        Updates contacts of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_contacts(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ContactsDTO body: Updated contacts of a given project. (required)
        :param str project_id: project's internal identifier (required)
        :return: ContactsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_contacts_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_contacts_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def update_contacts_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """Updates contacts of a given project.  # noqa: E501

        Updates contacts of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_contacts_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ContactsDTO body: Updated contacts of a given project. (required)
        :param str project_id: project's internal identifier (required)
        :return: ContactsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_contacts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_contacts`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `update_contacts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{projectId}/contacts', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContactsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_custom_fields(self, body, project_id, **kwargs):  # noqa: E501
        """Updates custom fields of a given project.  # noqa: E501

        Updates custom fields of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_custom_fields(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomFieldDTO] body: Updated custom fields of a given project. (required)
        :param str project_id: project's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_custom_fields_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_custom_fields_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def update_custom_fields_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """Updates custom fields of a given project.  # noqa: E501

        Updates custom fields of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_custom_fields_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomFieldDTO] body: Updated custom fields of a given project. (required)
        :param str project_id: project's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_custom_fields`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `update_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{projectId}/customFields', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFieldsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_dates(self, body, project_id, **kwargs):  # noqa: E501
        """Updates dates of a given project.  # noqa: E501

        Updates dates of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dates(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectDatesDTO body: Updated dates of a given project.. (required)
        :param str project_id: project's internal identifier (required)
        :return: ProjectDatesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_dates_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_dates_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def update_dates_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """Updates dates of a given project.  # noqa: E501

        Updates dates of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dates_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectDatesDTO body: Updated dates of a given project.. (required)
        :param str project_id: project's internal identifier (required)
        :return: ProjectDatesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_dates" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_dates`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `update_dates`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{projectId}/dates', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectDatesDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_instructions(self, body, project_id, **kwargs):  # noqa: E501
        """Updates instructions of a given project.  # noqa: E501

        Updates instructions of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instructions(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstructionsDTO body: Updated instructions of a given project. (required)
        :param str project_id: project's internal identifier (required)
        :return: InstructionsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_instructions_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_instructions_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def update_instructions_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """Updates instructions of a given project.  # noqa: E501

        Updates instructions of a given project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instructions_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstructionsDTO body: Updated instructions of a given project. (required)
        :param str project_id: project's internal identifier (required)
        :return: InstructionsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_instructions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_instructions`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `update_instructions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{projectId}/instructions', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstructionsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
