# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from xtrf_python_api.api_client import ApiClient


class BrowserApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def browse_csv(self, **kwargs):  # noqa: E501
        """Searches for data (ie. customer, task, etc) and returns it in a CSV form.  # noqa: E501

        Searches for data (ie. customer, task, etc) and returns it in a CSV form.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.browse_csv(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier
        :param str separator: csv field separator
        :param str additional_order:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.browse_csv_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.browse_csv_with_http_info(**kwargs)  # noqa: E501
            return data

    def browse_csv_with_http_info(self, **kwargs):  # noqa: E501
        """Searches for data (ie. customer, task, etc) and returns it in a CSV form.  # noqa: E501

        Searches for data (ie. customer, task, etc) and returns it in a CSV form.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.browse_csv_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier
        :param str separator: csv field separator
        :param str additional_order:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'separator', 'additional_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method browse_csv" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'view_id' in params:
            query_params.append(('viewId', params['view_id']))  # noqa: E501
        if 'separator' in params:
            query_params.append(('separator', params['separator']))  # noqa: E501
        if 'additional_order' in params:
            query_params.append(('additionalOrder', params['additional_order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/csv', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def browse_json(self, **kwargs):  # noqa: E501
        """Searches for data (ie. customer, task, etc) and returns it in a tabular form.  # noqa: E501

        Searches for data (ie. customer, task, etc) and returns it in a tabular form.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.browse_json(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier
        :param int page:
        :param str additional_order:
        :param str use_deferred_columns:
        :param int max_rows: overrides view's default rows limit, supported values 10 to 1000
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.browse_json_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.browse_json_with_http_info(**kwargs)  # noqa: E501
            return data

    def browse_json_with_http_info(self, **kwargs):  # noqa: E501
        """Searches for data (ie. customer, task, etc) and returns it in a tabular form.  # noqa: E501

        Searches for data (ie. customer, task, etc) and returns it in a tabular form.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.browse_json_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier
        :param int page:
        :param str additional_order:
        :param str use_deferred_columns:
        :param int max_rows: overrides view's default rows limit, supported values 10 to 1000
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'page', 'additional_order', 'use_deferred_columns', 'max_rows']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method browse_json" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'view_id' in params:
            query_params.append(('viewId', params['view_id']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'additional_order' in params:
            query_params.append(('additionalOrder', params['additional_order']))  # noqa: E501
        if 'use_deferred_columns' in params:
            query_params.append(('useDeferredColumns', params['use_deferred_columns']))  # noqa: E501
        if 'max_rows' in params:
            query_params.append(('maxRows', params['max_rows']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create(self, body, class_name, **kwargs):  # noqa: E501
        """Creates view for given class.  # noqa: E501

        Creates view for given class.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(body, class_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ViewDTO body: Created view for given class. (required)
        :param str class_name: view's class name (required)
        :return: ViewWithIdDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_with_http_info(body, class_name, **kwargs)  # noqa: E501
        else:
            (data) = self.create_with_http_info(body, class_name, **kwargs)  # noqa: E501
            return data

    def create_with_http_info(self, body, class_name, **kwargs):  # noqa: E501
        """Creates view for given class.  # noqa: E501

        Creates view for given class.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_with_http_info(body, class_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ViewDTO body: Created view for given class. (required)
        :param str class_name: view's class name (required)
        :return: ViewWithIdDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'class_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create`")  # noqa: E501
        # verify the required parameter 'class_name' is set
        if ('class_name' not in params or
                params['class_name'] is None):
            raise ValueError("Missing the required parameter `class_name` when calling `create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'class_name' in params:
            path_params['className'] = params['class_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/for/{className}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ViewWithIdDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete(self, view_id, **kwargs):  # noqa: E501
        """Removes a view.  # noqa: E501

        Removes a view. No content is returned upon success (204).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_with_http_info(view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_with_http_info(view_id, **kwargs)  # noqa: E501
            return data

    def delete_with_http_info(self, view_id, **kwargs):  # noqa: E501
        """Removes a view.  # noqa: E501

        Removes a view. No content is returned upon success (204).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_with_http_info(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_column(self, view_id, column_name, **kwargs):  # noqa: E501
        """Deletes a single column from view.  # noqa: E501

        Deletes a single column from view.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_column(view_id, column_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :param str column_name: column's name (required)
        :return: list[ColumnDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_column_with_http_info(view_id, column_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_column_with_http_info(view_id, column_name, **kwargs)  # noqa: E501
            return data

    def delete_column_with_http_info(self, view_id, column_name, **kwargs):  # noqa: E501
        """Deletes a single column from view.  # noqa: E501

        Deletes a single column from view.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_column_with_http_info(view_id, column_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :param str column_name: column's name (required)
        :return: list[ColumnDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'column_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_column" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `delete_column`")  # noqa: E501
        # verify the required parameter 'column_name' is set
        if ('column_name' not in params or
                params['column_name'] is None):
            raise ValueError("Missing the required parameter `column_name` when calling `delete_column`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501
        if 'column_name' in params:
            path_params['columnName'] = params['column_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}/columns/{columnName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ColumnDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get(self, view_id, **kwargs):  # noqa: E501
        """Returns all view's information.  # noqa: E501

        Returns all view's information (ie. name, columns, filters, etc).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :return: ViewDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_with_http_info(view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_with_http_info(view_id, **kwargs)  # noqa: E501
            return data

    def get_with_http_info(self, view_id, **kwargs):  # noqa: E501
        """Returns all view's information.  # noqa: E501

        Returns all view's information (ie. name, columns, filters, etc).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_with_http_info(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :return: ViewDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ViewDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_column_settings(self, view_id, column_name, **kwargs):  # noqa: E501
        """Returns column's specific settings.  # noqa: E501

        Returns column's specific settings. For example when column describes money amount we can decide whether it should display currency or not.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_column_settings(view_id, column_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :param str column_name: column's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_column_settings_with_http_info(view_id, column_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_column_settings_with_http_info(view_id, column_name, **kwargs)  # noqa: E501
            return data

    def get_column_settings_with_http_info(self, view_id, column_name, **kwargs):  # noqa: E501
        """Returns column's specific settings.  # noqa: E501

        Returns column's specific settings. For example when column describes money amount we can decide whether it should display currency or not.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_column_settings_with_http_info(view_id, column_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :param str column_name: column's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'column_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_column_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_column_settings`")  # noqa: E501
        # verify the required parameter 'column_name' is set
        if ('column_name' not in params or
                params['column_name'] is None):
            raise ValueError("Missing the required parameter `column_name` when calling `get_column_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501
        if 'column_name' in params:
            path_params['columnName'] = params['column_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}/columns/{columnName}/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_columns(self, view_id, **kwargs):  # noqa: E501
        """Returns columns defined in view.  # noqa: E501

        Returns columns defined in view.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_columns(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :return: list[ColumnDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_columns_with_http_info(view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_columns_with_http_info(view_id, **kwargs)  # noqa: E501
            return data

    def get_columns_with_http_info(self, view_id, **kwargs):  # noqa: E501
        """Returns columns defined in view.  # noqa: E501

        Returns columns defined in view.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_columns_with_http_info(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :return: list[ColumnDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_columns" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_columns`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}/columns', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ColumnDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_current_view_details(self, class_name, **kwargs):  # noqa: E501
        """Returns current view's detailed information, suitable for browser.  # noqa: E501

        Returns current view's detailed information, suitable for browser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_current_view_details(class_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str class_name: views' class name (required)
        :param str place_name: place name (denotes specific place in system with the table)
        :return: ViewDetailsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_current_view_details_with_http_info(class_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_current_view_details_with_http_info(class_name, **kwargs)  # noqa: E501
            return data

    def get_current_view_details_with_http_info(self, class_name, **kwargs):  # noqa: E501
        """Returns current view's detailed information, suitable for browser.  # noqa: E501

        Returns current view's detailed information, suitable for browser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_current_view_details_with_http_info(class_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str class_name: views' class name (required)
        :param str place_name: place name (denotes specific place in system with the table)
        :return: ViewDetailsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['class_name', 'place_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_current_view_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'class_name' is set
        if ('class_name' not in params or
                params['class_name'] is None):
            raise ValueError("Missing the required parameter `class_name` when calling `get_current_view_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'class_name' in params:
            path_params['className'] = params['class_name']  # noqa: E501

        query_params = []
        if 'place_name' in params:
            query_params.append(('placeName', params['place_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/details/for/{className}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ViewDetailsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_filter(self, view_id, **kwargs):  # noqa: E501
        """Returns view's filter.  # noqa: E501

        Returns view's filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_filter(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :return: FilterDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_filter_with_http_info(view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_filter_with_http_info(view_id, **kwargs)  # noqa: E501
            return data

    def get_filter_with_http_info(self, view_id, **kwargs):  # noqa: E501
        """Returns view's filter.  # noqa: E501

        Returns view's filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_filter_with_http_info(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :return: FilterDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}/filter', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FilterDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_local_settings(self, view_id, **kwargs):  # noqa: E501
        """Returns view's local settings (for current user).  # noqa: E501

        Returns view's local settings (for current user).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_local_settings(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :return: LocalSettingsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_local_settings_with_http_info(view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_local_settings_with_http_info(view_id, **kwargs)  # noqa: E501
            return data

    def get_local_settings_with_http_info(self, view_id, **kwargs):  # noqa: E501
        """Returns view's local settings (for current user).  # noqa: E501

        Returns view's local settings (for current user).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_local_settings_with_http_info(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :return: LocalSettingsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_local_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_local_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}/settings/local', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LocalSettingsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_order(self, view_id, **kwargs):  # noqa: E501
        """Returns view's order settings.  # noqa: E501

        Returns view's order settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :return: OrderDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_order_with_http_info(view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_order_with_http_info(view_id, **kwargs)  # noqa: E501
            return data

    def get_order_with_http_info(self, view_id, **kwargs):  # noqa: E501
        """Returns view's order settings.  # noqa: E501

        Returns view's order settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_with_http_info(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :return: OrderDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}/order', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_permissions(self, view_id, **kwargs):  # noqa: E501
        """Returns view's permissions.  # noqa: E501

        Returns view's permissions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_permissions(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :return: PermissionsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_permissions_with_http_info(view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_permissions_with_http_info(view_id, **kwargs)  # noqa: E501
            return data

    def get_permissions_with_http_info(self, view_id, **kwargs):  # noqa: E501
        """Returns view's permissions.  # noqa: E501

        Returns view's permissions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_permissions_with_http_info(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :return: PermissionsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_permissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}/permissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermissionsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_settings(self, view_id, **kwargs):  # noqa: E501
        """Returns view's settings.  # noqa: E501

        Returns view's settings (ie. name).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :return: SettingsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_settings_with_http_info(view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_settings_with_http_info(view_id, **kwargs)  # noqa: E501
            return data

    def get_settings_with_http_info(self, view_id, **kwargs):  # noqa: E501
        """Returns view's settings.  # noqa: E501

        Returns view's settings (ie. name).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_with_http_info(view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int view_id: view's identifier (required)
        :return: SettingsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_view_details(self, class_name, view_id, **kwargs):  # noqa: E501
        """Returns view's detailed information, suitable for browser.  # noqa: E501

        Returns view's detailed information, suitable for browser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_view_details(class_name, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str class_name: views' class name (required)
        :param int view_id: (required)
        :param str place_name: place name (denotes specific place in system with the table)
        :return: ViewDetailsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_view_details_with_http_info(class_name, view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_view_details_with_http_info(class_name, view_id, **kwargs)  # noqa: E501
            return data

    def get_view_details_with_http_info(self, class_name, view_id, **kwargs):  # noqa: E501
        """Returns view's detailed information, suitable for browser.  # noqa: E501

        Returns view's detailed information, suitable for browser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_view_details_with_http_info(class_name, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str class_name: views' class name (required)
        :param int view_id: (required)
        :param str place_name: place name (denotes specific place in system with the table)
        :return: ViewDetailsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['class_name', 'view_id', 'place_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_view_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'class_name' is set
        if ('class_name' not in params or
                params['class_name'] is None):
            raise ValueError("Missing the required parameter `class_name` when calling `get_view_details`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_view_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'class_name' in params:
            path_params['className'] = params['class_name']  # noqa: E501
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []
        if 'place_name' in params:
            query_params.append(('placeName', params['place_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/details/for/{className}/{viewId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ViewDetailsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_views_brief(self, class_name, **kwargs):  # noqa: E501
        """Returns views' brief.  # noqa: E501

        Returns views' brief.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_views_brief(class_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str class_name: views' class name (required)
        :param str place_name: place name (denotes specific place in system with the table)
        :return: ViewsBriefDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_views_brief_with_http_info(class_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_views_brief_with_http_info(class_name, **kwargs)  # noqa: E501
            return data

    def get_views_brief_with_http_info(self, class_name, **kwargs):  # noqa: E501
        """Returns views' brief.  # noqa: E501

        Returns views' brief.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_views_brief_with_http_info(class_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str class_name: views' class name (required)
        :param str place_name: place name (denotes specific place in system with the table)
        :return: ViewsBriefDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['class_name', 'place_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_views_brief" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'class_name' is set
        if ('class_name' not in params or
                params['class_name'] is None):
            raise ValueError("Missing the required parameter `class_name` when calling `get_views_brief`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'class_name' in params:
            path_params['className'] = params['class_name']  # noqa: E501

        query_params = []
        if 'place_name' in params:
            query_params.append(('placeName', params['place_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/for/{className}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ViewsBriefDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def select_view_and_get_its_details(self, class_name, view_id, **kwargs):  # noqa: E501
        """Selects given view as current and returns its detailed information, suitable for browser.  # noqa: E501

        Selects given view as current and returns its detailed information, suitable for browser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.select_view_and_get_its_details(class_name, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str class_name: views' class name (required)
        :param int view_id: (required)
        :param str place_name__denotes_specific_place_in_system_with_the_table:
        :return: ViewDetailsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.select_view_and_get_its_details_with_http_info(class_name, view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.select_view_and_get_its_details_with_http_info(class_name, view_id, **kwargs)  # noqa: E501
            return data

    def select_view_and_get_its_details_with_http_info(self, class_name, view_id, **kwargs):  # noqa: E501
        """Selects given view as current and returns its detailed information, suitable for browser.  # noqa: E501

        Selects given view as current and returns its detailed information, suitable for browser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.select_view_and_get_its_details_with_http_info(class_name, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str class_name: views' class name (required)
        :param int view_id: (required)
        :param str place_name__denotes_specific_place_in_system_with_the_table:
        :return: ViewDetailsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['class_name', 'view_id', 'place_name__denotes_specific_place_in_system_with_the_table']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method select_view_and_get_its_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'class_name' is set
        if ('class_name' not in params or
                params['class_name'] is None):
            raise ValueError("Missing the required parameter `class_name` when calling `select_view_and_get_its_details`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `select_view_and_get_its_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'class_name' in params:
            path_params['className'] = params['class_name']  # noqa: E501
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []
        if 'place_name__denotes_specific_place_in_system_with_the_table' in params:
            query_params.append(('place name (denotes specific place in system with the table)', params['place_name__denotes_specific_place_in_system_with_the_table']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/details/for/{className}/{viewId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ViewDetailsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update(self, body, view_id, **kwargs):  # noqa: E501
        """Updates all view's information.  # noqa: E501

        Updates all view's information (ie. name, columns, filters, etc).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update(body, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ViewDTO body: Updated all view's information. (required)
        :param int view_id: view's identifier (required)
        :return: ViewDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_with_http_info(body, view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_with_http_info(body, view_id, **kwargs)  # noqa: E501
            return data

    def update_with_http_info(self, body, view_id, **kwargs):  # noqa: E501
        """Updates all view's information.  # noqa: E501

        Updates all view's information (ie. name, columns, filters, etc).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_with_http_info(body, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ViewDTO body: Updated all view's information. (required)
        :param int view_id: view's identifier (required)
        :return: ViewDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'view_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ViewDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_column_settings(self, body, view_id, column_name, **kwargs):  # noqa: E501
        """Updates column's specific settings.  # noqa: E501

        Updates column's specific settings. For example when column describes money amount we can decide whether it should display currency or not.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_column_settings(body, view_id, column_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: Updated column's specific settings. (required)
        :param int view_id: view's identifier (required)
        :param str column_name: column's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_column_settings_with_http_info(body, view_id, column_name, **kwargs)  # noqa: E501
        else:
            (data) = self.update_column_settings_with_http_info(body, view_id, column_name, **kwargs)  # noqa: E501
            return data

    def update_column_settings_with_http_info(self, body, view_id, column_name, **kwargs):  # noqa: E501
        """Updates column's specific settings.  # noqa: E501

        Updates column's specific settings. For example when column describes money amount we can decide whether it should display currency or not.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_column_settings_with_http_info(body, view_id, column_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: Updated column's specific settings. (required)
        :param int view_id: view's identifier (required)
        :param str column_name: column's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'view_id', 'column_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_column_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_column_settings`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `update_column_settings`")  # noqa: E501
        # verify the required parameter 'column_name' is set
        if ('column_name' not in params or
                params['column_name'] is None):
            raise ValueError("Missing the required parameter `column_name` when calling `update_column_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501
        if 'column_name' in params:
            path_params['columnName'] = params['column_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}/columns/{columnName}/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_columns(self, body, view_id, **kwargs):  # noqa: E501
        """Updates columns in view.  # noqa: E501

        Updates columns in view.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_columns(body, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[ColumnDTO] body: Updated columns in view. (required)
        :param int view_id: view's identifier (required)
        :return: list[ColumnDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_columns_with_http_info(body, view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_columns_with_http_info(body, view_id, **kwargs)  # noqa: E501
            return data

    def update_columns_with_http_info(self, body, view_id, **kwargs):  # noqa: E501
        """Updates columns in view.  # noqa: E501

        Updates columns in view.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_columns_with_http_info(body, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[ColumnDTO] body: Updated columns in view. (required)
        :param int view_id: view's identifier (required)
        :return: list[ColumnDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'view_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_columns" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_columns`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `update_columns`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}/columns', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ColumnDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_filter(self, body, view_id, **kwargs):  # noqa: E501
        """Updates view's filter.  # noqa: E501

        Updates view's filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_filter(body, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FilterPropertyDTO] body: Updated view's filter. (required)
        :param int view_id: view's identifier (required)
        :return: FilterDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_filter_with_http_info(body, view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_filter_with_http_info(body, view_id, **kwargs)  # noqa: E501
            return data

    def update_filter_with_http_info(self, body, view_id, **kwargs):  # noqa: E501
        """Updates view's filter.  # noqa: E501

        Updates view's filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_filter_with_http_info(body, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FilterPropertyDTO] body: Updated view's filter. (required)
        :param int view_id: view's identifier (required)
        :return: FilterDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'view_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_filter`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `update_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}/filter', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FilterDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_filter_property(self, body, view_id, filter_property, **kwargs):  # noqa: E501
        """Updates view's filter property.  # noqa: E501

        Updates view's filter property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_filter_property(body, view_id, filter_property, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FilterPropertyDTO body: Updated view's filter property. (required)
        :param int view_id: view's identifier (required)
        :param str filter_property: view's filter property name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_filter_property_with_http_info(body, view_id, filter_property, **kwargs)  # noqa: E501
        else:
            (data) = self.update_filter_property_with_http_info(body, view_id, filter_property, **kwargs)  # noqa: E501
            return data

    def update_filter_property_with_http_info(self, body, view_id, filter_property, **kwargs):  # noqa: E501
        """Updates view's filter property.  # noqa: E501

        Updates view's filter property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_filter_property_with_http_info(body, view_id, filter_property, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FilterPropertyDTO body: Updated view's filter property. (required)
        :param int view_id: view's identifier (required)
        :param str filter_property: view's filter property name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'view_id', 'filter_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_filter_property" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_filter_property`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `update_filter_property`")  # noqa: E501
        # verify the required parameter 'filter_property' is set
        if ('filter_property' not in params or
                params['filter_property'] is None):
            raise ValueError("Missing the required parameter `filter_property` when calling `update_filter_property`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501
        if 'filter_property' in params:
            path_params['filterProperty'] = params['filter_property']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}/filter/{filterProperty}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_local_settings(self, body, view_id, **kwargs):  # noqa: E501
        """Updates view's local settings (for current user).  # noqa: E501

        Updates view's local settings (for current user).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_local_settings(body, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LocalSettingsDTO body: Updated view's local settings (for current user). (required)
        :param int view_id: view's identifier (required)
        :return: LocalSettingsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_local_settings_with_http_info(body, view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_local_settings_with_http_info(body, view_id, **kwargs)  # noqa: E501
            return data

    def update_local_settings_with_http_info(self, body, view_id, **kwargs):  # noqa: E501
        """Updates view's local settings (for current user).  # noqa: E501

        Updates view's local settings (for current user).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_local_settings_with_http_info(body, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LocalSettingsDTO body: Updated view's local settings (for current user). (required)
        :param int view_id: view's identifier (required)
        :return: LocalSettingsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'view_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_local_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_local_settings`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `update_local_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}/settings/local', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LocalSettingsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_order(self, body, view_id, **kwargs):  # noqa: E501
        """Updates view's order settings.  # noqa: E501

        Updates view's order settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_order(body, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderDTO body: Updated view's order settings. (required)
        :param int view_id: view's identifier (required)
        :return: OrderDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_order_with_http_info(body, view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_order_with_http_info(body, view_id, **kwargs)  # noqa: E501
            return data

    def update_order_with_http_info(self, body, view_id, **kwargs):  # noqa: E501
        """Updates view's order settings.  # noqa: E501

        Updates view's order settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_order_with_http_info(body, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderDTO body: Updated view's order settings. (required)
        :param int view_id: view's identifier (required)
        :return: OrderDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'view_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_order`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `update_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}/order', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_permissions(self, body, view_id, **kwargs):  # noqa: E501
        """Updates view's permissions.  # noqa: E501

        Updates view's permissions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_permissions(body, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermissionsDTO body: Updated view's permissions. (required)
        :param int view_id: view's identifier (required)
        :return: PermissionsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_permissions_with_http_info(body, view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_permissions_with_http_info(body, view_id, **kwargs)  # noqa: E501
            return data

    def update_permissions_with_http_info(self, body, view_id, **kwargs):  # noqa: E501
        """Updates view's permissions.  # noqa: E501

        Updates view's permissions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_permissions_with_http_info(body, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PermissionsDTO body: Updated view's permissions. (required)
        :param int view_id: view's identifier (required)
        :return: PermissionsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'view_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_permissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_permissions`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `update_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}/permissions', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermissionsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_settings(self, body, view_id, **kwargs):  # noqa: E501
        """Updates view's settings.  # noqa: E501

        Updates view's settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings(body, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsDTO body: Updated view's settings. (required)
        :param int view_id: view's identifier (required)
        :return: SettingsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_settings_with_http_info(body, view_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_settings_with_http_info(body, view_id, **kwargs)  # noqa: E501
            return data

    def update_settings_with_http_info(self, body, view_id, **kwargs):  # noqa: E501
        """Updates view's settings.  # noqa: E501

        Updates view's settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_with_http_info(body, view_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsDTO body: Updated view's settings. (required)
        :param int view_id: view's identifier (required)
        :return: SettingsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'view_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_settings`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `update_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/browser/views/{viewId}/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
