# swagger-client
XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here: 

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 2.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
view_id = 789 # int | view's identifier (optional)
separator = 'separator_example' # str | csv field separator (optional)
additional_order = 'additional_order_example' # str |  (optional)

try:
    # Searches for data (ie. customer, task, etc) and returns it in a CSV form.
    api_response = api_instance.browse_csv(view_id=view_id, separator=separator, additional_order=additional_order)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->browse_csv: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
view_id = 789 # int | view's identifier (optional)
page = 56 # int |  (optional)
additional_order = 'additional_order_example' # str |  (optional)
use_deferred_columns = 'use_deferred_columns_example' # str |  (optional)
max_rows = 56 # int | overrides view's default rows limit, supported values 10 to 1000 (optional)

try:
    # Searches for data (ie. customer, task, etc) and returns it in a tabular form.
    api_response = api_instance.browse_json(view_id=view_id, page=page, additional_order=additional_order, use_deferred_columns=use_deferred_columns, max_rows=max_rows)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->browse_json: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
body = swagger_client.ViewDTO() # ViewDTO | Created view for given class.
class_name = 'class_name_example' # str | view's class name

try:
    # Creates view for given class.
    api_response = api_instance.create(body, class_name)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->create: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
view_id = 789 # int | view's internal identifier

try:
    # Removes a view.
    api_instance.delete(view_id)
except ApiException as e:
    print("Exception when calling BrowserApi->delete: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
view_id = 789 # int | view's identifier
column_name = 'column_name_example' # str | column's name

try:
    # Deletes a single column from view.
    api_response = api_instance.delete_column(view_id, column_name)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->delete_column: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
view_id = 789 # int | view's identifier

try:
    # Returns all view's information.
    api_response = api_instance.get(view_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->get: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
view_id = 789 # int | view's identifier
column_name = 'column_name_example' # str | column's name

try:
    # Returns column's specific settings.
    api_response = api_instance.get_column_settings(view_id, column_name)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->get_column_settings: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
view_id = 789 # int | view's identifier

try:
    # Returns columns defined in view.
    api_response = api_instance.get_columns(view_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->get_columns: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
class_name = 'class_name_example' # str | views' class name
place_name = 'place_name_example' # str | place name (denotes specific place in system with the table) (optional)

try:
    # Returns current view's detailed information, suitable for browser.
    api_response = api_instance.get_current_view_details(class_name, place_name=place_name)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->get_current_view_details: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
view_id = 789 # int | view's identifier

try:
    # Returns view's filter.
    api_response = api_instance.get_filter(view_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->get_filter: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
view_id = 789 # int | view's identifier

try:
    # Returns view's local settings (for current user).
    api_response = api_instance.get_local_settings(view_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->get_local_settings: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
view_id = 789 # int | view's identifier

try:
    # Returns view's order settings.
    api_response = api_instance.get_order(view_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->get_order: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
view_id = 789 # int | view's identifier

try:
    # Returns view's permissions.
    api_response = api_instance.get_permissions(view_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->get_permissions: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
view_id = 789 # int | view's identifier

try:
    # Returns view's settings.
    api_response = api_instance.get_settings(view_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->get_settings: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
class_name = 'class_name_example' # str | views' class name
view_id = 789 # int | 
place_name = 'place_name_example' # str | place name (denotes specific place in system with the table) (optional)

try:
    # Returns view's detailed information, suitable for browser.
    api_response = api_instance.get_view_details(class_name, view_id, place_name=place_name)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->get_view_details: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
class_name = 'class_name_example' # str | views' class name
place_name = 'place_name_example' # str | place name (denotes specific place in system with the table) (optional)

try:
    # Returns views' brief.
    api_response = api_instance.get_views_brief(class_name, place_name=place_name)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->get_views_brief: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
class_name = 'class_name_example' # str | views' class name
view_id = 789 # int | 
place_name__denotes_specific_place_in_system_with_the_table = 'place_name__denotes_specific_place_in_system_with_the_table_example' # str |  (optional)

try:
    # Selects given view as current and returns its detailed information, suitable for browser.
    api_response = api_instance.select_view_and_get_its_details(class_name, view_id, place_name__denotes_specific_place_in_system_with_the_table=place_name__denotes_specific_place_in_system_with_the_table)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->select_view_and_get_its_details: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
body = swagger_client.ViewDTO() # ViewDTO | Updated all view's information.
view_id = 789 # int | view's identifier

try:
    # Updates all view's information.
    api_response = api_instance.update(body, view_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->update: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
body = {
  "description" : "ref",
  "value" : "/home-api/assets/examples/browsers/views/updateColumnSettings.json#requestBody"
} # object | Updated column's specific settings.
view_id = 789 # int | view's identifier
column_name = 'column_name_example' # str | column's name

try:
    # Updates column's specific settings.
    api_response = api_instance.update_column_settings(body, view_id, column_name)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->update_column_settings: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
body = [swagger_client.ColumnDTO()] # list[ColumnDTO] | Updated columns in view.
view_id = 789 # int | view's identifier

try:
    # Updates columns in view.
    api_response = api_instance.update_columns(body, view_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->update_columns: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
body = [swagger_client.FilterPropertyDTO()] # list[FilterPropertyDTO] | Updated view's filter.
view_id = 789 # int | view's identifier

try:
    # Updates view's filter.
    api_response = api_instance.update_filter(body, view_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->update_filter: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
body = swagger_client.FilterPropertyDTO() # FilterPropertyDTO | Updated view's filter property.
view_id = 789 # int | view's identifier
filter_property = 'filter_property_example' # str | view's filter property name

try:
    # Updates view's filter property.
    api_response = api_instance.update_filter_property(body, view_id, filter_property)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->update_filter_property: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
body = swagger_client.LocalSettingsDTO() # LocalSettingsDTO | Updated view's local settings (for current user).
view_id = 789 # int | view's identifier

try:
    # Updates view's local settings (for current user).
    api_response = api_instance.update_local_settings(body, view_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->update_local_settings: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
body = swagger_client.OrderDTO() # OrderDTO | Updated view's order settings.
view_id = 789 # int | view's identifier

try:
    # Updates view's order settings.
    api_response = api_instance.update_order(body, view_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->update_order: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
body = swagger_client.PermissionsDTO() # PermissionsDTO | Updated view's permissions.
view_id = 789 # int | view's identifier

try:
    # Updates view's permissions.
    api_response = api_instance.update_permissions(body, view_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->update_permissions: %s\n" % e)

# Configure API key authorization: X-AUTH-ACCESS-TOKEN
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-ACCESS-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-ACCESS-TOKEN'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.BrowserApi(swagger_client.ApiClient(configuration))
body = swagger_client.SettingsDTO() # SettingsDTO | Updated view's settings.
view_id = 789 # int | view's identifier

try:
    # Updates view's settings.
    api_response = api_instance.update_settings(body, view_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrowserApi->update_settings: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://hornet-trunk.dev.xtrf.eu/home-api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BrowserApi* | [**browse_csv**](docs/BrowserApi.md#browse_csv) | **GET** /browser/csv | Searches for data (ie. customer, task, etc) and returns it in a CSV form.
*BrowserApi* | [**browse_json**](docs/BrowserApi.md#browse_json) | **GET** /browser | Searches for data (ie. customer, task, etc) and returns it in a tabular form.
*BrowserApi* | [**create**](docs/BrowserApi.md#create) | **POST** /browser/views/for/{className} | Creates view for given class.
*BrowserApi* | [**delete**](docs/BrowserApi.md#delete) | **DELETE** /browser/views/{viewId} | Removes a view.
*BrowserApi* | [**delete_column**](docs/BrowserApi.md#delete_column) | **DELETE** /browser/views/{viewId}/columns/{columnName} | Deletes a single column from view.
*BrowserApi* | [**get**](docs/BrowserApi.md#get) | **GET** /browser/views/{viewId} | Returns all view&#x27;s information.
*BrowserApi* | [**get_column_settings**](docs/BrowserApi.md#get_column_settings) | **GET** /browser/views/{viewId}/columns/{columnName}/settings | Returns column&#x27;s specific settings.
*BrowserApi* | [**get_columns**](docs/BrowserApi.md#get_columns) | **GET** /browser/views/{viewId}/columns | Returns columns defined in view.
*BrowserApi* | [**get_current_view_details**](docs/BrowserApi.md#get_current_view_details) | **GET** /browser/views/details/for/{className} | Returns current view&#x27;s detailed information, suitable for browser.
*BrowserApi* | [**get_filter**](docs/BrowserApi.md#get_filter) | **GET** /browser/views/{viewId}/filter | Returns view&#x27;s filter.
*BrowserApi* | [**get_local_settings**](docs/BrowserApi.md#get_local_settings) | **GET** /browser/views/{viewId}/settings/local | Returns view&#x27;s local settings (for current user).
*BrowserApi* | [**get_order**](docs/BrowserApi.md#get_order) | **GET** /browser/views/{viewId}/order | Returns view&#x27;s order settings.
*BrowserApi* | [**get_permissions**](docs/BrowserApi.md#get_permissions) | **GET** /browser/views/{viewId}/permissions | Returns view&#x27;s permissions.
*BrowserApi* | [**get_settings**](docs/BrowserApi.md#get_settings) | **GET** /browser/views/{viewId}/settings | Returns view&#x27;s settings.
*BrowserApi* | [**get_view_details**](docs/BrowserApi.md#get_view_details) | **GET** /browser/views/details/for/{className}/{viewId} | Returns view&#x27;s detailed information, suitable for browser.
*BrowserApi* | [**get_views_brief**](docs/BrowserApi.md#get_views_brief) | **GET** /browser/views/for/{className} | Returns views&#x27; brief.
*BrowserApi* | [**select_view_and_get_its_details**](docs/BrowserApi.md#select_view_and_get_its_details) | **POST** /browser/views/details/for/{className}/{viewId} | Selects given view as current and returns its detailed information, suitable for browser.
*BrowserApi* | [**update**](docs/BrowserApi.md#update) | **PUT** /browser/views/{viewId} | Updates all view&#x27;s information.
*BrowserApi* | [**update_column_settings**](docs/BrowserApi.md#update_column_settings) | **PUT** /browser/views/{viewId}/columns/{columnName}/settings | Updates column&#x27;s specific settings.
*BrowserApi* | [**update_columns**](docs/BrowserApi.md#update_columns) | **PUT** /browser/views/{viewId}/columns | Updates columns in view.
*BrowserApi* | [**update_filter**](docs/BrowserApi.md#update_filter) | **PUT** /browser/views/{viewId}/filter | Updates view&#x27;s filter.
*BrowserApi* | [**update_filter_property**](docs/BrowserApi.md#update_filter_property) | **PUT** /browser/views/{viewId}/filter/{filterProperty} | Updates view&#x27;s filter property.
*BrowserApi* | [**update_local_settings**](docs/BrowserApi.md#update_local_settings) | **PUT** /browser/views/{viewId}/settings/local | Updates view&#x27;s local settings (for current user).
*BrowserApi* | [**update_order**](docs/BrowserApi.md#update_order) | **PUT** /browser/views/{viewId}/order | Updates view&#x27;s order settings.
*BrowserApi* | [**update_permissions**](docs/BrowserApi.md#update_permissions) | **PUT** /browser/views/{viewId}/permissions | Updates view&#x27;s permissions.
*BrowserApi* | [**update_settings**](docs/BrowserApi.md#update_settings) | **PUT** /browser/views/{viewId}/settings | Updates view&#x27;s settings.
*ClientInvoicesApi* | [**create**](docs/ClientInvoicesApi.md#create) | **POST** /accounting/customers/invoices | Creates a new invoice.
*ClientInvoicesApi* | [**create_payment**](docs/ClientInvoicesApi.md#create_payment) | **POST** /accounting/customers/invoices/{invoiceId}/payments | Adds a new payment to the client invoice. The invoice payment status (Not Paid, Partially Paid, Fully Paid) is automatically recalculated.
*ClientInvoicesApi* | [**delete**](docs/ClientInvoicesApi.md#delete) | **DELETE** /accounting/customers/invoices/{invoiceId} | Removes a client invoice.
*ClientInvoicesApi* | [**delete_0**](docs/ClientInvoicesApi.md#delete_0) | **DELETE** /accounting/customers/payments/{paymentId} | Removes a customer payment.
*ClientInvoicesApi* | [**download_documents**](docs/ClientInvoicesApi.md#download_documents) | **POST** /accounting/customers/invoices/documents | Generates client invoices&#x27; documents.
*ClientInvoicesApi* | [**duplicate**](docs/ClientInvoicesApi.md#duplicate) | **POST** /accounting/customers/invoices/{invoiceId}/duplicate | Duplicate client invoice.
*ClientInvoicesApi* | [**duplicate_as_pro_forma**](docs/ClientInvoicesApi.md#duplicate_as_pro_forma) | **POST** /accounting/customers/invoices/{invoiceId}/duplicate/proForma | Duplicate client invoice as pro forma.
*ClientInvoicesApi* | [**get_all**](docs/ClientInvoicesApi.md#get_all) | **GET** /accounting/customers/invoices | Lists all client invoices in all statuses (including not ready and drafts) that have been updated since a specific date.
*ClientInvoicesApi* | [**get_all_ids**](docs/ClientInvoicesApi.md#get_all_ids) | **GET** /accounting/customers/invoices/ids | Returns client invoices&#x27; internal identifiers.
*ClientInvoicesApi* | [**get_by_id**](docs/ClientInvoicesApi.md#get_by_id) | **GET** /accounting/customers/invoices/{invoiceId} | Returns client invoice details.
*ClientInvoicesApi* | [**get_dates**](docs/ClientInvoicesApi.md#get_dates) | **GET** /accounting/customers/invoices/{invoiceId}/dates | Returns dates of a given client invoice.
*ClientInvoicesApi* | [**get_document**](docs/ClientInvoicesApi.md#get_document) | **GET** /accounting/customers/invoices/{invoiceId}/document | Generates client invoice document (PDF).
*ClientInvoicesApi* | [**get_payment_terms**](docs/ClientInvoicesApi.md#get_payment_terms) | **GET** /accounting/customers/invoices/{invoiceId}/paymentTerms | Returns payment terms of a given client invoice.
*ClientInvoicesApi* | [**get_payments**](docs/ClientInvoicesApi.md#get_payments) | **GET** /accounting/customers/invoices/{invoiceId}/payments | Returns all payments for the client invoice.
*ClientInvoicesApi* | [**send_reminder**](docs/ClientInvoicesApi.md#send_reminder) | **POST** /accounting/customers/invoices/{invoiceId}/sendReminder | Sends reminder.
*ClientInvoicesApi* | [**send_reminders**](docs/ClientInvoicesApi.md#send_reminders) | **POST** /accounting/customers/invoices/sendReminders | Sends reminders. Returns number of sent e-mails.
*ClientsApi* | [**create**](docs/ClientsApi.md#create) | **POST** /customers/persons | Creates a new person.
*ClientsApi* | [**create1**](docs/ClientsApi.md#create1) | **POST** /customers | Creates a new client.
*ClientsApi* | [**delete1**](docs/ClientsApi.md#delete1) | **DELETE** /customers/persons/{personId} | Removes a person.
*ClientsApi* | [**delete1_0**](docs/ClientsApi.md#delete1_0) | **DELETE** /customers/priceLists/{priceListId} | Removes a customer price list.
*ClientsApi* | [**delete2**](docs/ClientsApi.md#delete2) | **DELETE** /customers/{customerId} | Removes a client.
*ClientsApi* | [**generate_single_use_sign_in_token**](docs/ClientsApi.md#generate_single_use_sign_in_token) | **POST** /customers/persons/accessToken | Generates a single use sign-in token.
*ClientsApi* | [**get_address**](docs/ClientsApi.md#get_address) | **GET** /customers/{customerId}/address | Returns address of a given client.
*ClientsApi* | [**get_all_ids1**](docs/ClientsApi.md#get_all_ids1) | **GET** /customers/persons/ids | Returns persons&#x27; internal identifiers.
*ClientsApi* | [**get_all_ids2**](docs/ClientsApi.md#get_all_ids2) | **GET** /customers/ids | Returns clients&#x27; internal identifiers.
*ClientsApi* | [**get_all_names_with_ids**](docs/ClientsApi.md#get_all_names_with_ids) | **GET** /customers | Returns list of simple clients representations
*ClientsApi* | [**get_by_id1**](docs/ClientsApi.md#get_by_id1) | **GET** /customers/persons/{personId} | Returns person details.
*ClientsApi* | [**get_by_id2**](docs/ClientsApi.md#get_by_id2) | **GET** /customers/{customerId} | Returns client details.
*ClientsApi* | [**get_categories**](docs/ClientsApi.md#get_categories) | **GET** /customers/{customerId}/categories | Returns categories of a given client.
*ClientsApi* | [**get_contact**](docs/ClientsApi.md#get_contact) | **GET** /customers/persons/{personId}/contact | Returns contact of a given person.
*ClientsApi* | [**get_contact1**](docs/ClientsApi.md#get_contact1) | **GET** /customers/{customerId}/contact | Returns contact of a given client.
*ClientsApi* | [**get_correspondence_address**](docs/ClientsApi.md#get_correspondence_address) | **GET** /customers/{customerId}/correspondenceAddress | Returns correspondence address of a given client.
*ClientsApi* | [**get_custom_field**](docs/ClientsApi.md#get_custom_field) | **GET** /customers/{customerId}/customFields/{customFieldKey} | Returns custom field of a given client.
*ClientsApi* | [**get_custom_fields**](docs/ClientsApi.md#get_custom_fields) | **GET** /customers/persons/{personId}/customFields | Returns custom fields of a given person.
*ClientsApi* | [**get_custom_fields1**](docs/ClientsApi.md#get_custom_fields1) | **GET** /customers/{customerId}/customFields | Returns custom fields of a given client.
*ClientsApi* | [**get_industries**](docs/ClientsApi.md#get_industries) | **GET** /customers/{customerId}/industries | Returns industries of a given client.
*ClientsApi* | [**update**](docs/ClientsApi.md#update) | **PUT** /customers/persons/{personId} | Updates an existing person.
*ClientsApi* | [**update_0**](docs/ClientsApi.md#update_0) | **PUT** /customers/{customerId} | Updates an existing client.
*ClientsApi* | [**update_address**](docs/ClientsApi.md#update_address) | **PUT** /customers/{customerId}/address | Updates address of a given client.
*ClientsApi* | [**update_categories**](docs/ClientsApi.md#update_categories) | **PUT** /customers/{customerId}/categories | Updates categories of a given client.
*ClientsApi* | [**update_contact**](docs/ClientsApi.md#update_contact) | **PUT** /customers/persons/{personId}/contact | Updates contact of a given person.
*ClientsApi* | [**update_contact_0**](docs/ClientsApi.md#update_contact_0) | **PUT** /customers/{customerId}/contact | Updates contact of a given client.
*ClientsApi* | [**update_correspondence_address**](docs/ClientsApi.md#update_correspondence_address) | **PUT** /customers/{customerId}/correspondenceAddress | Updates correspondence address of a given client.
*ClientsApi* | [**update_custom_field**](docs/ClientsApi.md#update_custom_field) | **PUT** /customers/{customerId}/customFields/{customFieldKey} | Updates given custom field of a given client.
*ClientsApi* | [**update_custom_fields**](docs/ClientsApi.md#update_custom_fields) | **PUT** /customers/persons/{personId}/customFields | Updates custom fields of a given person.
*ClientsApi* | [**update_custom_fields_0**](docs/ClientsApi.md#update_custom_fields_0) | **PUT** /customers/{customerId}/customFields | Updates custom fields of a given client.
*ClientsApi* | [**update_industries**](docs/ClientsApi.md#update_industries) | **PUT** /customers/{customerId}/industries | Updates industries of a given client.
*DictionariesApi* | [**get_active**](docs/DictionariesApi.md#get_active) | **GET** /dictionaries/active | Returns active dictionary entities for all types.
*DictionariesApi* | [**get_active_by_type**](docs/DictionariesApi.md#get_active_by_type) | **GET** /dictionaries/{type}/active | Returns active values from a given dictionary.
*DictionariesApi* | [**get_all1**](docs/DictionariesApi.md#get_all1) | **GET** /dictionaries/all | Returns dictionary entities for all types. Both active and not active ones.
*DictionariesApi* | [**get_all3**](docs/DictionariesApi.md#get_all3) | **GET** /services/all | Returns services list
*DictionariesApi* | [**get_all_active**](docs/DictionariesApi.md#get_all_active) | **GET** /services/active | Returns active services list
*DictionariesApi* | [**get_all_by_type**](docs/DictionariesApi.md#get_all_by_type) | **GET** /dictionaries/{type}/all | Returns all values (both active and not active) from a given dictionary.
*DictionariesApi* | [**get_by_type_and_id**](docs/DictionariesApi.md#get_by_type_and_id) | **GET** /dictionaries/{type}/{id} | Returns specific value from a given dictionary.
*FilesApi* | [**upload_file**](docs/FilesApi.md#upload_file) | **POST** /files | Uploads a temporary file (ie. for XML import). Returns token which can be used in other API calls.
*JobsSmartV2Api* | [**add_files**](docs/JobsSmartV2Api.md#add_files) | **PUT** /v2/jobs/{jobId}/files/delivered/add | Adds files to the project as delivered in the job.
*JobsSmartV2Api* | [**assign_vendor**](docs/JobsSmartV2Api.md#assign_vendor) | **PUT** /v2/jobs/{jobId}/vendor | Assigns vendor to a job in a project.
*JobsSmartV2Api* | [**change_status**](docs/JobsSmartV2Api.md#change_status) | **PUT** /v2/jobs/{jobId}/status | Changes job status if possible (400 Bad Request is returned otherwise).
*JobsSmartV2Api* | [**get_delivered_files**](docs/JobsSmartV2Api.md#get_delivered_files) | **GET** /v2/jobs/{jobId}/files/delivered | Returns list of files delivered in the job.
*JobsSmartV2Api* | [**get_file_by_id**](docs/JobsSmartV2Api.md#get_file_by_id) | **GET** /v2/jobs/{jobId} | Returns details for a job.
*JobsSmartV2Api* | [**get_shared_reference_files**](docs/JobsSmartV2Api.md#get_shared_reference_files) | **GET** /v2/jobs/{jobId}/files/sharedReferenceFiles | Returns list of files shared with the job as Reference Files.
*JobsSmartV2Api* | [**get_shared_work_files**](docs/JobsSmartV2Api.md#get_shared_work_files) | **GET** /v2/jobs/{jobId}/files/sharedWorkFiles | Returns list of files shared with the job as Work Files.
*JobsSmartV2Api* | [**share_as_reference_files**](docs/JobsSmartV2Api.md#share_as_reference_files) | **PUT** /v2/jobs/{jobId}/files/sharedReferenceFiles/share | Shares selected files as Reference Files with a job in a project.
*JobsSmartV2Api* | [**share_as_work_files**](docs/JobsSmartV2Api.md#share_as_work_files) | **PUT** /v2/jobs/{jobId}/files/sharedWorkFiles/share | Shares selected files as Work Files with a job in a project.
*JobsSmartV2Api* | [**stop_sharing**](docs/JobsSmartV2Api.md#stop_sharing) | **PUT** /v2/jobs/{jobId}/files/stopSharing | Stops sharing selected files with a job in a project.
*JobsSmartV2Api* | [**update_instructions**](docs/JobsSmartV2Api.md#update_instructions) | **PUT** /v2/jobs/{jobId}/instructions | Updates instructions for a job.
*JobsSmartV2Api* | [**upload_file1**](docs/JobsSmartV2Api.md#upload_file1) | **POST** /v2/jobs/{jobId}/files/delivered/upload | Uploads file to the project as a file delivered in the job.
*LicenseApi* | [**get_license**](docs/LicenseApi.md#get_license) | **GET** /license | Returns license content.
*LicenseApi* | [**refresh**](docs/LicenseApi.md#refresh) | **POST** /license/refresh | Refreshes license content.
*MacrosApi* | [**run**](docs/MacrosApi.md#run) | **POST** /macros/{macroId}/run | Executes a macro.
*ProjectsClassicApi* | [**create1**](docs/ProjectsClassicApi.md#create1) | **POST** /projects | Creates a new Classic Project.
*ProjectsClassicApi* | [**create_language_combination**](docs/ProjectsClassicApi.md#create_language_combination) | **POST** /projects/{projectId}/languageCombinations | Creates a new language combination for a given project without creating a task.
*ProjectsClassicApi* | [**create_task**](docs/ProjectsClassicApi.md#create_task) | **POST** /projects/{projectId}/tasks | Creates a new task for a given project.
*ProjectsClassicApi* | [**delete5**](docs/ProjectsClassicApi.md#delete5) | **DELETE** /projects/{projectId} | Removes a project.
*ProjectsClassicApi* | [**get_all_ids6**](docs/ProjectsClassicApi.md#get_all_ids6) | **GET** /projects/ids | Returns projects&#x27; internal identifiers.
*ProjectsClassicApi* | [**get_by_id7**](docs/ProjectsClassicApi.md#get_by_id7) | **GET** /projects/{projectId} | Returns project details.
*ProjectsClassicApi* | [**get_contacts**](docs/ProjectsClassicApi.md#get_contacts) | **GET** /projects/{projectId}/contacts | Returns contacts of a given project.
*ProjectsClassicApi* | [**get_custom_fields5**](docs/ProjectsClassicApi.md#get_custom_fields5) | **GET** /projects/{projectId}/customFields | Returns custom fields of a given project.
*ProjectsClassicApi* | [**get_dates1**](docs/ProjectsClassicApi.md#get_dates1) | **GET** /projects/{projectId}/dates | Returns dates of a given project.
*ProjectsClassicApi* | [**get_finance**](docs/ProjectsClassicApi.md#get_finance) | **GET** /projects/{projectId}/finance | Returns finance of a given project.
*ProjectsClassicApi* | [**get_instructions**](docs/ProjectsClassicApi.md#get_instructions) | **GET** /projects/{projectId}/instructions | Returns instructions of a given project.
*ProjectsClassicApi* | [**update_contacts**](docs/ProjectsClassicApi.md#update_contacts) | **PUT** /projects/{projectId}/contacts | Updates contacts of a given project.
*ProjectsClassicApi* | [**update_custom_fields**](docs/ProjectsClassicApi.md#update_custom_fields) | **PUT** /projects/{projectId}/customFields | Updates custom fields of a given project.
*ProjectsClassicApi* | [**update_dates**](docs/ProjectsClassicApi.md#update_dates) | **PUT** /projects/{projectId}/dates | Updates dates of a given project.
*ProjectsClassicApi* | [**update_instructions**](docs/ProjectsClassicApi.md#update_instructions) | **PUT** /projects/{projectId}/instructions | Updates instructions of a given project.
*ProjectsSmartV2Api* | [**add_file_links**](docs/ProjectsSmartV2Api.md#add_file_links) | **POST** /v2/projects/{projectId}/files/addLink | Adds file links to the project as added by PM.
*ProjectsSmartV2Api* | [**add_files1**](docs/ProjectsSmartV2Api.md#add_files1) | **PUT** /v2/projects/{projectId}/files/add | Adds files to the project as added by PM.
*ProjectsSmartV2Api* | [**archive**](docs/ProjectsSmartV2Api.md#archive) | **POST** /v2/projects/files/archive | Prepares a ZIP archive that contains the specified files.
*ProjectsSmartV2Api* | [**change_status1**](docs/ProjectsSmartV2Api.md#change_status1) | **PUT** /v2/projects/{projectId}/status | Changes project status if possible (400 Bad Request is returned otherwise).
*ProjectsSmartV2Api* | [**create2**](docs/ProjectsSmartV2Api.md#create2) | **POST** /v2/projects | Creates a new Smart Project.
*ProjectsSmartV2Api* | [**create_payable**](docs/ProjectsSmartV2Api.md#create_payable) | **POST** /v2/projects/{projectId}/finance/payables | Adds a payable to a project.
*ProjectsSmartV2Api* | [**create_receivable**](docs/ProjectsSmartV2Api.md#create_receivable) | **POST** /v2/projects/{projectId}/finance/receivables | Adds a receivable to a project.
*ProjectsSmartV2Api* | [**delete_payable**](docs/ProjectsSmartV2Api.md#delete_payable) | **DELETE** /v2/projects/{projectId}/finance/payables/{payableId} | Deletes a payable.
*ProjectsSmartV2Api* | [**delete_receivable**](docs/ProjectsSmartV2Api.md#delete_receivable) | **DELETE** /v2/projects/{projectId}/finance/receivables/{receivableId} | Deletes a receivable.
*ProjectsSmartV2Api* | [**get_by_id9**](docs/ProjectsSmartV2Api.md#get_by_id9) | **GET** /v2/projects/{projectId} | Returns project details.
*ProjectsSmartV2Api* | [**get_cat_tool_project_info**](docs/ProjectsSmartV2Api.md#get_cat_tool_project_info) | **GET** /v2/projects/{projectId}/catToolProject | Returns if cat tool project is created or queued.
*ProjectsSmartV2Api* | [**get_contacts2**](docs/ProjectsSmartV2Api.md#get_contacts2) | **GET** /v2/projects/{projectId}/clientContacts | Returns Client Contacts information for a project.
*ProjectsSmartV2Api* | [**get_custom_fields8**](docs/ProjectsSmartV2Api.md#get_custom_fields8) | **GET** /v2/projects/{projectId}/customFields | Returns a list of custom field keys and values for a project.
*ProjectsSmartV2Api* | [**get_deliverable_files**](docs/ProjectsSmartV2Api.md#get_deliverable_files) | **GET** /v2/projects/{projectId}/files/deliverable | Returns list of files in a project, that are ready to be delivered to client.
*ProjectsSmartV2Api* | [**get_file_by_id1**](docs/ProjectsSmartV2Api.md#get_file_by_id1) | **GET** /v2/projects/files/{fileId} | Returns details of a file.
*ProjectsSmartV2Api* | [**get_file_content_by_id**](docs/ProjectsSmartV2Api.md#get_file_content_by_id) | **GET** /v2/projects/files/{fileId}/download/{fileName} | Downloads a file content.
*ProjectsSmartV2Api* | [**get_files**](docs/ProjectsSmartV2Api.md#get_files) | **GET** /v2/projects/{projectId}/files | Returns list of files in a project.
*ProjectsSmartV2Api* | [**get_finance2**](docs/ProjectsSmartV2Api.md#get_finance2) | **GET** /v2/projects/{projectId}/finance | Returns finance information for a project.
*ProjectsSmartV2Api* | [**get_jobs**](docs/ProjectsSmartV2Api.md#get_jobs) | **GET** /v2/projects/{projectId}/jobs | Returns list of jobs in a project.
*ProjectsSmartV2Api* | [**update_client_deadline**](docs/ProjectsSmartV2Api.md#update_client_deadline) | **PUT** /v2/projects/{projectId}/clientDeadline | Updates Client Deadline for a project.
*ProjectsSmartV2Api* | [**update_client_notes**](docs/ProjectsSmartV2Api.md#update_client_notes) | **PUT** /v2/projects/{projectId}/clientNotes | Updates Client Notes for a project.
*ProjectsSmartV2Api* | [**update_client_reference_number**](docs/ProjectsSmartV2Api.md#update_client_reference_number) | **PUT** /v2/projects/{projectId}/clientReferenceNumber | Updates Client Reference Number for a project.
*ProjectsSmartV2Api* | [**update_contacts**](docs/ProjectsSmartV2Api.md#update_contacts) | **PUT** /v2/projects/{projectId}/clientContacts | Updates Client Contacts for a project.
*ProjectsSmartV2Api* | [**update_custom_field**](docs/ProjectsSmartV2Api.md#update_custom_field) | **PUT** /v2/projects/{projectId}/customFields/{key} | Updates a custom field with a specified key in a project
*ProjectsSmartV2Api* | [**update_internal_notes**](docs/ProjectsSmartV2Api.md#update_internal_notes) | **PUT** /v2/projects/{projectId}/internalNotes | Updates Internal Notes for a project.
*ProjectsSmartV2Api* | [**update_ordered_on**](docs/ProjectsSmartV2Api.md#update_ordered_on) | **PUT** /v2/projects/{projectId}/orderDate | Updates Order Date for a project.
*ProjectsSmartV2Api* | [**update_payable**](docs/ProjectsSmartV2Api.md#update_payable) | **PUT** /v2/projects/{projectId}/finance/payables/{payableId} | Updates a payable.
*ProjectsSmartV2Api* | [**update_receivable**](docs/ProjectsSmartV2Api.md#update_receivable) | **PUT** /v2/projects/{projectId}/finance/receivables/{receivableId} | Updates a receivable.
*ProjectsSmartV2Api* | [**update_source_language**](docs/ProjectsSmartV2Api.md#update_source_language) | **PUT** /v2/projects/{projectId}/sourceLanguage | Updates source language for a project.
*ProjectsSmartV2Api* | [**update_specialization**](docs/ProjectsSmartV2Api.md#update_specialization) | **PUT** /v2/projects/{projectId}/specialization | Updates specialization for a project.
*ProjectsSmartV2Api* | [**update_target_languages**](docs/ProjectsSmartV2Api.md#update_target_languages) | **PUT** /v2/projects/{projectId}/targetLanguages | Updates target languages for a project.
*ProjectsSmartV2Api* | [**update_vendor_instructions**](docs/ProjectsSmartV2Api.md#update_vendor_instructions) | **PUT** /v2/projects/{projectId}/vendorInstructions | Updates instructions for all vendors performing the jobs in a project.
*ProjectsSmartV2Api* | [**update_volume**](docs/ProjectsSmartV2Api.md#update_volume) | **PUT** /v2/projects/{projectId}/volume | Updates volume for a project.
*ProjectsSmartV2Api* | [**upload_file2**](docs/ProjectsSmartV2Api.md#upload_file2) | **POST** /v2/projects/{projectId}/files/upload | Uploads file to the project as a file uploaded by PM.
*QuotesClassicApi* | [**create_language_combination1**](docs/QuotesClassicApi.md#create_language_combination1) | **POST** /quotes/{quoteId}/languageCombinations | Creates a new language combination for a given quote without creating a task.
*QuotesClassicApi* | [**create_task1**](docs/QuotesClassicApi.md#create_task1) | **POST** /quotes/{quoteId}/tasks | Creates a new task for a given quote.
*QuotesClassicApi* | [**delete5**](docs/QuotesClassicApi.md#delete5) | **DELETE** /quotes/{quoteId} | Removes a quote.
*QuotesClassicApi* | [**get_all_ids7**](docs/QuotesClassicApi.md#get_all_ids7) | **GET** /quotes/ids | Returns quotes&#x27; internal identifiers.
*QuotesClassicApi* | [**get_by_id8**](docs/QuotesClassicApi.md#get_by_id8) | **GET** /quotes/{quoteId} | Returns quote details.
*QuotesClassicApi* | [**get_custom_fields6**](docs/QuotesClassicApi.md#get_custom_fields6) | **GET** /quotes/{quoteId}/customFields | Returns custom fields of a given quote.
*QuotesClassicApi* | [**get_dates2**](docs/QuotesClassicApi.md#get_dates2) | **GET** /quotes/{quoteId}/dates | Returns dates of a given quote.
*QuotesClassicApi* | [**get_finance1**](docs/QuotesClassicApi.md#get_finance1) | **GET** /quotes/{quoteId}/finance | Returns finance of a given quote.
*QuotesClassicApi* | [**send1**](docs/QuotesClassicApi.md#send1) | **POST** /quotes/{quoteId}/confirmation/send | Sends a quote for customer confirmation.
*QuotesClassicApi* | [**start**](docs/QuotesClassicApi.md#start) | **POST** /quotes/{quoteId}/start | Starts a quote.
*QuotesClassicApi* | [**update_custom_fields**](docs/QuotesClassicApi.md#update_custom_fields) | **PUT** /quotes/{quoteId}/customFields | Updates custom fields of a given quote.
*QuotesSmartV2Api* | [**add_files2**](docs/QuotesSmartV2Api.md#add_files2) | **PUT** /v2/quotes/{quoteId}/files/add | Adds files to the quote as added by PM.
*QuotesSmartV2Api* | [**archive1**](docs/QuotesSmartV2Api.md#archive1) | **POST** /v2/quotes/files/archive | Prepares a ZIP archive that contains the specified files.
*QuotesSmartV2Api* | [**change_status2**](docs/QuotesSmartV2Api.md#change_status2) | **PUT** /v2/quotes/{quoteId}/status | Changes quote status if possible (400 Bad Request is returned otherwise).
*QuotesSmartV2Api* | [**create3**](docs/QuotesSmartV2Api.md#create3) | **POST** /v2/quotes | Creates a new Smart Quote.
*QuotesSmartV2Api* | [**create_payable1**](docs/QuotesSmartV2Api.md#create_payable1) | **POST** /v2/quotes/{quoteId}/finance/payables | Adds a payable to a quote.
*QuotesSmartV2Api* | [**create_receivable1**](docs/QuotesSmartV2Api.md#create_receivable1) | **POST** /v2/quotes/{quoteId}/finance/receivables | Adds a receivable to a quote.
*QuotesSmartV2Api* | [**delete_payable**](docs/QuotesSmartV2Api.md#delete_payable) | **DELETE** /v2/quotes/{quoteId}/finance/payables/{payableId} | Deletes a payable.
*QuotesSmartV2Api* | [**delete_receivable**](docs/QuotesSmartV2Api.md#delete_receivable) | **DELETE** /v2/quotes/{quoteId}/finance/receivables/{receivableId} | Deletes a receivable.
*QuotesSmartV2Api* | [**get_by_id10**](docs/QuotesSmartV2Api.md#get_by_id10) | **GET** /v2/quotes/{quoteId} | Returns quote details.
*QuotesSmartV2Api* | [**get_contacts3**](docs/QuotesSmartV2Api.md#get_contacts3) | **GET** /v2/quotes/{quoteId}/clientContacts | Returns Client Contacts information for a quote.
*QuotesSmartV2Api* | [**get_custom_fields9**](docs/QuotesSmartV2Api.md#get_custom_fields9) | **GET** /v2/quotes/{quoteId}/customFields | Returns a list of custom field keys and values for a project.
*QuotesSmartV2Api* | [**get_file_by_id2**](docs/QuotesSmartV2Api.md#get_file_by_id2) | **GET** /v2/quotes/files/{fileId} | Returns details of a file.
*QuotesSmartV2Api* | [**get_file_content_by_id1**](docs/QuotesSmartV2Api.md#get_file_content_by_id1) | **GET** /v2/quotes/files/{fileId}/download/{fileName} | Downloads a file content.
*QuotesSmartV2Api* | [**get_files1**](docs/QuotesSmartV2Api.md#get_files1) | **GET** /v2/quotes/{quoteId}/files | Returns list of files in a quote.
*QuotesSmartV2Api* | [**get_finance3**](docs/QuotesSmartV2Api.md#get_finance3) | **GET** /v2/quotes/{quoteId}/finance | Returns finance information for a quote.
*QuotesSmartV2Api* | [**get_jobs1**](docs/QuotesSmartV2Api.md#get_jobs1) | **GET** /v2/quotes/{quoteId}/jobs | Returns list of jobs in a quote.
*QuotesSmartV2Api* | [**update_business_days**](docs/QuotesSmartV2Api.md#update_business_days) | **PUT** /v2/quotes/{quoteId}/businessDays | Updates Business Days for a quote.
*QuotesSmartV2Api* | [**update_client_notes1**](docs/QuotesSmartV2Api.md#update_client_notes1) | **PUT** /v2/quotes/{quoteId}/clientNotes | Updates Client Notes for a quote.
*QuotesSmartV2Api* | [**update_client_reference_number1**](docs/QuotesSmartV2Api.md#update_client_reference_number1) | **PUT** /v2/quotes/{quoteId}/clientReferenceNumber | Updates Client Reference Number for a quote.
*QuotesSmartV2Api* | [**update_contacts**](docs/QuotesSmartV2Api.md#update_contacts) | **PUT** /v2/quotes/{quoteId}/clientContacts | Updates Client Contacts for a quote.
*QuotesSmartV2Api* | [**update_custom_field1**](docs/QuotesSmartV2Api.md#update_custom_field1) | **PUT** /v2/quotes/{quoteId}/customFields/{key} | Updates a custom field with a specified key in a quote.
*QuotesSmartV2Api* | [**update_expected_delivery_date**](docs/QuotesSmartV2Api.md#update_expected_delivery_date) | **PUT** /v2/quotes/{quoteId}/expectedDeliveryDate | Updates Expected Delivery Date for a quote.
*QuotesSmartV2Api* | [**update_internal_notes1**](docs/QuotesSmartV2Api.md#update_internal_notes1) | **PUT** /v2/quotes/{quoteId}/internalNotes | Updates Internal Notes for a quote.
*QuotesSmartV2Api* | [**update_payable1**](docs/QuotesSmartV2Api.md#update_payable1) | **PUT** /v2/quotes/{quoteId}/finance/payables/{payableId} | Updates a payable.
*QuotesSmartV2Api* | [**update_quote_expiry**](docs/QuotesSmartV2Api.md#update_quote_expiry) | **PUT** /v2/quotes/{quoteId}/quoteExpiry | Updates Quote Expiry Date for a quote.
*QuotesSmartV2Api* | [**update_receivable1**](docs/QuotesSmartV2Api.md#update_receivable1) | **PUT** /v2/quotes/{quoteId}/finance/receivables/{receivableId} | Updates a receivable.
*QuotesSmartV2Api* | [**update_source_language1**](docs/QuotesSmartV2Api.md#update_source_language1) | **PUT** /v2/quotes/{quoteId}/sourceLanguage | Updates source language for a quote.
*QuotesSmartV2Api* | [**update_specialization1**](docs/QuotesSmartV2Api.md#update_specialization1) | **PUT** /v2/quotes/{quoteId}/specialization | Updates specialization for a quote.
*QuotesSmartV2Api* | [**update_target_languages1**](docs/QuotesSmartV2Api.md#update_target_languages1) | **PUT** /v2/quotes/{quoteId}/targetLanguages | Updates target languages for a quote.
*QuotesSmartV2Api* | [**update_vendor_instructions1**](docs/QuotesSmartV2Api.md#update_vendor_instructions1) | **PUT** /v2/quotes/{quoteId}/vendorInstructions | Updates instructions for all vendors performing the jobs in a quote.
*QuotesSmartV2Api* | [**update_volume1**](docs/QuotesSmartV2Api.md#update_volume1) | **PUT** /v2/quotes/{quoteId}/volume | Updates volume for a quote.
*QuotesSmartV2Api* | [**upload_file3**](docs/QuotesSmartV2Api.md#upload_file3) | **POST** /v2/quotes/{quoteId}/files/upload | Uploads file to the quote as a file uploaded by PM.
*ReportsApi* | [**delete4**](docs/ReportsApi.md#delete4) | **DELETE** /reports/{reportId} | Removes a report.
*ReportsApi* | [**duplicate1**](docs/ReportsApi.md#duplicate1) | **POST** /reports/{reportId}/duplicate | Duplicates a report.
*ReportsApi* | [**export_to_xml**](docs/ReportsApi.md#export_to_xml) | **POST** /reports/export/xml | Exports reports definition to XML.
*ReportsApi* | [**generate_csv**](docs/ReportsApi.md#generate_csv) | **GET** /reports/{reportId}/result/csv | Generates CSV content for a report.
*ReportsApi* | [**generate_printer_friendly**](docs/ReportsApi.md#generate_printer_friendly) | **GET** /reports/{reportId}/result/printerFriendly | Generates printer friendly content for a report.
*ReportsApi* | [**import_from_xml**](docs/ReportsApi.md#import_from_xml) | **POST** /reports/import/xml | Imports reports definition from XML.
*ReportsApi* | [**set_preferred**](docs/ReportsApi.md#set_preferred) | **PUT** /reports/{reportId}/preferred | Marks report as preferred or not.
*SubscriptionApi* | [**are_hooks_supported**](docs/SubscriptionApi.md#are_hooks_supported) | **GET** /subscription/supports | This method can be used to determine if hooks are supported.
*SubscriptionApi* | [**get_all4**](docs/SubscriptionApi.md#get_all4) | **GET** /subscription | Returns all subscriptions
*SubscriptionApi* | [**subscribe**](docs/SubscriptionApi.md#subscribe) | **POST** /subscription | Subscribe to event
*SubscriptionApi* | [**unsubscribe**](docs/SubscriptionApi.md#unsubscribe) | **DELETE** /subscription/{subscriptionId} | Unsubscribe from event
*TasksClassicApi* | [**add_file**](docs/TasksClassicApi.md#add_file) | **POST** /tasks/{taskId}/files/input | Adds files to a given task.
*TasksClassicApi* | [**delete5**](docs/TasksClassicApi.md#delete5) | **DELETE** /tasks/{taskId} | Removes a task.
*TasksClassicApi* | [**get_contacts1**](docs/TasksClassicApi.md#get_contacts1) | **GET** /tasks/{taskId}/contacts | Returns contacts of a given task.
*TasksClassicApi* | [**get_custom_fields7**](docs/TasksClassicApi.md#get_custom_fields7) | **GET** /tasks/{taskId}/customFields | Returns custom fields of a given task.
*TasksClassicApi* | [**get_dates3**](docs/TasksClassicApi.md#get_dates3) | **GET** /tasks/{taskId}/dates | Returns dates of a given task.
*TasksClassicApi* | [**get_instructions1**](docs/TasksClassicApi.md#get_instructions1) | **GET** /tasks/{taskId}/instructions | Returns instructions of a given task.
*TasksClassicApi* | [**get_progress**](docs/TasksClassicApi.md#get_progress) | **GET** /tasks/{taskId}/progress | Returns progress of a given task.
*TasksClassicApi* | [**start1**](docs/TasksClassicApi.md#start1) | **POST** /tasks/{taskId}/start | Starts a task.
*TasksClassicApi* | [**update_client_task_po_number**](docs/TasksClassicApi.md#update_client_task_po_number) | **PUT** /tasks/{taskId}/clientTaskPONumber | Updates Client Task PO Number of a given task.
*TasksClassicApi* | [**update_contacts**](docs/TasksClassicApi.md#update_contacts) | **PUT** /tasks/{taskId}/contacts | Updates contacts of a given task.
*TasksClassicApi* | [**update_custom_fields**](docs/TasksClassicApi.md#update_custom_fields) | **PUT** /tasks/{taskId}/customFields | Updates custom fields of a given task.
*TasksClassicApi* | [**update_dates**](docs/TasksClassicApi.md#update_dates) | **PUT** /tasks/{taskId}/dates | Updates dates of a given task.
*TasksClassicApi* | [**update_instructions**](docs/TasksClassicApi.md#update_instructions) | **PUT** /tasks/{taskId}/instructions | Updates instructions of a given task.
*TasksClassicApi* | [**update_name**](docs/TasksClassicApi.md#update_name) | **PUT** /tasks/{taskId}/name | Updates name of a given task.
*UsersApi* | [**change_password**](docs/UsersApi.md#change_password) | **PUT** /users/{userId}/password | Sets user&#x27;s password to a new value.
*UsersApi* | [**get_all_names_with_ids1**](docs/UsersApi.md#get_all_names_with_ids1) | **GET** /users | Returns list of simple users representations
*UsersApi* | [**get_by_id6**](docs/UsersApi.md#get_by_id6) | **GET** /users/{userId} | Returns user details.
*UsersApi* | [**get_custom_field1**](docs/UsersApi.md#get_custom_field1) | **GET** /users/{userId}/customFields/{customFieldKey} | Returns custom field of a given user.
*UsersApi* | [**get_custom_fields4**](docs/UsersApi.md#get_custom_fields4) | **GET** /users/{userId}/customFields | Returns custom fields of a given user.
*UsersApi* | [**get_me**](docs/UsersApi.md#get_me) | **GET** /users/me | Returns currently signed in user details.
*UsersApi* | [**update**](docs/UsersApi.md#update) | **PUT** /users/{userId} | Updates an existing user.
*UsersApi* | [**update_custom_field**](docs/UsersApi.md#update_custom_field) | **PUT** /users/{userId}/customFields/{customFieldKey} | Updates given custom field of a given user.
*UsersApi* | [**update_custom_fields**](docs/UsersApi.md#update_custom_fields) | **PUT** /users/{userId}/customFields | Updates custom fields of a given user.
*VendorInvoicesApi* | [**create1**](docs/VendorInvoicesApi.md#create1) | **POST** /accounting/providers/invoices | Creates a new invoice.
*VendorInvoicesApi* | [**create_payment**](docs/VendorInvoicesApi.md#create_payment) | **POST** /accounting/providers/invoices/{invoiceId}/payments | Creates a new payment on the vendor account and assigns the payment to the invoice.
*VendorInvoicesApi* | [**delete2**](docs/VendorInvoicesApi.md#delete2) | **DELETE** /accounting/providers/invoices/{invoiceId} | Removes a provider invoice.
*VendorInvoicesApi* | [**delete2_0**](docs/VendorInvoicesApi.md#delete2_0) | **DELETE** /accounting/providers/payments/{paymentId} | Removes a provider payment.
*VendorInvoicesApi* | [**get_all2**](docs/VendorInvoicesApi.md#get_all2) | **GET** /accounting/providers/invoices | Lists all vendor invoices in all statuses (including not ready and drafts) that have been updated since a specific date.
*VendorInvoicesApi* | [**get_all_ids3**](docs/VendorInvoicesApi.md#get_all_ids3) | **GET** /accounting/providers/invoices/ids | Returns vendor invoices&#x27; internal identifiers.
*VendorInvoicesApi* | [**get_by_id3**](docs/VendorInvoicesApi.md#get_by_id3) | **GET** /accounting/providers/invoices/{invoiceId} | Returns provider invoice details.
*VendorInvoicesApi* | [**get_document1**](docs/VendorInvoicesApi.md#get_document1) | **GET** /accounting/providers/invoices/{invoiceId}/document | Generates provider invoice document (PDF).
*VendorInvoicesApi* | [**get_payments1**](docs/VendorInvoicesApi.md#get_payments1) | **GET** /accounting/providers/invoices/{invoiceId}/payments | Returns all payments for the vendor invoice.
*VendorInvoicesApi* | [**send**](docs/VendorInvoicesApi.md#send) | **POST** /accounting/providers/invoices/{invoiceId}/send | Sends a provider invoice.
*VendorInvoicesApi* | [**set_status**](docs/VendorInvoicesApi.md#set_status) | **POST** /accounting/providers/invoices/{invoiceId}/status | Changes invoice status to given status.
*VendorsApi* | [**delete3**](docs/VendorsApi.md#delete3) | **DELETE** /providers/persons/{personId} | Removes a person.
*VendorsApi* | [**delete3_0**](docs/VendorsApi.md#delete3_0) | **DELETE** /providers/priceLists/{priceListId} | Removes a provider price list.
*VendorsApi* | [**delete4**](docs/VendorsApi.md#delete4) | **DELETE** /providers/{providerId} | Removes a provider.
*VendorsApi* | [**get_address1**](docs/VendorsApi.md#get_address1) | **GET** /providers/{providerId}/address | Returns address of a given provider.
*VendorsApi* | [**get_all_ids4**](docs/VendorsApi.md#get_all_ids4) | **GET** /providers/persons/ids | Returns persons&#x27; internal identifiers.
*VendorsApi* | [**get_all_ids5**](docs/VendorsApi.md#get_all_ids5) | **GET** /providers/ids | Returns providers&#x27; internal identifiers.
*VendorsApi* | [**get_by_id4**](docs/VendorsApi.md#get_by_id4) | **GET** /providers/persons/{personId} | Returns person details.
*VendorsApi* | [**get_by_id5**](docs/VendorsApi.md#get_by_id5) | **GET** /providers/{providerId} | Returns provider details.
*VendorsApi* | [**get_competencies**](docs/VendorsApi.md#get_competencies) | **GET** /providers/{providerId}/competencies | Returns competencies of a given provider.
*VendorsApi* | [**get_contact2**](docs/VendorsApi.md#get_contact2) | **GET** /providers/persons/{personId}/contact | Returns contact of a given person.
*VendorsApi* | [**get_contact3**](docs/VendorsApi.md#get_contact3) | **GET** /providers/{providerId}/contact | Returns contact of a given provider.
*VendorsApi* | [**get_correspondence_address1**](docs/VendorsApi.md#get_correspondence_address1) | **GET** /providers/{providerId}/correspondenceAddress | Returns correspondence address of a given provider.
*VendorsApi* | [**get_custom_fields2**](docs/VendorsApi.md#get_custom_fields2) | **GET** /providers/persons/{personId}/customFields | Returns custom fields of a given person.
*VendorsApi* | [**get_custom_fields3**](docs/VendorsApi.md#get_custom_fields3) | **GET** /providers/{providerId}/customFields | Returns custom fields of a given provider.
*VendorsApi* | [**send_invitations**](docs/VendorsApi.md#send_invitations) | **POST** /providers/persons/{personId}/notification/invitation | Sends invitation to Vendor Portal.
*VendorsApi* | [**send_invitations1**](docs/VendorsApi.md#send_invitations1) | **POST** /providers/{providerId}/notification/invitation | Sends invitations to Vendor Portal.

## Documentation For Models

 - [AccessDTO](docs/AccessDTO.md)
 - [AccessTokenDTO](docs/AccessTokenDTO.md)
 - [AccessTokenRequestDTO](docs/AccessTokenRequestDTO.md)
 - [ActionDTO](docs/ActionDTO.md)
 - [ActionStartedDTO](docs/ActionStartedDTO.md)
 - [ActiveSubscriptionDTO](docs/ActiveSubscriptionDTO.md)
 - [AddressDTO](docs/AddressDTO.md)
 - [BigDecimalDTO](docs/BigDecimalDTO.md)
 - [Body](docs/Body.md)
 - [BodyPart](docs/BodyPart.md)
 - [CATToolProjectDTO](docs/CATToolProjectDTO.md)
 - [CalculationUnitDTO](docs/CalculationUnitDTO.md)
 - [CategoriesDTO](docs/CategoriesDTO.md)
 - [CategoryDTO](docs/CategoryDTO.md)
 - [ChargeDTO](docs/ChargeDTO.md)
 - [ChargeLanguageCombinationDTO](docs/ChargeLanguageCombinationDTO.md)
 - [ColumnDTO](docs/ColumnDTO.md)
 - [CompetenciesDTO](docs/CompetenciesDTO.md)
 - [ContactDTO](docs/ContactDTO.md)
 - [ContactsDTO](docs/ContactsDTO.md)
 - [ContentDisposition](docs/ContentDisposition.md)
 - [CountryDTO](docs/CountryDTO.md)
 - [CurrencyDTO](docs/CurrencyDTO.md)
 - [CustomFieldDTO](docs/CustomFieldDTO.md)
 - [CustomFieldsDTO](docs/CustomFieldsDTO.md)
 - [CustomerAccountingDTO](docs/CustomerAccountingDTO.md)
 - [CustomerContactEmailsDTO](docs/CustomerContactEmailsDTO.md)
 - [CustomerDTO](docs/CustomerDTO.md)
 - [CustomerDetailsDTO](docs/CustomerDetailsDTO.md)
 - [CustomerInvoiceCreateDTO](docs/CustomerInvoiceCreateDTO.md)
 - [CustomerInvoiceCreateResultDTO](docs/CustomerInvoiceCreateResultDTO.md)
 - [CustomerInvoiceDTO](docs/CustomerInvoiceDTO.md)
 - [CustomerInvoiceDatesDTO](docs/CustomerInvoiceDatesDTO.md)
 - [CustomerPersonDTO](docs/CustomerPersonDTO.md)
 - [CustomerResponsiblePersonsDTO](docs/CustomerResponsiblePersonsDTO.md)
 - [CustomerTaxNoDTO](docs/CustomerTaxNoDTO.md)
 - [DictionaryEntity](docs/DictionaryEntity.md)
 - [DocumentsDTO](docs/DocumentsDTO.md)
 - [DownloadDocumentsRequestDTO](docs/DownloadDocumentsRequestDTO.md)
 - [EntityWithNameDTO](docs/EntityWithNameDTO.md)
 - [Event](docs/Event.md)
 - [EventsQueue](docs/EventsQueue.md)
 - [ExportRequestDTO](docs/ExportRequestDTO.md)
 - [FileCategorizationDto](docs/FileCategorizationDto.md)
 - [FileCategorizationsDto](docs/FileCategorizationsDto.md)
 - [FileDTO](docs/FileDTO.md)
 - [FileDto](docs/FileDto.md)
 - [FileLinkCategorizationDto](docs/FileLinkCategorizationDto.md)
 - [FileLinkCategorizationsDto](docs/FileLinkCategorizationsDto.md)
 - [FileShareStatusDto](docs/FileShareStatusDto.md)
 - [FilesArchiveDto](docs/FilesArchiveDto.md)
 - [FilesDto](docs/FilesDto.md)
 - [FilesShareStatusDto](docs/FilesShareStatusDto.md)
 - [FilterDTO](docs/FilterDTO.md)
 - [FilterPropertyDTO](docs/FilterPropertyDTO.md)
 - [FinanceDTO](docs/FinanceDTO.md)
 - [FormDataBodyPart](docs/FormDataBodyPart.md)
 - [FormDataContentDisposition](docs/FormDataContentDisposition.md)
 - [FormDataMultiPart](docs/FormDataMultiPart.md)
 - [FormDataMultiPartMediaType](docs/FormDataMultiPartMediaType.md)
 - [GetLicenseResult](docs/GetLicenseResult.md)
 - [Identifier](docs/Identifier.md)
 - [ImportRequestDTO](docs/ImportRequestDTO.md)
 - [ImportResultDTO](docs/ImportResultDTO.md)
 - [IndustriesDTO](docs/IndustriesDTO.md)
 - [IndustryDTO](docs/IndustryDTO.md)
 - [InstructionsDTO](docs/InstructionsDTO.md)
 - [InvitationStatisticsDTO](docs/InvitationStatisticsDTO.md)
 - [JobCommunicationDto](docs/JobCommunicationDto.md)
 - [JobDatesDto](docs/JobDatesDto.md)
 - [JobDocumentsDto](docs/JobDocumentsDto.md)
 - [JobDto](docs/JobDto.md)
 - [JobFilesDto](docs/JobFilesDto.md)
 - [JobLanguageCombinationDto](docs/JobLanguageCombinationDto.md)
 - [JobStatusDTO](docs/JobStatusDTO.md)
 - [JobTypeDTO](docs/JobTypeDTO.md)
 - [JsonNode](docs/JsonNode.md)
 - [LanguageCombinationDTO](docs/LanguageCombinationDTO.md)
 - [LanguageCombinationDto](docs/LanguageCombinationDto.md)
 - [LanguageDTO](docs/LanguageDTO.md)
 - [LanguageRelationDto](docs/LanguageRelationDto.md)
 - [LanguageSpecializationDTO](docs/LanguageSpecializationDTO.md)
 - [LastModificationDTO](docs/LastModificationDTO.md)
 - [LeadSourceDTO](docs/LeadSourceDTO.md)
 - [LocalSettingsDTO](docs/LocalSettingsDTO.md)
 - [LongDTO](docs/LongDTO.md)
 - [MacroRequestDTO](docs/MacroRequestDTO.md)
 - [ManyValuesPerTypeDTO](docs/ManyValuesPerTypeDTO.md)
 - [MessageBodyWorkers](docs/MessageBodyWorkers.md)
 - [MultiPart](docs/MultiPart.md)
 - [OrderDTO](docs/OrderDTO.md)
 - [Parameter](docs/Parameter.md)
 - [ParameterizedHeader](docs/ParameterizedHeader.md)
 - [PayableCreateDTO](docs/PayableCreateDTO.md)
 - [PayableDTO](docs/PayableDTO.md)
 - [PaymentDTO](docs/PaymentDTO.md)
 - [PaymentTermsDTO](docs/PaymentTermsDTO.md)
 - [PeopleDTO](docs/PeopleDTO.md)
 - [PermissionsDTO](docs/PermissionsDTO.md)
 - [PersonContactDTO](docs/PersonContactDTO.md)
 - [PersonContactEmailsDTO](docs/PersonContactEmailsDTO.md)
 - [PersonDepartmentDTO](docs/PersonDepartmentDTO.md)
 - [PersonPositionDTO](docs/PersonPositionDTO.md)
 - [PreferredRequestDTO](docs/PreferredRequestDTO.md)
 - [ProjectCreateDTO](docs/ProjectCreateDTO.md)
 - [ProjectDTO](docs/ProjectDTO.md)
 - [ProjectDatesDTO](docs/ProjectDatesDTO.md)
 - [ProjectFileAddedByDto](docs/ProjectFileAddedByDto.md)
 - [ProjectFileDto](docs/ProjectFileDto.md)
 - [ProjectLanguagesDTO](docs/ProjectLanguagesDTO.md)
 - [ProjectStatusDTO](docs/ProjectStatusDTO.md)
 - [ProviderDTO](docs/ProviderDTO.md)
 - [ProviderInvoiceCreateDTO](docs/ProviderInvoiceCreateDTO.md)
 - [ProviderInvoiceCreateResultDTO](docs/ProviderInvoiceCreateResultDTO.md)
 - [ProviderInvoiceDTO](docs/ProviderInvoiceDTO.md)
 - [ProviderInvoiceDatesDTO](docs/ProviderInvoiceDatesDTO.md)
 - [ProviderPersonDTO](docs/ProviderPersonDTO.md)
 - [ProvinceDTO](docs/ProvinceDTO.md)
 - [QuoteCreateDTO](docs/QuoteCreateDTO.md)
 - [QuoteDTO](docs/QuoteDTO.md)
 - [QuoteDatesDTO](docs/QuoteDatesDTO.md)
 - [ReceivableCreateDTO](docs/ReceivableCreateDTO.md)
 - [ReceivableDTO](docs/ReceivableDTO.md)
 - [RemoteCATToolReferencesDto](docs/RemoteCATToolReferencesDto.md)
 - [ReportResultDTO](docs/ReportResultDTO.md)
 - [ResponsiblePersonsDTO](docs/ResponsiblePersonsDTO.md)
 - [SendRemindersRequestDTO](docs/SendRemindersRequestDTO.md)
 - [SendRemindersResponseDTO](docs/SendRemindersResponseDTO.md)
 - [ServiceDTO](docs/ServiceDTO.md)
 - [SettingsDTO](docs/SettingsDTO.md)
 - [SmartContactsDTO](docs/SmartContactsDTO.md)
 - [SmartCustomFieldDTO](docs/SmartCustomFieldDTO.md)
 - [SourceLanguageDTO](docs/SourceLanguageDTO.md)
 - [SpecializationDTO](docs/SpecializationDTO.md)
 - [StatusRequestDTO](docs/StatusRequestDTO.md)
 - [StepTypeDto](docs/StepTypeDto.md)
 - [StepTypeSemanticsDto](docs/StepTypeSemanticsDto.md)
 - [StringDTO](docs/StringDTO.md)
 - [SubscriptionDTO](docs/SubscriptionDTO.md)
 - [TargetLanguagesDTO](docs/TargetLanguagesDTO.md)
 - [TaskCreateDTO](docs/TaskCreateDTO.md)
 - [TaskDTO](docs/TaskDTO.md)
 - [TaskFileDTO](docs/TaskFileDTO.md)
 - [TaskFinanceDTO](docs/TaskFinanceDTO.md)
 - [TaskProgressDTO](docs/TaskProgressDTO.md)
 - [TimeDTO](docs/TimeDTO.md)
 - [UploadedFileInfo](docs/UploadedFileInfo.md)
 - [UrlResultDTO](docs/UrlResultDTO.md)
 - [UserDTO](docs/UserDTO.md)
 - [VendorPriceProfileDTO](docs/VendorPriceProfileDTO.md)
 - [ViewBriefDTO](docs/ViewBriefDTO.md)
 - [ViewDTO](docs/ViewDTO.md)
 - [ViewDetailsDTO](docs/ViewDetailsDTO.md)
 - [ViewWithIdDTO](docs/ViewWithIdDTO.md)
 - [ViewsBriefDTO](docs/ViewsBriefDTO.md)
 - [VolumeDTO](docs/VolumeDTO.md)

## Documentation For Authorization


## X-AUTH-ACCESS-TOKEN

- **Type**: API key
- **API key parameter name**: X-AUTH-ACCESS-TOKEN
- **Location**: HTTP header


## Author


