import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

import cdk8s
import constructs


class Tenant(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.Tenant",
):
    '''
    :stability: experimental
    :schema: Tenant
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        spec: typing.Union["TenantSpec", typing.Dict[str, typing.Any]],
        metadata: typing.Optional[typing.Union[cdk8s.ApiObjectMetadata, typing.Dict[str, typing.Any]]] = None,
        scheduler: typing.Optional[typing.Union["TenantScheduler", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''(experimental) Defines a "Tenant" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param spec: 
        :param metadata: 
        :param scheduler: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(Tenant.__init__)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = TenantProps(spec=spec, metadata=metadata, scheduler=scheduler)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        spec: typing.Union["TenantSpec", typing.Dict[str, typing.Any]],
        metadata: typing.Optional[typing.Union[cdk8s.ApiObjectMetadata, typing.Dict[str, typing.Any]]] = None,
        scheduler: typing.Optional[typing.Union["TenantScheduler", typing.Dict[str, typing.Any]]] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "Tenant".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param spec: 
        :param metadata: 
        :param scheduler: 

        :stability: experimental
        '''
        props = TenantProps(spec=spec, metadata=metadata, scheduler=scheduler)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''(experimental) Renders the object to Kubernetes JSON.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "Tenant".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantProps",
    jsii_struct_bases=[],
    name_mapping={"spec": "spec", "metadata": "metadata", "scheduler": "scheduler"},
)
class TenantProps:
    def __init__(
        self,
        *,
        spec: typing.Union["TenantSpec", typing.Dict[str, typing.Any]],
        metadata: typing.Optional[typing.Union[cdk8s.ApiObjectMetadata, typing.Dict[str, typing.Any]]] = None,
        scheduler: typing.Optional[typing.Union["TenantScheduler", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param spec: 
        :param metadata: 
        :param scheduler: 

        :stability: experimental
        :schema: Tenant
        '''
        if isinstance(spec, dict):
            spec = TenantSpec(**spec)
        if isinstance(metadata, dict):
            metadata = cdk8s.ApiObjectMetadata(**metadata)
        if isinstance(scheduler, dict):
            scheduler = TenantScheduler(**scheduler)
        if __debug__:
            type_hints = typing.get_type_hints(TenantProps.__init__)
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument scheduler", value=scheduler, expected_type=type_hints["scheduler"])
        self._values: typing.Dict[str, typing.Any] = {
            "spec": spec,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if scheduler is not None:
            self._values["scheduler"] = scheduler

    @builtins.property
    def spec(self) -> "TenantSpec":
        '''
        :stability: experimental
        :schema: Tenant#spec
        '''
        result = self._values.get("spec")
        assert result is not None, "Required property 'spec' is missing"
        return typing.cast("TenantSpec", result)

    @builtins.property
    def metadata(self) -> typing.Optional[cdk8s.ApiObjectMetadata]:
        '''
        :stability: experimental
        :schema: Tenant#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[cdk8s.ApiObjectMetadata], result)

    @builtins.property
    def scheduler(self) -> typing.Optional["TenantScheduler"]:
        '''
        :stability: experimental
        :schema: Tenant#scheduler
        '''
        result = self._values.get("scheduler")
        return typing.cast(typing.Optional["TenantScheduler"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantScheduler",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class TenantScheduler:
    def __init__(self, *, name: builtins.str) -> None:
        '''
        :param name: 

        :stability: experimental
        :schema: TenantScheduler
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantScheduler.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantScheduler#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantScheduler(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpec",
    jsii_struct_bases=[],
    name_mapping={
        "zones": "zones",
        "cert_config": "certConfig",
        "configuration": "configuration",
        "creds_secret": "credsSecret",
        "env": "env",
        "expose_services": "exposeServices",
        "external_ca_cert_secret": "externalCaCertSecret",
        "external_cert_secret": "externalCertSecret",
        "external_client_cert_secret": "externalClientCertSecret",
        "image": "image",
        "image_pull_policy": "imagePullPolicy",
        "image_pull_secret": "imagePullSecret",
        "kes": "kes",
        "log": "log",
        "mount_path": "mountPath",
        "pod_management_policy": "podManagementPolicy",
        "priority_class_name": "priorityClassName",
        "prometheus": "prometheus",
        "request_auto_cert": "requestAutoCert",
        "s3": "s3",
        "security_context": "securityContext",
        "service_account_name": "serviceAccountName",
        "side_cars": "sideCars",
        "sub_path": "subPath",
        "users": "users",
    },
)
class TenantSpec:
    def __init__(
        self,
        *,
        zones: typing.Sequence[typing.Union["TenantSpecZones", typing.Dict[str, typing.Any]]],
        cert_config: typing.Optional[typing.Union["TenantSpecCertConfig", typing.Dict[str, typing.Any]]] = None,
        configuration: typing.Optional[typing.Union["TenantSpecConfiguration", typing.Dict[str, typing.Any]]] = None,
        creds_secret: typing.Optional[typing.Union["TenantSpecCredsSecret", typing.Dict[str, typing.Any]]] = None,
        env: typing.Optional[typing.Sequence[typing.Union["TenantSpecEnv", typing.Dict[str, typing.Any]]]] = None,
        expose_services: typing.Optional[typing.Union["TenantSpecExposeServices", typing.Dict[str, typing.Any]]] = None,
        external_ca_cert_secret: typing.Optional[typing.Sequence[typing.Union["TenantSpecExternalCaCertSecret", typing.Dict[str, typing.Any]]]] = None,
        external_cert_secret: typing.Optional[typing.Sequence[typing.Union["TenantSpecExternalCertSecret", typing.Dict[str, typing.Any]]]] = None,
        external_client_cert_secret: typing.Optional[typing.Union["TenantSpecExternalClientCertSecret", typing.Dict[str, typing.Any]]] = None,
        image: typing.Optional[builtins.str] = None,
        image_pull_policy: typing.Optional[builtins.str] = None,
        image_pull_secret: typing.Optional[typing.Union["TenantSpecImagePullSecret", typing.Dict[str, typing.Any]]] = None,
        kes: typing.Optional[typing.Union["TenantSpecKes", typing.Dict[str, typing.Any]]] = None,
        log: typing.Optional[typing.Union["TenantSpecLog", typing.Dict[str, typing.Any]]] = None,
        mount_path: typing.Optional[builtins.str] = None,
        pod_management_policy: typing.Optional[builtins.str] = None,
        priority_class_name: typing.Optional[builtins.str] = None,
        prometheus: typing.Optional[typing.Union["TenantSpecPrometheus", typing.Dict[str, typing.Any]]] = None,
        request_auto_cert: typing.Optional[builtins.bool] = None,
        s3: typing.Optional[typing.Union["TenantSpecS3", typing.Dict[str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union["TenantSpecSecurityContext", typing.Dict[str, typing.Any]]] = None,
        service_account_name: typing.Optional[builtins.str] = None,
        side_cars: typing.Optional[typing.Union["TenantSpecSideCars", typing.Dict[str, typing.Any]]] = None,
        sub_path: typing.Optional[builtins.str] = None,
        users: typing.Optional[typing.Sequence[typing.Union["TenantSpecUsers", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param zones: 
        :param cert_config: 
        :param configuration: 
        :param creds_secret: 
        :param env: 
        :param expose_services: 
        :param external_ca_cert_secret: 
        :param external_cert_secret: 
        :param external_client_cert_secret: 
        :param image: 
        :param image_pull_policy: 
        :param image_pull_secret: 
        :param kes: 
        :param log: 
        :param mount_path: 
        :param pod_management_policy: 
        :param priority_class_name: 
        :param prometheus: 
        :param request_auto_cert: 
        :param s3: 
        :param security_context: 
        :param service_account_name: 
        :param side_cars: 
        :param sub_path: 
        :param users: 

        :stability: experimental
        :schema: TenantSpec
        '''
        if isinstance(cert_config, dict):
            cert_config = TenantSpecCertConfig(**cert_config)
        if isinstance(configuration, dict):
            configuration = TenantSpecConfiguration(**configuration)
        if isinstance(creds_secret, dict):
            creds_secret = TenantSpecCredsSecret(**creds_secret)
        if isinstance(expose_services, dict):
            expose_services = TenantSpecExposeServices(**expose_services)
        if isinstance(external_client_cert_secret, dict):
            external_client_cert_secret = TenantSpecExternalClientCertSecret(**external_client_cert_secret)
        if isinstance(image_pull_secret, dict):
            image_pull_secret = TenantSpecImagePullSecret(**image_pull_secret)
        if isinstance(kes, dict):
            kes = TenantSpecKes(**kes)
        if isinstance(log, dict):
            log = TenantSpecLog(**log)
        if isinstance(prometheus, dict):
            prometheus = TenantSpecPrometheus(**prometheus)
        if isinstance(s3, dict):
            s3 = TenantSpecS3(**s3)
        if isinstance(security_context, dict):
            security_context = TenantSpecSecurityContext(**security_context)
        if isinstance(side_cars, dict):
            side_cars = TenantSpecSideCars(**side_cars)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpec.__init__)
            check_type(argname="argument zones", value=zones, expected_type=type_hints["zones"])
            check_type(argname="argument cert_config", value=cert_config, expected_type=type_hints["cert_config"])
            check_type(argname="argument configuration", value=configuration, expected_type=type_hints["configuration"])
            check_type(argname="argument creds_secret", value=creds_secret, expected_type=type_hints["creds_secret"])
            check_type(argname="argument env", value=env, expected_type=type_hints["env"])
            check_type(argname="argument expose_services", value=expose_services, expected_type=type_hints["expose_services"])
            check_type(argname="argument external_ca_cert_secret", value=external_ca_cert_secret, expected_type=type_hints["external_ca_cert_secret"])
            check_type(argname="argument external_cert_secret", value=external_cert_secret, expected_type=type_hints["external_cert_secret"])
            check_type(argname="argument external_client_cert_secret", value=external_client_cert_secret, expected_type=type_hints["external_client_cert_secret"])
            check_type(argname="argument image", value=image, expected_type=type_hints["image"])
            check_type(argname="argument image_pull_policy", value=image_pull_policy, expected_type=type_hints["image_pull_policy"])
            check_type(argname="argument image_pull_secret", value=image_pull_secret, expected_type=type_hints["image_pull_secret"])
            check_type(argname="argument kes", value=kes, expected_type=type_hints["kes"])
            check_type(argname="argument log", value=log, expected_type=type_hints["log"])
            check_type(argname="argument mount_path", value=mount_path, expected_type=type_hints["mount_path"])
            check_type(argname="argument pod_management_policy", value=pod_management_policy, expected_type=type_hints["pod_management_policy"])
            check_type(argname="argument priority_class_name", value=priority_class_name, expected_type=type_hints["priority_class_name"])
            check_type(argname="argument prometheus", value=prometheus, expected_type=type_hints["prometheus"])
            check_type(argname="argument request_auto_cert", value=request_auto_cert, expected_type=type_hints["request_auto_cert"])
            check_type(argname="argument s3", value=s3, expected_type=type_hints["s3"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account_name", value=service_account_name, expected_type=type_hints["service_account_name"])
            check_type(argname="argument side_cars", value=side_cars, expected_type=type_hints["side_cars"])
            check_type(argname="argument sub_path", value=sub_path, expected_type=type_hints["sub_path"])
            check_type(argname="argument users", value=users, expected_type=type_hints["users"])
        self._values: typing.Dict[str, typing.Any] = {
            "zones": zones,
        }
        if cert_config is not None:
            self._values["cert_config"] = cert_config
        if configuration is not None:
            self._values["configuration"] = configuration
        if creds_secret is not None:
            self._values["creds_secret"] = creds_secret
        if env is not None:
            self._values["env"] = env
        if expose_services is not None:
            self._values["expose_services"] = expose_services
        if external_ca_cert_secret is not None:
            self._values["external_ca_cert_secret"] = external_ca_cert_secret
        if external_cert_secret is not None:
            self._values["external_cert_secret"] = external_cert_secret
        if external_client_cert_secret is not None:
            self._values["external_client_cert_secret"] = external_client_cert_secret
        if image is not None:
            self._values["image"] = image
        if image_pull_policy is not None:
            self._values["image_pull_policy"] = image_pull_policy
        if image_pull_secret is not None:
            self._values["image_pull_secret"] = image_pull_secret
        if kes is not None:
            self._values["kes"] = kes
        if log is not None:
            self._values["log"] = log
        if mount_path is not None:
            self._values["mount_path"] = mount_path
        if pod_management_policy is not None:
            self._values["pod_management_policy"] = pod_management_policy
        if priority_class_name is not None:
            self._values["priority_class_name"] = priority_class_name
        if prometheus is not None:
            self._values["prometheus"] = prometheus
        if request_auto_cert is not None:
            self._values["request_auto_cert"] = request_auto_cert
        if s3 is not None:
            self._values["s3"] = s3
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account_name is not None:
            self._values["service_account_name"] = service_account_name
        if side_cars is not None:
            self._values["side_cars"] = side_cars
        if sub_path is not None:
            self._values["sub_path"] = sub_path
        if users is not None:
            self._values["users"] = users

    @builtins.property
    def zones(self) -> typing.List["TenantSpecZones"]:
        '''
        :stability: experimental
        :schema: TenantSpec#zones
        '''
        result = self._values.get("zones")
        assert result is not None, "Required property 'zones' is missing"
        return typing.cast(typing.List["TenantSpecZones"], result)

    @builtins.property
    def cert_config(self) -> typing.Optional["TenantSpecCertConfig"]:
        '''
        :stability: experimental
        :schema: TenantSpec#certConfig
        '''
        result = self._values.get("cert_config")
        return typing.cast(typing.Optional["TenantSpecCertConfig"], result)

    @builtins.property
    def configuration(self) -> typing.Optional["TenantSpecConfiguration"]:
        '''
        :stability: experimental
        :schema: TenantSpec#configuration
        '''
        result = self._values.get("configuration")
        return typing.cast(typing.Optional["TenantSpecConfiguration"], result)

    @builtins.property
    def creds_secret(self) -> typing.Optional["TenantSpecCredsSecret"]:
        '''
        :stability: experimental
        :schema: TenantSpec#credsSecret
        '''
        result = self._values.get("creds_secret")
        return typing.cast(typing.Optional["TenantSpecCredsSecret"], result)

    @builtins.property
    def env(self) -> typing.Optional[typing.List["TenantSpecEnv"]]:
        '''
        :stability: experimental
        :schema: TenantSpec#env
        '''
        result = self._values.get("env")
        return typing.cast(typing.Optional[typing.List["TenantSpecEnv"]], result)

    @builtins.property
    def expose_services(self) -> typing.Optional["TenantSpecExposeServices"]:
        '''
        :stability: experimental
        :schema: TenantSpec#exposeServices
        '''
        result = self._values.get("expose_services")
        return typing.cast(typing.Optional["TenantSpecExposeServices"], result)

    @builtins.property
    def external_ca_cert_secret(
        self,
    ) -> typing.Optional[typing.List["TenantSpecExternalCaCertSecret"]]:
        '''
        :stability: experimental
        :schema: TenantSpec#externalCaCertSecret
        '''
        result = self._values.get("external_ca_cert_secret")
        return typing.cast(typing.Optional[typing.List["TenantSpecExternalCaCertSecret"]], result)

    @builtins.property
    def external_cert_secret(
        self,
    ) -> typing.Optional[typing.List["TenantSpecExternalCertSecret"]]:
        '''
        :stability: experimental
        :schema: TenantSpec#externalCertSecret
        '''
        result = self._values.get("external_cert_secret")
        return typing.cast(typing.Optional[typing.List["TenantSpecExternalCertSecret"]], result)

    @builtins.property
    def external_client_cert_secret(
        self,
    ) -> typing.Optional["TenantSpecExternalClientCertSecret"]:
        '''
        :stability: experimental
        :schema: TenantSpec#externalClientCertSecret
        '''
        result = self._values.get("external_client_cert_secret")
        return typing.cast(typing.Optional["TenantSpecExternalClientCertSecret"], result)

    @builtins.property
    def image(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpec#image
        '''
        result = self._values.get("image")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def image_pull_policy(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpec#imagePullPolicy
        '''
        result = self._values.get("image_pull_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def image_pull_secret(self) -> typing.Optional["TenantSpecImagePullSecret"]:
        '''
        :stability: experimental
        :schema: TenantSpec#imagePullSecret
        '''
        result = self._values.get("image_pull_secret")
        return typing.cast(typing.Optional["TenantSpecImagePullSecret"], result)

    @builtins.property
    def kes(self) -> typing.Optional["TenantSpecKes"]:
        '''
        :stability: experimental
        :schema: TenantSpec#kes
        '''
        result = self._values.get("kes")
        return typing.cast(typing.Optional["TenantSpecKes"], result)

    @builtins.property
    def log(self) -> typing.Optional["TenantSpecLog"]:
        '''
        :stability: experimental
        :schema: TenantSpec#log
        '''
        result = self._values.get("log")
        return typing.cast(typing.Optional["TenantSpecLog"], result)

    @builtins.property
    def mount_path(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpec#mountPath
        '''
        result = self._values.get("mount_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def pod_management_policy(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpec#podManagementPolicy
        '''
        result = self._values.get("pod_management_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def priority_class_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpec#priorityClassName
        '''
        result = self._values.get("priority_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def prometheus(self) -> typing.Optional["TenantSpecPrometheus"]:
        '''
        :stability: experimental
        :schema: TenantSpec#prometheus
        '''
        result = self._values.get("prometheus")
        return typing.cast(typing.Optional["TenantSpecPrometheus"], result)

    @builtins.property
    def request_auto_cert(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpec#requestAutoCert
        '''
        result = self._values.get("request_auto_cert")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def s3(self) -> typing.Optional["TenantSpecS3"]:
        '''
        :stability: experimental
        :schema: TenantSpec#s3
        '''
        result = self._values.get("s3")
        return typing.cast(typing.Optional["TenantSpecS3"], result)

    @builtins.property
    def security_context(self) -> typing.Optional["TenantSpecSecurityContext"]:
        '''
        :stability: experimental
        :schema: TenantSpec#securityContext
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional["TenantSpecSecurityContext"], result)

    @builtins.property
    def service_account_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpec#serviceAccountName
        '''
        result = self._values.get("service_account_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def side_cars(self) -> typing.Optional["TenantSpecSideCars"]:
        '''
        :stability: experimental
        :schema: TenantSpec#sideCars
        '''
        result = self._values.get("side_cars")
        return typing.cast(typing.Optional["TenantSpecSideCars"], result)

    @builtins.property
    def sub_path(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpec#subPath
        '''
        result = self._values.get("sub_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def users(self) -> typing.Optional[typing.List["TenantSpecUsers"]]:
        '''
        :stability: experimental
        :schema: TenantSpec#users
        '''
        result = self._values.get("users")
        return typing.cast(typing.Optional[typing.List["TenantSpecUsers"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecCertConfig",
    jsii_struct_bases=[],
    name_mapping={
        "common_name": "commonName",
        "dns_names": "dnsNames",
        "organization_name": "organizationName",
    },
)
class TenantSpecCertConfig:
    def __init__(
        self,
        *,
        common_name: typing.Optional[builtins.str] = None,
        dns_names: typing.Optional[typing.Sequence[builtins.str]] = None,
        organization_name: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param common_name: 
        :param dns_names: 
        :param organization_name: 

        :stability: experimental
        :schema: TenantSpecCertConfig
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecCertConfig.__init__)
            check_type(argname="argument common_name", value=common_name, expected_type=type_hints["common_name"])
            check_type(argname="argument dns_names", value=dns_names, expected_type=type_hints["dns_names"])
            check_type(argname="argument organization_name", value=organization_name, expected_type=type_hints["organization_name"])
        self._values: typing.Dict[str, typing.Any] = {}
        if common_name is not None:
            self._values["common_name"] = common_name
        if dns_names is not None:
            self._values["dns_names"] = dns_names
        if organization_name is not None:
            self._values["organization_name"] = organization_name

    @builtins.property
    def common_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecCertConfig#commonName
        '''
        result = self._values.get("common_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def dns_names(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecCertConfig#dnsNames
        '''
        result = self._values.get("dns_names")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def organization_name(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecCertConfig#organizationName
        '''
        result = self._values.get("organization_name")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecCertConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecConfiguration",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class TenantSpecConfiguration:
    def __init__(self, *, name: typing.Optional[builtins.str] = None) -> None:
        '''
        :param name: 

        :stability: experimental
        :schema: TenantSpecConfiguration
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecConfiguration.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecConfiguration#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecCredsSecret",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class TenantSpecCredsSecret:
    def __init__(self, *, name: typing.Optional[builtins.str] = None) -> None:
        '''
        :param name: 

        :stability: experimental
        :schema: TenantSpecCredsSecret
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecCredsSecret.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecCredsSecret#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecCredsSecret(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecEnv",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value", "value_from": "valueFrom"},
)
class TenantSpecEnv:
    def __init__(
        self,
        *,
        name: builtins.str,
        value: typing.Optional[builtins.str] = None,
        value_from: typing.Optional[typing.Union["TenantSpecEnvValueFrom", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param name: 
        :param value: 
        :param value_from: 

        :stability: experimental
        :schema: TenantSpecEnv
        '''
        if isinstance(value_from, dict):
            value_from = TenantSpecEnvValueFrom(**value_from)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecEnv.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument value_from", value=value_from, expected_type=type_hints["value_from"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if value is not None:
            self._values["value"] = value
        if value_from is not None:
            self._values["value_from"] = value_from

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecEnv#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecEnv#value
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def value_from(self) -> typing.Optional["TenantSpecEnvValueFrom"]:
        '''
        :stability: experimental
        :schema: TenantSpecEnv#valueFrom
        '''
        result = self._values.get("value_from")
        return typing.cast(typing.Optional["TenantSpecEnvValueFrom"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecEnv(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecEnvValueFrom",
    jsii_struct_bases=[],
    name_mapping={
        "config_map_key_ref": "configMapKeyRef",
        "field_ref": "fieldRef",
        "resource_field_ref": "resourceFieldRef",
        "secret_key_ref": "secretKeyRef",
    },
)
class TenantSpecEnvValueFrom:
    def __init__(
        self,
        *,
        config_map_key_ref: typing.Optional[typing.Union["TenantSpecEnvValueFromConfigMapKeyRef", typing.Dict[str, typing.Any]]] = None,
        field_ref: typing.Optional[typing.Union["TenantSpecEnvValueFromFieldRef", typing.Dict[str, typing.Any]]] = None,
        resource_field_ref: typing.Optional[typing.Union["TenantSpecEnvValueFromResourceFieldRef", typing.Dict[str, typing.Any]]] = None,
        secret_key_ref: typing.Optional[typing.Union["TenantSpecEnvValueFromSecretKeyRef", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param config_map_key_ref: 
        :param field_ref: 
        :param resource_field_ref: 
        :param secret_key_ref: 

        :stability: experimental
        :schema: TenantSpecEnvValueFrom
        '''
        if isinstance(config_map_key_ref, dict):
            config_map_key_ref = TenantSpecEnvValueFromConfigMapKeyRef(**config_map_key_ref)
        if isinstance(field_ref, dict):
            field_ref = TenantSpecEnvValueFromFieldRef(**field_ref)
        if isinstance(resource_field_ref, dict):
            resource_field_ref = TenantSpecEnvValueFromResourceFieldRef(**resource_field_ref)
        if isinstance(secret_key_ref, dict):
            secret_key_ref = TenantSpecEnvValueFromSecretKeyRef(**secret_key_ref)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecEnvValueFrom.__init__)
            check_type(argname="argument config_map_key_ref", value=config_map_key_ref, expected_type=type_hints["config_map_key_ref"])
            check_type(argname="argument field_ref", value=field_ref, expected_type=type_hints["field_ref"])
            check_type(argname="argument resource_field_ref", value=resource_field_ref, expected_type=type_hints["resource_field_ref"])
            check_type(argname="argument secret_key_ref", value=secret_key_ref, expected_type=type_hints["secret_key_ref"])
        self._values: typing.Dict[str, typing.Any] = {}
        if config_map_key_ref is not None:
            self._values["config_map_key_ref"] = config_map_key_ref
        if field_ref is not None:
            self._values["field_ref"] = field_ref
        if resource_field_ref is not None:
            self._values["resource_field_ref"] = resource_field_ref
        if secret_key_ref is not None:
            self._values["secret_key_ref"] = secret_key_ref

    @builtins.property
    def config_map_key_ref(
        self,
    ) -> typing.Optional["TenantSpecEnvValueFromConfigMapKeyRef"]:
        '''
        :stability: experimental
        :schema: TenantSpecEnvValueFrom#configMapKeyRef
        '''
        result = self._values.get("config_map_key_ref")
        return typing.cast(typing.Optional["TenantSpecEnvValueFromConfigMapKeyRef"], result)

    @builtins.property
    def field_ref(self) -> typing.Optional["TenantSpecEnvValueFromFieldRef"]:
        '''
        :stability: experimental
        :schema: TenantSpecEnvValueFrom#fieldRef
        '''
        result = self._values.get("field_ref")
        return typing.cast(typing.Optional["TenantSpecEnvValueFromFieldRef"], result)

    @builtins.property
    def resource_field_ref(
        self,
    ) -> typing.Optional["TenantSpecEnvValueFromResourceFieldRef"]:
        '''
        :stability: experimental
        :schema: TenantSpecEnvValueFrom#resourceFieldRef
        '''
        result = self._values.get("resource_field_ref")
        return typing.cast(typing.Optional["TenantSpecEnvValueFromResourceFieldRef"], result)

    @builtins.property
    def secret_key_ref(self) -> typing.Optional["TenantSpecEnvValueFromSecretKeyRef"]:
        '''
        :stability: experimental
        :schema: TenantSpecEnvValueFrom#secretKeyRef
        '''
        result = self._values.get("secret_key_ref")
        return typing.cast(typing.Optional["TenantSpecEnvValueFromSecretKeyRef"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecEnvValueFrom(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecEnvValueFromConfigMapKeyRef",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "name": "name", "optional": "optional"},
)
class TenantSpecEnvValueFromConfigMapKeyRef:
    def __init__(
        self,
        *,
        key: builtins.str,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param key: 
        :param name: 
        :param optional: 

        :stability: experimental
        :schema: TenantSpecEnvValueFromConfigMapKeyRef
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecEnvValueFromConfigMapKeyRef.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
        }
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecEnvValueFromConfigMapKeyRef#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecEnvValueFromConfigMapKeyRef#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecEnvValueFromConfigMapKeyRef#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecEnvValueFromConfigMapKeyRef(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecEnvValueFromFieldRef",
    jsii_struct_bases=[],
    name_mapping={"field_path": "fieldPath", "api_version": "apiVersion"},
)
class TenantSpecEnvValueFromFieldRef:
    def __init__(
        self,
        *,
        field_path: builtins.str,
        api_version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param field_path: 
        :param api_version: 

        :stability: experimental
        :schema: TenantSpecEnvValueFromFieldRef
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecEnvValueFromFieldRef.__init__)
            check_type(argname="argument field_path", value=field_path, expected_type=type_hints["field_path"])
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
        self._values: typing.Dict[str, typing.Any] = {
            "field_path": field_path,
        }
        if api_version is not None:
            self._values["api_version"] = api_version

    @builtins.property
    def field_path(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecEnvValueFromFieldRef#fieldPath
        '''
        result = self._values.get("field_path")
        assert result is not None, "Required property 'field_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecEnvValueFromFieldRef#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecEnvValueFromFieldRef(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecEnvValueFromResourceFieldRef",
    jsii_struct_bases=[],
    name_mapping={
        "resource": "resource",
        "container_name": "containerName",
        "divisor": "divisor",
    },
)
class TenantSpecEnvValueFromResourceFieldRef:
    def __init__(
        self,
        *,
        resource: builtins.str,
        container_name: typing.Optional[builtins.str] = None,
        divisor: typing.Optional["TenantSpecEnvValueFromResourceFieldRefDivisor"] = None,
    ) -> None:
        '''
        :param resource: 
        :param container_name: 
        :param divisor: 

        :stability: experimental
        :schema: TenantSpecEnvValueFromResourceFieldRef
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecEnvValueFromResourceFieldRef.__init__)
            check_type(argname="argument resource", value=resource, expected_type=type_hints["resource"])
            check_type(argname="argument container_name", value=container_name, expected_type=type_hints["container_name"])
            check_type(argname="argument divisor", value=divisor, expected_type=type_hints["divisor"])
        self._values: typing.Dict[str, typing.Any] = {
            "resource": resource,
        }
        if container_name is not None:
            self._values["container_name"] = container_name
        if divisor is not None:
            self._values["divisor"] = divisor

    @builtins.property
    def resource(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecEnvValueFromResourceFieldRef#resource
        '''
        result = self._values.get("resource")
        assert result is not None, "Required property 'resource' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def container_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecEnvValueFromResourceFieldRef#containerName
        '''
        result = self._values.get("container_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def divisor(
        self,
    ) -> typing.Optional["TenantSpecEnvValueFromResourceFieldRefDivisor"]:
        '''
        :stability: experimental
        :schema: TenantSpecEnvValueFromResourceFieldRef#divisor
        '''
        result = self._values.get("divisor")
        return typing.cast(typing.Optional["TenantSpecEnvValueFromResourceFieldRefDivisor"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecEnvValueFromResourceFieldRef(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecEnvValueFromResourceFieldRefDivisor(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecEnvValueFromResourceFieldRefDivisor",
):
    '''
    :stability: experimental
    :schema: TenantSpecEnvValueFromResourceFieldRefDivisor
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecEnvValueFromResourceFieldRefDivisor":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecEnvValueFromResourceFieldRefDivisor.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecEnvValueFromResourceFieldRefDivisor", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecEnvValueFromResourceFieldRefDivisor":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecEnvValueFromResourceFieldRefDivisor.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecEnvValueFromResourceFieldRefDivisor", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecEnvValueFromSecretKeyRef",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "name": "name", "optional": "optional"},
)
class TenantSpecEnvValueFromSecretKeyRef:
    def __init__(
        self,
        *,
        key: builtins.str,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param key: 
        :param name: 
        :param optional: 

        :stability: experimental
        :schema: TenantSpecEnvValueFromSecretKeyRef
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecEnvValueFromSecretKeyRef.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
        }
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecEnvValueFromSecretKeyRef#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecEnvValueFromSecretKeyRef#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecEnvValueFromSecretKeyRef#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecEnvValueFromSecretKeyRef(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecExposeServices",
    jsii_struct_bases=[],
    name_mapping={"console": "console", "minio": "minio"},
)
class TenantSpecExposeServices:
    def __init__(
        self,
        *,
        console: typing.Optional[builtins.bool] = None,
        minio: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param console: 
        :param minio: 

        :stability: experimental
        :schema: TenantSpecExposeServices
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecExposeServices.__init__)
            check_type(argname="argument console", value=console, expected_type=type_hints["console"])
            check_type(argname="argument minio", value=minio, expected_type=type_hints["minio"])
        self._values: typing.Dict[str, typing.Any] = {}
        if console is not None:
            self._values["console"] = console
        if minio is not None:
            self._values["minio"] = minio

    @builtins.property
    def console(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecExposeServices#console
        '''
        result = self._values.get("console")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def minio(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecExposeServices#minio
        '''
        result = self._values.get("minio")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecExposeServices(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecExternalCaCertSecret",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "type": "type"},
)
class TenantSpecExternalCaCertSecret:
    def __init__(
        self,
        *,
        name: builtins.str,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: 
        :param type: 

        :stability: experimental
        :schema: TenantSpecExternalCaCertSecret
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecExternalCaCertSecret.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecExternalCaCertSecret#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecExternalCaCertSecret#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecExternalCaCertSecret(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecExternalCertSecret",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "type": "type"},
)
class TenantSpecExternalCertSecret:
    def __init__(
        self,
        *,
        name: builtins.str,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: 
        :param type: 

        :stability: experimental
        :schema: TenantSpecExternalCertSecret
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecExternalCertSecret.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecExternalCertSecret#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecExternalCertSecret#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecExternalCertSecret(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecExternalClientCertSecret",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "type": "type"},
)
class TenantSpecExternalClientCertSecret:
    def __init__(
        self,
        *,
        name: builtins.str,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: 
        :param type: 

        :stability: experimental
        :schema: TenantSpecExternalClientCertSecret
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecExternalClientCertSecret.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecExternalClientCertSecret#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecExternalClientCertSecret#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecExternalClientCertSecret(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecImagePullSecret",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class TenantSpecImagePullSecret:
    def __init__(self, *, name: typing.Optional[builtins.str] = None) -> None:
        '''
        :param name: 

        :stability: experimental
        :schema: TenantSpecImagePullSecret
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecImagePullSecret.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecImagePullSecret#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecImagePullSecret(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKes",
    jsii_struct_bases=[],
    name_mapping={
        "kes_secret": "kesSecret",
        "affinity": "affinity",
        "annotations": "annotations",
        "client_cert_secret": "clientCertSecret",
        "external_cert_secret": "externalCertSecret",
        "image": "image",
        "image_pull_policy": "imagePullPolicy",
        "key_name": "keyName",
        "labels": "labels",
        "node_selector": "nodeSelector",
        "replicas": "replicas",
        "resources": "resources",
        "security_context": "securityContext",
        "service_account_name": "serviceAccountName",
        "tolerations": "tolerations",
        "topology_spread_constraints": "topologySpreadConstraints",
    },
)
class TenantSpecKes:
    def __init__(
        self,
        *,
        kes_secret: typing.Union["TenantSpecKesKesSecret", typing.Dict[str, typing.Any]],
        affinity: typing.Optional[typing.Union["TenantSpecKesAffinity", typing.Dict[str, typing.Any]]] = None,
        annotations: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        client_cert_secret: typing.Optional[typing.Union["TenantSpecKesClientCertSecret", typing.Dict[str, typing.Any]]] = None,
        external_cert_secret: typing.Optional[typing.Union["TenantSpecKesExternalCertSecret", typing.Dict[str, typing.Any]]] = None,
        image: typing.Optional[builtins.str] = None,
        image_pull_policy: typing.Optional[builtins.str] = None,
        key_name: typing.Optional[builtins.str] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        node_selector: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        replicas: typing.Optional[jsii.Number] = None,
        resources: typing.Optional[typing.Union["TenantSpecKesResources", typing.Dict[str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union["TenantSpecKesSecurityContext", typing.Dict[str, typing.Any]]] = None,
        service_account_name: typing.Optional[builtins.str] = None,
        tolerations: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesTolerations", typing.Dict[str, typing.Any]]]] = None,
        topology_spread_constraints: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesTopologySpreadConstraints", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param kes_secret: 
        :param affinity: 
        :param annotations: 
        :param client_cert_secret: 
        :param external_cert_secret: 
        :param image: 
        :param image_pull_policy: 
        :param key_name: 
        :param labels: 
        :param node_selector: 
        :param replicas: 
        :param resources: 
        :param security_context: 
        :param service_account_name: 
        :param tolerations: 
        :param topology_spread_constraints: 

        :stability: experimental
        :schema: TenantSpecKes
        '''
        if isinstance(kes_secret, dict):
            kes_secret = TenantSpecKesKesSecret(**kes_secret)
        if isinstance(affinity, dict):
            affinity = TenantSpecKesAffinity(**affinity)
        if isinstance(client_cert_secret, dict):
            client_cert_secret = TenantSpecKesClientCertSecret(**client_cert_secret)
        if isinstance(external_cert_secret, dict):
            external_cert_secret = TenantSpecKesExternalCertSecret(**external_cert_secret)
        if isinstance(resources, dict):
            resources = TenantSpecKesResources(**resources)
        if isinstance(security_context, dict):
            security_context = TenantSpecKesSecurityContext(**security_context)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKes.__init__)
            check_type(argname="argument kes_secret", value=kes_secret, expected_type=type_hints["kes_secret"])
            check_type(argname="argument affinity", value=affinity, expected_type=type_hints["affinity"])
            check_type(argname="argument annotations", value=annotations, expected_type=type_hints["annotations"])
            check_type(argname="argument client_cert_secret", value=client_cert_secret, expected_type=type_hints["client_cert_secret"])
            check_type(argname="argument external_cert_secret", value=external_cert_secret, expected_type=type_hints["external_cert_secret"])
            check_type(argname="argument image", value=image, expected_type=type_hints["image"])
            check_type(argname="argument image_pull_policy", value=image_pull_policy, expected_type=type_hints["image_pull_policy"])
            check_type(argname="argument key_name", value=key_name, expected_type=type_hints["key_name"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
            check_type(argname="argument node_selector", value=node_selector, expected_type=type_hints["node_selector"])
            check_type(argname="argument replicas", value=replicas, expected_type=type_hints["replicas"])
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account_name", value=service_account_name, expected_type=type_hints["service_account_name"])
            check_type(argname="argument tolerations", value=tolerations, expected_type=type_hints["tolerations"])
            check_type(argname="argument topology_spread_constraints", value=topology_spread_constraints, expected_type=type_hints["topology_spread_constraints"])
        self._values: typing.Dict[str, typing.Any] = {
            "kes_secret": kes_secret,
        }
        if affinity is not None:
            self._values["affinity"] = affinity
        if annotations is not None:
            self._values["annotations"] = annotations
        if client_cert_secret is not None:
            self._values["client_cert_secret"] = client_cert_secret
        if external_cert_secret is not None:
            self._values["external_cert_secret"] = external_cert_secret
        if image is not None:
            self._values["image"] = image
        if image_pull_policy is not None:
            self._values["image_pull_policy"] = image_pull_policy
        if key_name is not None:
            self._values["key_name"] = key_name
        if labels is not None:
            self._values["labels"] = labels
        if node_selector is not None:
            self._values["node_selector"] = node_selector
        if replicas is not None:
            self._values["replicas"] = replicas
        if resources is not None:
            self._values["resources"] = resources
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account_name is not None:
            self._values["service_account_name"] = service_account_name
        if tolerations is not None:
            self._values["tolerations"] = tolerations
        if topology_spread_constraints is not None:
            self._values["topology_spread_constraints"] = topology_spread_constraints

    @builtins.property
    def kes_secret(self) -> "TenantSpecKesKesSecret":
        '''
        :stability: experimental
        :schema: TenantSpecKes#kesSecret
        '''
        result = self._values.get("kes_secret")
        assert result is not None, "Required property 'kes_secret' is missing"
        return typing.cast("TenantSpecKesKesSecret", result)

    @builtins.property
    def affinity(self) -> typing.Optional["TenantSpecKesAffinity"]:
        '''
        :stability: experimental
        :schema: TenantSpecKes#affinity
        '''
        result = self._values.get("affinity")
        return typing.cast(typing.Optional["TenantSpecKesAffinity"], result)

    @builtins.property
    def annotations(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKes#annotations
        '''
        result = self._values.get("annotations")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def client_cert_secret(self) -> typing.Optional["TenantSpecKesClientCertSecret"]:
        '''
        :stability: experimental
        :schema: TenantSpecKes#clientCertSecret
        '''
        result = self._values.get("client_cert_secret")
        return typing.cast(typing.Optional["TenantSpecKesClientCertSecret"], result)

    @builtins.property
    def external_cert_secret(
        self,
    ) -> typing.Optional["TenantSpecKesExternalCertSecret"]:
        '''
        :stability: experimental
        :schema: TenantSpecKes#externalCertSecret
        '''
        result = self._values.get("external_cert_secret")
        return typing.cast(typing.Optional["TenantSpecKesExternalCertSecret"], result)

    @builtins.property
    def image(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKes#image
        '''
        result = self._values.get("image")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def image_pull_policy(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKes#imagePullPolicy
        '''
        result = self._values.get("image_pull_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def key_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKes#keyName
        '''
        result = self._values.get("key_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKes#labels
        '''
        result = self._values.get("labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def node_selector(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKes#nodeSelector
        '''
        result = self._values.get("node_selector")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def replicas(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecKes#replicas
        '''
        result = self._values.get("replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def resources(self) -> typing.Optional["TenantSpecKesResources"]:
        '''
        :stability: experimental
        :schema: TenantSpecKes#resources
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["TenantSpecKesResources"], result)

    @builtins.property
    def security_context(self) -> typing.Optional["TenantSpecKesSecurityContext"]:
        '''
        :stability: experimental
        :schema: TenantSpecKes#securityContext
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional["TenantSpecKesSecurityContext"], result)

    @builtins.property
    def service_account_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKes#serviceAccountName
        '''
        result = self._values.get("service_account_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tolerations(self) -> typing.Optional[typing.List["TenantSpecKesTolerations"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKes#tolerations
        '''
        result = self._values.get("tolerations")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesTolerations"]], result)

    @builtins.property
    def topology_spread_constraints(
        self,
    ) -> typing.Optional[typing.List["TenantSpecKesTopologySpreadConstraints"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKes#topologySpreadConstraints
        '''
        result = self._values.get("topology_spread_constraints")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesTopologySpreadConstraints"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKes(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinity",
    jsii_struct_bases=[],
    name_mapping={
        "node_affinity": "nodeAffinity",
        "pod_affinity": "podAffinity",
        "pod_anti_affinity": "podAntiAffinity",
    },
)
class TenantSpecKesAffinity:
    def __init__(
        self,
        *,
        node_affinity: typing.Optional[typing.Union["TenantSpecKesAffinityNodeAffinity", typing.Dict[str, typing.Any]]] = None,
        pod_affinity: typing.Optional[typing.Union["TenantSpecKesAffinityPodAffinity", typing.Dict[str, typing.Any]]] = None,
        pod_anti_affinity: typing.Optional[typing.Union["TenantSpecKesAffinityPodAntiAffinity", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param node_affinity: 
        :param pod_affinity: 
        :param pod_anti_affinity: 

        :stability: experimental
        :schema: TenantSpecKesAffinity
        '''
        if isinstance(node_affinity, dict):
            node_affinity = TenantSpecKesAffinityNodeAffinity(**node_affinity)
        if isinstance(pod_affinity, dict):
            pod_affinity = TenantSpecKesAffinityPodAffinity(**pod_affinity)
        if isinstance(pod_anti_affinity, dict):
            pod_anti_affinity = TenantSpecKesAffinityPodAntiAffinity(**pod_anti_affinity)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinity.__init__)
            check_type(argname="argument node_affinity", value=node_affinity, expected_type=type_hints["node_affinity"])
            check_type(argname="argument pod_affinity", value=pod_affinity, expected_type=type_hints["pod_affinity"])
            check_type(argname="argument pod_anti_affinity", value=pod_anti_affinity, expected_type=type_hints["pod_anti_affinity"])
        self._values: typing.Dict[str, typing.Any] = {}
        if node_affinity is not None:
            self._values["node_affinity"] = node_affinity
        if pod_affinity is not None:
            self._values["pod_affinity"] = pod_affinity
        if pod_anti_affinity is not None:
            self._values["pod_anti_affinity"] = pod_anti_affinity

    @builtins.property
    def node_affinity(self) -> typing.Optional["TenantSpecKesAffinityNodeAffinity"]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinity#nodeAffinity
        '''
        result = self._values.get("node_affinity")
        return typing.cast(typing.Optional["TenantSpecKesAffinityNodeAffinity"], result)

    @builtins.property
    def pod_affinity(self) -> typing.Optional["TenantSpecKesAffinityPodAffinity"]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinity#podAffinity
        '''
        result = self._values.get("pod_affinity")
        return typing.cast(typing.Optional["TenantSpecKesAffinityPodAffinity"], result)

    @builtins.property
    def pod_anti_affinity(
        self,
    ) -> typing.Optional["TenantSpecKesAffinityPodAntiAffinity"]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinity#podAntiAffinity
        '''
        result = self._values.get("pod_anti_affinity")
        return typing.cast(typing.Optional["TenantSpecKesAffinityPodAntiAffinity"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityNodeAffinity",
    jsii_struct_bases=[],
    name_mapping={
        "preferred_during_scheduling_ignored_during_execution": "preferredDuringSchedulingIgnoredDuringExecution",
        "required_during_scheduling_ignored_during_execution": "requiredDuringSchedulingIgnoredDuringExecution",
    },
)
class TenantSpecKesAffinityNodeAffinity:
    def __init__(
        self,
        *,
        preferred_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
        required_during_scheduling_ignored_during_execution: typing.Optional[typing.Union["TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param preferred_during_scheduling_ignored_during_execution: 
        :param required_during_scheduling_ignored_during_execution: 

        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinity
        '''
        if isinstance(required_during_scheduling_ignored_during_execution, dict):
            required_during_scheduling_ignored_during_execution = TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(**required_during_scheduling_ignored_during_execution)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityNodeAffinity.__init__)
            check_type(argname="argument preferred_during_scheduling_ignored_during_execution", value=preferred_during_scheduling_ignored_during_execution, expected_type=type_hints["preferred_during_scheduling_ignored_during_execution"])
            check_type(argname="argument required_during_scheduling_ignored_during_execution", value=required_during_scheduling_ignored_during_execution, expected_type=type_hints["required_during_scheduling_ignored_during_execution"])
        self._values: typing.Dict[str, typing.Any] = {}
        if preferred_during_scheduling_ignored_during_execution is not None:
            self._values["preferred_during_scheduling_ignored_during_execution"] = preferred_during_scheduling_ignored_during_execution
        if required_during_scheduling_ignored_during_execution is not None:
            self._values["required_during_scheduling_ignored_during_execution"] = required_during_scheduling_ignored_during_execution

    @builtins.property
    def preferred_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinity#preferredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("preferred_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution"]], result)

    @builtins.property
    def required_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional["TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution"]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinity#requiredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("required_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional["TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityNodeAffinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={"preference": "preference", "weight": "weight"},
)
class TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        preference: typing.Union["TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference", typing.Dict[str, typing.Any]],
        weight: jsii.Number,
    ) -> None:
        '''
        :param preference: 
        :param weight: 

        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(preference, dict):
            preference = TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(**preference)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument preference", value=preference, expected_type=type_hints["preference"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[str, typing.Any] = {
            "preference": preference,
            "weight": weight,
        }

    @builtins.property
    def preference(
        self,
    ) -> "TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference":
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#preference
        '''
        result = self._values.get("preference")
        assert result is not None, "Required property 'preference' is missing"
        return typing.cast("TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference", result)

    @builtins.property
    def weight(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
        '''
        result = self._values.get("weight")
        assert result is not None, "Required property 'weight' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_fields": "matchFields",
    },
)
class TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_fields: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_fields: 

        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_fields", value=match_fields, expected_type=type_hints["match_fields"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_fields is not None:
            self._values["match_fields"] = match_fields

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions"]], result)

    @builtins.property
    def match_fields(
        self,
    ) -> typing.Optional[typing.List["TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchFields
        '''
        result = self._values.get("match_fields")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={"node_selector_terms": "nodeSelectorTerms"},
)
class TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        node_selector_terms: typing.Sequence[typing.Union["TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms", typing.Dict[str, typing.Any]]],
    ) -> None:
        '''
        :param node_selector_terms: 

        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument node_selector_terms", value=node_selector_terms, expected_type=type_hints["node_selector_terms"])
        self._values: typing.Dict[str, typing.Any] = {
            "node_selector_terms": node_selector_terms,
        }

    @builtins.property
    def node_selector_terms(
        self,
    ) -> typing.List["TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms"]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution#nodeSelectorTerms
        '''
        result = self._values.get("node_selector_terms")
        assert result is not None, "Required property 'node_selector_terms' is missing"
        return typing.cast(typing.List["TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_fields": "matchFields",
    },
)
class TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_fields: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_fields: 

        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_fields", value=match_fields, expected_type=type_hints["match_fields"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_fields is not None:
            self._values["match_fields"] = match_fields

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions"]], result)

    @builtins.property
    def match_fields(
        self,
    ) -> typing.Optional[typing.List["TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchFields
        '''
        result = self._values.get("match_fields")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityPodAffinity",
    jsii_struct_bases=[],
    name_mapping={
        "preferred_during_scheduling_ignored_during_execution": "preferredDuringSchedulingIgnoredDuringExecution",
        "required_during_scheduling_ignored_during_execution": "requiredDuringSchedulingIgnoredDuringExecution",
    },
)
class TenantSpecKesAffinityPodAffinity:
    def __init__(
        self,
        *,
        preferred_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
        required_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param preferred_during_scheduling_ignored_during_execution: 
        :param required_during_scheduling_ignored_during_execution: 

        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityPodAffinity.__init__)
            check_type(argname="argument preferred_during_scheduling_ignored_during_execution", value=preferred_during_scheduling_ignored_during_execution, expected_type=type_hints["preferred_during_scheduling_ignored_during_execution"])
            check_type(argname="argument required_during_scheduling_ignored_during_execution", value=required_during_scheduling_ignored_during_execution, expected_type=type_hints["required_during_scheduling_ignored_during_execution"])
        self._values: typing.Dict[str, typing.Any] = {}
        if preferred_during_scheduling_ignored_during_execution is not None:
            self._values["preferred_during_scheduling_ignored_during_execution"] = preferred_during_scheduling_ignored_during_execution
        if required_during_scheduling_ignored_during_execution is not None:
            self._values["required_during_scheduling_ignored_during_execution"] = required_during_scheduling_ignored_during_execution

    @builtins.property
    def preferred_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinity#preferredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("preferred_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution"]], result)

    @builtins.property
    def required_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinity#requiredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("required_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityPodAffinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={"pod_affinity_term": "podAffinityTerm", "weight": "weight"},
)
class TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        pod_affinity_term: typing.Union["TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm", typing.Dict[str, typing.Any]],
        weight: jsii.Number,
    ) -> None:
        '''
        :param pod_affinity_term: 
        :param weight: 

        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(pod_affinity_term, dict):
            pod_affinity_term = TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(**pod_affinity_term)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument pod_affinity_term", value=pod_affinity_term, expected_type=type_hints["pod_affinity_term"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[str, typing.Any] = {
            "pod_affinity_term": pod_affinity_term,
            "weight": weight,
        }

    @builtins.property
    def pod_affinity_term(
        self,
    ) -> "TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm":
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
        '''
        result = self._values.get("pod_affinity_term")
        assert result is not None, "Required property 'pod_affinity_term' is missing"
        return typing.cast("TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm", result)

    @builtins.property
    def weight(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
        '''
        result = self._values.get("weight")
        assert result is not None, "Required property 'weight' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm",
    jsii_struct_bases=[],
    name_mapping={
        "topology_key": "topologyKey",
        "label_selector": "labelSelector",
        "namespaces": "namespaces",
    },
)
class TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm:
    def __init__(
        self,
        *,
        topology_key: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector", typing.Dict[str, typing.Any]]] = None,
        namespaces: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param topology_key: 
        :param label_selector: 
        :param namespaces: 

        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm.__init__)
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[str, typing.Any] = {
            "topology_key": topology_key,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector"], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={
        "topology_key": "topologyKey",
        "label_selector": "labelSelector",
        "namespaces": "namespaces",
    },
)
class TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        topology_key: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector", typing.Dict[str, typing.Any]]] = None,
        namespaces: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param topology_key: 
        :param label_selector: 
        :param namespaces: 

        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[str, typing.Any] = {
            "topology_key": topology_key,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector"], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityPodAntiAffinity",
    jsii_struct_bases=[],
    name_mapping={
        "preferred_during_scheduling_ignored_during_execution": "preferredDuringSchedulingIgnoredDuringExecution",
        "required_during_scheduling_ignored_during_execution": "requiredDuringSchedulingIgnoredDuringExecution",
    },
)
class TenantSpecKesAffinityPodAntiAffinity:
    def __init__(
        self,
        *,
        preferred_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
        required_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param preferred_during_scheduling_ignored_during_execution: 
        :param required_during_scheduling_ignored_during_execution: 

        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityPodAntiAffinity.__init__)
            check_type(argname="argument preferred_during_scheduling_ignored_during_execution", value=preferred_during_scheduling_ignored_during_execution, expected_type=type_hints["preferred_during_scheduling_ignored_during_execution"])
            check_type(argname="argument required_during_scheduling_ignored_during_execution", value=required_during_scheduling_ignored_during_execution, expected_type=type_hints["required_during_scheduling_ignored_during_execution"])
        self._values: typing.Dict[str, typing.Any] = {}
        if preferred_during_scheduling_ignored_during_execution is not None:
            self._values["preferred_during_scheduling_ignored_during_execution"] = preferred_during_scheduling_ignored_during_execution
        if required_during_scheduling_ignored_during_execution is not None:
            self._values["required_during_scheduling_ignored_during_execution"] = required_during_scheduling_ignored_during_execution

    @builtins.property
    def preferred_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinity#preferredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("preferred_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution"]], result)

    @builtins.property
    def required_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinity#requiredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("required_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityPodAntiAffinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={"pod_affinity_term": "podAffinityTerm", "weight": "weight"},
)
class TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        pod_affinity_term: typing.Union["TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm", typing.Dict[str, typing.Any]],
        weight: jsii.Number,
    ) -> None:
        '''
        :param pod_affinity_term: 
        :param weight: 

        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(pod_affinity_term, dict):
            pod_affinity_term = TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(**pod_affinity_term)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument pod_affinity_term", value=pod_affinity_term, expected_type=type_hints["pod_affinity_term"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[str, typing.Any] = {
            "pod_affinity_term": pod_affinity_term,
            "weight": weight,
        }

    @builtins.property
    def pod_affinity_term(
        self,
    ) -> "TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm":
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
        '''
        result = self._values.get("pod_affinity_term")
        assert result is not None, "Required property 'pod_affinity_term' is missing"
        return typing.cast("TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm", result)

    @builtins.property
    def weight(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
        '''
        result = self._values.get("weight")
        assert result is not None, "Required property 'weight' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm",
    jsii_struct_bases=[],
    name_mapping={
        "topology_key": "topologyKey",
        "label_selector": "labelSelector",
        "namespaces": "namespaces",
    },
)
class TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm:
    def __init__(
        self,
        *,
        topology_key: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector", typing.Dict[str, typing.Any]]] = None,
        namespaces: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param topology_key: 
        :param label_selector: 
        :param namespaces: 

        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm.__init__)
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[str, typing.Any] = {
            "topology_key": topology_key,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector"], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={
        "topology_key": "topologyKey",
        "label_selector": "labelSelector",
        "namespaces": "namespaces",
    },
)
class TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        topology_key: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector", typing.Dict[str, typing.Any]]] = None,
        namespaces: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param topology_key: 
        :param label_selector: 
        :param namespaces: 

        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[str, typing.Any] = {
            "topology_key": topology_key,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector"], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesClientCertSecret",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "type": "type"},
)
class TenantSpecKesClientCertSecret:
    def __init__(
        self,
        *,
        name: builtins.str,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: 
        :param type: 

        :stability: experimental
        :schema: TenantSpecKesClientCertSecret
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesClientCertSecret.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesClientCertSecret#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKesClientCertSecret#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesClientCertSecret(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesExternalCertSecret",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "type": "type"},
)
class TenantSpecKesExternalCertSecret:
    def __init__(
        self,
        *,
        name: builtins.str,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: 
        :param type: 

        :stability: experimental
        :schema: TenantSpecKesExternalCertSecret
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesExternalCertSecret.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesExternalCertSecret#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKesExternalCertSecret#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesExternalCertSecret(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesKesSecret",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class TenantSpecKesKesSecret:
    def __init__(self, *, name: typing.Optional[builtins.str] = None) -> None:
        '''
        :param name: 

        :stability: experimental
        :schema: TenantSpecKesKesSecret
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesKesSecret.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKesKesSecret#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesKesSecret(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesResources",
    jsii_struct_bases=[],
    name_mapping={"limits": "limits", "requests": "requests"},
)
class TenantSpecKesResources:
    def __init__(
        self,
        *,
        limits: typing.Optional[typing.Mapping[builtins.str, "TenantSpecKesResourcesLimits"]] = None,
        requests: typing.Optional[typing.Mapping[builtins.str, "TenantSpecKesResourcesRequests"]] = None,
    ) -> None:
        '''
        :param limits: 
        :param requests: 

        :stability: experimental
        :schema: TenantSpecKesResources
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesResources.__init__)
            check_type(argname="argument limits", value=limits, expected_type=type_hints["limits"])
            check_type(argname="argument requests", value=requests, expected_type=type_hints["requests"])
        self._values: typing.Dict[str, typing.Any] = {}
        if limits is not None:
            self._values["limits"] = limits
        if requests is not None:
            self._values["requests"] = requests

    @builtins.property
    def limits(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "TenantSpecKesResourcesLimits"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesResources#limits
        '''
        result = self._values.get("limits")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "TenantSpecKesResourcesLimits"]], result)

    @builtins.property
    def requests(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "TenantSpecKesResourcesRequests"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesResources#requests
        '''
        result = self._values.get("requests")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "TenantSpecKesResourcesRequests"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecKesResourcesLimits(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesResourcesLimits",
):
    '''
    :stability: experimental
    :schema: TenantSpecKesResourcesLimits
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(cls, value: jsii.Number) -> "TenantSpecKesResourcesLimits":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesResourcesLimits.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecKesResourcesLimits", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(cls, value: builtins.str) -> "TenantSpecKesResourcesLimits":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesResourcesLimits.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecKesResourcesLimits", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


class TenantSpecKesResourcesRequests(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesResourcesRequests",
):
    '''
    :stability: experimental
    :schema: TenantSpecKesResourcesRequests
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(cls, value: jsii.Number) -> "TenantSpecKesResourcesRequests":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesResourcesRequests.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecKesResourcesRequests", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(cls, value: builtins.str) -> "TenantSpecKesResourcesRequests":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesResourcesRequests.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecKesResourcesRequests", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesSecurityContext",
    jsii_struct_bases=[],
    name_mapping={
        "fs_group": "fsGroup",
        "fs_group_change_policy": "fsGroupChangePolicy",
        "run_as_group": "runAsGroup",
        "run_as_non_root": "runAsNonRoot",
        "run_as_user": "runAsUser",
        "seccomp_profile": "seccompProfile",
        "se_linux_options": "seLinuxOptions",
        "supplemental_groups": "supplementalGroups",
        "sysctls": "sysctls",
        "windows_options": "windowsOptions",
    },
)
class TenantSpecKesSecurityContext:
    def __init__(
        self,
        *,
        fs_group: typing.Optional[jsii.Number] = None,
        fs_group_change_policy: typing.Optional[builtins.str] = None,
        run_as_group: typing.Optional[jsii.Number] = None,
        run_as_non_root: typing.Optional[builtins.bool] = None,
        run_as_user: typing.Optional[jsii.Number] = None,
        seccomp_profile: typing.Optional[typing.Union["TenantSpecKesSecurityContextSeccompProfile", typing.Dict[str, typing.Any]]] = None,
        se_linux_options: typing.Optional[typing.Union["TenantSpecKesSecurityContextSeLinuxOptions", typing.Dict[str, typing.Any]]] = None,
        supplemental_groups: typing.Optional[typing.Sequence[jsii.Number]] = None,
        sysctls: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesSecurityContextSysctls", typing.Dict[str, typing.Any]]]] = None,
        windows_options: typing.Optional[typing.Union["TenantSpecKesSecurityContextWindowsOptions", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param fs_group: 
        :param fs_group_change_policy: 
        :param run_as_group: 
        :param run_as_non_root: 
        :param run_as_user: 
        :param seccomp_profile: 
        :param se_linux_options: 
        :param supplemental_groups: 
        :param sysctls: 
        :param windows_options: 

        :stability: experimental
        :schema: TenantSpecKesSecurityContext
        '''
        if isinstance(seccomp_profile, dict):
            seccomp_profile = TenantSpecKesSecurityContextSeccompProfile(**seccomp_profile)
        if isinstance(se_linux_options, dict):
            se_linux_options = TenantSpecKesSecurityContextSeLinuxOptions(**se_linux_options)
        if isinstance(windows_options, dict):
            windows_options = TenantSpecKesSecurityContextWindowsOptions(**windows_options)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesSecurityContext.__init__)
            check_type(argname="argument fs_group", value=fs_group, expected_type=type_hints["fs_group"])
            check_type(argname="argument fs_group_change_policy", value=fs_group_change_policy, expected_type=type_hints["fs_group_change_policy"])
            check_type(argname="argument run_as_group", value=run_as_group, expected_type=type_hints["run_as_group"])
            check_type(argname="argument run_as_non_root", value=run_as_non_root, expected_type=type_hints["run_as_non_root"])
            check_type(argname="argument run_as_user", value=run_as_user, expected_type=type_hints["run_as_user"])
            check_type(argname="argument seccomp_profile", value=seccomp_profile, expected_type=type_hints["seccomp_profile"])
            check_type(argname="argument se_linux_options", value=se_linux_options, expected_type=type_hints["se_linux_options"])
            check_type(argname="argument supplemental_groups", value=supplemental_groups, expected_type=type_hints["supplemental_groups"])
            check_type(argname="argument sysctls", value=sysctls, expected_type=type_hints["sysctls"])
            check_type(argname="argument windows_options", value=windows_options, expected_type=type_hints["windows_options"])
        self._values: typing.Dict[str, typing.Any] = {}
        if fs_group is not None:
            self._values["fs_group"] = fs_group
        if fs_group_change_policy is not None:
            self._values["fs_group_change_policy"] = fs_group_change_policy
        if run_as_group is not None:
            self._values["run_as_group"] = run_as_group
        if run_as_non_root is not None:
            self._values["run_as_non_root"] = run_as_non_root
        if run_as_user is not None:
            self._values["run_as_user"] = run_as_user
        if seccomp_profile is not None:
            self._values["seccomp_profile"] = seccomp_profile
        if se_linux_options is not None:
            self._values["se_linux_options"] = se_linux_options
        if supplemental_groups is not None:
            self._values["supplemental_groups"] = supplemental_groups
        if sysctls is not None:
            self._values["sysctls"] = sysctls
        if windows_options is not None:
            self._values["windows_options"] = windows_options

    @builtins.property
    def fs_group(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContext#fsGroup
        '''
        result = self._values.get("fs_group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fs_group_change_policy(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContext#fsGroupChangePolicy
        '''
        result = self._values.get("fs_group_change_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def run_as_group(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContext#runAsGroup
        '''
        result = self._values.get("run_as_group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def run_as_non_root(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContext#runAsNonRoot
        '''
        result = self._values.get("run_as_non_root")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def run_as_user(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContext#runAsUser
        '''
        result = self._values.get("run_as_user")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def seccomp_profile(
        self,
    ) -> typing.Optional["TenantSpecKesSecurityContextSeccompProfile"]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContext#seccompProfile
        '''
        result = self._values.get("seccomp_profile")
        return typing.cast(typing.Optional["TenantSpecKesSecurityContextSeccompProfile"], result)

    @builtins.property
    def se_linux_options(
        self,
    ) -> typing.Optional["TenantSpecKesSecurityContextSeLinuxOptions"]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContext#seLinuxOptions
        '''
        result = self._values.get("se_linux_options")
        return typing.cast(typing.Optional["TenantSpecKesSecurityContextSeLinuxOptions"], result)

    @builtins.property
    def supplemental_groups(self) -> typing.Optional[typing.List[jsii.Number]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContext#supplementalGroups
        '''
        result = self._values.get("supplemental_groups")
        return typing.cast(typing.Optional[typing.List[jsii.Number]], result)

    @builtins.property
    def sysctls(
        self,
    ) -> typing.Optional[typing.List["TenantSpecKesSecurityContextSysctls"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContext#sysctls
        '''
        result = self._values.get("sysctls")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesSecurityContextSysctls"]], result)

    @builtins.property
    def windows_options(
        self,
    ) -> typing.Optional["TenantSpecKesSecurityContextWindowsOptions"]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContext#windowsOptions
        '''
        result = self._values.get("windows_options")
        return typing.cast(typing.Optional["TenantSpecKesSecurityContextWindowsOptions"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesSecurityContext(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesSecurityContextSeLinuxOptions",
    jsii_struct_bases=[],
    name_mapping={"level": "level", "role": "role", "type": "type", "user": "user"},
)
class TenantSpecKesSecurityContextSeLinuxOptions:
    def __init__(
        self,
        *,
        level: typing.Optional[builtins.str] = None,
        role: typing.Optional[builtins.str] = None,
        type: typing.Optional[builtins.str] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param level: 
        :param role: 
        :param type: 
        :param user: 

        :stability: experimental
        :schema: TenantSpecKesSecurityContextSeLinuxOptions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesSecurityContextSeLinuxOptions.__init__)
            check_type(argname="argument level", value=level, expected_type=type_hints["level"])
            check_type(argname="argument role", value=role, expected_type=type_hints["role"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[str, typing.Any] = {}
        if level is not None:
            self._values["level"] = level
        if role is not None:
            self._values["role"] = role
        if type is not None:
            self._values["type"] = type
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def level(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContextSeLinuxOptions#level
        '''
        result = self._values.get("level")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def role(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContextSeLinuxOptions#role
        '''
        result = self._values.get("role")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContextSeLinuxOptions#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContextSeLinuxOptions#user
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesSecurityContextSeLinuxOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesSecurityContextSeccompProfile",
    jsii_struct_bases=[],
    name_mapping={"type": "type", "localhost_profile": "localhostProfile"},
)
class TenantSpecKesSecurityContextSeccompProfile:
    def __init__(
        self,
        *,
        type: builtins.str,
        localhost_profile: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param type: 
        :param localhost_profile: 

        :stability: experimental
        :schema: TenantSpecKesSecurityContextSeccompProfile
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesSecurityContextSeccompProfile.__init__)
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument localhost_profile", value=localhost_profile, expected_type=type_hints["localhost_profile"])
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
        }
        if localhost_profile is not None:
            self._values["localhost_profile"] = localhost_profile

    @builtins.property
    def type(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContextSeccompProfile#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def localhost_profile(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContextSeccompProfile#localhostProfile
        '''
        result = self._values.get("localhost_profile")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesSecurityContextSeccompProfile(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesSecurityContextSysctls",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class TenantSpecKesSecurityContextSysctls:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        '''
        :param name: 
        :param value: 

        :stability: experimental
        :schema: TenantSpecKesSecurityContextSysctls
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesSecurityContextSysctls.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContextSysctls#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContextSysctls#value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesSecurityContextSysctls(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesSecurityContextWindowsOptions",
    jsii_struct_bases=[],
    name_mapping={
        "gmsa_credential_spec": "gmsaCredentialSpec",
        "gmsa_credential_spec_name": "gmsaCredentialSpecName",
        "run_as_user_name": "runAsUserName",
    },
)
class TenantSpecKesSecurityContextWindowsOptions:
    def __init__(
        self,
        *,
        gmsa_credential_spec: typing.Optional[builtins.str] = None,
        gmsa_credential_spec_name: typing.Optional[builtins.str] = None,
        run_as_user_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param gmsa_credential_spec: 
        :param gmsa_credential_spec_name: 
        :param run_as_user_name: 

        :stability: experimental
        :schema: TenantSpecKesSecurityContextWindowsOptions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesSecurityContextWindowsOptions.__init__)
            check_type(argname="argument gmsa_credential_spec", value=gmsa_credential_spec, expected_type=type_hints["gmsa_credential_spec"])
            check_type(argname="argument gmsa_credential_spec_name", value=gmsa_credential_spec_name, expected_type=type_hints["gmsa_credential_spec_name"])
            check_type(argname="argument run_as_user_name", value=run_as_user_name, expected_type=type_hints["run_as_user_name"])
        self._values: typing.Dict[str, typing.Any] = {}
        if gmsa_credential_spec is not None:
            self._values["gmsa_credential_spec"] = gmsa_credential_spec
        if gmsa_credential_spec_name is not None:
            self._values["gmsa_credential_spec_name"] = gmsa_credential_spec_name
        if run_as_user_name is not None:
            self._values["run_as_user_name"] = run_as_user_name

    @builtins.property
    def gmsa_credential_spec(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContextWindowsOptions#gmsaCredentialSpec
        '''
        result = self._values.get("gmsa_credential_spec")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def gmsa_credential_spec_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContextWindowsOptions#gmsaCredentialSpecName
        '''
        result = self._values.get("gmsa_credential_spec_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def run_as_user_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKesSecurityContextWindowsOptions#runAsUserName
        '''
        result = self._values.get("run_as_user_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesSecurityContextWindowsOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesTolerations",
    jsii_struct_bases=[],
    name_mapping={
        "effect": "effect",
        "key": "key",
        "operator": "operator",
        "toleration_seconds": "tolerationSeconds",
        "value": "value",
    },
)
class TenantSpecKesTolerations:
    def __init__(
        self,
        *,
        effect: typing.Optional[builtins.str] = None,
        key: typing.Optional[builtins.str] = None,
        operator: typing.Optional[builtins.str] = None,
        toleration_seconds: typing.Optional[jsii.Number] = None,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param effect: 
        :param key: 
        :param operator: 
        :param toleration_seconds: 
        :param value: 

        :stability: experimental
        :schema: TenantSpecKesTolerations
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesTolerations.__init__)
            check_type(argname="argument effect", value=effect, expected_type=type_hints["effect"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument toleration_seconds", value=toleration_seconds, expected_type=type_hints["toleration_seconds"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[str, typing.Any] = {}
        if effect is not None:
            self._values["effect"] = effect
        if key is not None:
            self._values["key"] = key
        if operator is not None:
            self._values["operator"] = operator
        if toleration_seconds is not None:
            self._values["toleration_seconds"] = toleration_seconds
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def effect(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKesTolerations#effect
        '''
        result = self._values.get("effect")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def key(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKesTolerations#key
        '''
        result = self._values.get("key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def operator(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKesTolerations#operator
        '''
        result = self._values.get("operator")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def toleration_seconds(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecKesTolerations#tolerationSeconds
        '''
        result = self._values.get("toleration_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecKesTolerations#value
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesTolerations(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesTopologySpreadConstraints",
    jsii_struct_bases=[],
    name_mapping={
        "max_skew": "maxSkew",
        "topology_key": "topologyKey",
        "when_unsatisfiable": "whenUnsatisfiable",
        "label_selector": "labelSelector",
    },
)
class TenantSpecKesTopologySpreadConstraints:
    def __init__(
        self,
        *,
        max_skew: jsii.Number,
        topology_key: builtins.str,
        when_unsatisfiable: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecKesTopologySpreadConstraintsLabelSelector", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param max_skew: 
        :param topology_key: 
        :param when_unsatisfiable: 
        :param label_selector: 

        :stability: experimental
        :schema: TenantSpecKesTopologySpreadConstraints
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecKesTopologySpreadConstraintsLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesTopologySpreadConstraints.__init__)
            check_type(argname="argument max_skew", value=max_skew, expected_type=type_hints["max_skew"])
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument when_unsatisfiable", value=when_unsatisfiable, expected_type=type_hints["when_unsatisfiable"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
        self._values: typing.Dict[str, typing.Any] = {
            "max_skew": max_skew,
            "topology_key": topology_key,
            "when_unsatisfiable": when_unsatisfiable,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector

    @builtins.property
    def max_skew(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecKesTopologySpreadConstraints#maxSkew
        '''
        result = self._values.get("max_skew")
        assert result is not None, "Required property 'max_skew' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesTopologySpreadConstraints#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def when_unsatisfiable(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesTopologySpreadConstraints#whenUnsatisfiable
        '''
        result = self._values.get("when_unsatisfiable")
        assert result is not None, "Required property 'when_unsatisfiable' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecKesTopologySpreadConstraintsLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecKesTopologySpreadConstraints#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecKesTopologySpreadConstraintsLabelSelector"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesTopologySpreadConstraints(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesTopologySpreadConstraintsLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecKesTopologySpreadConstraintsLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecKesTopologySpreadConstraintsLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesTopologySpreadConstraintsLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesTopologySpreadConstraintsLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesTopologySpreadConstraintsLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesTopologySpreadConstraintsLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLog",
    jsii_struct_bases=[],
    name_mapping={
        "affinity": "affinity",
        "annotations": "annotations",
        "audit": "audit",
        "db": "db",
        "image": "image",
        "labels": "labels",
        "node_selector": "nodeSelector",
        "resources": "resources",
        "security_context": "securityContext",
        "service_account_name": "serviceAccountName",
        "tolerations": "tolerations",
        "topology_spread_constraints": "topologySpreadConstraints",
    },
)
class TenantSpecLog:
    def __init__(
        self,
        *,
        affinity: typing.Optional[typing.Union["TenantSpecLogAffinity", typing.Dict[str, typing.Any]]] = None,
        annotations: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        audit: typing.Optional[typing.Union["TenantSpecLogAudit", typing.Dict[str, typing.Any]]] = None,
        db: typing.Optional[typing.Union["TenantSpecLogDb", typing.Dict[str, typing.Any]]] = None,
        image: typing.Optional[builtins.str] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        node_selector: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        resources: typing.Optional[typing.Union["TenantSpecLogResources", typing.Dict[str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union["TenantSpecLogSecurityContext", typing.Dict[str, typing.Any]]] = None,
        service_account_name: typing.Optional[builtins.str] = None,
        tolerations: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogTolerations", typing.Dict[str, typing.Any]]]] = None,
        topology_spread_constraints: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogTopologySpreadConstraints", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param affinity: 
        :param annotations: 
        :param audit: 
        :param db: 
        :param image: 
        :param labels: 
        :param node_selector: 
        :param resources: 
        :param security_context: 
        :param service_account_name: 
        :param tolerations: 
        :param topology_spread_constraints: 

        :stability: experimental
        :schema: TenantSpecLog
        '''
        if isinstance(affinity, dict):
            affinity = TenantSpecLogAffinity(**affinity)
        if isinstance(audit, dict):
            audit = TenantSpecLogAudit(**audit)
        if isinstance(db, dict):
            db = TenantSpecLogDb(**db)
        if isinstance(resources, dict):
            resources = TenantSpecLogResources(**resources)
        if isinstance(security_context, dict):
            security_context = TenantSpecLogSecurityContext(**security_context)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLog.__init__)
            check_type(argname="argument affinity", value=affinity, expected_type=type_hints["affinity"])
            check_type(argname="argument annotations", value=annotations, expected_type=type_hints["annotations"])
            check_type(argname="argument audit", value=audit, expected_type=type_hints["audit"])
            check_type(argname="argument db", value=db, expected_type=type_hints["db"])
            check_type(argname="argument image", value=image, expected_type=type_hints["image"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
            check_type(argname="argument node_selector", value=node_selector, expected_type=type_hints["node_selector"])
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account_name", value=service_account_name, expected_type=type_hints["service_account_name"])
            check_type(argname="argument tolerations", value=tolerations, expected_type=type_hints["tolerations"])
            check_type(argname="argument topology_spread_constraints", value=topology_spread_constraints, expected_type=type_hints["topology_spread_constraints"])
        self._values: typing.Dict[str, typing.Any] = {}
        if affinity is not None:
            self._values["affinity"] = affinity
        if annotations is not None:
            self._values["annotations"] = annotations
        if audit is not None:
            self._values["audit"] = audit
        if db is not None:
            self._values["db"] = db
        if image is not None:
            self._values["image"] = image
        if labels is not None:
            self._values["labels"] = labels
        if node_selector is not None:
            self._values["node_selector"] = node_selector
        if resources is not None:
            self._values["resources"] = resources
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account_name is not None:
            self._values["service_account_name"] = service_account_name
        if tolerations is not None:
            self._values["tolerations"] = tolerations
        if topology_spread_constraints is not None:
            self._values["topology_spread_constraints"] = topology_spread_constraints

    @builtins.property
    def affinity(self) -> typing.Optional["TenantSpecLogAffinity"]:
        '''
        :stability: experimental
        :schema: TenantSpecLog#affinity
        '''
        result = self._values.get("affinity")
        return typing.cast(typing.Optional["TenantSpecLogAffinity"], result)

    @builtins.property
    def annotations(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLog#annotations
        '''
        result = self._values.get("annotations")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def audit(self) -> typing.Optional["TenantSpecLogAudit"]:
        '''
        :stability: experimental
        :schema: TenantSpecLog#audit
        '''
        result = self._values.get("audit")
        return typing.cast(typing.Optional["TenantSpecLogAudit"], result)

    @builtins.property
    def db(self) -> typing.Optional["TenantSpecLogDb"]:
        '''
        :stability: experimental
        :schema: TenantSpecLog#db
        '''
        result = self._values.get("db")
        return typing.cast(typing.Optional["TenantSpecLogDb"], result)

    @builtins.property
    def image(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLog#image
        '''
        result = self._values.get("image")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLog#labels
        '''
        result = self._values.get("labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def node_selector(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLog#nodeSelector
        '''
        result = self._values.get("node_selector")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def resources(self) -> typing.Optional["TenantSpecLogResources"]:
        '''
        :stability: experimental
        :schema: TenantSpecLog#resources
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["TenantSpecLogResources"], result)

    @builtins.property
    def security_context(self) -> typing.Optional["TenantSpecLogSecurityContext"]:
        '''
        :stability: experimental
        :schema: TenantSpecLog#securityContext
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional["TenantSpecLogSecurityContext"], result)

    @builtins.property
    def service_account_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLog#serviceAccountName
        '''
        result = self._values.get("service_account_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tolerations(self) -> typing.Optional[typing.List["TenantSpecLogTolerations"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLog#tolerations
        '''
        result = self._values.get("tolerations")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogTolerations"]], result)

    @builtins.property
    def topology_spread_constraints(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogTopologySpreadConstraints"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLog#topologySpreadConstraints
        '''
        result = self._values.get("topology_spread_constraints")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogTopologySpreadConstraints"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLog(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinity",
    jsii_struct_bases=[],
    name_mapping={
        "node_affinity": "nodeAffinity",
        "pod_affinity": "podAffinity",
        "pod_anti_affinity": "podAntiAffinity",
    },
)
class TenantSpecLogAffinity:
    def __init__(
        self,
        *,
        node_affinity: typing.Optional[typing.Union["TenantSpecLogAffinityNodeAffinity", typing.Dict[str, typing.Any]]] = None,
        pod_affinity: typing.Optional[typing.Union["TenantSpecLogAffinityPodAffinity", typing.Dict[str, typing.Any]]] = None,
        pod_anti_affinity: typing.Optional[typing.Union["TenantSpecLogAffinityPodAntiAffinity", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param node_affinity: 
        :param pod_affinity: 
        :param pod_anti_affinity: 

        :stability: experimental
        :schema: TenantSpecLogAffinity
        '''
        if isinstance(node_affinity, dict):
            node_affinity = TenantSpecLogAffinityNodeAffinity(**node_affinity)
        if isinstance(pod_affinity, dict):
            pod_affinity = TenantSpecLogAffinityPodAffinity(**pod_affinity)
        if isinstance(pod_anti_affinity, dict):
            pod_anti_affinity = TenantSpecLogAffinityPodAntiAffinity(**pod_anti_affinity)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinity.__init__)
            check_type(argname="argument node_affinity", value=node_affinity, expected_type=type_hints["node_affinity"])
            check_type(argname="argument pod_affinity", value=pod_affinity, expected_type=type_hints["pod_affinity"])
            check_type(argname="argument pod_anti_affinity", value=pod_anti_affinity, expected_type=type_hints["pod_anti_affinity"])
        self._values: typing.Dict[str, typing.Any] = {}
        if node_affinity is not None:
            self._values["node_affinity"] = node_affinity
        if pod_affinity is not None:
            self._values["pod_affinity"] = pod_affinity
        if pod_anti_affinity is not None:
            self._values["pod_anti_affinity"] = pod_anti_affinity

    @builtins.property
    def node_affinity(self) -> typing.Optional["TenantSpecLogAffinityNodeAffinity"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinity#nodeAffinity
        '''
        result = self._values.get("node_affinity")
        return typing.cast(typing.Optional["TenantSpecLogAffinityNodeAffinity"], result)

    @builtins.property
    def pod_affinity(self) -> typing.Optional["TenantSpecLogAffinityPodAffinity"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinity#podAffinity
        '''
        result = self._values.get("pod_affinity")
        return typing.cast(typing.Optional["TenantSpecLogAffinityPodAffinity"], result)

    @builtins.property
    def pod_anti_affinity(
        self,
    ) -> typing.Optional["TenantSpecLogAffinityPodAntiAffinity"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinity#podAntiAffinity
        '''
        result = self._values.get("pod_anti_affinity")
        return typing.cast(typing.Optional["TenantSpecLogAffinityPodAntiAffinity"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityNodeAffinity",
    jsii_struct_bases=[],
    name_mapping={
        "preferred_during_scheduling_ignored_during_execution": "preferredDuringSchedulingIgnoredDuringExecution",
        "required_during_scheduling_ignored_during_execution": "requiredDuringSchedulingIgnoredDuringExecution",
    },
)
class TenantSpecLogAffinityNodeAffinity:
    def __init__(
        self,
        *,
        preferred_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
        required_during_scheduling_ignored_during_execution: typing.Optional[typing.Union["TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param preferred_during_scheduling_ignored_during_execution: 
        :param required_during_scheduling_ignored_during_execution: 

        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinity
        '''
        if isinstance(required_during_scheduling_ignored_during_execution, dict):
            required_during_scheduling_ignored_during_execution = TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(**required_during_scheduling_ignored_during_execution)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityNodeAffinity.__init__)
            check_type(argname="argument preferred_during_scheduling_ignored_during_execution", value=preferred_during_scheduling_ignored_during_execution, expected_type=type_hints["preferred_during_scheduling_ignored_during_execution"])
            check_type(argname="argument required_during_scheduling_ignored_during_execution", value=required_during_scheduling_ignored_during_execution, expected_type=type_hints["required_during_scheduling_ignored_during_execution"])
        self._values: typing.Dict[str, typing.Any] = {}
        if preferred_during_scheduling_ignored_during_execution is not None:
            self._values["preferred_during_scheduling_ignored_during_execution"] = preferred_during_scheduling_ignored_during_execution
        if required_during_scheduling_ignored_during_execution is not None:
            self._values["required_during_scheduling_ignored_during_execution"] = required_during_scheduling_ignored_during_execution

    @builtins.property
    def preferred_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinity#preferredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("preferred_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution"]], result)

    @builtins.property
    def required_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional["TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinity#requiredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("required_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional["TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityNodeAffinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={"preference": "preference", "weight": "weight"},
)
class TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        preference: typing.Union["TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference", typing.Dict[str, typing.Any]],
        weight: jsii.Number,
    ) -> None:
        '''
        :param preference: 
        :param weight: 

        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(preference, dict):
            preference = TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(**preference)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument preference", value=preference, expected_type=type_hints["preference"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[str, typing.Any] = {
            "preference": preference,
            "weight": weight,
        }

    @builtins.property
    def preference(
        self,
    ) -> "TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference":
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#preference
        '''
        result = self._values.get("preference")
        assert result is not None, "Required property 'preference' is missing"
        return typing.cast("TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference", result)

    @builtins.property
    def weight(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
        '''
        result = self._values.get("weight")
        assert result is not None, "Required property 'weight' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_fields": "matchFields",
    },
)
class TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_fields: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_fields: 

        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_fields", value=match_fields, expected_type=type_hints["match_fields"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_fields is not None:
            self._values["match_fields"] = match_fields

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions"]], result)

    @builtins.property
    def match_fields(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchFields
        '''
        result = self._values.get("match_fields")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={"node_selector_terms": "nodeSelectorTerms"},
)
class TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        node_selector_terms: typing.Sequence[typing.Union["TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms", typing.Dict[str, typing.Any]]],
    ) -> None:
        '''
        :param node_selector_terms: 

        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument node_selector_terms", value=node_selector_terms, expected_type=type_hints["node_selector_terms"])
        self._values: typing.Dict[str, typing.Any] = {
            "node_selector_terms": node_selector_terms,
        }

    @builtins.property
    def node_selector_terms(
        self,
    ) -> typing.List["TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution#nodeSelectorTerms
        '''
        result = self._values.get("node_selector_terms")
        assert result is not None, "Required property 'node_selector_terms' is missing"
        return typing.cast(typing.List["TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_fields": "matchFields",
    },
)
class TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_fields: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_fields: 

        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_fields", value=match_fields, expected_type=type_hints["match_fields"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_fields is not None:
            self._values["match_fields"] = match_fields

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions"]], result)

    @builtins.property
    def match_fields(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchFields
        '''
        result = self._values.get("match_fields")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityPodAffinity",
    jsii_struct_bases=[],
    name_mapping={
        "preferred_during_scheduling_ignored_during_execution": "preferredDuringSchedulingIgnoredDuringExecution",
        "required_during_scheduling_ignored_during_execution": "requiredDuringSchedulingIgnoredDuringExecution",
    },
)
class TenantSpecLogAffinityPodAffinity:
    def __init__(
        self,
        *,
        preferred_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
        required_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param preferred_during_scheduling_ignored_during_execution: 
        :param required_during_scheduling_ignored_during_execution: 

        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityPodAffinity.__init__)
            check_type(argname="argument preferred_during_scheduling_ignored_during_execution", value=preferred_during_scheduling_ignored_during_execution, expected_type=type_hints["preferred_during_scheduling_ignored_during_execution"])
            check_type(argname="argument required_during_scheduling_ignored_during_execution", value=required_during_scheduling_ignored_during_execution, expected_type=type_hints["required_during_scheduling_ignored_during_execution"])
        self._values: typing.Dict[str, typing.Any] = {}
        if preferred_during_scheduling_ignored_during_execution is not None:
            self._values["preferred_during_scheduling_ignored_during_execution"] = preferred_during_scheduling_ignored_during_execution
        if required_during_scheduling_ignored_during_execution is not None:
            self._values["required_during_scheduling_ignored_during_execution"] = required_during_scheduling_ignored_during_execution

    @builtins.property
    def preferred_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinity#preferredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("preferred_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution"]], result)

    @builtins.property
    def required_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinity#requiredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("required_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityPodAffinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={"pod_affinity_term": "podAffinityTerm", "weight": "weight"},
)
class TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        pod_affinity_term: typing.Union["TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm", typing.Dict[str, typing.Any]],
        weight: jsii.Number,
    ) -> None:
        '''
        :param pod_affinity_term: 
        :param weight: 

        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(pod_affinity_term, dict):
            pod_affinity_term = TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(**pod_affinity_term)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument pod_affinity_term", value=pod_affinity_term, expected_type=type_hints["pod_affinity_term"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[str, typing.Any] = {
            "pod_affinity_term": pod_affinity_term,
            "weight": weight,
        }

    @builtins.property
    def pod_affinity_term(
        self,
    ) -> "TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm":
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
        '''
        result = self._values.get("pod_affinity_term")
        assert result is not None, "Required property 'pod_affinity_term' is missing"
        return typing.cast("TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm", result)

    @builtins.property
    def weight(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
        '''
        result = self._values.get("weight")
        assert result is not None, "Required property 'weight' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm",
    jsii_struct_bases=[],
    name_mapping={
        "topology_key": "topologyKey",
        "label_selector": "labelSelector",
        "namespaces": "namespaces",
    },
)
class TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm:
    def __init__(
        self,
        *,
        topology_key: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector", typing.Dict[str, typing.Any]]] = None,
        namespaces: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param topology_key: 
        :param label_selector: 
        :param namespaces: 

        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm.__init__)
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[str, typing.Any] = {
            "topology_key": topology_key,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector"], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={
        "topology_key": "topologyKey",
        "label_selector": "labelSelector",
        "namespaces": "namespaces",
    },
)
class TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        topology_key: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector", typing.Dict[str, typing.Any]]] = None,
        namespaces: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param topology_key: 
        :param label_selector: 
        :param namespaces: 

        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[str, typing.Any] = {
            "topology_key": topology_key,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector"], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityPodAntiAffinity",
    jsii_struct_bases=[],
    name_mapping={
        "preferred_during_scheduling_ignored_during_execution": "preferredDuringSchedulingIgnoredDuringExecution",
        "required_during_scheduling_ignored_during_execution": "requiredDuringSchedulingIgnoredDuringExecution",
    },
)
class TenantSpecLogAffinityPodAntiAffinity:
    def __init__(
        self,
        *,
        preferred_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
        required_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param preferred_during_scheduling_ignored_during_execution: 
        :param required_during_scheduling_ignored_during_execution: 

        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityPodAntiAffinity.__init__)
            check_type(argname="argument preferred_during_scheduling_ignored_during_execution", value=preferred_during_scheduling_ignored_during_execution, expected_type=type_hints["preferred_during_scheduling_ignored_during_execution"])
            check_type(argname="argument required_during_scheduling_ignored_during_execution", value=required_during_scheduling_ignored_during_execution, expected_type=type_hints["required_during_scheduling_ignored_during_execution"])
        self._values: typing.Dict[str, typing.Any] = {}
        if preferred_during_scheduling_ignored_during_execution is not None:
            self._values["preferred_during_scheduling_ignored_during_execution"] = preferred_during_scheduling_ignored_during_execution
        if required_during_scheduling_ignored_during_execution is not None:
            self._values["required_during_scheduling_ignored_during_execution"] = required_during_scheduling_ignored_during_execution

    @builtins.property
    def preferred_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinity#preferredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("preferred_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution"]], result)

    @builtins.property
    def required_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinity#requiredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("required_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityPodAntiAffinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={"pod_affinity_term": "podAffinityTerm", "weight": "weight"},
)
class TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        pod_affinity_term: typing.Union["TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm", typing.Dict[str, typing.Any]],
        weight: jsii.Number,
    ) -> None:
        '''
        :param pod_affinity_term: 
        :param weight: 

        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(pod_affinity_term, dict):
            pod_affinity_term = TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(**pod_affinity_term)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument pod_affinity_term", value=pod_affinity_term, expected_type=type_hints["pod_affinity_term"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[str, typing.Any] = {
            "pod_affinity_term": pod_affinity_term,
            "weight": weight,
        }

    @builtins.property
    def pod_affinity_term(
        self,
    ) -> "TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm":
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
        '''
        result = self._values.get("pod_affinity_term")
        assert result is not None, "Required property 'pod_affinity_term' is missing"
        return typing.cast("TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm", result)

    @builtins.property
    def weight(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
        '''
        result = self._values.get("weight")
        assert result is not None, "Required property 'weight' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm",
    jsii_struct_bases=[],
    name_mapping={
        "topology_key": "topologyKey",
        "label_selector": "labelSelector",
        "namespaces": "namespaces",
    },
)
class TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm:
    def __init__(
        self,
        *,
        topology_key: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector", typing.Dict[str, typing.Any]]] = None,
        namespaces: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param topology_key: 
        :param label_selector: 
        :param namespaces: 

        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm.__init__)
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[str, typing.Any] = {
            "topology_key": topology_key,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector"], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={
        "topology_key": "topologyKey",
        "label_selector": "labelSelector",
        "namespaces": "namespaces",
    },
)
class TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        topology_key: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector", typing.Dict[str, typing.Any]]] = None,
        namespaces: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param topology_key: 
        :param label_selector: 
        :param namespaces: 

        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[str, typing.Any] = {
            "topology_key": topology_key,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector"], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogAudit",
    jsii_struct_bases=[],
    name_mapping={"disk_capacity_gb": "diskCapacityGb"},
)
class TenantSpecLogAudit:
    def __init__(
        self,
        *,
        disk_capacity_gb: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param disk_capacity_gb: 

        :stability: experimental
        :schema: TenantSpecLogAudit
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogAudit.__init__)
            check_type(argname="argument disk_capacity_gb", value=disk_capacity_gb, expected_type=type_hints["disk_capacity_gb"])
        self._values: typing.Dict[str, typing.Any] = {}
        if disk_capacity_gb is not None:
            self._values["disk_capacity_gb"] = disk_capacity_gb

    @builtins.property
    def disk_capacity_gb(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecLogAudit#diskCapacityGB
        '''
        result = self._values.get("disk_capacity_gb")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogAudit(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDb",
    jsii_struct_bases=[],
    name_mapping={
        "volume_claim_template": "volumeClaimTemplate",
        "affinity": "affinity",
        "annotations": "annotations",
        "image": "image",
        "initimage": "initimage",
        "labels": "labels",
        "node_selector": "nodeSelector",
        "resources": "resources",
        "security_context": "securityContext",
        "service_account_name": "serviceAccountName",
        "tolerations": "tolerations",
        "topology_spread_constraints": "topologySpreadConstraints",
    },
)
class TenantSpecLogDb:
    def __init__(
        self,
        *,
        volume_claim_template: typing.Union["TenantSpecLogDbVolumeClaimTemplate", typing.Dict[str, typing.Any]],
        affinity: typing.Optional[typing.Union["TenantSpecLogDbAffinity", typing.Dict[str, typing.Any]]] = None,
        annotations: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        image: typing.Optional[builtins.str] = None,
        initimage: typing.Optional[builtins.str] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        node_selector: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        resources: typing.Optional[typing.Union["TenantSpecLogDbResources", typing.Dict[str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union["TenantSpecLogDbSecurityContext", typing.Dict[str, typing.Any]]] = None,
        service_account_name: typing.Optional[builtins.str] = None,
        tolerations: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbTolerations", typing.Dict[str, typing.Any]]]] = None,
        topology_spread_constraints: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbTopologySpreadConstraints", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param volume_claim_template: 
        :param affinity: 
        :param annotations: 
        :param image: 
        :param initimage: 
        :param labels: 
        :param node_selector: 
        :param resources: 
        :param security_context: 
        :param service_account_name: 
        :param tolerations: 
        :param topology_spread_constraints: 

        :stability: experimental
        :schema: TenantSpecLogDb
        '''
        if isinstance(volume_claim_template, dict):
            volume_claim_template = TenantSpecLogDbVolumeClaimTemplate(**volume_claim_template)
        if isinstance(affinity, dict):
            affinity = TenantSpecLogDbAffinity(**affinity)
        if isinstance(resources, dict):
            resources = TenantSpecLogDbResources(**resources)
        if isinstance(security_context, dict):
            security_context = TenantSpecLogDbSecurityContext(**security_context)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDb.__init__)
            check_type(argname="argument volume_claim_template", value=volume_claim_template, expected_type=type_hints["volume_claim_template"])
            check_type(argname="argument affinity", value=affinity, expected_type=type_hints["affinity"])
            check_type(argname="argument annotations", value=annotations, expected_type=type_hints["annotations"])
            check_type(argname="argument image", value=image, expected_type=type_hints["image"])
            check_type(argname="argument initimage", value=initimage, expected_type=type_hints["initimage"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
            check_type(argname="argument node_selector", value=node_selector, expected_type=type_hints["node_selector"])
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account_name", value=service_account_name, expected_type=type_hints["service_account_name"])
            check_type(argname="argument tolerations", value=tolerations, expected_type=type_hints["tolerations"])
            check_type(argname="argument topology_spread_constraints", value=topology_spread_constraints, expected_type=type_hints["topology_spread_constraints"])
        self._values: typing.Dict[str, typing.Any] = {
            "volume_claim_template": volume_claim_template,
        }
        if affinity is not None:
            self._values["affinity"] = affinity
        if annotations is not None:
            self._values["annotations"] = annotations
        if image is not None:
            self._values["image"] = image
        if initimage is not None:
            self._values["initimage"] = initimage
        if labels is not None:
            self._values["labels"] = labels
        if node_selector is not None:
            self._values["node_selector"] = node_selector
        if resources is not None:
            self._values["resources"] = resources
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account_name is not None:
            self._values["service_account_name"] = service_account_name
        if tolerations is not None:
            self._values["tolerations"] = tolerations
        if topology_spread_constraints is not None:
            self._values["topology_spread_constraints"] = topology_spread_constraints

    @builtins.property
    def volume_claim_template(self) -> "TenantSpecLogDbVolumeClaimTemplate":
        '''
        :stability: experimental
        :schema: TenantSpecLogDb#volumeClaimTemplate
        '''
        result = self._values.get("volume_claim_template")
        assert result is not None, "Required property 'volume_claim_template' is missing"
        return typing.cast("TenantSpecLogDbVolumeClaimTemplate", result)

    @builtins.property
    def affinity(self) -> typing.Optional["TenantSpecLogDbAffinity"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDb#affinity
        '''
        result = self._values.get("affinity")
        return typing.cast(typing.Optional["TenantSpecLogDbAffinity"], result)

    @builtins.property
    def annotations(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDb#annotations
        '''
        result = self._values.get("annotations")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def image(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDb#image
        '''
        result = self._values.get("image")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def initimage(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDb#initimage
        '''
        result = self._values.get("initimage")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDb#labels
        '''
        result = self._values.get("labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def node_selector(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDb#nodeSelector
        '''
        result = self._values.get("node_selector")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def resources(self) -> typing.Optional["TenantSpecLogDbResources"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDb#resources
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["TenantSpecLogDbResources"], result)

    @builtins.property
    def security_context(self) -> typing.Optional["TenantSpecLogDbSecurityContext"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDb#securityContext
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional["TenantSpecLogDbSecurityContext"], result)

    @builtins.property
    def service_account_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDb#serviceAccountName
        '''
        result = self._values.get("service_account_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tolerations(self) -> typing.Optional[typing.List["TenantSpecLogDbTolerations"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDb#tolerations
        '''
        result = self._values.get("tolerations")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbTolerations"]], result)

    @builtins.property
    def topology_spread_constraints(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbTopologySpreadConstraints"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDb#topologySpreadConstraints
        '''
        result = self._values.get("topology_spread_constraints")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbTopologySpreadConstraints"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDb(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinity",
    jsii_struct_bases=[],
    name_mapping={
        "node_affinity": "nodeAffinity",
        "pod_affinity": "podAffinity",
        "pod_anti_affinity": "podAntiAffinity",
    },
)
class TenantSpecLogDbAffinity:
    def __init__(
        self,
        *,
        node_affinity: typing.Optional[typing.Union["TenantSpecLogDbAffinityNodeAffinity", typing.Dict[str, typing.Any]]] = None,
        pod_affinity: typing.Optional[typing.Union["TenantSpecLogDbAffinityPodAffinity", typing.Dict[str, typing.Any]]] = None,
        pod_anti_affinity: typing.Optional[typing.Union["TenantSpecLogDbAffinityPodAntiAffinity", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param node_affinity: 
        :param pod_affinity: 
        :param pod_anti_affinity: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinity
        '''
        if isinstance(node_affinity, dict):
            node_affinity = TenantSpecLogDbAffinityNodeAffinity(**node_affinity)
        if isinstance(pod_affinity, dict):
            pod_affinity = TenantSpecLogDbAffinityPodAffinity(**pod_affinity)
        if isinstance(pod_anti_affinity, dict):
            pod_anti_affinity = TenantSpecLogDbAffinityPodAntiAffinity(**pod_anti_affinity)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinity.__init__)
            check_type(argname="argument node_affinity", value=node_affinity, expected_type=type_hints["node_affinity"])
            check_type(argname="argument pod_affinity", value=pod_affinity, expected_type=type_hints["pod_affinity"])
            check_type(argname="argument pod_anti_affinity", value=pod_anti_affinity, expected_type=type_hints["pod_anti_affinity"])
        self._values: typing.Dict[str, typing.Any] = {}
        if node_affinity is not None:
            self._values["node_affinity"] = node_affinity
        if pod_affinity is not None:
            self._values["pod_affinity"] = pod_affinity
        if pod_anti_affinity is not None:
            self._values["pod_anti_affinity"] = pod_anti_affinity

    @builtins.property
    def node_affinity(self) -> typing.Optional["TenantSpecLogDbAffinityNodeAffinity"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinity#nodeAffinity
        '''
        result = self._values.get("node_affinity")
        return typing.cast(typing.Optional["TenantSpecLogDbAffinityNodeAffinity"], result)

    @builtins.property
    def pod_affinity(self) -> typing.Optional["TenantSpecLogDbAffinityPodAffinity"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinity#podAffinity
        '''
        result = self._values.get("pod_affinity")
        return typing.cast(typing.Optional["TenantSpecLogDbAffinityPodAffinity"], result)

    @builtins.property
    def pod_anti_affinity(
        self,
    ) -> typing.Optional["TenantSpecLogDbAffinityPodAntiAffinity"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinity#podAntiAffinity
        '''
        result = self._values.get("pod_anti_affinity")
        return typing.cast(typing.Optional["TenantSpecLogDbAffinityPodAntiAffinity"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityNodeAffinity",
    jsii_struct_bases=[],
    name_mapping={
        "preferred_during_scheduling_ignored_during_execution": "preferredDuringSchedulingIgnoredDuringExecution",
        "required_during_scheduling_ignored_during_execution": "requiredDuringSchedulingIgnoredDuringExecution",
    },
)
class TenantSpecLogDbAffinityNodeAffinity:
    def __init__(
        self,
        *,
        preferred_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
        required_during_scheduling_ignored_during_execution: typing.Optional[typing.Union["TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param preferred_during_scheduling_ignored_during_execution: 
        :param required_during_scheduling_ignored_during_execution: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinity
        '''
        if isinstance(required_during_scheduling_ignored_during_execution, dict):
            required_during_scheduling_ignored_during_execution = TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(**required_during_scheduling_ignored_during_execution)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityNodeAffinity.__init__)
            check_type(argname="argument preferred_during_scheduling_ignored_during_execution", value=preferred_during_scheduling_ignored_during_execution, expected_type=type_hints["preferred_during_scheduling_ignored_during_execution"])
            check_type(argname="argument required_during_scheduling_ignored_during_execution", value=required_during_scheduling_ignored_during_execution, expected_type=type_hints["required_during_scheduling_ignored_during_execution"])
        self._values: typing.Dict[str, typing.Any] = {}
        if preferred_during_scheduling_ignored_during_execution is not None:
            self._values["preferred_during_scheduling_ignored_during_execution"] = preferred_during_scheduling_ignored_during_execution
        if required_during_scheduling_ignored_during_execution is not None:
            self._values["required_during_scheduling_ignored_during_execution"] = required_during_scheduling_ignored_during_execution

    @builtins.property
    def preferred_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinity#preferredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("preferred_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution"]], result)

    @builtins.property
    def required_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional["TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinity#requiredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("required_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional["TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityNodeAffinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={"preference": "preference", "weight": "weight"},
)
class TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        preference: typing.Union["TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference", typing.Dict[str, typing.Any]],
        weight: jsii.Number,
    ) -> None:
        '''
        :param preference: 
        :param weight: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(preference, dict):
            preference = TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(**preference)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument preference", value=preference, expected_type=type_hints["preference"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[str, typing.Any] = {
            "preference": preference,
            "weight": weight,
        }

    @builtins.property
    def preference(
        self,
    ) -> "TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference":
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#preference
        '''
        result = self._values.get("preference")
        assert result is not None, "Required property 'preference' is missing"
        return typing.cast("TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference", result)

    @builtins.property
    def weight(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
        '''
        result = self._values.get("weight")
        assert result is not None, "Required property 'weight' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_fields": "matchFields",
    },
)
class TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_fields: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_fields: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_fields", value=match_fields, expected_type=type_hints["match_fields"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_fields is not None:
            self._values["match_fields"] = match_fields

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions"]], result)

    @builtins.property
    def match_fields(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchFields
        '''
        result = self._values.get("match_fields")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={"node_selector_terms": "nodeSelectorTerms"},
)
class TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        node_selector_terms: typing.Sequence[typing.Union["TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms", typing.Dict[str, typing.Any]]],
    ) -> None:
        '''
        :param node_selector_terms: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument node_selector_terms", value=node_selector_terms, expected_type=type_hints["node_selector_terms"])
        self._values: typing.Dict[str, typing.Any] = {
            "node_selector_terms": node_selector_terms,
        }

    @builtins.property
    def node_selector_terms(
        self,
    ) -> typing.List["TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution#nodeSelectorTerms
        '''
        result = self._values.get("node_selector_terms")
        assert result is not None, "Required property 'node_selector_terms' is missing"
        return typing.cast(typing.List["TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_fields": "matchFields",
    },
)
class TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_fields: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_fields: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_fields", value=match_fields, expected_type=type_hints["match_fields"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_fields is not None:
            self._values["match_fields"] = match_fields

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions"]], result)

    @builtins.property
    def match_fields(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchFields
        '''
        result = self._values.get("match_fields")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityPodAffinity",
    jsii_struct_bases=[],
    name_mapping={
        "preferred_during_scheduling_ignored_during_execution": "preferredDuringSchedulingIgnoredDuringExecution",
        "required_during_scheduling_ignored_during_execution": "requiredDuringSchedulingIgnoredDuringExecution",
    },
)
class TenantSpecLogDbAffinityPodAffinity:
    def __init__(
        self,
        *,
        preferred_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
        required_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param preferred_during_scheduling_ignored_during_execution: 
        :param required_during_scheduling_ignored_during_execution: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityPodAffinity.__init__)
            check_type(argname="argument preferred_during_scheduling_ignored_during_execution", value=preferred_during_scheduling_ignored_during_execution, expected_type=type_hints["preferred_during_scheduling_ignored_during_execution"])
            check_type(argname="argument required_during_scheduling_ignored_during_execution", value=required_during_scheduling_ignored_during_execution, expected_type=type_hints["required_during_scheduling_ignored_during_execution"])
        self._values: typing.Dict[str, typing.Any] = {}
        if preferred_during_scheduling_ignored_during_execution is not None:
            self._values["preferred_during_scheduling_ignored_during_execution"] = preferred_during_scheduling_ignored_during_execution
        if required_during_scheduling_ignored_during_execution is not None:
            self._values["required_during_scheduling_ignored_during_execution"] = required_during_scheduling_ignored_during_execution

    @builtins.property
    def preferred_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinity#preferredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("preferred_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution"]], result)

    @builtins.property
    def required_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinity#requiredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("required_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityPodAffinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={"pod_affinity_term": "podAffinityTerm", "weight": "weight"},
)
class TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        pod_affinity_term: typing.Union["TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm", typing.Dict[str, typing.Any]],
        weight: jsii.Number,
    ) -> None:
        '''
        :param pod_affinity_term: 
        :param weight: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(pod_affinity_term, dict):
            pod_affinity_term = TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(**pod_affinity_term)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument pod_affinity_term", value=pod_affinity_term, expected_type=type_hints["pod_affinity_term"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[str, typing.Any] = {
            "pod_affinity_term": pod_affinity_term,
            "weight": weight,
        }

    @builtins.property
    def pod_affinity_term(
        self,
    ) -> "TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm":
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
        '''
        result = self._values.get("pod_affinity_term")
        assert result is not None, "Required property 'pod_affinity_term' is missing"
        return typing.cast("TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm", result)

    @builtins.property
    def weight(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
        '''
        result = self._values.get("weight")
        assert result is not None, "Required property 'weight' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm",
    jsii_struct_bases=[],
    name_mapping={
        "topology_key": "topologyKey",
        "label_selector": "labelSelector",
        "namespaces": "namespaces",
    },
)
class TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm:
    def __init__(
        self,
        *,
        topology_key: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector", typing.Dict[str, typing.Any]]] = None,
        namespaces: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param topology_key: 
        :param label_selector: 
        :param namespaces: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm.__init__)
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[str, typing.Any] = {
            "topology_key": topology_key,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector"], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={
        "topology_key": "topologyKey",
        "label_selector": "labelSelector",
        "namespaces": "namespaces",
    },
)
class TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        topology_key: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector", typing.Dict[str, typing.Any]]] = None,
        namespaces: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param topology_key: 
        :param label_selector: 
        :param namespaces: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[str, typing.Any] = {
            "topology_key": topology_key,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector"], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityPodAntiAffinity",
    jsii_struct_bases=[],
    name_mapping={
        "preferred_during_scheduling_ignored_during_execution": "preferredDuringSchedulingIgnoredDuringExecution",
        "required_during_scheduling_ignored_during_execution": "requiredDuringSchedulingIgnoredDuringExecution",
    },
)
class TenantSpecLogDbAffinityPodAntiAffinity:
    def __init__(
        self,
        *,
        preferred_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
        required_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param preferred_during_scheduling_ignored_during_execution: 
        :param required_during_scheduling_ignored_during_execution: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityPodAntiAffinity.__init__)
            check_type(argname="argument preferred_during_scheduling_ignored_during_execution", value=preferred_during_scheduling_ignored_during_execution, expected_type=type_hints["preferred_during_scheduling_ignored_during_execution"])
            check_type(argname="argument required_during_scheduling_ignored_during_execution", value=required_during_scheduling_ignored_during_execution, expected_type=type_hints["required_during_scheduling_ignored_during_execution"])
        self._values: typing.Dict[str, typing.Any] = {}
        if preferred_during_scheduling_ignored_during_execution is not None:
            self._values["preferred_during_scheduling_ignored_during_execution"] = preferred_during_scheduling_ignored_during_execution
        if required_during_scheduling_ignored_during_execution is not None:
            self._values["required_during_scheduling_ignored_during_execution"] = required_during_scheduling_ignored_during_execution

    @builtins.property
    def preferred_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinity#preferredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("preferred_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution"]], result)

    @builtins.property
    def required_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinity#requiredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("required_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityPodAntiAffinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={"pod_affinity_term": "podAffinityTerm", "weight": "weight"},
)
class TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        pod_affinity_term: typing.Union["TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm", typing.Dict[str, typing.Any]],
        weight: jsii.Number,
    ) -> None:
        '''
        :param pod_affinity_term: 
        :param weight: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(pod_affinity_term, dict):
            pod_affinity_term = TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(**pod_affinity_term)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument pod_affinity_term", value=pod_affinity_term, expected_type=type_hints["pod_affinity_term"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[str, typing.Any] = {
            "pod_affinity_term": pod_affinity_term,
            "weight": weight,
        }

    @builtins.property
    def pod_affinity_term(
        self,
    ) -> "TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm":
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
        '''
        result = self._values.get("pod_affinity_term")
        assert result is not None, "Required property 'pod_affinity_term' is missing"
        return typing.cast("TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm", result)

    @builtins.property
    def weight(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
        '''
        result = self._values.get("weight")
        assert result is not None, "Required property 'weight' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm",
    jsii_struct_bases=[],
    name_mapping={
        "topology_key": "topologyKey",
        "label_selector": "labelSelector",
        "namespaces": "namespaces",
    },
)
class TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm:
    def __init__(
        self,
        *,
        topology_key: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector", typing.Dict[str, typing.Any]]] = None,
        namespaces: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param topology_key: 
        :param label_selector: 
        :param namespaces: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm.__init__)
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[str, typing.Any] = {
            "topology_key": topology_key,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector"], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={
        "topology_key": "topologyKey",
        "label_selector": "labelSelector",
        "namespaces": "namespaces",
    },
)
class TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        topology_key: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector", typing.Dict[str, typing.Any]]] = None,
        namespaces: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param topology_key: 
        :param label_selector: 
        :param namespaces: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[str, typing.Any] = {
            "topology_key": topology_key,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector"], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbResources",
    jsii_struct_bases=[],
    name_mapping={"limits": "limits", "requests": "requests"},
)
class TenantSpecLogDbResources:
    def __init__(
        self,
        *,
        limits: typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogDbResourcesLimits"]] = None,
        requests: typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogDbResourcesRequests"]] = None,
    ) -> None:
        '''
        :param limits: 
        :param requests: 

        :stability: experimental
        :schema: TenantSpecLogDbResources
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbResources.__init__)
            check_type(argname="argument limits", value=limits, expected_type=type_hints["limits"])
            check_type(argname="argument requests", value=requests, expected_type=type_hints["requests"])
        self._values: typing.Dict[str, typing.Any] = {}
        if limits is not None:
            self._values["limits"] = limits
        if requests is not None:
            self._values["requests"] = requests

    @builtins.property
    def limits(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogDbResourcesLimits"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbResources#limits
        '''
        result = self._values.get("limits")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogDbResourcesLimits"]], result)

    @builtins.property
    def requests(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogDbResourcesRequests"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbResources#requests
        '''
        result = self._values.get("requests")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogDbResourcesRequests"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecLogDbResourcesLimits(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbResourcesLimits",
):
    '''
    :stability: experimental
    :schema: TenantSpecLogDbResourcesLimits
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(cls, value: jsii.Number) -> "TenantSpecLogDbResourcesLimits":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbResourcesLimits.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecLogDbResourcesLimits", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(cls, value: builtins.str) -> "TenantSpecLogDbResourcesLimits":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbResourcesLimits.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecLogDbResourcesLimits", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


class TenantSpecLogDbResourcesRequests(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbResourcesRequests",
):
    '''
    :stability: experimental
    :schema: TenantSpecLogDbResourcesRequests
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(cls, value: jsii.Number) -> "TenantSpecLogDbResourcesRequests":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbResourcesRequests.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecLogDbResourcesRequests", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(cls, value: builtins.str) -> "TenantSpecLogDbResourcesRequests":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbResourcesRequests.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecLogDbResourcesRequests", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbSecurityContext",
    jsii_struct_bases=[],
    name_mapping={
        "fs_group": "fsGroup",
        "fs_group_change_policy": "fsGroupChangePolicy",
        "run_as_group": "runAsGroup",
        "run_as_non_root": "runAsNonRoot",
        "run_as_user": "runAsUser",
        "seccomp_profile": "seccompProfile",
        "se_linux_options": "seLinuxOptions",
        "supplemental_groups": "supplementalGroups",
        "sysctls": "sysctls",
        "windows_options": "windowsOptions",
    },
)
class TenantSpecLogDbSecurityContext:
    def __init__(
        self,
        *,
        fs_group: typing.Optional[jsii.Number] = None,
        fs_group_change_policy: typing.Optional[builtins.str] = None,
        run_as_group: typing.Optional[jsii.Number] = None,
        run_as_non_root: typing.Optional[builtins.bool] = None,
        run_as_user: typing.Optional[jsii.Number] = None,
        seccomp_profile: typing.Optional[typing.Union["TenantSpecLogDbSecurityContextSeccompProfile", typing.Dict[str, typing.Any]]] = None,
        se_linux_options: typing.Optional[typing.Union["TenantSpecLogDbSecurityContextSeLinuxOptions", typing.Dict[str, typing.Any]]] = None,
        supplemental_groups: typing.Optional[typing.Sequence[jsii.Number]] = None,
        sysctls: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbSecurityContextSysctls", typing.Dict[str, typing.Any]]]] = None,
        windows_options: typing.Optional[typing.Union["TenantSpecLogDbSecurityContextWindowsOptions", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param fs_group: 
        :param fs_group_change_policy: 
        :param run_as_group: 
        :param run_as_non_root: 
        :param run_as_user: 
        :param seccomp_profile: 
        :param se_linux_options: 
        :param supplemental_groups: 
        :param sysctls: 
        :param windows_options: 

        :stability: experimental
        :schema: TenantSpecLogDbSecurityContext
        '''
        if isinstance(seccomp_profile, dict):
            seccomp_profile = TenantSpecLogDbSecurityContextSeccompProfile(**seccomp_profile)
        if isinstance(se_linux_options, dict):
            se_linux_options = TenantSpecLogDbSecurityContextSeLinuxOptions(**se_linux_options)
        if isinstance(windows_options, dict):
            windows_options = TenantSpecLogDbSecurityContextWindowsOptions(**windows_options)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbSecurityContext.__init__)
            check_type(argname="argument fs_group", value=fs_group, expected_type=type_hints["fs_group"])
            check_type(argname="argument fs_group_change_policy", value=fs_group_change_policy, expected_type=type_hints["fs_group_change_policy"])
            check_type(argname="argument run_as_group", value=run_as_group, expected_type=type_hints["run_as_group"])
            check_type(argname="argument run_as_non_root", value=run_as_non_root, expected_type=type_hints["run_as_non_root"])
            check_type(argname="argument run_as_user", value=run_as_user, expected_type=type_hints["run_as_user"])
            check_type(argname="argument seccomp_profile", value=seccomp_profile, expected_type=type_hints["seccomp_profile"])
            check_type(argname="argument se_linux_options", value=se_linux_options, expected_type=type_hints["se_linux_options"])
            check_type(argname="argument supplemental_groups", value=supplemental_groups, expected_type=type_hints["supplemental_groups"])
            check_type(argname="argument sysctls", value=sysctls, expected_type=type_hints["sysctls"])
            check_type(argname="argument windows_options", value=windows_options, expected_type=type_hints["windows_options"])
        self._values: typing.Dict[str, typing.Any] = {}
        if fs_group is not None:
            self._values["fs_group"] = fs_group
        if fs_group_change_policy is not None:
            self._values["fs_group_change_policy"] = fs_group_change_policy
        if run_as_group is not None:
            self._values["run_as_group"] = run_as_group
        if run_as_non_root is not None:
            self._values["run_as_non_root"] = run_as_non_root
        if run_as_user is not None:
            self._values["run_as_user"] = run_as_user
        if seccomp_profile is not None:
            self._values["seccomp_profile"] = seccomp_profile
        if se_linux_options is not None:
            self._values["se_linux_options"] = se_linux_options
        if supplemental_groups is not None:
            self._values["supplemental_groups"] = supplemental_groups
        if sysctls is not None:
            self._values["sysctls"] = sysctls
        if windows_options is not None:
            self._values["windows_options"] = windows_options

    @builtins.property
    def fs_group(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContext#fsGroup
        '''
        result = self._values.get("fs_group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fs_group_change_policy(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContext#fsGroupChangePolicy
        '''
        result = self._values.get("fs_group_change_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def run_as_group(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContext#runAsGroup
        '''
        result = self._values.get("run_as_group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def run_as_non_root(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContext#runAsNonRoot
        '''
        result = self._values.get("run_as_non_root")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def run_as_user(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContext#runAsUser
        '''
        result = self._values.get("run_as_user")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def seccomp_profile(
        self,
    ) -> typing.Optional["TenantSpecLogDbSecurityContextSeccompProfile"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContext#seccompProfile
        '''
        result = self._values.get("seccomp_profile")
        return typing.cast(typing.Optional["TenantSpecLogDbSecurityContextSeccompProfile"], result)

    @builtins.property
    def se_linux_options(
        self,
    ) -> typing.Optional["TenantSpecLogDbSecurityContextSeLinuxOptions"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContext#seLinuxOptions
        '''
        result = self._values.get("se_linux_options")
        return typing.cast(typing.Optional["TenantSpecLogDbSecurityContextSeLinuxOptions"], result)

    @builtins.property
    def supplemental_groups(self) -> typing.Optional[typing.List[jsii.Number]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContext#supplementalGroups
        '''
        result = self._values.get("supplemental_groups")
        return typing.cast(typing.Optional[typing.List[jsii.Number]], result)

    @builtins.property
    def sysctls(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbSecurityContextSysctls"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContext#sysctls
        '''
        result = self._values.get("sysctls")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbSecurityContextSysctls"]], result)

    @builtins.property
    def windows_options(
        self,
    ) -> typing.Optional["TenantSpecLogDbSecurityContextWindowsOptions"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContext#windowsOptions
        '''
        result = self._values.get("windows_options")
        return typing.cast(typing.Optional["TenantSpecLogDbSecurityContextWindowsOptions"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbSecurityContext(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbSecurityContextSeLinuxOptions",
    jsii_struct_bases=[],
    name_mapping={"level": "level", "role": "role", "type": "type", "user": "user"},
)
class TenantSpecLogDbSecurityContextSeLinuxOptions:
    def __init__(
        self,
        *,
        level: typing.Optional[builtins.str] = None,
        role: typing.Optional[builtins.str] = None,
        type: typing.Optional[builtins.str] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param level: 
        :param role: 
        :param type: 
        :param user: 

        :stability: experimental
        :schema: TenantSpecLogDbSecurityContextSeLinuxOptions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbSecurityContextSeLinuxOptions.__init__)
            check_type(argname="argument level", value=level, expected_type=type_hints["level"])
            check_type(argname="argument role", value=role, expected_type=type_hints["role"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[str, typing.Any] = {}
        if level is not None:
            self._values["level"] = level
        if role is not None:
            self._values["role"] = role
        if type is not None:
            self._values["type"] = type
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def level(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContextSeLinuxOptions#level
        '''
        result = self._values.get("level")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def role(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContextSeLinuxOptions#role
        '''
        result = self._values.get("role")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContextSeLinuxOptions#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContextSeLinuxOptions#user
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbSecurityContextSeLinuxOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbSecurityContextSeccompProfile",
    jsii_struct_bases=[],
    name_mapping={"type": "type", "localhost_profile": "localhostProfile"},
)
class TenantSpecLogDbSecurityContextSeccompProfile:
    def __init__(
        self,
        *,
        type: builtins.str,
        localhost_profile: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param type: 
        :param localhost_profile: 

        :stability: experimental
        :schema: TenantSpecLogDbSecurityContextSeccompProfile
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbSecurityContextSeccompProfile.__init__)
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument localhost_profile", value=localhost_profile, expected_type=type_hints["localhost_profile"])
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
        }
        if localhost_profile is not None:
            self._values["localhost_profile"] = localhost_profile

    @builtins.property
    def type(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContextSeccompProfile#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def localhost_profile(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContextSeccompProfile#localhostProfile
        '''
        result = self._values.get("localhost_profile")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbSecurityContextSeccompProfile(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbSecurityContextSysctls",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class TenantSpecLogDbSecurityContextSysctls:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        '''
        :param name: 
        :param value: 

        :stability: experimental
        :schema: TenantSpecLogDbSecurityContextSysctls
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbSecurityContextSysctls.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContextSysctls#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContextSysctls#value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbSecurityContextSysctls(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbSecurityContextWindowsOptions",
    jsii_struct_bases=[],
    name_mapping={
        "gmsa_credential_spec": "gmsaCredentialSpec",
        "gmsa_credential_spec_name": "gmsaCredentialSpecName",
        "run_as_user_name": "runAsUserName",
    },
)
class TenantSpecLogDbSecurityContextWindowsOptions:
    def __init__(
        self,
        *,
        gmsa_credential_spec: typing.Optional[builtins.str] = None,
        gmsa_credential_spec_name: typing.Optional[builtins.str] = None,
        run_as_user_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param gmsa_credential_spec: 
        :param gmsa_credential_spec_name: 
        :param run_as_user_name: 

        :stability: experimental
        :schema: TenantSpecLogDbSecurityContextWindowsOptions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbSecurityContextWindowsOptions.__init__)
            check_type(argname="argument gmsa_credential_spec", value=gmsa_credential_spec, expected_type=type_hints["gmsa_credential_spec"])
            check_type(argname="argument gmsa_credential_spec_name", value=gmsa_credential_spec_name, expected_type=type_hints["gmsa_credential_spec_name"])
            check_type(argname="argument run_as_user_name", value=run_as_user_name, expected_type=type_hints["run_as_user_name"])
        self._values: typing.Dict[str, typing.Any] = {}
        if gmsa_credential_spec is not None:
            self._values["gmsa_credential_spec"] = gmsa_credential_spec
        if gmsa_credential_spec_name is not None:
            self._values["gmsa_credential_spec_name"] = gmsa_credential_spec_name
        if run_as_user_name is not None:
            self._values["run_as_user_name"] = run_as_user_name

    @builtins.property
    def gmsa_credential_spec(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContextWindowsOptions#gmsaCredentialSpec
        '''
        result = self._values.get("gmsa_credential_spec")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def gmsa_credential_spec_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContextWindowsOptions#gmsaCredentialSpecName
        '''
        result = self._values.get("gmsa_credential_spec_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def run_as_user_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbSecurityContextWindowsOptions#runAsUserName
        '''
        result = self._values.get("run_as_user_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbSecurityContextWindowsOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbTolerations",
    jsii_struct_bases=[],
    name_mapping={
        "effect": "effect",
        "key": "key",
        "operator": "operator",
        "toleration_seconds": "tolerationSeconds",
        "value": "value",
    },
)
class TenantSpecLogDbTolerations:
    def __init__(
        self,
        *,
        effect: typing.Optional[builtins.str] = None,
        key: typing.Optional[builtins.str] = None,
        operator: typing.Optional[builtins.str] = None,
        toleration_seconds: typing.Optional[jsii.Number] = None,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param effect: 
        :param key: 
        :param operator: 
        :param toleration_seconds: 
        :param value: 

        :stability: experimental
        :schema: TenantSpecLogDbTolerations
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbTolerations.__init__)
            check_type(argname="argument effect", value=effect, expected_type=type_hints["effect"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument toleration_seconds", value=toleration_seconds, expected_type=type_hints["toleration_seconds"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[str, typing.Any] = {}
        if effect is not None:
            self._values["effect"] = effect
        if key is not None:
            self._values["key"] = key
        if operator is not None:
            self._values["operator"] = operator
        if toleration_seconds is not None:
            self._values["toleration_seconds"] = toleration_seconds
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def effect(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbTolerations#effect
        '''
        result = self._values.get("effect")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def key(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbTolerations#key
        '''
        result = self._values.get("key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def operator(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbTolerations#operator
        '''
        result = self._values.get("operator")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def toleration_seconds(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbTolerations#tolerationSeconds
        '''
        result = self._values.get("toleration_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbTolerations#value
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbTolerations(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbTopologySpreadConstraints",
    jsii_struct_bases=[],
    name_mapping={
        "max_skew": "maxSkew",
        "topology_key": "topologyKey",
        "when_unsatisfiable": "whenUnsatisfiable",
        "label_selector": "labelSelector",
    },
)
class TenantSpecLogDbTopologySpreadConstraints:
    def __init__(
        self,
        *,
        max_skew: jsii.Number,
        topology_key: builtins.str,
        when_unsatisfiable: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecLogDbTopologySpreadConstraintsLabelSelector", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param max_skew: 
        :param topology_key: 
        :param when_unsatisfiable: 
        :param label_selector: 

        :stability: experimental
        :schema: TenantSpecLogDbTopologySpreadConstraints
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecLogDbTopologySpreadConstraintsLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbTopologySpreadConstraints.__init__)
            check_type(argname="argument max_skew", value=max_skew, expected_type=type_hints["max_skew"])
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument when_unsatisfiable", value=when_unsatisfiable, expected_type=type_hints["when_unsatisfiable"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
        self._values: typing.Dict[str, typing.Any] = {
            "max_skew": max_skew,
            "topology_key": topology_key,
            "when_unsatisfiable": when_unsatisfiable,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector

    @builtins.property
    def max_skew(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbTopologySpreadConstraints#maxSkew
        '''
        result = self._values.get("max_skew")
        assert result is not None, "Required property 'max_skew' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbTopologySpreadConstraints#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def when_unsatisfiable(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbTopologySpreadConstraints#whenUnsatisfiable
        '''
        result = self._values.get("when_unsatisfiable")
        assert result is not None, "Required property 'when_unsatisfiable' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecLogDbTopologySpreadConstraintsLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbTopologySpreadConstraints#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecLogDbTopologySpreadConstraintsLabelSelector"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbTopologySpreadConstraints(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbTopologySpreadConstraintsLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecLogDbTopologySpreadConstraintsLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecLogDbTopologySpreadConstraintsLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbTopologySpreadConstraintsLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbTopologySpreadConstraintsLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbTopologySpreadConstraintsLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbTopologySpreadConstraintsLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbVolumeClaimTemplate",
    jsii_struct_bases=[],
    name_mapping={
        "api_version": "apiVersion",
        "kind": "kind",
        "metadata": "metadata",
        "spec": "spec",
        "status": "status",
    },
)
class TenantSpecLogDbVolumeClaimTemplate:
    def __init__(
        self,
        *,
        api_version: typing.Optional[builtins.str] = None,
        kind: typing.Optional[builtins.str] = None,
        metadata: typing.Optional[typing.Union["TenantSpecLogDbVolumeClaimTemplateMetadata", typing.Dict[str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union["TenantSpecLogDbVolumeClaimTemplateSpec", typing.Dict[str, typing.Any]]] = None,
        status: typing.Optional[typing.Union["TenantSpecLogDbVolumeClaimTemplateStatus", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param api_version: 
        :param kind: 
        :param metadata: 
        :param spec: 
        :param status: 

        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplate
        '''
        if isinstance(metadata, dict):
            metadata = TenantSpecLogDbVolumeClaimTemplateMetadata(**metadata)
        if isinstance(spec, dict):
            spec = TenantSpecLogDbVolumeClaimTemplateSpec(**spec)
        if isinstance(status, dict):
            status = TenantSpecLogDbVolumeClaimTemplateStatus(**status)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbVolumeClaimTemplate.__init__)
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
            check_type(argname="argument status", value=status, expected_type=type_hints["status"])
        self._values: typing.Dict[str, typing.Any] = {}
        if api_version is not None:
            self._values["api_version"] = api_version
        if kind is not None:
            self._values["kind"] = kind
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec
        if status is not None:
            self._values["status"] = status

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplate#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kind(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplate#kind
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def metadata(self) -> typing.Optional["TenantSpecLogDbVolumeClaimTemplateMetadata"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplate#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["TenantSpecLogDbVolumeClaimTemplateMetadata"], result)

    @builtins.property
    def spec(self) -> typing.Optional["TenantSpecLogDbVolumeClaimTemplateSpec"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplate#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional["TenantSpecLogDbVolumeClaimTemplateSpec"], result)

    @builtins.property
    def status(self) -> typing.Optional["TenantSpecLogDbVolumeClaimTemplateStatus"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplate#status
        '''
        result = self._values.get("status")
        return typing.cast(typing.Optional["TenantSpecLogDbVolumeClaimTemplateStatus"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbVolumeClaimTemplate(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbVolumeClaimTemplateMetadata",
    jsii_struct_bases=[],
    name_mapping={
        "annotations": "annotations",
        "finalizers": "finalizers",
        "labels": "labels",
        "name": "name",
        "namespace": "namespace",
    },
)
class TenantSpecLogDbVolumeClaimTemplateMetadata:
    def __init__(
        self,
        *,
        annotations: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        finalizers: typing.Optional[typing.Sequence[builtins.str]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        name: typing.Optional[builtins.str] = None,
        namespace: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param annotations: 
        :param finalizers: 
        :param labels: 
        :param name: 
        :param namespace: 

        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateMetadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbVolumeClaimTemplateMetadata.__init__)
            check_type(argname="argument annotations", value=annotations, expected_type=type_hints["annotations"])
            check_type(argname="argument finalizers", value=finalizers, expected_type=type_hints["finalizers"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
        self._values: typing.Dict[str, typing.Any] = {}
        if annotations is not None:
            self._values["annotations"] = annotations
        if finalizers is not None:
            self._values["finalizers"] = finalizers
        if labels is not None:
            self._values["labels"] = labels
        if name is not None:
            self._values["name"] = name
        if namespace is not None:
            self._values["namespace"] = namespace

    @builtins.property
    def annotations(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateMetadata#annotations
        '''
        result = self._values.get("annotations")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def finalizers(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateMetadata#finalizers
        '''
        result = self._values.get("finalizers")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateMetadata#labels
        '''
        result = self._values.get("labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateMetadata#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def namespace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateMetadata#namespace
        '''
        result = self._values.get("namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbVolumeClaimTemplateMetadata(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbVolumeClaimTemplateSpec",
    jsii_struct_bases=[],
    name_mapping={
        "access_modes": "accessModes",
        "data_source": "dataSource",
        "resources": "resources",
        "selector": "selector",
        "storage_class_name": "storageClassName",
        "volume_mode": "volumeMode",
        "volume_name": "volumeName",
    },
)
class TenantSpecLogDbVolumeClaimTemplateSpec:
    def __init__(
        self,
        *,
        access_modes: typing.Optional[typing.Sequence[builtins.str]] = None,
        data_source: typing.Optional[typing.Union["TenantSpecLogDbVolumeClaimTemplateSpecDataSource", typing.Dict[str, typing.Any]]] = None,
        resources: typing.Optional[typing.Union["TenantSpecLogDbVolumeClaimTemplateSpecResources", typing.Dict[str, typing.Any]]] = None,
        selector: typing.Optional[typing.Union["TenantSpecLogDbVolumeClaimTemplateSpecSelector", typing.Dict[str, typing.Any]]] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[builtins.str] = None,
        volume_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param access_modes: 
        :param data_source: 
        :param resources: 
        :param selector: 
        :param storage_class_name: 
        :param volume_mode: 
        :param volume_name: 

        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpec
        '''
        if isinstance(data_source, dict):
            data_source = TenantSpecLogDbVolumeClaimTemplateSpecDataSource(**data_source)
        if isinstance(resources, dict):
            resources = TenantSpecLogDbVolumeClaimTemplateSpecResources(**resources)
        if isinstance(selector, dict):
            selector = TenantSpecLogDbVolumeClaimTemplateSpecSelector(**selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbVolumeClaimTemplateSpec.__init__)
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument data_source", value=data_source, expected_type=type_hints["data_source"])
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
            check_type(argname="argument volume_name", value=volume_name, expected_type=type_hints["volume_name"])
        self._values: typing.Dict[str, typing.Any] = {}
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if data_source is not None:
            self._values["data_source"] = data_source
        if resources is not None:
            self._values["resources"] = resources
        if selector is not None:
            self._values["selector"] = selector
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode
        if volume_name is not None:
            self._values["volume_name"] = volume_name

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpec#accessModes
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def data_source(
        self,
    ) -> typing.Optional["TenantSpecLogDbVolumeClaimTemplateSpecDataSource"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpec#dataSource
        '''
        result = self._values.get("data_source")
        return typing.cast(typing.Optional["TenantSpecLogDbVolumeClaimTemplateSpecDataSource"], result)

    @builtins.property
    def resources(
        self,
    ) -> typing.Optional["TenantSpecLogDbVolumeClaimTemplateSpecResources"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpec#resources
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["TenantSpecLogDbVolumeClaimTemplateSpecResources"], result)

    @builtins.property
    def selector(
        self,
    ) -> typing.Optional["TenantSpecLogDbVolumeClaimTemplateSpecSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpec#selector
        '''
        result = self._values.get("selector")
        return typing.cast(typing.Optional["TenantSpecLogDbVolumeClaimTemplateSpecSelector"], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpec#storageClassName
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpec#volumeMode
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpec#volumeName
        '''
        result = self._values.get("volume_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbVolumeClaimTemplateSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbVolumeClaimTemplateSpecDataSource",
    jsii_struct_bases=[],
    name_mapping={"kind": "kind", "name": "name", "api_group": "apiGroup"},
)
class TenantSpecLogDbVolumeClaimTemplateSpecDataSource:
    def __init__(
        self,
        *,
        kind: builtins.str,
        name: builtins.str,
        api_group: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param kind: 
        :param name: 
        :param api_group: 

        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpecDataSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbVolumeClaimTemplateSpecDataSource.__init__)
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument api_group", value=api_group, expected_type=type_hints["api_group"])
        self._values: typing.Dict[str, typing.Any] = {
            "kind": kind,
            "name": name,
        }
        if api_group is not None:
            self._values["api_group"] = api_group

    @builtins.property
    def kind(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpecDataSource#kind
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpecDataSource#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_group(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpecDataSource#apiGroup
        '''
        result = self._values.get("api_group")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbVolumeClaimTemplateSpecDataSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbVolumeClaimTemplateSpecResources",
    jsii_struct_bases=[],
    name_mapping={"limits": "limits", "requests": "requests"},
)
class TenantSpecLogDbVolumeClaimTemplateSpecResources:
    def __init__(
        self,
        *,
        limits: typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits"]] = None,
        requests: typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests"]] = None,
    ) -> None:
        '''
        :param limits: 
        :param requests: 

        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpecResources
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbVolumeClaimTemplateSpecResources.__init__)
            check_type(argname="argument limits", value=limits, expected_type=type_hints["limits"])
            check_type(argname="argument requests", value=requests, expected_type=type_hints["requests"])
        self._values: typing.Dict[str, typing.Any] = {}
        if limits is not None:
            self._values["limits"] = limits
        if requests is not None:
            self._values["requests"] = requests

    @builtins.property
    def limits(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpecResources#limits
        '''
        result = self._values.get("limits")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits"]], result)

    @builtins.property
    def requests(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpecResources#requests
        '''
        result = self._values.get("requests")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbVolumeClaimTemplateSpecResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits",
):
    '''
    :stability: experimental
    :schema: TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


class TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests",
):
    '''
    :stability: experimental
    :schema: TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbVolumeClaimTemplateSpecSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecLogDbVolumeClaimTemplateSpecSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpecSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbVolumeClaimTemplateSpecSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpecSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpecSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbVolumeClaimTemplateSpecSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbVolumeClaimTemplateStatus",
    jsii_struct_bases=[],
    name_mapping={
        "access_modes": "accessModes",
        "capacity": "capacity",
        "conditions": "conditions",
        "phase": "phase",
    },
)
class TenantSpecLogDbVolumeClaimTemplateStatus:
    def __init__(
        self,
        *,
        access_modes: typing.Optional[typing.Sequence[builtins.str]] = None,
        capacity: typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogDbVolumeClaimTemplateStatusCapacity"]] = None,
        conditions: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogDbVolumeClaimTemplateStatusConditions", typing.Dict[str, typing.Any]]]] = None,
        phase: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param access_modes: 
        :param capacity: 
        :param conditions: 
        :param phase: 

        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateStatus
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbVolumeClaimTemplateStatus.__init__)
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument capacity", value=capacity, expected_type=type_hints["capacity"])
            check_type(argname="argument conditions", value=conditions, expected_type=type_hints["conditions"])
            check_type(argname="argument phase", value=phase, expected_type=type_hints["phase"])
        self._values: typing.Dict[str, typing.Any] = {}
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if capacity is not None:
            self._values["capacity"] = capacity
        if conditions is not None:
            self._values["conditions"] = conditions
        if phase is not None:
            self._values["phase"] = phase

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateStatus#accessModes
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def capacity(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogDbVolumeClaimTemplateStatusCapacity"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateStatus#capacity
        '''
        result = self._values.get("capacity")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogDbVolumeClaimTemplateStatusCapacity"]], result)

    @builtins.property
    def conditions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogDbVolumeClaimTemplateStatusConditions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateStatus#conditions
        '''
        result = self._values.get("conditions")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogDbVolumeClaimTemplateStatusConditions"]], result)

    @builtins.property
    def phase(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateStatus#phase
        '''
        result = self._values.get("phase")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbVolumeClaimTemplateStatus(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecLogDbVolumeClaimTemplateStatusCapacity(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbVolumeClaimTemplateStatusCapacity",
):
    '''
    :stability: experimental
    :schema: TenantSpecLogDbVolumeClaimTemplateStatusCapacity
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecLogDbVolumeClaimTemplateStatusCapacity":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbVolumeClaimTemplateStatusCapacity.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecLogDbVolumeClaimTemplateStatusCapacity", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecLogDbVolumeClaimTemplateStatusCapacity":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbVolumeClaimTemplateStatusCapacity.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecLogDbVolumeClaimTemplateStatusCapacity", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogDbVolumeClaimTemplateStatusConditions",
    jsii_struct_bases=[],
    name_mapping={
        "status": "status",
        "type": "type",
        "last_probe_time": "lastProbeTime",
        "last_transition_time": "lastTransitionTime",
        "message": "message",
        "reason": "reason",
    },
)
class TenantSpecLogDbVolumeClaimTemplateStatusConditions:
    def __init__(
        self,
        *,
        status: builtins.str,
        type: builtins.str,
        last_probe_time: typing.Optional[datetime.datetime] = None,
        last_transition_time: typing.Optional[datetime.datetime] = None,
        message: typing.Optional[builtins.str] = None,
        reason: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param status: 
        :param type: 
        :param last_probe_time: 
        :param last_transition_time: 
        :param message: 
        :param reason: 

        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateStatusConditions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogDbVolumeClaimTemplateStatusConditions.__init__)
            check_type(argname="argument status", value=status, expected_type=type_hints["status"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument last_probe_time", value=last_probe_time, expected_type=type_hints["last_probe_time"])
            check_type(argname="argument last_transition_time", value=last_transition_time, expected_type=type_hints["last_transition_time"])
            check_type(argname="argument message", value=message, expected_type=type_hints["message"])
            check_type(argname="argument reason", value=reason, expected_type=type_hints["reason"])
        self._values: typing.Dict[str, typing.Any] = {
            "status": status,
            "type": type,
        }
        if last_probe_time is not None:
            self._values["last_probe_time"] = last_probe_time
        if last_transition_time is not None:
            self._values["last_transition_time"] = last_transition_time
        if message is not None:
            self._values["message"] = message
        if reason is not None:
            self._values["reason"] = reason

    @builtins.property
    def status(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateStatusConditions#status
        '''
        result = self._values.get("status")
        assert result is not None, "Required property 'status' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateStatusConditions#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def last_probe_time(self) -> typing.Optional[datetime.datetime]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateStatusConditions#lastProbeTime
        '''
        result = self._values.get("last_probe_time")
        return typing.cast(typing.Optional[datetime.datetime], result)

    @builtins.property
    def last_transition_time(self) -> typing.Optional[datetime.datetime]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateStatusConditions#lastTransitionTime
        '''
        result = self._values.get("last_transition_time")
        return typing.cast(typing.Optional[datetime.datetime], result)

    @builtins.property
    def message(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateStatusConditions#message
        '''
        result = self._values.get("message")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def reason(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogDbVolumeClaimTemplateStatusConditions#reason
        '''
        result = self._values.get("reason")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogDbVolumeClaimTemplateStatusConditions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogResources",
    jsii_struct_bases=[],
    name_mapping={"limits": "limits", "requests": "requests"},
)
class TenantSpecLogResources:
    def __init__(
        self,
        *,
        limits: typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogResourcesLimits"]] = None,
        requests: typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogResourcesRequests"]] = None,
    ) -> None:
        '''
        :param limits: 
        :param requests: 

        :stability: experimental
        :schema: TenantSpecLogResources
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogResources.__init__)
            check_type(argname="argument limits", value=limits, expected_type=type_hints["limits"])
            check_type(argname="argument requests", value=requests, expected_type=type_hints["requests"])
        self._values: typing.Dict[str, typing.Any] = {}
        if limits is not None:
            self._values["limits"] = limits
        if requests is not None:
            self._values["requests"] = requests

    @builtins.property
    def limits(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogResourcesLimits"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogResources#limits
        '''
        result = self._values.get("limits")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogResourcesLimits"]], result)

    @builtins.property
    def requests(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogResourcesRequests"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogResources#requests
        '''
        result = self._values.get("requests")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "TenantSpecLogResourcesRequests"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecLogResourcesLimits(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogResourcesLimits",
):
    '''
    :stability: experimental
    :schema: TenantSpecLogResourcesLimits
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(cls, value: jsii.Number) -> "TenantSpecLogResourcesLimits":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogResourcesLimits.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecLogResourcesLimits", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(cls, value: builtins.str) -> "TenantSpecLogResourcesLimits":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogResourcesLimits.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecLogResourcesLimits", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


class TenantSpecLogResourcesRequests(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogResourcesRequests",
):
    '''
    :stability: experimental
    :schema: TenantSpecLogResourcesRequests
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(cls, value: jsii.Number) -> "TenantSpecLogResourcesRequests":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogResourcesRequests.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecLogResourcesRequests", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(cls, value: builtins.str) -> "TenantSpecLogResourcesRequests":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogResourcesRequests.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecLogResourcesRequests", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogSecurityContext",
    jsii_struct_bases=[],
    name_mapping={
        "fs_group": "fsGroup",
        "fs_group_change_policy": "fsGroupChangePolicy",
        "run_as_group": "runAsGroup",
        "run_as_non_root": "runAsNonRoot",
        "run_as_user": "runAsUser",
        "seccomp_profile": "seccompProfile",
        "se_linux_options": "seLinuxOptions",
        "supplemental_groups": "supplementalGroups",
        "sysctls": "sysctls",
        "windows_options": "windowsOptions",
    },
)
class TenantSpecLogSecurityContext:
    def __init__(
        self,
        *,
        fs_group: typing.Optional[jsii.Number] = None,
        fs_group_change_policy: typing.Optional[builtins.str] = None,
        run_as_group: typing.Optional[jsii.Number] = None,
        run_as_non_root: typing.Optional[builtins.bool] = None,
        run_as_user: typing.Optional[jsii.Number] = None,
        seccomp_profile: typing.Optional[typing.Union["TenantSpecLogSecurityContextSeccompProfile", typing.Dict[str, typing.Any]]] = None,
        se_linux_options: typing.Optional[typing.Union["TenantSpecLogSecurityContextSeLinuxOptions", typing.Dict[str, typing.Any]]] = None,
        supplemental_groups: typing.Optional[typing.Sequence[jsii.Number]] = None,
        sysctls: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogSecurityContextSysctls", typing.Dict[str, typing.Any]]]] = None,
        windows_options: typing.Optional[typing.Union["TenantSpecLogSecurityContextWindowsOptions", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param fs_group: 
        :param fs_group_change_policy: 
        :param run_as_group: 
        :param run_as_non_root: 
        :param run_as_user: 
        :param seccomp_profile: 
        :param se_linux_options: 
        :param supplemental_groups: 
        :param sysctls: 
        :param windows_options: 

        :stability: experimental
        :schema: TenantSpecLogSecurityContext
        '''
        if isinstance(seccomp_profile, dict):
            seccomp_profile = TenantSpecLogSecurityContextSeccompProfile(**seccomp_profile)
        if isinstance(se_linux_options, dict):
            se_linux_options = TenantSpecLogSecurityContextSeLinuxOptions(**se_linux_options)
        if isinstance(windows_options, dict):
            windows_options = TenantSpecLogSecurityContextWindowsOptions(**windows_options)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogSecurityContext.__init__)
            check_type(argname="argument fs_group", value=fs_group, expected_type=type_hints["fs_group"])
            check_type(argname="argument fs_group_change_policy", value=fs_group_change_policy, expected_type=type_hints["fs_group_change_policy"])
            check_type(argname="argument run_as_group", value=run_as_group, expected_type=type_hints["run_as_group"])
            check_type(argname="argument run_as_non_root", value=run_as_non_root, expected_type=type_hints["run_as_non_root"])
            check_type(argname="argument run_as_user", value=run_as_user, expected_type=type_hints["run_as_user"])
            check_type(argname="argument seccomp_profile", value=seccomp_profile, expected_type=type_hints["seccomp_profile"])
            check_type(argname="argument se_linux_options", value=se_linux_options, expected_type=type_hints["se_linux_options"])
            check_type(argname="argument supplemental_groups", value=supplemental_groups, expected_type=type_hints["supplemental_groups"])
            check_type(argname="argument sysctls", value=sysctls, expected_type=type_hints["sysctls"])
            check_type(argname="argument windows_options", value=windows_options, expected_type=type_hints["windows_options"])
        self._values: typing.Dict[str, typing.Any] = {}
        if fs_group is not None:
            self._values["fs_group"] = fs_group
        if fs_group_change_policy is not None:
            self._values["fs_group_change_policy"] = fs_group_change_policy
        if run_as_group is not None:
            self._values["run_as_group"] = run_as_group
        if run_as_non_root is not None:
            self._values["run_as_non_root"] = run_as_non_root
        if run_as_user is not None:
            self._values["run_as_user"] = run_as_user
        if seccomp_profile is not None:
            self._values["seccomp_profile"] = seccomp_profile
        if se_linux_options is not None:
            self._values["se_linux_options"] = se_linux_options
        if supplemental_groups is not None:
            self._values["supplemental_groups"] = supplemental_groups
        if sysctls is not None:
            self._values["sysctls"] = sysctls
        if windows_options is not None:
            self._values["windows_options"] = windows_options

    @builtins.property
    def fs_group(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContext#fsGroup
        '''
        result = self._values.get("fs_group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fs_group_change_policy(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContext#fsGroupChangePolicy
        '''
        result = self._values.get("fs_group_change_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def run_as_group(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContext#runAsGroup
        '''
        result = self._values.get("run_as_group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def run_as_non_root(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContext#runAsNonRoot
        '''
        result = self._values.get("run_as_non_root")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def run_as_user(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContext#runAsUser
        '''
        result = self._values.get("run_as_user")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def seccomp_profile(
        self,
    ) -> typing.Optional["TenantSpecLogSecurityContextSeccompProfile"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContext#seccompProfile
        '''
        result = self._values.get("seccomp_profile")
        return typing.cast(typing.Optional["TenantSpecLogSecurityContextSeccompProfile"], result)

    @builtins.property
    def se_linux_options(
        self,
    ) -> typing.Optional["TenantSpecLogSecurityContextSeLinuxOptions"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContext#seLinuxOptions
        '''
        result = self._values.get("se_linux_options")
        return typing.cast(typing.Optional["TenantSpecLogSecurityContextSeLinuxOptions"], result)

    @builtins.property
    def supplemental_groups(self) -> typing.Optional[typing.List[jsii.Number]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContext#supplementalGroups
        '''
        result = self._values.get("supplemental_groups")
        return typing.cast(typing.Optional[typing.List[jsii.Number]], result)

    @builtins.property
    def sysctls(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogSecurityContextSysctls"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContext#sysctls
        '''
        result = self._values.get("sysctls")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogSecurityContextSysctls"]], result)

    @builtins.property
    def windows_options(
        self,
    ) -> typing.Optional["TenantSpecLogSecurityContextWindowsOptions"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContext#windowsOptions
        '''
        result = self._values.get("windows_options")
        return typing.cast(typing.Optional["TenantSpecLogSecurityContextWindowsOptions"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogSecurityContext(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogSecurityContextSeLinuxOptions",
    jsii_struct_bases=[],
    name_mapping={"level": "level", "role": "role", "type": "type", "user": "user"},
)
class TenantSpecLogSecurityContextSeLinuxOptions:
    def __init__(
        self,
        *,
        level: typing.Optional[builtins.str] = None,
        role: typing.Optional[builtins.str] = None,
        type: typing.Optional[builtins.str] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param level: 
        :param role: 
        :param type: 
        :param user: 

        :stability: experimental
        :schema: TenantSpecLogSecurityContextSeLinuxOptions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogSecurityContextSeLinuxOptions.__init__)
            check_type(argname="argument level", value=level, expected_type=type_hints["level"])
            check_type(argname="argument role", value=role, expected_type=type_hints["role"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[str, typing.Any] = {}
        if level is not None:
            self._values["level"] = level
        if role is not None:
            self._values["role"] = role
        if type is not None:
            self._values["type"] = type
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def level(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContextSeLinuxOptions#level
        '''
        result = self._values.get("level")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def role(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContextSeLinuxOptions#role
        '''
        result = self._values.get("role")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContextSeLinuxOptions#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContextSeLinuxOptions#user
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogSecurityContextSeLinuxOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogSecurityContextSeccompProfile",
    jsii_struct_bases=[],
    name_mapping={"type": "type", "localhost_profile": "localhostProfile"},
)
class TenantSpecLogSecurityContextSeccompProfile:
    def __init__(
        self,
        *,
        type: builtins.str,
        localhost_profile: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param type: 
        :param localhost_profile: 

        :stability: experimental
        :schema: TenantSpecLogSecurityContextSeccompProfile
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogSecurityContextSeccompProfile.__init__)
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument localhost_profile", value=localhost_profile, expected_type=type_hints["localhost_profile"])
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
        }
        if localhost_profile is not None:
            self._values["localhost_profile"] = localhost_profile

    @builtins.property
    def type(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContextSeccompProfile#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def localhost_profile(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContextSeccompProfile#localhostProfile
        '''
        result = self._values.get("localhost_profile")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogSecurityContextSeccompProfile(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogSecurityContextSysctls",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class TenantSpecLogSecurityContextSysctls:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        '''
        :param name: 
        :param value: 

        :stability: experimental
        :schema: TenantSpecLogSecurityContextSysctls
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogSecurityContextSysctls.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContextSysctls#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContextSysctls#value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogSecurityContextSysctls(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogSecurityContextWindowsOptions",
    jsii_struct_bases=[],
    name_mapping={
        "gmsa_credential_spec": "gmsaCredentialSpec",
        "gmsa_credential_spec_name": "gmsaCredentialSpecName",
        "run_as_user_name": "runAsUserName",
    },
)
class TenantSpecLogSecurityContextWindowsOptions:
    def __init__(
        self,
        *,
        gmsa_credential_spec: typing.Optional[builtins.str] = None,
        gmsa_credential_spec_name: typing.Optional[builtins.str] = None,
        run_as_user_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param gmsa_credential_spec: 
        :param gmsa_credential_spec_name: 
        :param run_as_user_name: 

        :stability: experimental
        :schema: TenantSpecLogSecurityContextWindowsOptions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogSecurityContextWindowsOptions.__init__)
            check_type(argname="argument gmsa_credential_spec", value=gmsa_credential_spec, expected_type=type_hints["gmsa_credential_spec"])
            check_type(argname="argument gmsa_credential_spec_name", value=gmsa_credential_spec_name, expected_type=type_hints["gmsa_credential_spec_name"])
            check_type(argname="argument run_as_user_name", value=run_as_user_name, expected_type=type_hints["run_as_user_name"])
        self._values: typing.Dict[str, typing.Any] = {}
        if gmsa_credential_spec is not None:
            self._values["gmsa_credential_spec"] = gmsa_credential_spec
        if gmsa_credential_spec_name is not None:
            self._values["gmsa_credential_spec_name"] = gmsa_credential_spec_name
        if run_as_user_name is not None:
            self._values["run_as_user_name"] = run_as_user_name

    @builtins.property
    def gmsa_credential_spec(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContextWindowsOptions#gmsaCredentialSpec
        '''
        result = self._values.get("gmsa_credential_spec")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def gmsa_credential_spec_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContextWindowsOptions#gmsaCredentialSpecName
        '''
        result = self._values.get("gmsa_credential_spec_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def run_as_user_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogSecurityContextWindowsOptions#runAsUserName
        '''
        result = self._values.get("run_as_user_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogSecurityContextWindowsOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogTolerations",
    jsii_struct_bases=[],
    name_mapping={
        "effect": "effect",
        "key": "key",
        "operator": "operator",
        "toleration_seconds": "tolerationSeconds",
        "value": "value",
    },
)
class TenantSpecLogTolerations:
    def __init__(
        self,
        *,
        effect: typing.Optional[builtins.str] = None,
        key: typing.Optional[builtins.str] = None,
        operator: typing.Optional[builtins.str] = None,
        toleration_seconds: typing.Optional[jsii.Number] = None,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param effect: 
        :param key: 
        :param operator: 
        :param toleration_seconds: 
        :param value: 

        :stability: experimental
        :schema: TenantSpecLogTolerations
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogTolerations.__init__)
            check_type(argname="argument effect", value=effect, expected_type=type_hints["effect"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument toleration_seconds", value=toleration_seconds, expected_type=type_hints["toleration_seconds"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[str, typing.Any] = {}
        if effect is not None:
            self._values["effect"] = effect
        if key is not None:
            self._values["key"] = key
        if operator is not None:
            self._values["operator"] = operator
        if toleration_seconds is not None:
            self._values["toleration_seconds"] = toleration_seconds
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def effect(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogTolerations#effect
        '''
        result = self._values.get("effect")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def key(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogTolerations#key
        '''
        result = self._values.get("key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def operator(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogTolerations#operator
        '''
        result = self._values.get("operator")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def toleration_seconds(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecLogTolerations#tolerationSeconds
        '''
        result = self._values.get("toleration_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecLogTolerations#value
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogTolerations(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogTopologySpreadConstraints",
    jsii_struct_bases=[],
    name_mapping={
        "max_skew": "maxSkew",
        "topology_key": "topologyKey",
        "when_unsatisfiable": "whenUnsatisfiable",
        "label_selector": "labelSelector",
    },
)
class TenantSpecLogTopologySpreadConstraints:
    def __init__(
        self,
        *,
        max_skew: jsii.Number,
        topology_key: builtins.str,
        when_unsatisfiable: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecLogTopologySpreadConstraintsLabelSelector", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param max_skew: 
        :param topology_key: 
        :param when_unsatisfiable: 
        :param label_selector: 

        :stability: experimental
        :schema: TenantSpecLogTopologySpreadConstraints
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecLogTopologySpreadConstraintsLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogTopologySpreadConstraints.__init__)
            check_type(argname="argument max_skew", value=max_skew, expected_type=type_hints["max_skew"])
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument when_unsatisfiable", value=when_unsatisfiable, expected_type=type_hints["when_unsatisfiable"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
        self._values: typing.Dict[str, typing.Any] = {
            "max_skew": max_skew,
            "topology_key": topology_key,
            "when_unsatisfiable": when_unsatisfiable,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector

    @builtins.property
    def max_skew(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecLogTopologySpreadConstraints#maxSkew
        '''
        result = self._values.get("max_skew")
        assert result is not None, "Required property 'max_skew' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogTopologySpreadConstraints#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def when_unsatisfiable(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogTopologySpreadConstraints#whenUnsatisfiable
        '''
        result = self._values.get("when_unsatisfiable")
        assert result is not None, "Required property 'when_unsatisfiable' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecLogTopologySpreadConstraintsLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecLogTopologySpreadConstraints#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecLogTopologySpreadConstraintsLabelSelector"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogTopologySpreadConstraints(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogTopologySpreadConstraintsLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecLogTopologySpreadConstraintsLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecLogTopologySpreadConstraintsLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogTopologySpreadConstraintsLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogTopologySpreadConstraintsLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogTopologySpreadConstraintsLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogTopologySpreadConstraintsLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheus",
    jsii_struct_bases=[],
    name_mapping={
        "affinity": "affinity",
        "annotations": "annotations",
        "disk_capacity_gb": "diskCapacityGb",
        "image": "image",
        "initimage": "initimage",
        "labels": "labels",
        "node_selector": "nodeSelector",
        "resources": "resources",
        "security_context": "securityContext",
        "service_account_name": "serviceAccountName",
        "sidecarimage": "sidecarimage",
        "storage_class_name": "storageClassName",
        "topology_spread_constraints": "topologySpreadConstraints",
    },
)
class TenantSpecPrometheus:
    def __init__(
        self,
        *,
        affinity: typing.Optional[typing.Union["TenantSpecPrometheusAffinity", typing.Dict[str, typing.Any]]] = None,
        annotations: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        disk_capacity_gb: typing.Optional[jsii.Number] = None,
        image: typing.Optional[builtins.str] = None,
        initimage: typing.Optional[builtins.str] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        node_selector: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        resources: typing.Optional[typing.Union["TenantSpecPrometheusResources", typing.Dict[str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union["TenantSpecPrometheusSecurityContext", typing.Dict[str, typing.Any]]] = None,
        service_account_name: typing.Optional[builtins.str] = None,
        sidecarimage: typing.Optional[builtins.str] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        topology_spread_constraints: typing.Optional[typing.Sequence[typing.Union["TenantSpecPrometheusTopologySpreadConstraints", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param affinity: 
        :param annotations: 
        :param disk_capacity_gb: 
        :param image: 
        :param initimage: 
        :param labels: 
        :param node_selector: 
        :param resources: 
        :param security_context: 
        :param service_account_name: 
        :param sidecarimage: 
        :param storage_class_name: 
        :param topology_spread_constraints: 

        :stability: experimental
        :schema: TenantSpecPrometheus
        '''
        if isinstance(affinity, dict):
            affinity = TenantSpecPrometheusAffinity(**affinity)
        if isinstance(resources, dict):
            resources = TenantSpecPrometheusResources(**resources)
        if isinstance(security_context, dict):
            security_context = TenantSpecPrometheusSecurityContext(**security_context)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheus.__init__)
            check_type(argname="argument affinity", value=affinity, expected_type=type_hints["affinity"])
            check_type(argname="argument annotations", value=annotations, expected_type=type_hints["annotations"])
            check_type(argname="argument disk_capacity_gb", value=disk_capacity_gb, expected_type=type_hints["disk_capacity_gb"])
            check_type(argname="argument image", value=image, expected_type=type_hints["image"])
            check_type(argname="argument initimage", value=initimage, expected_type=type_hints["initimage"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
            check_type(argname="argument node_selector", value=node_selector, expected_type=type_hints["node_selector"])
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account_name", value=service_account_name, expected_type=type_hints["service_account_name"])
            check_type(argname="argument sidecarimage", value=sidecarimage, expected_type=type_hints["sidecarimage"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument topology_spread_constraints", value=topology_spread_constraints, expected_type=type_hints["topology_spread_constraints"])
        self._values: typing.Dict[str, typing.Any] = {}
        if affinity is not None:
            self._values["affinity"] = affinity
        if annotations is not None:
            self._values["annotations"] = annotations
        if disk_capacity_gb is not None:
            self._values["disk_capacity_gb"] = disk_capacity_gb
        if image is not None:
            self._values["image"] = image
        if initimage is not None:
            self._values["initimage"] = initimage
        if labels is not None:
            self._values["labels"] = labels
        if node_selector is not None:
            self._values["node_selector"] = node_selector
        if resources is not None:
            self._values["resources"] = resources
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account_name is not None:
            self._values["service_account_name"] = service_account_name
        if sidecarimage is not None:
            self._values["sidecarimage"] = sidecarimage
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if topology_spread_constraints is not None:
            self._values["topology_spread_constraints"] = topology_spread_constraints

    @builtins.property
    def affinity(self) -> typing.Optional["TenantSpecPrometheusAffinity"]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheus#affinity
        '''
        result = self._values.get("affinity")
        return typing.cast(typing.Optional["TenantSpecPrometheusAffinity"], result)

    @builtins.property
    def annotations(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheus#annotations
        '''
        result = self._values.get("annotations")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def disk_capacity_gb(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheus#diskCapacityGB
        '''
        result = self._values.get("disk_capacity_gb")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def image(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheus#image
        '''
        result = self._values.get("image")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def initimage(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheus#initimage
        '''
        result = self._values.get("initimage")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheus#labels
        '''
        result = self._values.get("labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def node_selector(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheus#nodeSelector
        '''
        result = self._values.get("node_selector")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def resources(self) -> typing.Optional["TenantSpecPrometheusResources"]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheus#resources
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["TenantSpecPrometheusResources"], result)

    @builtins.property
    def security_context(
        self,
    ) -> typing.Optional["TenantSpecPrometheusSecurityContext"]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheus#securityContext
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional["TenantSpecPrometheusSecurityContext"], result)

    @builtins.property
    def service_account_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheus#serviceAccountName
        '''
        result = self._values.get("service_account_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sidecarimage(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheus#sidecarimage
        '''
        result = self._values.get("sidecarimage")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheus#storageClassName
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def topology_spread_constraints(
        self,
    ) -> typing.Optional[typing.List["TenantSpecPrometheusTopologySpreadConstraints"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheus#topologySpreadConstraints
        '''
        result = self._values.get("topology_spread_constraints")
        return typing.cast(typing.Optional[typing.List["TenantSpecPrometheusTopologySpreadConstraints"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheus(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinity",
    jsii_struct_bases=[],
    name_mapping={
        "node_affinity": "nodeAffinity",
        "pod_affinity": "podAffinity",
        "pod_anti_affinity": "podAntiAffinity",
    },
)
class TenantSpecPrometheusAffinity:
    def __init__(
        self,
        *,
        node_affinity: typing.Optional[typing.Union["TenantSpecPrometheusAffinityNodeAffinity", typing.Dict[str, typing.Any]]] = None,
        pod_affinity: typing.Optional[typing.Union["TenantSpecPrometheusAffinityPodAffinity", typing.Dict[str, typing.Any]]] = None,
        pod_anti_affinity: typing.Optional[typing.Union["TenantSpecPrometheusAffinityPodAntiAffinity", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param node_affinity: 
        :param pod_affinity: 
        :param pod_anti_affinity: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinity
        '''
        if isinstance(node_affinity, dict):
            node_affinity = TenantSpecPrometheusAffinityNodeAffinity(**node_affinity)
        if isinstance(pod_affinity, dict):
            pod_affinity = TenantSpecPrometheusAffinityPodAffinity(**pod_affinity)
        if isinstance(pod_anti_affinity, dict):
            pod_anti_affinity = TenantSpecPrometheusAffinityPodAntiAffinity(**pod_anti_affinity)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinity.__init__)
            check_type(argname="argument node_affinity", value=node_affinity, expected_type=type_hints["node_affinity"])
            check_type(argname="argument pod_affinity", value=pod_affinity, expected_type=type_hints["pod_affinity"])
            check_type(argname="argument pod_anti_affinity", value=pod_anti_affinity, expected_type=type_hints["pod_anti_affinity"])
        self._values: typing.Dict[str, typing.Any] = {}
        if node_affinity is not None:
            self._values["node_affinity"] = node_affinity
        if pod_affinity is not None:
            self._values["pod_affinity"] = pod_affinity
        if pod_anti_affinity is not None:
            self._values["pod_anti_affinity"] = pod_anti_affinity

    @builtins.property
    def node_affinity(
        self,
    ) -> typing.Optional["TenantSpecPrometheusAffinityNodeAffinity"]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinity#nodeAffinity
        '''
        result = self._values.get("node_affinity")
        return typing.cast(typing.Optional["TenantSpecPrometheusAffinityNodeAffinity"], result)

    @builtins.property
    def pod_affinity(
        self,
    ) -> typing.Optional["TenantSpecPrometheusAffinityPodAffinity"]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinity#podAffinity
        '''
        result = self._values.get("pod_affinity")
        return typing.cast(typing.Optional["TenantSpecPrometheusAffinityPodAffinity"], result)

    @builtins.property
    def pod_anti_affinity(
        self,
    ) -> typing.Optional["TenantSpecPrometheusAffinityPodAntiAffinity"]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinity#podAntiAffinity
        '''
        result = self._values.get("pod_anti_affinity")
        return typing.cast(typing.Optional["TenantSpecPrometheusAffinityPodAntiAffinity"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityNodeAffinity",
    jsii_struct_bases=[],
    name_mapping={
        "preferred_during_scheduling_ignored_during_execution": "preferredDuringSchedulingIgnoredDuringExecution",
        "required_during_scheduling_ignored_during_execution": "requiredDuringSchedulingIgnoredDuringExecution",
    },
)
class TenantSpecPrometheusAffinityNodeAffinity:
    def __init__(
        self,
        *,
        preferred_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
        required_during_scheduling_ignored_during_execution: typing.Optional[typing.Union["TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param preferred_during_scheduling_ignored_during_execution: 
        :param required_during_scheduling_ignored_during_execution: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinity
        '''
        if isinstance(required_during_scheduling_ignored_during_execution, dict):
            required_during_scheduling_ignored_during_execution = TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(**required_during_scheduling_ignored_during_execution)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityNodeAffinity.__init__)
            check_type(argname="argument preferred_during_scheduling_ignored_during_execution", value=preferred_during_scheduling_ignored_during_execution, expected_type=type_hints["preferred_during_scheduling_ignored_during_execution"])
            check_type(argname="argument required_during_scheduling_ignored_during_execution", value=required_during_scheduling_ignored_during_execution, expected_type=type_hints["required_during_scheduling_ignored_during_execution"])
        self._values: typing.Dict[str, typing.Any] = {}
        if preferred_during_scheduling_ignored_during_execution is not None:
            self._values["preferred_during_scheduling_ignored_during_execution"] = preferred_during_scheduling_ignored_during_execution
        if required_during_scheduling_ignored_during_execution is not None:
            self._values["required_during_scheduling_ignored_during_execution"] = required_during_scheduling_ignored_during_execution

    @builtins.property
    def preferred_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinity#preferredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("preferred_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution"]], result)

    @builtins.property
    def required_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional["TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution"]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinity#requiredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("required_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional["TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityNodeAffinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={"preference": "preference", "weight": "weight"},
)
class TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        preference: typing.Union["TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference", typing.Dict[str, typing.Any]],
        weight: jsii.Number,
    ) -> None:
        '''
        :param preference: 
        :param weight: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(preference, dict):
            preference = TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(**preference)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument preference", value=preference, expected_type=type_hints["preference"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[str, typing.Any] = {
            "preference": preference,
            "weight": weight,
        }

    @builtins.property
    def preference(
        self,
    ) -> "TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference":
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#preference
        '''
        result = self._values.get("preference")
        assert result is not None, "Required property 'preference' is missing"
        return typing.cast("TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference", result)

    @builtins.property
    def weight(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
        '''
        result = self._values.get("weight")
        assert result is not None, "Required property 'weight' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_fields": "matchFields",
    },
)
class TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_fields: typing.Optional[typing.Sequence[typing.Union["TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_fields: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_fields", value=match_fields, expected_type=type_hints["match_fields"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_fields is not None:
            self._values["match_fields"] = match_fields

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions"]], result)

    @builtins.property
    def match_fields(
        self,
    ) -> typing.Optional[typing.List["TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchFields
        '''
        result = self._values.get("match_fields")
        return typing.cast(typing.Optional[typing.List["TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={"node_selector_terms": "nodeSelectorTerms"},
)
class TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        node_selector_terms: typing.Sequence[typing.Union["TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms", typing.Dict[str, typing.Any]]],
    ) -> None:
        '''
        :param node_selector_terms: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument node_selector_terms", value=node_selector_terms, expected_type=type_hints["node_selector_terms"])
        self._values: typing.Dict[str, typing.Any] = {
            "node_selector_terms": node_selector_terms,
        }

    @builtins.property
    def node_selector_terms(
        self,
    ) -> typing.List["TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms"]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution#nodeSelectorTerms
        '''
        result = self._values.get("node_selector_terms")
        assert result is not None, "Required property 'node_selector_terms' is missing"
        return typing.cast(typing.List["TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_fields": "matchFields",
    },
)
class TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_fields: typing.Optional[typing.Sequence[typing.Union["TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_fields: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_fields", value=match_fields, expected_type=type_hints["match_fields"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_fields is not None:
            self._values["match_fields"] = match_fields

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions"]], result)

    @builtins.property
    def match_fields(
        self,
    ) -> typing.Optional[typing.List["TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchFields
        '''
        result = self._values.get("match_fields")
        return typing.cast(typing.Optional[typing.List["TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityPodAffinity",
    jsii_struct_bases=[],
    name_mapping={
        "preferred_during_scheduling_ignored_during_execution": "preferredDuringSchedulingIgnoredDuringExecution",
        "required_during_scheduling_ignored_during_execution": "requiredDuringSchedulingIgnoredDuringExecution",
    },
)
class TenantSpecPrometheusAffinityPodAffinity:
    def __init__(
        self,
        *,
        preferred_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
        required_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param preferred_during_scheduling_ignored_during_execution: 
        :param required_during_scheduling_ignored_during_execution: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityPodAffinity.__init__)
            check_type(argname="argument preferred_during_scheduling_ignored_during_execution", value=preferred_during_scheduling_ignored_during_execution, expected_type=type_hints["preferred_during_scheduling_ignored_during_execution"])
            check_type(argname="argument required_during_scheduling_ignored_during_execution", value=required_during_scheduling_ignored_during_execution, expected_type=type_hints["required_during_scheduling_ignored_during_execution"])
        self._values: typing.Dict[str, typing.Any] = {}
        if preferred_during_scheduling_ignored_during_execution is not None:
            self._values["preferred_during_scheduling_ignored_during_execution"] = preferred_during_scheduling_ignored_during_execution
        if required_during_scheduling_ignored_during_execution is not None:
            self._values["required_during_scheduling_ignored_during_execution"] = required_during_scheduling_ignored_during_execution

    @builtins.property
    def preferred_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinity#preferredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("preferred_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution"]], result)

    @builtins.property
    def required_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinity#requiredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("required_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityPodAffinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={"pod_affinity_term": "podAffinityTerm", "weight": "weight"},
)
class TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        pod_affinity_term: typing.Union["TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm", typing.Dict[str, typing.Any]],
        weight: jsii.Number,
    ) -> None:
        '''
        :param pod_affinity_term: 
        :param weight: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(pod_affinity_term, dict):
            pod_affinity_term = TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(**pod_affinity_term)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument pod_affinity_term", value=pod_affinity_term, expected_type=type_hints["pod_affinity_term"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[str, typing.Any] = {
            "pod_affinity_term": pod_affinity_term,
            "weight": weight,
        }

    @builtins.property
    def pod_affinity_term(
        self,
    ) -> "TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm":
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
        '''
        result = self._values.get("pod_affinity_term")
        assert result is not None, "Required property 'pod_affinity_term' is missing"
        return typing.cast("TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm", result)

    @builtins.property
    def weight(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
        '''
        result = self._values.get("weight")
        assert result is not None, "Required property 'weight' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm",
    jsii_struct_bases=[],
    name_mapping={
        "topology_key": "topologyKey",
        "label_selector": "labelSelector",
        "namespaces": "namespaces",
    },
)
class TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm:
    def __init__(
        self,
        *,
        topology_key: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector", typing.Dict[str, typing.Any]]] = None,
        namespaces: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param topology_key: 
        :param label_selector: 
        :param namespaces: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm.__init__)
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[str, typing.Any] = {
            "topology_key": topology_key,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector"], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={
        "topology_key": "topologyKey",
        "label_selector": "labelSelector",
        "namespaces": "namespaces",
    },
)
class TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        topology_key: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector", typing.Dict[str, typing.Any]]] = None,
        namespaces: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param topology_key: 
        :param label_selector: 
        :param namespaces: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[str, typing.Any] = {
            "topology_key": topology_key,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector"], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityPodAntiAffinity",
    jsii_struct_bases=[],
    name_mapping={
        "preferred_during_scheduling_ignored_during_execution": "preferredDuringSchedulingIgnoredDuringExecution",
        "required_during_scheduling_ignored_during_execution": "requiredDuringSchedulingIgnoredDuringExecution",
    },
)
class TenantSpecPrometheusAffinityPodAntiAffinity:
    def __init__(
        self,
        *,
        preferred_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
        required_during_scheduling_ignored_during_execution: typing.Optional[typing.Sequence[typing.Union["TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param preferred_during_scheduling_ignored_during_execution: 
        :param required_during_scheduling_ignored_during_execution: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityPodAntiAffinity.__init__)
            check_type(argname="argument preferred_during_scheduling_ignored_during_execution", value=preferred_during_scheduling_ignored_during_execution, expected_type=type_hints["preferred_during_scheduling_ignored_during_execution"])
            check_type(argname="argument required_during_scheduling_ignored_during_execution", value=required_during_scheduling_ignored_during_execution, expected_type=type_hints["required_during_scheduling_ignored_during_execution"])
        self._values: typing.Dict[str, typing.Any] = {}
        if preferred_during_scheduling_ignored_during_execution is not None:
            self._values["preferred_during_scheduling_ignored_during_execution"] = preferred_during_scheduling_ignored_during_execution
        if required_during_scheduling_ignored_during_execution is not None:
            self._values["required_during_scheduling_ignored_during_execution"] = required_during_scheduling_ignored_during_execution

    @builtins.property
    def preferred_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinity#preferredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("preferred_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution"]], result)

    @builtins.property
    def required_during_scheduling_ignored_during_execution(
        self,
    ) -> typing.Optional[typing.List["TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinity#requiredDuringSchedulingIgnoredDuringExecution
        '''
        result = self._values.get("required_during_scheduling_ignored_during_execution")
        return typing.cast(typing.Optional[typing.List["TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityPodAntiAffinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={"pod_affinity_term": "podAffinityTerm", "weight": "weight"},
)
class TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        pod_affinity_term: typing.Union["TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm", typing.Dict[str, typing.Any]],
        weight: jsii.Number,
    ) -> None:
        '''
        :param pod_affinity_term: 
        :param weight: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(pod_affinity_term, dict):
            pod_affinity_term = TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(**pod_affinity_term)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument pod_affinity_term", value=pod_affinity_term, expected_type=type_hints["pod_affinity_term"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[str, typing.Any] = {
            "pod_affinity_term": pod_affinity_term,
            "weight": weight,
        }

    @builtins.property
    def pod_affinity_term(
        self,
    ) -> "TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm":
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
        '''
        result = self._values.get("pod_affinity_term")
        assert result is not None, "Required property 'pod_affinity_term' is missing"
        return typing.cast("TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm", result)

    @builtins.property
    def weight(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
        '''
        result = self._values.get("weight")
        assert result is not None, "Required property 'weight' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm",
    jsii_struct_bases=[],
    name_mapping={
        "topology_key": "topologyKey",
        "label_selector": "labelSelector",
        "namespaces": "namespaces",
    },
)
class TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm:
    def __init__(
        self,
        *,
        topology_key: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector", typing.Dict[str, typing.Any]]] = None,
        namespaces: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param topology_key: 
        :param label_selector: 
        :param namespaces: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm.__init__)
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[str, typing.Any] = {
            "topology_key": topology_key,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector"], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution",
    jsii_struct_bases=[],
    name_mapping={
        "topology_key": "topologyKey",
        "label_selector": "labelSelector",
        "namespaces": "namespaces",
    },
)
class TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution:
    def __init__(
        self,
        *,
        topology_key: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector", typing.Dict[str, typing.Any]]] = None,
        namespaces: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param topology_key: 
        :param label_selector: 
        :param namespaces: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution.__init__)
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[str, typing.Any] = {
            "topology_key": topology_key,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector"], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusResources",
    jsii_struct_bases=[],
    name_mapping={"limits": "limits", "requests": "requests"},
)
class TenantSpecPrometheusResources:
    def __init__(
        self,
        *,
        limits: typing.Optional[typing.Mapping[builtins.str, "TenantSpecPrometheusResourcesLimits"]] = None,
        requests: typing.Optional[typing.Mapping[builtins.str, "TenantSpecPrometheusResourcesRequests"]] = None,
    ) -> None:
        '''
        :param limits: 
        :param requests: 

        :stability: experimental
        :schema: TenantSpecPrometheusResources
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusResources.__init__)
            check_type(argname="argument limits", value=limits, expected_type=type_hints["limits"])
            check_type(argname="argument requests", value=requests, expected_type=type_hints["requests"])
        self._values: typing.Dict[str, typing.Any] = {}
        if limits is not None:
            self._values["limits"] = limits
        if requests is not None:
            self._values["requests"] = requests

    @builtins.property
    def limits(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "TenantSpecPrometheusResourcesLimits"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusResources#limits
        '''
        result = self._values.get("limits")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "TenantSpecPrometheusResourcesLimits"]], result)

    @builtins.property
    def requests(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "TenantSpecPrometheusResourcesRequests"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusResources#requests
        '''
        result = self._values.get("requests")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "TenantSpecPrometheusResourcesRequests"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecPrometheusResourcesLimits(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusResourcesLimits",
):
    '''
    :stability: experimental
    :schema: TenantSpecPrometheusResourcesLimits
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(cls, value: jsii.Number) -> "TenantSpecPrometheusResourcesLimits":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusResourcesLimits.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecPrometheusResourcesLimits", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(cls, value: builtins.str) -> "TenantSpecPrometheusResourcesLimits":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusResourcesLimits.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecPrometheusResourcesLimits", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


class TenantSpecPrometheusResourcesRequests(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusResourcesRequests",
):
    '''
    :stability: experimental
    :schema: TenantSpecPrometheusResourcesRequests
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(cls, value: jsii.Number) -> "TenantSpecPrometheusResourcesRequests":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusResourcesRequests.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecPrometheusResourcesRequests", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecPrometheusResourcesRequests":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusResourcesRequests.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecPrometheusResourcesRequests", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusSecurityContext",
    jsii_struct_bases=[],
    name_mapping={
        "fs_group": "fsGroup",
        "fs_group_change_policy": "fsGroupChangePolicy",
        "run_as_group": "runAsGroup",
        "run_as_non_root": "runAsNonRoot",
        "run_as_user": "runAsUser",
        "seccomp_profile": "seccompProfile",
        "se_linux_options": "seLinuxOptions",
        "supplemental_groups": "supplementalGroups",
        "sysctls": "sysctls",
        "windows_options": "windowsOptions",
    },
)
class TenantSpecPrometheusSecurityContext:
    def __init__(
        self,
        *,
        fs_group: typing.Optional[jsii.Number] = None,
        fs_group_change_policy: typing.Optional[builtins.str] = None,
        run_as_group: typing.Optional[jsii.Number] = None,
        run_as_non_root: typing.Optional[builtins.bool] = None,
        run_as_user: typing.Optional[jsii.Number] = None,
        seccomp_profile: typing.Optional[typing.Union["TenantSpecPrometheusSecurityContextSeccompProfile", typing.Dict[str, typing.Any]]] = None,
        se_linux_options: typing.Optional[typing.Union["TenantSpecPrometheusSecurityContextSeLinuxOptions", typing.Dict[str, typing.Any]]] = None,
        supplemental_groups: typing.Optional[typing.Sequence[jsii.Number]] = None,
        sysctls: typing.Optional[typing.Sequence[typing.Union["TenantSpecPrometheusSecurityContextSysctls", typing.Dict[str, typing.Any]]]] = None,
        windows_options: typing.Optional[typing.Union["TenantSpecPrometheusSecurityContextWindowsOptions", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param fs_group: 
        :param fs_group_change_policy: 
        :param run_as_group: 
        :param run_as_non_root: 
        :param run_as_user: 
        :param seccomp_profile: 
        :param se_linux_options: 
        :param supplemental_groups: 
        :param sysctls: 
        :param windows_options: 

        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContext
        '''
        if isinstance(seccomp_profile, dict):
            seccomp_profile = TenantSpecPrometheusSecurityContextSeccompProfile(**seccomp_profile)
        if isinstance(se_linux_options, dict):
            se_linux_options = TenantSpecPrometheusSecurityContextSeLinuxOptions(**se_linux_options)
        if isinstance(windows_options, dict):
            windows_options = TenantSpecPrometheusSecurityContextWindowsOptions(**windows_options)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusSecurityContext.__init__)
            check_type(argname="argument fs_group", value=fs_group, expected_type=type_hints["fs_group"])
            check_type(argname="argument fs_group_change_policy", value=fs_group_change_policy, expected_type=type_hints["fs_group_change_policy"])
            check_type(argname="argument run_as_group", value=run_as_group, expected_type=type_hints["run_as_group"])
            check_type(argname="argument run_as_non_root", value=run_as_non_root, expected_type=type_hints["run_as_non_root"])
            check_type(argname="argument run_as_user", value=run_as_user, expected_type=type_hints["run_as_user"])
            check_type(argname="argument seccomp_profile", value=seccomp_profile, expected_type=type_hints["seccomp_profile"])
            check_type(argname="argument se_linux_options", value=se_linux_options, expected_type=type_hints["se_linux_options"])
            check_type(argname="argument supplemental_groups", value=supplemental_groups, expected_type=type_hints["supplemental_groups"])
            check_type(argname="argument sysctls", value=sysctls, expected_type=type_hints["sysctls"])
            check_type(argname="argument windows_options", value=windows_options, expected_type=type_hints["windows_options"])
        self._values: typing.Dict[str, typing.Any] = {}
        if fs_group is not None:
            self._values["fs_group"] = fs_group
        if fs_group_change_policy is not None:
            self._values["fs_group_change_policy"] = fs_group_change_policy
        if run_as_group is not None:
            self._values["run_as_group"] = run_as_group
        if run_as_non_root is not None:
            self._values["run_as_non_root"] = run_as_non_root
        if run_as_user is not None:
            self._values["run_as_user"] = run_as_user
        if seccomp_profile is not None:
            self._values["seccomp_profile"] = seccomp_profile
        if se_linux_options is not None:
            self._values["se_linux_options"] = se_linux_options
        if supplemental_groups is not None:
            self._values["supplemental_groups"] = supplemental_groups
        if sysctls is not None:
            self._values["sysctls"] = sysctls
        if windows_options is not None:
            self._values["windows_options"] = windows_options

    @builtins.property
    def fs_group(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContext#fsGroup
        '''
        result = self._values.get("fs_group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fs_group_change_policy(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContext#fsGroupChangePolicy
        '''
        result = self._values.get("fs_group_change_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def run_as_group(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContext#runAsGroup
        '''
        result = self._values.get("run_as_group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def run_as_non_root(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContext#runAsNonRoot
        '''
        result = self._values.get("run_as_non_root")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def run_as_user(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContext#runAsUser
        '''
        result = self._values.get("run_as_user")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def seccomp_profile(
        self,
    ) -> typing.Optional["TenantSpecPrometheusSecurityContextSeccompProfile"]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContext#seccompProfile
        '''
        result = self._values.get("seccomp_profile")
        return typing.cast(typing.Optional["TenantSpecPrometheusSecurityContextSeccompProfile"], result)

    @builtins.property
    def se_linux_options(
        self,
    ) -> typing.Optional["TenantSpecPrometheusSecurityContextSeLinuxOptions"]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContext#seLinuxOptions
        '''
        result = self._values.get("se_linux_options")
        return typing.cast(typing.Optional["TenantSpecPrometheusSecurityContextSeLinuxOptions"], result)

    @builtins.property
    def supplemental_groups(self) -> typing.Optional[typing.List[jsii.Number]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContext#supplementalGroups
        '''
        result = self._values.get("supplemental_groups")
        return typing.cast(typing.Optional[typing.List[jsii.Number]], result)

    @builtins.property
    def sysctls(
        self,
    ) -> typing.Optional[typing.List["TenantSpecPrometheusSecurityContextSysctls"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContext#sysctls
        '''
        result = self._values.get("sysctls")
        return typing.cast(typing.Optional[typing.List["TenantSpecPrometheusSecurityContextSysctls"]], result)

    @builtins.property
    def windows_options(
        self,
    ) -> typing.Optional["TenantSpecPrometheusSecurityContextWindowsOptions"]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContext#windowsOptions
        '''
        result = self._values.get("windows_options")
        return typing.cast(typing.Optional["TenantSpecPrometheusSecurityContextWindowsOptions"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusSecurityContext(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusSecurityContextSeLinuxOptions",
    jsii_struct_bases=[],
    name_mapping={"level": "level", "role": "role", "type": "type", "user": "user"},
)
class TenantSpecPrometheusSecurityContextSeLinuxOptions:
    def __init__(
        self,
        *,
        level: typing.Optional[builtins.str] = None,
        role: typing.Optional[builtins.str] = None,
        type: typing.Optional[builtins.str] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param level: 
        :param role: 
        :param type: 
        :param user: 

        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContextSeLinuxOptions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusSecurityContextSeLinuxOptions.__init__)
            check_type(argname="argument level", value=level, expected_type=type_hints["level"])
            check_type(argname="argument role", value=role, expected_type=type_hints["role"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[str, typing.Any] = {}
        if level is not None:
            self._values["level"] = level
        if role is not None:
            self._values["role"] = role
        if type is not None:
            self._values["type"] = type
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def level(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContextSeLinuxOptions#level
        '''
        result = self._values.get("level")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def role(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContextSeLinuxOptions#role
        '''
        result = self._values.get("role")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContextSeLinuxOptions#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContextSeLinuxOptions#user
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusSecurityContextSeLinuxOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusSecurityContextSeccompProfile",
    jsii_struct_bases=[],
    name_mapping={"type": "type", "localhost_profile": "localhostProfile"},
)
class TenantSpecPrometheusSecurityContextSeccompProfile:
    def __init__(
        self,
        *,
        type: builtins.str,
        localhost_profile: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param type: 
        :param localhost_profile: 

        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContextSeccompProfile
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusSecurityContextSeccompProfile.__init__)
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument localhost_profile", value=localhost_profile, expected_type=type_hints["localhost_profile"])
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
        }
        if localhost_profile is not None:
            self._values["localhost_profile"] = localhost_profile

    @builtins.property
    def type(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContextSeccompProfile#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def localhost_profile(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContextSeccompProfile#localhostProfile
        '''
        result = self._values.get("localhost_profile")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusSecurityContextSeccompProfile(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusSecurityContextSysctls",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class TenantSpecPrometheusSecurityContextSysctls:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        '''
        :param name: 
        :param value: 

        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContextSysctls
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusSecurityContextSysctls.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContextSysctls#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContextSysctls#value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusSecurityContextSysctls(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusSecurityContextWindowsOptions",
    jsii_struct_bases=[],
    name_mapping={
        "gmsa_credential_spec": "gmsaCredentialSpec",
        "gmsa_credential_spec_name": "gmsaCredentialSpecName",
        "run_as_user_name": "runAsUserName",
    },
)
class TenantSpecPrometheusSecurityContextWindowsOptions:
    def __init__(
        self,
        *,
        gmsa_credential_spec: typing.Optional[builtins.str] = None,
        gmsa_credential_spec_name: typing.Optional[builtins.str] = None,
        run_as_user_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param gmsa_credential_spec: 
        :param gmsa_credential_spec_name: 
        :param run_as_user_name: 

        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContextWindowsOptions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusSecurityContextWindowsOptions.__init__)
            check_type(argname="argument gmsa_credential_spec", value=gmsa_credential_spec, expected_type=type_hints["gmsa_credential_spec"])
            check_type(argname="argument gmsa_credential_spec_name", value=gmsa_credential_spec_name, expected_type=type_hints["gmsa_credential_spec_name"])
            check_type(argname="argument run_as_user_name", value=run_as_user_name, expected_type=type_hints["run_as_user_name"])
        self._values: typing.Dict[str, typing.Any] = {}
        if gmsa_credential_spec is not None:
            self._values["gmsa_credential_spec"] = gmsa_credential_spec
        if gmsa_credential_spec_name is not None:
            self._values["gmsa_credential_spec_name"] = gmsa_credential_spec_name
        if run_as_user_name is not None:
            self._values["run_as_user_name"] = run_as_user_name

    @builtins.property
    def gmsa_credential_spec(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContextWindowsOptions#gmsaCredentialSpec
        '''
        result = self._values.get("gmsa_credential_spec")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def gmsa_credential_spec_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContextWindowsOptions#gmsaCredentialSpecName
        '''
        result = self._values.get("gmsa_credential_spec_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def run_as_user_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusSecurityContextWindowsOptions#runAsUserName
        '''
        result = self._values.get("run_as_user_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusSecurityContextWindowsOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusTopologySpreadConstraints",
    jsii_struct_bases=[],
    name_mapping={
        "max_skew": "maxSkew",
        "topology_key": "topologyKey",
        "when_unsatisfiable": "whenUnsatisfiable",
        "label_selector": "labelSelector",
    },
)
class TenantSpecPrometheusTopologySpreadConstraints:
    def __init__(
        self,
        *,
        max_skew: jsii.Number,
        topology_key: builtins.str,
        when_unsatisfiable: builtins.str,
        label_selector: typing.Optional[typing.Union["TenantSpecPrometheusTopologySpreadConstraintsLabelSelector", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param max_skew: 
        :param topology_key: 
        :param when_unsatisfiable: 
        :param label_selector: 

        :stability: experimental
        :schema: TenantSpecPrometheusTopologySpreadConstraints
        '''
        if isinstance(label_selector, dict):
            label_selector = TenantSpecPrometheusTopologySpreadConstraintsLabelSelector(**label_selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusTopologySpreadConstraints.__init__)
            check_type(argname="argument max_skew", value=max_skew, expected_type=type_hints["max_skew"])
            check_type(argname="argument topology_key", value=topology_key, expected_type=type_hints["topology_key"])
            check_type(argname="argument when_unsatisfiable", value=when_unsatisfiable, expected_type=type_hints["when_unsatisfiable"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
        self._values: typing.Dict[str, typing.Any] = {
            "max_skew": max_skew,
            "topology_key": topology_key,
            "when_unsatisfiable": when_unsatisfiable,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector

    @builtins.property
    def max_skew(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusTopologySpreadConstraints#maxSkew
        '''
        result = self._values.get("max_skew")
        assert result is not None, "Required property 'max_skew' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def topology_key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusTopologySpreadConstraints#topologyKey
        '''
        result = self._values.get("topology_key")
        assert result is not None, "Required property 'topology_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def when_unsatisfiable(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusTopologySpreadConstraints#whenUnsatisfiable
        '''
        result = self._values.get("when_unsatisfiable")
        assert result is not None, "Required property 'when_unsatisfiable' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector(
        self,
    ) -> typing.Optional["TenantSpecPrometheusTopologySpreadConstraintsLabelSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusTopologySpreadConstraints#labelSelector
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional["TenantSpecPrometheusTopologySpreadConstraintsLabelSelector"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusTopologySpreadConstraints(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusTopologySpreadConstraintsLabelSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecPrometheusTopologySpreadConstraintsLabelSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecPrometheusTopologySpreadConstraintsLabelSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusTopologySpreadConstraintsLabelSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusTopologySpreadConstraintsLabelSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusTopologySpreadConstraintsLabelSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusTopologySpreadConstraintsLabelSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecS3",
    jsii_struct_bases=[],
    name_mapping={"bucket_dns": "bucketDns"},
)
class TenantSpecS3:
    def __init__(self, *, bucket_dns: typing.Optional[builtins.bool] = None) -> None:
        '''
        :param bucket_dns: 

        :stability: experimental
        :schema: TenantSpecS3
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecS3.__init__)
            check_type(argname="argument bucket_dns", value=bucket_dns, expected_type=type_hints["bucket_dns"])
        self._values: typing.Dict[str, typing.Any] = {}
        if bucket_dns is not None:
            self._values["bucket_dns"] = bucket_dns

    @builtins.property
    def bucket_dns(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecS3#bucketDNS
        '''
        result = self._values.get("bucket_dns")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecS3(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSecurityContext",
    jsii_struct_bases=[],
    name_mapping={
        "fs_group": "fsGroup",
        "fs_group_change_policy": "fsGroupChangePolicy",
        "run_as_group": "runAsGroup",
        "run_as_non_root": "runAsNonRoot",
        "run_as_user": "runAsUser",
        "seccomp_profile": "seccompProfile",
        "se_linux_options": "seLinuxOptions",
        "supplemental_groups": "supplementalGroups",
        "sysctls": "sysctls",
        "windows_options": "windowsOptions",
    },
)
class TenantSpecSecurityContext:
    def __init__(
        self,
        *,
        fs_group: typing.Optional[jsii.Number] = None,
        fs_group_change_policy: typing.Optional[builtins.str] = None,
        run_as_group: typing.Optional[jsii.Number] = None,
        run_as_non_root: typing.Optional[builtins.bool] = None,
        run_as_user: typing.Optional[jsii.Number] = None,
        seccomp_profile: typing.Optional[typing.Union["TenantSpecSecurityContextSeccompProfile", typing.Dict[str, typing.Any]]] = None,
        se_linux_options: typing.Optional[typing.Union["TenantSpecSecurityContextSeLinuxOptions", typing.Dict[str, typing.Any]]] = None,
        supplemental_groups: typing.Optional[typing.Sequence[jsii.Number]] = None,
        sysctls: typing.Optional[typing.Sequence[typing.Union["TenantSpecSecurityContextSysctls", typing.Dict[str, typing.Any]]]] = None,
        windows_options: typing.Optional[typing.Union["TenantSpecSecurityContextWindowsOptions", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param fs_group: 
        :param fs_group_change_policy: 
        :param run_as_group: 
        :param run_as_non_root: 
        :param run_as_user: 
        :param seccomp_profile: 
        :param se_linux_options: 
        :param supplemental_groups: 
        :param sysctls: 
        :param windows_options: 

        :stability: experimental
        :schema: TenantSpecSecurityContext
        '''
        if isinstance(seccomp_profile, dict):
            seccomp_profile = TenantSpecSecurityContextSeccompProfile(**seccomp_profile)
        if isinstance(se_linux_options, dict):
            se_linux_options = TenantSpecSecurityContextSeLinuxOptions(**se_linux_options)
        if isinstance(windows_options, dict):
            windows_options = TenantSpecSecurityContextWindowsOptions(**windows_options)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSecurityContext.__init__)
            check_type(argname="argument fs_group", value=fs_group, expected_type=type_hints["fs_group"])
            check_type(argname="argument fs_group_change_policy", value=fs_group_change_policy, expected_type=type_hints["fs_group_change_policy"])
            check_type(argname="argument run_as_group", value=run_as_group, expected_type=type_hints["run_as_group"])
            check_type(argname="argument run_as_non_root", value=run_as_non_root, expected_type=type_hints["run_as_non_root"])
            check_type(argname="argument run_as_user", value=run_as_user, expected_type=type_hints["run_as_user"])
            check_type(argname="argument seccomp_profile", value=seccomp_profile, expected_type=type_hints["seccomp_profile"])
            check_type(argname="argument se_linux_options", value=se_linux_options, expected_type=type_hints["se_linux_options"])
            check_type(argname="argument supplemental_groups", value=supplemental_groups, expected_type=type_hints["supplemental_groups"])
            check_type(argname="argument sysctls", value=sysctls, expected_type=type_hints["sysctls"])
            check_type(argname="argument windows_options", value=windows_options, expected_type=type_hints["windows_options"])
        self._values: typing.Dict[str, typing.Any] = {}
        if fs_group is not None:
            self._values["fs_group"] = fs_group
        if fs_group_change_policy is not None:
            self._values["fs_group_change_policy"] = fs_group_change_policy
        if run_as_group is not None:
            self._values["run_as_group"] = run_as_group
        if run_as_non_root is not None:
            self._values["run_as_non_root"] = run_as_non_root
        if run_as_user is not None:
            self._values["run_as_user"] = run_as_user
        if seccomp_profile is not None:
            self._values["seccomp_profile"] = seccomp_profile
        if se_linux_options is not None:
            self._values["se_linux_options"] = se_linux_options
        if supplemental_groups is not None:
            self._values["supplemental_groups"] = supplemental_groups
        if sysctls is not None:
            self._values["sysctls"] = sysctls
        if windows_options is not None:
            self._values["windows_options"] = windows_options

    @builtins.property
    def fs_group(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContext#fsGroup
        '''
        result = self._values.get("fs_group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fs_group_change_policy(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContext#fsGroupChangePolicy
        '''
        result = self._values.get("fs_group_change_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def run_as_group(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContext#runAsGroup
        '''
        result = self._values.get("run_as_group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def run_as_non_root(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContext#runAsNonRoot
        '''
        result = self._values.get("run_as_non_root")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def run_as_user(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContext#runAsUser
        '''
        result = self._values.get("run_as_user")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def seccomp_profile(
        self,
    ) -> typing.Optional["TenantSpecSecurityContextSeccompProfile"]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContext#seccompProfile
        '''
        result = self._values.get("seccomp_profile")
        return typing.cast(typing.Optional["TenantSpecSecurityContextSeccompProfile"], result)

    @builtins.property
    def se_linux_options(
        self,
    ) -> typing.Optional["TenantSpecSecurityContextSeLinuxOptions"]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContext#seLinuxOptions
        '''
        result = self._values.get("se_linux_options")
        return typing.cast(typing.Optional["TenantSpecSecurityContextSeLinuxOptions"], result)

    @builtins.property
    def supplemental_groups(self) -> typing.Optional[typing.List[jsii.Number]]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContext#supplementalGroups
        '''
        result = self._values.get("supplemental_groups")
        return typing.cast(typing.Optional[typing.List[jsii.Number]], result)

    @builtins.property
    def sysctls(
        self,
    ) -> typing.Optional[typing.List["TenantSpecSecurityContextSysctls"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContext#sysctls
        '''
        result = self._values.get("sysctls")
        return typing.cast(typing.Optional[typing.List["TenantSpecSecurityContextSysctls"]], result)

    @builtins.property
    def windows_options(
        self,
    ) -> typing.Optional["TenantSpecSecurityContextWindowsOptions"]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContext#windowsOptions
        '''
        result = self._values.get("windows_options")
        return typing.cast(typing.Optional["TenantSpecSecurityContextWindowsOptions"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSecurityContext(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSecurityContextSeLinuxOptions",
    jsii_struct_bases=[],
    name_mapping={"level": "level", "role": "role", "type": "type", "user": "user"},
)
class TenantSpecSecurityContextSeLinuxOptions:
    def __init__(
        self,
        *,
        level: typing.Optional[builtins.str] = None,
        role: typing.Optional[builtins.str] = None,
        type: typing.Optional[builtins.str] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param level: 
        :param role: 
        :param type: 
        :param user: 

        :stability: experimental
        :schema: TenantSpecSecurityContextSeLinuxOptions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSecurityContextSeLinuxOptions.__init__)
            check_type(argname="argument level", value=level, expected_type=type_hints["level"])
            check_type(argname="argument role", value=role, expected_type=type_hints["role"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[str, typing.Any] = {}
        if level is not None:
            self._values["level"] = level
        if role is not None:
            self._values["role"] = role
        if type is not None:
            self._values["type"] = type
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def level(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContextSeLinuxOptions#level
        '''
        result = self._values.get("level")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def role(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContextSeLinuxOptions#role
        '''
        result = self._values.get("role")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContextSeLinuxOptions#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContextSeLinuxOptions#user
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSecurityContextSeLinuxOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSecurityContextSeccompProfile",
    jsii_struct_bases=[],
    name_mapping={"type": "type", "localhost_profile": "localhostProfile"},
)
class TenantSpecSecurityContextSeccompProfile:
    def __init__(
        self,
        *,
        type: builtins.str,
        localhost_profile: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param type: 
        :param localhost_profile: 

        :stability: experimental
        :schema: TenantSpecSecurityContextSeccompProfile
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSecurityContextSeccompProfile.__init__)
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument localhost_profile", value=localhost_profile, expected_type=type_hints["localhost_profile"])
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
        }
        if localhost_profile is not None:
            self._values["localhost_profile"] = localhost_profile

    @builtins.property
    def type(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContextSeccompProfile#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def localhost_profile(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContextSeccompProfile#localhostProfile
        '''
        result = self._values.get("localhost_profile")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSecurityContextSeccompProfile(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSecurityContextSysctls",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class TenantSpecSecurityContextSysctls:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        '''
        :param name: 
        :param value: 

        :stability: experimental
        :schema: TenantSpecSecurityContextSysctls
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSecurityContextSysctls.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContextSysctls#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContextSysctls#value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSecurityContextSysctls(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSecurityContextWindowsOptions",
    jsii_struct_bases=[],
    name_mapping={
        "gmsa_credential_spec": "gmsaCredentialSpec",
        "gmsa_credential_spec_name": "gmsaCredentialSpecName",
        "run_as_user_name": "runAsUserName",
    },
)
class TenantSpecSecurityContextWindowsOptions:
    def __init__(
        self,
        *,
        gmsa_credential_spec: typing.Optional[builtins.str] = None,
        gmsa_credential_spec_name: typing.Optional[builtins.str] = None,
        run_as_user_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param gmsa_credential_spec: 
        :param gmsa_credential_spec_name: 
        :param run_as_user_name: 

        :stability: experimental
        :schema: TenantSpecSecurityContextWindowsOptions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSecurityContextWindowsOptions.__init__)
            check_type(argname="argument gmsa_credential_spec", value=gmsa_credential_spec, expected_type=type_hints["gmsa_credential_spec"])
            check_type(argname="argument gmsa_credential_spec_name", value=gmsa_credential_spec_name, expected_type=type_hints["gmsa_credential_spec_name"])
            check_type(argname="argument run_as_user_name", value=run_as_user_name, expected_type=type_hints["run_as_user_name"])
        self._values: typing.Dict[str, typing.Any] = {}
        if gmsa_credential_spec is not None:
            self._values["gmsa_credential_spec"] = gmsa_credential_spec
        if gmsa_credential_spec_name is not None:
            self._values["gmsa_credential_spec_name"] = gmsa_credential_spec_name
        if run_as_user_name is not None:
            self._values["run_as_user_name"] = run_as_user_name

    @builtins.property
    def gmsa_credential_spec(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContextWindowsOptions#gmsaCredentialSpec
        '''
        result = self._values.get("gmsa_credential_spec")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def gmsa_credential_spec_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContextWindowsOptions#gmsaCredentialSpecName
        '''
        result = self._values.get("gmsa_credential_spec_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def run_as_user_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSecurityContextWindowsOptions#runAsUserName
        '''
        result = self._values.get("run_as_user_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSecurityContextWindowsOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCars",
    jsii_struct_bases=[],
    name_mapping={
        "containers": "containers",
        "volume_claim_templates": "volumeClaimTemplates",
        "volumes": "volumes",
    },
)
class TenantSpecSideCars:
    def __init__(
        self,
        *,
        containers: typing.Sequence[typing.Union["TenantSpecSideCarsContainers", typing.Dict[str, typing.Any]]],
        volume_claim_templates: typing.Optional[typing.Sequence[typing.Union["TenantSpecSideCarsVolumeClaimTemplates", typing.Dict[str, typing.Any]]]] = None,
        volumes: typing.Optional[typing.Sequence[typing.Union["TenantSpecSideCarsVolumes", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param containers: 
        :param volume_claim_templates: 
        :param volumes: 

        :stability: experimental
        :schema: TenantSpecSideCars
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCars.__init__)
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument volume_claim_templates", value=volume_claim_templates, expected_type=type_hints["volume_claim_templates"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
        self._values: typing.Dict[str, typing.Any] = {
            "containers": containers,
        }
        if volume_claim_templates is not None:
            self._values["volume_claim_templates"] = volume_claim_templates
        if volumes is not None:
            self._values["volumes"] = volumes

    @builtins.property
    def containers(self) -> typing.List["TenantSpecSideCarsContainers"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCars#containers
        '''
        result = self._values.get("containers")
        assert result is not None, "Required property 'containers' is missing"
        return typing.cast(typing.List["TenantSpecSideCarsContainers"], result)

    @builtins.property
    def volume_claim_templates(
        self,
    ) -> typing.Optional[typing.List["TenantSpecSideCarsVolumeClaimTemplates"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCars#volumeClaimTemplates
        '''
        result = self._values.get("volume_claim_templates")
        return typing.cast(typing.Optional[typing.List["TenantSpecSideCarsVolumeClaimTemplates"]], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List["TenantSpecSideCarsVolumes"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCars#volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List["TenantSpecSideCarsVolumes"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCars(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainers",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "args": "args",
        "command": "command",
        "env": "env",
        "env_from": "envFrom",
        "image": "image",
        "image_pull_policy": "imagePullPolicy",
        "lifecycle": "lifecycle",
        "liveness_probe": "livenessProbe",
        "ports": "ports",
        "readiness_probe": "readinessProbe",
        "resources": "resources",
        "security_context": "securityContext",
        "startup_probe": "startupProbe",
        "stdin": "stdin",
        "stdin_once": "stdinOnce",
        "termination_message_path": "terminationMessagePath",
        "termination_message_policy": "terminationMessagePolicy",
        "tty": "tty",
        "volume_devices": "volumeDevices",
        "volume_mounts": "volumeMounts",
        "working_dir": "workingDir",
    },
)
class TenantSpecSideCarsContainers:
    def __init__(
        self,
        *,
        name: builtins.str,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env: typing.Optional[typing.Sequence[typing.Union["TenantSpecSideCarsContainersEnv", typing.Dict[str, typing.Any]]]] = None,
        env_from: typing.Optional[typing.Sequence[typing.Union["TenantSpecSideCarsContainersEnvFrom", typing.Dict[str, typing.Any]]]] = None,
        image: typing.Optional[builtins.str] = None,
        image_pull_policy: typing.Optional[builtins.str] = None,
        lifecycle: typing.Optional[typing.Union["TenantSpecSideCarsContainersLifecycle", typing.Dict[str, typing.Any]]] = None,
        liveness_probe: typing.Optional[typing.Union["TenantSpecSideCarsContainersLivenessProbe", typing.Dict[str, typing.Any]]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union["TenantSpecSideCarsContainersPorts", typing.Dict[str, typing.Any]]]] = None,
        readiness_probe: typing.Optional[typing.Union["TenantSpecSideCarsContainersReadinessProbe", typing.Dict[str, typing.Any]]] = None,
        resources: typing.Optional[typing.Union["TenantSpecSideCarsContainersResources", typing.Dict[str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union["TenantSpecSideCarsContainersSecurityContext", typing.Dict[str, typing.Any]]] = None,
        startup_probe: typing.Optional[typing.Union["TenantSpecSideCarsContainersStartupProbe", typing.Dict[str, typing.Any]]] = None,
        stdin: typing.Optional[builtins.bool] = None,
        stdin_once: typing.Optional[builtins.bool] = None,
        termination_message_path: typing.Optional[builtins.str] = None,
        termination_message_policy: typing.Optional[builtins.str] = None,
        tty: typing.Optional[builtins.bool] = None,
        volume_devices: typing.Optional[typing.Sequence[typing.Union["TenantSpecSideCarsContainersVolumeDevices", typing.Dict[str, typing.Any]]]] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union["TenantSpecSideCarsContainersVolumeMounts", typing.Dict[str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: 
        :param args: 
        :param command: 
        :param env: 
        :param env_from: 
        :param image: 
        :param image_pull_policy: 
        :param lifecycle: 
        :param liveness_probe: 
        :param ports: 
        :param readiness_probe: 
        :param resources: 
        :param security_context: 
        :param startup_probe: 
        :param stdin: 
        :param stdin_once: 
        :param termination_message_path: 
        :param termination_message_policy: 
        :param tty: 
        :param volume_devices: 
        :param volume_mounts: 
        :param working_dir: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainers
        '''
        if isinstance(lifecycle, dict):
            lifecycle = TenantSpecSideCarsContainersLifecycle(**lifecycle)
        if isinstance(liveness_probe, dict):
            liveness_probe = TenantSpecSideCarsContainersLivenessProbe(**liveness_probe)
        if isinstance(readiness_probe, dict):
            readiness_probe = TenantSpecSideCarsContainersReadinessProbe(**readiness_probe)
        if isinstance(resources, dict):
            resources = TenantSpecSideCarsContainersResources(**resources)
        if isinstance(security_context, dict):
            security_context = TenantSpecSideCarsContainersSecurityContext(**security_context)
        if isinstance(startup_probe, dict):
            startup_probe = TenantSpecSideCarsContainersStartupProbe(**startup_probe)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainers.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument args", value=args, expected_type=type_hints["args"])
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
            check_type(argname="argument env", value=env, expected_type=type_hints["env"])
            check_type(argname="argument env_from", value=env_from, expected_type=type_hints["env_from"])
            check_type(argname="argument image", value=image, expected_type=type_hints["image"])
            check_type(argname="argument image_pull_policy", value=image_pull_policy, expected_type=type_hints["image_pull_policy"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument liveness_probe", value=liveness_probe, expected_type=type_hints["liveness_probe"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument readiness_probe", value=readiness_probe, expected_type=type_hints["readiness_probe"])
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument startup_probe", value=startup_probe, expected_type=type_hints["startup_probe"])
            check_type(argname="argument stdin", value=stdin, expected_type=type_hints["stdin"])
            check_type(argname="argument stdin_once", value=stdin_once, expected_type=type_hints["stdin_once"])
            check_type(argname="argument termination_message_path", value=termination_message_path, expected_type=type_hints["termination_message_path"])
            check_type(argname="argument termination_message_policy", value=termination_message_policy, expected_type=type_hints["termination_message_policy"])
            check_type(argname="argument tty", value=tty, expected_type=type_hints["tty"])
            check_type(argname="argument volume_devices", value=volume_devices, expected_type=type_hints["volume_devices"])
            check_type(argname="argument volume_mounts", value=volume_mounts, expected_type=type_hints["volume_mounts"])
            check_type(argname="argument working_dir", value=working_dir, expected_type=type_hints["working_dir"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if args is not None:
            self._values["args"] = args
        if command is not None:
            self._values["command"] = command
        if env is not None:
            self._values["env"] = env
        if env_from is not None:
            self._values["env_from"] = env_from
        if image is not None:
            self._values["image"] = image
        if image_pull_policy is not None:
            self._values["image_pull_policy"] = image_pull_policy
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if liveness_probe is not None:
            self._values["liveness_probe"] = liveness_probe
        if ports is not None:
            self._values["ports"] = ports
        if readiness_probe is not None:
            self._values["readiness_probe"] = readiness_probe
        if resources is not None:
            self._values["resources"] = resources
        if security_context is not None:
            self._values["security_context"] = security_context
        if startup_probe is not None:
            self._values["startup_probe"] = startup_probe
        if stdin is not None:
            self._values["stdin"] = stdin
        if stdin_once is not None:
            self._values["stdin_once"] = stdin_once
        if termination_message_path is not None:
            self._values["termination_message_path"] = termination_message_path
        if termination_message_policy is not None:
            self._values["termination_message_policy"] = termination_message_policy
        if tty is not None:
            self._values["tty"] = tty
        if volume_devices is not None:
            self._values["volume_devices"] = volume_devices
        if volume_mounts is not None:
            self._values["volume_mounts"] = volume_mounts
        if working_dir is not None:
            self._values["working_dir"] = working_dir

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def args(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#args
        '''
        result = self._values.get("args")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#command
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def env(self) -> typing.Optional[typing.List["TenantSpecSideCarsContainersEnv"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#env
        '''
        result = self._values.get("env")
        return typing.cast(typing.Optional[typing.List["TenantSpecSideCarsContainersEnv"]], result)

    @builtins.property
    def env_from(
        self,
    ) -> typing.Optional[typing.List["TenantSpecSideCarsContainersEnvFrom"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#envFrom
        '''
        result = self._values.get("env_from")
        return typing.cast(typing.Optional[typing.List["TenantSpecSideCarsContainersEnvFrom"]], result)

    @builtins.property
    def image(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#image
        '''
        result = self._values.get("image")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def image_pull_policy(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#imagePullPolicy
        '''
        result = self._values.get("image_pull_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional["TenantSpecSideCarsContainersLifecycle"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#lifecycle
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersLifecycle"], result)

    @builtins.property
    def liveness_probe(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersLivenessProbe"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#livenessProbe
        '''
        result = self._values.get("liveness_probe")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersLivenessProbe"], result)

    @builtins.property
    def ports(
        self,
    ) -> typing.Optional[typing.List["TenantSpecSideCarsContainersPorts"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#ports
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List["TenantSpecSideCarsContainersPorts"]], result)

    @builtins.property
    def readiness_probe(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersReadinessProbe"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#readinessProbe
        '''
        result = self._values.get("readiness_probe")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersReadinessProbe"], result)

    @builtins.property
    def resources(self) -> typing.Optional["TenantSpecSideCarsContainersResources"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#resources
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersResources"], result)

    @builtins.property
    def security_context(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersSecurityContext"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#securityContext
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersSecurityContext"], result)

    @builtins.property
    def startup_probe(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersStartupProbe"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#startupProbe
        '''
        result = self._values.get("startup_probe")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersStartupProbe"], result)

    @builtins.property
    def stdin(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#stdin
        '''
        result = self._values.get("stdin")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def stdin_once(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#stdinOnce
        '''
        result = self._values.get("stdin_once")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def termination_message_path(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#terminationMessagePath
        '''
        result = self._values.get("termination_message_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def termination_message_policy(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#terminationMessagePolicy
        '''
        result = self._values.get("termination_message_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tty(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#tty
        '''
        result = self._values.get("tty")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def volume_devices(
        self,
    ) -> typing.Optional[typing.List["TenantSpecSideCarsContainersVolumeDevices"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#volumeDevices
        '''
        result = self._values.get("volume_devices")
        return typing.cast(typing.Optional[typing.List["TenantSpecSideCarsContainersVolumeDevices"]], result)

    @builtins.property
    def volume_mounts(
        self,
    ) -> typing.Optional[typing.List["TenantSpecSideCarsContainersVolumeMounts"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#volumeMounts
        '''
        result = self._values.get("volume_mounts")
        return typing.cast(typing.Optional[typing.List["TenantSpecSideCarsContainersVolumeMounts"]], result)

    @builtins.property
    def working_dir(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainers#workingDir
        '''
        result = self._values.get("working_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainers(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersEnv",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value", "value_from": "valueFrom"},
)
class TenantSpecSideCarsContainersEnv:
    def __init__(
        self,
        *,
        name: builtins.str,
        value: typing.Optional[builtins.str] = None,
        value_from: typing.Optional[typing.Union["TenantSpecSideCarsContainersEnvValueFrom", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param name: 
        :param value: 
        :param value_from: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnv
        '''
        if isinstance(value_from, dict):
            value_from = TenantSpecSideCarsContainersEnvValueFrom(**value_from)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersEnv.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument value_from", value=value_from, expected_type=type_hints["value_from"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if value is not None:
            self._values["value"] = value
        if value_from is not None:
            self._values["value_from"] = value_from

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnv#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnv#value
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def value_from(self) -> typing.Optional["TenantSpecSideCarsContainersEnvValueFrom"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnv#valueFrom
        '''
        result = self._values.get("value_from")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersEnvValueFrom"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersEnv(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersEnvFrom",
    jsii_struct_bases=[],
    name_mapping={
        "config_map_ref": "configMapRef",
        "prefix": "prefix",
        "secret_ref": "secretRef",
    },
)
class TenantSpecSideCarsContainersEnvFrom:
    def __init__(
        self,
        *,
        config_map_ref: typing.Optional[typing.Union["TenantSpecSideCarsContainersEnvFromConfigMapRef", typing.Dict[str, typing.Any]]] = None,
        prefix: typing.Optional[builtins.str] = None,
        secret_ref: typing.Optional[typing.Union["TenantSpecSideCarsContainersEnvFromSecretRef", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param config_map_ref: 
        :param prefix: 
        :param secret_ref: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvFrom
        '''
        if isinstance(config_map_ref, dict):
            config_map_ref = TenantSpecSideCarsContainersEnvFromConfigMapRef(**config_map_ref)
        if isinstance(secret_ref, dict):
            secret_ref = TenantSpecSideCarsContainersEnvFromSecretRef(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersEnvFrom.__init__)
            check_type(argname="argument config_map_ref", value=config_map_ref, expected_type=type_hints["config_map_ref"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
        self._values: typing.Dict[str, typing.Any] = {}
        if config_map_ref is not None:
            self._values["config_map_ref"] = config_map_ref
        if prefix is not None:
            self._values["prefix"] = prefix
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def config_map_ref(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersEnvFromConfigMapRef"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvFrom#configMapRef
        '''
        result = self._values.get("config_map_ref")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersEnvFromConfigMapRef"], result)

    @builtins.property
    def prefix(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvFrom#prefix
        '''
        result = self._values.get("prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_ref(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersEnvFromSecretRef"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvFrom#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersEnvFromSecretRef"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersEnvFrom(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersEnvFromConfigMapRef",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "optional": "optional"},
)
class TenantSpecSideCarsContainersEnvFromConfigMapRef:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param name: 
        :param optional: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvFromConfigMapRef
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersEnvFromConfigMapRef.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvFromConfigMapRef#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvFromConfigMapRef#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersEnvFromConfigMapRef(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersEnvFromSecretRef",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "optional": "optional"},
)
class TenantSpecSideCarsContainersEnvFromSecretRef:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param name: 
        :param optional: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvFromSecretRef
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersEnvFromSecretRef.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvFromSecretRef#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvFromSecretRef#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersEnvFromSecretRef(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersEnvValueFrom",
    jsii_struct_bases=[],
    name_mapping={
        "config_map_key_ref": "configMapKeyRef",
        "field_ref": "fieldRef",
        "resource_field_ref": "resourceFieldRef",
        "secret_key_ref": "secretKeyRef",
    },
)
class TenantSpecSideCarsContainersEnvValueFrom:
    def __init__(
        self,
        *,
        config_map_key_ref: typing.Optional[typing.Union["TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef", typing.Dict[str, typing.Any]]] = None,
        field_ref: typing.Optional[typing.Union["TenantSpecSideCarsContainersEnvValueFromFieldRef", typing.Dict[str, typing.Any]]] = None,
        resource_field_ref: typing.Optional[typing.Union["TenantSpecSideCarsContainersEnvValueFromResourceFieldRef", typing.Dict[str, typing.Any]]] = None,
        secret_key_ref: typing.Optional[typing.Union["TenantSpecSideCarsContainersEnvValueFromSecretKeyRef", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param config_map_key_ref: 
        :param field_ref: 
        :param resource_field_ref: 
        :param secret_key_ref: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFrom
        '''
        if isinstance(config_map_key_ref, dict):
            config_map_key_ref = TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef(**config_map_key_ref)
        if isinstance(field_ref, dict):
            field_ref = TenantSpecSideCarsContainersEnvValueFromFieldRef(**field_ref)
        if isinstance(resource_field_ref, dict):
            resource_field_ref = TenantSpecSideCarsContainersEnvValueFromResourceFieldRef(**resource_field_ref)
        if isinstance(secret_key_ref, dict):
            secret_key_ref = TenantSpecSideCarsContainersEnvValueFromSecretKeyRef(**secret_key_ref)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersEnvValueFrom.__init__)
            check_type(argname="argument config_map_key_ref", value=config_map_key_ref, expected_type=type_hints["config_map_key_ref"])
            check_type(argname="argument field_ref", value=field_ref, expected_type=type_hints["field_ref"])
            check_type(argname="argument resource_field_ref", value=resource_field_ref, expected_type=type_hints["resource_field_ref"])
            check_type(argname="argument secret_key_ref", value=secret_key_ref, expected_type=type_hints["secret_key_ref"])
        self._values: typing.Dict[str, typing.Any] = {}
        if config_map_key_ref is not None:
            self._values["config_map_key_ref"] = config_map_key_ref
        if field_ref is not None:
            self._values["field_ref"] = field_ref
        if resource_field_ref is not None:
            self._values["resource_field_ref"] = resource_field_ref
        if secret_key_ref is not None:
            self._values["secret_key_ref"] = secret_key_ref

    @builtins.property
    def config_map_key_ref(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFrom#configMapKeyRef
        '''
        result = self._values.get("config_map_key_ref")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef"], result)

    @builtins.property
    def field_ref(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersEnvValueFromFieldRef"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFrom#fieldRef
        '''
        result = self._values.get("field_ref")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersEnvValueFromFieldRef"], result)

    @builtins.property
    def resource_field_ref(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersEnvValueFromResourceFieldRef"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFrom#resourceFieldRef
        '''
        result = self._values.get("resource_field_ref")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersEnvValueFromResourceFieldRef"], result)

    @builtins.property
    def secret_key_ref(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersEnvValueFromSecretKeyRef"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFrom#secretKeyRef
        '''
        result = self._values.get("secret_key_ref")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersEnvValueFromSecretKeyRef"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersEnvValueFrom(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "name": "name", "optional": "optional"},
)
class TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef:
    def __init__(
        self,
        *,
        key: builtins.str,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param key: 
        :param name: 
        :param optional: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
        }
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersEnvValueFromFieldRef",
    jsii_struct_bases=[],
    name_mapping={"field_path": "fieldPath", "api_version": "apiVersion"},
)
class TenantSpecSideCarsContainersEnvValueFromFieldRef:
    def __init__(
        self,
        *,
        field_path: builtins.str,
        api_version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param field_path: 
        :param api_version: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFromFieldRef
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersEnvValueFromFieldRef.__init__)
            check_type(argname="argument field_path", value=field_path, expected_type=type_hints["field_path"])
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
        self._values: typing.Dict[str, typing.Any] = {
            "field_path": field_path,
        }
        if api_version is not None:
            self._values["api_version"] = api_version

    @builtins.property
    def field_path(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFromFieldRef#fieldPath
        '''
        result = self._values.get("field_path")
        assert result is not None, "Required property 'field_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFromFieldRef#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersEnvValueFromFieldRef(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersEnvValueFromResourceFieldRef",
    jsii_struct_bases=[],
    name_mapping={
        "resource": "resource",
        "container_name": "containerName",
        "divisor": "divisor",
    },
)
class TenantSpecSideCarsContainersEnvValueFromResourceFieldRef:
    def __init__(
        self,
        *,
        resource: builtins.str,
        container_name: typing.Optional[builtins.str] = None,
        divisor: typing.Optional["TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor"] = None,
    ) -> None:
        '''
        :param resource: 
        :param container_name: 
        :param divisor: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFromResourceFieldRef
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersEnvValueFromResourceFieldRef.__init__)
            check_type(argname="argument resource", value=resource, expected_type=type_hints["resource"])
            check_type(argname="argument container_name", value=container_name, expected_type=type_hints["container_name"])
            check_type(argname="argument divisor", value=divisor, expected_type=type_hints["divisor"])
        self._values: typing.Dict[str, typing.Any] = {
            "resource": resource,
        }
        if container_name is not None:
            self._values["container_name"] = container_name
        if divisor is not None:
            self._values["divisor"] = divisor

    @builtins.property
    def resource(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFromResourceFieldRef#resource
        '''
        result = self._values.get("resource")
        assert result is not None, "Required property 'resource' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def container_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFromResourceFieldRef#containerName
        '''
        result = self._values.get("container_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def divisor(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFromResourceFieldRef#divisor
        '''
        result = self._values.get("divisor")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersEnvValueFromResourceFieldRef(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersEnvValueFromSecretKeyRef",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "name": "name", "optional": "optional"},
)
class TenantSpecSideCarsContainersEnvValueFromSecretKeyRef:
    def __init__(
        self,
        *,
        key: builtins.str,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param key: 
        :param name: 
        :param optional: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFromSecretKeyRef
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersEnvValueFromSecretKeyRef.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
        }
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFromSecretKeyRef#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFromSecretKeyRef#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersEnvValueFromSecretKeyRef#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersEnvValueFromSecretKeyRef(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLifecycle",
    jsii_struct_bases=[],
    name_mapping={"post_start": "postStart", "pre_stop": "preStop"},
)
class TenantSpecSideCarsContainersLifecycle:
    def __init__(
        self,
        *,
        post_start: typing.Optional[typing.Union["TenantSpecSideCarsContainersLifecyclePostStart", typing.Dict[str, typing.Any]]] = None,
        pre_stop: typing.Optional[typing.Union["TenantSpecSideCarsContainersLifecyclePreStop", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param post_start: 
        :param pre_stop: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecycle
        '''
        if isinstance(post_start, dict):
            post_start = TenantSpecSideCarsContainersLifecyclePostStart(**post_start)
        if isinstance(pre_stop, dict):
            pre_stop = TenantSpecSideCarsContainersLifecyclePreStop(**pre_stop)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecycle.__init__)
            check_type(argname="argument post_start", value=post_start, expected_type=type_hints["post_start"])
            check_type(argname="argument pre_stop", value=pre_stop, expected_type=type_hints["pre_stop"])
        self._values: typing.Dict[str, typing.Any] = {}
        if post_start is not None:
            self._values["post_start"] = post_start
        if pre_stop is not None:
            self._values["pre_stop"] = pre_stop

    @builtins.property
    def post_start(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersLifecyclePostStart"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecycle#postStart
        '''
        result = self._values.get("post_start")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersLifecyclePostStart"], result)

    @builtins.property
    def pre_stop(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersLifecyclePreStop"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecycle#preStop
        '''
        result = self._values.get("pre_stop")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersLifecyclePreStop"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersLifecycle(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLifecyclePostStart",
    jsii_struct_bases=[],
    name_mapping={"exec": "exec", "http_get": "httpGet", "tcp_socket": "tcpSocket"},
)
class TenantSpecSideCarsContainersLifecyclePostStart:
    def __init__(
        self,
        *,
        exec: typing.Optional[typing.Union["TenantSpecSideCarsContainersLifecyclePostStartExec", typing.Dict[str, typing.Any]]] = None,
        http_get: typing.Optional[typing.Union["TenantSpecSideCarsContainersLifecyclePostStartHttpGet", typing.Dict[str, typing.Any]]] = None,
        tcp_socket: typing.Optional[typing.Union["TenantSpecSideCarsContainersLifecyclePostStartTcpSocket", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param exec: 
        :param http_get: 
        :param tcp_socket: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStart
        '''
        if isinstance(exec, dict):
            exec = TenantSpecSideCarsContainersLifecyclePostStartExec(**exec)
        if isinstance(http_get, dict):
            http_get = TenantSpecSideCarsContainersLifecyclePostStartHttpGet(**http_get)
        if isinstance(tcp_socket, dict):
            tcp_socket = TenantSpecSideCarsContainersLifecyclePostStartTcpSocket(**tcp_socket)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePostStart.__init__)
            check_type(argname="argument exec", value=exec, expected_type=type_hints["exec"])
            check_type(argname="argument http_get", value=http_get, expected_type=type_hints["http_get"])
            check_type(argname="argument tcp_socket", value=tcp_socket, expected_type=type_hints["tcp_socket"])
        self._values: typing.Dict[str, typing.Any] = {}
        if exec is not None:
            self._values["exec"] = exec
        if http_get is not None:
            self._values["http_get"] = http_get
        if tcp_socket is not None:
            self._values["tcp_socket"] = tcp_socket

    @builtins.property
    def exec(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersLifecyclePostStartExec"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStart#exec
        '''
        result = self._values.get("exec")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersLifecyclePostStartExec"], result)

    @builtins.property
    def http_get(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersLifecyclePostStartHttpGet"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStart#httpGet
        '''
        result = self._values.get("http_get")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersLifecyclePostStartHttpGet"], result)

    @builtins.property
    def tcp_socket(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersLifecyclePostStartTcpSocket"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStart#tcpSocket
        '''
        result = self._values.get("tcp_socket")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersLifecyclePostStartTcpSocket"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersLifecyclePostStart(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLifecyclePostStartExec",
    jsii_struct_bases=[],
    name_mapping={"command": "command"},
)
class TenantSpecSideCarsContainersLifecyclePostStartExec:
    def __init__(
        self,
        *,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param command: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStartExec
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePostStartExec.__init__)
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
        self._values: typing.Dict[str, typing.Any] = {}
        if command is not None:
            self._values["command"] = command

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStartExec#command
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersLifecyclePostStartExec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLifecyclePostStartHttpGet",
    jsii_struct_bases=[],
    name_mapping={
        "port": "port",
        "host": "host",
        "http_headers": "httpHeaders",
        "path": "path",
        "scheme": "scheme",
    },
)
class TenantSpecSideCarsContainersLifecyclePostStartHttpGet:
    def __init__(
        self,
        *,
        port: "TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort",
        host: typing.Optional[builtins.str] = None,
        http_headers: typing.Optional[typing.Sequence[typing.Union["TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders", typing.Dict[str, typing.Any]]]] = None,
        path: typing.Optional[builtins.str] = None,
        scheme: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param port: 
        :param host: 
        :param http_headers: 
        :param path: 
        :param scheme: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStartHttpGet
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePostStartHttpGet.__init__)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument http_headers", value=http_headers, expected_type=type_hints["http_headers"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument scheme", value=scheme, expected_type=type_hints["scheme"])
        self._values: typing.Dict[str, typing.Any] = {
            "port": port,
        }
        if host is not None:
            self._values["host"] = host
        if http_headers is not None:
            self._values["http_headers"] = http_headers
        if path is not None:
            self._values["path"] = path
        if scheme is not None:
            self._values["scheme"] = scheme

    @builtins.property
    def port(self) -> "TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort":
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStartHttpGet#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast("TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort", result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStartHttpGet#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def http_headers(
        self,
    ) -> typing.Optional[typing.List["TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStartHttpGet#httpHeaders
        '''
        result = self._values.get("http_headers")
        return typing.cast(typing.Optional[typing.List["TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders"]], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStartHttpGet#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scheme(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStartHttpGet#scheme
        '''
        result = self._values.get("scheme")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersLifecyclePostStartHttpGet(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        '''
        :param name: 
        :param value: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders#value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLifecyclePostStartTcpSocket",
    jsii_struct_bases=[],
    name_mapping={"port": "port", "host": "host"},
)
class TenantSpecSideCarsContainersLifecyclePostStartTcpSocket:
    def __init__(
        self,
        *,
        port: "TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort",
        host: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param port: 
        :param host: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStartTcpSocket
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePostStartTcpSocket.__init__)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
        self._values: typing.Dict[str, typing.Any] = {
            "port": port,
        }
        if host is not None:
            self._values["host"] = host

    @builtins.property
    def port(self) -> "TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort":
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStartTcpSocket#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast("TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort", result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePostStartTcpSocket#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersLifecyclePostStartTcpSocket(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLifecyclePreStop",
    jsii_struct_bases=[],
    name_mapping={"exec": "exec", "http_get": "httpGet", "tcp_socket": "tcpSocket"},
)
class TenantSpecSideCarsContainersLifecyclePreStop:
    def __init__(
        self,
        *,
        exec: typing.Optional[typing.Union["TenantSpecSideCarsContainersLifecyclePreStopExec", typing.Dict[str, typing.Any]]] = None,
        http_get: typing.Optional[typing.Union["TenantSpecSideCarsContainersLifecyclePreStopHttpGet", typing.Dict[str, typing.Any]]] = None,
        tcp_socket: typing.Optional[typing.Union["TenantSpecSideCarsContainersLifecyclePreStopTcpSocket", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param exec: 
        :param http_get: 
        :param tcp_socket: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStop
        '''
        if isinstance(exec, dict):
            exec = TenantSpecSideCarsContainersLifecyclePreStopExec(**exec)
        if isinstance(http_get, dict):
            http_get = TenantSpecSideCarsContainersLifecyclePreStopHttpGet(**http_get)
        if isinstance(tcp_socket, dict):
            tcp_socket = TenantSpecSideCarsContainersLifecyclePreStopTcpSocket(**tcp_socket)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePreStop.__init__)
            check_type(argname="argument exec", value=exec, expected_type=type_hints["exec"])
            check_type(argname="argument http_get", value=http_get, expected_type=type_hints["http_get"])
            check_type(argname="argument tcp_socket", value=tcp_socket, expected_type=type_hints["tcp_socket"])
        self._values: typing.Dict[str, typing.Any] = {}
        if exec is not None:
            self._values["exec"] = exec
        if http_get is not None:
            self._values["http_get"] = http_get
        if tcp_socket is not None:
            self._values["tcp_socket"] = tcp_socket

    @builtins.property
    def exec(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersLifecyclePreStopExec"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStop#exec
        '''
        result = self._values.get("exec")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersLifecyclePreStopExec"], result)

    @builtins.property
    def http_get(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersLifecyclePreStopHttpGet"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStop#httpGet
        '''
        result = self._values.get("http_get")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersLifecyclePreStopHttpGet"], result)

    @builtins.property
    def tcp_socket(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersLifecyclePreStopTcpSocket"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStop#tcpSocket
        '''
        result = self._values.get("tcp_socket")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersLifecyclePreStopTcpSocket"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersLifecyclePreStop(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLifecyclePreStopExec",
    jsii_struct_bases=[],
    name_mapping={"command": "command"},
)
class TenantSpecSideCarsContainersLifecyclePreStopExec:
    def __init__(
        self,
        *,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param command: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStopExec
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePreStopExec.__init__)
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
        self._values: typing.Dict[str, typing.Any] = {}
        if command is not None:
            self._values["command"] = command

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStopExec#command
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersLifecyclePreStopExec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLifecyclePreStopHttpGet",
    jsii_struct_bases=[],
    name_mapping={
        "port": "port",
        "host": "host",
        "http_headers": "httpHeaders",
        "path": "path",
        "scheme": "scheme",
    },
)
class TenantSpecSideCarsContainersLifecyclePreStopHttpGet:
    def __init__(
        self,
        *,
        port: "TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort",
        host: typing.Optional[builtins.str] = None,
        http_headers: typing.Optional[typing.Sequence[typing.Union["TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders", typing.Dict[str, typing.Any]]]] = None,
        path: typing.Optional[builtins.str] = None,
        scheme: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param port: 
        :param host: 
        :param http_headers: 
        :param path: 
        :param scheme: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStopHttpGet
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePreStopHttpGet.__init__)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument http_headers", value=http_headers, expected_type=type_hints["http_headers"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument scheme", value=scheme, expected_type=type_hints["scheme"])
        self._values: typing.Dict[str, typing.Any] = {
            "port": port,
        }
        if host is not None:
            self._values["host"] = host
        if http_headers is not None:
            self._values["http_headers"] = http_headers
        if path is not None:
            self._values["path"] = path
        if scheme is not None:
            self._values["scheme"] = scheme

    @builtins.property
    def port(self) -> "TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort":
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStopHttpGet#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast("TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort", result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStopHttpGet#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def http_headers(
        self,
    ) -> typing.Optional[typing.List["TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStopHttpGet#httpHeaders
        '''
        result = self._values.get("http_headers")
        return typing.cast(typing.Optional[typing.List["TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders"]], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStopHttpGet#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scheme(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStopHttpGet#scheme
        '''
        result = self._values.get("scheme")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersLifecyclePreStopHttpGet(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        '''
        :param name: 
        :param value: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders#value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLifecyclePreStopTcpSocket",
    jsii_struct_bases=[],
    name_mapping={"port": "port", "host": "host"},
)
class TenantSpecSideCarsContainersLifecyclePreStopTcpSocket:
    def __init__(
        self,
        *,
        port: "TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort",
        host: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param port: 
        :param host: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStopTcpSocket
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePreStopTcpSocket.__init__)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
        self._values: typing.Dict[str, typing.Any] = {
            "port": port,
        }
        if host is not None:
            self._values["host"] = host

    @builtins.property
    def port(self) -> "TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort":
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStopTcpSocket#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast("TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort", result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLifecyclePreStopTcpSocket#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersLifecyclePreStopTcpSocket(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLivenessProbe",
    jsii_struct_bases=[],
    name_mapping={
        "exec": "exec",
        "failure_threshold": "failureThreshold",
        "http_get": "httpGet",
        "initial_delay_seconds": "initialDelaySeconds",
        "period_seconds": "periodSeconds",
        "success_threshold": "successThreshold",
        "tcp_socket": "tcpSocket",
        "timeout_seconds": "timeoutSeconds",
    },
)
class TenantSpecSideCarsContainersLivenessProbe:
    def __init__(
        self,
        *,
        exec: typing.Optional[typing.Union["TenantSpecSideCarsContainersLivenessProbeExec", typing.Dict[str, typing.Any]]] = None,
        failure_threshold: typing.Optional[jsii.Number] = None,
        http_get: typing.Optional[typing.Union["TenantSpecSideCarsContainersLivenessProbeHttpGet", typing.Dict[str, typing.Any]]] = None,
        initial_delay_seconds: typing.Optional[jsii.Number] = None,
        period_seconds: typing.Optional[jsii.Number] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        tcp_socket: typing.Optional[typing.Union["TenantSpecSideCarsContainersLivenessProbeTcpSocket", typing.Dict[str, typing.Any]]] = None,
        timeout_seconds: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param exec: 
        :param failure_threshold: 
        :param http_get: 
        :param initial_delay_seconds: 
        :param period_seconds: 
        :param success_threshold: 
        :param tcp_socket: 
        :param timeout_seconds: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbe
        '''
        if isinstance(exec, dict):
            exec = TenantSpecSideCarsContainersLivenessProbeExec(**exec)
        if isinstance(http_get, dict):
            http_get = TenantSpecSideCarsContainersLivenessProbeHttpGet(**http_get)
        if isinstance(tcp_socket, dict):
            tcp_socket = TenantSpecSideCarsContainersLivenessProbeTcpSocket(**tcp_socket)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLivenessProbe.__init__)
            check_type(argname="argument exec", value=exec, expected_type=type_hints["exec"])
            check_type(argname="argument failure_threshold", value=failure_threshold, expected_type=type_hints["failure_threshold"])
            check_type(argname="argument http_get", value=http_get, expected_type=type_hints["http_get"])
            check_type(argname="argument initial_delay_seconds", value=initial_delay_seconds, expected_type=type_hints["initial_delay_seconds"])
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument success_threshold", value=success_threshold, expected_type=type_hints["success_threshold"])
            check_type(argname="argument tcp_socket", value=tcp_socket, expected_type=type_hints["tcp_socket"])
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
        self._values: typing.Dict[str, typing.Any] = {}
        if exec is not None:
            self._values["exec"] = exec
        if failure_threshold is not None:
            self._values["failure_threshold"] = failure_threshold
        if http_get is not None:
            self._values["http_get"] = http_get
        if initial_delay_seconds is not None:
            self._values["initial_delay_seconds"] = initial_delay_seconds
        if period_seconds is not None:
            self._values["period_seconds"] = period_seconds
        if success_threshold is not None:
            self._values["success_threshold"] = success_threshold
        if tcp_socket is not None:
            self._values["tcp_socket"] = tcp_socket
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds

    @builtins.property
    def exec(self) -> typing.Optional["TenantSpecSideCarsContainersLivenessProbeExec"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbe#exec
        '''
        result = self._values.get("exec")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersLivenessProbeExec"], result)

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbe#failureThreshold
        '''
        result = self._values.get("failure_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def http_get(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersLivenessProbeHttpGet"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbe#httpGet
        '''
        result = self._values.get("http_get")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersLivenessProbeHttpGet"], result)

    @builtins.property
    def initial_delay_seconds(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbe#initialDelaySeconds
        '''
        result = self._values.get("initial_delay_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def period_seconds(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbe#periodSeconds
        '''
        result = self._values.get("period_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbe#successThreshold
        '''
        result = self._values.get("success_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def tcp_socket(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersLivenessProbeTcpSocket"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbe#tcpSocket
        '''
        result = self._values.get("tcp_socket")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersLivenessProbeTcpSocket"], result)

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbe#timeoutSeconds
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersLivenessProbe(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLivenessProbeExec",
    jsii_struct_bases=[],
    name_mapping={"command": "command"},
)
class TenantSpecSideCarsContainersLivenessProbeExec:
    def __init__(
        self,
        *,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param command: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbeExec
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLivenessProbeExec.__init__)
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
        self._values: typing.Dict[str, typing.Any] = {}
        if command is not None:
            self._values["command"] = command

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbeExec#command
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersLivenessProbeExec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLivenessProbeHttpGet",
    jsii_struct_bases=[],
    name_mapping={
        "port": "port",
        "host": "host",
        "http_headers": "httpHeaders",
        "path": "path",
        "scheme": "scheme",
    },
)
class TenantSpecSideCarsContainersLivenessProbeHttpGet:
    def __init__(
        self,
        *,
        port: "TenantSpecSideCarsContainersLivenessProbeHttpGetPort",
        host: typing.Optional[builtins.str] = None,
        http_headers: typing.Optional[typing.Sequence[typing.Union["TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders", typing.Dict[str, typing.Any]]]] = None,
        path: typing.Optional[builtins.str] = None,
        scheme: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param port: 
        :param host: 
        :param http_headers: 
        :param path: 
        :param scheme: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbeHttpGet
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLivenessProbeHttpGet.__init__)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument http_headers", value=http_headers, expected_type=type_hints["http_headers"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument scheme", value=scheme, expected_type=type_hints["scheme"])
        self._values: typing.Dict[str, typing.Any] = {
            "port": port,
        }
        if host is not None:
            self._values["host"] = host
        if http_headers is not None:
            self._values["http_headers"] = http_headers
        if path is not None:
            self._values["path"] = path
        if scheme is not None:
            self._values["scheme"] = scheme

    @builtins.property
    def port(self) -> "TenantSpecSideCarsContainersLivenessProbeHttpGetPort":
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbeHttpGet#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast("TenantSpecSideCarsContainersLivenessProbeHttpGetPort", result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbeHttpGet#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def http_headers(
        self,
    ) -> typing.Optional[typing.List["TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbeHttpGet#httpHeaders
        '''
        result = self._values.get("http_headers")
        return typing.cast(typing.Optional[typing.List["TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders"]], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbeHttpGet#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scheme(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbeHttpGet#scheme
        '''
        result = self._values.get("scheme")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersLivenessProbeHttpGet(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        '''
        :param name: 
        :param value: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders#value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecSideCarsContainersLivenessProbeHttpGetPort(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLivenessProbeHttpGetPort",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsContainersLivenessProbeHttpGetPort
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsContainersLivenessProbeHttpGetPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLivenessProbeHttpGetPort.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersLivenessProbeHttpGetPort", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsContainersLivenessProbeHttpGetPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLivenessProbeHttpGetPort.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersLivenessProbeHttpGetPort", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLivenessProbeTcpSocket",
    jsii_struct_bases=[],
    name_mapping={"port": "port", "host": "host"},
)
class TenantSpecSideCarsContainersLivenessProbeTcpSocket:
    def __init__(
        self,
        *,
        port: "TenantSpecSideCarsContainersLivenessProbeTcpSocketPort",
        host: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param port: 
        :param host: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbeTcpSocket
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLivenessProbeTcpSocket.__init__)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
        self._values: typing.Dict[str, typing.Any] = {
            "port": port,
        }
        if host is not None:
            self._values["host"] = host

    @builtins.property
    def port(self) -> "TenantSpecSideCarsContainersLivenessProbeTcpSocketPort":
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbeTcpSocket#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast("TenantSpecSideCarsContainersLivenessProbeTcpSocketPort", result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersLivenessProbeTcpSocket#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersLivenessProbeTcpSocket(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecSideCarsContainersLivenessProbeTcpSocketPort(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersLivenessProbeTcpSocketPort",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsContainersLivenessProbeTcpSocketPort
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsContainersLivenessProbeTcpSocketPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLivenessProbeTcpSocketPort.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersLivenessProbeTcpSocketPort", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsContainersLivenessProbeTcpSocketPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersLivenessProbeTcpSocketPort.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersLivenessProbeTcpSocketPort", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersPorts",
    jsii_struct_bases=[],
    name_mapping={
        "container_port": "containerPort",
        "host_ip": "hostIp",
        "host_port": "hostPort",
        "name": "name",
        "protocol": "protocol",
    },
)
class TenantSpecSideCarsContainersPorts:
    def __init__(
        self,
        *,
        container_port: jsii.Number,
        host_ip: typing.Optional[builtins.str] = None,
        host_port: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
        protocol: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param container_port: 
        :param host_ip: 
        :param host_port: 
        :param name: 
        :param protocol: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersPorts
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersPorts.__init__)
            check_type(argname="argument container_port", value=container_port, expected_type=type_hints["container_port"])
            check_type(argname="argument host_ip", value=host_ip, expected_type=type_hints["host_ip"])
            check_type(argname="argument host_port", value=host_port, expected_type=type_hints["host_port"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
        self._values: typing.Dict[str, typing.Any] = {
            "container_port": container_port,
        }
        if host_ip is not None:
            self._values["host_ip"] = host_ip
        if host_port is not None:
            self._values["host_port"] = host_port
        if name is not None:
            self._values["name"] = name
        if protocol is not None:
            self._values["protocol"] = protocol

    @builtins.property
    def container_port(self) -> jsii.Number:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersPorts#containerPort
        '''
        result = self._values.get("container_port")
        assert result is not None, "Required property 'container_port' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def host_ip(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersPorts#hostIP
        '''
        result = self._values.get("host_ip")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def host_port(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersPorts#hostPort
        '''
        result = self._values.get("host_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersPorts#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def protocol(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersPorts#protocol
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersPorts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersReadinessProbe",
    jsii_struct_bases=[],
    name_mapping={
        "exec": "exec",
        "failure_threshold": "failureThreshold",
        "http_get": "httpGet",
        "initial_delay_seconds": "initialDelaySeconds",
        "period_seconds": "periodSeconds",
        "success_threshold": "successThreshold",
        "tcp_socket": "tcpSocket",
        "timeout_seconds": "timeoutSeconds",
    },
)
class TenantSpecSideCarsContainersReadinessProbe:
    def __init__(
        self,
        *,
        exec: typing.Optional[typing.Union["TenantSpecSideCarsContainersReadinessProbeExec", typing.Dict[str, typing.Any]]] = None,
        failure_threshold: typing.Optional[jsii.Number] = None,
        http_get: typing.Optional[typing.Union["TenantSpecSideCarsContainersReadinessProbeHttpGet", typing.Dict[str, typing.Any]]] = None,
        initial_delay_seconds: typing.Optional[jsii.Number] = None,
        period_seconds: typing.Optional[jsii.Number] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        tcp_socket: typing.Optional[typing.Union["TenantSpecSideCarsContainersReadinessProbeTcpSocket", typing.Dict[str, typing.Any]]] = None,
        timeout_seconds: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param exec: 
        :param failure_threshold: 
        :param http_get: 
        :param initial_delay_seconds: 
        :param period_seconds: 
        :param success_threshold: 
        :param tcp_socket: 
        :param timeout_seconds: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbe
        '''
        if isinstance(exec, dict):
            exec = TenantSpecSideCarsContainersReadinessProbeExec(**exec)
        if isinstance(http_get, dict):
            http_get = TenantSpecSideCarsContainersReadinessProbeHttpGet(**http_get)
        if isinstance(tcp_socket, dict):
            tcp_socket = TenantSpecSideCarsContainersReadinessProbeTcpSocket(**tcp_socket)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersReadinessProbe.__init__)
            check_type(argname="argument exec", value=exec, expected_type=type_hints["exec"])
            check_type(argname="argument failure_threshold", value=failure_threshold, expected_type=type_hints["failure_threshold"])
            check_type(argname="argument http_get", value=http_get, expected_type=type_hints["http_get"])
            check_type(argname="argument initial_delay_seconds", value=initial_delay_seconds, expected_type=type_hints["initial_delay_seconds"])
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument success_threshold", value=success_threshold, expected_type=type_hints["success_threshold"])
            check_type(argname="argument tcp_socket", value=tcp_socket, expected_type=type_hints["tcp_socket"])
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
        self._values: typing.Dict[str, typing.Any] = {}
        if exec is not None:
            self._values["exec"] = exec
        if failure_threshold is not None:
            self._values["failure_threshold"] = failure_threshold
        if http_get is not None:
            self._values["http_get"] = http_get
        if initial_delay_seconds is not None:
            self._values["initial_delay_seconds"] = initial_delay_seconds
        if period_seconds is not None:
            self._values["period_seconds"] = period_seconds
        if success_threshold is not None:
            self._values["success_threshold"] = success_threshold
        if tcp_socket is not None:
            self._values["tcp_socket"] = tcp_socket
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds

    @builtins.property
    def exec(self) -> typing.Optional["TenantSpecSideCarsContainersReadinessProbeExec"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbe#exec
        '''
        result = self._values.get("exec")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersReadinessProbeExec"], result)

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbe#failureThreshold
        '''
        result = self._values.get("failure_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def http_get(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersReadinessProbeHttpGet"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbe#httpGet
        '''
        result = self._values.get("http_get")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersReadinessProbeHttpGet"], result)

    @builtins.property
    def initial_delay_seconds(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbe#initialDelaySeconds
        '''
        result = self._values.get("initial_delay_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def period_seconds(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbe#periodSeconds
        '''
        result = self._values.get("period_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbe#successThreshold
        '''
        result = self._values.get("success_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def tcp_socket(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersReadinessProbeTcpSocket"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbe#tcpSocket
        '''
        result = self._values.get("tcp_socket")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersReadinessProbeTcpSocket"], result)

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbe#timeoutSeconds
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersReadinessProbe(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersReadinessProbeExec",
    jsii_struct_bases=[],
    name_mapping={"command": "command"},
)
class TenantSpecSideCarsContainersReadinessProbeExec:
    def __init__(
        self,
        *,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param command: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbeExec
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersReadinessProbeExec.__init__)
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
        self._values: typing.Dict[str, typing.Any] = {}
        if command is not None:
            self._values["command"] = command

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbeExec#command
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersReadinessProbeExec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersReadinessProbeHttpGet",
    jsii_struct_bases=[],
    name_mapping={
        "port": "port",
        "host": "host",
        "http_headers": "httpHeaders",
        "path": "path",
        "scheme": "scheme",
    },
)
class TenantSpecSideCarsContainersReadinessProbeHttpGet:
    def __init__(
        self,
        *,
        port: "TenantSpecSideCarsContainersReadinessProbeHttpGetPort",
        host: typing.Optional[builtins.str] = None,
        http_headers: typing.Optional[typing.Sequence[typing.Union["TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders", typing.Dict[str, typing.Any]]]] = None,
        path: typing.Optional[builtins.str] = None,
        scheme: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param port: 
        :param host: 
        :param http_headers: 
        :param path: 
        :param scheme: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbeHttpGet
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersReadinessProbeHttpGet.__init__)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument http_headers", value=http_headers, expected_type=type_hints["http_headers"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument scheme", value=scheme, expected_type=type_hints["scheme"])
        self._values: typing.Dict[str, typing.Any] = {
            "port": port,
        }
        if host is not None:
            self._values["host"] = host
        if http_headers is not None:
            self._values["http_headers"] = http_headers
        if path is not None:
            self._values["path"] = path
        if scheme is not None:
            self._values["scheme"] = scheme

    @builtins.property
    def port(self) -> "TenantSpecSideCarsContainersReadinessProbeHttpGetPort":
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbeHttpGet#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast("TenantSpecSideCarsContainersReadinessProbeHttpGetPort", result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbeHttpGet#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def http_headers(
        self,
    ) -> typing.Optional[typing.List["TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbeHttpGet#httpHeaders
        '''
        result = self._values.get("http_headers")
        return typing.cast(typing.Optional[typing.List["TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders"]], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbeHttpGet#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scheme(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbeHttpGet#scheme
        '''
        result = self._values.get("scheme")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersReadinessProbeHttpGet(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        '''
        :param name: 
        :param value: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders#value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecSideCarsContainersReadinessProbeHttpGetPort(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersReadinessProbeHttpGetPort",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsContainersReadinessProbeHttpGetPort
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsContainersReadinessProbeHttpGetPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersReadinessProbeHttpGetPort.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersReadinessProbeHttpGetPort", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsContainersReadinessProbeHttpGetPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersReadinessProbeHttpGetPort.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersReadinessProbeHttpGetPort", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersReadinessProbeTcpSocket",
    jsii_struct_bases=[],
    name_mapping={"port": "port", "host": "host"},
)
class TenantSpecSideCarsContainersReadinessProbeTcpSocket:
    def __init__(
        self,
        *,
        port: "TenantSpecSideCarsContainersReadinessProbeTcpSocketPort",
        host: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param port: 
        :param host: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbeTcpSocket
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersReadinessProbeTcpSocket.__init__)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
        self._values: typing.Dict[str, typing.Any] = {
            "port": port,
        }
        if host is not None:
            self._values["host"] = host

    @builtins.property
    def port(self) -> "TenantSpecSideCarsContainersReadinessProbeTcpSocketPort":
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbeTcpSocket#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast("TenantSpecSideCarsContainersReadinessProbeTcpSocketPort", result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersReadinessProbeTcpSocket#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersReadinessProbeTcpSocket(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecSideCarsContainersReadinessProbeTcpSocketPort(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersReadinessProbeTcpSocketPort",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsContainersReadinessProbeTcpSocketPort
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsContainersReadinessProbeTcpSocketPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersReadinessProbeTcpSocketPort.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersReadinessProbeTcpSocketPort", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsContainersReadinessProbeTcpSocketPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersReadinessProbeTcpSocketPort.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersReadinessProbeTcpSocketPort", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersResources",
    jsii_struct_bases=[],
    name_mapping={"limits": "limits", "requests": "requests"},
)
class TenantSpecSideCarsContainersResources:
    def __init__(
        self,
        *,
        limits: typing.Optional[typing.Mapping[builtins.str, "TenantSpecSideCarsContainersResourcesLimits"]] = None,
        requests: typing.Optional[typing.Mapping[builtins.str, "TenantSpecSideCarsContainersResourcesRequests"]] = None,
    ) -> None:
        '''
        :param limits: 
        :param requests: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersResources
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersResources.__init__)
            check_type(argname="argument limits", value=limits, expected_type=type_hints["limits"])
            check_type(argname="argument requests", value=requests, expected_type=type_hints["requests"])
        self._values: typing.Dict[str, typing.Any] = {}
        if limits is not None:
            self._values["limits"] = limits
        if requests is not None:
            self._values["requests"] = requests

    @builtins.property
    def limits(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "TenantSpecSideCarsContainersResourcesLimits"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersResources#limits
        '''
        result = self._values.get("limits")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "TenantSpecSideCarsContainersResourcesLimits"]], result)

    @builtins.property
    def requests(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "TenantSpecSideCarsContainersResourcesRequests"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersResources#requests
        '''
        result = self._values.get("requests")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "TenantSpecSideCarsContainersResourcesRequests"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecSideCarsContainersResourcesLimits(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersResourcesLimits",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsContainersResourcesLimits
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsContainersResourcesLimits":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersResourcesLimits.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersResourcesLimits", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsContainersResourcesLimits":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersResourcesLimits.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersResourcesLimits", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


class TenantSpecSideCarsContainersResourcesRequests(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersResourcesRequests",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsContainersResourcesRequests
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsContainersResourcesRequests":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersResourcesRequests.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersResourcesRequests", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsContainersResourcesRequests":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersResourcesRequests.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersResourcesRequests", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersSecurityContext",
    jsii_struct_bases=[],
    name_mapping={
        "allow_privilege_escalation": "allowPrivilegeEscalation",
        "capabilities": "capabilities",
        "privileged": "privileged",
        "proc_mount": "procMount",
        "read_only_root_filesystem": "readOnlyRootFilesystem",
        "run_as_group": "runAsGroup",
        "run_as_non_root": "runAsNonRoot",
        "run_as_user": "runAsUser",
        "seccomp_profile": "seccompProfile",
        "se_linux_options": "seLinuxOptions",
        "windows_options": "windowsOptions",
    },
)
class TenantSpecSideCarsContainersSecurityContext:
    def __init__(
        self,
        *,
        allow_privilege_escalation: typing.Optional[builtins.bool] = None,
        capabilities: typing.Optional[typing.Union["TenantSpecSideCarsContainersSecurityContextCapabilities", typing.Dict[str, typing.Any]]] = None,
        privileged: typing.Optional[builtins.bool] = None,
        proc_mount: typing.Optional[builtins.str] = None,
        read_only_root_filesystem: typing.Optional[builtins.bool] = None,
        run_as_group: typing.Optional[jsii.Number] = None,
        run_as_non_root: typing.Optional[builtins.bool] = None,
        run_as_user: typing.Optional[jsii.Number] = None,
        seccomp_profile: typing.Optional[typing.Union["TenantSpecSideCarsContainersSecurityContextSeccompProfile", typing.Dict[str, typing.Any]]] = None,
        se_linux_options: typing.Optional[typing.Union["TenantSpecSideCarsContainersSecurityContextSeLinuxOptions", typing.Dict[str, typing.Any]]] = None,
        windows_options: typing.Optional[typing.Union["TenantSpecSideCarsContainersSecurityContextWindowsOptions", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param allow_privilege_escalation: 
        :param capabilities: 
        :param privileged: 
        :param proc_mount: 
        :param read_only_root_filesystem: 
        :param run_as_group: 
        :param run_as_non_root: 
        :param run_as_user: 
        :param seccomp_profile: 
        :param se_linux_options: 
        :param windows_options: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContext
        '''
        if isinstance(capabilities, dict):
            capabilities = TenantSpecSideCarsContainersSecurityContextCapabilities(**capabilities)
        if isinstance(seccomp_profile, dict):
            seccomp_profile = TenantSpecSideCarsContainersSecurityContextSeccompProfile(**seccomp_profile)
        if isinstance(se_linux_options, dict):
            se_linux_options = TenantSpecSideCarsContainersSecurityContextSeLinuxOptions(**se_linux_options)
        if isinstance(windows_options, dict):
            windows_options = TenantSpecSideCarsContainersSecurityContextWindowsOptions(**windows_options)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersSecurityContext.__init__)
            check_type(argname="argument allow_privilege_escalation", value=allow_privilege_escalation, expected_type=type_hints["allow_privilege_escalation"])
            check_type(argname="argument capabilities", value=capabilities, expected_type=type_hints["capabilities"])
            check_type(argname="argument privileged", value=privileged, expected_type=type_hints["privileged"])
            check_type(argname="argument proc_mount", value=proc_mount, expected_type=type_hints["proc_mount"])
            check_type(argname="argument read_only_root_filesystem", value=read_only_root_filesystem, expected_type=type_hints["read_only_root_filesystem"])
            check_type(argname="argument run_as_group", value=run_as_group, expected_type=type_hints["run_as_group"])
            check_type(argname="argument run_as_non_root", value=run_as_non_root, expected_type=type_hints["run_as_non_root"])
            check_type(argname="argument run_as_user", value=run_as_user, expected_type=type_hints["run_as_user"])
            check_type(argname="argument seccomp_profile", value=seccomp_profile, expected_type=type_hints["seccomp_profile"])
            check_type(argname="argument se_linux_options", value=se_linux_options, expected_type=type_hints["se_linux_options"])
            check_type(argname="argument windows_options", value=windows_options, expected_type=type_hints["windows_options"])
        self._values: typing.Dict[str, typing.Any] = {}
        if allow_privilege_escalation is not None:
            self._values["allow_privilege_escalation"] = allow_privilege_escalation
        if capabilities is not None:
            self._values["capabilities"] = capabilities
        if privileged is not None:
            self._values["privileged"] = privileged
        if proc_mount is not None:
            self._values["proc_mount"] = proc_mount
        if read_only_root_filesystem is not None:
            self._values["read_only_root_filesystem"] = read_only_root_filesystem
        if run_as_group is not None:
            self._values["run_as_group"] = run_as_group
        if run_as_non_root is not None:
            self._values["run_as_non_root"] = run_as_non_root
        if run_as_user is not None:
            self._values["run_as_user"] = run_as_user
        if seccomp_profile is not None:
            self._values["seccomp_profile"] = seccomp_profile
        if se_linux_options is not None:
            self._values["se_linux_options"] = se_linux_options
        if windows_options is not None:
            self._values["windows_options"] = windows_options

    @builtins.property
    def allow_privilege_escalation(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContext#allowPrivilegeEscalation
        '''
        result = self._values.get("allow_privilege_escalation")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def capabilities(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersSecurityContextCapabilities"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContext#capabilities
        '''
        result = self._values.get("capabilities")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersSecurityContextCapabilities"], result)

    @builtins.property
    def privileged(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContext#privileged
        '''
        result = self._values.get("privileged")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def proc_mount(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContext#procMount
        '''
        result = self._values.get("proc_mount")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only_root_filesystem(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContext#readOnlyRootFilesystem
        '''
        result = self._values.get("read_only_root_filesystem")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def run_as_group(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContext#runAsGroup
        '''
        result = self._values.get("run_as_group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def run_as_non_root(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContext#runAsNonRoot
        '''
        result = self._values.get("run_as_non_root")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def run_as_user(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContext#runAsUser
        '''
        result = self._values.get("run_as_user")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def seccomp_profile(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersSecurityContextSeccompProfile"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContext#seccompProfile
        '''
        result = self._values.get("seccomp_profile")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersSecurityContextSeccompProfile"], result)

    @builtins.property
    def se_linux_options(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersSecurityContextSeLinuxOptions"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContext#seLinuxOptions
        '''
        result = self._values.get("se_linux_options")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersSecurityContextSeLinuxOptions"], result)

    @builtins.property
    def windows_options(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersSecurityContextWindowsOptions"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContext#windowsOptions
        '''
        result = self._values.get("windows_options")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersSecurityContextWindowsOptions"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersSecurityContext(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersSecurityContextCapabilities",
    jsii_struct_bases=[],
    name_mapping={"add": "add", "drop": "drop"},
)
class TenantSpecSideCarsContainersSecurityContextCapabilities:
    def __init__(
        self,
        *,
        add: typing.Optional[typing.Sequence[builtins.str]] = None,
        drop: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param add: 
        :param drop: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContextCapabilities
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersSecurityContextCapabilities.__init__)
            check_type(argname="argument add", value=add, expected_type=type_hints["add"])
            check_type(argname="argument drop", value=drop, expected_type=type_hints["drop"])
        self._values: typing.Dict[str, typing.Any] = {}
        if add is not None:
            self._values["add"] = add
        if drop is not None:
            self._values["drop"] = drop

    @builtins.property
    def add(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContextCapabilities#add
        '''
        result = self._values.get("add")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def drop(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContextCapabilities#drop
        '''
        result = self._values.get("drop")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersSecurityContextCapabilities(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersSecurityContextSeLinuxOptions",
    jsii_struct_bases=[],
    name_mapping={"level": "level", "role": "role", "type": "type", "user": "user"},
)
class TenantSpecSideCarsContainersSecurityContextSeLinuxOptions:
    def __init__(
        self,
        *,
        level: typing.Optional[builtins.str] = None,
        role: typing.Optional[builtins.str] = None,
        type: typing.Optional[builtins.str] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param level: 
        :param role: 
        :param type: 
        :param user: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContextSeLinuxOptions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersSecurityContextSeLinuxOptions.__init__)
            check_type(argname="argument level", value=level, expected_type=type_hints["level"])
            check_type(argname="argument role", value=role, expected_type=type_hints["role"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[str, typing.Any] = {}
        if level is not None:
            self._values["level"] = level
        if role is not None:
            self._values["role"] = role
        if type is not None:
            self._values["type"] = type
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def level(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContextSeLinuxOptions#level
        '''
        result = self._values.get("level")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def role(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContextSeLinuxOptions#role
        '''
        result = self._values.get("role")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContextSeLinuxOptions#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContextSeLinuxOptions#user
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersSecurityContextSeLinuxOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersSecurityContextSeccompProfile",
    jsii_struct_bases=[],
    name_mapping={"type": "type", "localhost_profile": "localhostProfile"},
)
class TenantSpecSideCarsContainersSecurityContextSeccompProfile:
    def __init__(
        self,
        *,
        type: builtins.str,
        localhost_profile: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param type: 
        :param localhost_profile: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContextSeccompProfile
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersSecurityContextSeccompProfile.__init__)
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument localhost_profile", value=localhost_profile, expected_type=type_hints["localhost_profile"])
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
        }
        if localhost_profile is not None:
            self._values["localhost_profile"] = localhost_profile

    @builtins.property
    def type(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContextSeccompProfile#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def localhost_profile(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContextSeccompProfile#localhostProfile
        '''
        result = self._values.get("localhost_profile")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersSecurityContextSeccompProfile(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersSecurityContextWindowsOptions",
    jsii_struct_bases=[],
    name_mapping={
        "gmsa_credential_spec": "gmsaCredentialSpec",
        "gmsa_credential_spec_name": "gmsaCredentialSpecName",
        "run_as_user_name": "runAsUserName",
    },
)
class TenantSpecSideCarsContainersSecurityContextWindowsOptions:
    def __init__(
        self,
        *,
        gmsa_credential_spec: typing.Optional[builtins.str] = None,
        gmsa_credential_spec_name: typing.Optional[builtins.str] = None,
        run_as_user_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param gmsa_credential_spec: 
        :param gmsa_credential_spec_name: 
        :param run_as_user_name: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContextWindowsOptions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersSecurityContextWindowsOptions.__init__)
            check_type(argname="argument gmsa_credential_spec", value=gmsa_credential_spec, expected_type=type_hints["gmsa_credential_spec"])
            check_type(argname="argument gmsa_credential_spec_name", value=gmsa_credential_spec_name, expected_type=type_hints["gmsa_credential_spec_name"])
            check_type(argname="argument run_as_user_name", value=run_as_user_name, expected_type=type_hints["run_as_user_name"])
        self._values: typing.Dict[str, typing.Any] = {}
        if gmsa_credential_spec is not None:
            self._values["gmsa_credential_spec"] = gmsa_credential_spec
        if gmsa_credential_spec_name is not None:
            self._values["gmsa_credential_spec_name"] = gmsa_credential_spec_name
        if run_as_user_name is not None:
            self._values["run_as_user_name"] = run_as_user_name

    @builtins.property
    def gmsa_credential_spec(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContextWindowsOptions#gmsaCredentialSpec
        '''
        result = self._values.get("gmsa_credential_spec")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def gmsa_credential_spec_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContextWindowsOptions#gmsaCredentialSpecName
        '''
        result = self._values.get("gmsa_credential_spec_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def run_as_user_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersSecurityContextWindowsOptions#runAsUserName
        '''
        result = self._values.get("run_as_user_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersSecurityContextWindowsOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersStartupProbe",
    jsii_struct_bases=[],
    name_mapping={
        "exec": "exec",
        "failure_threshold": "failureThreshold",
        "http_get": "httpGet",
        "initial_delay_seconds": "initialDelaySeconds",
        "period_seconds": "periodSeconds",
        "success_threshold": "successThreshold",
        "tcp_socket": "tcpSocket",
        "timeout_seconds": "timeoutSeconds",
    },
)
class TenantSpecSideCarsContainersStartupProbe:
    def __init__(
        self,
        *,
        exec: typing.Optional[typing.Union["TenantSpecSideCarsContainersStartupProbeExec", typing.Dict[str, typing.Any]]] = None,
        failure_threshold: typing.Optional[jsii.Number] = None,
        http_get: typing.Optional[typing.Union["TenantSpecSideCarsContainersStartupProbeHttpGet", typing.Dict[str, typing.Any]]] = None,
        initial_delay_seconds: typing.Optional[jsii.Number] = None,
        period_seconds: typing.Optional[jsii.Number] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        tcp_socket: typing.Optional[typing.Union["TenantSpecSideCarsContainersStartupProbeTcpSocket", typing.Dict[str, typing.Any]]] = None,
        timeout_seconds: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param exec: 
        :param failure_threshold: 
        :param http_get: 
        :param initial_delay_seconds: 
        :param period_seconds: 
        :param success_threshold: 
        :param tcp_socket: 
        :param timeout_seconds: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbe
        '''
        if isinstance(exec, dict):
            exec = TenantSpecSideCarsContainersStartupProbeExec(**exec)
        if isinstance(http_get, dict):
            http_get = TenantSpecSideCarsContainersStartupProbeHttpGet(**http_get)
        if isinstance(tcp_socket, dict):
            tcp_socket = TenantSpecSideCarsContainersStartupProbeTcpSocket(**tcp_socket)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersStartupProbe.__init__)
            check_type(argname="argument exec", value=exec, expected_type=type_hints["exec"])
            check_type(argname="argument failure_threshold", value=failure_threshold, expected_type=type_hints["failure_threshold"])
            check_type(argname="argument http_get", value=http_get, expected_type=type_hints["http_get"])
            check_type(argname="argument initial_delay_seconds", value=initial_delay_seconds, expected_type=type_hints["initial_delay_seconds"])
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument success_threshold", value=success_threshold, expected_type=type_hints["success_threshold"])
            check_type(argname="argument tcp_socket", value=tcp_socket, expected_type=type_hints["tcp_socket"])
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
        self._values: typing.Dict[str, typing.Any] = {}
        if exec is not None:
            self._values["exec"] = exec
        if failure_threshold is not None:
            self._values["failure_threshold"] = failure_threshold
        if http_get is not None:
            self._values["http_get"] = http_get
        if initial_delay_seconds is not None:
            self._values["initial_delay_seconds"] = initial_delay_seconds
        if period_seconds is not None:
            self._values["period_seconds"] = period_seconds
        if success_threshold is not None:
            self._values["success_threshold"] = success_threshold
        if tcp_socket is not None:
            self._values["tcp_socket"] = tcp_socket
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds

    @builtins.property
    def exec(self) -> typing.Optional["TenantSpecSideCarsContainersStartupProbeExec"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbe#exec
        '''
        result = self._values.get("exec")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersStartupProbeExec"], result)

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbe#failureThreshold
        '''
        result = self._values.get("failure_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def http_get(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersStartupProbeHttpGet"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbe#httpGet
        '''
        result = self._values.get("http_get")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersStartupProbeHttpGet"], result)

    @builtins.property
    def initial_delay_seconds(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbe#initialDelaySeconds
        '''
        result = self._values.get("initial_delay_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def period_seconds(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbe#periodSeconds
        '''
        result = self._values.get("period_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbe#successThreshold
        '''
        result = self._values.get("success_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def tcp_socket(
        self,
    ) -> typing.Optional["TenantSpecSideCarsContainersStartupProbeTcpSocket"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbe#tcpSocket
        '''
        result = self._values.get("tcp_socket")
        return typing.cast(typing.Optional["TenantSpecSideCarsContainersStartupProbeTcpSocket"], result)

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbe#timeoutSeconds
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersStartupProbe(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersStartupProbeExec",
    jsii_struct_bases=[],
    name_mapping={"command": "command"},
)
class TenantSpecSideCarsContainersStartupProbeExec:
    def __init__(
        self,
        *,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param command: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbeExec
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersStartupProbeExec.__init__)
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
        self._values: typing.Dict[str, typing.Any] = {}
        if command is not None:
            self._values["command"] = command

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbeExec#command
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersStartupProbeExec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersStartupProbeHttpGet",
    jsii_struct_bases=[],
    name_mapping={
        "port": "port",
        "host": "host",
        "http_headers": "httpHeaders",
        "path": "path",
        "scheme": "scheme",
    },
)
class TenantSpecSideCarsContainersStartupProbeHttpGet:
    def __init__(
        self,
        *,
        port: "TenantSpecSideCarsContainersStartupProbeHttpGetPort",
        host: typing.Optional[builtins.str] = None,
        http_headers: typing.Optional[typing.Sequence[typing.Union["TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders", typing.Dict[str, typing.Any]]]] = None,
        path: typing.Optional[builtins.str] = None,
        scheme: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param port: 
        :param host: 
        :param http_headers: 
        :param path: 
        :param scheme: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbeHttpGet
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersStartupProbeHttpGet.__init__)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument http_headers", value=http_headers, expected_type=type_hints["http_headers"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument scheme", value=scheme, expected_type=type_hints["scheme"])
        self._values: typing.Dict[str, typing.Any] = {
            "port": port,
        }
        if host is not None:
            self._values["host"] = host
        if http_headers is not None:
            self._values["http_headers"] = http_headers
        if path is not None:
            self._values["path"] = path
        if scheme is not None:
            self._values["scheme"] = scheme

    @builtins.property
    def port(self) -> "TenantSpecSideCarsContainersStartupProbeHttpGetPort":
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbeHttpGet#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast("TenantSpecSideCarsContainersStartupProbeHttpGetPort", result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbeHttpGet#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def http_headers(
        self,
    ) -> typing.Optional[typing.List["TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbeHttpGet#httpHeaders
        '''
        result = self._values.get("http_headers")
        return typing.cast(typing.Optional[typing.List["TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders"]], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbeHttpGet#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scheme(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbeHttpGet#scheme
        '''
        result = self._values.get("scheme")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersStartupProbeHttpGet(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        '''
        :param name: 
        :param value: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders#value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecSideCarsContainersStartupProbeHttpGetPort(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersStartupProbeHttpGetPort",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsContainersStartupProbeHttpGetPort
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsContainersStartupProbeHttpGetPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersStartupProbeHttpGetPort.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersStartupProbeHttpGetPort", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsContainersStartupProbeHttpGetPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersStartupProbeHttpGetPort.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersStartupProbeHttpGetPort", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersStartupProbeTcpSocket",
    jsii_struct_bases=[],
    name_mapping={"port": "port", "host": "host"},
)
class TenantSpecSideCarsContainersStartupProbeTcpSocket:
    def __init__(
        self,
        *,
        port: "TenantSpecSideCarsContainersStartupProbeTcpSocketPort",
        host: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param port: 
        :param host: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbeTcpSocket
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersStartupProbeTcpSocket.__init__)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
        self._values: typing.Dict[str, typing.Any] = {
            "port": port,
        }
        if host is not None:
            self._values["host"] = host

    @builtins.property
    def port(self) -> "TenantSpecSideCarsContainersStartupProbeTcpSocketPort":
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbeTcpSocket#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast("TenantSpecSideCarsContainersStartupProbeTcpSocketPort", result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersStartupProbeTcpSocket#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersStartupProbeTcpSocket(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecSideCarsContainersStartupProbeTcpSocketPort(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersStartupProbeTcpSocketPort",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsContainersStartupProbeTcpSocketPort
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsContainersStartupProbeTcpSocketPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersStartupProbeTcpSocketPort.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersStartupProbeTcpSocketPort", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsContainersStartupProbeTcpSocketPort":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersStartupProbeTcpSocketPort.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsContainersStartupProbeTcpSocketPort", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersVolumeDevices",
    jsii_struct_bases=[],
    name_mapping={"device_path": "devicePath", "name": "name"},
)
class TenantSpecSideCarsContainersVolumeDevices:
    def __init__(self, *, device_path: builtins.str, name: builtins.str) -> None:
        '''
        :param device_path: 
        :param name: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersVolumeDevices
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersVolumeDevices.__init__)
            check_type(argname="argument device_path", value=device_path, expected_type=type_hints["device_path"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[str, typing.Any] = {
            "device_path": device_path,
            "name": name,
        }

    @builtins.property
    def device_path(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersVolumeDevices#devicePath
        '''
        result = self._values.get("device_path")
        assert result is not None, "Required property 'device_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersVolumeDevices#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersVolumeDevices(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsContainersVolumeMounts",
    jsii_struct_bases=[],
    name_mapping={
        "mount_path": "mountPath",
        "name": "name",
        "mount_propagation": "mountPropagation",
        "read_only": "readOnly",
        "sub_path": "subPath",
        "sub_path_expr": "subPathExpr",
    },
)
class TenantSpecSideCarsContainersVolumeMounts:
    def __init__(
        self,
        *,
        mount_path: builtins.str,
        name: builtins.str,
        mount_propagation: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
        sub_path: typing.Optional[builtins.str] = None,
        sub_path_expr: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param mount_path: 
        :param name: 
        :param mount_propagation: 
        :param read_only: 
        :param sub_path: 
        :param sub_path_expr: 

        :stability: experimental
        :schema: TenantSpecSideCarsContainersVolumeMounts
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsContainersVolumeMounts.__init__)
            check_type(argname="argument mount_path", value=mount_path, expected_type=type_hints["mount_path"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument mount_propagation", value=mount_propagation, expected_type=type_hints["mount_propagation"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument sub_path", value=sub_path, expected_type=type_hints["sub_path"])
            check_type(argname="argument sub_path_expr", value=sub_path_expr, expected_type=type_hints["sub_path_expr"])
        self._values: typing.Dict[str, typing.Any] = {
            "mount_path": mount_path,
            "name": name,
        }
        if mount_propagation is not None:
            self._values["mount_propagation"] = mount_propagation
        if read_only is not None:
            self._values["read_only"] = read_only
        if sub_path is not None:
            self._values["sub_path"] = sub_path
        if sub_path_expr is not None:
            self._values["sub_path_expr"] = sub_path_expr

    @builtins.property
    def mount_path(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersVolumeMounts#mountPath
        '''
        result = self._values.get("mount_path")
        assert result is not None, "Required property 'mount_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersVolumeMounts#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def mount_propagation(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersVolumeMounts#mountPropagation
        '''
        result = self._values.get("mount_propagation")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersVolumeMounts#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def sub_path(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersVolumeMounts#subPath
        '''
        result = self._values.get("sub_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sub_path_expr(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsContainersVolumeMounts#subPathExpr
        '''
        result = self._values.get("sub_path_expr")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsContainersVolumeMounts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumeClaimTemplates",
    jsii_struct_bases=[],
    name_mapping={
        "api_version": "apiVersion",
        "kind": "kind",
        "metadata": "metadata",
        "spec": "spec",
        "status": "status",
    },
)
class TenantSpecSideCarsVolumeClaimTemplates:
    def __init__(
        self,
        *,
        api_version: typing.Optional[builtins.str] = None,
        kind: typing.Optional[builtins.str] = None,
        metadata: typing.Optional[typing.Union["TenantSpecSideCarsVolumeClaimTemplatesMetadata", typing.Dict[str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union["TenantSpecSideCarsVolumeClaimTemplatesSpec", typing.Dict[str, typing.Any]]] = None,
        status: typing.Optional[typing.Union["TenantSpecSideCarsVolumeClaimTemplatesStatus", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param api_version: 
        :param kind: 
        :param metadata: 
        :param spec: 
        :param status: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplates
        '''
        if isinstance(metadata, dict):
            metadata = TenantSpecSideCarsVolumeClaimTemplatesMetadata(**metadata)
        if isinstance(spec, dict):
            spec = TenantSpecSideCarsVolumeClaimTemplatesSpec(**spec)
        if isinstance(status, dict):
            status = TenantSpecSideCarsVolumeClaimTemplatesStatus(**status)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumeClaimTemplates.__init__)
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
            check_type(argname="argument status", value=status, expected_type=type_hints["status"])
        self._values: typing.Dict[str, typing.Any] = {}
        if api_version is not None:
            self._values["api_version"] = api_version
        if kind is not None:
            self._values["kind"] = kind
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec
        if status is not None:
            self._values["status"] = status

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplates#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kind(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplates#kind
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def metadata(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumeClaimTemplatesMetadata"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplates#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumeClaimTemplatesMetadata"], result)

    @builtins.property
    def spec(self) -> typing.Optional["TenantSpecSideCarsVolumeClaimTemplatesSpec"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplates#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumeClaimTemplatesSpec"], result)

    @builtins.property
    def status(self) -> typing.Optional["TenantSpecSideCarsVolumeClaimTemplatesStatus"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplates#status
        '''
        result = self._values.get("status")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumeClaimTemplatesStatus"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumeClaimTemplates(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumeClaimTemplatesMetadata",
    jsii_struct_bases=[],
    name_mapping={
        "annotations": "annotations",
        "finalizers": "finalizers",
        "labels": "labels",
        "name": "name",
        "namespace": "namespace",
    },
)
class TenantSpecSideCarsVolumeClaimTemplatesMetadata:
    def __init__(
        self,
        *,
        annotations: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        finalizers: typing.Optional[typing.Sequence[builtins.str]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        name: typing.Optional[builtins.str] = None,
        namespace: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param annotations: 
        :param finalizers: 
        :param labels: 
        :param name: 
        :param namespace: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesMetadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumeClaimTemplatesMetadata.__init__)
            check_type(argname="argument annotations", value=annotations, expected_type=type_hints["annotations"])
            check_type(argname="argument finalizers", value=finalizers, expected_type=type_hints["finalizers"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
        self._values: typing.Dict[str, typing.Any] = {}
        if annotations is not None:
            self._values["annotations"] = annotations
        if finalizers is not None:
            self._values["finalizers"] = finalizers
        if labels is not None:
            self._values["labels"] = labels
        if name is not None:
            self._values["name"] = name
        if namespace is not None:
            self._values["namespace"] = namespace

    @builtins.property
    def annotations(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesMetadata#annotations
        '''
        result = self._values.get("annotations")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def finalizers(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesMetadata#finalizers
        '''
        result = self._values.get("finalizers")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesMetadata#labels
        '''
        result = self._values.get("labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesMetadata#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def namespace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesMetadata#namespace
        '''
        result = self._values.get("namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumeClaimTemplatesMetadata(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumeClaimTemplatesSpec",
    jsii_struct_bases=[],
    name_mapping={
        "access_modes": "accessModes",
        "data_source": "dataSource",
        "resources": "resources",
        "selector": "selector",
        "storage_class_name": "storageClassName",
        "volume_mode": "volumeMode",
        "volume_name": "volumeName",
    },
)
class TenantSpecSideCarsVolumeClaimTemplatesSpec:
    def __init__(
        self,
        *,
        access_modes: typing.Optional[typing.Sequence[builtins.str]] = None,
        data_source: typing.Optional[typing.Union["TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource", typing.Dict[str, typing.Any]]] = None,
        resources: typing.Optional[typing.Union["TenantSpecSideCarsVolumeClaimTemplatesSpecResources", typing.Dict[str, typing.Any]]] = None,
        selector: typing.Optional[typing.Union["TenantSpecSideCarsVolumeClaimTemplatesSpecSelector", typing.Dict[str, typing.Any]]] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[builtins.str] = None,
        volume_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param access_modes: 
        :param data_source: 
        :param resources: 
        :param selector: 
        :param storage_class_name: 
        :param volume_mode: 
        :param volume_name: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpec
        '''
        if isinstance(data_source, dict):
            data_source = TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource(**data_source)
        if isinstance(resources, dict):
            resources = TenantSpecSideCarsVolumeClaimTemplatesSpecResources(**resources)
        if isinstance(selector, dict):
            selector = TenantSpecSideCarsVolumeClaimTemplatesSpecSelector(**selector)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumeClaimTemplatesSpec.__init__)
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument data_source", value=data_source, expected_type=type_hints["data_source"])
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
            check_type(argname="argument volume_name", value=volume_name, expected_type=type_hints["volume_name"])
        self._values: typing.Dict[str, typing.Any] = {}
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if data_source is not None:
            self._values["data_source"] = data_source
        if resources is not None:
            self._values["resources"] = resources
        if selector is not None:
            self._values["selector"] = selector
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode
        if volume_name is not None:
            self._values["volume_name"] = volume_name

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpec#accessModes
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def data_source(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpec#dataSource
        '''
        result = self._values.get("data_source")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource"], result)

    @builtins.property
    def resources(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumeClaimTemplatesSpecResources"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpec#resources
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumeClaimTemplatesSpecResources"], result)

    @builtins.property
    def selector(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumeClaimTemplatesSpecSelector"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpec#selector
        '''
        result = self._values.get("selector")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumeClaimTemplatesSpecSelector"], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpec#storageClassName
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpec#volumeMode
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpec#volumeName
        '''
        result = self._values.get("volume_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumeClaimTemplatesSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource",
    jsii_struct_bases=[],
    name_mapping={"kind": "kind", "name": "name", "api_group": "apiGroup"},
)
class TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource:
    def __init__(
        self,
        *,
        kind: builtins.str,
        name: builtins.str,
        api_group: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param kind: 
        :param name: 
        :param api_group: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource.__init__)
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument api_group", value=api_group, expected_type=type_hints["api_group"])
        self._values: typing.Dict[str, typing.Any] = {
            "kind": kind,
            "name": name,
        }
        if api_group is not None:
            self._values["api_group"] = api_group

    @builtins.property
    def kind(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource#kind
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_group(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource#apiGroup
        '''
        result = self._values.get("api_group")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumeClaimTemplatesSpecResources",
    jsii_struct_bases=[],
    name_mapping={"limits": "limits", "requests": "requests"},
)
class TenantSpecSideCarsVolumeClaimTemplatesSpecResources:
    def __init__(
        self,
        *,
        limits: typing.Optional[typing.Mapping[builtins.str, "TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits"]] = None,
        requests: typing.Optional[typing.Mapping[builtins.str, "TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests"]] = None,
    ) -> None:
        '''
        :param limits: 
        :param requests: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpecResources
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumeClaimTemplatesSpecResources.__init__)
            check_type(argname="argument limits", value=limits, expected_type=type_hints["limits"])
            check_type(argname="argument requests", value=requests, expected_type=type_hints["requests"])
        self._values: typing.Dict[str, typing.Any] = {}
        if limits is not None:
            self._values["limits"] = limits
        if requests is not None:
            self._values["requests"] = requests

    @builtins.property
    def limits(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpecResources#limits
        '''
        result = self._values.get("limits")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits"]], result)

    @builtins.property
    def requests(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpecResources#requests
        '''
        result = self._values.get("requests")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumeClaimTemplatesSpecResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


class TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumeClaimTemplatesSpecSelector",
    jsii_struct_bases=[],
    name_mapping={
        "match_expressions": "matchExpressions",
        "match_labels": "matchLabels",
    },
)
class TenantSpecSideCarsVolumeClaimTemplatesSpecSelector:
    def __init__(
        self,
        *,
        match_expressions: typing.Optional[typing.Sequence[typing.Union["TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions", typing.Dict[str, typing.Any]]]] = None,
        match_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param match_expressions: 
        :param match_labels: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpecSelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumeClaimTemplatesSpecSelector.__init__)
            check_type(argname="argument match_expressions", value=match_expressions, expected_type=type_hints["match_expressions"])
            check_type(argname="argument match_labels", value=match_labels, expected_type=type_hints["match_labels"])
        self._values: typing.Dict[str, typing.Any] = {}
        if match_expressions is not None:
            self._values["match_expressions"] = match_expressions
        if match_labels is not None:
            self._values["match_labels"] = match_labels

    @builtins.property
    def match_expressions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpecSelector#matchExpressions
        '''
        result = self._values.get("match_expressions")
        return typing.cast(typing.Optional[typing.List["TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions"]], result)

    @builtins.property
    def match_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpecSelector#matchLabels
        '''
        result = self._values.get("match_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumeClaimTemplatesSpecSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param key: 
        :param operator: 
        :param values: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions#operator
        '''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions#values
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumeClaimTemplatesStatus",
    jsii_struct_bases=[],
    name_mapping={
        "access_modes": "accessModes",
        "capacity": "capacity",
        "conditions": "conditions",
        "phase": "phase",
    },
)
class TenantSpecSideCarsVolumeClaimTemplatesStatus:
    def __init__(
        self,
        *,
        access_modes: typing.Optional[typing.Sequence[builtins.str]] = None,
        capacity: typing.Optional[typing.Mapping[builtins.str, "TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity"]] = None,
        conditions: typing.Optional[typing.Sequence[typing.Union["TenantSpecSideCarsVolumeClaimTemplatesStatusConditions", typing.Dict[str, typing.Any]]]] = None,
        phase: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param access_modes: 
        :param capacity: 
        :param conditions: 
        :param phase: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesStatus
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumeClaimTemplatesStatus.__init__)
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument capacity", value=capacity, expected_type=type_hints["capacity"])
            check_type(argname="argument conditions", value=conditions, expected_type=type_hints["conditions"])
            check_type(argname="argument phase", value=phase, expected_type=type_hints["phase"])
        self._values: typing.Dict[str, typing.Any] = {}
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if capacity is not None:
            self._values["capacity"] = capacity
        if conditions is not None:
            self._values["conditions"] = conditions
        if phase is not None:
            self._values["phase"] = phase

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesStatus#accessModes
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def capacity(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesStatus#capacity
        '''
        result = self._values.get("capacity")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity"]], result)

    @builtins.property
    def conditions(
        self,
    ) -> typing.Optional[typing.List["TenantSpecSideCarsVolumeClaimTemplatesStatusConditions"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesStatus#conditions
        '''
        result = self._values.get("conditions")
        return typing.cast(typing.Optional[typing.List["TenantSpecSideCarsVolumeClaimTemplatesStatusConditions"]], result)

    @builtins.property
    def phase(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesStatus#phase
        '''
        result = self._values.get("phase")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumeClaimTemplatesStatus(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumeClaimTemplatesStatusConditions",
    jsii_struct_bases=[],
    name_mapping={
        "status": "status",
        "type": "type",
        "last_probe_time": "lastProbeTime",
        "last_transition_time": "lastTransitionTime",
        "message": "message",
        "reason": "reason",
    },
)
class TenantSpecSideCarsVolumeClaimTemplatesStatusConditions:
    def __init__(
        self,
        *,
        status: builtins.str,
        type: builtins.str,
        last_probe_time: typing.Optional[datetime.datetime] = None,
        last_transition_time: typing.Optional[datetime.datetime] = None,
        message: typing.Optional[builtins.str] = None,
        reason: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param status: 
        :param type: 
        :param last_probe_time: 
        :param last_transition_time: 
        :param message: 
        :param reason: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesStatusConditions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumeClaimTemplatesStatusConditions.__init__)
            check_type(argname="argument status", value=status, expected_type=type_hints["status"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument last_probe_time", value=last_probe_time, expected_type=type_hints["last_probe_time"])
            check_type(argname="argument last_transition_time", value=last_transition_time, expected_type=type_hints["last_transition_time"])
            check_type(argname="argument message", value=message, expected_type=type_hints["message"])
            check_type(argname="argument reason", value=reason, expected_type=type_hints["reason"])
        self._values: typing.Dict[str, typing.Any] = {
            "status": status,
            "type": type,
        }
        if last_probe_time is not None:
            self._values["last_probe_time"] = last_probe_time
        if last_transition_time is not None:
            self._values["last_transition_time"] = last_transition_time
        if message is not None:
            self._values["message"] = message
        if reason is not None:
            self._values["reason"] = reason

    @builtins.property
    def status(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesStatusConditions#status
        '''
        result = self._values.get("status")
        assert result is not None, "Required property 'status' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesStatusConditions#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def last_probe_time(self) -> typing.Optional[datetime.datetime]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesStatusConditions#lastProbeTime
        '''
        result = self._values.get("last_probe_time")
        return typing.cast(typing.Optional[datetime.datetime], result)

    @builtins.property
    def last_transition_time(self) -> typing.Optional[datetime.datetime]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesStatusConditions#lastTransitionTime
        '''
        result = self._values.get("last_transition_time")
        return typing.cast(typing.Optional[datetime.datetime], result)

    @builtins.property
    def message(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesStatusConditions#message
        '''
        result = self._values.get("message")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def reason(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumeClaimTemplatesStatusConditions#reason
        '''
        result = self._values.get("reason")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumeClaimTemplatesStatusConditions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumes",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "aws_elastic_block_store": "awsElasticBlockStore",
        "azure_disk": "azureDisk",
        "azure_file": "azureFile",
        "cephfs": "cephfs",
        "cinder": "cinder",
        "config_map": "configMap",
        "csi": "csi",
        "downward_api": "downwardApi",
        "empty_dir": "emptyDir",
        "ephemeral": "ephemeral",
        "fc": "fc",
        "flex_volume": "flexVolume",
        "flocker": "flocker",
        "gce_persistent_disk": "gcePersistentDisk",
        "git_repo": "gitRepo",
        "glusterfs": "glusterfs",
        "host_path": "hostPath",
        "iscsi": "iscsi",
        "nfs": "nfs",
        "persistent_volume_claim": "persistentVolumeClaim",
        "photon_persistent_disk": "photonPersistentDisk",
        "portworx_volume": "portworxVolume",
        "projected": "projected",
        "quobyte": "quobyte",
        "rbd": "rbd",
        "scale_io": "scaleIo",
        "secret": "secret",
        "storageos": "storageos",
        "vsphere_volume": "vsphereVolume",
    },
)
class TenantSpecSideCarsVolumes:
    def __init__(
        self,
        *,
        name: builtins.str,
        aws_elastic_block_store: typing.Optional[typing.Union["TenantSpecSideCarsVolumesAwsElasticBlockStore", typing.Dict[str, typing.Any]]] = None,
        azure_disk: typing.Optional[typing.Union["TenantSpecSideCarsVolumesAzureDisk", typing.Dict[str, typing.Any]]] = None,
        azure_file: typing.Optional[typing.Union["TenantSpecSideCarsVolumesAzureFile", typing.Dict[str, typing.Any]]] = None,
        cephfs: typing.Optional[typing.Union["TenantSpecSideCarsVolumesCephfs", typing.Dict[str, typing.Any]]] = None,
        cinder: typing.Optional[typing.Union["TenantSpecSideCarsVolumesCinder", typing.Dict[str, typing.Any]]] = None,
        config_map: typing.Optional[typing.Union["TenantSpecSideCarsVolumesConfigMap", typing.Dict[str, typing.Any]]] = None,
        csi: typing.Optional[typing.Union["TenantSpecSideCarsVolumesCsi", typing.Dict[str, typing.Any]]] = None,
        downward_api: typing.Optional[typing.Union["TenantSpecSideCarsVolumesDownwardApi", typing.Dict[str, typing.Any]]] = None,
        empty_dir: typing.Optional[typing.Union["TenantSpecSideCarsVolumesEmptyDir", typing.Dict[str, typing.Any]]] = None,
        ephemeral: typing.Optional[typing.Union["TenantSpecSideCarsVolumesEphemeral", typing.Dict[str, typing.Any]]] = None,
        fc: typing.Optional[typing.Union["TenantSpecSideCarsVolumesFc", typing.Dict[str, typing.Any]]] = None,
        flex_volume: typing.Optional[typing.Union["TenantSpecSideCarsVolumesFlexVolume", typing.Dict[str, typing.Any]]] = None,
        flocker: typing.Optional[typing.Union["TenantSpecSideCarsVolumesFlocker", typing.Dict[str, typing.Any]]] = None,
        gce_persistent_disk: typing.Optional[typing.Union["TenantSpecSideCarsVolumesGcePersistentDisk", typing.Dict[str, typing.Any]]] = None,
        git_repo: typing.Optional[typing.Union["TenantSpecSideCarsVolumesGitRepo", typing.Dict[str, typing.Any]]] = None,
        glusterfs: typing.Optional[typing.Union["TenantSpecSideCarsVolumesGlusterfs", typing.Dict[str, typing.Any]]] = None,
        host_path: typing.Optional[typing.Union["TenantSpecSideCarsVolumesHostPath", typing.Dict[str, typing.Any]]] = None,
        iscsi: typing.Optional[typing.Union["TenantSpecSideCarsVolumesIscsi", typing.Dict[str, typing.Any]]] = None,
        nfs: typing.Optional[typing.Union["TenantSpecSideCarsVolumesNfs", typing.Dict[str, typing.Any]]] = None,
        persistent_volume_claim: typing.Optional[typing.Union["TenantSpecSideCarsVolumesPersistentVolumeClaim", typing.Dict[str, typing.Any]]] = None,
        photon_persistent_disk: typing.Optional[typing.Union["TenantSpecSideCarsVolumesPhotonPersistentDisk", typing.Dict[str, typing.Any]]] = None,
        portworx_volume: typing.Optional[typing.Union["TenantSpecSideCarsVolumesPortworxVolume", typing.Dict[str, typing.Any]]] = None,
        projected: typing.Optional[typing.Union["TenantSpecSideCarsVolumesProjected", typing.Dict[str, typing.Any]]] = None,
        quobyte: typing.Optional[typing.Union["TenantSpecSideCarsVolumesQuobyte", typing.Dict[str, typing.Any]]] = None,
        rbd: typing.Optional[typing.Union["TenantSpecSideCarsVolumesRbd", typing.Dict[str, typing.Any]]] = None,
        scale_io: typing.Optional[typing.Union["TenantSpecSideCarsVolumesScaleIo", typing.Dict[str, typing.Any]]] = None,
        secret: typing.Optional[typing.Union["TenantSpecSideCarsVolumesSecret", typing.Dict[str, typing.Any]]] = None,
        storageos: typing.Optional[typing.Union["TenantSpecSideCarsVolumesStorageos", typing.Dict[str, typing.Any]]] = None,
        vsphere_volume: typing.Optional[typing.Union["TenantSpecSideCarsVolumesVsphereVolume", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param name: 
        :param aws_elastic_block_store: 
        :param azure_disk: 
        :param azure_file: 
        :param cephfs: 
        :param cinder: 
        :param config_map: 
        :param csi: 
        :param downward_api: 
        :param empty_dir: 
        :param ephemeral: 
        :param fc: 
        :param flex_volume: 
        :param flocker: 
        :param gce_persistent_disk: 
        :param git_repo: 
        :param glusterfs: 
        :param host_path: 
        :param iscsi: 
        :param nfs: 
        :param persistent_volume_claim: 
        :param photon_persistent_disk: 
        :param portworx_volume: 
        :param projected: 
        :param quobyte: 
        :param rbd: 
        :param scale_io: 
        :param secret: 
        :param storageos: 
        :param vsphere_volume: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumes
        '''
        if isinstance(aws_elastic_block_store, dict):
            aws_elastic_block_store = TenantSpecSideCarsVolumesAwsElasticBlockStore(**aws_elastic_block_store)
        if isinstance(azure_disk, dict):
            azure_disk = TenantSpecSideCarsVolumesAzureDisk(**azure_disk)
        if isinstance(azure_file, dict):
            azure_file = TenantSpecSideCarsVolumesAzureFile(**azure_file)
        if isinstance(cephfs, dict):
            cephfs = TenantSpecSideCarsVolumesCephfs(**cephfs)
        if isinstance(cinder, dict):
            cinder = TenantSpecSideCarsVolumesCinder(**cinder)
        if isinstance(config_map, dict):
            config_map = TenantSpecSideCarsVolumesConfigMap(**config_map)
        if isinstance(csi, dict):
            csi = TenantSpecSideCarsVolumesCsi(**csi)
        if isinstance(downward_api, dict):
            downward_api = TenantSpecSideCarsVolumesDownwardApi(**downward_api)
        if isinstance(empty_dir, dict):
            empty_dir = TenantSpecSideCarsVolumesEmptyDir(**empty_dir)
        if isinstance(ephemeral, dict):
            ephemeral = TenantSpecSideCarsVolumesEphemeral(**ephemeral)
        if isinstance(fc, dict):
            fc = TenantSpecSideCarsVolumesFc(**fc)
        if isinstance(flex_volume, dict):
            flex_volume = TenantSpecSideCarsVolumesFlexVolume(**flex_volume)
        if isinstance(flocker, dict):
            flocker = TenantSpecSideCarsVolumesFlocker(**flocker)
        if isinstance(gce_persistent_disk, dict):
            gce_persistent_disk = TenantSpecSideCarsVolumesGcePersistentDisk(**gce_persistent_disk)
        if isinstance(git_repo, dict):
            git_repo = TenantSpecSideCarsVolumesGitRepo(**git_repo)
        if isinstance(glusterfs, dict):
            glusterfs = TenantSpecSideCarsVolumesGlusterfs(**glusterfs)
        if isinstance(host_path, dict):
            host_path = TenantSpecSideCarsVolumesHostPath(**host_path)
        if isinstance(iscsi, dict):
            iscsi = TenantSpecSideCarsVolumesIscsi(**iscsi)
        if isinstance(nfs, dict):
            nfs = TenantSpecSideCarsVolumesNfs(**nfs)
        if isinstance(persistent_volume_claim, dict):
            persistent_volume_claim = TenantSpecSideCarsVolumesPersistentVolumeClaim(**persistent_volume_claim)
        if isinstance(photon_persistent_disk, dict):
            photon_persistent_disk = TenantSpecSideCarsVolumesPhotonPersistentDisk(**photon_persistent_disk)
        if isinstance(portworx_volume, dict):
            portworx_volume = TenantSpecSideCarsVolumesPortworxVolume(**portworx_volume)
        if isinstance(projected, dict):
            projected = TenantSpecSideCarsVolumesProjected(**projected)
        if isinstance(quobyte, dict):
            quobyte = TenantSpecSideCarsVolumesQuobyte(**quobyte)
        if isinstance(rbd, dict):
            rbd = TenantSpecSideCarsVolumesRbd(**rbd)
        if isinstance(scale_io, dict):
            scale_io = TenantSpecSideCarsVolumesScaleIo(**scale_io)
        if isinstance(secret, dict):
            secret = TenantSpecSideCarsVolumesSecret(**secret)
        if isinstance(storageos, dict):
            storageos = TenantSpecSideCarsVolumesStorageos(**storageos)
        if isinstance(vsphere_volume, dict):
            vsphere_volume = TenantSpecSideCarsVolumesVsphereVolume(**vsphere_volume)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumes.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument aws_elastic_block_store", value=aws_elastic_block_store, expected_type=type_hints["aws_elastic_block_store"])
            check_type(argname="argument azure_disk", value=azure_disk, expected_type=type_hints["azure_disk"])
            check_type(argname="argument azure_file", value=azure_file, expected_type=type_hints["azure_file"])
            check_type(argname="argument cephfs", value=cephfs, expected_type=type_hints["cephfs"])
            check_type(argname="argument cinder", value=cinder, expected_type=type_hints["cinder"])
            check_type(argname="argument config_map", value=config_map, expected_type=type_hints["config_map"])
            check_type(argname="argument csi", value=csi, expected_type=type_hints["csi"])
            check_type(argname="argument downward_api", value=downward_api, expected_type=type_hints["downward_api"])
            check_type(argname="argument empty_dir", value=empty_dir, expected_type=type_hints["empty_dir"])
            check_type(argname="argument ephemeral", value=ephemeral, expected_type=type_hints["ephemeral"])
            check_type(argname="argument fc", value=fc, expected_type=type_hints["fc"])
            check_type(argname="argument flex_volume", value=flex_volume, expected_type=type_hints["flex_volume"])
            check_type(argname="argument flocker", value=flocker, expected_type=type_hints["flocker"])
            check_type(argname="argument gce_persistent_disk", value=gce_persistent_disk, expected_type=type_hints["gce_persistent_disk"])
            check_type(argname="argument git_repo", value=git_repo, expected_type=type_hints["git_repo"])
            check_type(argname="argument glusterfs", value=glusterfs, expected_type=type_hints["glusterfs"])
            check_type(argname="argument host_path", value=host_path, expected_type=type_hints["host_path"])
            check_type(argname="argument iscsi", value=iscsi, expected_type=type_hints["iscsi"])
            check_type(argname="argument nfs", value=nfs, expected_type=type_hints["nfs"])
            check_type(argname="argument persistent_volume_claim", value=persistent_volume_claim, expected_type=type_hints["persistent_volume_claim"])
            check_type(argname="argument photon_persistent_disk", value=photon_persistent_disk, expected_type=type_hints["photon_persistent_disk"])
            check_type(argname="argument portworx_volume", value=portworx_volume, expected_type=type_hints["portworx_volume"])
            check_type(argname="argument projected", value=projected, expected_type=type_hints["projected"])
            check_type(argname="argument quobyte", value=quobyte, expected_type=type_hints["quobyte"])
            check_type(argname="argument rbd", value=rbd, expected_type=type_hints["rbd"])
            check_type(argname="argument scale_io", value=scale_io, expected_type=type_hints["scale_io"])
            check_type(argname="argument secret", value=secret, expected_type=type_hints["secret"])
            check_type(argname="argument storageos", value=storageos, expected_type=type_hints["storageos"])
            check_type(argname="argument vsphere_volume", value=vsphere_volume, expected_type=type_hints["vsphere_volume"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if aws_elastic_block_store is not None:
            self._values["aws_elastic_block_store"] = aws_elastic_block_store
        if azure_disk is not None:
            self._values["azure_disk"] = azure_disk
        if azure_file is not None:
            self._values["azure_file"] = azure_file
        if cephfs is not None:
            self._values["cephfs"] = cephfs
        if cinder is not None:
            self._values["cinder"] = cinder
        if config_map is not None:
            self._values["config_map"] = config_map
        if csi is not None:
            self._values["csi"] = csi
        if downward_api is not None:
            self._values["downward_api"] = downward_api
        if empty_dir is not None:
            self._values["empty_dir"] = empty_dir
        if ephemeral is not None:
            self._values["ephemeral"] = ephemeral
        if fc is not None:
            self._values["fc"] = fc
        if flex_volume is not None:
            self._values["flex_volume"] = flex_volume
        if flocker is not None:
            self._values["flocker"] = flocker
        if gce_persistent_disk is not None:
            self._values["gce_persistent_disk"] = gce_persistent_disk
        if git_repo is not None:
            self._values["git_repo"] = git_repo
        if glusterfs is not None:
            self._values["glusterfs"] = glusterfs
        if host_path is not None:
            self._values["host_path"] = host_path
        if iscsi is not None:
            self._values["iscsi"] = iscsi
        if nfs is not None:
            self._values["nfs"] = nfs
        if persistent_volume_claim is not None:
            self._values["persistent_volume_claim"] = persistent_volume_claim
        if photon_persistent_disk is not None:
            self._values["photon_persistent_disk"] = photon_persistent_disk
        if portworx_volume is not None:
            self._values["portworx_volume"] = portworx_volume
        if projected is not None:
            self._values["projected"] = projected
        if quobyte is not None:
            self._values["quobyte"] = quobyte
        if rbd is not None:
            self._values["rbd"] = rbd
        if scale_io is not None:
            self._values["scale_io"] = scale_io
        if secret is not None:
            self._values["secret"] = secret
        if storageos is not None:
            self._values["storageos"] = storageos
        if vsphere_volume is not None:
            self._values["vsphere_volume"] = vsphere_volume

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def aws_elastic_block_store(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumesAwsElasticBlockStore"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#awsElasticBlockStore
        '''
        result = self._values.get("aws_elastic_block_store")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesAwsElasticBlockStore"], result)

    @builtins.property
    def azure_disk(self) -> typing.Optional["TenantSpecSideCarsVolumesAzureDisk"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#azureDisk
        '''
        result = self._values.get("azure_disk")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesAzureDisk"], result)

    @builtins.property
    def azure_file(self) -> typing.Optional["TenantSpecSideCarsVolumesAzureFile"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#azureFile
        '''
        result = self._values.get("azure_file")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesAzureFile"], result)

    @builtins.property
    def cephfs(self) -> typing.Optional["TenantSpecSideCarsVolumesCephfs"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#cephfs
        '''
        result = self._values.get("cephfs")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesCephfs"], result)

    @builtins.property
    def cinder(self) -> typing.Optional["TenantSpecSideCarsVolumesCinder"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#cinder
        '''
        result = self._values.get("cinder")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesCinder"], result)

    @builtins.property
    def config_map(self) -> typing.Optional["TenantSpecSideCarsVolumesConfigMap"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#configMap
        '''
        result = self._values.get("config_map")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesConfigMap"], result)

    @builtins.property
    def csi(self) -> typing.Optional["TenantSpecSideCarsVolumesCsi"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#csi
        '''
        result = self._values.get("csi")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesCsi"], result)

    @builtins.property
    def downward_api(self) -> typing.Optional["TenantSpecSideCarsVolumesDownwardApi"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#downwardAPI
        '''
        result = self._values.get("downward_api")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesDownwardApi"], result)

    @builtins.property
    def empty_dir(self) -> typing.Optional["TenantSpecSideCarsVolumesEmptyDir"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#emptyDir
        '''
        result = self._values.get("empty_dir")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesEmptyDir"], result)

    @builtins.property
    def ephemeral(self) -> typing.Optional["TenantSpecSideCarsVolumesEphemeral"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#ephemeral
        '''
        result = self._values.get("ephemeral")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesEphemeral"], result)

    @builtins.property
    def fc(self) -> typing.Optional["TenantSpecSideCarsVolumesFc"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#fc
        '''
        result = self._values.get("fc")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesFc"], result)

    @builtins.property
    def flex_volume(self) -> typing.Optional["TenantSpecSideCarsVolumesFlexVolume"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#flexVolume
        '''
        result = self._values.get("flex_volume")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesFlexVolume"], result)

    @builtins.property
    def flocker(self) -> typing.Optional["TenantSpecSideCarsVolumesFlocker"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#flocker
        '''
        result = self._values.get("flocker")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesFlocker"], result)

    @builtins.property
    def gce_persistent_disk(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumesGcePersistentDisk"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#gcePersistentDisk
        '''
        result = self._values.get("gce_persistent_disk")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesGcePersistentDisk"], result)

    @builtins.property
    def git_repo(self) -> typing.Optional["TenantSpecSideCarsVolumesGitRepo"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#gitRepo
        '''
        result = self._values.get("git_repo")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesGitRepo"], result)

    @builtins.property
    def glusterfs(self) -> typing.Optional["TenantSpecSideCarsVolumesGlusterfs"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#glusterfs
        '''
        result = self._values.get("glusterfs")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesGlusterfs"], result)

    @builtins.property
    def host_path(self) -> typing.Optional["TenantSpecSideCarsVolumesHostPath"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#hostPath
        '''
        result = self._values.get("host_path")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesHostPath"], result)

    @builtins.property
    def iscsi(self) -> typing.Optional["TenantSpecSideCarsVolumesIscsi"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#iscsi
        '''
        result = self._values.get("iscsi")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesIscsi"], result)

    @builtins.property
    def nfs(self) -> typing.Optional["TenantSpecSideCarsVolumesNfs"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#nfs
        '''
        result = self._values.get("nfs")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesNfs"], result)

    @builtins.property
    def persistent_volume_claim(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumesPersistentVolumeClaim"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#persistentVolumeClaim
        '''
        result = self._values.get("persistent_volume_claim")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesPersistentVolumeClaim"], result)

    @builtins.property
    def photon_persistent_disk(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumesPhotonPersistentDisk"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#photonPersistentDisk
        '''
        result = self._values.get("photon_persistent_disk")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesPhotonPersistentDisk"], result)

    @builtins.property
    def portworx_volume(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumesPortworxVolume"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#portworxVolume
        '''
        result = self._values.get("portworx_volume")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesPortworxVolume"], result)

    @builtins.property
    def projected(self) -> typing.Optional["TenantSpecSideCarsVolumesProjected"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#projected
        '''
        result = self._values.get("projected")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesProjected"], result)

    @builtins.property
    def quobyte(self) -> typing.Optional["TenantSpecSideCarsVolumesQuobyte"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#quobyte
        '''
        result = self._values.get("quobyte")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesQuobyte"], result)

    @builtins.property
    def rbd(self) -> typing.Optional["TenantSpecSideCarsVolumesRbd"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#rbd
        '''
        result = self._values.get("rbd")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesRbd"], result)

    @builtins.property
    def scale_io(self) -> typing.Optional["TenantSpecSideCarsVolumesScaleIo"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#scaleIO
        '''
        result = self._values.get("scale_io")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesScaleIo"], result)

    @builtins.property
    def secret(self) -> typing.Optional["TenantSpecSideCarsVolumesSecret"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#secret
        '''
        result = self._values.get("secret")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesSecret"], result)

    @builtins.property
    def storageos(self) -> typing.Optional["TenantSpecSideCarsVolumesStorageos"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#storageos
        '''
        result = self._values.get("storageos")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesStorageos"], result)

    @builtins.property
    def vsphere_volume(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumesVsphereVolume"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumes#vsphereVolume
        '''
        result = self._values.get("vsphere_volume")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesVsphereVolume"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumes(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesAwsElasticBlockStore",
    jsii_struct_bases=[],
    name_mapping={
        "volume_id": "volumeId",
        "fs_type": "fsType",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class TenantSpecSideCarsVolumesAwsElasticBlockStore:
    def __init__(
        self,
        *,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param volume_id: 
        :param fs_type: 
        :param partition: 
        :param read_only: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesAwsElasticBlockStore
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesAwsElasticBlockStore.__init__)
            check_type(argname="argument volume_id", value=volume_id, expected_type=type_hints["volume_id"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[str, typing.Any] = {
            "volume_id": volume_id,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def volume_id(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesAwsElasticBlockStore#volumeID
        '''
        result = self._values.get("volume_id")
        assert result is not None, "Required property 'volume_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesAwsElasticBlockStore#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesAwsElasticBlockStore#partition
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesAwsElasticBlockStore#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesAwsElasticBlockStore(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesAzureDisk",
    jsii_struct_bases=[],
    name_mapping={
        "disk_name": "diskName",
        "disk_uri": "diskUri",
        "caching_mode": "cachingMode",
        "fs_type": "fsType",
        "kind": "kind",
        "read_only": "readOnly",
    },
)
class TenantSpecSideCarsVolumesAzureDisk:
    def __init__(
        self,
        *,
        disk_name: builtins.str,
        disk_uri: builtins.str,
        caching_mode: typing.Optional[builtins.str] = None,
        fs_type: typing.Optional[builtins.str] = None,
        kind: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param disk_name: 
        :param disk_uri: 
        :param caching_mode: 
        :param fs_type: 
        :param kind: 
        :param read_only: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesAzureDisk
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesAzureDisk.__init__)
            check_type(argname="argument disk_name", value=disk_name, expected_type=type_hints["disk_name"])
            check_type(argname="argument disk_uri", value=disk_uri, expected_type=type_hints["disk_uri"])
            check_type(argname="argument caching_mode", value=caching_mode, expected_type=type_hints["caching_mode"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[str, typing.Any] = {
            "disk_name": disk_name,
            "disk_uri": disk_uri,
        }
        if caching_mode is not None:
            self._values["caching_mode"] = caching_mode
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if kind is not None:
            self._values["kind"] = kind
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def disk_name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesAzureDisk#diskName
        '''
        result = self._values.get("disk_name")
        assert result is not None, "Required property 'disk_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def disk_uri(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesAzureDisk#diskURI
        '''
        result = self._values.get("disk_uri")
        assert result is not None, "Required property 'disk_uri' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def caching_mode(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesAzureDisk#cachingMode
        '''
        result = self._values.get("caching_mode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesAzureDisk#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kind(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesAzureDisk#kind
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesAzureDisk#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesAzureDisk(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesAzureFile",
    jsii_struct_bases=[],
    name_mapping={
        "secret_name": "secretName",
        "share_name": "shareName",
        "read_only": "readOnly",
    },
)
class TenantSpecSideCarsVolumesAzureFile:
    def __init__(
        self,
        *,
        secret_name: builtins.str,
        share_name: builtins.str,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param secret_name: 
        :param share_name: 
        :param read_only: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesAzureFile
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesAzureFile.__init__)
            check_type(argname="argument secret_name", value=secret_name, expected_type=type_hints["secret_name"])
            check_type(argname="argument share_name", value=share_name, expected_type=type_hints["share_name"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[str, typing.Any] = {
            "secret_name": secret_name,
            "share_name": share_name,
        }
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def secret_name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesAzureFile#secretName
        '''
        result = self._values.get("secret_name")
        assert result is not None, "Required property 'secret_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def share_name(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesAzureFile#shareName
        '''
        result = self._values.get("share_name")
        assert result is not None, "Required property 'share_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesAzureFile#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesAzureFile(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesCephfs",
    jsii_struct_bases=[],
    name_mapping={
        "monitors": "monitors",
        "path": "path",
        "read_only": "readOnly",
        "secret_file": "secretFile",
        "secret_ref": "secretRef",
        "user": "user",
    },
)
class TenantSpecSideCarsVolumesCephfs:
    def __init__(
        self,
        *,
        monitors: typing.Sequence[builtins.str],
        path: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_file: typing.Optional[builtins.str] = None,
        secret_ref: typing.Optional[typing.Union["TenantSpecSideCarsVolumesCephfsSecretRef", typing.Dict[str, typing.Any]]] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param monitors: 
        :param path: 
        :param read_only: 
        :param secret_file: 
        :param secret_ref: 
        :param user: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCephfs
        '''
        if isinstance(secret_ref, dict):
            secret_ref = TenantSpecSideCarsVolumesCephfsSecretRef(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesCephfs.__init__)
            check_type(argname="argument monitors", value=monitors, expected_type=type_hints["monitors"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_file", value=secret_file, expected_type=type_hints["secret_file"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[str, typing.Any] = {
            "monitors": monitors,
        }
        if path is not None:
            self._values["path"] = path
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_file is not None:
            self._values["secret_file"] = secret_file
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def monitors(self) -> typing.List[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCephfs#monitors
        '''
        result = self._values.get("monitors")
        assert result is not None, "Required property 'monitors' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCephfs#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCephfs#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_file(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCephfs#secretFile
        '''
        result = self._values.get("secret_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["TenantSpecSideCarsVolumesCephfsSecretRef"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCephfs#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesCephfsSecretRef"], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCephfs#user
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesCephfs(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesCephfsSecretRef",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class TenantSpecSideCarsVolumesCephfsSecretRef:
    def __init__(self, *, name: typing.Optional[builtins.str] = None) -> None:
        '''
        :param name: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCephfsSecretRef
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesCephfsSecretRef.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCephfsSecretRef#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesCephfsSecretRef(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesCinder",
    jsii_struct_bases=[],
    name_mapping={
        "volume_id": "volumeId",
        "fs_type": "fsType",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class TenantSpecSideCarsVolumesCinder:
    def __init__(
        self,
        *,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional[typing.Union["TenantSpecSideCarsVolumesCinderSecretRef", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param volume_id: 
        :param fs_type: 
        :param read_only: 
        :param secret_ref: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCinder
        '''
        if isinstance(secret_ref, dict):
            secret_ref = TenantSpecSideCarsVolumesCinderSecretRef(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesCinder.__init__)
            check_type(argname="argument volume_id", value=volume_id, expected_type=type_hints["volume_id"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
        self._values: typing.Dict[str, typing.Any] = {
            "volume_id": volume_id,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def volume_id(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCinder#volumeID
        '''
        result = self._values.get("volume_id")
        assert result is not None, "Required property 'volume_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCinder#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCinder#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["TenantSpecSideCarsVolumesCinderSecretRef"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCinder#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesCinderSecretRef"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesCinder(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesCinderSecretRef",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class TenantSpecSideCarsVolumesCinderSecretRef:
    def __init__(self, *, name: typing.Optional[builtins.str] = None) -> None:
        '''
        :param name: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCinderSecretRef
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesCinderSecretRef.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCinderSecretRef#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesCinderSecretRef(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesConfigMap",
    jsii_struct_bases=[],
    name_mapping={
        "default_mode": "defaultMode",
        "items": "items",
        "name": "name",
        "optional": "optional",
    },
)
class TenantSpecSideCarsVolumesConfigMap:
    def __init__(
        self,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Sequence[typing.Union["TenantSpecSideCarsVolumesConfigMapItems", typing.Dict[str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param default_mode: 
        :param items: 
        :param name: 
        :param optional: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesConfigMap
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesConfigMap.__init__)
            check_type(argname="argument default_mode", value=default_mode, expected_type=type_hints["default_mode"])
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[str, typing.Any] = {}
        if default_mode is not None:
            self._values["default_mode"] = default_mode
        if items is not None:
            self._values["items"] = items
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def default_mode(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesConfigMap#defaultMode
        '''
        result = self._values.get("default_mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def items(
        self,
    ) -> typing.Optional[typing.List["TenantSpecSideCarsVolumesConfigMapItems"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesConfigMap#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.List["TenantSpecSideCarsVolumesConfigMapItems"]], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesConfigMap#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesConfigMap#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesConfigMap(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesConfigMapItems",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "path": "path", "mode": "mode"},
)
class TenantSpecSideCarsVolumesConfigMapItems:
    def __init__(
        self,
        *,
        key: builtins.str,
        path: builtins.str,
        mode: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param key: 
        :param path: 
        :param mode: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesConfigMapItems
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesConfigMapItems.__init__)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument mode", value=mode, expected_type=type_hints["mode"])
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "path": path,
        }
        if mode is not None:
            self._values["mode"] = mode

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesConfigMapItems#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesConfigMapItems#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def mode(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesConfigMapItems#mode
        '''
        result = self._values.get("mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesConfigMapItems(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesCsi",
    jsii_struct_bases=[],
    name_mapping={
        "driver": "driver",
        "fs_type": "fsType",
        "node_publish_secret_ref": "nodePublishSecretRef",
        "read_only": "readOnly",
        "volume_attributes": "volumeAttributes",
    },
)
class TenantSpecSideCarsVolumesCsi:
    def __init__(
        self,
        *,
        driver: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        node_publish_secret_ref: typing.Optional[typing.Union["TenantSpecSideCarsVolumesCsiNodePublishSecretRef", typing.Dict[str, typing.Any]]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        volume_attributes: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param driver: 
        :param fs_type: 
        :param node_publish_secret_ref: 
        :param read_only: 
        :param volume_attributes: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCsi
        '''
        if isinstance(node_publish_secret_ref, dict):
            node_publish_secret_ref = TenantSpecSideCarsVolumesCsiNodePublishSecretRef(**node_publish_secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesCsi.__init__)
            check_type(argname="argument driver", value=driver, expected_type=type_hints["driver"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument node_publish_secret_ref", value=node_publish_secret_ref, expected_type=type_hints["node_publish_secret_ref"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument volume_attributes", value=volume_attributes, expected_type=type_hints["volume_attributes"])
        self._values: typing.Dict[str, typing.Any] = {
            "driver": driver,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if node_publish_secret_ref is not None:
            self._values["node_publish_secret_ref"] = node_publish_secret_ref
        if read_only is not None:
            self._values["read_only"] = read_only
        if volume_attributes is not None:
            self._values["volume_attributes"] = volume_attributes

    @builtins.property
    def driver(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCsi#driver
        '''
        result = self._values.get("driver")
        assert result is not None, "Required property 'driver' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCsi#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_publish_secret_ref(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumesCsiNodePublishSecretRef"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCsi#nodePublishSecretRef
        '''
        result = self._values.get("node_publish_secret_ref")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesCsiNodePublishSecretRef"], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCsi#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def volume_attributes(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCsi#volumeAttributes
        '''
        result = self._values.get("volume_attributes")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesCsi(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesCsiNodePublishSecretRef",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class TenantSpecSideCarsVolumesCsiNodePublishSecretRef:
    def __init__(self, *, name: typing.Optional[builtins.str] = None) -> None:
        '''
        :param name: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCsiNodePublishSecretRef
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesCsiNodePublishSecretRef.__init__)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesCsiNodePublishSecretRef#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesCsiNodePublishSecretRef(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesDownwardApi",
    jsii_struct_bases=[],
    name_mapping={"default_mode": "defaultMode", "items": "items"},
)
class TenantSpecSideCarsVolumesDownwardApi:
    def __init__(
        self,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Sequence[typing.Union["TenantSpecSideCarsVolumesDownwardApiItems", typing.Dict[str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param default_mode: 
        :param items: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesDownwardApi
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesDownwardApi.__init__)
            check_type(argname="argument default_mode", value=default_mode, expected_type=type_hints["default_mode"])
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
        self._values: typing.Dict[str, typing.Any] = {}
        if default_mode is not None:
            self._values["default_mode"] = default_mode
        if items is not None:
            self._values["items"] = items

    @builtins.property
    def default_mode(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesDownwardApi#defaultMode
        '''
        result = self._values.get("default_mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def items(
        self,
    ) -> typing.Optional[typing.List["TenantSpecSideCarsVolumesDownwardApiItems"]]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesDownwardApi#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.List["TenantSpecSideCarsVolumesDownwardApiItems"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesDownwardApi(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesDownwardApiItems",
    jsii_struct_bases=[],
    name_mapping={
        "path": "path",
        "field_ref": "fieldRef",
        "mode": "mode",
        "resource_field_ref": "resourceFieldRef",
    },
)
class TenantSpecSideCarsVolumesDownwardApiItems:
    def __init__(
        self,
        *,
        path: builtins.str,
        field_ref: typing.Optional[typing.Union["TenantSpecSideCarsVolumesDownwardApiItemsFieldRef", typing.Dict[str, typing.Any]]] = None,
        mode: typing.Optional[jsii.Number] = None,
        resource_field_ref: typing.Optional[typing.Union["TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param path: 
        :param field_ref: 
        :param mode: 
        :param resource_field_ref: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesDownwardApiItems
        '''
        if isinstance(field_ref, dict):
            field_ref = TenantSpecSideCarsVolumesDownwardApiItemsFieldRef(**field_ref)
        if isinstance(resource_field_ref, dict):
            resource_field_ref = TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef(**resource_field_ref)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesDownwardApiItems.__init__)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument field_ref", value=field_ref, expected_type=type_hints["field_ref"])
            check_type(argname="argument mode", value=mode, expected_type=type_hints["mode"])
            check_type(argname="argument resource_field_ref", value=resource_field_ref, expected_type=type_hints["resource_field_ref"])
        self._values: typing.Dict[str, typing.Any] = {
            "path": path,
        }
        if field_ref is not None:
            self._values["field_ref"] = field_ref
        if mode is not None:
            self._values["mode"] = mode
        if resource_field_ref is not None:
            self._values["resource_field_ref"] = resource_field_ref

    @builtins.property
    def path(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesDownwardApiItems#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def field_ref(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumesDownwardApiItemsFieldRef"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesDownwardApiItems#fieldRef
        '''
        result = self._values.get("field_ref")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesDownwardApiItemsFieldRef"], result)

    @builtins.property
    def mode(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesDownwardApiItems#mode
        '''
        result = self._values.get("mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def resource_field_ref(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesDownwardApiItems#resourceFieldRef
        '''
        result = self._values.get("resource_field_ref")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesDownwardApiItems(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesDownwardApiItemsFieldRef",
    jsii_struct_bases=[],
    name_mapping={"field_path": "fieldPath", "api_version": "apiVersion"},
)
class TenantSpecSideCarsVolumesDownwardApiItemsFieldRef:
    def __init__(
        self,
        *,
        field_path: builtins.str,
        api_version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param field_path: 
        :param api_version: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesDownwardApiItemsFieldRef
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesDownwardApiItemsFieldRef.__init__)
            check_type(argname="argument field_path", value=field_path, expected_type=type_hints["field_path"])
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
        self._values: typing.Dict[str, typing.Any] = {
            "field_path": field_path,
        }
        if api_version is not None:
            self._values["api_version"] = api_version

    @builtins.property
    def field_path(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesDownwardApiItemsFieldRef#fieldPath
        '''
        result = self._values.get("field_path")
        assert result is not None, "Required property 'field_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesDownwardApiItemsFieldRef#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesDownwardApiItemsFieldRef(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef",
    jsii_struct_bases=[],
    name_mapping={
        "resource": "resource",
        "container_name": "containerName",
        "divisor": "divisor",
    },
)
class TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef:
    def __init__(
        self,
        *,
        resource: builtins.str,
        container_name: typing.Optional[builtins.str] = None,
        divisor: typing.Optional["TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor"] = None,
    ) -> None:
        '''
        :param resource: 
        :param container_name: 
        :param divisor: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef.__init__)
            check_type(argname="argument resource", value=resource, expected_type=type_hints["resource"])
            check_type(argname="argument container_name", value=container_name, expected_type=type_hints["container_name"])
            check_type(argname="argument divisor", value=divisor, expected_type=type_hints["divisor"])
        self._values: typing.Dict[str, typing.Any] = {
            "resource": resource,
        }
        if container_name is not None:
            self._values["container_name"] = container_name
        if divisor is not None:
            self._values["divisor"] = divisor

    @builtins.property
    def resource(self) -> builtins.str:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef#resource
        '''
        result = self._values.get("resource")
        assert result is not None, "Required property 'resource' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def container_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef#containerName
        '''
        result = self._values.get("container_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def divisor(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef#divisor
        '''
        result = self._values.get("divisor")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesEmptyDir",
    jsii_struct_bases=[],
    name_mapping={"medium": "medium", "size_limit": "sizeLimit"},
)
class TenantSpecSideCarsVolumesEmptyDir:
    def __init__(
        self,
        *,
        medium: typing.Optional[builtins.str] = None,
        size_limit: typing.Optional["TenantSpecSideCarsVolumesEmptyDirSizeLimit"] = None,
    ) -> None:
        '''
        :param medium: 
        :param size_limit: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesEmptyDir
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesEmptyDir.__init__)
            check_type(argname="argument medium", value=medium, expected_type=type_hints["medium"])
            check_type(argname="argument size_limit", value=size_limit, expected_type=type_hints["size_limit"])
        self._values: typing.Dict[str, typing.Any] = {}
        if medium is not None:
            self._values["medium"] = medium
        if size_limit is not None:
            self._values["size_limit"] = size_limit

    @builtins.property
    def medium(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesEmptyDir#medium
        '''
        result = self._values.get("medium")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def size_limit(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumesEmptyDirSizeLimit"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesEmptyDir#sizeLimit
        '''
        result = self._values.get("size_limit")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesEmptyDirSizeLimit"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesEmptyDir(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TenantSpecSideCarsVolumesEmptyDirSizeLimit(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesEmptyDirSizeLimit",
):
    '''
    :stability: experimental
    :schema: TenantSpecSideCarsVolumesEmptyDirSizeLimit
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(
        cls,
        value: jsii.Number,
    ) -> "TenantSpecSideCarsVolumesEmptyDirSizeLimit":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesEmptyDirSizeLimit.from_number)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsVolumesEmptyDirSizeLimit", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(
        cls,
        value: builtins.str,
    ) -> "TenantSpecSideCarsVolumesEmptyDirSizeLimit":
        '''
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesEmptyDirSizeLimit.from_string)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("TenantSpecSideCarsVolumesEmptyDirSizeLimit", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesEphemeral",
    jsii_struct_bases=[],
    name_mapping={
        "read_only": "readOnly",
        "volume_claim_template": "volumeClaimTemplate",
    },
)
class TenantSpecSideCarsVolumesEphemeral:
    def __init__(
        self,
        *,
        read_only: typing.Optional[builtins.bool] = None,
        volume_claim_template: typing.Optional[typing.Union["TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param read_only: 
        :param volume_claim_template: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesEphemeral
        '''
        if isinstance(volume_claim_template, dict):
            volume_claim_template = TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate(**volume_claim_template)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesEphemeral.__init__)
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument volume_claim_template", value=volume_claim_template, expected_type=type_hints["volume_claim_template"])
        self._values: typing.Dict[str, typing.Any] = {}
        if read_only is not None:
            self._values["read_only"] = read_only
        if volume_claim_template is not None:
            self._values["volume_claim_template"] = volume_claim_template

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesEphemeral#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def volume_claim_template(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesEphemeral#volumeClaimTemplate
        '''
        result = self._values.get("volume_claim_template")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesEphemeral(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate",
    jsii_struct_bases=[],
    name_mapping={"spec": "spec", "metadata": "metadata"},
)
class TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate:
    def __init__(
        self,
        *,
        spec: typing.Union["TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec", typing.Dict[str, typing.Any]],
        metadata: typing.Optional[typing.Union["TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param spec: 
        :param metadata: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate
        '''
        if isinstance(spec, dict):
            spec = TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec(**spec)
        if isinstance(metadata, dict):
            metadata = TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate.__init__)
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[str, typing.Any] = {
            "spec": spec,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def spec(self) -> "TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec":
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate#spec
        '''
        result = self._values.get("spec")
        assert result is not None, "Required property 'spec' is missing"
        return typing.cast("TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec", result)

    @builtins.property
    def metadata(
        self,
    ) -> typing.Optional["TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata"]:
        '''
        :stability: experimental
        :schema: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-metaflow.minio.TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata",
    jsii_struct_bases=[],
    name_mapping={
        "annotations": "annotations",
        "finalizers": "finalizers",
        "labels": "labels",
        "name": "name",
        "namespace": "namespace",
    },
)
class TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata:
    def __init__(
        self,
        *,
        annotations: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        finalizers: typing.Optional[typing.Sequence[builtins.str]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        name: typing.Optional[builtins.str] = None,
        namespace: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param annotations: 
        :param finalizers: 
        :param labels: 
        :param name: 
        :param namespace: 

        :stability: experimental
        :schema: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata.__init__)
            check_type(argname="argument annotations", value=annotations, expected_type=type_hints["annotations"])
            check_type(argname="argument finalizers", value=finalizers, expected_type=type_hints["finalizers"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
        self._values: typing.Dict[str, typing.Any] = {}
        if annotations is not None:
            self._values["annotations"] = annotations
        if finalizers is not None:
            self._values["finalizers"] = finalizers
        if labels is not None:
            self._values["labels"] = labels
        if name is not None:
            self._values["name"] = name
        if namespace is not None:
            self._values["namespace"] = namespace

    @builtins.property