"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetadataDatabase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
class MetadataDatabase extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const chartValues = props.chartValues ?? {
            enabled: true,
            auth: {
                database: 'metaflow',
                password: 'metaflow',
                username: 'metaflow',
            },
        };
        new cdk8s_1.Helm(this, 'postgres', {
            chart: 'bitnami/postgresql',
            releaseName: 'release-name-postgresql',
            helmFlags: ['--version', props.chartVersion],
            values: chartValues,
        });
    }
}
exports.MetadataDatabase = MetadataDatabase;
_a = JSII_RTTI_SYMBOL_1;
MetadataDatabase[_a] = { fqn: "cdk8s-metaflow.MetadataDatabase", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWV0YWRhdGEtZGF0YWJhc2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvbWV0YWRhdGEtZGF0YWJhc2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxpQ0FBNkI7QUFDN0IsMkNBQXVDO0FBUXZDLE1BQWEsZ0JBQWlCLFNBQVEsc0JBQVM7SUFDN0MsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE0QjtRQUNwRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLElBQUk7WUFDdkMsT0FBTyxFQUFFLElBQUk7WUFDYixJQUFJLEVBQUU7Z0JBQ0osUUFBUSxFQUFFLFVBQVU7Z0JBQ3BCLFFBQVEsRUFBRSxVQUFVO2dCQUNwQixRQUFRLEVBQUUsVUFBVTthQUNyQjtTQUNGLENBQUM7UUFFRixJQUFJLFlBQUksQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3pCLEtBQUssRUFBRSxvQkFBb0I7WUFDM0IsV0FBVyxFQUFFLHlCQUF5QjtZQUN0QyxTQUFTLEVBQUUsQ0FBQyxXQUFXLEVBQUUsS0FBSyxDQUFDLFlBQVksQ0FBQztZQUM1QyxNQUFNLEVBQUUsV0FBVztTQUNwQixDQUFDLENBQUM7SUFDTCxDQUFDOztBQW5CSCw0Q0FvQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBIZWxtIH0gZnJvbSAnY2RrOHMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBNZXRhZGF0YURhdGFiYXNlT3B0aW9ucyB9IGZyb20gJy4vaW50ZXJmYWNlcyc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgTWV0YWRhdGFEYXRhYmFzZVByb3BzIHtcbiAgcmVhZG9ubHkgY2hhcnRWZXJzaW9uOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGNoYXJ0VmFsdWVzPzogTWV0YWRhdGFEYXRhYmFzZU9wdGlvbnM7XG59XG5cbmV4cG9ydCBjbGFzcyBNZXRhZGF0YURhdGFiYXNlIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IE1ldGFkYXRhRGF0YWJhc2VQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCBjaGFydFZhbHVlcyA9IHByb3BzLmNoYXJ0VmFsdWVzID8/IHtcbiAgICAgIGVuYWJsZWQ6IHRydWUsXG4gICAgICBhdXRoOiB7XG4gICAgICAgIGRhdGFiYXNlOiAnbWV0YWZsb3cnLFxuICAgICAgICBwYXNzd29yZDogJ21ldGFmbG93JyxcbiAgICAgICAgdXNlcm5hbWU6ICdtZXRhZmxvdycsXG4gICAgICB9LFxuICAgIH07XG5cbiAgICBuZXcgSGVsbSh0aGlzLCAncG9zdGdyZXMnLCB7XG4gICAgICBjaGFydDogJ2JpdG5hbWkvcG9zdGdyZXNxbCcsXG4gICAgICByZWxlYXNlTmFtZTogJ3JlbGVhc2UtbmFtZS1wb3N0Z3Jlc3FsJyxcbiAgICAgIGhlbG1GbGFnczogWyctLXZlcnNpb24nLCBwcm9wcy5jaGFydFZlcnNpb25dLFxuICAgICAgdmFsdWVzOiBjaGFydFZhbHVlcyxcbiAgICB9KTtcbiAgfVxufVxuIl19