# coding: utf-8

"""
    Peacemakr

    This API describes the Peacemakr services, which enable seamless application layer encryption and verification.  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SymmetricKeyRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'derive_symmetric_key_ids': 'list[str]',
        'delivery_public_key_ids': 'list[str]',
        'key_derivation_service_id': 'str',
        'creation_time': 'int',
        'symmetric_key_length': 'int',
        'packaged_ciphertext_version': 'int',
        'must_sign_delivered_symmetric_keys': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'derive_symmetric_key_ids': 'deriveSymmetricKeyIds',
        'delivery_public_key_ids': 'deliveryPublicKeyIds',
        'key_derivation_service_id': 'keyDerivationServiceId',
        'creation_time': 'creationTime',
        'symmetric_key_length': 'symmetricKeyLength',
        'packaged_ciphertext_version': 'packagedCiphertextVersion',
        'must_sign_delivered_symmetric_keys': 'mustSignDeliveredSymmetricKeys'
    }

    def __init__(self, id=None, derive_symmetric_key_ids=None, delivery_public_key_ids=None, key_derivation_service_id=None, creation_time=None, symmetric_key_length=None, packaged_ciphertext_version=None, must_sign_delivered_symmetric_keys=None):  # noqa: E501
        """SymmetricKeyRequest - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._derive_symmetric_key_ids = None
        self._delivery_public_key_ids = None
        self._key_derivation_service_id = None
        self._creation_time = None
        self._symmetric_key_length = None
        self._packaged_ciphertext_version = None
        self._must_sign_delivered_symmetric_keys = None
        self.discriminator = None

        self.id = id
        self.derive_symmetric_key_ids = derive_symmetric_key_ids
        self.delivery_public_key_ids = delivery_public_key_ids
        self.key_derivation_service_id = key_derivation_service_id
        self.creation_time = creation_time
        self.symmetric_key_length = symmetric_key_length
        self.packaged_ciphertext_version = packaged_ciphertext_version
        self.must_sign_delivered_symmetric_keys = must_sign_delivered_symmetric_keys

    @property
    def id(self):
        """Gets the id of this SymmetricKeyRequest.  # noqa: E501

        Id of the symmetric key request.  # noqa: E501

        :return: The id of this SymmetricKeyRequest.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SymmetricKeyRequest.

        Id of the symmetric key request.  # noqa: E501

        :param id: The id of this SymmetricKeyRequest.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def derive_symmetric_key_ids(self):
        """Gets the derive_symmetric_key_ids of this SymmetricKeyRequest.  # noqa: E501

        These are the keyId's of for the symmetric keys to actually derive.  # noqa: E501

        :return: The derive_symmetric_key_ids of this SymmetricKeyRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._derive_symmetric_key_ids

    @derive_symmetric_key_ids.setter
    def derive_symmetric_key_ids(self, derive_symmetric_key_ids):
        """Sets the derive_symmetric_key_ids of this SymmetricKeyRequest.

        These are the keyId's of for the symmetric keys to actually derive.  # noqa: E501

        :param derive_symmetric_key_ids: The derive_symmetric_key_ids of this SymmetricKeyRequest.  # noqa: E501
        :type: list[str]
        """
        if derive_symmetric_key_ids is None:
            raise ValueError("Invalid value for `derive_symmetric_key_ids`, must not be `None`")  # noqa: E501

        self._derive_symmetric_key_ids = derive_symmetric_key_ids

    @property
    def delivery_public_key_ids(self):
        """Gets the delivery_public_key_ids of this SymmetricKeyRequest.  # noqa: E501

        These are the keyId's to deliver all of the derived symmetric keys.  # noqa: E501

        :return: The delivery_public_key_ids of this SymmetricKeyRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._delivery_public_key_ids

    @delivery_public_key_ids.setter
    def delivery_public_key_ids(self, delivery_public_key_ids):
        """Sets the delivery_public_key_ids of this SymmetricKeyRequest.

        These are the keyId's to deliver all of the derived symmetric keys.  # noqa: E501

        :param delivery_public_key_ids: The delivery_public_key_ids of this SymmetricKeyRequest.  # noqa: E501
        :type: list[str]
        """
        if delivery_public_key_ids is None:
            raise ValueError("Invalid value for `delivery_public_key_ids`, must not be `None`")  # noqa: E501

        self._delivery_public_key_ids = delivery_public_key_ids

    @property
    def key_derivation_service_id(self):
        """Gets the key_derivation_service_id of this SymmetricKeyRequest.  # noqa: E501

        The serviceId that must generate these keys.  # noqa: E501

        :return: The key_derivation_service_id of this SymmetricKeyRequest.  # noqa: E501
        :rtype: str
        """
        return self._key_derivation_service_id

    @key_derivation_service_id.setter
    def key_derivation_service_id(self, key_derivation_service_id):
        """Sets the key_derivation_service_id of this SymmetricKeyRequest.

        The serviceId that must generate these keys.  # noqa: E501

        :param key_derivation_service_id: The key_derivation_service_id of this SymmetricKeyRequest.  # noqa: E501
        :type: str
        """
        if key_derivation_service_id is None:
            raise ValueError("Invalid value for `key_derivation_service_id`, must not be `None`")  # noqa: E501

        self._key_derivation_service_id = key_derivation_service_id

    @property
    def creation_time(self):
        """Gets the creation_time of this SymmetricKeyRequest.  # noqa: E501

        Epoch time of the symmetric key requestion request time.  # noqa: E501

        :return: The creation_time of this SymmetricKeyRequest.  # noqa: E501
        :rtype: int
        """
        return self._creation_time

    @creation_time.setter
    def creation_time(self, creation_time):
        """Sets the creation_time of this SymmetricKeyRequest.

        Epoch time of the symmetric key requestion request time.  # noqa: E501

        :param creation_time: The creation_time of this SymmetricKeyRequest.  # noqa: E501
        :type: int
        """
        if creation_time is None:
            raise ValueError("Invalid value for `creation_time`, must not be `None`")  # noqa: E501

        self._creation_time = creation_time

    @property
    def symmetric_key_length(self):
        """Gets the symmetric_key_length of this SymmetricKeyRequest.  # noqa: E501

        Length in bytes of the derived symmetric keys.  # noqa: E501

        :return: The symmetric_key_length of this SymmetricKeyRequest.  # noqa: E501
        :rtype: int
        """
        return self._symmetric_key_length

    @symmetric_key_length.setter
    def symmetric_key_length(self, symmetric_key_length):
        """Sets the symmetric_key_length of this SymmetricKeyRequest.

        Length in bytes of the derived symmetric keys.  # noqa: E501

        :param symmetric_key_length: The symmetric_key_length of this SymmetricKeyRequest.  # noqa: E501
        :type: int
        """
        if symmetric_key_length is None:
            raise ValueError("Invalid value for `symmetric_key_length`, must not be `None`")  # noqa: E501

        self._symmetric_key_length = symmetric_key_length

    @property
    def packaged_ciphertext_version(self):
        """Gets the packaged_ciphertext_version of this SymmetricKeyRequest.  # noqa: E501

        After deriving symmetric keys, this determines the ciphertext packaging scheme required for encrypted key delivery.  # noqa: E501

        :return: The packaged_ciphertext_version of this SymmetricKeyRequest.  # noqa: E501
        :rtype: int
        """
        return self._packaged_ciphertext_version

    @packaged_ciphertext_version.setter
    def packaged_ciphertext_version(self, packaged_ciphertext_version):
        """Sets the packaged_ciphertext_version of this SymmetricKeyRequest.

        After deriving symmetric keys, this determines the ciphertext packaging scheme required for encrypted key delivery.  # noqa: E501

        :param packaged_ciphertext_version: The packaged_ciphertext_version of this SymmetricKeyRequest.  # noqa: E501
        :type: int
        """
        if packaged_ciphertext_version is None:
            raise ValueError("Invalid value for `packaged_ciphertext_version`, must not be `None`")  # noqa: E501

        self._packaged_ciphertext_version = packaged_ciphertext_version

    @property
    def must_sign_delivered_symmetric_keys(self):
        """Gets the must_sign_delivered_symmetric_keys of this SymmetricKeyRequest.  # noqa: E501

        If true the key deriver must sign delivered symmetric keys ciphertext blobs  # noqa: E501

        :return: The must_sign_delivered_symmetric_keys of this SymmetricKeyRequest.  # noqa: E501
        :rtype: bool
        """
        return self._must_sign_delivered_symmetric_keys

    @must_sign_delivered_symmetric_keys.setter
    def must_sign_delivered_symmetric_keys(self, must_sign_delivered_symmetric_keys):
        """Sets the must_sign_delivered_symmetric_keys of this SymmetricKeyRequest.

        If true the key deriver must sign delivered symmetric keys ciphertext blobs  # noqa: E501

        :param must_sign_delivered_symmetric_keys: The must_sign_delivered_symmetric_keys of this SymmetricKeyRequest.  # noqa: E501
        :type: bool
        """
        if must_sign_delivered_symmetric_keys is None:
            raise ValueError("Invalid value for `must_sign_delivered_symmetric_keys`, must not be `None`")  # noqa: E501

        self._must_sign_delivered_symmetric_keys = must_sign_delivered_symmetric_keys

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SymmetricKeyRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SymmetricKeyRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
