# coding: utf-8

"""
    Peacemakr

    This API describes the Peacemakr services, which enable seamless application layer encryption and verification.  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class KeyDerivationInstance(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'service_ids': 'list[str]',
        'active': 'bool',
        'version': 'str',
        'base_url': 'str',
        'is_public': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'service_ids': 'serviceIds',
        'active': 'active',
        'version': 'version',
        'base_url': 'baseUrl',
        'is_public': 'isPublic'
    }

    def __init__(self, id=None, service_ids=None, active=None, version=None, base_url=None, is_public=False):  # noqa: E501
        """KeyDerivationInstance - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._service_ids = None
        self._active = None
        self._version = None
        self._base_url = None
        self._is_public = None
        self.discriminator = None

        self.id = id
        self.service_ids = service_ids
        self.active = active
        self.version = version
        if base_url is not None:
            self.base_url = base_url
        if is_public is not None:
            self.is_public = is_public

    @property
    def id(self):
        """Gets the id of this KeyDerivationInstance.  # noqa: E501

        instance id (concrete instance)  # noqa: E501

        :return: The id of this KeyDerivationInstance.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this KeyDerivationInstance.

        instance id (concrete instance)  # noqa: E501

        :param id: The id of this KeyDerivationInstance.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def service_ids(self):
        """Gets the service_ids of this KeyDerivationInstance.  # noqa: E501

        service id (virtual service id)  # noqa: E501

        :return: The service_ids of this KeyDerivationInstance.  # noqa: E501
        :rtype: list[str]
        """
        return self._service_ids

    @service_ids.setter
    def service_ids(self, service_ids):
        """Sets the service_ids of this KeyDerivationInstance.

        service id (virtual service id)  # noqa: E501

        :param service_ids: The service_ids of this KeyDerivationInstance.  # noqa: E501
        :type: list[str]
        """
        if service_ids is None:
            raise ValueError("Invalid value for `service_ids`, must not be `None`")  # noqa: E501

        self._service_ids = service_ids

    @property
    def active(self):
        """Gets the active of this KeyDerivationInstance.  # noqa: E501

        currently online and accepting requests for key derivation  # noqa: E501

        :return: The active of this KeyDerivationInstance.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this KeyDerivationInstance.

        currently online and accepting requests for key derivation  # noqa: E501

        :param active: The active of this KeyDerivationInstance.  # noqa: E501
        :type: bool
        """
        if active is None:
            raise ValueError("Invalid value for `active`, must not be `None`")  # noqa: E501

        self._active = active

    @property
    def version(self):
        """Gets the version of this KeyDerivationInstance.  # noqa: E501


        :return: The version of this KeyDerivationInstance.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this KeyDerivationInstance.


        :param version: The version of this KeyDerivationInstance.  # noqa: E501
        :type: str
        """
        if version is None:
            raise ValueError("Invalid value for `version`, must not be `None`")  # noqa: E501

        self._version = version

    @property
    def base_url(self):
        """Gets the base_url of this KeyDerivationInstance.  # noqa: E501

        base URL from which this key deriver instance will respond to new key derivation job requests  # noqa: E501

        :return: The base_url of this KeyDerivationInstance.  # noqa: E501
        :rtype: str
        """
        return self._base_url

    @base_url.setter
    def base_url(self, base_url):
        """Sets the base_url of this KeyDerivationInstance.

        base URL from which this key deriver instance will respond to new key derivation job requests  # noqa: E501

        :param base_url: The base_url of this KeyDerivationInstance.  # noqa: E501
        :type: str
        """

        self._base_url = base_url

    @property
    def is_public(self):
        """Gets the is_public of this KeyDerivationInstance.  # noqa: E501

        if true then the key deriver is visible to every other organization  # noqa: E501

        :return: The is_public of this KeyDerivationInstance.  # noqa: E501
        :rtype: bool
        """
        return self._is_public

    @is_public.setter
    def is_public(self, is_public):
        """Sets the is_public of this KeyDerivationInstance.

        if true then the key deriver is visible to every other organization  # noqa: E501

        :param is_public: The is_public of this KeyDerivationInstance.  # noqa: E501
        :type: bool
        """

        self._is_public = is_public

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(KeyDerivationInstance, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, KeyDerivationInstance):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
