# coding: utf-8

"""
    Peacemakr

    This API describes the Peacemakr services, which enable seamless application layer encryption and verification.  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class EncryptedSymmetricKey(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'key_ids': 'list[str]',
        'key_length': 'int',
        'symmetric_key_use_domain_id': 'str',
        'packaged_ciphertext': 'str'
    }

    attribute_map = {
        'key_ids': 'keyIds',
        'key_length': 'keyLength',
        'symmetric_key_use_domain_id': 'symmetricKeyUseDomainId',
        'packaged_ciphertext': 'packagedCiphertext'
    }

    def __init__(self, key_ids=None, key_length=None, symmetric_key_use_domain_id=None, packaged_ciphertext=None):  # noqa: E501
        """EncryptedSymmetricKey - a model defined in Swagger"""  # noqa: E501

        self._key_ids = None
        self._key_length = None
        self._symmetric_key_use_domain_id = None
        self._packaged_ciphertext = None
        self.discriminator = None

        self.key_ids = key_ids
        self.key_length = key_length
        self.symmetric_key_use_domain_id = symmetric_key_use_domain_id
        self.packaged_ciphertext = packaged_ciphertext

    @property
    def key_ids(self):
        """Gets the key_ids of this EncryptedSymmetricKey.  # noqa: E501

        id's of the symmetric keys encrypted in packedCiphertext  # noqa: E501

        :return: The key_ids of this EncryptedSymmetricKey.  # noqa: E501
        :rtype: list[str]
        """
        return self._key_ids

    @key_ids.setter
    def key_ids(self, key_ids):
        """Sets the key_ids of this EncryptedSymmetricKey.

        id's of the symmetric keys encrypted in packedCiphertext  # noqa: E501

        :param key_ids: The key_ids of this EncryptedSymmetricKey.  # noqa: E501
        :type: list[str]
        """
        if key_ids is None:
            raise ValueError("Invalid value for `key_ids`, must not be `None`")  # noqa: E501

        self._key_ids = key_ids

    @property
    def key_length(self):
        """Gets the key_length of this EncryptedSymmetricKey.  # noqa: E501

        length of the keys encrypted in packedCiphertext  # noqa: E501

        :return: The key_length of this EncryptedSymmetricKey.  # noqa: E501
        :rtype: int
        """
        return self._key_length

    @key_length.setter
    def key_length(self, key_length):
        """Sets the key_length of this EncryptedSymmetricKey.

        length of the keys encrypted in packedCiphertext  # noqa: E501

        :param key_length: The key_length of this EncryptedSymmetricKey.  # noqa: E501
        :type: int
        """
        if key_length is None:
            raise ValueError("Invalid value for `key_length`, must not be `None`")  # noqa: E501

        self._key_length = key_length

    @property
    def symmetric_key_use_domain_id(self):
        """Gets the symmetric_key_use_domain_id of this EncryptedSymmetricKey.  # noqa: E501

        id of the symmetric key use domain which contains this key  # noqa: E501

        :return: The symmetric_key_use_domain_id of this EncryptedSymmetricKey.  # noqa: E501
        :rtype: str
        """
        return self._symmetric_key_use_domain_id

    @symmetric_key_use_domain_id.setter
    def symmetric_key_use_domain_id(self, symmetric_key_use_domain_id):
        """Sets the symmetric_key_use_domain_id of this EncryptedSymmetricKey.

        id of the symmetric key use domain which contains this key  # noqa: E501

        :param symmetric_key_use_domain_id: The symmetric_key_use_domain_id of this EncryptedSymmetricKey.  # noqa: E501
        :type: str
        """
        if symmetric_key_use_domain_id is None:
            raise ValueError("Invalid value for `symmetric_key_use_domain_id`, must not be `None`")  # noqa: E501

        self._symmetric_key_use_domain_id = symmetric_key_use_domain_id

    @property
    def packaged_ciphertext(self):
        """Gets the packaged_ciphertext of this EncryptedSymmetricKey.  # noqa: E501

        the actual packaged ciphertext of the encrypted symmetric key, of key  # noqa: E501

        :return: The packaged_ciphertext of this EncryptedSymmetricKey.  # noqa: E501
        :rtype: str
        """
        return self._packaged_ciphertext

    @packaged_ciphertext.setter
    def packaged_ciphertext(self, packaged_ciphertext):
        """Sets the packaged_ciphertext of this EncryptedSymmetricKey.

        the actual packaged ciphertext of the encrypted symmetric key, of key  # noqa: E501

        :param packaged_ciphertext: The packaged_ciphertext of this EncryptedSymmetricKey.  # noqa: E501
        :type: str
        """
        if packaged_ciphertext is None:
            raise ValueError("Invalid value for `packaged_ciphertext`, must not be `None`")  # noqa: E501

        self._packaged_ciphertext = packaged_ciphertext

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EncryptedSymmetricKey, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EncryptedSymmetricKey):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
