# coding: utf-8

"""
    Peacemakr

    This API describes the Peacemakr services, which enable seamless application layer encryption and verification.  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from peacemakr.generated.models.contact import Contact  # noqa: F401,E501


class APIKey(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'key': 'str',
        'org_id': 'str',
        'creation_time': 'int',
        'authorized_use_domains': 'list[str]',
        'creator': 'Contact'
    }

    attribute_map = {
        'key': 'key',
        'org_id': 'orgId',
        'creation_time': 'creationTime',
        'authorized_use_domains': 'authorizedUseDomains',
        'creator': 'creator'
    }

    def __init__(self, key=None, org_id=None, creation_time=None, authorized_use_domains=None, creator=None):  # noqa: E501
        """APIKey - a model defined in Swagger"""  # noqa: E501

        self._key = None
        self._org_id = None
        self._creation_time = None
        self._authorized_use_domains = None
        self._creator = None
        self.discriminator = None

        self.key = key
        self.org_id = org_id
        if creation_time is not None:
            self.creation_time = creation_time
        if authorized_use_domains is not None:
            self.authorized_use_domains = authorized_use_domains
        if creator is not None:
            self.creator = creator

    @property
    def key(self):
        """Gets the key of this APIKey.  # noqa: E501


        :return: The key of this APIKey.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this APIKey.


        :param key: The key of this APIKey.  # noqa: E501
        :type: str
        """
        if key is None:
            raise ValueError("Invalid value for `key`, must not be `None`")  # noqa: E501

        self._key = key

    @property
    def org_id(self):
        """Gets the org_id of this APIKey.  # noqa: E501


        :return: The org_id of this APIKey.  # noqa: E501
        :rtype: str
        """
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Sets the org_id of this APIKey.


        :param org_id: The org_id of this APIKey.  # noqa: E501
        :type: str
        """
        if org_id is None:
            raise ValueError("Invalid value for `org_id`, must not be `None`")  # noqa: E501

        self._org_id = org_id

    @property
    def creation_time(self):
        """Gets the creation_time of this APIKey.  # noqa: E501


        :return: The creation_time of this APIKey.  # noqa: E501
        :rtype: int
        """
        return self._creation_time

    @creation_time.setter
    def creation_time(self, creation_time):
        """Sets the creation_time of this APIKey.


        :param creation_time: The creation_time of this APIKey.  # noqa: E501
        :type: int
        """

        self._creation_time = creation_time

    @property
    def authorized_use_domains(self):
        """Gets the authorized_use_domains of this APIKey.  # noqa: E501

        list of useDomains that APIKey has access to  # noqa: E501

        :return: The authorized_use_domains of this APIKey.  # noqa: E501
        :rtype: list[str]
        """
        return self._authorized_use_domains

    @authorized_use_domains.setter
    def authorized_use_domains(self, authorized_use_domains):
        """Sets the authorized_use_domains of this APIKey.

        list of useDomains that APIKey has access to  # noqa: E501

        :param authorized_use_domains: The authorized_use_domains of this APIKey.  # noqa: E501
        :type: list[str]
        """

        self._authorized_use_domains = authorized_use_domains

    @property
    def creator(self):
        """Gets the creator of this APIKey.  # noqa: E501


        :return: The creator of this APIKey.  # noqa: E501
        :rtype: Contact
        """
        return self._creator

    @creator.setter
    def creator(self, creator):
        """Sets the creator of this APIKey.


        :param creator: The creator of this APIKey.  # noqa: E501
        :type: Contact
        """

        self._creator = creator

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(APIKey, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, APIKey):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
