# coding: utf-8

"""
    Peacemakr

    This API describes the Peacemakr services, which enable seamless application layer encryption and verification.  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from peacemakr.generated.api_client import ApiClient


class OrgApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_admin_to_org(self, contact, **kwargs):  # noqa: E501
        """Add a new admin to this org  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_admin_to_org(contact, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Contact contact: (required)
        :return: Contact
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_admin_to_org_with_http_info(contact, **kwargs)  # noqa: E501
        else:
            (data) = self.add_admin_to_org_with_http_info(contact, **kwargs)  # noqa: E501
            return data

    def add_admin_to_org_with_http_info(self, contact, **kwargs):  # noqa: E501
        """Add a new admin to this org  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_admin_to_org_with_http_info(contact, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Contact contact: (required)
        :return: Contact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_admin_to_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'contact' is set
        if ('contact' not in params or
                params['contact'] is None):
            raise ValueError("Missing the required parameter `contact` when calling `add_admin_to_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'contact' in params:
            body_params = params['contact']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/org/admin', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Contact',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_api_key_to_org(self, **kwargs):  # noqa: E501
        """Add a new API Key to an org  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_api_key_to_org(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: APIKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_api_key_to_org_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_api_key_to_org_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_api_key_to_org_with_http_info(self, **kwargs):  # noqa: E501
        """Add a new API Key to an org  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_api_key_to_org_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: APIKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_api_key_to_org" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/org/key', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='APIKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_organization(self, id_token, stripe_customer_id, org_name, contact, **kwargs):  # noqa: E501
        """Create a new organization. Must be an authenticated request with a valid id_token from a trusted IdP.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_organization(id_token, stripe_customer_id, org_name, contact, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_token: (required)
        :param str stripe_customer_id: (required)
        :param str org_name: (required)
        :param Contact contact: (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_organization_with_http_info(id_token, stripe_customer_id, org_name, contact, **kwargs)  # noqa: E501
        else:
            (data) = self.add_organization_with_http_info(id_token, stripe_customer_id, org_name, contact, **kwargs)  # noqa: E501
            return data

    def add_organization_with_http_info(self, id_token, stripe_customer_id, org_name, contact, **kwargs):  # noqa: E501
        """Create a new organization. Must be an authenticated request with a valid id_token from a trusted IdP.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_organization_with_http_info(id_token, stripe_customer_id, org_name, contact, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_token: (required)
        :param str stripe_customer_id: (required)
        :param str org_name: (required)
        :param Contact contact: (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_token', 'stripe_customer_id', 'org_name', 'contact']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_organization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_token' is set
        if ('id_token' not in params or
                params['id_token'] is None):
            raise ValueError("Missing the required parameter `id_token` when calling `add_organization`")  # noqa: E501
        # verify the required parameter 'stripe_customer_id' is set
        if ('stripe_customer_id' not in params or
                params['stripe_customer_id'] is None):
            raise ValueError("Missing the required parameter `stripe_customer_id` when calling `add_organization`")  # noqa: E501
        # verify the required parameter 'org_name' is set
        if ('org_name' not in params or
                params['org_name'] is None):
            raise ValueError("Missing the required parameter `org_name` when calling `add_organization`")  # noqa: E501
        # verify the required parameter 'contact' is set
        if ('contact' not in params or
                params['contact'] is None):
            raise ValueError("Missing the required parameter `contact` when calling `add_organization`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'id_token' in params:
            query_params.append(('id_token', params['id_token']))  # noqa: E501
        if 'stripe_customer_id' in params:
            query_params.append(('stripeCustomerId', params['stripe_customer_id']))  # noqa: E501
        if 'org_name' in params:
            query_params.append(('orgName', params['org_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'contact' in params:
            body_params = params['contact']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/org', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_admin_from_org(self, email, **kwargs):  # noqa: E501
        """Remove an existing admin from the org (You can not remove the last admin. It will faile with a Bad Request response.)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_admin_from_org(email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_admin_from_org_with_http_info(email, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_admin_from_org_with_http_info(email, **kwargs)  # noqa: E501
            return data

    def delete_admin_from_org_with_http_info(self, email, **kwargs):  # noqa: E501
        """Remove an existing admin from the org (You can not remove the last admin. It will faile with a Bad Request response.)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_admin_from_org_with_http_info(email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_admin_from_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email' is set
        if ('email' not in params or
                params['email'] is None):
            raise ValueError("Missing the required parameter `email` when calling `delete_admin_from_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'email' in params:
            path_params['email'] = params['email']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/org/admin/{email}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_api_key_from_org(self, apikey, **kwargs):  # noqa: E501
        """Remove an existing API Key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_api_key_from_org(apikey, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str apikey: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_api_key_from_org_with_http_info(apikey, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_api_key_from_org_with_http_info(apikey, **kwargs)  # noqa: E501
            return data

    def delete_api_key_from_org_with_http_info(self, apikey, **kwargs):  # noqa: E501
        """Remove an existing API Key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_api_key_from_org_with_http_info(apikey, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str apikey: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['apikey']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_api_key_from_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'apikey' is set
        if ('apikey' not in params or
                params['apikey'] is None):
            raise ValueError("Missing the required parameter `apikey` when calling `delete_api_key_from_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'apikey' in params:
            path_params['apikey'] = params['apikey']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/org/key/{apikey}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_organization(self, org_id, **kwargs):  # noqa: E501
        """Remove an existing organization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_organization(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_organization_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_organization_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def delete_organization_with_http_info(self, org_id, **kwargs):  # noqa: E501
        """Remove an existing organization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_organization_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_organization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in params or
                params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `delete_organization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in params:
            path_params['orgId'] = params['org_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/org/{orgId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_organization_api_key(self, **kwargs):  # noqa: E501
        """Get an access key for the peacemakr shared cloud org (all cloud key derivers must use this)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_organization_api_key(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: APIKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cloud_organization_api_key_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_organization_api_key_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cloud_organization_api_key_with_http_info(self, **kwargs):  # noqa: E501
        """Get an access key for the peacemakr shared cloud org (all cloud key derivers must use this)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_organization_api_key_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: APIKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_organization_api_key" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/org/key/sharedCloud', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='APIKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_organization(self, org_id, **kwargs):  # noqa: E501
        """Get an existing organization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_organization_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_organization_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def get_organization_with_http_info(self, org_id, **kwargs):  # noqa: E501
        """Get an existing organization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in params or
                params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `get_organization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in params:
            path_params['orgId'] = params['org_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/org/{orgId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_organization_from_api_key(self, apikey, **kwargs):  # noqa: E501
        """Get an existing Organization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_from_api_key(apikey, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str apikey: (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_organization_from_api_key_with_http_info(apikey, **kwargs)  # noqa: E501
        else:
            (data) = self.get_organization_from_api_key_with_http_info(apikey, **kwargs)  # noqa: E501
            return data

    def get_organization_from_api_key_with_http_info(self, apikey, **kwargs):  # noqa: E501
        """Get an existing Organization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_from_api_key_with_http_info(apikey, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str apikey: (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['apikey']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_from_api_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'apikey' is set
        if ('apikey' not in params or
                params['apikey'] is None):
            raise ValueError("Missing the required parameter `apikey` when calling `get_organization_from_api_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'apikey' in params:
            path_params['apikey'] = params['apikey']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/org/key/{apikey}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_organization_api_key(self, **kwargs):  # noqa: E501
        """Get an ephemeral test org api key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_organization_api_key(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: APIKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_test_organization_api_key_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_test_organization_api_key_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_test_organization_api_key_with_http_info(self, **kwargs):  # noqa: E501
        """Get an ephemeral test org api key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_organization_api_key_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: APIKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_organization_api_key" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/org/key/test', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='APIKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_stripe_customer_id(self, stripe_customer_id, **kwargs):  # noqa: E501
        """Update the stripe customer Id associated with this account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_stripe_customer_id(stripe_customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str stripe_customer_id: (required)
        :return: APIKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_stripe_customer_id_with_http_info(stripe_customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_stripe_customer_id_with_http_info(stripe_customer_id, **kwargs)  # noqa: E501
            return data

    def update_stripe_customer_id_with_http_info(self, stripe_customer_id, **kwargs):  # noqa: E501
        """Update the stripe customer Id associated with this account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_stripe_customer_id_with_http_info(stripe_customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str stripe_customer_id: (required)
        :return: APIKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['stripe_customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_stripe_customer_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'stripe_customer_id' is set
        if ('stripe_customer_id' not in params or
                params['stripe_customer_id'] is None):
            raise ValueError("Missing the required parameter `stripe_customer_id` when calling `update_stripe_customer_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'stripe_customer_id' in params:
            query_params.append(('stripeCustomerId', params['stripe_customer_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/org/stripeId', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='APIKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
