# coding: utf-8

"""
    Peacemakr

    This API describes the Peacemakr services, which enable seamless application layer encryption and verification.  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from peacemakr.generated.api_client import ApiClient


class CryptoConfigApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_existing_use_domain(self, crypto_config_id, use_domain_id, **kwargs):  # noqa: E501
        """Add an existing use domain to another crypto config.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_existing_use_domain(crypto_config_id, use_domain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str crypto_config_id: (required)
        :param str use_domain_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_existing_use_domain_with_http_info(crypto_config_id, use_domain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_existing_use_domain_with_http_info(crypto_config_id, use_domain_id, **kwargs)  # noqa: E501
            return data

    def add_existing_use_domain_with_http_info(self, crypto_config_id, use_domain_id, **kwargs):  # noqa: E501
        """Add an existing use domain to another crypto config.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_existing_use_domain_with_http_info(crypto_config_id, use_domain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str crypto_config_id: (required)
        :param str use_domain_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['crypto_config_id', 'use_domain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_existing_use_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'crypto_config_id' is set
        if ('crypto_config_id' not in params or
                params['crypto_config_id'] is None):
            raise ValueError("Missing the required parameter `crypto_config_id` when calling `add_existing_use_domain`")  # noqa: E501
        # verify the required parameter 'use_domain_id' is set
        if ('use_domain_id' not in params or
                params['use_domain_id'] is None):
            raise ValueError("Missing the required parameter `use_domain_id` when calling `add_existing_use_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'crypto_config_id' in params:
            path_params['cryptoConfigId'] = params['crypto_config_id']  # noqa: E501
        if 'use_domain_id' in params:
            path_params['useDomainId'] = params['use_domain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/config/{cryptoConfigId}/useDomain/{useDomainId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_use_domain(self, crypto_config_id, new_use_domain, **kwargs):  # noqa: E501
        """Add a new active use domain and attached it to the crypto config.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_use_domain(crypto_config_id, new_use_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str crypto_config_id: (required)
        :param SymmetricKeyUseDomain new_use_domain: (required)
        :return: SymmetricKeyUseDomain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_use_domain_with_http_info(crypto_config_id, new_use_domain, **kwargs)  # noqa: E501
        else:
            (data) = self.add_use_domain_with_http_info(crypto_config_id, new_use_domain, **kwargs)  # noqa: E501
            return data

    def add_use_domain_with_http_info(self, crypto_config_id, new_use_domain, **kwargs):  # noqa: E501
        """Add a new active use domain and attached it to the crypto config.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_use_domain_with_http_info(crypto_config_id, new_use_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str crypto_config_id: (required)
        :param SymmetricKeyUseDomain new_use_domain: (required)
        :return: SymmetricKeyUseDomain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['crypto_config_id', 'new_use_domain']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_use_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'crypto_config_id' is set
        if ('crypto_config_id' not in params or
                params['crypto_config_id'] is None):
            raise ValueError("Missing the required parameter `crypto_config_id` when calling `add_use_domain`")  # noqa: E501
        # verify the required parameter 'new_use_domain' is set
        if ('new_use_domain' not in params or
                params['new_use_domain'] is None):
            raise ValueError("Missing the required parameter `new_use_domain` when calling `add_use_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'crypto_config_id' in params:
            path_params['cryptoConfigId'] = params['crypto_config_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_use_domain' in params:
            body_params = params['new_use_domain']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/config/{cryptoConfigId}/useDomain', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SymmetricKeyUseDomain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_crypto_config(self, crypto_config_id, **kwargs):  # noqa: E501
        """Get the crypto configurations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crypto_config(crypto_config_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str crypto_config_id: (required)
        :return: CryptoConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_crypto_config_with_http_info(crypto_config_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_crypto_config_with_http_info(crypto_config_id, **kwargs)  # noqa: E501
            return data

    def get_crypto_config_with_http_info(self, crypto_config_id, **kwargs):  # noqa: E501
        """Get the crypto configurations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crypto_config_with_http_info(crypto_config_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str crypto_config_id: (required)
        :return: CryptoConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['crypto_config_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_crypto_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'crypto_config_id' is set
        if ('crypto_config_id' not in params or
                params['crypto_config_id'] is None):
            raise ValueError("Missing the required parameter `crypto_config_id` when calling `get_crypto_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'crypto_config_id' in params:
            path_params['cryptoConfigId'] = params['crypto_config_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/config/{cryptoConfigId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CryptoConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def rapid_rotation_use_domain(self, use_domain_id, **kwargs):  # noqa: E501
        """Rapid expiration of existing use doamin and immediately replacment with an identical use domain containing fresh keys  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rapid_rotation_use_domain(use_domain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str use_domain_id: (required)
        :param str optional_next_key_derivation_service_id:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.rapid_rotation_use_domain_with_http_info(use_domain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.rapid_rotation_use_domain_with_http_info(use_domain_id, **kwargs)  # noqa: E501
            return data

    def rapid_rotation_use_domain_with_http_info(self, use_domain_id, **kwargs):  # noqa: E501
        """Rapid expiration of existing use doamin and immediately replacment with an identical use domain containing fresh keys  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rapid_rotation_use_domain_with_http_info(use_domain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str use_domain_id: (required)
        :param str optional_next_key_derivation_service_id:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['use_domain_id', 'optional_next_key_derivation_service_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rapid_rotation_use_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'use_domain_id' is set
        if ('use_domain_id' not in params or
                params['use_domain_id'] is None):
            raise ValueError("Missing the required parameter `use_domain_id` when calling `rapid_rotation_use_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'use_domain_id' in params:
            path_params['useDomainId'] = params['use_domain_id']  # noqa: E501

        query_params = []
        if 'optional_next_key_derivation_service_id' in params:
            query_params.append(('optionalNextKeyDerivationServiceId', params['optional_next_key_derivation_service_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/useDomain/{useDomainId}/rapidRotation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_use_domain(self, use_domain_id, **kwargs):  # noqa: E501
        """Delete a fully expired use domain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_use_domain(use_domain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str use_domain_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_use_domain_with_http_info(use_domain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_use_domain_with_http_info(use_domain_id, **kwargs)  # noqa: E501
            return data

    def remove_use_domain_with_http_info(self, use_domain_id, **kwargs):  # noqa: E501
        """Delete a fully expired use domain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_use_domain_with_http_info(use_domain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str use_domain_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['use_domain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_use_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'use_domain_id' is set
        if ('use_domain_id' not in params or
                params['use_domain_id'] is None):
            raise ValueError("Missing the required parameter `use_domain_id` when calling `remove_use_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'use_domain_id' in params:
            path_params['useDomainId'] = params['use_domain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/useDomain/{useDomainId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_crypto_config(self, crypto_config_id, updated_crypto_config, **kwargs):  # noqa: E501
        """Update the crypto configuration, ONLY the clientKeyType clientKeyBitlength, and clientKeyTTL fields.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_crypto_config(crypto_config_id, updated_crypto_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str crypto_config_id: (required)
        :param CryptoConfig updated_crypto_config: (required)
        :return: CryptoConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_crypto_config_with_http_info(crypto_config_id, updated_crypto_config, **kwargs)  # noqa: E501
        else:
            (data) = self.update_crypto_config_with_http_info(crypto_config_id, updated_crypto_config, **kwargs)  # noqa: E501
            return data

    def update_crypto_config_with_http_info(self, crypto_config_id, updated_crypto_config, **kwargs):  # noqa: E501
        """Update the crypto configuration, ONLY the clientKeyType clientKeyBitlength, and clientKeyTTL fields.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_crypto_config_with_http_info(crypto_config_id, updated_crypto_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str crypto_config_id: (required)
        :param CryptoConfig updated_crypto_config: (required)
        :return: CryptoConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['crypto_config_id', 'updated_crypto_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_crypto_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'crypto_config_id' is set
        if ('crypto_config_id' not in params or
                params['crypto_config_id'] is None):
            raise ValueError("Missing the required parameter `crypto_config_id` when calling `update_crypto_config`")  # noqa: E501
        # verify the required parameter 'updated_crypto_config' is set
        if ('updated_crypto_config' not in params or
                params['updated_crypto_config'] is None):
            raise ValueError("Missing the required parameter `updated_crypto_config` when calling `update_crypto_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'crypto_config_id' in params:
            path_params['cryptoConfigId'] = params['crypto_config_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'updated_crypto_config' in params:
            body_params = params['updated_crypto_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/config/{cryptoConfigId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CryptoConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_crypto_config_fallback_to_cloud(self, use_domain_id, fallback_to_cloud, **kwargs):  # noqa: E501
        """Update an existing crypto config's asymmetricKeyTTL  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_crypto_config_fallback_to_cloud(use_domain_id, fallback_to_cloud, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str use_domain_id: (required)
        :param bool fallback_to_cloud: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_crypto_config_fallback_to_cloud_with_http_info(use_domain_id, fallback_to_cloud, **kwargs)  # noqa: E501
        else:
            (data) = self.update_crypto_config_fallback_to_cloud_with_http_info(use_domain_id, fallback_to_cloud, **kwargs)  # noqa: E501
            return data

    def update_crypto_config_fallback_to_cloud_with_http_info(self, use_domain_id, fallback_to_cloud, **kwargs):  # noqa: E501
        """Update an existing crypto config's asymmetricKeyTTL  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_crypto_config_fallback_to_cloud_with_http_info(use_domain_id, fallback_to_cloud, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str use_domain_id: (required)
        :param bool fallback_to_cloud: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['use_domain_id', 'fallback_to_cloud']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_crypto_config_fallback_to_cloud" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'use_domain_id' is set
        if ('use_domain_id' not in params or
                params['use_domain_id'] is None):
            raise ValueError("Missing the required parameter `use_domain_id` when calling `update_crypto_config_fallback_to_cloud`")  # noqa: E501
        # verify the required parameter 'fallback_to_cloud' is set
        if ('fallback_to_cloud' not in params or
                params['fallback_to_cloud'] is None):
            raise ValueError("Missing the required parameter `fallback_to_cloud` when calling `update_crypto_config_fallback_to_cloud`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'use_domain_id' in params:
            path_params['useDomainId'] = params['use_domain_id']  # noqa: E501

        query_params = []
        if 'fallback_to_cloud' in params:
            query_params.append(('fallbackToCloud', params['fallback_to_cloud']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/useDomain/{useDomainId}/enableKDSFallbackToCloud', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_crypto_config_selector_scheme(self, crypto_config_id, new_selector_scheme, **kwargs):  # noqa: E501
        """Update an existing crypto config's domainSelectorScheme  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_crypto_config_selector_scheme(crypto_config_id, new_selector_scheme, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str crypto_config_id: (required)
        :param str new_selector_scheme: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_crypto_config_selector_scheme_with_http_info(crypto_config_id, new_selector_scheme, **kwargs)  # noqa: E501
        else:
            (data) = self.update_crypto_config_selector_scheme_with_http_info(crypto_config_id, new_selector_scheme, **kwargs)  # noqa: E501
            return data

    def update_crypto_config_selector_scheme_with_http_info(self, crypto_config_id, new_selector_scheme, **kwargs):  # noqa: E501
        """Update an existing crypto config's domainSelectorScheme  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_crypto_config_selector_scheme_with_http_info(crypto_config_id, new_selector_scheme, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str crypto_config_id: (required)
        :param str new_selector_scheme: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['crypto_config_id', 'new_selector_scheme']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_crypto_config_selector_scheme" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'crypto_config_id' is set
        if ('crypto_config_id' not in params or
                params['crypto_config_id'] is None):
            raise ValueError("Missing the required parameter `crypto_config_id` when calling `update_crypto_config_selector_scheme`")  # noqa: E501
        # verify the required parameter 'new_selector_scheme' is set
        if ('new_selector_scheme' not in params or
                params['new_selector_scheme'] is None):
            raise ValueError("Missing the required parameter `new_selector_scheme` when calling `update_crypto_config_selector_scheme`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'crypto_config_id' in params:
            path_params['cryptoConfigId'] = params['crypto_config_id']  # noqa: E501

        query_params = []
        if 'new_selector_scheme' in params:
            query_params.append(('newSelectorScheme', params['new_selector_scheme']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/config/{cryptoConfigId}/domainSelectorScheme', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_expire_use_domain(self, use_domain_id, inception_ttl, encryption_ttl, decryption_ttl, retention_ttl, **kwargs):  # noqa: E501
        """Chnage expiration of a use domain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_expire_use_domain(use_domain_id, inception_ttl, encryption_ttl, decryption_ttl, retention_ttl, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str use_domain_id: (required)
        :param int inception_ttl: (required)
        :param int encryption_ttl: (required)
        :param int decryption_ttl: (required)
        :param int retention_ttl: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_expire_use_domain_with_http_info(use_domain_id, inception_ttl, encryption_ttl, decryption_ttl, retention_ttl, **kwargs)  # noqa: E501
        else:
            (data) = self.update_expire_use_domain_with_http_info(use_domain_id, inception_ttl, encryption_ttl, decryption_ttl, retention_ttl, **kwargs)  # noqa: E501
            return data

    def update_expire_use_domain_with_http_info(self, use_domain_id, inception_ttl, encryption_ttl, decryption_ttl, retention_ttl, **kwargs):  # noqa: E501
        """Chnage expiration of a use domain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_expire_use_domain_with_http_info(use_domain_id, inception_ttl, encryption_ttl, decryption_ttl, retention_ttl, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str use_domain_id: (required)
        :param int inception_ttl: (required)
        :param int encryption_ttl: (required)
        :param int decryption_ttl: (required)
        :param int retention_ttl: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['use_domain_id', 'inception_ttl', 'encryption_ttl', 'decryption_ttl', 'retention_ttl']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_expire_use_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'use_domain_id' is set
        if ('use_domain_id' not in params or
                params['use_domain_id'] is None):
            raise ValueError("Missing the required parameter `use_domain_id` when calling `update_expire_use_domain`")  # noqa: E501
        # verify the required parameter 'inception_ttl' is set
        if ('inception_ttl' not in params or
                params['inception_ttl'] is None):
            raise ValueError("Missing the required parameter `inception_ttl` when calling `update_expire_use_domain`")  # noqa: E501
        # verify the required parameter 'encryption_ttl' is set
        if ('encryption_ttl' not in params or
                params['encryption_ttl'] is None):
            raise ValueError("Missing the required parameter `encryption_ttl` when calling `update_expire_use_domain`")  # noqa: E501
        # verify the required parameter 'decryption_ttl' is set
        if ('decryption_ttl' not in params or
                params['decryption_ttl'] is None):
            raise ValueError("Missing the required parameter `decryption_ttl` when calling `update_expire_use_domain`")  # noqa: E501
        # verify the required parameter 'retention_ttl' is set
        if ('retention_ttl' not in params or
                params['retention_ttl'] is None):
            raise ValueError("Missing the required parameter `retention_ttl` when calling `update_expire_use_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'use_domain_id' in params:
            path_params['useDomainId'] = params['use_domain_id']  # noqa: E501

        query_params = []
        if 'inception_ttl' in params:
            query_params.append(('inceptionTTL', params['inception_ttl']))  # noqa: E501
        if 'encryption_ttl' in params:
            query_params.append(('encryptionTTL', params['encryption_ttl']))  # noqa: E501
        if 'decryption_ttl' in params:
            query_params.append(('decryptionTTL', params['decryption_ttl']))  # noqa: E501
        if 'retention_ttl' in params:
            query_params.append(('retentionTTL', params['retention_ttl']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['header']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/useDomain/{useDomainId}/updateExpire', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
