# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.configuration import Configuration


class V1alpha1AnnotationForAssembly(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'file': 'list[V1alpha1AnnotationForAssemblyFile]',
        'name': 'str',
        'release_date': 'str',
        'release_number': 'str',
        'report_url': 'str',
        'source': 'str'
    }

    attribute_map = {
        'file': 'file',
        'name': 'name',
        'release_date': 'release_date',
        'release_number': 'release_number',
        'report_url': 'report_url',
        'source': 'source'
    }

    def __init__(self, file=None, name=None, release_date=None, release_number=None, report_url=None, source=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1AnnotationForAssembly - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._file = None
        self._name = None
        self._release_date = None
        self._release_number = None
        self._report_url = None
        self._source = None
        self.discriminator = None

        if file is not None:
            self.file = file
        if name is not None:
            self.name = name
        if release_date is not None:
            self.release_date = release_date
        if release_number is not None:
            self.release_number = release_number
        if report_url is not None:
            self.report_url = report_url
        if source is not None:
            self.source = source

    @property
    def file(self):
        """Gets the file of this V1alpha1AnnotationForAssembly.  # noqa: E501

        List of annotation files available for this assembly.  # noqa: E501

        :return: The file of this V1alpha1AnnotationForAssembly.  # noqa: E501
        :rtype: list[V1alpha1AnnotationForAssemblyFile]
        """
        return self._file

    @file.setter
    def file(self, file):
        """Sets the file of this V1alpha1AnnotationForAssembly.

        List of annotation files available for this assembly.  # noqa: E501

        :param file: The file of this V1alpha1AnnotationForAssembly.  # noqa: E501
        :type: list[V1alpha1AnnotationForAssemblyFile]
        """

        self._file = file

    @property
    def name(self):
        """Gets the name of this V1alpha1AnnotationForAssembly.  # noqa: E501


        :return: The name of this V1alpha1AnnotationForAssembly.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this V1alpha1AnnotationForAssembly.


        :param name: The name of this V1alpha1AnnotationForAssembly.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def release_date(self):
        """Gets the release_date of this V1alpha1AnnotationForAssembly.  # noqa: E501


        :return: The release_date of this V1alpha1AnnotationForAssembly.  # noqa: E501
        :rtype: str
        """
        return self._release_date

    @release_date.setter
    def release_date(self, release_date):
        """Sets the release_date of this V1alpha1AnnotationForAssembly.


        :param release_date: The release_date of this V1alpha1AnnotationForAssembly.  # noqa: E501
        :type: str
        """

        self._release_date = release_date

    @property
    def release_number(self):
        """Gets the release_number of this V1alpha1AnnotationForAssembly.  # noqa: E501

        NCBI Annotation release number, if one exists.  # noqa: E501

        :return: The release_number of this V1alpha1AnnotationForAssembly.  # noqa: E501
        :rtype: str
        """
        return self._release_number

    @release_number.setter
    def release_number(self, release_number):
        """Sets the release_number of this V1alpha1AnnotationForAssembly.

        NCBI Annotation release number, if one exists.  # noqa: E501

        :param release_number: The release_number of this V1alpha1AnnotationForAssembly.  # noqa: E501
        :type: str
        """

        self._release_number = release_number

    @property
    def report_url(self):
        """Gets the report_url of this V1alpha1AnnotationForAssembly.  # noqa: E501


        :return: The report_url of this V1alpha1AnnotationForAssembly.  # noqa: E501
        :rtype: str
        """
        return self._report_url

    @report_url.setter
    def report_url(self, report_url):
        """Sets the report_url of this V1alpha1AnnotationForAssembly.


        :param report_url: The report_url of this V1alpha1AnnotationForAssembly.  # noqa: E501
        :type: str
        """

        self._report_url = report_url

    @property
    def source(self):
        """Gets the source of this V1alpha1AnnotationForAssembly.  # noqa: E501

        Source of the annotation.  Possibly from a submitter.  # noqa: E501

        :return: The source of this V1alpha1AnnotationForAssembly.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this V1alpha1AnnotationForAssembly.

        Source of the annotation.  Possibly from a submitter.  # noqa: E501

        :param source: The source of this V1alpha1AnnotationForAssembly.  # noqa: E501
        :type: str
        """

        self._source = source

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1AnnotationForAssembly):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1AnnotationForAssembly):
            return True

        return self.to_dict() != other.to_dict()
