"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationStackNotificationCheck = exports.CloudFormationStackDriftDetectionCheck = exports.AccessKeysRotated = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const rule_1 = require("./rule");
/**
 * Checks whether the active access keys are rotated within the number of days
 * specified in `maxAge`.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html
 *
 * @resource AWS::Config::ConfigRule
 */
class AccessKeysRotated extends rule_1.ManagedRule {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            identifier: rule_1.ManagedRuleIdentifiers.ACCESS_KEYS_ROTATED,
            inputParameters: {
                ...props.maxAge
                    ? {
                        maxAccessKeyAge: props.maxAge.toDays(),
                    }
                    : {},
            },
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_config_AccessKeysRotatedProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AccessKeysRotated);
            }
            throw error;
        }
    }
}
exports.AccessKeysRotated = AccessKeysRotated;
_a = JSII_RTTI_SYMBOL_1;
AccessKeysRotated[_a] = { fqn: "@aws-cdk/aws-config.AccessKeysRotated", version: "1.174.0" };
/**
 * Checks whether your CloudFormation stacks' actual configuration differs, or
 * has drifted, from its expected configuration.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-drift-detection-check.html
 *
 * @resource AWS::Config::ConfigRule
 */
class CloudFormationStackDriftDetectionCheck extends rule_1.ManagedRule {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            identifier: rule_1.ManagedRuleIdentifiers.CLOUDFORMATION_STACK_DRIFT_DETECTION_CHECK,
            inputParameters: {
                cloudformationRoleArn: core_1.Lazy.string({ produce: () => this.role.roleArn }),
            },
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_config_CloudFormationStackDriftDetectionCheckProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudFormationStackDriftDetectionCheck);
            }
            throw error;
        }
        this.ruleScope = rule_1.RuleScope.fromResource(rule_1.ResourceType.CLOUDFORMATION_STACK, props.ownStackOnly ? core_1.Stack.of(this).stackId : undefined);
        this.role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('config.amazonaws.com'),
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('ReadOnlyAccess'),
            ],
        });
    }
}
exports.CloudFormationStackDriftDetectionCheck = CloudFormationStackDriftDetectionCheck;
_b = JSII_RTTI_SYMBOL_1;
CloudFormationStackDriftDetectionCheck[_b] = { fqn: "@aws-cdk/aws-config.CloudFormationStackDriftDetectionCheck", version: "1.174.0" };
/**
 * Checks whether your CloudFormation stacks are sending event notifications to
 * a SNS topic. Optionally checks whether specified SNS topics are used.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-notification-check.html
 *
 * @resource AWS::Config::ConfigRule
 */
class CloudFormationStackNotificationCheck extends rule_1.ManagedRule {
    constructor(scope, id, props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_config_CloudFormationStackNotificationCheckProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudFormationStackNotificationCheck);
            }
            throw error;
        }
        if (props.topics && props.topics.length > 5) {
            throw new Error('At most 5 topics can be specified.');
        }
        super(scope, id, {
            ...props,
            identifier: rule_1.ManagedRuleIdentifiers.CLOUDFORMATION_STACK_NOTIFICATION_CHECK,
            inputParameters: props.topics && props.topics.reduce((params, topic, idx) => ({ ...params, [`snsTopic${idx + 1}`]: topic.topicArn }), {}),
            ruleScope: rule_1.RuleScope.fromResources([rule_1.ResourceType.CLOUDFORMATION_STACK]),
        });
    }
}
exports.CloudFormationStackNotificationCheck = CloudFormationStackNotificationCheck;
_c = JSII_RTTI_SYMBOL_1;
CloudFormationStackNotificationCheck[_c] = { fqn: "@aws-cdk/aws-config.CloudFormationStackNotificationCheck", version: "1.174.0" };
//# sourceMappingURL=data:application/json;base64,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