"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const sns_generated_1 = require("./sns.generated");
/**
 * Applies a policy to SNS topics.
 */
class TopicPolicy extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * The IAM policy document for this policy.
         */
        this.document = new aws_iam_1.PolicyDocument({
            // statements must be unique, so we use the statement index.
            // potantially SIDs can change as a result of order change, but this should
            // not have an impact on the policy evaluation.
            // https://docs.aws.amazon.com/sns/latest/dg/AccessPolicyLanguage_SpecialInfo.html
            assignSids: true
        });
        new sns_generated_1.CfnTopicPolicy(this, 'Resource', {
            policyDocument: this.document,
            topics: props.topics.map(t => t.topicArn)
        });
    }
}
exports.TopicPolicy = TopicPolicy;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicG9saWN5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicG9saWN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsOENBQWtEO0FBQ2xELHdDQUFvRDtBQUNwRCxtREFBaUQ7QUFVakQ7O0dBRUc7QUFDSCxNQUFhLFdBQVksU0FBUSxlQUFRO0lBWXZDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBdUI7UUFDL0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQVpuQjs7V0FFRztRQUNhLGFBQVEsR0FBRyxJQUFJLHdCQUFjLENBQUM7WUFDNUMsNERBQTREO1lBQzVELDJFQUEyRTtZQUMzRSwrQ0FBK0M7WUFDL0Msa0ZBQWtGO1lBQ2xGLFVBQVUsRUFBRSxJQUFJO1NBQ2pCLENBQUMsQ0FBQztRQUtELElBQUksOEJBQWMsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ25DLGNBQWMsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUM3QixNQUFNLEVBQUUsS0FBSyxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDO1NBQzFDLENBQUMsQ0FBQztJQUNMLENBQUM7Q0FDRjtBQXBCRCxrQ0FvQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBQb2xpY3lEb2N1bWVudCB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0IHsgQ29uc3RydWN0LCBSZXNvdXJjZSB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ2ZuVG9waWNQb2xpY3kgfSBmcm9tICcuL3Nucy5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgSVRvcGljIH0gZnJvbSAnLi90b3BpYy1iYXNlJztcblxuZXhwb3J0IGludGVyZmFjZSBUb3BpY1BvbGljeVByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBzZXQgb2YgdG9waWNzIHRoaXMgcG9saWN5IGFwcGxpZXMgdG8uXG4gICAqL1xuICByZWFkb25seSB0b3BpY3M6IElUb3BpY1tdO1xufVxuXG4vKipcbiAqIEFwcGxpZXMgYSBwb2xpY3kgdG8gU05TIHRvcGljcy5cbiAqL1xuZXhwb3J0IGNsYXNzIFRvcGljUG9saWN5IGV4dGVuZHMgUmVzb3VyY2Uge1xuICAvKipcbiAgICogVGhlIElBTSBwb2xpY3kgZG9jdW1lbnQgZm9yIHRoaXMgcG9saWN5LlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGRvY3VtZW50ID0gbmV3IFBvbGljeURvY3VtZW50KHtcbiAgICAvLyBzdGF0ZW1lbnRzIG11c3QgYmUgdW5pcXVlLCBzbyB3ZSB1c2UgdGhlIHN0YXRlbWVudCBpbmRleC5cbiAgICAvLyBwb3RhbnRpYWxseSBTSURzIGNhbiBjaGFuZ2UgYXMgYSByZXN1bHQgb2Ygb3JkZXIgY2hhbmdlLCBidXQgdGhpcyBzaG91bGRcbiAgICAvLyBub3QgaGF2ZSBhbiBpbXBhY3Qgb24gdGhlIHBvbGljeSBldmFsdWF0aW9uLlxuICAgIC8vIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zbnMvbGF0ZXN0L2RnL0FjY2Vzc1BvbGljeUxhbmd1YWdlX1NwZWNpYWxJbmZvLmh0bWxcbiAgICBhc3NpZ25TaWRzOiB0cnVlXG4gIH0pO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBUb3BpY1BvbGljeVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIG5ldyBDZm5Ub3BpY1BvbGljeSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBwb2xpY3lEb2N1bWVudDogdGhpcy5kb2N1bWVudCxcbiAgICAgIHRvcGljczogcHJvcHMudG9waWNzLm1hcCh0ID0+IHQudG9waWNBcm4pXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==