# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_cli.ipynb.

# %% auto 0
__all__ = ['download_grammars']

# %% ../nbs/01_cli.ipynb 2
import code_tokenizers

from fastcore.script import *
from git import Git, Repo
from pathlib import Path
from tree_sitter import Language

# %% ../nbs/01_cli.ipynb 4
_GRAMMARs = {
    "python": ("https://github.com/tree-sitter/tree-sitter-python.git", "tree-sitter-python", "v0.20.0"),
}

# %% ../nbs/01_cli.ipynb 5
@call_parse
def download_grammars(
    languages: Param("Languages to download", str, nargs="+") = "all",
):
    """Download Tree-sitter grammars"""
    try:
        grammars = _GRAMMARs if languages == "all" else {k: _GRAMMARs[k] for k in languages}
    except KeyError as e:
        raise ValueError(f"Invalid or unsupported language: {e}. Supported languages: {list(_GRAMMARs.keys())}")

    langs = []
    grammar_dir = Path(code_tokenizers.__file__).parent / "grammars"
    grammar_dir.mkdir(exist_ok=True)
    for lang, (url, dir, tag) in grammars.items():
        repo_dir = grammar_dir / dir
        if not repo_dir.exists():
            repo = Repo.clone_from(url, repo_dir)
        g = Git(str(repo_dir))
        g.checkout(tag)
        langs.append(str(repo_dir))
    
    Language.build_library(
        # Store the library in the directory
        str(grammar_dir / "tree-sitter-languages.so"),
        # Include one or more languages
        langs
    )
