"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataFormat = exports.Encryption = exports.Machine = exports.Technology = exports.Size = exports.TechnicalAssetType = exports.TechnicalAsset = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const communication_1 = require("./communication");
const model_1 = require("./model");
const resource_1 = require("./resource");
const scope_1 = require("./scope");
class TechnicalAsset extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.type = props.type;
        this.usage = props.usage;
        this.humanUse = props.humanUse;
        this.internet = props.internet;
        this.scope = props.scope ?? new scope_1.InScope();
        this.size = props.size;
        this.technology = props.technology;
        this.tags = props.tags;
        this.machine = props.machine;
        this.encryption = props.encryption;
        this.owner = props.owner;
        this.ciaTriad = props.ciaTriad;
        this.multiTenant = props.multiTenant;
        this.redundant = props.redundant;
        this.dataAssetsProcessed = new Set();
        this.dataAssetsStored = new Set();
        this.communications = new Array();
        if (this.tags && this.tags.length > 0) {
            const model = model_1.Model.of(this);
            model.addTags(...this.tags);
        }
        if (props.trustBoundary) {
            props.trustBoundary.addTechnicalAssets(this);
        }
    }
    process(...assets) {
        assets.forEach((a) => {
            this.dataAssetsProcessed.add(a.uuid);
        });
    }
    store(...assets) {
        assets.forEach((a) => {
            this.dataAssetsStored.add(a.uuid);
        });
    }
    communicateWith(id, target, options) {
        const communication = new communication_1.Communication(id, {
            target: target,
            ...options,
        });
        this.communications.push(communication);
        return communication;
    }
    /**
     * @internal
     */
    _toThreagile() {
        const threagile = {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                type: this.type,
                usage: this.usage,
                used_as_client_by_human: this.humanUse,
                ...this.scope?._toThreagile(),
                size: this.size,
                technology: this.technology,
                tags: Array.from(new Set(this.tags)),
                internet: this.internet,
                machine: this.machine,
                encryption: this.encryption,
                owner: this.owner,
                ...this.ciaTriad._toThreagile(),
                multitenant: this.multiTenant,
                redundant: this.redundant,
                data_assets_processed: Array.from(this.dataAssetsProcessed),
                data_assets_stored: Array.from(this.dataAssetsStored),
            },
        };
        if (this.communications.length > 0) {
            threagile[this.node.id].communication_links = {};
            this.communications.forEach((c) => {
                threagile[this.node.id].communication_links = {
                    ...threagile[this.node.id].communication_links,
                    ...c._toThreagile(),
                };
            });
        }
        return threagile;
    }
}
exports.TechnicalAsset = TechnicalAsset;
_a = JSII_RTTI_SYMBOL_1;
TechnicalAsset[_a] = { fqn: "cdktg.TechnicalAsset", version: "0.0.13" };
var TechnicalAssetType;
(function (TechnicalAssetType) {
    TechnicalAssetType["EXTERNAL_ENTITY"] = "external-entity";
    TechnicalAssetType["PROCESS"] = "process";
    TechnicalAssetType["DATASTORE"] = "datastore";
})(TechnicalAssetType = exports.TechnicalAssetType || (exports.TechnicalAssetType = {}));
var Size;
(function (Size) {
    Size["SYSTEM"] = "system";
    Size["SERVICE"] = "service";
    Size["APPLICATION"] = "application";
    Size["COMPONENT"] = "component";
})(Size = exports.Size || (exports.Size = {}));
var Technology;
(function (Technology) {
    Technology["UNKNOWN"] = "unknown-technology";
    Technology["CLIENT_SYSTEM"] = "client-system";
    Technology["BROWSER"] = "browser";
    Technology["DESKTOP"] = "desktop";
    Technology["MOBILE_APP"] = "mobile-app";
    Technology["DEVOPS_CLIENT"] = "devops-client";
    Technology["WEB_SERVER"] = "web-server";
    Technology["WEB_APPLICATION"] = "web-application";
    Technology["APPLICATION_SERVER"] = "application-server";
    Technology["DATABASE"] = "database";
    Technology["FILE_SERVER"] = "file-server";
    Technology["LOCAL_FILE_SERVER"] = "local-file-system";
    Technology["ERP"] = "erp";
    Technology["CMS"] = "cms";
    Technology["WEB_SERVICE_REST"] = "web-service-rest";
    Technology["WEB_SERVICE_SOAP"] = "web-service-soap";
    Technology["EJB"] = "ejb";
    Technology["SEARCH_INDEX"] = "search-index";
    Technology["SEARCH_ENGINE"] = "search-engine";
    Technology["SERVICE_REGISTRY"] = "service-registry";
    Technology["REVERSE_PROXY"] = "reverse-proxy";
    Technology["LOAD_BALANCER"] = "load-balancer";
    Technology["BUILD_PIPELINE"] = "build-pipeline";
    Technology["SOURCECODE_REPOSITORY"] = "sourcecode-repository";
    Technology["ARTIFACT_REGISTRY"] = "artifact-registry";
    Technology["CODE_INSPECTION_PLATFORM"] = "code-inspection-platform";
    Technology["MONITORING"] = "monitoring";
    Technology["LDAP_SERVER"] = "ldap-server";
    Technology["CONTAINER_PLATFORM"] = "container-platform";
    Technology["BATCH_PROCESSING"] = "batch-processing";
    Technology["EVENT_LISTENER"] = "event-listener";
    Technology["IDENTITIY_PROVIDER"] = "identity-provider";
    Technology["IDENTITY_STORE_LDAP"] = "identity-store-ldap";
    Technology["IDENTITY_STORE_DATABASE"] = "identity-store-database";
    Technology["TOOL"] = "tool";
    Technology["CLI"] = "cli";
    Technology["TASK"] = "task";
    Technology["FUNCTION"] = "function";
    Technology["GATEWAY"] = "gateway";
    Technology["IOT_DEVICE"] = "iot-device";
    Technology["MESSAGE_QUEUE"] = "message-queue";
    Technology["STREAM_PROCESSING"] = "stream-processing";
    Technology["SERVICE_MESH"] = "service-mesh";
    Technology["DATA_LAKE"] = "data-lake";
    Technology["REPORT_ENGINE"] = "report-engine";
    Technology["AI"] = "ai";
    Technology["MAIL_SERVER"] = "mail-server";
    Technology["VAULT"] = "vault";
    Technology["HASM"] = "hsm";
    Technology["WAF"] = "waf";
    Technology["IDS"] = "ids";
    Technology["IPS"] = "ips";
    Technology["SCHEDULER"] = "scheduler";
    Technology["MAINFRAME"] = "mainframe";
    Technology["BLOCK_STORAGE"] = "block-storage";
    Technology["LIBRARY"] = "library";
})(Technology = exports.Technology || (exports.Technology = {}));
var Machine;
(function (Machine) {
    Machine["PHYSICAL"] = "physical";
    Machine["VIRTUAL"] = "virtual";
    Machine["CONTAINER"] = "container";
    Machine["SERVERLESS"] = "serverless";
})(Machine = exports.Machine || (exports.Machine = {}));
var Encryption;
(function (Encryption) {
    Encryption["NONE"] = "none";
    Encryption["TRANSPARENT"] = "transparent";
    Encryption["SYMMETRIC_SHARED_KEY"] = "data-with-symmetric-shared-key";
    Encryption["ASYMMETRIC_SHARED_KEY"] = "data-with-asymmetric-shared-key";
    Encryption["ENDUSER_INDIVIDUAL_KEY"] = "data-with-enduser-individual-key";
})(Encryption = exports.Encryption || (exports.Encryption = {}));
var DataFormat;
(function (DataFormat) {
    DataFormat["JSON"] = "json";
    DataFormat["XML"] = "xml";
    DataFormat["SERIALIZATION"] = "serialization";
    DataFormat["FILE"] = "file";
    DataFormat["CSV"] = "csv";
})(DataFormat = exports.DataFormat || (exports.DataFormat = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVjaG5pY2FsLWFzc2V0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3RlY2huaWNhbC1hc3NldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUdBLG1EQUFzRTtBQUV0RSxtQ0FBZ0M7QUFDaEMseUNBQXFEO0FBQ3JELG1DQUF5QztBQXVCekMsTUFBYSxjQUFlLFNBQVEsbUJBQVE7SUFvQjFDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMEI7UUFDbEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFeEIsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQztRQUN6QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQy9CLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDLEtBQUssSUFBSSxJQUFJLGVBQU8sRUFBRSxDQUFDO1FBQzFDLElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztRQUN2QixJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDO1FBQ3pCLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO1FBRWpDLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxJQUFJLEdBQUcsRUFBVSxDQUFDO1FBQzdDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLEdBQUcsRUFBVSxDQUFDO1FBRTFDLElBQUksQ0FBQyxjQUFjLEdBQUcsSUFBSSxLQUFLLEVBQWlCLENBQUM7UUFFakQsSUFBSSxJQUFJLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtZQUNyQyxNQUFNLEtBQUssR0FBRyxhQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDO1lBQzdCLEtBQUssQ0FBQyxPQUFPLENBQUMsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7U0FDN0I7UUFFRCxJQUFJLEtBQUssQ0FBQyxhQUFhLEVBQUU7WUFDdkIsS0FBSyxDQUFDLGFBQWEsQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztTQUM5QztJQUNILENBQUM7SUFFTSxPQUFPLENBQUMsR0FBRyxNQUFtQjtRQUNuQyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUU7WUFDbkIsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDdkMsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU0sS0FBSyxDQUFDLEdBQUcsTUFBbUI7UUFDakMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFO1lBQ25CLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ3BDLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVNLGVBQWUsQ0FDcEIsRUFBVSxFQUNWLE1BQXNCLEVBQ3RCLE9BQTZCO1FBRTdCLE1BQU0sYUFBYSxHQUFHLElBQUksNkJBQWEsQ0FBQyxFQUFFLEVBQUU7WUFDMUMsTUFBTSxFQUFFLE1BQU07WUFDZCxHQUFHLE9BQU87U0FDWCxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztRQUV4QyxPQUFPLGFBQWEsQ0FBQztJQUN2QixDQUFDO0lBRUQ7O09BRUc7SUFDSSxZQUFZO1FBQ2pCLE1BQU0sU0FBUyxHQUFRO1lBQ3JCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsRUFBRTtnQkFDZCxFQUFFLEVBQUUsSUFBSSxDQUFDLElBQUk7Z0JBQ2IsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO2dCQUM3QixJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUk7Z0JBQ2YsS0FBSyxFQUFFLElBQUksQ0FBQyxLQUFLO2dCQUNqQix1QkFBdUIsRUFBRSxJQUFJLENBQUMsUUFBUTtnQkFDdEMsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLFlBQVksRUFBRTtnQkFDN0IsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO2dCQUNmLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtnQkFDM0IsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO2dCQUNwQyxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7Z0JBQ3ZCLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztnQkFDckIsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVO2dCQUMzQixLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUs7Z0JBQ2pCLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxZQUFZLEVBQUU7Z0JBQy9CLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztnQkFDN0IsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO2dCQUN6QixxQkFBcUIsRUFBRSxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztnQkFDM0Qsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7YUFDdEQ7U0FDRixDQUFDO1FBRUYsSUFBSSxJQUFJLENBQUMsY0FBYyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7WUFDbEMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUMsbUJBQW1CLEdBQUcsRUFBRSxDQUFDO1lBRWpELElBQUksQ0FBQyxjQUFjLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUU7Z0JBQ2hDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDLG1CQUFtQixHQUFHO29CQUM1QyxHQUFHLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDLG1CQUFtQjtvQkFDOUMsR0FBRyxDQUFDLENBQUMsWUFBWSxFQUFFO2lCQUNwQixDQUFDO1lBQ0osQ0FBQyxDQUFDLENBQUM7U0FDSjtRQUVELE9BQU8sU0FBUyxDQUFDO0lBQ25CLENBQUM7O0FBdkhILHdDQXdIQzs7O0FBRUQsSUFBWSxrQkFJWDtBQUpELFdBQVksa0JBQWtCO0lBQzVCLHlEQUFtQyxDQUFBO0lBQ25DLHlDQUFtQixDQUFBO0lBQ25CLDZDQUF1QixDQUFBO0FBQ3pCLENBQUMsRUFKVyxrQkFBa0IsR0FBbEIsMEJBQWtCLEtBQWxCLDBCQUFrQixRQUk3QjtBQUVELElBQVksSUFLWDtBQUxELFdBQVksSUFBSTtJQUNkLHlCQUFpQixDQUFBO0lBQ2pCLDJCQUFtQixDQUFBO0lBQ25CLG1DQUEyQixDQUFBO0lBQzNCLCtCQUF1QixDQUFBO0FBQ3pCLENBQUMsRUFMVyxJQUFJLEdBQUosWUFBSSxLQUFKLFlBQUksUUFLZjtBQUVELElBQVksVUF5RFg7QUF6REQsV0FBWSxVQUFVO0lBQ3BCLDRDQUE4QixDQUFBO0lBQzlCLDZDQUErQixDQUFBO0lBQy9CLGlDQUFtQixDQUFBO0lBQ25CLGlDQUFtQixDQUFBO0lBQ25CLHVDQUF5QixDQUFBO0lBQ3pCLDZDQUErQixDQUFBO0lBQy9CLHVDQUF5QixDQUFBO0lBQ3pCLGlEQUFtQyxDQUFBO0lBQ25DLHVEQUF5QyxDQUFBO0lBQ3pDLG1DQUFxQixDQUFBO0lBQ3JCLHlDQUEyQixDQUFBO0lBQzNCLHFEQUF1QyxDQUFBO0lBQ3ZDLHlCQUFXLENBQUE7SUFDWCx5QkFBVyxDQUFBO0lBQ1gsbURBQXFDLENBQUE7SUFDckMsbURBQXFDLENBQUE7SUFDckMseUJBQVcsQ0FBQTtJQUNYLDJDQUE2QixDQUFBO0lBQzdCLDZDQUErQixDQUFBO0lBQy9CLG1EQUFxQyxDQUFBO0lBQ3JDLDZDQUErQixDQUFBO0lBQy9CLDZDQUErQixDQUFBO0lBQy9CLCtDQUFpQyxDQUFBO0lBQ2pDLDZEQUErQyxDQUFBO0lBQy9DLHFEQUF1QyxDQUFBO0lBQ3ZDLG1FQUFxRCxDQUFBO0lBQ3JELHVDQUF5QixDQUFBO0lBQ3pCLHlDQUEyQixDQUFBO0lBQzNCLHVEQUF5QyxDQUFBO0lBQ3pDLG1EQUFxQyxDQUFBO0lBQ3JDLCtDQUFpQyxDQUFBO0lBQ2pDLHNEQUF3QyxDQUFBO0lBQ3hDLHlEQUEyQyxDQUFBO0lBQzNDLGlFQUFtRCxDQUFBO0lBQ25ELDJCQUFhLENBQUE7SUFDYix5QkFBVyxDQUFBO0lBQ1gsMkJBQWEsQ0FBQTtJQUNiLG1DQUFxQixDQUFBO0lBQ3JCLGlDQUFtQixDQUFBO0lBQ25CLHVDQUF5QixDQUFBO0lBQ3pCLDZDQUErQixDQUFBO0lBQy9CLHFEQUF1QyxDQUFBO0lBQ3ZDLDJDQUE2QixDQUFBO0lBQzdCLHFDQUF1QixDQUFBO0lBQ3ZCLDZDQUErQixDQUFBO0lBQy9CLHVCQUFTLENBQUE7SUFDVCx5Q0FBMkIsQ0FBQTtJQUMzQiw2QkFBZSxDQUFBO0lBQ2YsMEJBQVksQ0FBQTtJQUNaLHlCQUFXLENBQUE7SUFDWCx5QkFBVyxDQUFBO0lBQ1gseUJBQVcsQ0FBQTtJQUNYLHFDQUF1QixDQUFBO0lBQ3ZCLHFDQUF1QixDQUFBO0lBQ3ZCLDZDQUErQixDQUFBO0lBQy9CLGlDQUFtQixDQUFBO0FBQ3JCLENBQUMsRUF6RFcsVUFBVSxHQUFWLGtCQUFVLEtBQVYsa0JBQVUsUUF5RHJCO0FBRUQsSUFBWSxPQUtYO0FBTEQsV0FBWSxPQUFPO0lBQ2pCLGdDQUFxQixDQUFBO0lBQ3JCLDhCQUFtQixDQUFBO0lBQ25CLGtDQUF1QixDQUFBO0lBQ3ZCLG9DQUF5QixDQUFBO0FBQzNCLENBQUMsRUFMVyxPQUFPLEdBQVAsZUFBTyxLQUFQLGVBQU8sUUFLbEI7QUFFRCxJQUFZLFVBTVg7QUFORCxXQUFZLFVBQVU7SUFDcEIsMkJBQWEsQ0FBQTtJQUNiLHlDQUEyQixDQUFBO0lBQzNCLHFFQUF1RCxDQUFBO0lBQ3ZELHVFQUF5RCxDQUFBO0lBQ3pELHlFQUEyRCxDQUFBO0FBQzdELENBQUMsRUFOVyxVQUFVLEdBQVYsa0JBQVUsS0FBVixrQkFBVSxRQU1yQjtBQUVELElBQVksVUFNWDtBQU5ELFdBQVksVUFBVTtJQUNwQiwyQkFBYSxDQUFBO0lBQ2IseUJBQVcsQ0FBQTtJQUNYLDZDQUErQixDQUFBO0lBQy9CLDJCQUFhLENBQUE7SUFDYix5QkFBVyxDQUFBO0FBQ2IsQ0FBQyxFQU5XLFVBQVUsR0FBVixrQkFBVSxLQUFWLGtCQUFVLFFBTXJCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcblxuaW1wb3J0IHsgQ0lBVHJpYWQgfSBmcm9tIFwiLi9jaWEtdHJpYWRlXCI7XG5pbXBvcnQgeyBDb21tdW5pY2F0aW9uLCBDb21tdW5pY2F0aW9uT3B0aW9ucyB9IGZyb20gXCIuL2NvbW11bmljYXRpb25cIjtcbmltcG9ydCB7IERhdGFBc3NldCB9IGZyb20gXCIuL2RhdGEtYXNzZXRcIjtcbmltcG9ydCB7IE1vZGVsIH0gZnJvbSBcIi4vbW9kZWxcIjtcbmltcG9ydCB7IFJlc291cmNlLCBSZXNvdXJjZVByb3BzIH0gZnJvbSBcIi4vcmVzb3VyY2VcIjtcbmltcG9ydCB7IEluU2NvcGUsIFNjb3BlIH0gZnJvbSBcIi4vc2NvcGVcIjtcbmltcG9ydCAqIGFzIHNwZWMgZnJvbSBcIi4vc3BlYy90aHJlYXRnaWxlLmdlbmVyYXRlZFwiO1xuaW1wb3J0IHsgVHJ1c3RCb3VuZGFyeSB9IGZyb20gXCIuL3RydXN0LWJvdW5kYXJ5XCI7XG5pbXBvcnQgeyBVc2FnZSB9IGZyb20gXCIuL3VzYWdlXCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgVGVjaG5pY2FsQXNzZXRQcm9wcyBleHRlbmRzIFJlc291cmNlUHJvcHMge1xuICByZWFkb25seSB0eXBlOiBUZWNobmljYWxBc3NldFR5cGU7XG4gIHJlYWRvbmx5IHVzYWdlOiBVc2FnZTtcbiAgcmVhZG9ubHkgaHVtYW5Vc2U6IGJvb2xlYW47XG4gIHJlYWRvbmx5IHNjb3BlPzogU2NvcGU7XG4gIHJlYWRvbmx5IHNpemU6IFNpemU7XG4gIHJlYWRvbmx5IHRlY2hub2xvZ3k6IFRlY2hub2xvZ3k7XG4gIHJlYWRvbmx5IHRhZ3M/OiBzdHJpbmdbXTtcbiAgcmVhZG9ubHkgaW50ZXJuZXQ6IGJvb2xlYW47XG4gIHJlYWRvbmx5IG1hY2hpbmU6IE1hY2hpbmU7XG4gIHJlYWRvbmx5IGVuY3J5cHRpb246IEVuY3J5cHRpb247XG4gIHJlYWRvbmx5IG93bmVyOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGNpYVRyaWFkOiBDSUFUcmlhZDtcbiAgcmVhZG9ubHkgbXVsdGlUZW5hbnQ6IGJvb2xlYW47XG4gIHJlYWRvbmx5IHJlZHVuZGFudDogYm9vbGVhbjtcbiAgcmVhZG9ubHkgdHJ1c3RCb3VuZGFyeT86IFRydXN0Qm91bmRhcnk7XG59XG5cbmV4cG9ydCBjbGFzcyBUZWNobmljYWxBc3NldCBleHRlbmRzIFJlc291cmNlIHtcbiAgcHVibGljIHJlYWRvbmx5IHR5cGU6IFRlY2huaWNhbEFzc2V0VHlwZTtcbiAgcHVibGljIHJlYWRvbmx5IHVzYWdlOiBVc2FnZTtcbiAgcHVibGljIHJlYWRvbmx5IGludGVybmV0OiBib29sZWFuO1xuICBwdWJsaWMgcmVhZG9ubHkgaHVtYW5Vc2U6IGJvb2xlYW47XG4gIHB1YmxpYyByZWFkb25seSBzY29wZT86IFNjb3BlO1xuICBwdWJsaWMgcmVhZG9ubHkgc2l6ZTogU2l6ZTtcbiAgcHVibGljIHJlYWRvbmx5IHRlY2hub2xvZ3k6IFRlY2hub2xvZ3k7XG4gIHB1YmxpYyByZWFkb25seSB0YWdzPzogc3RyaW5nW107XG4gIHB1YmxpYyByZWFkb25seSBtYWNoaW5lOiBNYWNoaW5lO1xuICBwdWJsaWMgcmVhZG9ubHkgZW5jcnlwdGlvbjogRW5jcnlwdGlvbjtcbiAgcHVibGljIHJlYWRvbmx5IG93bmVyOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBjaWFUcmlhZDogQ0lBVHJpYWQ7XG4gIHB1YmxpYyByZWFkb25seSBtdWx0aVRlbmFudDogYm9vbGVhbjtcbiAgcHVibGljIHJlYWRvbmx5IHJlZHVuZGFudDogYm9vbGVhbjtcblxuICBwcml2YXRlIGRhdGFBc3NldHNQcm9jZXNzZWQ6IFNldDxzdHJpbmc+O1xuICBwcml2YXRlIGRhdGFBc3NldHNTdG9yZWQ6IFNldDxzdHJpbmc+O1xuICBwcml2YXRlIGNvbW11bmljYXRpb25zOiBDb21tdW5pY2F0aW9uW107XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFRlY2huaWNhbEFzc2V0UHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcblxuICAgIHRoaXMudHlwZSA9IHByb3BzLnR5cGU7XG4gICAgdGhpcy51c2FnZSA9IHByb3BzLnVzYWdlO1xuICAgIHRoaXMuaHVtYW5Vc2UgPSBwcm9wcy5odW1hblVzZTtcbiAgICB0aGlzLmludGVybmV0ID0gcHJvcHMuaW50ZXJuZXQ7XG4gICAgdGhpcy5zY29wZSA9IHByb3BzLnNjb3BlID8/IG5ldyBJblNjb3BlKCk7XG4gICAgdGhpcy5zaXplID0gcHJvcHMuc2l6ZTtcbiAgICB0aGlzLnRlY2hub2xvZ3kgPSBwcm9wcy50ZWNobm9sb2d5O1xuICAgIHRoaXMudGFncyA9IHByb3BzLnRhZ3M7XG4gICAgdGhpcy5tYWNoaW5lID0gcHJvcHMubWFjaGluZTtcbiAgICB0aGlzLmVuY3J5cHRpb24gPSBwcm9wcy5lbmNyeXB0aW9uO1xuICAgIHRoaXMub3duZXIgPSBwcm9wcy5vd25lcjtcbiAgICB0aGlzLmNpYVRyaWFkID0gcHJvcHMuY2lhVHJpYWQ7XG4gICAgdGhpcy5tdWx0aVRlbmFudCA9IHByb3BzLm11bHRpVGVuYW50O1xuICAgIHRoaXMucmVkdW5kYW50ID0gcHJvcHMucmVkdW5kYW50O1xuXG4gICAgdGhpcy5kYXRhQXNzZXRzUHJvY2Vzc2VkID0gbmV3IFNldDxzdHJpbmc+KCk7XG4gICAgdGhpcy5kYXRhQXNzZXRzU3RvcmVkID0gbmV3IFNldDxzdHJpbmc+KCk7XG5cbiAgICB0aGlzLmNvbW11bmljYXRpb25zID0gbmV3IEFycmF5PENvbW11bmljYXRpb24+KCk7XG5cbiAgICBpZiAodGhpcy50YWdzICYmIHRoaXMudGFncy5sZW5ndGggPiAwKSB7XG4gICAgICBjb25zdCBtb2RlbCA9IE1vZGVsLm9mKHRoaXMpO1xuICAgICAgbW9kZWwuYWRkVGFncyguLi50aGlzLnRhZ3MpO1xuICAgIH1cblxuICAgIGlmIChwcm9wcy50cnVzdEJvdW5kYXJ5KSB7XG4gICAgICBwcm9wcy50cnVzdEJvdW5kYXJ5LmFkZFRlY2huaWNhbEFzc2V0cyh0aGlzKTtcbiAgICB9XG4gIH1cblxuICBwdWJsaWMgcHJvY2VzcyguLi5hc3NldHM6IERhdGFBc3NldFtdKSB7XG4gICAgYXNzZXRzLmZvckVhY2goKGEpID0+IHtcbiAgICAgIHRoaXMuZGF0YUFzc2V0c1Byb2Nlc3NlZC5hZGQoYS51dWlkKTtcbiAgICB9KTtcbiAgfVxuXG4gIHB1YmxpYyBzdG9yZSguLi5hc3NldHM6IERhdGFBc3NldFtdKSB7XG4gICAgYXNzZXRzLmZvckVhY2goKGEpID0+IHtcbiAgICAgIHRoaXMuZGF0YUFzc2V0c1N0b3JlZC5hZGQoYS51dWlkKTtcbiAgICB9KTtcbiAgfVxuXG4gIHB1YmxpYyBjb21tdW5pY2F0ZVdpdGgoXG4gICAgaWQ6IHN0cmluZyxcbiAgICB0YXJnZXQ6IFRlY2huaWNhbEFzc2V0LFxuICAgIG9wdGlvbnM6IENvbW11bmljYXRpb25PcHRpb25zXG4gICk6IENvbW11bmljYXRpb24ge1xuICAgIGNvbnN0IGNvbW11bmljYXRpb24gPSBuZXcgQ29tbXVuaWNhdGlvbihpZCwge1xuICAgICAgdGFyZ2V0OiB0YXJnZXQsXG4gICAgICAuLi5vcHRpb25zLFxuICAgIH0pO1xuXG4gICAgdGhpcy5jb21tdW5pY2F0aW9ucy5wdXNoKGNvbW11bmljYXRpb24pO1xuXG4gICAgcmV0dXJuIGNvbW11bmljYXRpb247XG4gIH1cblxuICAvKipcbiAgICogQGludGVybmFsXG4gICAqL1xuICBwdWJsaWMgX3RvVGhyZWFnaWxlKCk6IHNwZWMuVGhyZWFnaWxlW1widGVjaG5pY2FsX2Fzc2V0c1wiXSB7XG4gICAgY29uc3QgdGhyZWFnaWxlOiBhbnkgPSB7XG4gICAgICBbdGhpcy5ub2RlLmlkXToge1xuICAgICAgICBpZDogdGhpcy51dWlkLFxuICAgICAgICBkZXNjcmlwdGlvbjogdGhpcy5kZXNjcmlwdGlvbixcbiAgICAgICAgdHlwZTogdGhpcy50eXBlLFxuICAgICAgICB1c2FnZTogdGhpcy51c2FnZSxcbiAgICAgICAgdXNlZF9hc19jbGllbnRfYnlfaHVtYW46IHRoaXMuaHVtYW5Vc2UsXG4gICAgICAgIC4uLnRoaXMuc2NvcGU/Ll90b1RocmVhZ2lsZSgpLFxuICAgICAgICBzaXplOiB0aGlzLnNpemUsXG4gICAgICAgIHRlY2hub2xvZ3k6IHRoaXMudGVjaG5vbG9neSxcbiAgICAgICAgdGFnczogQXJyYXkuZnJvbShuZXcgU2V0KHRoaXMudGFncykpLFxuICAgICAgICBpbnRlcm5ldDogdGhpcy5pbnRlcm5ldCxcbiAgICAgICAgbWFjaGluZTogdGhpcy5tYWNoaW5lLFxuICAgICAgICBlbmNyeXB0aW9uOiB0aGlzLmVuY3J5cHRpb24sXG4gICAgICAgIG93bmVyOiB0aGlzLm93bmVyLFxuICAgICAgICAuLi50aGlzLmNpYVRyaWFkLl90b1RocmVhZ2lsZSgpLFxuICAgICAgICBtdWx0aXRlbmFudDogdGhpcy5tdWx0aVRlbmFudCxcbiAgICAgICAgcmVkdW5kYW50OiB0aGlzLnJlZHVuZGFudCxcbiAgICAgICAgZGF0YV9hc3NldHNfcHJvY2Vzc2VkOiBBcnJheS5mcm9tKHRoaXMuZGF0YUFzc2V0c1Byb2Nlc3NlZCksXG4gICAgICAgIGRhdGFfYXNzZXRzX3N0b3JlZDogQXJyYXkuZnJvbSh0aGlzLmRhdGFBc3NldHNTdG9yZWQpLFxuICAgICAgfSxcbiAgICB9O1xuXG4gICAgaWYgKHRoaXMuY29tbXVuaWNhdGlvbnMubGVuZ3RoID4gMCkge1xuICAgICAgdGhyZWFnaWxlW3RoaXMubm9kZS5pZF0uY29tbXVuaWNhdGlvbl9saW5rcyA9IHt9O1xuXG4gICAgICB0aGlzLmNvbW11bmljYXRpb25zLmZvckVhY2goKGMpID0+IHtcbiAgICAgICAgdGhyZWFnaWxlW3RoaXMubm9kZS5pZF0uY29tbXVuaWNhdGlvbl9saW5rcyA9IHtcbiAgICAgICAgICAuLi50aHJlYWdpbGVbdGhpcy5ub2RlLmlkXS5jb21tdW5pY2F0aW9uX2xpbmtzLFxuICAgICAgICAgIC4uLmMuX3RvVGhyZWFnaWxlKCksXG4gICAgICAgIH07XG4gICAgICB9KTtcbiAgICB9XG5cbiAgICByZXR1cm4gdGhyZWFnaWxlO1xuICB9XG59XG5cbmV4cG9ydCBlbnVtIFRlY2huaWNhbEFzc2V0VHlwZSB7XG4gIEVYVEVSTkFMX0VOVElUWSA9IFwiZXh0ZXJuYWwtZW50aXR5XCIsXG4gIFBST0NFU1MgPSBcInByb2Nlc3NcIixcbiAgREFUQVNUT1JFID0gXCJkYXRhc3RvcmVcIixcbn1cblxuZXhwb3J0IGVudW0gU2l6ZSB7XG4gIFNZU1RFTSA9IFwic3lzdGVtXCIsXG4gIFNFUlZJQ0UgPSBcInNlcnZpY2VcIixcbiAgQVBQTElDQVRJT04gPSBcImFwcGxpY2F0aW9uXCIsXG4gIENPTVBPTkVOVCA9IFwiY29tcG9uZW50XCIsXG59XG5cbmV4cG9ydCBlbnVtIFRlY2hub2xvZ3kge1xuICBVTktOT1dOID0gXCJ1bmtub3duLXRlY2hub2xvZ3lcIixcbiAgQ0xJRU5UX1NZU1RFTSA9IFwiY2xpZW50LXN5c3RlbVwiLFxuICBCUk9XU0VSID0gXCJicm93c2VyXCIsXG4gIERFU0tUT1AgPSBcImRlc2t0b3BcIixcbiAgTU9CSUxFX0FQUCA9IFwibW9iaWxlLWFwcFwiLFxuICBERVZPUFNfQ0xJRU5UID0gXCJkZXZvcHMtY2xpZW50XCIsXG4gIFdFQl9TRVJWRVIgPSBcIndlYi1zZXJ2ZXJcIixcbiAgV0VCX0FQUExJQ0FUSU9OID0gXCJ3ZWItYXBwbGljYXRpb25cIixcbiAgQVBQTElDQVRJT05fU0VSVkVSID0gXCJhcHBsaWNhdGlvbi1zZXJ2ZXJcIixcbiAgREFUQUJBU0UgPSBcImRhdGFiYXNlXCIsXG4gIEZJTEVfU0VSVkVSID0gXCJmaWxlLXNlcnZlclwiLFxuICBMT0NBTF9GSUxFX1NFUlZFUiA9IFwibG9jYWwtZmlsZS1zeXN0ZW1cIixcbiAgRVJQID0gXCJlcnBcIixcbiAgQ01TID0gXCJjbXNcIixcbiAgV0VCX1NFUlZJQ0VfUkVTVCA9IFwid2ViLXNlcnZpY2UtcmVzdFwiLFxuICBXRUJfU0VSVklDRV9TT0FQID0gXCJ3ZWItc2VydmljZS1zb2FwXCIsXG4gIEVKQiA9IFwiZWpiXCIsXG4gIFNFQVJDSF9JTkRFWCA9IFwic2VhcmNoLWluZGV4XCIsXG4gIFNFQVJDSF9FTkdJTkUgPSBcInNlYXJjaC1lbmdpbmVcIixcbiAgU0VSVklDRV9SRUdJU1RSWSA9IFwic2VydmljZS1yZWdpc3RyeVwiLFxuICBSRVZFUlNFX1BST1hZID0gXCJyZXZlcnNlLXByb3h5XCIsXG4gIExPQURfQkFMQU5DRVIgPSBcImxvYWQtYmFsYW5jZXJcIixcbiAgQlVJTERfUElQRUxJTkUgPSBcImJ1aWxkLXBpcGVsaW5lXCIsXG4gIFNPVVJDRUNPREVfUkVQT1NJVE9SWSA9IFwic291cmNlY29kZS1yZXBvc2l0b3J5XCIsXG4gIEFSVElGQUNUX1JFR0lTVFJZID0gXCJhcnRpZmFjdC1yZWdpc3RyeVwiLFxuICBDT0RFX0lOU1BFQ1RJT05fUExBVEZPUk0gPSBcImNvZGUtaW5zcGVjdGlvbi1wbGF0Zm9ybVwiLFxuICBNT05JVE9SSU5HID0gXCJtb25pdG9yaW5nXCIsXG4gIExEQVBfU0VSVkVSID0gXCJsZGFwLXNlcnZlclwiLFxuICBDT05UQUlORVJfUExBVEZPUk0gPSBcImNvbnRhaW5lci1wbGF0Zm9ybVwiLFxuICBCQVRDSF9QUk9DRVNTSU5HID0gXCJiYXRjaC1wcm9jZXNzaW5nXCIsXG4gIEVWRU5UX0xJU1RFTkVSID0gXCJldmVudC1saXN0ZW5lclwiLFxuICBJREVOVElUSVlfUFJPVklERVIgPSBcImlkZW50aXR5LXByb3ZpZGVyXCIsXG4gIElERU5USVRZX1NUT1JFX0xEQVAgPSBcImlkZW50aXR5LXN0b3JlLWxkYXBcIixcbiAgSURFTlRJVFlfU1RPUkVfREFUQUJBU0UgPSBcImlkZW50aXR5LXN0b3JlLWRhdGFiYXNlXCIsXG4gIFRPT0wgPSBcInRvb2xcIixcbiAgQ0xJID0gXCJjbGlcIixcbiAgVEFTSyA9IFwidGFza1wiLFxuICBGVU5DVElPTiA9IFwiZnVuY3Rpb25cIixcbiAgR0FURVdBWSA9IFwiZ2F0ZXdheVwiLFxuICBJT1RfREVWSUNFID0gXCJpb3QtZGV2aWNlXCIsXG4gIE1FU1NBR0VfUVVFVUUgPSBcIm1lc3NhZ2UtcXVldWVcIixcbiAgU1RSRUFNX1BST0NFU1NJTkcgPSBcInN0cmVhbS1wcm9jZXNzaW5nXCIsXG4gIFNFUlZJQ0VfTUVTSCA9IFwic2VydmljZS1tZXNoXCIsXG4gIERBVEFfTEFLRSA9IFwiZGF0YS1sYWtlXCIsXG4gIFJFUE9SVF9FTkdJTkUgPSBcInJlcG9ydC1lbmdpbmVcIixcbiAgQUkgPSBcImFpXCIsXG4gIE1BSUxfU0VSVkVSID0gXCJtYWlsLXNlcnZlclwiLFxuICBWQVVMVCA9IFwidmF1bHRcIixcbiAgSEFTTSA9IFwiaHNtXCIsXG4gIFdBRiA9IFwid2FmXCIsXG4gIElEUyA9IFwiaWRzXCIsXG4gIElQUyA9IFwiaXBzXCIsXG4gIFNDSEVEVUxFUiA9IFwic2NoZWR1bGVyXCIsXG4gIE1BSU5GUkFNRSA9IFwibWFpbmZyYW1lXCIsXG4gIEJMT0NLX1NUT1JBR0UgPSBcImJsb2NrLXN0b3JhZ2VcIixcbiAgTElCUkFSWSA9IFwibGlicmFyeVwiLFxufVxuXG5leHBvcnQgZW51bSBNYWNoaW5lIHtcbiAgUEhZU0lDQUwgPSBcInBoeXNpY2FsXCIsXG4gIFZJUlRVQUwgPSBcInZpcnR1YWxcIixcbiAgQ09OVEFJTkVSID0gXCJjb250YWluZXJcIixcbiAgU0VSVkVSTEVTUyA9IFwic2VydmVybGVzc1wiLFxufVxuXG5leHBvcnQgZW51bSBFbmNyeXB0aW9uIHtcbiAgTk9ORSA9IFwibm9uZVwiLFxuICBUUkFOU1BBUkVOVCA9IFwidHJhbnNwYXJlbnRcIixcbiAgU1lNTUVUUklDX1NIQVJFRF9LRVkgPSBcImRhdGEtd2l0aC1zeW1tZXRyaWMtc2hhcmVkLWtleVwiLFxuICBBU1lNTUVUUklDX1NIQVJFRF9LRVkgPSBcImRhdGEtd2l0aC1hc3ltbWV0cmljLXNoYXJlZC1rZXlcIixcbiAgRU5EVVNFUl9JTkRJVklEVUFMX0tFWSA9IFwiZGF0YS13aXRoLWVuZHVzZXItaW5kaXZpZHVhbC1rZXlcIixcbn1cblxuZXhwb3J0IGVudW0gRGF0YUZvcm1hdCB7XG4gIEpTT04gPSBcImpzb25cIixcbiAgWE1MID0gXCJ4bWxcIixcbiAgU0VSSUFMSVpBVElPTiA9IFwic2VyaWFsaXphdGlvblwiLFxuICBGSUxFID0gXCJmaWxlXCIsXG4gIENTViA9IFwiY3N2XCIsXG59XG4iXX0=