import { Construct } from "constructs";
import { Resource, ResourceProps } from "./resource";
import * as spec from "./spec/threatgile.generated";
import { TechnicalAsset } from "./technical-asset";
export interface SharedRuntimeProps extends ResourceProps {
    readonly tags?: string[];
}
export declare class SharedRuntime extends Resource {
    readonly tags?: string[];
    private technicalAssetsRunning;
    constructor(scope: Construct, id: string, props: SharedRuntimeProps);
    run(...assets: TechnicalAsset[]): void;
    /**
     * @internal
     */
    _toThreagile(): spec.Threagile["shared_runtimes"];
}
