"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessCriticality = exports.Model = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const data_asset_1 = require("./data-asset");
const shared_runtime_1 = require("./shared-runtime");
const synthesizer_1 = require("./synthesizer");
const technical_asset_1 = require("./technical-asset");
const trust_boundary_1 = require("./trust-boundary");
const MODEL_SYMBOL = Symbol.for("cdktg/Model");
class Model extends constructs_1.Construct {
    constructor(project, id, props) {
        super(project, id);
        this.version = props.version;
        this.title = props.title ?? id;
        this.date = props.date
            ? new Date(props.date).toISOString().split("T")[0]
            : undefined;
        this.author = props.author;
        this.managementSummary = props.managementSummary;
        this.businessCriticality = props.businessCriticality;
        this.tags = new Set();
        this.rawOverrides = {};
        this.synthesizer = new synthesizer_1.ModelSynthesizer(this, false);
        Object.defineProperty(this, MODEL_SYMBOL, { value: true });
    }
    static isModel(x) {
        return x !== null && typeof x === "object" && MODEL_SYMBOL in x;
    }
    static of(construct) {
        return _lookup(construct);
        function _lookup(c) {
            if (Model.isModel(c)) {
                return c;
            }
            const node = c.node;
            if (!node.scope) {
                throw new Error(`No model could be identified for the construct at path '${construct.node.path}'`);
            }
            return _lookup(node.scope);
        }
    }
    addTags(...tags) {
        tags.forEach((tag) => {
            this.tags.add(tag);
        });
    }
    addOverride(path, value) {
        const parts = path.split(".");
        let curr = this.rawOverrides;
        while (parts.length > 1) {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            const key = parts.shift();
            // if we can't recurse further or the previous value is not an
            // object overwrite it with an object.
            const isObject = curr[key] != null &&
                typeof curr[key] === "object" &&
                !Array.isArray(curr[key]);
            if (!isObject) {
                curr[key] = {};
            }
            curr = curr[key];
        }
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        const lastKey = parts.shift();
        curr[lastKey] = value;
    }
    /**
     * @internal
     */
    _toThreagile() {
        const dataAssets = new Array();
        const technicalAssets = new Array();
        const trustBoundaries = new Array();
        const sharedRuntimes = new Array();
        this.node.findAll().map((n) => {
            if (n instanceof data_asset_1.DataAsset) {
                dataAssets.push(n);
            }
            else if (n instanceof technical_asset_1.TechnicalAsset) {
                technicalAssets.push(n);
            }
            else if (n instanceof trust_boundary_1.TrustBoundary) {
                trustBoundaries.push(n);
            }
            else if (n instanceof shared_runtime_1.SharedRuntime) {
                sharedRuntimes.push(n);
            }
        });
        const threagile = {
            threagile_version: this.version,
            title: this.title,
            data: this.date,
            author: this.author._toThreagile(),
            management_summary_comment: this.managementSummary,
            business_criticality: this.businessCriticality,
            tags_available: Array.from(this.tags),
        };
        if (dataAssets.length > 0) {
            threagile.data_assets = {};
            dataAssets.forEach((a) => {
                const obj = a._toThreagile();
                const k = Object.keys(obj)[0];
                threagile.data_assets[k] = obj[k];
            });
        }
        if (technicalAssets.length > 0) {
            threagile.technical_assets = {};
            technicalAssets.forEach((a) => {
                const obj = a._toThreagile();
                const k = Object.keys(obj)[0];
                threagile.technical_assets[k] = obj[k];
            });
        }
        if (trustBoundaries.length > 0) {
            threagile.trust_boundaries = {};
            trustBoundaries.forEach((t) => {
                const obj = t._toThreagile();
                if (obj) {
                    const k = Object.keys(obj)[0];
                    threagile.trust_boundaries[k] = obj[k];
                }
            });
        }
        if (sharedRuntimes.length > 0) {
            threagile.shared_runtimes = {};
            sharedRuntimes.forEach((a) => {
                const obj = a._toThreagile();
                const k = Object.keys(obj)[0];
                threagile.shared_runtimes[k] = obj[k];
            });
        }
        return {
            ...threagile,
            ...(Object.keys(this.rawOverrides).length > 0
                ? { overrides: { stack: Object.keys(this.rawOverrides) } }
                : {}),
        };
    }
}
exports.Model = Model;
_a = JSII_RTTI_SYMBOL_1;
Model[_a] = { fqn: "cdktg.Model", version: "0.0.13" };
var BusinessCriticality;
(function (BusinessCriticality) {
    BusinessCriticality["ARCHIVE"] = "archive";
    BusinessCriticality["OPERATIONAL"] = "operational";
    BusinessCriticality["IMPORTANT"] = "important";
    BusinessCriticality["CRITICAL"] = "critical";
    BusinessCriticality["MISSION_CRITICAL"] = "mission-critical";
})(BusinessCriticality = exports.BusinessCriticality || (exports.BusinessCriticality = {}));
//# sourceMappingURL=data:application/json;base64,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