"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Quantity = exports.DataAsset = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const model_1 = require("./model");
const resource_1 = require("./resource");
class DataAsset extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.usage = props.usage;
        this.tags = props.tags;
        this.origin = props.origin;
        this.owner = props.owner;
        this.quantity = props.quantity;
        this.ciaTriad = props.ciaTriad;
        if (this.tags && this.tags.length > 0) {
            const model = model_1.Model.of(this);
            model.addTags(...this.tags);
        }
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                usage: this.usage,
                tags: Array.from(new Set(this.tags)),
                origin: this.origin,
                owner: this.owner,
                quantity: this.quantity,
                ...this.ciaTriad._toThreagile(),
            },
        };
    }
}
exports.DataAsset = DataAsset;
_a = JSII_RTTI_SYMBOL_1;
DataAsset[_a] = { fqn: "cdktg.DataAsset", version: "0.0.13" };
var Quantity;
(function (Quantity) {
    Quantity["VERY_FEW"] = "very-few";
    Quantity["FEW"] = "few";
    Quantity["MANY"] = "many";
    Quantity["VERY_MANY"] = "very-many";
})(Quantity = exports.Quantity || (exports.Quantity = {}));
//# sourceMappingURL=data:application/json;base64,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