# codat-banking

<!-- Start SDK Installation -->
## SDK Installation

```bash
pip install codat-banking
```
<!-- End SDK Installation -->

## SDK Example Usage
<!-- Start SDK Example Usage -->
```python
import codat
from codat.models import operations, shared

s = codat.Codat(
    security=shared.Security(
        auth_header="YOUR_API_KEY_HERE",
    ),
)


req = operations.ListAccountBalancesRequest(
    company_id="8a210b68-6988-11ed-a1eb-0242ac120002",
    connection_id="2e9d2c44-f675-40ba-8049-353bfcb5e171",
    order_by="-modifiedDate",
    page=1,
    page_size=100,
    query="corrupti",
)
    
res = s.account_balances.list_account_balances(req)

if res.account_balances is not None:
    # handle response
```
<!-- End SDK Example Usage -->

<!-- Start SDK Available Operations -->
## Available Resources and Operations


### account_balances

* `list_account_balances` - List account balances

### accounts

* `get_account` - Get account
* `list_accounts` - List accounts

### transaction_categories

* `get_transaction_category` - Get transaction category
* `list_transaction_categories` - List all transaction categories

### transactions

* `get_transaction` - Get bank transaction
* `list_bank_transactions` - List banking transactions
* `list_transactions` - List transactions
<!-- End SDK Available Operations -->

### SDK Generated by [Speakeasy](https://docs.speakeasyapi.dev/docs/using-speakeasy/client-sdks)
