class GeneralChineseToPinyin:

    def __init__(self, *args, **kwargs):
        super(GeneralChineseToPinyin, self).__init__(*args, **kwargs)

    def single_get_first(self, unicode1):
        str1 = unicode1.encode('gbk')
        try:
            ord(str1)
            return str1.decode('gbk')
        except:
            asc = str1[0] * 256 + str1[1] - 65536
            if asc >= -20319 and asc <= -20284:
                return 'a'
            if asc >= -20283 and asc <= -19776:
                return 'b'
            if asc >= -19775 and asc <= -19219:
                return 'c'
            if asc >= -19218 and asc <= -18711:
                return 'd'
            if asc >= -18710 and asc <= -18527:
                return 'e'
            if asc >= -18526 and asc <= -18240:
                return 'f'
            if asc >= -18239 and asc <= -17923:
                return 'g'
            if asc >= -17922 and asc <= -17418:
                return 'h'
            if asc >= -17417 and asc <= -16475:
                return 'j'
            if asc >= -16474 and asc <= -16213:
                return 'k'
            if asc >= -16212 and asc <= -15641:
                return 'l'
            if asc >= -15640 and asc <= -15166:
                return 'm'
            if asc >= -15165 and asc <= -14923:
                return 'n'
            if asc >= -14922 and asc <= -14915:
                return 'o'
            if asc >= -14914 and asc <= -14631:
                return 'p'
            if asc >= -14630 and asc <= -14150:
                return 'q'
            if asc >= -14149 and asc <= -14091:
                return 'r'
            if asc >= -14090 and asc <= -13119:
                return 's'
            if asc >= -13118 and asc <= -12839:
                return 't'
            if asc >= -12838 and asc <= -12557:
                return 'w'
            if asc >= -12556 and asc <= -11848:
                return 'x'
            if asc >= -11847 and asc <= -11056:
                return 'y'
            if asc >= -11055 and asc <= -10247:
                return 'z'
            return ''

    def get_pinyin(self, chinese_string: str) -> str:
        """
        输入中文字符串返回拼音的首字母字符串
        :param chinese_string: str
        :return: str
        """
        if chinese_string:
            lst = list(chinese_string)
            charLst = []
            for l in lst:
                charLst.append(self.single_get_first(l))
            return ''.join(charLst)
        return ''


if __name__ == '__main__':
    print(GeneralChineseToPinyin().get_pinyin('中国外汇交易中心'))
