import click
from halo import Halo

from .. import convert_to_json, Services


@click.command(context_settings=dict(max_content_width=200))
@click.argument("path", type=click.Path(exists=True))
@click.option("-w", "--workers", default=6, show_default=True, help="amount of workers")
@click.pass_context
def to_json(ctx, path, workers):
    """ Convert invoices to ocr json output """
    # Services available
    spinner = Halo(spinner="dots")
    spinner.start()
    Services(ctx)
    spinner.succeed(f"Found dir: {path}\n ")

    endpoints = ctx.obj["config"]["endpoints"]

    # Conversion
    convert_to_json(path, endpoints["extractor"], ctx.obj["token"], workers)
    spinner.succeed("Converted invoice(s) to ocr json output.")
