"""This module was autogenerated from sharepoint list schema.
Please be careful modifying the contents."""

from datetime import datetime
from enum import Enum, EnumMeta
from typing import Optional

from pydantic import BaseModel, Extra, Field


class OptionalEnumMeta(EnumMeta):
    """Return None if constructing from a value not in members."""

    def __call__(cls, value, *args, **kw):
        """Return none if value not in members. Else return enum."""
        if value in [m.value for m in cls.__members__.values()]:
            return super().__call__(value, *args, **kw)
        else:
            return None


class Burr1Hemisphere(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr1Hemisphere"""

    LEFT = "Left"
    RIGHT = "Right"
    SELECT = "Select..."


class Burr1InjectionDevice(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr1InjectionDevice"""

    IONTO_1 = "Ionto #1"
    IONTO_2 = "Ionto #2"
    IONTO_3 = "Ionto #3"
    IONTO_4 = "Ionto #4"
    IONTO_5 = "Ionto #5"
    IONTO_6 = "Ionto #6"
    IONTO_7 = "Ionto #7"
    IONTO_8 = "Ionto #8"
    IONTO_9 = "Ionto #9"
    NANO_1 = "Nano #1"
    NANO_2 = "Nano #2"
    NANO_3 = "Nano #3"
    NANO_4 = "Nano #4"
    NANO_5 = "Nano #5"
    NANO_6 = "Nano #6"
    NANO_7 = "Nano #7"
    NANO_8 = "Nano #8"
    NANO_9 = "Nano #9"
    SELECT = "Select..."


class Burr1PerformDuring(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr1PerformDuring"""

    FOLLOW_UP_SURGERY = "Follow up Surgery"
    INITIAL_SURGERY = "Initial Surgery"


class Burr1Status(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr1Status"""

    COMPLETE = "Complete"


class Burr1VirusBiosafteyLevelBsl(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr1VirusBiosafteyLevelBsl"""

    BSL_1_AAV = "BSL 1 - AAV"
    BSL_1_AAV_BEADS = "BSL 1 - AAV + Beads"
    BSL_1_BEADS = "BSL 1 - Beads"
    BSL_1_OTHER_WRITE_IN_COMM = "BSL 1 - Other (Write in comments)"
    BSL_2_6OHDA = "BSL 2 - 6-OHDA"
    BSL_2_CAV = "BSL 2 - CAV"
    BSL_2_CHOLERA_TOXIN_B = "BSL 2 - Cholera Toxin B"
    BSL_2_HSV1 = "BSL 2 - HSV-1"
    BSL_2_LENTI = "BSL 2 - Lenti"
    BSL_2_OTHER_WRITE_IN_COMM = "BSL 2 - Other (Write in comments)"
    BSL_2_RABIES = "BSL 2 - Rabies"
    BSL_2_SINDBIS = "BSL 2 - Sindbis"
    SELECT = "Select..."


class Burr2Hemisphere(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr2Hemisphere"""

    LEFT = "Left"
    RIGHT = "Right"
    SELECT = "Select..."


class Burr2InjectionDevice(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr2InjectionDevice"""

    IONTO_1 = "Ionto #1"
    IONTO_2 = "Ionto #2"
    IONTO_3 = "Ionto #3"
    IONTO_4 = "Ionto #4"
    IONTO_5 = "Ionto #5"
    IONTO_6 = "Ionto #6"
    IONTO_7 = "Ionto #7"
    IONTO_8 = "Ionto #8"
    IONTO_9 = "Ionto #9"
    NANO_1 = "Nano #1"
    NANO_2 = "Nano #2"
    NANO_3 = "Nano #3"
    NANO_4 = "Nano #4"
    NANO_5 = "Nano #5"
    NANO_6 = "Nano #6"
    NANO_7 = "Nano #7"
    NANO_8 = "Nano #8"
    NANO_9 = "Nano #9"
    SELECT = "Select..."


class Burr2PerformDuring(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr2PerformDuring"""

    FOLLOW_UP_SURGERY = "Follow up Surgery"
    INITIAL_SURGERY = "Initial Surgery"


class Burr2Status(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr2Status"""

    COMPLETE = "Complete"


class Burr2VirusBiosafteyLevelBsl(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr2VirusBiosafteyLevelBsl"""

    BSL_1_AAV = "BSL 1 - AAV"
    BSL_1_AAV_BEADS = "BSL 1 - AAV + Beads"
    BSL_1_BEADS = "BSL 1 - Beads"
    BSL_1_OTHER_WRITE_IN_COMM = "BSL 1 - Other (Write in comments)"
    BSL_2_6OHDA = "BSL 2 - 6-OHDA"
    BSL_2_CAV = "BSL 2 - CAV"
    BSL_2_CHOLERA_TOXIN_B = "BSL 2 - Cholera Toxin B"
    BSL_2_HSV1 = "BSL 2 - HSV-1"
    BSL_2_LENTI = "BSL 2 - Lenti"
    BSL_2_OTHER_WRITE_IN_COMM = "BSL 2 - Other (Write in comments)"
    BSL_2_RABIES = "BSL 2 - Rabies"
    BSL_2_SINDBIS = "BSL 2 - Sindbis"
    SELECT = "Select..."


class Burr3Hemisphere(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr3Hemisphere"""

    LEFT = "Left"
    RIGHT = "Right"
    SELECT = "Select..."


class Burr3InjectionDevice(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr3InjectionDevice"""

    IONTO_1 = "Ionto #1"
    IONTO_2 = "Ionto #2"
    IONTO_3 = "Ionto #3"
    IONTO_4 = "Ionto #4"
    IONTO_5 = "Ionto #5"
    IONTO_6 = "Ionto #6"
    IONTO_7 = "Ionto #7"
    IONTO_8 = "Ionto #8"
    IONTO_9 = "Ionto #9"
    NANO_1 = "Nano #1"
    NANO_2 = "Nano #2"
    NANO_3 = "Nano #3"
    NANO_4 = "Nano #4"
    NANO_5 = "Nano #5"
    NANO_6 = "Nano #6"
    NANO_7 = "Nano #7"
    NANO_8 = "Nano #8"
    NANO_9 = "Nano #9"
    SELECT = "Select..."


class Burr3PerformDuring(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr3PerformDuring"""

    FOLLOW_UP_SURGERY = "Follow up Surgery"
    INITIAL_SURGERY = "Initial Surgery"


class Burr3Status(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr3Status"""

    COMPLETE = "Complete"


class Burr3VirusBiosafetyLevelBsl(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr3VirusBiosafetyLevelBsl"""

    BSL_1_AAV = "BSL 1 - AAV"
    BSL_1_AAV_BEADS = "BSL 1 - AAV + Beads"
    BSL_1_BEADS = "BSL 1 - Beads"
    BSL_1_OTHER_WRITE_IN_COMM = "BSL 1 - Other (Write in comments)"
    BSL_2_6OHDA = "BSL 2 - 6-OHDA"
    BSL_2_CAV = "BSL 2 - CAV"
    BSL_2_CHOLERA_TOXIN_B = "BSL 2 - Cholera Toxin B"
    BSL_2_HSV1 = "BSL 2 - HSV-1"
    BSL_2_LENTI = "BSL 2 - Lenti"
    BSL_2_OTHER_WRITE_IN_COMM = "BSL 2 - Other (Write in comments)"
    BSL_2_RABIES = "BSL 2 - Rabies"
    BSL_2_SINDBIS = "BSL 2 - Sindbis"
    SELECT = "Select..."


class Burr4Hemisphere(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr4Hemisphere"""

    LEFT = "Left"
    RIGHT = "Right"
    SELECT = "Select..."


class Burr4InjectionDevice(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr4InjectionDevice"""

    IONTO_1 = "Ionto #1"
    IONTO_2 = "Ionto #2"
    IONTO_3 = "Ionto #3"
    IONTO_4 = "Ionto #4"
    IONTO_5 = "Ionto #5"
    IONTO_6 = "Ionto #6"
    IONTO_7 = "Ionto #7"
    IONTO_8 = "Ionto #8"
    IONTO_9 = "Ionto #9"
    NANO_1 = "Nano #1"
    NANO_2 = "Nano #2"
    NANO_3 = "Nano #3"
    NANO_4 = "Nano #4"
    NANO_5 = "Nano #5"
    NANO_6 = "Nano #6"
    NANO_7 = "Nano #7"
    NANO_8 = "Nano #8"
    NANO_9 = "Nano #9"
    SELECT = "Select..."


class Burr4PerformDuring(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr4PerformDuring"""

    FOLLOW_UP_SURGERY = "Follow up Surgery"
    INITIAL_SURGERY = "Initial Surgery"


class Burr4Status(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr4Status"""

    COMPLETE = "Complete"


class Burr4VirusBiosafteyLevelBsl(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Burr4VirusBiosafteyLevelBsl"""

    BSL_1_AAV = "BSL 1 - AAV"
    BSL_1_AAV_BEADS = "BSL 1 - AAV + Beads"
    BSL_1_BEADS = "BSL 1 - Beads"
    BSL_1_OTHER_WRITE_IN_COMM = "BSL 1 - Other (Write in comments)"
    BSL_2_6OHDA = "BSL 2 - 6-OHDA"
    BSL_2_CAV = "BSL 2 - CAV"
    BSL_2_CHOLERA_TOXIN_B = "BSL 2 - Cholera Toxin B"
    BSL_2_HSV1 = "BSL 2 - HSV-1"
    BSL_2_LENTI = "BSL 2 - Lenti"
    BSL_2_OTHER_WRITE_IN_COMM = "BSL 2 - Other (Write in comments)"
    BSL_2_RABIES = "BSL 2 - Rabies"
    BSL_2_SINDBIS = "BSL 2 - Sindbis"
    SELECT = "Select..."


class BurrHole1(Enum, metaclass=OptionalEnumMeta):
    """Enum class for BurrHole1"""

    FIBER_IMPLANT = "Fiber Implant"
    INJECTION = "Injection"
    INJECTION_FIBER_IMPLANT = "Injection & Fiber Implant"
    SELECT = "Select..."


class BurrHole2(Enum, metaclass=OptionalEnumMeta):
    """Enum class for BurrHole2"""

    FIBER_IMPLANT = "Fiber Implant"
    INJECTION = "Injection"
    INJECTION_FIBER_IMPLANT = "Injection & Fiber Implant"
    SELECT = "Select..."


class BurrHole3(Enum, metaclass=OptionalEnumMeta):
    """Enum class for BurrHole3"""

    FIBER_IMPLANT = "Fiber Implant"
    INJECTION = "Injection"
    INJECTION_FIBER_IMPLANT = "Injection & Fiber Implant"
    SELECT = "Select..."


class BurrHole4(Enum, metaclass=OptionalEnumMeta):
    """Enum class for BurrHole4"""

    FIBER_IMPLANT = "Fiber Implant"
    INJECTION = "Injection"
    INJECTION_FIBER_IMPLANT = "Injection & Fiber Implant"
    SELECT = "Select..."


class Contusion(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Contusion"""

    MILD = "Mild"
    MODERATE = "Moderate"
    NA = "N/A"
    NONE = "None"
    SELECT = "Select..."
    SEVERE = "Severe"


class CraniotomyPerformDuring(Enum, metaclass=OptionalEnumMeta):
    """Enum class for CraniotomyPerformDuring"""

    FOLLOW_UP_SURGERY = "Follow up Surgery"
    INITIAL_SURGERY = "Initial Surgery"


class CraniotomyType(Enum, metaclass=OptionalEnumMeta):
    """Enum class for CraniotomyType"""

    N_3MM = "3mm"
    N_5MM = "5mm"
    SELECT = "Select..."
    WHC = "WHC"


class Durotomy(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Durotomy"""

    COMPLETE = "Complete"
    NA = "N/A"
    NO = "No"
    PARTIAL = "Partial"
    SELECT = "Select..."
    TORN_COMPLETE = "Torn & Complete"
    UNINTENTIONAL = "Unintentional"


class EdemaSwelling(Enum, metaclass=OptionalEnumMeta):
    """Enum class for EdemaSwelling"""

    MILD = "Mild"
    MODERATE = "Moderate"
    NA = "N/A"
    NONE = "None"
    SELECT = "Select..."
    SEVERE = "Severe"


class FiberImplant1Length(Enum, metaclass=OptionalEnumMeta):
    """Enum class for FiberImplant1Length"""

    N_20_MM = "2.0 mm"
    N_25_MM = "2.5 mm"
    N_30_MM = "3.0 mm"
    N_35_MM = "3.5 mm"
    N_40_MM = "4.0 mm"
    N_45_MM = "4.5 mm"
    N_50_MM = "5.0 mm"
    SELECT = "Select..."


class FiberImplant2Length(Enum, metaclass=OptionalEnumMeta):
    """Enum class for FiberImplant2Length"""

    N_20_MM = "2.0 mm"
    N_25_MM = "2.5 mm"
    N_30_MM = "3.0 mm"
    N_35_MM = "3.5 mm"
    N_40_MM = "4.0 mm"
    N_45_MM = "4.5 mm"
    N_50_MM = "5.0 mm"
    SELECT = "Select..."


class FiberImplant3Length(Enum, metaclass=OptionalEnumMeta):
    """Enum class for FiberImplant3Length"""

    N_20_MM = "2.0 mm"
    N_25_MM = "2.5 mm"
    N_30_MM = "3.0 mm"
    N_35_MM = "3.5 mm"
    N_40_MM = "4.0 mm"
    N_45_MM = "4.5 mm"
    N_50_MM = "5.0 mm"
    SELECT = "Select..."


class FiberImplant4Length(Enum, metaclass=OptionalEnumMeta):
    """Enum class for FiberImplant4Length"""

    N_20_MM = "2.0 mm"
    N_25_MM = "2.5 mm"
    N_30_MM = "3.0 mm"
    N_35_MM = "3.5 mm"
    N_40_MM = "4.0 mm"
    N_45_MM = "4.5 mm"
    N_50_MM = "5.0 mm"
    SELECT = "Select..."


class FollowUpNanojectNumber(Enum, metaclass=OptionalEnumMeta):
    """Enum class for FollowUpNanojectNumber"""

    NA = "N/A"
    NJ1 = "NJ#1"
    NJ2 = "NJ#2"
    NJ3 = "NJ#3"
    NJ4 = "NJ#4"
    NJ5 = "NJ#5"
    NJ6 = "NJ#6"
    NJ7 = "NJ#7"
    NJ8 = "NJ#8"
    SELECT = "Select..."


class FollowUpWorkstation(Enum, metaclass=OptionalEnumMeta):
    """Enum class for FollowUpWorkstation"""

    SELECT = "Select..."
    SWS_1 = "SWS 1"
    SWS_2 = "SWS 2"
    SWS_3 = "SWS 3"
    SWS_4 = "SWS 4"
    SWS_5 = "SWS 5"
    SWS_6 = "SWS 6"
    SWS_7 = "SWS 7"
    SWS_8 = "SWS 8"
    SWS_9 = "SWS 9"


class FolowUpIontoNumber(Enum, metaclass=OptionalEnumMeta):
    """Enum class for FolowUpIontoNumber"""

    IONTO_1 = "Ionto #1"
    IONTO_10 = "Ionto #10"
    IONTO_2 = "Ionto #2"
    IONTO_3 = "Ionto #3"
    IONTO_4 = "Ionto #4"
    IONTO_5 = "Ionto #5"
    IONTO_6 = "Ionto #6"
    IONTO_7 = "Ionto #7"
    IONTO_8 = "Ionto #8"
    IONTO_9 = "Ionto #9"
    NA = "N/A"
    SELECT = "Select..."


class Headpost(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Headpost"""

    AI_STRAIGHT_BAR = "AI Straight bar"
    FRONTAL_CTX = "Frontal Ctx"
    MOTOR_CTX = "Motor Ctx"
    OTHER_ADD_DETAILS_IN_REQU = "Other (add details in requestor comments)"
    SELECT = "Select..."
    VISUAL_CTX = "Visual Ctx"
    WHC_2_P = "WHC 2P"
    WHC_NP = "WHC NP"


class HeadpostPerformDuring(Enum, metaclass=OptionalEnumMeta):
    """Enum class for HeadpostPerformDuring"""

    FOLLOW_UP_SURGERY = "Follow up Surgery"
    INITIAL_SURGERY = "Initial Surgery"


class Hematoma(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Hematoma"""

    MILD = "Mild"
    MODERATE = "Moderate"
    NA = "N/A"
    NONE = "None"
    SELECT = "Select..."
    SEVERE = "Severe"


class IacucProtocol(Enum, metaclass=OptionalEnumMeta):
    """Enum class for IacucProtocol"""

    N_1906 = "1906"
    N_2001 = "2001"
    N_2003 = "2003"
    N_2004 = "2004"
    N_2005 = "2005"
    N_2006 = "2006"
    N_2011 = "2011"
    N_2102 = "2102"
    N_2103 = "2103"
    N_2104 = "2104"
    N_2105 = "2105"
    N_2106 = "2106"
    N_2107 = "2107"
    N_2108 = "2108"
    N_2109 = "2109"
    N_2110 = "2110"
    N_2113 = "2113"
    N_2115 = "2115"
    N_2117 = "2117"
    N_2201 = "2201"
    N_2202 = "2202"
    N_2205 = "2205"
    N_2212 = "2212"
    N_2301 = "2301"
    SELECT = "Select..."


class ImplantIdCoverslipType(Enum, metaclass=OptionalEnumMeta):
    """Enum class for ImplantIdCoverslipType"""

    N_2001 = "2001"
    N_2002 = "2002"
    N_3001 = "3001"
    N_3002 = "3002"
    N_3MM = "3mm"
    N_3MM_STACKED_COVERSLIP = "3mm stacked coverslip"
    N_5MM_STACKED_COVERSLIP = "5mm stacked coverslip"
    N_5MM_STACKED_COVERSLIP_W = (
        "5mm stacked coverslip (with silicone coating for Neuropixel)"
    )
    SELECT = "Select..."


class InitialIontoNumber(Enum, metaclass=OptionalEnumMeta):
    """Enum class for InitialIontoNumber"""

    IONTO_1 = "Ionto #1"
    IONTO_10 = "Ionto #10"
    IONTO_2 = "Ionto #2"
    IONTO_3 = "Ionto #3"
    IONTO_4 = "Ionto #4"
    IONTO_5 = "Ionto #5"
    IONTO_6 = "Ionto #6"
    IONTO_7 = "Ionto #7"
    IONTO_8 = "Ionto #8"
    IONTO_9 = "Ionto #9"
    NA = "N/A"
    SELECT = "Select..."


class InitialNanojectNumber(Enum, metaclass=OptionalEnumMeta):
    """Enum class for InitialNanojectNumber"""

    NA = "N/A"
    NJ1 = "NJ#1"
    NJ2 = "NJ#2"
    NJ3 = "NJ#3"
    NJ4 = "NJ#4"
    NJ5 = "NJ#5"
    NJ6 = "NJ#6"
    NJ7 = "NJ#7"
    NJ8 = "NJ#8"
    SELECT = "Select..."


class InitialWorkStation(Enum, metaclass=OptionalEnumMeta):
    """Enum class for InitialWorkStation"""

    SELECT = "Select..."
    SWS_1 = "SWS 1"
    SWS_2 = "SWS 2"
    SWS_3 = "SWS 3"
    SWS_4 = "SWS 4"
    SWS_5 = "SWS 5"
    SWS_6 = "SWS 6"
    SWS_7 = "SWS 7"
    SWS_8 = "SWS 8"
    SWS_9 = "SWS 9"


class Inj1Retsetting(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj1Retsetting"""

    OFF = "Off"
    ON = "On"


class Inj1Type(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj1Type"""

    IONTOPHORESIS = "Iontophoresis"
    NANOJECT_PRESSURE = "Nanoject (Pressure)"
    SELECT = "Select..."


class Inj2Retsetting(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj2Retsetting"""

    OFF = "Off"
    ON = "On"


class Inj2Type(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj2Type"""

    IONTOPHORESIS = "Iontophoresis"
    NANOJECT_PRESSURE = "Nanoject (Pressure)"
    SELECT = "Select..."


class Inj3Retsetting(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj3Retsetting"""

    OFF = "Off"
    ON = "On"


class Inj3Type(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj3Type"""

    IONTOPHORESIS = "Iontophoresis"
    NANOJECT_PRESSURE = "Nanoject (Pressure)"
    SELECT = "Select..."


class Inj4Retsetting(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj4Retsetting"""

    OFF = "Off"
    ON = "On"


class Inj4Type(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj4Type"""

    IONTOPHORESIS = "Iontophoresis"
    NANOJECT_PRESSURE = "Nanoject (Pressure)"
    SELECT = "Select..."


class Laceration(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Laceration"""

    MILD = "Mild"
    MODERATE = "Moderate"
    NA = "N/A"
    NONE = "None"
    SELECT = "Select..."
    SEVERE = "Severe"


class Lightcycle(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Lightcycle"""

    REVERSE_LIGHT_CYCLE_9PM_T = "Reverse Light Cycle (9pm to 9am light)"
    STANDARD_LIGHT_CYCLE_6AM = "Standard Light Cycle (6am to 8pm light)"


class LimsRequired(Enum, metaclass=OptionalEnumMeta):
    """Enum class for LimsRequired"""

    NO = "No"
    SELECT = "Select..."
    YES = "Yes"


class Limsproject(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Limsproject"""

    AINDDISCOVERY = "aind-discovery"
    AINDEPHYS = "aind-ephys"
    AINDMSMA = "aind-msma"
    AINDOPHYS = "aind-ophys"
    APR_OX = "APROx"
    A_XL_OX = "AXlOx"
    BRAINTV_VIRAL_STRATEGIES = "BraintvViralStrategies"
    BRAIN_STIM = "BrainStim"
    C200 = "C200"
    C600 = "C600"
    C600X = "C600x"
    C600_LATERAL = "C600Lateral"
    CELLTYPES_TRANSGENIC_CHAR = "CelltypesTransgenicCharacterizationGCaMP"
    CITRICACIDPILOT = "Citricacidpilot"
    CON9999 = "CON-9999"
    CONC505 = "CON-C505"
    CONCS04 = "CON-CS04"
    DEEPSCOPE_SLM_DEVELOPMENT = "DeepscopeSLMDevelopment"
    DYNAMIC_ROUTING_BEHAVIOR = "DynamicRoutingBehaviorDev"
    DYNAMIC_ROUTING_SURGICAL = "DynamicRoutingSurgicalDevelopment"
    DYNAMIC_ROUTING_TASK1_PRO = "DynamicRoutingTask1Production"
    DYNAMIC_ROUTING_TASK2_PRO = "DynamicRoutingTask2Production"
    DYNAMIC_ROUTING_ULTRA_OPT = "DynamicRoutingUltraOptotaggingBehavior"
    H120 = "H120"
    H200 = "H200"
    H301 = "H301"
    H301T = "H301t"
    H301_X = "H301X"
    H501_X = "H501X"
    H504 = "H504"
    IS_IX = "ISIx"
    LARGE_SCALE_VOLTAGE = "LargeScaleVoltage"
    LEARNINGM_FISH_DEVELOPMEN = "LearningmFISHDevelopment"
    LEARNINGM_FISH_TASK1_A = "LearningmFISHTask1A"
    M301T = "M301t"
    MESOSCOPE_DEVELOPMENT = "MesoscopeDevelopment"
    MINDSCOPE_TRANSGENIC_CHAR = "MindscopeTransgenicCharacterizationGCaMP"
    MOUSE_BRAIN_CELL_ATLAS_CH = "MouseBrainCellAtlasCharacterizationPilot"
    MOUSE_BRAIN_CELL_ATLAS_TR = "MouseBrainCellAtlasTranssynaptic"
    MOUSE_BRAIN_CELL_ATLA_001 = "MouseBrainCellAtlasCharacterizatlon"
    MOUSE_FULL_MORPHOLOGY_FMO = "MouseFullMorphologyFmost"
    MOUSE_GENETIC_TOOLS_PROJE = "MouseGeneticToolsProjectionMapping"
    MULTISCOPE_SIGNAL_NOISE = "MultiscopeSignalNoise"
    M_FISH_PLATFORM_DEVELOPME = "mFishPlatformDevelopment"
    M_IVSCCMET = "mIVSCC-MET"
    M_IVSCCME_TX = "mIVSCC-METx"
    M_MPATC_HX = "mMPATCHx"
    M_M_PATCHX = "mMPatchx"
    M_VISPTAXLO = "MVisp-taxl.o"
    N200 = "N200"
    N310 = "N310"
    NEUROPIXEL_VISUAL_BEHAVIO = "NeuropixelVisualBehavior"
    NEUROPIXEL_VISUAL_BEH_001 = "NeuropixelVisualBehaviorDevelopment"
    NEUROPIXEL_VISUAL_CODING = "NeuropixelVisualCoding"
    N_0200 = "0200"
    N_0309 = "0309"
    N_0310 = "0310"
    N_0311 = "0311"
    N_0312 = "0312"
    N_0314 = "0314"
    N_0316 = "0316"
    N_0319 = "0319"
    N_0320 = "0320"
    N_0321 = "0321"
    N_03212 = "03212"
    N_03213 = "03213"
    N_03214 = "03214"
    N_0322 = "0322"
    N_0324 = "0324"
    N_0325 = "0325"
    N_0326 = "0326"
    N_0327 = "0327"
    N_03272 = "03272"
    N_0328 = "0328"
    N_0329 = "0329"
    N_0331 = "0331"
    N_0334 = "0334"
    N_03342 = "03342"
    N_0335 = "0335"
    N_0336 = "0336"
    N_0338 = "0338"
    N_0339 = "0339"
    N_03392 = "03392"
    N_0340 = "0340"
    N_0342 = "0342"
    N_03422 = "03422"
    N_0343 = "0343"
    N_0344 = "0344"
    N_0345 = "0345"
    N_0346 = "0346"
    N_0350 = "0350"
    N_0350X = "0350x"
    N_0351 = "0351"
    N_0351X = "0351x"
    N_0354 = "0354"
    N_0355 = "0355"
    N_0357 = "0357"
    N_0358 = "0358"
    N_0359 = "0359"
    N_0360 = "0360"
    N_03602 = "03602"
    N_0362 = "0362"
    N_0363 = "0363"
    N_0364 = "0364"
    N_0365 = "0365"
    N_0365X = "0365x"
    N_0366 = "0366"
    N_0366X = "0366x"
    N_0367 = "0367"
    N_0369 = "0369"
    N_0371 = "0371"
    N_0372 = "0372"
    N_0372X = "0372x"
    N_0374 = "0374"
    N_0376 = "0376"
    N_0376A = "0376a"
    N_0376X = "0376x"
    N_0378 = "0378"
    N_0378X = "0378x"
    N_0380 = "0380"
    N_0384 = "0384"
    N_0386 = "0386"
    N_0388 = "0388"
    OLVSX = "OLVSX"
    OM_FISHRO_BINJECTIONVIRUS = "omFISHROBinjectionviruspilot"
    OM_FISH_CUX2_MESO = "omFISHCux2Meso"
    OM_FISH_GAD2_MESO = "omFISHGad2Meso"
    OM_FISH_GAD2_PILOT = "omFISHGad2Pilot"
    OM_FISH_RBP4_MESO = "omFISHRbp4Meso"
    OM_FISH_RORB_PILOT = "omFISHRorbPilot"
    OM_FISH_SST_MESO = "omFISHSstMeso"
    OM_FIS_HCOREGISTRATIONPIL = "omFISHcoregistrationpilot"
    OPENSCOPELNJECTION_PILOT = "OpenscopelnjectionPilot"
    OPENSCOPE_DEVELOPMENT = "OpenscopeDevelopment"
    OPENSCOPE_GAMMA_PILOT = "OpenscopeGammaPilot"
    OPENSCOPE_GAMMA_PRODUCTLO = "OpenscopeGammaProductlon"
    OPENSCOPE_MOTION_PLLOT = "OpenscopeMotionPllot"
    OPENSCOPE_MOTION_PRODUCTI = "OpenscopeMotionProduction"
    OPENSCOPE_MULTIPLEX_PILOT = "OpenscopeMultiplexPilot"
    OPENSCOPE_MULTIPLEX_PRODU = "OpenscopeMultiplexProduction"
    OPEN_SCOPE_DENDRITE_COUPL = "OpenScopeDendriteCoupling"
    OPEN_SCOPE_GLOBAL_LOCAL_O = "OpenScopeGlobalLocalOddball"
    OPEN_SCOPE_ILLUSION = "OpenScopeIllusion"
    OPEN_SCOPE_SEQUENCE_LEARN = "OpenScopeSequenceLearning"
    OPEN_SCOPE_TEMPORAL_BARCO = "OpenScopeTemporalBarcode"
    OPEN_SCOPE_VISION2_HIPPOC = "OpenScopeVision2Hippocampus"
    OPH5_X = "OPH5X"
    S200_C = "S200C"
    SMART_SPIM_GENETIC_TOOLS = "SmartSPIM_GeneticTools"
    SURGERY_X = "SurgeryX"
    T301 = "T301"
    T301T = "T301t"
    T301_X = "T301X"
    T503 = "T503"
    T503_X = "T503X"
    T504 = "T504"
    T504_X = "T504X"
    T600 = "T600"
    T601 = "T601"
    T601_X = "T601X"
    TASK_TRAINED_NETWORKS_MUL = "TaskTrainedNetworksMultiscope"
    TASK_TRAINED_NETWORKS_NEU = "TaskTrainedNetworksNeuropixel"
    TCYTX = "TCYTX"
    TEMPLETON_PSYCHEDELICS = "TempletonPsychedelics"
    TEMPLETON_TTOC = "Templeton TTOC"
    TINY_BLUE_DOT_BEHAVIOR = "TinyBlueDotBehavior"
    U01_BFCT = "U01BFCT"
    VARIABILITY_AIM1 = "VariabilityAim1"
    VARIABILITY_AIM1_PILOT = "VariabilityAim1Pilot"
    VARIABILITY_SPONTANEOUS = "VariabilitySpontaneous"
    VIP_AXONAL_V1_PHASE1 = "VipAxonalV1Phase1"
    VIP_SOMATIC_V1_MESO = "VIPSomaticV1Meso"
    VIP_SOMATIC_V1_PHASE1 = "VipSomaticV1Phase1"
    VIP_SOMATIC_V1_PHASE2 = "VipSomaticV1Phase2"
    VISUAL_BEHAVIOR = "VisualBehavior"
    VISUAL_BEHAVIOR_DEVELOPME = "VisualBehaviorDevelopment"
    VISUAL_BEHAVIOR_MULTISCOP = "VisualBehaviorMultiscope"
    VISUAL_BEHAVIOR_MULTI_001 = "VisualBehaviorMultiscope4areasx2d"
    VISUAL_BEHAVIOR_TASK1_B = "VisualBehaviorTask1B"
    VISUAL_BEHAV_IOR_MULTISCO = "VisualBehavIorMultiscopeTask1G"
    VI_DEEPDLVE_DEEPSCOPE_PIE = "VIDeepdlveDeepscopePiezo"
    VI_DEEP_DIVE_EM_VOLUME = "VIDeepDiveEMVolume"


class Limstaskflow(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Limstaskflow"""

    AIND_EPHYS_PASSIVE_BEHAVI = "AIND Ephys (Passive Behavior)"
    AIND_EPHYS_SURGERY_ONLY = "AIND Ephys (Surgery only)"
    AIND_U19_AAV_RETROGRADE = "AIND U19 AAV Retrograde"
    AIND_U19_THALAMUS = "AIND U19 Thalamus"
    BRAIN_LARGE_SCALE_RECORDI = "BRAIN Large Scale Recording"
    BRAIN_MOUSE_BRAIN_CELL_AT = "BRAIN Mouse Brain Cell Atlas trans-synaptic"
    BRAIN_OBSERVATORY_DEEPSCO = "Brain Observatory Deepscope"
    BRAIN_OBSERVATORY_EPHYS_D = "Brain Observatory Ephys Dev"
    BRAIN_OBSERVATORY_MAPSCOP = "Brain Observatory Mapscope"
    BRAIN_OBSERVATORY_MESOSCO = "Brain Observatory Mesoscope"
    BRAIN_OBSERVATORY_MES_001 = "Brain Observatory Mesoscope 1G"
    BRAIN_OBSERVATORY_NEUROPI = "Brain Observatory Neuropixel Dev"
    BRAIN_OBSERVATORY_TRANSGE = "Brain Observatory Transgenic Characterization"
    BRAIN_OBSERVATORY_V1_DD = "Brain Observatory V1DD"
    BRAIN_OBSERVATORY_VISUAL = "Brain Observatory Visual Behavior"
    BRAIN_OBSERVATORY_VIS_001 = "Brain Observatory Visual Behavior 1B"
    BRAIN_OBSERVATORY_VIS_002 = "Brain Observatory Visual Behavior Neuropixel"
    BRAIN_OBSERVATORY_VIS_003 = "Brain Observatory Visual Coding"
    BTV_BRAIN_VIRAL_STRATEGIE = "BTV BRAIN Viral Strategies"
    CITRIC_ACID_PILOT = "Citric Acid Pilot"
    EPHYS_DEV_VISUAL_BEHAVIOR2 = "Ephys Dev Visual Behavior 2"
    EPHYS_DEV_VISUAL_BEHAVIOR = "Ephys Dev Visual Behavior"
    EPHYS_TASK_DEV_DYANMIC_RO = "Ephys Task Dev Dyanmic Routing (NSB Beh"
    EPHYS_TASK_DEV_DYNAMIC_RO = "Ephys Task Dev Dynamic Routing DOC Left Eye"
    EPHYS_TASK_DEV_DYNAMI_001 = "Ephys Task Dev Dynamic Routing (S/C Beh)"
    IVSCC_HVA_RETRO_PATCH_SEQ = "IVSCC HVA Retro PatchSeq"
    IVSC_CM_INJECTION = "IVSCCm injection"
    IVSP_CM_INJECTION = "IVSPCm Injection"
    MGT_LAB = "MGT Lab"
    MGT_TISSUE_CYTE = "MGT TissueCyte"
    MSP_DYNAMIC_ROUTING_BEHAV = "MSP Dynamic Routing Behavior Development"
    MSP_DYNAMIC_ROUTING_SURGI = "MSP Dynamic Routing Surgical Development"
    MSP_DYNAMIC_ROUTING_TASK = "MSP Dynamic Routing Task 1 Production"
    MSP_DYNAMIC_ROUTING_T_001 = "MSP Dynamic Routing Task 2 Production"
    MSP_DYNAMIC_ROUTING_ULTRA = (
        "MSP Dynamic Routing Ultra Optotagging Behavior"
    )
    MSP_LEARNING_M_FISH_DEVEL = "MSP Learning & mFISH Development"
    MSP_LEARNING_M_FISH_D_001 = "MSP Learning & mFISH Development (Dox)"
    MSP_LEARNING_M_FISH_FRONT = "MSP Learning & mFISH Frontal Window Dev"
    MSP_LEARNING_M_FISH_VIRUS = "MSP Learning & mFISH Virus Testing"
    MSP_OM_FISH_COREGISTRATIO = "MSP omFISH Co-registration Pilot"
    MSP_OM_FISH_CUX2_PILOT = "MSP omFISH Cux2 Pilot"
    MSP_OM_FISH_GAD2_PILOT = "MSP omFISH Gad2 Pilot"
    MSP_OM_FISH_RBP4_MESO = "MSP omFISH Rbp4 Meso"
    MSP_OM_FISH_ROB_INJECTION = "MSP omFISH ROB Injection Virus Pilot"
    MSP_OM_FISH_RORB_PILOT = "MSP omFISH Rorb Pilot"
    MSP_OM_FISH_SST_MESO_GAMM = "MSP omFISH Sst Meso (GammaStim)"
    MSP_OPEN_SCOPE_DENDRITE_C = "MSP OpenScope Dendrite Coupling"
    MSP_OPEN_SCOPE_GLOBAL_001 = (
        "MSP OpenScope Global Local Oddballs (Cohort 2)"
    )
    MSP_OPEN_SCOPE_GLOBAL_LOC = (
        "MSP OpenScope Global Local Oddballs (Cohort 1)"
    )
    MSP_OPEN_SCOPE_ILLUSION = "MSP OpenScope Illusion"
    MSP_TASK_TRAINED_NETWORKS = "MSP Task Trained Networks Multiscope"
    MSP_TASK_TRAINED_NETW_001 = "MSP Task Trained Networks Neuropixel"
    MSP_U01_BRIDGING_FUNCTION = (
        "MSP U01 Bridging Function, Connectivity, and Transcriptomics"
    )
    MSP_VARIABILITY_AIM_1 = "MSP Variability Aim 1"
    MSP_VARIABILITY_AIM_1_PIL = "MSP Variability Aim 1 Pilot"
    MSP_VARIABILITY_SPONTANEO = "MSP Variability Spontaneous"
    MSP_VIP_AXONAL_V1 = "MSP VIP Axonal V1"
    MSP_VIP_SOMATIC_V1 = "MSP VIP Somatic V1"
    OPENSCOPE_MOTION_PRODUCTI = "Openscope Motion Production"
    OPENSCOPE_VIRUS_VALIDATIO = "Openscope Virus Validation"
    OPEN_SCOPE_GAMMA_PILOT = "OpenScope_Gamma_Pilot"
    OPEN_SCOPE_GAMMA_PRODUCTI = "OpenScope_Gamma_Production"
    OPEN_SCOPE_LNJECTION_VOLU = "OpenScope_lnjection_Volume_Pilot"
    OPEN_SCOPE_MOTION_PILOT = "OpenScope_Motion_Pilot"
    OPEN_SCOPE_MULTIPLEX_PILO = "OpenScope_Multiplex_Pilot_Inj"
    OPEN_SCOPE_MULTIPLEX_PROD = "OpenScope_Multiplex_Production_NoInj"
    OPEN_SCOPE_MULTIPLEX__001 = "OpenScope_Multiplex_Pilot_Nolnj"
    OPEN_SCOPE_MULTLPLEX_PROD = "OpenScope_Multlplex_Production"
    OPEN_SCOPE_SEQUENCE_LEARN = "OpenScope Sequence Learning"
    OPEN_SCOPE_TEMPORAL_BARCO = "OpenScope Temporal Barcode"
    OPEN_SCOPE_TEMPORAL_B_001 = "OpenScope Temporal Barcode Testing"
    OPEN_SCOPE_VISION_2_HIPPO = "OpenScope Vision 2 Hippocampus"
    OPEN_SCOPE_WHC_2_P_DEV = "OpenScope WHC 2P Dev"
    TINY_BLUE_DOT_BEHAVIOR = "Tiny Blue Dot Behavior"
    TRANSGENIC_CHARACTERIZATI = "Transgenic Characterization (Passive)"
    VGT_ENHANCERS_TRANSSYNAPT = "VGT Enhancers Transsynaptic"
    VIS_B_DEV_CONTROL_GROUP = "VisB Dev Control Group"
    VIS_B_LATERAL_PREP_DEVELO = "VisB Lateral Prep Development"
    VIS_B_TASK_2_DEVELOPMENT = "VisB Task 2 Development"


class OfBurrHoles(Enum, metaclass=OptionalEnumMeta):
    """Enum class for OfBurrHoles"""

    N_1 = "1"
    N_2 = "2"
    N_3 = "3"
    N_4 = "4"
    SELECT = "Select..."


class PhysiologyType(Enum, metaclass=OptionalEnumMeta):
    """Enum class for PhysiologyType"""

    NA = "N/A"
    NP = "NP"
    N_2_P = "2P"
    SELECT = "Select..."


class Procedure(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Procedure"""

    CUSTOM = "Custom"
    FIBER_OPTIC_IMPLANT_WITH = "Fiber Optic Implant (with Headpost)"
    FRONTAL_CTX_2_P = "Frontal Ctx 2P"
    HP_ONLY = "HP Only"
    HP_TRANSCRANIAL = "HP Transcranial"
    INJECTION_FIBER_OPTIC_IMP = "Injection+Fiber Optic Implant (with Headpost)"
    INJ_MOTOR_CTX = "INJ + Motor Ctx"
    INJ_VISUAL_CTX_2_P = "INJ + Visual Ctx 2P"
    INJ_WHC_NP_1_INJECTION_LO = "INJ + WHC NP (1 Injection Location)"
    ISIGUIDED_INJECTION_WITH = "ISI-guided Injection (with Headpost)"
    MOTOR_CTX = "Motor Ctx"
    SELECT = "Select..."
    STEREOTAXIC_INJECTION = "Stereotaxic Injection"
    STEREOTAXIC_INJECTION_WIT = "Stereotaxic Injection (with Headpost)"
    VISUAL_CTX_2_P = "Visual Ctx 2P"
    VISUAL_CTX_NP = "Visual Ctx NP"
    WHC_NP = "WHC NP"


class ProcedureCategory(Enum, metaclass=OptionalEnumMeta):
    """Enum class for ProcedureCategory"""

    CRANIAL_WINDOW = "Cranial Window"
    CUSTOM = "Custom"
    FIBER_OPTIC_IMPLANT = "Fiber Optic Implant"
    HEADPOST_ONLY = "Headpost only"
    INJECTION = "Injection"
    SELECT = "Select..."
    TRAINING = "Training"


class ProcedureSlots(Enum, metaclass=OptionalEnumMeta):
    """Enum class for ProcedureSlots"""

    INITIAL_SURGERY_WITH_FOLL = "Initial surgery with follow up session"
    SELECT = "Select..."
    SINGLE_SURGICAL_SESSION = "Single surgical session"


class Projectid(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Projectid"""

    AAV_PRODUCTION_1028800410 = "AAV production 102-88-004-10"
    CVS_PRODUCTION_1028800410 = "CVS production 102-88-004-10"
    N_1010300110_COSTA_PGA_LA = "101-03-001-10 Costa PGA Lab Research (Direct)"
    N_1020100710_CTY_M_FISH = "102-01-007-10 CTY mFISH"
    N_1020100910_CTY_MORPHOLO = "102-01-009-10 CTY Morphology"
    N_1020101110_CTY_CONNECTO = "102-01-011-10 CTY Connectome EM"
    N_1020101210_CTY_CONNECTO = "102-01-012-10 CTY Connectome Meso"
    N_1020101610_CTY_TAXONOMY = "102-01-016-10 CTY Taxonomy"
    N_1020102720_CTY_BRAIN_AX = "102-01-027-20 CTY BRAIN Axonal Connectomics"
    N_1020102920_CTY_BRAIN_CE = (
        "102-01-029-20 CTY BRAIN Cell-type Specific Enhancer Viruses"
    )
    N_1020103120_W4_CTY_EU_HO = (
        "102-01-031-20 W4 - CTY EU Horizon 2020 BRAINTIME"
    )
    N_1020103120_W5_CTY_EU_HO = (
        "102-01-031-20 W5 - CTY EU Horizon 2020 BRAINTIME"
    )
    N_1020103220_CTY_MOUSE_AG = "102-01-032-20 CTY Mouse Aging"
    N_1020103620_CTY_DISSEMIN = (
        "102-01-036-20 CTY Dissemination of 3-Photon Imaging"
    )
    N_1020104020_CTY_BRAIN_UG = (
        "102-01-040-20 CTY BRAIN UG3/UH3 Genetic Viral Tools"
    )
    N_1020104320_CTY_OPTICAL = "102-01-043-20 CTY Optical interrogation"
    N_1020104410_CTY_GENOMICS = "102-01-044-10 – CTY Genomics"
    N_1020104510_CTY_IVSCC = "102-01-045-10 – CTY IVSCC"
    N_1020104620_CTY_WEILL_NE = (
        "102-01-046-20 - CTY Weill Neuronal Heterogeneity"
    )
    N_1020104810_CTY_BARCODED = "102-01-048-10 CTY Barcoded Connectomics"
    N_1020104920_CTY_OPIOID_T = "102-01-049-20 - CTY Opioid Transcriptomics"
    N_1020105520_CTY_EM_MOTOR = "102-01-055-20 CTY EM Motor Cortex"
    N_1020105720_CTY_BRAIN_BG = "102-01-057-20 CTY BRAIN BG AAV Toolbox"
    N_1020105920_CTY_SCORCH = "102-01-059-20 CTY SCORCH"
    N_1020106020_CTY_BRAIN_DR = "102-01-060-20 CTY Brain Drain"
    N_1020106220_CTY_BICAN_MO = (
        "102-01-062-20 CTY BICAN Mouse Developmental Atlas"
    )
    N_1020106410_CTY_GENETIC = "102-01-064-10 CTY Genetic Tools"
    N_1020106920_PRE_SPEND = "102-01-069-20 Pre-Spend"
    N_1020199910_CTY_PROGRAM = "102-01-999-10 CTY Program Admin"
    N_1020200410_BTV_VISUAL_B = "102-02-004-10 BTV Visual Behavior"
    N_1020201220_BTV_BRAIN_VI = "102-02-012-20 BTV BRAIN Viral Strategies"
    N_1020201620_MSP_BRAIN_MO = (
        "102-02-016-20 MSP BRAIN Models and methods for Ca Imaging"
    )
    N_1020201720_BTV_BRAIN_NE = "102-02-017-20 BTV BRAIN Neuropixels ULTRA"
    N_1020400410_OTH_MERITORI = (
        "102-04-004-10 OTH Meritorious Scholar Directed Research"
    )
    N_1020400620_OTH_MEASURIN = (
        "102-04-006-20 OTH Measuring Consciousness Ph2 (TBD)"
    )
    N_1020400710_APLD_TARGETE = "102-04-007-10 APLD Targeted CNS Gene Therapy"
    N_1020400910_CAPSID_SCREE = "102-04-009-10  Capsid Screening"
    N_1020400910_DRAVET_SYNDR = "102-04-009-10 Dravet Syndrome"
    N_1020401010_CTY_SR_SLC6 = "102-04-010-10 CTY SR: SLC6A1"
    N_1020401110_CTY_SR_SYNGA = "102-04-011-10 CTY SR: SYNGAP1"
    N_1020401210_CTY_SR_FRIED = "102-04-012-10 : CTY SR: Friedreich Ataxia"
    N_1020401410_CTY_PARKINSO = "102-04-014-10 CTY Parkinsons Disease"
    N_1028800310_ANIMAL_CARE = "102-88-003-10 Animal Care Team"
    N_1028800510_TRANSGENIC_C = "102-88-005-10 Transgenic Colony Management"
    N_1028800810_LAB_ANIMAL_S = "102-88-008-10 Lab Animal Services"
    N_1060100110_IMMUNOLOGY_D = "106-01-001-10 Immunology (Direct)"
    N_1210100110_MSP_DEEP_INT = "121-01-001-10 MSP Deep Interpolation"
    N_1210100210_MSP_BEHAVIOR = "121-01-002-10 MSP Behavioral Dynamics"
    N_1210100310_MSP_X_AREA_F = (
        "121-01-003-10 MSP X - Area Functional Interactions"
    )
    N_1210100410_MSP_VIP_REGU = (
        "121-01-004-10 MSP VIP Regulated Stabilized Network"
    )
    N_1210100510_MSP_SURROUND = "121-01-005-10 MSP Surround Structure Function"
    N_1210100610_MSP_AUTOMATI = (
        "121-01-006-10 MSP Automatically Optimized Model"
    )
    N_1210100710_MSP_TASK_TRA = "121-01-007-10 MSP Task Trained Networks"
    N_1210100810_MSP_NEURAL_E = "121-01-008-10 MSP Neural Ensemble Variability"
    N_1210100910_MSP_BIO_REAL = "121-01-009-10 MSP Bio-Realistic Modeling"
    N_1210101010_MSP_V1_OM_FI = "121-01-010-10 MSP V1 omFISH"
    N_1210101110_MSP_DYNAMIC = "121-01-011-10 MSP Dynamic Routing"
    N_1210101210_MSP_LEARNING = "121-01-012-10 MSP Learning mFISH"
    N_1210101420_MSP_BRAIN_MO = (
        "121-01-014-20 MSP BRAIN Model Structure Function"
    )
    N_1210101510_MSP_FALCONWO = "121-01-015-10 MSP Falconwood"
    N_1210101620_MSP_BRAIN_OP = "121-01-016-20 MSP BRAIN OpenScope"
    N_1210101820_MSP_EPHAPTIC = "121-01-018-20 MSP Ephaptic Cell Typ"
    N_1210102320_MSP_TEMPLETO = (
        "121-01-023-20 MSP Templeton - Testing Theories of Consciousness"
    )
    N_1210102520_MSP_U01_BRID = (
        "121-01-025-20 MSP U01 Bridging Function, Connectivity, & "
        "Transcriptomics"
    )
    N_1210102620_MSP_TEMPLETO = (
        "121-01-026-20 MSP Templeton Measuring Distinct Conscious State"
    )
    N_1210199910_MSP_CROSS_PR = "121-01-999-10 MSP Cross Program 10YP"
    N_1210199910_MSP_CROS_001 = "121-01-999-10 MSP Cross Program  Scientific"
    N_1220100110_AIND_SCIENTI = "122-01-001-10 AIND Scientific Activities"
    N_1220100220_MOLECULAR_CO = "122-01-002-20 Molecular Core"
    N_1220100220_PROJECT_1 = "122-01-002-20 Project 1"
    N_1220100220_PROJECT_2 = "122-01-002-20 Project 2"
    N_1220100220_PROJECT_4 = "122-01-002-20 Project 4"
    N_1220100420_AIND_BRAINST = "122-01-004-20 AIND Brainstem RF1"
    N_1229999910_NEURAL_DYNAM = "122-99-999-10 Neural Dynamics Admin (Direct)"
    RD_1028800410 = "R&D 102-88-004-10"


class Sex(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Sex"""

    FEMALE = "Female"
    MALE = "Male"
    SELECT = "Select..."


class SinusBleed(Enum, metaclass=OptionalEnumMeta):
    """Enum class for SinusBleed"""

    MILD = "Mild"
    MODERATE = "Moderate"
    NA = "N/A"
    NONE = "None"
    SELECT = "Select..."
    SEVERE = "Severe"


class SurgeryStatus(Enum, metaclass=OptionalEnumMeta):
    """Enum class for SurgeryStatus"""

    INJECTION_PENDING = "Injection Pending"
    NEW = "New"
    NO_SURGERY = "No Surgery"
    PHASE_2_PENDING = "Phase 2 Pending"
    PLANNED_ACUTE = "Planned Acute"
    READY_FOR_FEEDBACK = "Ready for Feedback"
    UNPLANNED_ACUTE = "Unplanned Acute"


class Well(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Well"""

    MESOSCOPE = "Mesoscope"
    NEUROPIXEL = "Neuropixel"
    NO_WELL = "No Well"
    OTHER_SEE_REQUESTOR_COMME = "Other (See requestor comments)"
    SCIENTIFICA_CAM = "Scientifica (CAM)"
    SELECT = "Select..."
    WHC_2_P = "WHC 2P"
    WHC_NP = "WHC NP"


class WindowPlacment(Enum, metaclass=OptionalEnumMeta):
    """Enum class for WindowPlacment"""

    ANTERIOR = "Anterior"
    CENTRAL = "Central"
    LATERAL = "Lateral"
    MEDIAL = "Medial"
    NA = "N/A"
    OTHER_IN_COMMENTS = "Other (In comments)"
    POSTERIOR = "Posterior"
    SELECT = "Select..."


class NSBList(BaseModel, extra=Extra.allow):
    """Fields in Sharepoint list"""

    age_at_injection: Optional[str] = Field(
        default=None,
        alias="Age_x0020_at_x0020_Injection",
        title="Age at Injection 1",
    )
    ap2nd_inj: Optional[str] = Field(
        default=None, alias="AP2ndInj", title="Burr 2 A/P"
    )
    author_id: Optional[int] = Field(default=None, alias="AuthorId")
    breg2_lamb: Optional[float] = Field(
        default=None, alias="Breg2Lamb", title="Bregma to Lambda"
    )
    burr1_injection_devi: Optional[Burr1InjectionDevice] = Field(
        default=None,
        alias="Burr1_x0020_Injection_x0020_Devi",
        title="Burr1 Injection Device",
    )
    burr1_perform_during: Optional[Burr1PerformDuring] = Field(
        default=None,
        alias="Burr1_x0020_Perform_x0020_During",
        title="Burr1 Perform During",
    )
    burr1_virus_biosafte: Optional[Burr1VirusBiosafteyLevelBsl] = Field(
        default=None,
        alias="Burr1_x0020_Virus_x0020_Biosafte",
        title="Burr1 Virus Biosaftey Level (BSL)",
        description=(
            "BSL & Material injected. If other PI must provide material in "
            "requestor comments."
        ),
    )
    burr2_injection_devi: Optional[Burr2InjectionDevice] = Field(
        default=None,
        alias="Burr2_x0020_Injection_x0020_Devi",
        title="Burr2 Injection Device",
    )
    burr2_perform_during: Optional[Burr2PerformDuring] = Field(
        default=None,
        alias="Burr2_x0020_Perform_x0020_During",
        title="Burr2 Perform During",
    )
    burr2_status: Optional[Burr2Status] = Field(
        default=None, alias="Burr2_x0020_Status", title="Burr2 Status"
    )
    burr2_virus_biosafte: Optional[Burr2VirusBiosafteyLevelBsl] = Field(
        default=None,
        alias="Burr2_x0020_Virus_x0020_Biosafte",
        title="Burr2 Virus Biosaftey Level (BSL)",
        description=(
            "BSL & Material injected. If other PI must provide material in "
            "requestor comments."
        ),
    )
    burr3_a_p: Optional[str] = Field(
        default=None, alias="Burr3_x0020_A_x002f_P", title="Burr3 A/P"
    )
    burr3_d_v: Optional[str] = Field(
        default=None, alias="Burr3_x0020_D_x002f_V", title="Burr3 D/V"
    )
    burr3_injection_devi: Optional[Burr3InjectionDevice] = Field(
        default=None,
        alias="Burr3_x0020_Injection_x0020_Devi",
        title="Burr3 Injection Device",
    )
    burr3_m_l: Optional[str] = Field(
        default=None, alias="Burr3_x0020_M_x002f_L", title="Burr3 M/L"
    )
    burr3_perform_during: Optional[Burr3PerformDuring] = Field(
        default=None,
        alias="Burr3_x0020_Perform_x0020_During",
        title="Burr3 Perform During",
    )
    burr3_status: Optional[Burr3Status] = Field(
        default=None, alias="Burr3_x0020_Status", title="Burr3 Status"
    )
    burr3_virus_biosafet: Optional[Burr3VirusBiosafetyLevelBsl] = Field(
        default=None,
        alias="Burr3_x0020_Virus_x0020_Biosafet",
        title="Burr3 Virus Biosafety Level (BSL)",
        description=(
            "BSL & Material injected. If other PI must provide material in "
            "requestor comments."
        ),
    )
    burr4_a_p: Optional[str] = Field(
        default=None, alias="Burr4_x0020_A_x002f_P", title="Burr4 A/P"
    )
    burr4_d_v: Optional[str] = Field(
        default=None, alias="Burr4_x0020_D_x002f_V", title="Burr4 D/V"
    )
    burr4_injection_devi: Optional[Burr4InjectionDevice] = Field(
        default=None,
        alias="Burr4_x0020_Injection_x0020_Devi",
        title="Burr4 Injection Device",
    )
    burr4_m_l: Optional[str] = Field(
        default=None, alias="Burr4_x0020_M_x002f_L", title="Burr4 M/L"
    )
    burr4_perform_during: Optional[Burr4PerformDuring] = Field(
        default=None,
        alias="Burr4_x0020_Perform_x0020_During",
        title="Burr4 Perform During",
    )
    burr4_status: Optional[Burr4Status] = Field(
        default=None, alias="Burr4_x0020_Status", title="Burr4 Status"
    )
    burr4_virus_biosafte: Optional[Burr4VirusBiosafteyLevelBsl] = Field(
        default=None,
        alias="Burr4_x0020_Virus_x0020_Biosafte",
        title="Burr4 Virus Biosaftey Level (BSL)",
        description=(
            "BSL & Material injected. If other PI must provide material in "
            "requestor comments."
        ),
    )
    burr_3_angle: Optional[str] = Field(
        default=None, alias="Burr_x0020_3_x0020_Angle", title="Burr 3 Angle"
    )
    burr_3_hemisphere: Optional[Burr3Hemisphere] = Field(
        default=None,
        alias="Burr_x0020_3_x0020_Hemisphere",
        title="Burr 3 Hemisphere",
    )
    burr_4_angle: Optional[str] = Field(
        default=None, alias="Burr_x0020_4_x0020_Angle", title="Burr 4 Angle"
    )
    burr_4_hemisphere: Optional[Burr4Hemisphere] = Field(
        default=None,
        alias="Burr_x0020_4_x0020_Hemisphere",
        title="Burr 4 Hemisphere",
    )
    burr_hole_1: Optional[BurrHole1] = Field(
        default=None, alias="Burr_x0020_hole_x0020_1", title="Burr hole 1"
    )
    burr_hole_1_st: Optional[Burr1Status] = Field(
        default=None,
        alias="Burr_x0020_Hole_x0020_1_x0020_st",
        title="Burr1 Status",
    )
    burr_hole_2: Optional[BurrHole2] = Field(
        default=None, alias="Burr_x0020_hole_x0020_2", title="Burr hole 2"
    )
    burr_hole_3: Optional[BurrHole3] = Field(
        default=None, alias="Burr_x0020_hole_x0020_3", title="Burr hole 3"
    )
    burr_hole_4: Optional[BurrHole4] = Field(
        default=None, alias="Burr_x0020_hole_x0020_4", title="Burr hole 4"
    )
    color_tag: Optional[str] = Field(
        default=None, alias="_ColorTag", title="Color Tag"
    )
    com_coplanar: Optional[Laceration] = Field(
        default=None, alias="ComCoplanar", title="Laceration"
    )
    com_damage: Optional[Hematoma] = Field(
        default=None, alias="ComDamage", title="Hematoma"
    )
    com_durotomy: Optional[Durotomy] = Field(
        default=None, alias="ComDurotomy", title="Durotomy"
    )
    com_sinusbleed: Optional[SinusBleed] = Field(
        default=None, alias="ComSinusbleed", title="Sinus Bleed"
    )
    com_swelling: Optional[EdemaSwelling] = Field(
        default=None, alias="ComSwelling", title="Edema (Swelling)"
    )
    com_window: Optional[WindowPlacment] = Field(
        default=None, alias="ComWindow", title="Window Placment"
    )
    compliance_asset_id: Optional[str] = Field(
        default=None, alias="ComplianceAssetId", title="Compliance Asset Id"
    )
    contusion: Optional[Contusion] = Field(
        default=None, alias="Contusion", title="Contusion"
    )
    craniotomy_perform_d: Optional[CraniotomyPerformDuring] = Field(
        default=None,
        alias="Craniotomy_x0020_Perform_x0020_D",
        title="Craniotomy Perform During",
    )
    craniotomy_type: Optional[CraniotomyType] = Field(
        default=None, alias="CraniotomyType", title="Craniotomy Type"
    )
    created: Optional[datetime] = Field(
        default=None, alias="Created", title="Created"
    )
    date1st_injection: Optional[datetime] = Field(
        default=None,
        alias="Date1stInjection",
        title="Date of Follow up Surgery",
    )
    date_of_birth: Optional[datetime] = Field(
        default=None, alias="Date_x0020_of_x0020_Birth", title="Date of Birth"
    )
    date_of_surgery: Optional[datetime] = Field(
        default=None,
        alias="Date_x0020_of_x0020_Surgery",
        title="Date of Initial Surgery",
    )
    date_range_start: Optional[datetime] = Field(
        default=None, alias="DateRangeStart", title="DateRangeStart"
    )
    dv2nd_inj: Optional[str] = Field(
        default=None, alias="DV2ndInj", title="Burr 2 D/V"
    )
    editor_id: Optional[int] = Field(default=None, alias="EditorId")
    fiber_implant1_dv: Optional[str] = Field(
        default=None, alias="FiberImplant1DV", title="Fiber Implant1 D/V"
    )
    fiber_implant1_lengt: Optional[FiberImplant1Length] = Field(
        default=None,
        alias="Fiber_x0020_Implant1_x0020_Lengt",
        title="Fiber Implant1 Length",
    )
    fiber_implant2_dv: Optional[str] = Field(
        default=None, alias="FiberImplant2DV", title="Fiber Implant2 D/V"
    )
    fiber_implant2_lengt: Optional[FiberImplant2Length] = Field(
        default=None,
        alias="Fiber_x0020_Implant2_x0020_Lengt",
        title="Fiber Implant2 Length",
    )
    fiber_implant3_d_x00: Optional[str] = Field(
        default=None,
        alias="Fiber_x0020_Implant3_x0020_D_x00",
        title="Fiber Implant3 D/V",
    )
    fiber_implant3_lengt: Optional[FiberImplant3Length] = Field(
        default=None,
        alias="Fiber_x0020_Implant3_x0020_Lengt",
        title="Fiber Implant3 Length",
    )
    fiber_implant4_d_x00: Optional[str] = Field(
        default=None,
        alias="Fiber_x0020_Implant4_x0020_D_x00",
        title="Fiber Implant4 D/V",
    )
    fiber_implant4_lengt: Optional[FiberImplant4Length] = Field(
        default=None,
        alias="Fiber_x0020_Implant4_x0020_Lengt",
        title="Fiber Implant4 Length",
    )
    first_inj_recovery: Optional[float] = Field(
        default=None, alias="FirstInjRecovery", title="Follow up Recovery"
    )
    first_injection_iso_durat: Optional[float] = Field(
        default=None,
        alias="FirstInjectionIsoDuration",
        title="Follow up Iso Duration",
    )
    first_injection_weight_af: Optional[float] = Field(
        default=None,
        alias="FirstInjectionWeightAfter",
        title="Follow up Weight After",
    )
    first_injection_weight_be: Optional[float] = Field(
        default=None,
        alias="FirstInjectionWeightBefor",
        title="Follow up Weight Before",
    )
    headpost: Optional[Headpost] = Field(
        default=None, alias="Headpost", title="Headpost"
    )
    headpost_perform_dur: Optional[HeadpostPerformDuring] = Field(
        default=None,
        alias="Headpost_x0020_Perform_x0020_Dur",
        title="Headpost Perform During",
    )
    headpost_type: Optional[Well] = Field(
        default=None, alias="HeadpostType", title="Well"
    )
    hemisphere2nd_inj: Optional[Burr2Hemisphere] = Field(
        default=None, alias="Hemisphere2ndInj", title="Burr 2 Hemisphere"
    )
    hp_iso_level: Optional[float] = Field(
        default=None, alias="HPIsoLevel", title="Initial Iso Level"
    )
    hp_recovery: Optional[float] = Field(
        default=None, alias="HPRecovery", title="Initial Recovery"
    )
    hp_surgeon_comments: Optional[str] = Field(
        default=None, alias="HPSurgeonComments", title="Surgeon Comments"
    )
    hp_work_station: Optional[InitialWorkStation] = Field(
        default=None, alias="HpWorkStation", title="Initial Work Station"
    )
    iacuc_protocol: Optional[IacucProtocol] = Field(
        default=None,
        alias="IACUC_x0020_Protocol_x0020__x002",
        title="IACUC Protocol",
        description="Create a secondary List for Protocols and link to drugs",
    )
    id: Optional[int] = Field(default=None, alias="ID", title="ID")
    implant_id_coverslip_type: Optional[ImplantIdCoverslipType] = Field(
        default=None,
        alias="ImplantIDCoverslipType",
        title="Implant ID/Coverslip type",
    )
    inj1_alternating_time: Optional[str] = Field(
        default=None, alias="Inj1AlternatingTime", title="Inj1AlternatingTime"
    )
    inj1_angle_v2: Optional[str] = Field(
        default=None, alias="Inj1Angle_v2", title="Burr 1 Angle"
    )
    inj1_current: Optional[str] = Field(
        default=None, alias="Inj1Current", title="Inj1Current"
    )
    inj1_ionto_time: Optional[str] = Field(
        default=None, alias="Inj1IontoTime", title="Inj1IontoTime"
    )
    inj1_storage_location: Optional[str] = Field(
        default=None, alias="Inj1StorageLocation", title="Inj1StorageLocation"
    )
    inj1_type: Optional[Inj1Type] = Field(
        default=None, alias="Inj1Type", title="Inj1Type"
    )
    inj1_virus_strain_rt: Optional[str] = Field(
        default=None, alias="Inj1VirusStrain_rt", title="Inj1VirusStrain_rt"
    )
    inj1volperdepth: Optional[str] = Field(
        default=None, alias="inj1volperdepth", title="inj1volperdepth"
    )
    inj2_alternating_time: Optional[str] = Field(
        default=None, alias="Inj2AlternatingTime", title="Inj2AlternatingTime"
    )
    inj2_angle_v2: Optional[str] = Field(
        default=None, alias="Inj2Angle_v2", title="Burr 2 Angle"
    )
    inj2_current: Optional[str] = Field(
        default=None, alias="Inj2Current", title="Inj2Current"
    )
    inj2_ionto_time: Optional[str] = Field(
        default=None, alias="Inj2IontoTime", title="Inj2IontoTime"
    )
    inj2_storage_location: Optional[str] = Field(
        default=None, alias="Inj2StorageLocation", title="Inj2StorageLocation"
    )
    inj2_type: Optional[Inj2Type] = Field(
        default=None, alias="Inj2Type", title="Inj2Type"
    )
    inj2_virus_strain_rt: Optional[str] = Field(
        default=None, alias="Inj2VirusStrain_rt", title="Inj2VirusStrain_rt"
    )
    inj2volperdepth: Optional[str] = Field(
        default=None, alias="inj2volperdepth", title="inj2volperdepth"
    )
    inj3_alternating_time: Optional[str] = Field(
        default=None, alias="Inj3AlternatingTime", title="Inj3AlternatingTime"
    )
    inj3_current: Optional[str] = Field(
        default=None, alias="Inj3Current", title="Inj3Current"
    )
    inj3_ionto_time: Optional[str] = Field(
        default=None, alias="Inj3IontoTime", title="Inj3IontoTime"
    )
    inj3_storage_location: Optional[str] = Field(
        default=None, alias="Inj3StorageLocation", title="Inj3StorageLocation"
    )
    inj3_type: Optional[Inj3Type] = Field(
        default=None, alias="Inj3Type", title="Inj3Type"
    )
    inj3ret_setting: Optional[Inj3Retsetting] = Field(
        default=None, alias="Inj3retSetting", title="Inj3retSetting"
    )
    inj3volperdepth: Optional[str] = Field(
        default=None, alias="Inj3volperdepth", title="Inj3volperdepth"
    )
    inj4_alternating_time: Optional[str] = Field(
        default=None, alias="Inj4AlternatingTime", title="Inj4AlternatingTime"
    )
    inj4_current: Optional[str] = Field(
        default=None, alias="Inj4Current", title="Inj4Current"
    )
    inj4_ionto_time: Optional[str] = Field(
        default=None, alias="Inj4IontoTime", title="Inj4IontoTime"
    )
    inj4_storage_location: Optional[str] = Field(
        default=None, alias="Inj4StorageLocation", title="Inj4StorageLocation"
    )
    inj4_type: Optional[Inj4Type] = Field(
        default=None, alias="Inj4Type", title="Inj4Type"
    )
    inj4_virus_strain_rt: Optional[str] = Field(
        default=None, alias="Inj4VirusStrain_rt", title="Inj4VirusStrain_rt"
    )
    inj4ret_setting: Optional[Inj4Retsetting] = Field(
        default=None, alias="Inj4retSetting", title="Inj4retSetting"
    )
    inj4volperdepth: Optional[str] = Field(
        default=None, alias="Inj4volperdepth", title="Inj4volperdepth"
    )
    inj_virus_strain_rt: Optional[str] = Field(
        default=None, alias="InjVirusStrain_rt", title="Inj3VirusStrain_rt"
    )
    ionto_number_inj1: Optional[InitialIontoNumber] = Field(
        default=None, alias="IontoNumberInj1", title="Initial Ionto Number"
    )
    ionto_number_inj2: Optional[FolowUpIontoNumber] = Field(
        default=None, alias="IontoNumberInj2", title="Folow up Ionto Number"
    )
    iso_on: Optional[float] = Field(
        default=None, alias="Iso_x0020_On", title="Initial Iso Duration"
    )
    lab_tracks_group: Optional[str] = Field(
        default=None, alias="LabTracks_x0020_Group", title="LabTracks Group"
    )
    lab_tracks_id1: Optional[str] = Field(
        default=None, alias="LabTracks_x0020_ID1", title="LabTracks ID"
    )
    lab_tracks_requestor: Optional[str] = Field(
        default=None,
        alias="LabTracks_x0020_Requestor",
        title="LabTracks Requestor",
        description="Who requested the animal in LabTracks",
    )
    li_ms_required: Optional[LimsRequired] = Field(
        default=None,
        alias="LIMs_x0020_Required",
        title="LIMS Required",
        description="Is LIMS Entry required",
    )
    light_cycle: Optional[Lightcycle] = Field(
        default=None, alias="LightCycle", title="LightCycle"
    )
    lims_project: Optional[Limsproject] = Field(
        default=None, alias="LIMSProject", title="LIMSProject"
    )
    lims_taskflow: Optional[Limstaskflow] = Field(
        default=None, alias="LIMSTaskflow", title="LIMSTaskflow"
    )
    long_requestor_comments: Optional[str] = Field(
        default=None, alias="LongRequestorComments", title="Requestor Comments"
    )
    ml2nd_inj: Optional[str] = Field(
        default=None, alias="ML2ndInj", title="Burr 2 M/L"
    )
    modified: Optional[datetime] = Field(
        default=None, alias="Modified", title="Modified"
    )
    nanoject_number_inj10: Optional[InitialNanojectNumber] = Field(
        default=None,
        alias="NanojectNumberInj10",
        title="Initial Nanoject Number",
    )
    nanoject_number_inj2: Optional[FollowUpNanojectNumber] = Field(
        default=None,
        alias="NanojectNumberInj2",
        title="Follow up Nanoject Number",
    )
    of_burr: Optional[OfBurrHoles] = Field(
        default=None,
        alias="_x0023__x0020_of_x0020_Burr_x002",
        title="# of Burr Holes",
    )
    pedigree_name: Optional[str] = Field(
        default=None, alias="PedigreeName", title="Pedigree Name"
    )
    procedure: Optional[Procedure] = Field(
        default=None,
        alias="Procedure",
        title="Procedure",
        description="Procedure, Specific T3",
    )
    procedure_family: Optional[ProcedureCategory] = Field(
        default=None,
        alias="Procedure_x0020_Family",
        title="Procedure Category",
        description="Procedure Family T1",
    )
    procedure_slots: Optional[ProcedureSlots] = Field(
        default=None,
        alias="Procedure_x0020_Slots",
        title="Procedure Slots",
        description="Sinlge or mutpile surgical slots",
    )
    procedure_t2: Optional[PhysiologyType] = Field(
        default=None,
        alias="Procedure_x0020_T2",
        title="Physiology Type",
        description="Procedure Imaging paradigm T2",
    )
    project_id: Optional[Projectid] = Field(
        default=None, alias="ProjectID", title="ProjectID"
    )
    ret_setting0: Optional[Inj1Retsetting] = Field(
        default=None, alias="retSetting0", title="Inj1retSetting"
    )
    ret_setting1: Optional[Inj2Retsetting] = Field(
        default=None, alias="retSetting1", title="Inj2retSetting"
    )
    round1_inj_isolevel: Optional[float] = Field(
        default=None, alias="Round1InjIsolevel", title="Follow up Iso Level"
    )
    sex: Optional[Sex] = Field(default=None, alias="Sex", title="Sex")
    surgery_status: Optional[SurgeryStatus] = Field(
        default=None, alias="SurgeryStatus", title="Surgery Status"
    )
    title: Optional[str] = Field(default=None, alias="Title", title="Title")
    ui_version_string: Optional[str] = Field(
        default=None, alias="_UIVersionString", title="Version"
    )
    virus_a_p: Optional[str] = Field(
        default=None, alias="Virus_x0020_A_x002f_P", title="Burr 1 A/P"
    )
    virus_d_v: Optional[str] = Field(
        default=None, alias="Virus_x0020_D_x002f_V", title="Burr  1 D/V"
    )
    virus_hemisphere: Optional[Burr1Hemisphere] = Field(
        default=None, alias="Virus_x0020_Hemisphere", title="Burr 1 Hemisphere"
    )
    virus_m_l: Optional[str] = Field(
        default=None, alias="Virus_x0020_M_x002f_L", title="Burr  1 M/L"
    )
    weight_after_surgery: Optional[float] = Field(
        default=None,
        alias="Weight_x0020_after_x0020_Surgery",
        title="Initial Weight after",
    )
    weight_before_surger: Optional[float] = Field(
        default=None,
        alias="Weight_x0020_before_x0020_Surger",
        title="Initial Weight before",
    )
    work_station1st_injection: Optional[FollowUpWorkstation] = Field(
        default=None,
        alias="WorkStation1stInjection",
        title="Follow up Workstation",
    )
