"""This module was autogenerated from sharepoint list schema. Please be
careful modifying the contents."""

from datetime import datetime
from enum import Enum, EnumMeta
from typing import Optional

from pydantic import BaseModel, Extra, Field


class OptionalEnumMeta(EnumMeta):
    """Return None if constructing from a value not in members."""

    def __call__(cls, value, *args, **kw):
        """Return none if value not in members. Else return enum."""
        if value in [m.value for m in cls.__members__.values()]:
            return super().__call__(value, *args, **kw)
        else:
            return None


class After1StInjection(Enum, metaclass=OptionalEnumMeta):
    """Enum class for After1StInjection"""

    BLEEDING = "Bleeding"
    BLEEDING_FLUID_COMING_UP = "Bleeding/Fluid coming up"
    FLUID_COMING_UP = "Fluid coming up"
    NA = "N/A"
    NO_ISSUES = "No Issues"
    SELECT = "Select..."
    SWELLING = "Swelling"


class After2NdInjection(Enum, metaclass=OptionalEnumMeta):
    """Enum class for After2NdInjection"""

    BLEEDING = "Bleeding"
    BLEEDING_FLUID_COMING_UP = "Bleeding/Fluid coming up"
    FLUID_COMING_UP = "Fluid coming up"
    NA = "N/A"
    NO_ISSUES = "No Issues"
    SELECT = "Select..."
    SWELLING = "Swelling"


class Contusion(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Contusion"""

    MILD = "Mild"
    MODERATE = "Moderate"
    NA = "N/A"
    NONE = "None"
    SELECT = "Select..."
    SEVERE = "Severe"


class CraniotomyType(Enum, metaclass=OptionalEnumMeta):
    """Enum class for CraniotomyType"""

    FRONTAL_WINDOW_3MM = "Frontal Window 3mm"
    SELECT = "Select..."
    VISUAL_CORTEX_5MM = "Visual Cortex 5mm"
    WHC_2_P = "WHC 2P"
    WHC_NP = "WHC NP"


class During1StInjection(Enum, metaclass=OptionalEnumMeta):
    """Enum class for During1StInjection"""

    BLEEDING = "Bleeding"
    BLEEDING_FLUID_COMING = "Bleeding/Fluid coming"
    FLUID_COMING_UP = "Fluid coming up"
    NA = "N/A"
    NO_ISSUES = "No Issues"
    PIPETTE_CLOGGEDBROKE_TIP = "Pipette clogged/broke tip"
    SELECT = "Select..."
    SWELLING = "Swelling"


class During2NdInjection(Enum, metaclass=OptionalEnumMeta):
    """Enum class for During2NdInjection"""

    BLEEDING = "Bleeding"
    BLEEDING_FLUID_COMING_UP = "Bleeding/Fluid coming up"
    FLUID_COMING_UP = "Fluid coming up"
    NA = "N/A"
    NO_ISSUES = "No Issues"
    PIPETTE_CLOGGEDBROKE_TIP = "Pipette clogged/broke tip"
    SELECT = "Select..."
    SWELLING = "Swelling"


class Durotomy(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Durotomy"""

    COMPLETE = "Complete"
    NA = "N/A"
    NO = "No"
    PARTIAL = "Partial"
    SELECT = "Select..."
    TORN_COMPLETE = "Torn & Complete"
    UNINTENTIONAL = "Unintentional"


class EdemaSwelling(Enum, metaclass=OptionalEnumMeta):
    """Enum class for EdemaSwelling"""

    MILD = "Mild"
    MODERATE = "Moderate"
    NA = "N/A"
    NONE = "None"
    SELECT = "Select..."
    SEVERE = "Severe"


class ExudateSeverity(Enum, metaclass=OptionalEnumMeta):
    """Enum class for ExudateSeverity"""

    MILD = "Mild"
    MODERATE = "Moderate"
    NONE = "None"
    SELECT = "Select..."
    SEVERE = "Severe"


class EyeAffected(Enum, metaclass=OptionalEnumMeta):
    """Enum class for EyeAffected"""

    BOTH = "Both"
    LEFT = "Left"
    NEITHER = "Neither"
    RIGHT = "Right"
    SELECT = "Select..."


class EyeIssue(Enum, metaclass=OptionalEnumMeta):
    """Enum class for EyeIssue"""

    CLOUD_POSSIBLY_BLIND = "Cloud/Possibly Blind"
    NONE = "None"
    OTHER_SEE_COMMENTS = "Other...(See comments)"
    PUFFY_SWOLLEN = "Puffy/Swollen"
    SELECT = "Select..."
    SLIGHTLY_CLOSED = "Slightly Closed"
    WEEPY = "Weepy"


class FirstRoundInjIsoLevel(Enum, metaclass=OptionalEnumMeta):
    """Enum class for FirstRoundInjIsoLevel"""

    N_025 = "0.25"
    N_050 = "0.50"
    N_075 = "0.75"
    N_100 = "1.00"
    N_125 = "1.25"
    N_150 = "1.50"
    N_175 = "1.75"
    N_200 = "2.00"
    N_225 = "2.25"
    N_250 = "2.50"
    N_275 = "2.75"
    N_300 = "3.00+"
    SELECT = "Select..."


class FirstRoundInjWorkstation(Enum, metaclass=OptionalEnumMeta):
    """Enum class for FirstRoundInjWorkstation"""

    SELECT = "Select..."
    SWS_1 = "SWS 1"
    SWS_2 = "SWS 2"
    SWS_3 = "SWS 3"
    SWS_4 = "SWS 4"
    SWS_5 = "SWS 5"
    SWS_6 = "SWS 6"
    SWS_7 = "SWS 7"
    SWS_8 = "SWS 8"
    SWS_9 = "SWS 9"


class Firstroundiontoissue(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Firstroundiontoissue"""

    NA = "N/A"
    NO = "No"
    SELECT = "Select..."
    YES = "Yes"


class Firstroundiontonumber(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Firstroundiontonumber"""

    IONTO_1 = "Ionto #1"
    IONTO_10 = "Ionto #10"
    IONTO_2 = "Ionto #2"
    IONTO_3 = "Ionto #3"
    IONTO_4 = "Ionto #4"
    IONTO_5 = "Ionto #5"
    IONTO_6 = "Ionto #6"
    IONTO_7 = "Ionto #7"
    IONTO_8 = "Ionto #8"
    IONTO_9 = "Ionto #9"
    NA = "N/A"
    SELECT = "Select..."


class Firstroundnanojectnumber(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Firstroundnanojectnumber"""

    NA = "N/A"
    NJ1 = "NJ#1"
    NJ2 = "NJ#2"
    NJ3 = "NJ#3"
    NJ4 = "NJ#4"
    NJ5 = "NJ#5"
    NJ6 = "NJ#6"
    NJ7 = "NJ#7"
    NJ8 = "NJ#8"
    SELECT = "Select..."


class HeadpostType(Enum, metaclass=OptionalEnumMeta):
    """Enum class for HeadpostType"""

    AI_STRAIGHT_HEADBAR = "AI Straight Headbar"
    CAMSTYLE_HEADFRAME_016010 = "CAM-style headframe (0160-100-10 Rev A)"
    MESOSCOPESTYLE_WELL_WITH = (
        "Mesoscope-style well with NGC-style headframe "
        "(0160-200-20/0160-100-10)"
    )
    NEUROPIXELSTYLE_HEADFRAME = (
        "Neuropixel-style headframe (0160-100-10/0160-200-36)"
    )
    NGCSTYLE_HEADFRAME_NO_WEL = "NGC-style headframe, no well (0160-100-10)"
    SELECT = "Select..."
    WHC_42_WITH_NEUROPIXEL_WE = "WHC #42 with Neuropixel well and well cap"


class Hematoma(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Hematoma"""

    MILD = "Mild"
    MODERATE = "Moderate"
    NA = "N/A"
    NONE = "None"
    SELECT = "Select..."
    SEVERE = "Severe"


class HpDurotomy(Enum, metaclass=OptionalEnumMeta):
    """Enum class for HpDurotomy"""

    NO = "No"
    SELECT = "Select..."
    YES = "Yes"


class HpIsoLevel(Enum, metaclass=OptionalEnumMeta):
    """Enum class for HpIsoLevel"""

    N_025 = "0.25"
    N_050 = "0.50"
    N_075 = "0.75"
    N_100 = "1.00"
    N_125 = "1.25"
    N_15 = "1.5"
    N_175 = "1.75"
    N_200 = "2.00"
    N_225 = "2.25"
    N_250 = "2.50"
    N_275 = "2.75"
    N_300 = "3.00+"
    SELECT = "Select..."


class HpLocation(Enum, metaclass=OptionalEnumMeta):
    """Enum class for HpLocation"""

    CENTER = "Center"
    LEFT = "Left"
    RIGHT = "Right"
    SELECT = "Select..."


class HpPerferations(Enum, metaclass=OptionalEnumMeta):
    """Enum class for HpPerferations"""

    LEFT = "Left"
    NA = "NA"
    RIGHT = "Right"
    SELECT_IF_APPLICABLE = "Select if applicable..."


class HpWorkStation(Enum, metaclass=OptionalEnumMeta):
    """Enum class for HpWorkStation"""

    SELECT = "Select..."
    SWS_1 = "SWS 1"
    SWS_2 = "SWS 2"
    SWS_3 = "SWS 3"
    SWS_4 = "SWS 4"
    SWS_5 = "SWS 5"
    SWS_6 = "SWS 6"
    SWS_7 = "SWS 7"
    SWS_8 = "SWS 8"
    SWS_9 = "SWS 9"


class IacucProtocol(Enum, metaclass=OptionalEnumMeta):
    """Enum class for IacucProtocol"""

    N_2001 = "2001"
    N_2002 = "2002"
    N_2003 = "2003"
    N_2004 = "2004"
    N_2005 = "2005"
    N_2006 = "2006"
    N_2011 = "2011"
    N_2102 = "2102"
    N_2103 = "2103"
    N_2104 = "2104"
    N_2105 = "2105"
    N_2106 = "2106"
    N_2107 = "2107"
    N_2108 = "2108"
    N_2109 = "2109"
    N_2110 = "2110"
    N_2113 = "2113"
    N_2115 = "2115"
    N_2117 = "2117"
    N_2201 = "2201"
    N_2202 = "2202"
    N_2205 = "2205"
    N_2212 = "2212"
    SELECT = "Select..."


class ImplantIdCoverslipType(Enum, metaclass=OptionalEnumMeta):
    """Enum class for ImplantIdCoverslipType"""

    CUSTOM_IMPLANT_ADD_DETAIL = (
        "Custom Implant (add details in comments section)"
    )
    N_2001 = "2001"
    N_2002 = "2002"
    N_3001 = "3001"
    N_5MM_STACKED_COVERSLIP = "5mm stacked coverslip"
    N_5MM_STACKED_COVERSLIP_W = (
        "5mm stacked coverslip (with silicone coating for Neuropixel)"
    )
    SELECT = "Select..."


class Inj1Angle(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj1Angle"""

    N_0_DEGREES = "0 degrees"
    N_10_DEGREES = "10 degrees"
    N_15_DEGREES = "15 degrees"
    N_20_DEGREES = "20 degrees"
    N_30_DEGREES = "30 degrees"
    N_40_DEGREES = "40 degrees"
    SELECT = "Select..."


class Inj1Hemisphere(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj1Hemisphere"""

    LEFT = "Left"
    RIGHT = "Right"
    SELECT = "Select..."


class Inj1Retsetting(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj1Retsetting"""

    OFF = "Off"
    ON = "On"


class Inj1Round(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj1Round"""

    NA = "NA"
    N_1ST = "1st"
    N_2ND = "2nd"
    SELECT = "Select..."


class Inj1Type(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj1Type"""

    IONTOPHORESIS = "Iontophoresis"
    NANOJECT_PRESSURE = "Nanoject (Pressure)"
    SELECT = "Select..."


class Inj2Angle(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj2Angle"""

    N_0_DEGREES = "0 degrees"
    N_10_DEGREES = "10 degrees"
    N_15_DEGREES = "15 degrees"
    N_20_DEGREES = "20 degrees"
    N_30_DEGREES = "30 degrees"
    N_40_DEGREES = "40 degrees"
    SELECT = "Select..."


class Inj2Hemisphere(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj2Hemisphere"""

    LEFT = "Left"
    RIGHT = "Right"
    SELECT = "Select..."


class Inj2Retsetting(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj2Retsetting"""

    OFF = "Off"
    ON = "On"


class Inj2Round(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj2Round"""

    NA = "NA"
    N_1ST = "1st"
    N_2ND = "2nd"
    SELECT = "Select..."


class Inj2Type(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Inj2Type"""

    IONTOPHORESIS = "Iontophoresis"
    NANOJECT_PRESSURE = "Nanoject (Pressure)"
    SELECT = "Select..."


class Iontonumberhpinj(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Iontonumberhpinj"""

    IONTO_1 = "Ionto #1"
    IONTO_2 = "Ionto #2"
    IONTO_3 = "Ionto #3"
    IONTO_4 = "Ionto #4"
    IONTO_5 = "Ionto #5"
    IONTO_6 = "Ionto #6"
    IONTO_7 = "Ionto #7"
    IONTO_8 = "Ionto #8"
    IONTO_9 = "Ionto #9"


class Issue(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Issue"""

    EXUDATE = "Exudate"
    EYE_ISSUE = "Eye Issue"
    METABOND = "Metabond"
    MULTIPLE_ISSUES_NOTES_IN = "Multiple Issues (Notes In comments)"
    NON_SURGICAL_ISSUE = "Non-Surgical Issue"
    OTHERWRITE_IN_COMMENTS = "Other..(write in comments)"
    REPLACEMENT_COVERSLIP = "Replacement: Coverslip"
    REPLACEMENT_KWIKCAST = "Replacement: Kwikcast"
    REPLACEMENT_ORING = "Replacement: O-ring"
    SCABBING = "Scabbing"
    SELECT = "Select..."
    Z_MOTION = "Z-Motion"


class Laceration(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Laceration"""

    MILD = "Mild"
    MODERATE = "Moderate"
    NA = "N/A"
    NONE = "None"
    SELECT = "Select..."
    SEVERE = "Severe"


class LightCycle(Enum, metaclass=OptionalEnumMeta):
    """Enum class for LightCycle"""

    NORMAL_6AM_TO_8PM = "Normal (6am to 8pm)"
    REVERSE_9PM_TO_9AM = "Reverse (9pm to 9am)"
    SELECT = "Select..."


class LimsProjectCode(Enum, metaclass=OptionalEnumMeta):
    """Enum class for LimsProjectCode"""

    AINDDISCOVERY = "aind-discovery"
    AINDEPHYS = "aind-ephys"
    AINDMSMA = "aind-msma"
    AINDOPHYS = "aind-ophys"
    BRAINTV_VIRAL_STRATEGIES = "BraintvViralStrategies"
    CELLTYPES_TRANSGENIC_CHAR = "CelltypesTransgenicCharacterizationGCaMP"
    CITRICACIDPILOT = "Citricacidpilot"
    DYNAMIC_ROUTING_BEHAVIOR = "DynamicRoutingBehaviorDev"
    DYNAMIC_ROUTING_SURGICAL = "DynamicRoutingSurgicalDevelopment"
    DYNAMIC_ROUTING_TASK1_PRO = "DynamicRoutingTask1Production"
    DYNAMIC_ROUTING_ULTRA_OPT = "DynamicRoutingUltraOptotaggingBehavior"
    IS_IX = "ISIx"
    LEARNINGM_FISH_DEVELOPMEN = "LearningmFISHDevelopment"
    LEARNINGM_FISH_TASK1_A = "LearningmFISHTask1A"
    MINDSCOPE_TRANSGENIC_CHAR = "MindscopeTransgenicCharacterizationGCaMP"
    MOUSE_BRAIN_CELL_ATLAS_TR = "MouseBrainCellAtlasTranssynaptic"
    MOUSE_GENETIC_TOOLS_PROJE = "MouseGeneticToolsProjectionMapping"
    M_IVSCCMET = "mIVSCC-MET"
    M_IVSCCME_TX = "mIVSCC-METx"
    M_MPATC_HX = "mMPATCHx"
    M_M_PATCH = "mMPatch"
    OM_FISHRO_BINJECTIONVIRUS = "omFISHROBinjectionviruspilot"
    OM_FISH_CUX2_MESO = "omFISHCux2Meso"
    OM_FISH_GAD2_MESO = "omFISHGad2Meso"
    OM_FISH_GAD2_PILOT = "omFISHGad2Pilot"
    OM_FISH_RORB_PILOT = "omFISHRorbPilot"
    OM_FIS_HCOREGISTRATIONPIL = "omFISHcoregistrationpilot"
    OPENSCOPE_DEVELOPMENT = "OpenscopeDevelopment"
    OPEN_SCOPE_DENDRITE_COUPL = "OpenScopeDendriteCoupling"
    OPEN_SCOPE_GLOBAL_LOCAL_O = "OpenScopeGlobalLocalOddball"
    OPEN_SCOPE_ILLUSION = "OpenScopeIllusion"
    OPEN_SCOPE_INJECTION_PILO = "OpenScopeInjectionPilot"
    SELECT = "Select..."
    SURGERY_X = "SurgeryX"
    T301T = "T301t"
    TASK_TRAINED_NETWORKS_MUL = "TaskTrainedNetworksMultiscope"
    TASK_TRAINED_NETWORKS_NEU = "TaskTrainedNetworksNeuropixel"
    TINY_BLUE_DOT_BEHAVIOR = "TinyBlueDotBehavior"
    VARIABILITY_AIM1 = "VariabilityAim1"
    VARIABILITY_AIM1_PILOT = "VariabilityAim1Pilot"
    VARIABILITY_SPONTANEOUS = "VariabilitySpontaneous"
    VIP_AXONAL_V1_PHASE1 = "VipAxonalV1Phase1"
    VIP_SOMATIC_V1_MESO = "VIPSomaticV1Meso"
    VIP_SOMATIC_V1_PHASE1 = "VipSomaticV1Phase1"
    VIP_SOMATIC_V1_PHASE2 = "VipSomaticV1Phase2"


class LimsRequired(Enum, metaclass=OptionalEnumMeta):
    """Enum class for LimsRequired"""

    NO = "No"
    SELECT = "Select..."
    YES = "Yes"


class Limstaskflow(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Limstaskflow"""

    AIND_EPHYS_PASSIVE_BEHAVI = "AIND Ephys (Passive Behavior)"
    AIND_EPHYS_SURGERY_ONLY = "AIND Ephys (Surgery only)"
    AIND_U19_THALAMUS = "AIND U19 Thalamus"
    BRAIN_LARGE_SCALE_RECORDI = "BRAIN Large Scale Recording"
    BRAIN_MOUSE_BRAIN_CELL_AT = "BRAIN Mouse Brain Cell Atlas trans-synaptic"
    BRAIN_OBSERVATORY_TRANSGE = "Brain Observatory Transgenic Characterization"
    BTV_BRAIN_VIRAL_STRATEGIE = "BTV BRAIN Viral Strategies"
    CITRIC_ACID_PILOT = "Citric Acid Pilot"
    EPHYS_TASK_DEV_DYNAMIC_RO = "Ephys Task Dev Dynamic Routing (NSB Beh)"
    EPHYS_TASK_DEV_DYNAMI_001 = "Ephys Task Dev Dynamic Routing (S/C Beh)"
    EPHYS_TAS_DEV_DYNAMIC_ROU = "Ephys Tas Dev Dynamic Routing DOC Left Eye"
    IVSCC_HVA_RETRO_PATCH_SEQ = "IVSCC HVA Retro PatchSeq"
    IVSC_CM_INJECTION = "IVSCCm injection"
    IVSP_CM_INJECTION = "IVSPCm Injection"
    MGT_ANTEROGRADE_PROJECTIO = "MGT Anterograde Projection Mapping"
    MGT_LAB = "MGT Lab"
    MGT_TISSUE_CYTE = "MGT TissueCyte"
    MSP_DYNAMIC_ROUTING_SURGI = "MSP Dynamic Routing Surgical Development"
    MSP_DYNAMIC_ROUTING_TASK = "MSP Dynamic Routing Task 1 Production"
    MSP_DYNAMIC_ROUTING_ULTRA = (
        "MSP Dynamic Routing Ultra Optotagging Behavior"
    )
    MSP_LEARNING_M_FISH_DEVEL = "MSP Learning & mFISH Development (Dox)"
    MSP_LEARNING_M_FISH_D_001 = "MSP Learning & mFISH Development"
    MSP_LEARNING_M_FISH_FRONT = "MSP Learning & mFISH Frontal Window Dev"
    MSP_LEARNING_M_FISH_VIRUS = "MSP Learning & mFISH Virus Testing"
    MSP_OM_FISH_CO_REGISTRATI = "MSP omFISH Co-Registration Pilot"
    MSP_OM_FISH_CUX2_PILOT = "MSP omFISH Cux2 Pilot"
    MSP_OM_FISH_GAD2_PILOT = "MSP omFISH Gad2 Pilot"
    MSP_OM_FISH_ROB_INJECTION = "MSP omFISH ROB Injection Virus Pilot"
    MSP_OM_FISH_RORB_PILOT = "MSP omFISH Rorb Pilot"
    MSP_OPEN_SCOPE_DENDRITE_C = "MSP OpenScope Dendrite Coupling"
    MSP_OPEN_SCOPE_GLOBAL_001 = (
        "MSP OpenScope Global Local Oddballs (Cohort 2)"
    )
    MSP_OPEN_SCOPE_GLOBAL_LOC = (
        "MSP OpenScope Global Local Oddballs (Cohort 1)"
    )
    MSP_OPEN_SCOPE_ILLUSION = "MSP OpenScope Illusion"
    MSP_TASK_TRAINED_NETWORKS = "MSP Task Trained Networks Neuropixel"
    MSP_TASK_TRAINED_NETW_001 = "MSP Task Trained Networks Multiscope"
    MSP_VARIABILITY_AIM_1 = "MSP Variability Aim 1"
    MSP_VARIABILITY_AIM_1_PIL = "MSP Variability Aim 1 Pilot"
    MSP_VARIABILITY_SPONTANEO = "MSP Variability Spontaneous"
    MSP_VIP_AXONAL_V1 = "MSP VIP Axonal V1"
    MSP_VIP_SOMATIC_V1 = "MSP VIP Somatic V1"
    NA = "N/A"
    OPENSCOPE_VIRUS_VALIDATIO = "Openscope Virus Validation"
    TINY_BLUE_DOT_BEHAVIOR = "Tiny Blue Dot Behavior"
    TRANSGENIC_CHARACTERIZATI = "Transgenic Characterization (Passive)"
    VGT_ENHANCERS_TRANSSYNAPT = "VGT Enhancers Transsynaptic"


class PreviouslyInjected(Enum, metaclass=OptionalEnumMeta):
    """Enum class for PreviouslyInjected"""

    NO = "No"
    SELECT = "Select..."
    YES = "Yes"


class Procedure(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Procedure"""

    CUSTOM = "Custom"
    HPC_CAM = "HP+C CAM"
    HPC_MULTISCOPE = "HP+C Multiscope"
    HPC_NEUROPIXEL_STYLE = "HP+C Neuropixel style"
    HPINJ = "HP+INJ"
    HP_INJECTION_OPTIC_FIBER = "HP+Injection+Optic Fiber Implant"
    HP_ONLY = "HP only"
    HP_TRANSCRANIAL_FOR_ISI = "HP Transcranial (for ISI)"
    INJHPC = "INJ+HP+C"
    INJWHC_NP = "INJ+WHC NP"
    SELECT = "Select..."
    STEREOTAXIC_INJECTION = "Stereotaxic Injection"
    TRAINING_SURGERY = "Training Surgery"
    WHC_NP = "WHC NP"


class ProjectId(Enum, metaclass=OptionalEnumMeta):
    """Enum class for ProjectId"""

    CAMC506 = "CAM-C506"
    CONT503 = "CON-T503"
    CTYT504 = "CTY-T504"
    LOCC500 = "LOC-C500"
    N_1020100910_CTY_MORPHOLO = "102-01-009-10: CTY-Morphology"
    N_1020101010_CTY_SYNAPTIC = "102-01-010-10: CTY-Synaptic Phys"
    N_1020101410_CTY_GEN_TOOL = "102-01-014-10: CTY GenTools Mouse"
    N_1020102120_CTYBRAIN_001 = (
        "102-01-021-20: CTY-BRAIN Mouse Brain Cell Atlas Seg 1"
    )
    N_1020102120_CTYBRAIN_MOU = (
        "102-01-021-20: CTY-BRAIN Mouse Brain Cell Atlas Seg 2 Anatomy"
    )
    N_1020103620_DISSEMINATIO = (
        "102-01-036-20 Dissemination of 3-photon Imaging"
    )
    N_1020104320_OPTICAL_INTE = (
        "102-01-043-20 Optical Interrogation of Venular Function"
    )
    N_1020104410_CTY_GENOMICS = "102-01-044-10 CTY Genomics"
    N_1020104510_IVSCC = "102-01-045-10 IVSCC"
    N_1020104720_3_P_NHP_CORT = "102-01-047-20 3P NHP cortical imaging R34"
    N_1020104810_CTY_BARCODED = "102-01-048-10 CTY Barcoded Connectomics"
    N_1020105520_CTY_EM_MOTOR = "102-01-055-20 CTY EM Motor Cortex"
    N_1020199910_CTY_PROGRAM = "102-01-999-10 CTY Program Admin"
    N_1020201220_BRAIN_VIRAL = "102-02-012-20: BRAIN Viral Strategies"
    N_1020201720_BRAIN_NEUROP = "102-02-017-20 BRAIN Neuropixels Ultra"
    N_1020400620_OTH_MEASURIN = "102-04-006-20: OTH Measuring Consciousness"
    N_1020400710_TARGETED_CNS = "102-04-007-10 Targeted CNS Gene Therapy"
    N_1020401010_CTY_SR_SLC6 = "102-04-010-10 CTY SR: SLC6A1"
    N_1020401410_CTY_PARKINSO = "102-04-014-10 CTY Parkinsons Disease"
    N_1028800410_XPG_CORE_001 = (
        "102-88-004-10 XPG Core Virus Prod, Task: CVS Production"
    )
    N_1028800410_XPG_CORE_VIR = "102-88-004-10 XPG Core Virus Prod, Task: R&D"
    N_1210100410_VIP_REGULATE = (
        "121-01-004-10 VIP Regulated Stabilized Networks"
    )
    N_1210100710_TASK_TRAINED = "121-01-007-10 Task Trained Networks"
    N_1210100810_NEURAL_ENSEM = "121-01-008-10 Neural Ensemble Variability"
    N_1210101010_V1_OM_FISH = "121-01-010-10 V1 omFISH"
    N_1210101110_DYNAMIC_ROUT = "121-01-011-10 Dynamic Routing"
    N_1210101210_LEARNING_M_F = "121-01-012-10 Learning mFISH"
    N_1210101320_MSP_TEMPLETO = "121-01-013-20 MSP Templeton"
    N_1210101620_BRAIN_OPEN_S = "121-01-016-20 BRAIN OpenScope"
    N_1210102320_MSP_TEMPLETO = (
        "121-01-023-20 MSP Templeton - Testing Theories of Consciousness"
    )
    N_1210199910_MINDSCOPE_MS = "121-01-999-10 Mindscope (MSP) Cross Program"
    N_1220100110_NEURAL_DYNAM = (
        "122-01-001-10 Neural Dynamics Scientific Activities"
    )
    N_1220100220_NEURAL_DYNAM = (
        "122-01-002-20 Neural Dynamics U19- Project 1: Period 1"
    )
    N_1220100220_NEURAL_D_001 = (
        "122-01-002-20 Neural Dynamics U19- Project 2: Period 1"
    )
    N_1229999910_NEURAL_DYNAM = "122-99-999-10 Neural Dynamics Admin (Direct)"
    SELECT = "Select..."


class Scabbing(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Scabbing"""

    MILD = "Mild"
    MODERATE = "Moderate"
    NONE = "None"
    SELECT = "Select..."
    SEVERE = "Severe"


class SecondRoundInjIsoLevel(Enum, metaclass=OptionalEnumMeta):
    """Enum class for SecondRoundInjIsoLevel"""

    N_025 = "0.25"
    N_050 = "0.50"
    N_075 = "0.75"
    N_100 = "1.00"
    N_125 = "1.25"
    N_150 = "1.50"
    N_175 = "1.75"
    N_200 = "2.00"
    N_225 = "2.25"
    N_250 = "2.50"
    N_275 = "2.75"
    N_300 = "3.00+"
    SELECT = "Select..."


class SecondRoundIontoIssue(Enum, metaclass=OptionalEnumMeta):
    """Enum class for SecondRoundIontoIssue"""

    NA = "N/A"
    NO = "No"
    SELECT = "Select..."
    YES = "Yes"


class SecondRoundWorkstation(Enum, metaclass=OptionalEnumMeta):
    """Enum class for SecondRoundWorkstation"""

    SELECT = "Select..."
    SWS_1 = "SWS 1"
    SWS_2 = "SWS 2"
    SWS_3 = "SWS 3"
    SWS_4 = "SWS 4"
    SWS_5 = "SWS 5"
    SWS_6 = "SWS 6"
    SWS_7 = "SWS 7"
    SWS_8 = "SWS 8"
    SWS_9 = "SWS 9"


class Secondroundiontonumber(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Secondroundiontonumber"""

    IONTO_1 = "Ionto #1"
    IONTO_10 = "Ionto #10"
    IONTO_2 = "Ionto #2"
    IONTO_3 = "Ionto #3"
    IONTO_4 = "Ionto #4"
    IONTO_5 = "Ionto #5"
    IONTO_6 = "Ionto #6"
    IONTO_7 = "Ionto #7"
    IONTO_8 = "Ionto #8"
    IONTO_9 = "Ionto #9"
    NA = "N/A"
    SELECT = "Select..."


class Secondroundnanojectnumber(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Secondroundnanojectnumber"""

    NA = "N/A"
    NJ1 = "NJ#1"
    NJ2 = "NJ#2"
    NJ3 = "NJ#3"
    NJ4 = "NJ#4"
    NJ5 = "NJ#5"
    NJ6 = "NJ#6"
    NJ7 = "NJ#7"
    NJ8 = "NJ#8"
    SELECT = "Select..."


class Sex(Enum, metaclass=OptionalEnumMeta):
    """Enum class for Sex"""

    FEMALE = "Female"
    MALE = "Male"
    SELECT = "Select..."


class SinusBleed(Enum, metaclass=OptionalEnumMeta):
    """Enum class for SinusBleed"""

    MILD = "Mild"
    MODERATE = "Moderate"
    NA = "N/A"
    NONE = "None"
    SELECT = "Select..."
    SEVERE = "Severe"


class SurgeryStatus(Enum, metaclass=OptionalEnumMeta):
    """Enum class for SurgeryStatus"""

    INJECTION_PENDING = "Injection Pending"
    NEW = "New"
    NO_SURGERY = "No Surgery"
    PHASE_2_PENDING = "Phase 2 Pending"
    PLANNED_ACUTE = "Planned Acute"
    READY_FOR_FEEDBACK = "Ready for Feedback"
    UNPLANNED_ACUTE = "Unplanned Acute"


class TouchUpStatus(Enum, metaclass=OptionalEnumMeta):
    """Enum class for TouchUpStatus"""

    COMPLETE = "Complete"
    PENDING = "Pending"
    SCHEDULED = "Scheduled"
    SELECT = "Select..."
    UNDER_OBSERVATION = "Under Observation"


class WindowClarity(Enum, metaclass=OptionalEnumMeta):
    """Enum class for WindowClarity"""

    ANTERIOR = "Anterior"
    CENTRAL = "Central"
    LATERAL = "Lateral"
    MEDIAL = "Medial"
    NA = "N/A"
    OTHER_IN_COMMENTS = "Other (In comments)"
    POSTERIOR = "Posterior"
    SELECT = "Select..."


class NSBList(BaseModel, extra=Extra.allow):
    """Fields in Sharepoint list"""

    age_at_injection: Optional[str] = Field(
        default=None,
        alias="Age_x0020_at_x0020_Injection",
        title="Age at Injection 1",
    )
    ap2nd_inj: Optional[str] = Field(
        default=None, alias="AP2ndInj", title="Inj 2 A/P"
    )
    author_id: Optional[int] = Field(default=None, alias="AuthorId")
    breg2_lamb: Optional[str] = Field(
        default=None, alias="Breg2Lamb", title="Bregma to Lambda"
    )
    cage: Optional[str] = Field(default=None, alias="Cage", title="Cage")
    color_tag: Optional[str] = Field(
        default=None, alias="_ColorTag", title="Color Tag"
    )
    com_after1st_inj: Optional[After1StInjection] = Field(
        default=None, alias="ComAfter1stInj", title="After 1st Injection"
    )
    com_after2nd_inj: Optional[After2NdInjection] = Field(
        default=None, alias="ComAfter2ndInj", title="After 2nd Injection"
    )
    com_coplanar: Optional[Laceration] = Field(
        default=None, alias="ComCoplanar", title="Laceration"
    )
    com_damage: Optional[Hematoma] = Field(
        default=None, alias="ComDamage", title="Hematoma"
    )
    com_during1st_inj: Optional[During1StInjection] = Field(
        default=None, alias="ComDuring1stInj", title="During 1st Injection"
    )
    com_during2nd_inj: Optional[During2NdInjection] = Field(
        default=None, alias="ComDuring2ndInj", title="During 2nd Injection"
    )
    com_durotomy: Optional[Durotomy] = Field(
        default=None, alias="ComDurotomy", title="Durotomy"
    )
    com_sinusbleed: Optional[SinusBleed] = Field(
        default=None, alias="ComSinusbleed", title="Sinus Bleed"
    )
    com_swelling: Optional[EdemaSwelling] = Field(
        default=None, alias="ComSwelling", title="Edema (Swelling)"
    )
    com_window: Optional[WindowClarity] = Field(
        default=None, alias="ComWindow", title="Window Clarity"
    )
    compliance_asset_id: Optional[str] = Field(
        default=None, alias="ComplianceAssetId", title="Compliance Asset Id"
    )
    contusion: Optional[Contusion] = Field(
        default=None, alias="Contusion", title="Contusion"
    )
    craniotomy_type: Optional[CraniotomyType] = Field(
        default=None, alias="CraniotomyType", title="Craniotomy Type"
    )
    created: Optional[datetime] = Field(
        default=None, alias="Created", title="Created"
    )
    date1st_injection: Optional[datetime] = Field(
        default=None,
        alias="Date1stInjection",
        title="Date 1st Round Injections",
    )
    date2nd_injection: Optional[datetime] = Field(
        default=None,
        alias="Date2ndInjection",
        title="Date 2nd Round Injections",
    )
    date_of_birth: Optional[datetime] = Field(
        default=None, alias="Date_x0020_of_x0020_Birth", title="Date of Birth"
    )
    date_of_surgery: Optional[datetime] = Field(
        default=None,
        alias="Date_x0020_of_x0020_Surgery",
        title="Date of HP Surgery",
    )
    date_range_end: Optional[datetime] = Field(
        default=None, alias="DateRangeEnd", title="DateRangeEnd"
    )
    date_range_start: Optional[datetime] = Field(
        default=None, alias="DateRangeStart", title="DateRangeStart"
    )
    dv2nd_inj: Optional[str] = Field(
        default=None, alias="DV2ndInj", title="Inj 2 D/V"
    )
    editor_id: Optional[int] = Field(default=None, alias="EditorId")
    end_of_week: Optional[datetime] = Field(
        default=None, alias="End_x0020_of_x0020_Week", title="End of Week"
    )
    exudate_severity: Optional[ExudateSeverity] = Field(
        default=None, alias="Exudate_x0020_Severity", title="Exudate Severity"
    )
    eye_affected: Optional[EyeAffected] = Field(
        default=None, alias="Eye_x0020_Affected", title="Eye Affected"
    )
    eye_issue: Optional[EyeIssue] = Field(
        default=None, alias="Eye_x0020_Issue", title="Eye Issue"
    )
    fiber_implant1: Optional[bool] = Field(
        default=None, alias="FiberImplant1", title="Fiber Implant1"
    )
    fiber_implant1_dv: Optional[str] = Field(
        default=None, alias="FiberImplant1DV", title="FiberImplant1DV"
    )
    fiber_implant2: Optional[bool] = Field(
        default=None, alias="FiberImplant2", title="FiberImplant2"
    )
    fiber_implant2_dv: Optional[str] = Field(
        default=None, alias="FiberImplant2DV", title="FiberImplant2DV"
    )
    field30: Optional[str] = Field(
        default=None, alias="field30", title="Inj1Volperpress"
    )
    field50: Optional[str] = Field(
        default=None, alias="field50", title="Inj2Volperpress"
    )
    first_inj_recovery: Optional[float] = Field(
        default=None, alias="FirstInjRecovery", title="1st Inj Recovery"
    )
    first_injection_iso_durat: Optional[str] = Field(
        default=None,
        alias="FirstInjectionIsoDuration",
        title="1st Round Inj Iso Duration",
    )
    first_injection_weight_af: Optional[str] = Field(
        default=None,
        alias="FirstInjectionWeightAfter",
        title="1st Round Inj Weight After",
    )
    first_injection_weight_be: Optional[str] = Field(
        default=None,
        alias="FirstInjectionWeightBefor",
        title="1st Round Inj Weight Before",
    )
    first_round_ionto_issue: Optional[Firstroundiontoissue] = Field(
        default=None, alias="FirstRoundIontoIssue", title="1stRoundIontoIssue"
    )
    headpost_type: Optional[HeadpostType] = Field(
        default=None, alias="HeadpostType", title="Headpost Type"
    )
    hemisphere2nd_inj: Optional[Inj2Hemisphere] = Field(
        default=None, alias="Hemisphere2ndInj", title="Inj 2 Hemisphere"
    )
    hp_a_p: Optional[str] = Field(
        default=None, alias="HP_x0020_A_x002f_P", title="HP A/P"
    )
    hp_diameter: Optional[str] = Field(
        default=None, alias="HP_x0020_Diameter", title="HP Diameter"
    )
    hp_durotomy: Optional[HpDurotomy] = Field(
        default=None, alias="HPDurotomy", title="HP Durotomy"
    )
    hp_inj: Optional[str] = Field(
        default=None, alias="HP_x0020__x0026__x0020_Inj", title="HP & Inj"
    )
    hp_iso_level: Optional[HpIsoLevel] = Field(
        default=None, alias="HPIsoLevel", title="HP Iso Level"
    )
    hp_loc: Optional[HpLocation] = Field(
        default=None, alias="HpLoc", title="HP Location"
    )
    hp_m_l: Optional[str] = Field(
        default=None, alias="HP_x0020_M_x002f_L", title="HP M/L"
    )
    hp_perf: Optional[HpPerferations] = Field(
        default=None, alias="HpPerf", title="HP Perferations"
    )
    hp_prev_inject: Optional[PreviouslyInjected] = Field(
        default=None, alias="HpPrevInject", title="Previously Injected"
    )
    hp_recovery: Optional[float] = Field(
        default=None, alias="HPRecovery", title="HP Recovery"
    )
    hp_requestor: Optional[str] = Field(
        default=None,
        alias="_x0031_HP_x0020_Requestor_x0020_",
        title="HP Requestor Comments",
    )
    hp_requestor_comments_pla: Optional[str] = Field(
        default=None,
        alias="HPRequestorCommentsPlaintext",
        title="Requestor Comments Plain text",
    )
    hp_surgeon_comments: Optional[str] = Field(
        default=None, alias="HPSurgeonComments", title="HP Surgeon Comments"
    )
    hp_work_station: Optional[HpWorkStation] = Field(
        default=None, alias="HpWorkStation", title="HP Work Station"
    )
    iacuc_protocol: Optional[IacucProtocol] = Field(
        default=None,
        alias="IACUC_x0020_Protocol_x0020__x002",
        title="IACUC Protocol",
        description="Create a secondary List for Protocols and link to drugs",
    )
    id: Optional[int] = Field(default=None, alias="ID", title="ID")
    implant_id_coverslip_type: Optional[ImplantIdCoverslipType] = Field(
        default=None,
        alias="ImplantIDCoverslipType",
        title="Implant ID/Coverslip type",
    )
    inj1_alternating_time: Optional[str] = Field(
        default=None, alias="Inj1AlternatingTime", title="Inj1AlternatingTime"
    )
    inj1_angle_v2: Optional[str] = Field(
        default=None, alias="Inj1Angle_v2", title="Inj1Angle_v2"
    )
    inj1_current: Optional[str] = Field(
        default=None, alias="Inj1Current", title="Inj1Current"
    )
    inj1_lenghtof_time: Optional[str] = Field(
        default=None, alias="Inj1LenghtofTime", title="Inj1LenghtofTime"
    )
    inj1_round: Optional[Inj1Round] = Field(
        default=None, alias="Inj1Round", title="Inj1Round"
    )
    inj1_storage_location: Optional[str] = Field(
        default=None, alias="Inj1StorageLocation", title="Inj1StorageLocation"
    )
    inj1_type: Optional[Inj1Type] = Field(
        default=None, alias="Inj1Type", title="Inj1Type"
    )
    inj1_virus_strain_rt: Optional[str] = Field(
        default=None, alias="Inj1VirusStrain_rt", title="Inj1VirusStrain_rt"
    )
    inj1_vol: Optional[str] = Field(
        default=None, alias="Inj1Vol", title="Inj1Vol"
    )
    inj1angle0: Optional[Inj1Angle] = Field(
        default=None, alias="Inj1angle0", title="Inj1angle"
    )
    inj1volperdepth: Optional[str] = Field(
        default=None, alias="inj1volperdepth", title="inj1volperdepth"
    )
    inj2_alternating_time: Optional[str] = Field(
        default=None, alias="Inj2AlternatingTime", title="Inj2AlternatingTime"
    )
    inj2_angle_v2: Optional[str] = Field(
        default=None, alias="Inj2Angle_v2", title="Inj2Angle_v2"
    )
    inj2_current: Optional[str] = Field(
        default=None, alias="Inj2Current", title="Inj2Current"
    )
    inj2_lenghtof_time: Optional[str] = Field(
        default=None, alias="Inj2LenghtofTime", title="Inj2LenghtofTime"
    )
    inj2_round: Optional[Inj2Round] = Field(
        default=None, alias="Inj2Round", title="Inj2Round"
    )
    inj2_storage_location: Optional[str] = Field(
        default=None, alias="Inj2StorageLocation", title="Inj2StorageLocation"
    )
    inj2_type: Optional[Inj2Type] = Field(
        default=None, alias="Inj2Type", title="Inj2Type"
    )
    inj2_virus_strain_rt: Optional[str] = Field(
        default=None, alias="Inj2VirusStrain_rt", title="Inj2VirusStrain_rt"
    )
    inj2_vol: Optional[str] = Field(
        default=None, alias="Inj2Vol", title="Inj2Vol"
    )
    inj2angle0: Optional[Inj2Angle] = Field(
        default=None, alias="Inj2angle0", title="Inj2angle"
    )
    inj2volperdepth: Optional[str] = Field(
        default=None, alias="inj2volperdepth", title="inj2volperdepth"
    )
    ionto_number_hpinj: Optional[Iontonumberhpinj] = Field(
        default=None, alias="IontoNumberHPINJ", title="IontoNumberHPINJ"
    )
    ionto_number_inj1: Optional[Firstroundiontonumber] = Field(
        default=None, alias="IontoNumberInj1", title="1stRoundIontoNumber"
    )
    ionto_number_inj2: Optional[Secondroundiontonumber] = Field(
        default=None, alias="IontoNumberInj2", title="2ndRoundIontoNumber"
    )
    iso_on: Optional[float] = Field(
        default=None, alias="Iso_x0020_On", title="HP Iso Duration"
    )
    issue: Optional[Issue] = Field(default=None, alias="Issue", title="Issue")
    lab_tracks_group: Optional[str] = Field(
        default=None, alias="LabTracks_x0020_Group", title="LabTracks Group"
    )
    lab_tracks_id: Optional[str] = Field(
        default=None,
        alias="LabTracks_x0020_ID",
        title="LabTracks ID",
        description="Lab Tracks Animal ID",
    )
    lab_tracks_requestor: Optional[str] = Field(
        default=None,
        alias="LabTracks_x0020_Requestor",
        title="LabTracks Requestor",
        description="Who requested the animal in LabTracks",
    )
    li_ms_required: Optional[LimsRequired] = Field(
        default=None,
        alias="LIMs_x0020_Required",
        title="LIMs Required",
        description="Is LIMs Entry required",
    )
    light_cycle: Optional[LightCycle] = Field(
        default=None, alias="Light_x0020_Cycle", title="Light Cycle"
    )
    lim_staskflow1: Optional[Limstaskflow] = Field(
        default=None, alias="LIMStaskflow1", title="LIMStaskflow"
    )
    lims_link: Optional[str] = Field(
        default=None, alias="LIMS_x0020_link", title="LIMS link"
    )
    lims_project_code: Optional[LimsProjectCode] = Field(
        default=None,
        alias="Lims_x0020_Project_x0020_Code",
        title="Lims Project Code",
    )
    long1st_round_inj_cmts: Optional[str] = Field(
        default=None, alias="Long1stRoundInjCmts", title="1stRoundInjComments"
    )
    long2nd_rnd_inj_cmts: Optional[str] = Field(
        default=None, alias="Long2ndRndInjCmts", title="2ndRoundInjComments"
    )
    long_requestor_comments: Optional[str] = Field(
        default=None, alias="LongRequestorComments", title="ReqComments"
    )
    long_surgeon_comments: Optional[str] = Field(
        default=None, alias="LongSurgeonComments", title="HPSurgeonComments"
    )
    ml2nd_inj: Optional[str] = Field(
        default=None, alias="ML2ndInj", title="Inj 2 M/L"
    )
    modified: Optional[datetime] = Field(
        default=None, alias="Modified", title="Modified"
    )
    nanoject_number_inj10: Optional[Firstroundnanojectnumber] = Field(
        default=None,
        alias="NanojectNumberInj10",
        title="1stRoundNanojectNumber",
    )
    nanoject_number_inj2: Optional[Secondroundnanojectnumber] = Field(
        default=None,
        alias="NanojectNumberInj2",
        title="2ndRoundNanojectNumber",
    )
    nd_roung_injection_commen: Optional[str] = Field(
        default=None,
        alias="ndRoungInjectionComments",
        title="2ndRoungInjectionComments",
    )
    pedigree_name: Optional[str] = Field(
        default=None, alias="PedigreeName", title="Pedigree Name"
    )
    procedure: Optional[Procedure] = Field(
        default=None,
        alias="Procedure",
        title="Procedure",
        description="Type of Surgical Procedure",
    )
    project_id_te: Optional[ProjectId] = Field(
        default=None,
        alias="Project_x0020_ID_x0020__x0028_te",
        title="Project ID",
    )
    ret_setting0: Optional[Inj1Retsetting] = Field(
        default=None, alias="retSetting0", title="Inj1retSetting"
    )
    ret_setting1: Optional[Inj2Retsetting] = Field(
        default=None, alias="retSetting1", title="Inj2retSetting"
    )
    round1_inj_isolevel: Optional[FirstRoundInjIsoLevel] = Field(
        default=None,
        alias="Round1InjIsolevel",
        title="1st Round Inj Iso Level",
    )
    round2_inj_isolevel: Optional[SecondRoundInjIsoLevel] = Field(
        default=None,
        alias="Round2InjIsolevel",
        title="2nd Round Inj Iso Level",
    )
    scabbing: Optional[Scabbing] = Field(
        default=None, alias="Scabbing", title="Scabbing"
    )
    second_inj_recover: Optional[float] = Field(
        default=None, alias="SecondInjRecover", title="2nd Inj REcovery"
    )
    second_injection_iso_dura: Optional[str] = Field(
        default=None,
        alias="SecondInjectionIsoDuration",
        title="2nd Round Inj Iso Duration",
    )
    second_injection_weight_a: Optional[str] = Field(
        default=None,
        alias="SecondInjectionWeightAfter",
        title="2nd Round Inj Weight After",
    )
    second_injection_weight_b: Optional[str] = Field(
        default=None,
        alias="SecondInjectionWeightBefore",
        title="2nd Round Inj Weight Before",
    )
    second_round_ionto_issue: Optional[SecondRoundIontoIssue] = Field(
        default=None,
        alias="SecondRoundIontoIssue",
        title="2nd Round Ionto Issue",
    )
    sex: Optional[Sex] = Field(default=None, alias="Sex", title="Sex")
    st_round_injection_commen: Optional[str] = Field(
        default=None,
        alias="stRoundInjectionComments",
        title="1stRoundInjectionComments",
    )
    start_of_week: Optional[datetime] = Field(
        default=None, alias="Start_x0020_Of_x0020_Week", title="Start Of Week"
    )
    surgery_status: Optional[SurgeryStatus] = Field(
        default=None, alias="SurgeryStatus", title="Surgery Status"
    )
    title: Optional[str] = Field(default=None, alias="Title", title="Title")
    touch_up_comp: Optional[datetime] = Field(
        default=None,
        alias="Touch_x0020_Up_x0020__x0020_Comp",
        title="Touch Up  Completed",
    )
    touch_up_status: Optional[TouchUpStatus] = Field(
        default=None,
        alias="Touch_x0020_Up_x0020_Status",
        title="Touch Up Status",
    )
    touch_up_weight: Optional[str] = Field(
        default=None,
        alias="Touch_x0020_Up_x0020_Weight_x002",
        title="Touch Up Weight After",
    )
    ui_version_string: Optional[str] = Field(
        default=None, alias="_UIVersionString", title="Version"
    )
    virus_a_p: Optional[str] = Field(
        default=None, alias="Virus_x0020_A_x002f_P", title="Inj 1 A/P"
    )
    virus_d_v: Optional[str] = Field(
        default=None, alias="Virus_x0020_D_x002f_V", title="Inj 1 D/V"
    )
    virus_hemisphere: Optional[Inj1Hemisphere] = Field(
        default=None, alias="Virus_x0020_Hemisphere", title="Inj 1 Hemisphere"
    )
    virus_m_l: Optional[str] = Field(
        default=None, alias="Virus_x0020_M_x002f_L", title="Inj 1 M/L"
    )
    weight_after_surgery: Optional[str] = Field(
        default=None,
        alias="Weight_x0020_after_x0020_Surgery",
        title="HP Weight after",
    )
    weight_before_surger: Optional[str] = Field(
        default=None,
        alias="Weight_x0020_before_x0020_Surger",
        title="HP Weight before",
    )
    work_station1st_injection: Optional[FirstRoundInjWorkstation] = Field(
        default=None,
        alias="WorkStation1stInjection",
        title="1st Round Inj Workstation",
    )
    work_station2nd_injection: Optional[SecondRoundWorkstation] = Field(
        default=None,
        alias="WorkStation2ndInjection",
        title="2nd Round Workstation",
    )
