(self["webpackChunkipyxturtle"] = self["webpackChunkipyxturtle"] || []).push([["vendors-node_modules_xturtle_index_js"],{

/***/ "./node_modules/xturtle/assets/idle_turtle.png":
/*!*****************************************************!*\
  !*** ./node_modules/xturtle/assets/idle_turtle.png ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__webpack_require__.p + "23d3dc43a7ebe54f7dcbf2bc658de693.png");

/***/ }),

/***/ "./node_modules/xturtle/assets/turtle.png":
/*!************************************************!*\
  !*** ./node_modules/xturtle/assets/turtle.png ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__webpack_require__.p + "97466b07c2424184308f22f5928448ec.png");

/***/ }),

/***/ "./node_modules/xturtle/index.js":
/*!***************************************!*\
  !*** ./node_modules/xturtle/index.js ***!
  \***************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TurtleComponent": () => (/* reexport safe */ _src_turtle_component_js__WEBPACK_IMPORTED_MODULE_0__.TurtleComponent),
/* harmony export */   "Sprite": () => (/* reexport safe */ _src_turtle_component_js__WEBPACK_IMPORTED_MODULE_0__.Sprite)
/* harmony export */ });
/* harmony import */ var _src_turtle_component_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./src/turtle_component.js */ "./node_modules/xturtle/src/turtle_component.js");


customElements.define('x-turtle', _src_turtle_component_js__WEBPACK_IMPORTED_MODULE_0__.TurtleComponent);




/***/ }),

/***/ "./node_modules/xturtle/src/sprite.js":
/*!********************************************!*\
  !*** ./node_modules/xturtle/src/sprite.js ***!
  \********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Sprite)
/* harmony export */ });
/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils.js */ "./node_modules/xturtle/src/utils.js");


class Sprite {
  #rows
  #columns
  #image
  #frameWidth
  #frameHeight
  #currentFrame
  #maxFrame
  #canvas
  #spriteScale

  constructor(rows, columns, image, canvas, spriteScale) {
    this.#rows = rows;
    this.#columns = columns;
    this.#image = image;
    this.#frameWidth = image.width / columns;
    this.#frameHeight = image.height / rows;
    this.#currentFrame = 0;
    this.#maxFrame = columns * rows - 1;
    this.#canvas = canvas;
    this.#spriteScale = { width: this.frameWidth * spriteScale, height: this.frameHeight * spriteScale };

    this.#loadImage(image, spriteScale);
  }

  #loadImage(image, spriteScale) {
    let onloadFunction = () => {
      this.#image = image;
      this.#frameWidth = image.width / this.#columns;
      this.#frameHeight = image.height / this.#rows;
      this.#spriteScale = { width: this.#frameWidth * spriteScale, height: this.#frameHeight * spriteScale };
      this.#currentFrame = 0;
    }

    image.onload = onloadFunction;
    this.#reloadImage();
  }

  #reloadImage() {
    if (this.#image.complete && this.#image.naturalHeight !== 0) this.#image.onload();
  }

  setCanvas(canvas) {
    this.#canvas = canvas;
    this.#reloadImage();
  }

  async run(position) {
    if (!this.#canvas) return;

    this.#currentFrame++;

    if (this.#currentFrame > this.#maxFrame) {
      this.#currentFrame = 0;
    }

    let column = this.#currentFrame % this.#columns;
    let row = Math.floor(this.#currentFrame / this.#columns);

    this.#canvas.drawImage(
      this.#image,
      column * this.#frameWidth,
      row * this.#frameHeight,
      this.#frameWidth,
      this.#frameHeight,
      position.x - this.#getCenterOffset().width,
      position.y - this.#getCenterOffset().height,
      this.#spriteScale.width,
      this.#spriteScale.height
    );

    await (0,_utils_js__WEBPACK_IMPORTED_MODULE_0__.sleep)(1000 / this.#maxFrame)
  }

  #getCenterOffset() {
    return { width: (this.#spriteScale.width / 2), height: (this.#spriteScale.height / 2) }
  }
}


/***/ }),

/***/ "./node_modules/xturtle/src/turtle.js":
/*!********************************************!*\
  !*** ./node_modules/xturtle/src/turtle.js ***!
  \********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Turtle)
/* harmony export */ });
/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils.js */ "./node_modules/xturtle/src/utils.js");


const FULL_CIRCUNFERENCE_ANGLE = 360
const INVISIBLE_COLOR = 'rgb(0, 0, 0, 0)';

class Turtle {
  #position
  #angle
  #speed
  #actions
  #moving
  #width
  #height
  #color
  #penUp

  #backgroundCanvas
  #foregroundCanvas

  #idleSprite
  #moveSprite
  #spritePosition

  constructor(backgroundCanvas, foregroundCanvas, spriteIdle, spriteMoving, width, height) {
    this.#position = { x: 0, y: 0 }
    this.#angle = 0
    this.#speed = 1
    this.#moving = false;
    this.#penUp = false;
    this.#width = width;
    this.#height = height;
    this.#color = 'black';

    this.#backgroundCanvas = backgroundCanvas;
    this.#foregroundCanvas = foregroundCanvas;

    this.#idleSprite = spriteIdle
    this.#moveSprite = spriteMoving
    this.#spritePosition = { x: 0, y: 0 }

    this.#actions = []

    this.runTurtleActionsAndAnimation = this.runTurtleActionsAndAnimation.bind(this)
  }

  async runTurtleActionsAndAnimation() {
    const FPS = 33

    let delayUpdate = await this.#update()
    let delayDraw = await this.#spriteAnimation()

    let delayTotal = (FPS - ((delayUpdate + delayDraw) * 1000))

    if (delayTotal > 0) {
      await (0,_utils_js__WEBPACK_IMPORTED_MODULE_0__.sleep)(FPS - delayTotal)
    }
  }

  forward(distance) {
    this.#actions.push({ action: 'forwardAction', parameters: [distance] })
  }

  backward(value) {
    this.#actions.push({ action: 'forwardAction', parameters: [-value] })
  }

  setLineColor(color) {
    this.#actions.push({ action: 'setLineColorAction', parameters: [color] })
  }

  circle(radius, circumferenceAngle = FULL_CIRCUNFERENCE_ANGLE) {
    this.#actions.push({ action: 'circleAction', parameters: [radius, circumferenceAngle] })
  }

  rectangle(width, height) {
    this.#actions.push({ action: 'rectangleAction', parameters: [width, height] })
  }

  async #rectangleAction(width, height) {
    await this.#backgroundCanvas.rect(this.#position.x, this.#position.y, width, height);
  }

  speed(speed) {
    if (speed) this.#actions.push({ action: 'speedAction', parameters: [speed] });
    else return this.#speed;
  }

  async clear() {
    this.#foregroundCanvas.fillStyle = "rgba(0,0,0,1)";
    this.#foregroundCanvas.globalCompositeOperation = "destination-out";
  }

  turtleCommandsList(commands) {
    this.#actions = commands
  }

  right(value) {
    this.#actions.push({ action: 'rightAction', parameters: [value] })
  }

  setPosition(x, y) {
    this.#actions.push({ action: 'setPositionAction', parameters: [x, y] })
  }

  async getPosition() {
    while (this.#actions.length !== 0)
      await (0,_utils_js__WEBPACK_IMPORTED_MODULE_0__.sleep)(33)

    return this.#position
  }

  penUp() {
    this.#actions.push({ action: 'penUpAction', parameters: [] });
  }

  penDown() {
    this.#actions.push({ action: 'penDownAction', parameters: [] });
  }

  setLineWidth(width) {
    this.#actions.push({ action: 'setLineWidthAction', parameters: [width] });
  }

  // Private Methods

  async #update() {
    let t0 = performance.now()
    if (this.#actions.length) {
      await this.#runAction()
      this.#actions.splice(0, 1)
    }
    let t1 = performance.now()
    return t1 - t0
  }

  async #runAction() {
    switch(this.#actions[0].action) {
      case "forwardAction":
        await this.#forwardAction(...this.#actions[0].parameters)
        break;
      case "setLineColorAction":
        await this.#setLineColorAction(...this.#actions[0].parameters)
        break;
      case "circleAction":
        await this.#circleAction(...this.#actions[0].parameters)
        break;
      case "rectangleAction":
        await this.#rectangleAction(...this.#actions[0].parameters)
        break;
      case "speedAction":
        this.#speedAction(...this.#actions[0].parameters)
        break;
      case "leftAction":
        await this.#leftAction(...this.#actions[0].parameters)
        break;
      case "rightAction":
        await this.#rightAction(...this.#actions[0].parameters)
        break;
      case "setPositionAction":
        await this.#setPositionAction(...this.#actions[0].parameters)
        break;
      case "penUpAction":
        await this.#penUpAction(...this.#actions[0].parameters)
        break;
      case "penDownAction":
        await this.#penDownAction(...this.#actions[0].parameters)
        break;
      case "setLineWidthAction":
        await this.#setLineWidthAction(...this.#actions[0].parameters)
        break;
    }
  }

  async #forwardAction(distance) {
    this.#backgroundCanvas.beginPath();

    this.#moving = true;
    distance = parseInt(distance)

    let displacement = null;
    const FPS = 66

    while (distance) {
      if (Math.abs(distance) < this.#speed / 10 * FPS) {
        displacement = distance;
      }
      else {
        if (distance > 0) {
          displacement = Math.round(this.#speed / 10 * FPS)
        }
        else {
          displacement = Math.round(this.#speed / 10 * FPS) * -1
        }
      }

      this.#backgroundCanvas.moveTo(this.#position.x, this.#position.y);

      this.#position = (0,_utils_js__WEBPACK_IMPORTED_MODULE_0__.positionWithAngle)(this.#angle, displacement, this.#position)
      this.#spritePosition.x += displacement;
      this.#backgroundCanvas.lineTo(this.#position.x, this.#position.y);

      this.#backgroundCanvas.stroke();
      this.#spriteAnimation();

      distance -= displacement

      await (0,_utils_js__WEBPACK_IMPORTED_MODULE_0__.sleep)(FPS);
    }
    this.#moving = false;
  }

  async #setLineColorAction(color) {
    this.#color = color;

    if (!this.#penUp) {
      this.#backgroundCanvas.beginPath();
      this.#backgroundCanvas.strokeStyle = color;
    }
  }

  async #circleAction(radius, circumferenceAngle) {
    this.#backgroundCanvas.beginPath();

    let circumferenceStartAngle = this.#angle
    let circumferenceEndAgnle = circumferenceAngle+this.#angle

    if(circumferenceAngle < 0) {
      circumferenceStartAngle = circumferenceAngle+this.#angle
      circumferenceEndAgnle = this.#angle
    }

    this.#backgroundCanvas.arc(this.#position.x, this.#position.y, radius, (0,_utils_js__WEBPACK_IMPORTED_MODULE_0__.angleInRadians)(circumferenceStartAngle), (0,_utils_js__WEBPACK_IMPORTED_MODULE_0__.angleInRadians)(circumferenceEndAgnle));
  }

  async #speedAction(speed) {
    this.#speed = speed;
  }

  async #rightAction(value) {
    this.#rotateLine(value)
  }

  left(value) {
    this.#actions.push({ action: 'leftAction', parameters: [value] })
  }

  async #leftAction(value) {
    this.#rotateLine(-value)
  }

  async #rotateLine(value) {
    this.#angle += parseInt(value)

    while (this.angle >= 360)
      this.#angle = this.#angle - 360

    this.#rotateForegroundCanvas('right', value)
  }

  #rotateForegroundCanvas(direction, value) {
    if (direction == 'left')
      value *= -1

      this.#foregroundCanvas.translate(this.#spritePosition.x, this.#spritePosition.y);
      // this rotate works using the center of the canvas defined on translate as reference
      this.#foregroundCanvas.rotate((0,_utils_js__WEBPACK_IMPORTED_MODULE_0__.angleInRadians)(value))
      this.#foregroundCanvas.translate(-this.#spritePosition.x, -this.#spritePosition.y);
  }

  async #setPositionAction(x, y) {
    x = parseFloat(x)
    y = parseFloat(y)

    y = y * -1

    this.#backgroundCanvas.moveTo(x, y)
    this.#position = { x: x, y: y }

    this.#foregroundCanvas.setTransform(1, 0, 0, 1, this.#width * 0.5, this.#height * 0.5);
    this.#spritePosition = { x: x, y: y }
    this.#rotateForegroundCanvas("", this.#angle)
  }

  async #penDownAction() {
    this.#penUp = false;
    this.#backgroundCanvas.strokeStyle = this.color;
    this.#backgroundCanvas.beginPath();
    this.#backgroundCanvas.strokeStyle = this.#color;
  }

  async #penUpAction() {
    this.#penUp = true;
    this.#backgroundCanvas.strokeStyle = INVISIBLE_COLOR;
    this.#backgroundCanvas.beginPath();
  }

  async #setLineWidthAction(width) {
    this.#backgroundCanvas.lineWidth = width;
  }

  async #spriteAnimation() {
    var t0 = performance.now()
    this.#backgroundCanvas.stroke();

    // Implement a better clear thinkin in this magic numbers
    this.#foregroundCanvas.clearRect(
      this.#spritePosition.x - this.#width,
      this.#spritePosition.y - this.#height,
      this.#width * 3,
      this.#height * 3
    );

    if (this.#moving) {
      await this.#moveSprite.run(this.#spritePosition)
    }
    else {
      await this.#idleSprite.run(this.#spritePosition)
    }

    var t1 = performance.now()

    return t1 - t0
  }
}


/***/ }),

/***/ "./node_modules/xturtle/src/turtle_component.js":
/*!******************************************************!*\
  !*** ./node_modules/xturtle/src/turtle_component.js ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TurtleComponent": () => (/* binding */ TurtleComponent),
/* harmony export */   "Sprite": () => (/* reexport safe */ _sprite_js__WEBPACK_IMPORTED_MODULE_2__.default)
/* harmony export */ });
/* harmony import */ var _assets_idle_turtle_png__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../assets/idle_turtle.png */ "./node_modules/xturtle/assets/idle_turtle.png");
/* harmony import */ var _assets_turtle_png__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../assets/turtle.png */ "./node_modules/xturtle/assets/turtle.png");
/* harmony import */ var _sprite_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sprite.js */ "./node_modules/xturtle/src/sprite.js");
/* harmony import */ var _turtle_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./turtle.js */ "./node_modules/xturtle/src/turtle.js");





class TurtleComponent extends HTMLElement {
  #backgroundCanvas
  #parentDiv
  #forwardCanvas

  static get observedAttributes() {
    return ['width', 'height'];
  }

  constructor() {
    super()
    this.#parentDiv = document.createElement("div")
    this.#backgroundCanvas = document.createElement("canvas");
    this.#parentDiv.appendChild(this.#backgroundCanvas);
  }

  get width() {
    return this.getAttribute('width');
  }

  set width(value) {
    this.setAttribute('width', value);
  }

  get height() {
    return this.getAttribute('height');
  }

  set height(value) {
    this.setAttribute('height', value);
  }

  get canvasClass() {
    return this.getAttribute('canvas-class');
  }

  set canvasClass(value) {
    this.setAttribute('canvas-class', value);
  }

  connectedCallback() {
    if (!this.width) {
      this.width = 300;
    }
    if (!this.height) {
      this.height = 300;
    }
    if (!this.canvasClass) {
      this.canvasClass = "border: solid 1px black;";
    }

    this.initializeCanvas();
  }

  initializeCanvas(parent = document.body, parentDivStyle = "position: relative;") {
    this.#backgroundCanvas.width = this.width
    this.#backgroundCanvas.height = this.height
    this.#backgroundCanvas.style = "position: absolute !important"
    this.#backgroundCanvas.className = this.canvasClass
    this.#parentDiv.style = parentDivStyle

    this.#backgroundCanvas.getContext("2d").translate(this.#backgroundCanvas.width * 0.5,
                                                      this.#backgroundCanvas.height * 0.5);

    parent.appendChild(this.#parentDiv);
  }

  attributeChangedCallback(name, oldVal, newVal) {
    if (oldVal !== newVal) {
      switch (name) {
        case 'width':
          this.width = newVal;
          break;
        case 'height':
          this.height = newVal;
          break;
        case 'canvas-class':
          this.canvasClass = newVal
          break;
      }
    }
  }

  async #update(turtle){
    while(true) {
      await turtle.runTurtleActionsAndAnimation();
    }
  }

  #buildForwardCanvas() {
    let foregroundCanvas = document.createElement("canvas");
    foregroundCanvas.style = "position: absolute;"
    this.#parentDiv.appendChild(foregroundCanvas);
    let foregroundCanvasContext = foregroundCanvas.getContext("2d")

    foregroundCanvas.width = this.width
    foregroundCanvas.height = this.height

    foregroundCanvasContext.translate(
      foregroundCanvas.width * 0.5,
      foregroundCanvas.height * 0.5
    );

    return foregroundCanvasContext
  }

  #idleSprite(idleSprite, forwardCanvas) {
    idleSprite = new Image();
    idleSprite.src = _assets_idle_turtle_png__WEBPACK_IMPORTED_MODULE_0__.default;

    return new _sprite_js__WEBPACK_IMPORTED_MODULE_2__.default(1, 10, idleSprite, forwardCanvas, 0.2);
  }

  #moveSprite(moveSprite, forwardCanvas) {
    moveSprite = new Image();
    moveSprite.src = _assets_turtle_png__WEBPACK_IMPORTED_MODULE_1__.default;

    return new _sprite_js__WEBPACK_IMPORTED_MODULE_2__.default(1, 8, moveSprite, forwardCanvas, 0.2);
  }

  buildSprite(rows, colums, image, scale) {
    return new _sprite_js__WEBPACK_IMPORTED_MODULE_2__.default(rows, colums, image, null, scale);
  }

  createTurtle(idleSprite = null, moveSprite = null) {
    let forwardCanvas = this.#buildForwardCanvas();

    if (idleSprite) idleSprite.setCanvas(forwardCanvas);
    if (moveSprite) moveSprite.setCanvas(forwardCanvas);

    let turtle = new _turtle_js__WEBPACK_IMPORTED_MODULE_3__.default(
      this.#backgroundCanvas.getContext("2d"),
      forwardCanvas,
      (idleSprite == null) ? this.#idleSprite(idleSprite, forwardCanvas) : idleSprite,
      (moveSprite == null) ? this.#moveSprite(moveSprite, forwardCanvas) : moveSprite,
      this.width,
      this.height
    );

    this.#update(turtle);

    return turtle;
  }

  getImageData(x, y, width, height) {
    return this.#backgroundCanvas.getContext('2d').getImageData(x, y, width, height);
  }
}




/***/ }),

/***/ "./node_modules/xturtle/src/utils.js":
/*!*******************************************!*\
  !*** ./node_modules/xturtle/src/utils.js ***!
  \*******************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "sleep": () => (/* binding */ sleep),
/* harmony export */   "angleInRadians": () => (/* binding */ angleInRadians),
/* harmony export */   "angleInDegrees": () => (/* binding */ angleInDegrees),
/* harmony export */   "positionWithAngle": () => (/* binding */ positionWithAngle)
/* harmony export */ });
function sleep(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}

function angleInRadians(angle) {
  return angle * Math.PI / 180
}

function angleInDegrees(angle) {
  return angle * (180 / Math.PI)
}

function positionWithAngle(angle, distance, position) {
  return {
    x: position.x + distance * (Math.cos(angleInRadians(angle))),
    y: position.y + distance * (Math.sin(angleInRadians(angle)))
  }
}


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_xturtle_index_js.2f164945a16dfa74cd72.js.map