/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.util.RB;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@SASScope
public class MapWithDefaults
implements Map {
    public static final String RB_KEY = "MapWithDefaults.";
    Map defaultMap;
    Map internalMap;

    public MapWithDefaults() {
    }

    public MapWithDefaults(Map defaultMap) {
        this();
        this.defaultMap = defaultMap;
    }

    public Map getDefaultMap() {
        return this.defaultMap;
    }

    public void setDefaultMap(Map defaultMap) {
        this.defaultMap = defaultMap;
    }

    public Map getInternalMap() {
        return this.acquireInternalMap();
    }

    public void setInternalMap(Map internalMap) {
        this.internalMap = internalMap;
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        if (this.internalMap != null) {
            this.internalMap.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) throws ClassCastException, NullPointerException {
        try {
            if (this.defaultMap != null && this.defaultMap.containsKey(key)) {
                return true;
            }
            return this.internalMap != null && this.internalMap.containsKey(key);
        }
        catch (ClassCastException cce) {
            throw new ClassCastException(RB.getStringResource(RB_KEY, "invalidType.txt"));
        }
        catch (NullPointerException npe) {
            throw new NullPointerException(RB.getStringResource(RB_KEY, "nullKey.txt"));
        }
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.defaultMap != null && this.defaultMap.containsValue(value)) {
            return true;
        }
        return this.internalMap != null && this.internalMap.containsValue(value);
    }

    public Set entrySet() {
        if (this.defaultMap != null && this.internalMap != null) {
            HashMap merged = new HashMap(this.defaultMap);
            merged.putAll(this.internalMap);
            return merged.entrySet();
        }
        if (this.defaultMap == null && this.internalMap != null) {
            return this.internalMap.entrySet();
        }
        if (this.defaultMap != null && this.internalMap == null) {
            return this.defaultMap.entrySet();
        }
        return new HashSet();
    }

    public Object get(Object key) throws ClassCastException, NullPointerException {
        try {
            Object o = null;
            if (this.internalMap != null) {
                o = this.internalMap.get(key);
            }
            if (o == null && this.defaultMap != null) {
                o = this.defaultMap.get(key);
            }
            return o;
        }
        catch (ClassCastException cce) {
            throw new ClassCastException(RB.getStringResource(RB_KEY, "invalidType.txt"));
        }
        catch (NullPointerException npe) {
            throw new NullPointerException(RB.getStringResource(RB_KEY, "nullKey.txt"));
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.defaultMap != null && !this.defaultMap.isEmpty()) {
            return false;
        }
        if (this.internalMap != null && !this.internalMap.isEmpty()) {
            return false;
        }
        if (this.internalMap != null && this.defaultMap != null && this.internalMap.isEmpty() && this.defaultMap.isEmpty()) {
            return true;
        }
        return true;
    }

    public Set keySet() {
        if (this.defaultMap != null && this.internalMap != null) {
            HashMap merged = new HashMap(this.defaultMap);
            merged.putAll(this.internalMap);
            return merged.keySet();
        }
        if (this.defaultMap != null && this.internalMap == null) {
            return this.defaultMap.keySet();
        }
        if (this.defaultMap == null && this.internalMap != null) {
            return this.internalMap.keySet();
        }
        return new HashSet();
    }

    @Override
    public int size() {
        if (this.defaultMap != null && this.internalMap != null) {
            HashMap merged = new HashMap(this.defaultMap);
            merged.putAll(this.internalMap);
            return merged.size();
        }
        if (this.defaultMap != null) {
            return this.defaultMap.size();
        }
        if (this.internalMap != null) {
            return this.internalMap.size();
        }
        return 0;
    }

    public Collection values() {
        if (this.defaultMap != null && this.internalMap != null) {
            HashMap merged = new HashMap(this.defaultMap);
            merged.putAll(this);
            return merged.values();
        }
        if (this.defaultMap != null) {
            return this.defaultMap.values();
        }
        if (this.internalMap != null) {
            return this.internalMap.values();
        }
        return new HashSet();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Map)) {
            return false;
        }
        if (this.defaultMap != null && this.internalMap != null) {
            HashMap merged = new HashMap(this.defaultMap);
            merged.putAll(this.internalMap);
            return ((Object)merged.entrySet()).equals(((Map)o).entrySet());
        }
        if (this.defaultMap != null) {
            return ((Object)this.defaultMap.entrySet()).equals(((Map)o).entrySet());
        }
        if (this.internalMap != null) {
            return ((Object)this.internalMap.entrySet()).equals(((Map)o).entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.defaultMap != null && this.internalMap != null) {
            HashMap merged = new HashMap(this.defaultMap);
            merged.putAll(this.internalMap);
            return merged.hashCode();
        }
        if (this.defaultMap != null) {
            return ((Object)this.defaultMap).hashCode();
        }
        if (this.internalMap != null) {
            return ((Object)this.internalMap).hashCode();
        }
        return 0;
    }

    public String toString() {
        if (this.defaultMap != null && this.internalMap != null) {
            HashMap merged = new HashMap(this.defaultMap);
            merged.putAll(this.internalMap);
            return merged.toString();
        }
        if (this.defaultMap != null) {
            return this.defaultMap.toString();
        }
        if (this.internalMap != null) {
            return this.internalMap.toString();
        }
        return "";
    }

    public Object put(Object key, Object value) throws UnsupportedOperationException, ClassCastException, IllegalArgumentException, NullPointerException {
        return this.acquireInternalMap().put(key, value);
    }

    public void putAll(Map t) throws UnsupportedOperationException, ClassCastException, IllegalArgumentException, NullPointerException {
        this.acquireInternalMap().putAll(t);
    }

    public Object remove(Object o) throws UnsupportedOperationException {
        if (this.internalMap != null) {
            return this.internalMap.remove(o);
        }
        return null;
    }

    private Map acquireInternalMap() {
        if (this.internalMap == null) {
            this.internalMap = new HashMap(8, 1.0f);
        }
        return this.internalMap;
    }
}

