/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.util;

import com.sas.codepolicy.SASScope;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

@SASScope
public class WriterHandler
extends Handler {
    private Writer writer;
    private Level level;
    private Filter filter;
    private Formatter formatter;
    private boolean closed;
    protected boolean sealed = false;

    public WriterHandler(Writer newWriter) {
        this(newWriter, null);
    }

    public WriterHandler(Writer newWriter, Formatter newFormatter) {
        this.configure();
        if (newWriter == null) {
            throw new NullPointerException("\"newWriter\" cannot be null.");
        }
        this.writer = newWriter;
        if (newFormatter != null) {
            this.setFormatter(newFormatter);
        }
        this.sealed = true;
        this.writeHead();
    }

    @Override
    public synchronized void close() {
        this.checkState();
        this.checkControlAccess();
        try {
            Formatter formatter = this.getFormatter();
            String tail = formatter.getTail(this);
            if (tail != null && tail.length() > 0) {
                this.writer.write(tail);
            }
        }
        catch (Exception e) {
            this.reportError("An exception was thrown while writing the tail.", e, 1);
        }
        this.doFlush();
        try {
            this.writer.close();
        }
        catch (Exception e) {
            this.reportError(null, e, 3);
        }
        this.closed = true;
    }

    @Override
    public synchronized void flush() {
        this.checkState();
        this.checkControlAccess();
        this.doFlush();
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        this.checkState();
        if (!this.isLoggable(logRecord)) {
            return;
        }
        String message = null;
        try {
            Formatter formatter = this.getFormatter();
            message = formatter.format(logRecord);
        }
        catch (Exception e) {
            this.reportError(null, e, 5);
            return;
        }
        try {
            this.writer.write(message);
        }
        catch (Exception e) {
            this.reportError(null, e, 1);
            return;
        }
        this.doFlush();
    }

    @Override
    public void setLevel(Level newLevel) {
        this.checkControlAccess();
        if (newLevel == null) {
            throw new IllegalArgumentException("\"newLevel\" cannot be null.");
        }
        this.level = newLevel;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public void setFilter(Filter newFilter) {
        this.checkControlAccess();
        if (newFilter == null) {
            throw new IllegalArgumentException("\"newFilter\" cannot be null.");
        }
        this.filter = newFilter;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFormatter(Formatter newFormatter) {
        this.checkControlAccess();
        if (newFormatter == null) {
            throw new IllegalArgumentException("\"newFormatter\" cannot be null.");
        }
        this.formatter = newFormatter;
    }

    @Override
    public Formatter getFormatter() {
        return this.formatter;
    }

    @Override
    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
    }

    @Override
    public String getEncoding() {
        return null;
    }

    private void configure() {
        String formatterName;
        String cname;
        LogManager manager = LogManager.getLogManager();
        String levelName = manager.getProperty((cname = WriterHandler.class.getName()) + ".level");
        if (levelName != null && levelName.length() > 0) {
            Level newLevel = Level.parse(levelName);
            this.setLevel(newLevel);
        } else {
            this.setLevel(Level.ALL);
        }
        String filterName = manager.getProperty(cname + ".filter");
        if (filterName != null && filterName.length() > 0) {
            Filter newFilter = (Filter)this.objectForName(filterName);
            this.setFilter(newFilter);
        }
        if ((formatterName = manager.getProperty(cname + ".formatter")) != null && formatterName.length() > 0) {
            Formatter newFormatter = (Formatter)this.objectForName(formatterName);
            this.setFormatter(newFormatter);
        } else {
            this.setFormatter(new SimpleFormatter());
        }
    }

    private Object objectForName(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            return clazz.newInstance();
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("An exception was thrown while instantiating class " + name + ".");
            iae.initCause(e);
            throw iae;
        }
    }

    private void writeHead() {
        Formatter formatter = this.getFormatter();
        try {
            String head = formatter.getHead(this);
            if (head != null && head.length() > 0) {
                this.writer.write(head);
            }
        }
        catch (Exception e) {
            this.reportError("An exception was thrown while writing the head.", e, 1);
        }
    }

    private void checkState() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    private void checkControlAccess() {
        if (this.sealed) {
            LogManager.getLogManager().checkAccess();
        }
    }

    private void doFlush() {
        try {
            this.writer.flush();
        }
        catch (Exception e) {
            this.reportError(null, e, 2);
        }
    }
}

