/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDateType;
import com.sas.datatypes.CollectionType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.IntegerType;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

@SASScope
public class DataTypeUtil {
    private static Map formatCache = null;
    public static final String DATE_FORMATS = "DATE";
    public static final String TIME_FORMATS = "TIME";
    public static final String TIMESTAMP_FORMATS = "TIMESTAMP";

    public static DataTypeInterface getContainedDataType(DataTypeInterface dataType) {
        if (dataType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)dataType;
            return DataTypeUtil.getContainedDataType(collectionType.getTypeOfData());
        }
        return dataType;
    }

    public static Date convertDateToTimeZone(Date date, TimeZone inputTimeZone, TimeZone outputTimeZone, Locale locale) {
        if (date == null) {
            return date;
        }
        GregorianCalendar inputGC = inputTimeZone != null && locale != null ? new GregorianCalendar(inputTimeZone, locale) : (locale != null ? new GregorianCalendar(locale) : (inputTimeZone != null ? new GregorianCalendar(inputTimeZone) : new GregorianCalendar()));
        inputGC.setTime(date);
        GregorianCalendar outputGC = outputTimeZone != null && locale != null ? new GregorianCalendar(outputTimeZone, locale) : (locale != null ? new GregorianCalendar(locale) : (outputTimeZone != null ? new GregorianCalendar(outputTimeZone) : new GregorianCalendar()));
        outputGC.set(1, inputGC.get(1));
        outputGC.set(2, inputGC.get(2));
        outputGC.set(5, inputGC.get(5));
        outputGC.set(11, inputGC.get(11));
        outputGC.set(12, inputGC.get(12));
        outputGC.set(13, inputGC.get(13));
        outputGC.set(14, inputGC.get(14));
        return outputGC.getTime();
    }

    public static Calendar getCalendar(TimeZone timeZone, Locale locale) {
        Calendar cal = null;
        cal = timeZone != null ? Calendar.getInstance(timeZone, locale) : Calendar.getInstance(locale);
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        return cal;
    }

    public static String getDefaultPatternNameForDataType(DataTypeInterface dataType) {
        if (dataType instanceof BaseDateType) {
            return ((BaseDateType)dataType).getDefaultFormatName() + ".";
        }
        if (dataType instanceof IntegerType) {
            return "BEST32.";
        }
        return null;
    }

    public static String getPersistenceString(DataTypeInterface dataType, Object value) {
        if (dataType instanceof CollectionType) {
            return dataType.getValueAsString(value, Locale.US);
        }
        return dataType.getPersistanceString(value);
    }

    static {
        formatCache = Collections.synchronizedMap(new LinkedHashMap(1000, 0.75f, true));
    }
}

