/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class ContentsChangedListenerList
implements Serializable,
ContentsChangedListener {
    static final long serialVersionUID = 3333148294274840633L;
    private int numberOfListeners;
    private ContentsChangedListener[] listenerList;
    private static ContentsChangedListener[] emptyListenerList;
    private ContentsChangedListener[] listeners;
    private int increment;
    private static final int DEFAULT_INCREMENT = 8;
    private boolean reThrowExceptions;
    private boolean logExceptions;

    public ContentsChangedListenerList() {
        this(8, true, false);
    }

    public ContentsChangedListenerList(int initialIncrement, boolean logExceptions, boolean reThrowExceptions) {
        this.increment = initialIncrement <= 0 ? 8 : initialIncrement;
        this.logExceptions = logExceptions;
        this.reThrowExceptions = reThrowExceptions;
    }

    public ContentsChangedListenerList(int initialIncrement) {
        this(initialIncrement, true, false);
    }

    public int count() {
        return this.numberOfListeners;
    }

    public void setExceptionLoggingEnabled(boolean logExceptions) {
        this.logExceptions = logExceptions;
    }

    public boolean isExceptionLoggingEnabled() {
        return this.logExceptions;
    }

    protected void handleException(RuntimeException exception) {
        if (this.isExceptionLoggingEnabled()) {
            System.err.println(exception.getMessage());
            exception.printStackTrace(System.err);
        }
        if (this.isExceptionReThrown()) {
            throw exception;
        }
    }

    public void setExceptionReThrown(boolean reThrow) {
        this.reThrowExceptions = reThrow;
    }

    public boolean isExceptionReThrown() {
        return this.reThrowExceptions;
    }

    private int indexOf(ContentsChangedListener listener) {
        if (this.listenerList != null) {
            for (int i = 0; i < this.numberOfListeners; ++i) {
                if (this.listenerList[i] != listener) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized void add(ContentsChangedListener listener) {
        if (listener == null) {
            return;
        }
        if (this.indexOf(listener) != -1) {
            return;
        }
        this.listeners = null;
        if (this.listenerList == null || this.numberOfListeners >= this.listenerList.length) {
            if (this.numberOfListeners > 4 * this.increment) {
                this.increment *= 2;
            }
            ContentsChangedListener[] newListenerList = new ContentsChangedListener[this.numberOfListeners + this.increment];
            if (this.listenerList != null) {
                System.arraycopy(this.listenerList, 0, newListenerList, 0, this.numberOfListeners);
            }
            this.listenerList = newListenerList;
        }
        this.listenerList[this.numberOfListeners++] = listener;
    }

    public synchronized ContentsChangedListener[] getListeners() {
        if (this.listeners == null) {
            if (this.numberOfListeners > 0) {
                this.listeners = new ContentsChangedListener[this.numberOfListeners];
                System.arraycopy(this.listenerList, 0, this.listeners, 0, this.numberOfListeners);
            } else {
                if (emptyListenerList == null) {
                    emptyListenerList = new ContentsChangedListener[0];
                }
                return emptyListenerList;
            }
        }
        return this.listeners;
    }

    public synchronized void remove(ContentsChangedListener listener) {
        int index = this.indexOf(listener);
        if (index == -1) {
            return;
        }
        this.listeners = null;
        --this.numberOfListeners;
        if (this.numberOfListeners == 0) {
            if (emptyListenerList == null) {
                emptyListenerList = new ContentsChangedListener[0];
            }
            this.listenerList = null;
            return;
        }
        this.listenerList[index] = null;
        while (index < this.numberOfListeners) {
            this.listenerList[index++] = this.listenerList[index];
        }
    }

    @Override
    public void contentsChanged(ContentsChangedEvent event) {
        if (this.numberOfListeners == 0) {
            return;
        }
        for (ContentsChangedListener listener : this.getListeners()) {
            try {
                listener.contentsChanged(event);
            }
            catch (RuntimeException exception) {
                this.handleException(exception);
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.numberOfListeners == 0) {
            this.listenerList = null;
        }
    }
}

