"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceHandler = void 0;
// eslint-disable-next-line import/no-extraneous-dependencies
const aws = require("aws-sdk");
class ResourceHandler {
    constructor(eks, event) {
        this.eks = eks;
        this.requestType = event.RequestType;
        this.requestId = event.RequestId;
        this.logicalResourceId = event.LogicalResourceId;
        this.physicalResourceId = event.PhysicalResourceId;
        this.event = event;
        const roleToAssume = event.ResourceProperties.AssumeRoleArn;
        if (!roleToAssume) {
            throw new Error('AssumeRoleArn must be provided');
        }
        eks.configureAssumeRole({
            RoleArn: roleToAssume,
            RoleSessionName: `AWSCDK.EKSCluster.${this.requestType}.${this.requestId}`,
        });
        const proxyAddress = this.httpProxyFromEnvironment();
        if (proxyAddress) {
            this.log(`Using proxy server: ${proxyAddress}`);
            // eslint-disable-next-line @typescript-eslint/no-require-imports, import/no-extraneous-dependencies
            const ProxyAgent = require('proxy-agent');
            aws.config.update({
                httpOptions: { agent: new ProxyAgent(proxyAddress) },
            });
        }
    }
    onEvent() {
        switch (this.requestType) {
            case 'Create': return this.onCreate();
            case 'Update': return this.onUpdate();
            case 'Delete': return this.onDelete();
        }
        throw new Error(`Invalid request type ${this.requestType}`);
    }
    isComplete() {
        switch (this.requestType) {
            case 'Create': return this.isCreateComplete();
            case 'Update': return this.isUpdateComplete();
            case 'Delete': return this.isDeleteComplete();
        }
        throw new Error(`Invalid request type ${this.requestType}`);
    }
    log(x) {
        // eslint-disable-next-line no-console
        console.log(JSON.stringify(x, undefined, 2));
    }
    httpProxyFromEnvironment() {
        if (process.env.http_proxy) {
            return process.env.http_proxy;
        }
        if (process.env.HTTP_PROXY) {
            return process.env.HTTP_PROXY;
        }
        return undefined;
    }
}
exports.ResourceHandler = ResourceHandler;
//# sourceMappingURL=data:application/json;base64,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