---
title: Getting started
summary: How to get started with dcm2bids
authors:
  - Samuel Guay
date: 2022-04-17
---

# Getting started with dcm2bids

## How to get the most out of the documentation

Our documentation is organized in 4 main parts and each fulfills a different
function:

1.  **[Installation][installation]**: A beginner-friendly guide that walks
    through the installation process, including the creation of a dedicated
    environment.
    <!-- prettier-ignore-start -->
    - TL;DR: Run `conda install -c conda-forge dcm2bids` or
    `pip install dcm2bids` within your project environment.
    <!-- prettier-ignore-end -->
2.  **[Tutorials][tutorial]**: Aimed at beginners and people new to dcm2bids,
    the tutorials are a series of steps that describes in length how to use
    dcm2bids in order to understand how dcm2bids works.
3.  **[How-to guides][how-to]**: Analogous to recipes, these guides provides
    series of steps to address typical problems and use-cases when converting
    into BIDS. They are less verbose than tutorials and assume some
    understanding of BIDS-related concepts and how dcm2bids works.
    <!-- prettier-ignore-start -->
    - There is an exception worth reading by anyone: [How-to Get help and
    support][get-help]
    <!-- prettier-ignore-end -->
4.  **[Technical reference][reference]**: Automated rendering of the code that
    composes the inner machinery of dcm2bids.

[installation]: ./install.md
[tutorial]: ../tutorial/first-steps.md
[how-to]: ../how-to
[reference]: /reference/dcm2bids
[get-help]: ../how-to/get-help.md
