from ApiMethod import ApiMethod


class Widgets(ApiMethod):
    def __init__(self, access_token, v, session, calls_per_second):
        super(Widgets, self).__init__(access_token, v, session, calls_per_second)
        self._base_method = 'widgets.'

    def getComments(self, widget_api_id: str = None, url: str = None, page_id: str = None, order: str = None,
                    fields: str = None, offset: str = None, count: str = None) -> dict:
        """
        Получает список комментариев к странице, оставленных через Виджет комментариев.

        :param widget_api_id: Идентификатор приложения/сайта, с которым инициализируются виджеты.
        :param url: URL-адрес страницы.
        :param page_id: внутренний идентификатор страницы в приложении/сайте (в случае, если для инициализации
            виджетов использовался параметр page_id).
        :param order: тип сортировки комментариев. Возможные значения: date, likes, last_comment. Значение по
            умолчанию - date.
        :param fields: перечисленные через запятую поля анкет необходимые для получения. Если среди полей
            присутствует replies, будут возвращены последние комментарии второго уровня для каждого комментария
            первого уровня.
        :param offset: смещение необходимое для выборки определенного подмножества комментариев. По умолчанию 0.
        :param count: количество возвращаемых записей.

        :return: В случае успеха возвращает объект со следующими полями:   count — общее количество комментариев
            первого уровня к странице (без учета ограничений из входного параметра count).  posts — список
            комментариев первого уровня. Каждый элемент списка имеет структуру, схожую с объектами post из
            результатов метода wall.get. Помимо этого:   В случае, если среди необходимых полей было указано replies,
            в поле comments.replies будет содержаться список комментариев второго уровня. Каждый элемент этого списка
            имеет структуру, схожую с объектами comment из результатов метода wall.getComments.  В случае, если были
            указаны любые другие необходимые поля анкет, в каждом элементе post и comment будет поле user, содержащее
            соответствующую информацию об авторе комментария
        """

        params = locals()
        method_name = self._base_method + 'getComments'
        return self._call(method_name, params)

    def getPages(self, widget_api_id: str = None, order: str = None, period: str = None, offset: str = None,
                 count: str = None) -> dict:
        """
        Получает список страниц приложения/сайта, на которых установлен Виджет комментариев или «Мне нравится».

        :param widget_api_id: идентификатор приложения/сайта, с которым инициализируются виджеты.
        :param order: Тип сортировки страниц. Возможные значения: date, comments, likes, friend_likes.
        :param period: Период выборки. Возможные значения: day, week, month, alltime.
        :param offset: смещение необходимое для выборки определенного подмножества комментариев. По умолчанию 0.
        :param count: количество возвращаемых записей.

        :return: В случае успеха возвращает объект со следующими полями:   count — общее количество страниц (без
            учета ограничений входного параметра count)  pages — список объектов-страниц Каждый объект, описывающий
            страницу, имеет следующие поля:   id — идентификатор страницы в системе;  title — заголовок страницы
            (берется из мета-тегов на странице или задается параметром pageTitle при инициализации)  description —
            краткое описание страницы (берется из мета-тегов на странице или задается параметром pageDescription при
            инициализации);  photo — объект, содержащий фотографию-миниатюру страницы (берется из мета-тегов на
            странице или задается параметром pageImage при инициализации)  url — абсолютный адрес страницы;  likes —
            объект, содержащий поле count — количество отметок «Мне нравится» к странице. Для получения списка
            пользователей, отметивших страницу можно использовать метод likes.getList с параметром type равным
            site_page;  comments — объект, содержащий поле count — количество комментариев к странице внутри виджета.
            Для получения списка комментариев можно использовать метод widgets.getComments;  date — дата первого
            обращения к виджетам на странице  page_id — внутренний идентификатор страницы в приложении/на сайте (в
            случае, если при инициализации виджетов использовался параметр page_id)
        """

        params = locals()
        method_name = self._base_method + 'getPages'
        return self._call(method_name, params)
