from ApiMethod import ApiMethod


class Search(ApiMethod):
    def __init__(self, access_token, v, session, calls_per_second):
        super(Search, self).__init__(access_token, v, session, calls_per_second)
        self._base_method = 'search.'

    def getHints(self, q: str = None, offset: str = None, limit: str = None, filters: str = None, fields: str = None,
                 search_global: str = None) -> dict:
        """
        Метод позволяет получить результаты быстрого поиска по произвольной подстроке

        :param q: текст запроса, результаты которого нужно получить
        :param offset: смещение для выборки определённого подмножества результатов.
        :param limit: ограничение на количество возвращаемых результатов.
        :param filters: Перечисленные через запятую типы данных, которые необходимо вернуть. Возможные значения:
            friends – друзья пользователя;  idols – подписки пользователя;  publics – публичные страницы, на которые
            подписан пользователь;  groups – группы пользователя;  events – встречи пользователя;  correspondents –
            люди, с которыми пользователь имеет переписку;  mutual_friends – люди, у которых есть общие друзья с
            текущим пользователем (этот фильтр позволяет получить не всех пользователей, имеющих общих друзей).    По
            умолчанию возвращаются все.
        :param fields: дополнительные поля профилей и сообществ для получения.
        :param search_global: 1 — к результатам поиска добавляются результаты глобального поиска по всем
            пользователям и группам.

        :return: После успешного выполнения возвращает массив объектов, каждый из которых содержит стандартные
            поля type, section, description и соответствующий объект с набором дополнительных полей.  type integerтип
            объекта. Возможные значения:   group — сообщество;  profile — профиль.   group (для type = group)
            objectданные о сообществе. Объект, который содержит поля:   id (integer) — идентификатор сообщества;
            name (string) — название сообщества;  screen_name (string) — короткий адрес;  is_closed (integer) —
            информация о том, является ли группа/встреча закрытой (0 — открытая, 1 — закрытая, 2 — частная);
            is_admin (integer, [0,1]) — информация о том, является ли текущий пользователь администратором сообщества
            (1 — является, 0 — не является);  is_member (integer, [0,1]) — информация о том, является ли текущий
            пользователь участником сообщества (1 — является, 0 — не является);  type (string) — тип сообщества.
            Возможные значения:   group — группа;  page — публичная страница;  event — встреча);   photo (string) —
            URL квадратной фотографии сообщества с размером 50х50px;  photo_medium (string) — URL квадратной
            фотографии сообщества с размером 100х100px;  photo_big (string) — URL фотографии сообщества в
            максимальном доступном размере. profile (для type = profile) objectданные о профиле. Объект, который
            содержит поля:   id (integer) — идентификатор пользователя;  first_name (string) — имя пользователя;
            last_name (string) — фамилия пользователя. section  stringтип объекта. Возможные значения для сообществ:
            groups — группы;  events — мероприятия;  publics — публичные страницы.  Возможные значения для профилей:
            correspondents — собеседники по переписке;  people — популярные пользователи;  friends — друзья;
            mutual_friends — пользователи, имеющие общих друзей с текущим. description  stringописание объекта (для
            сообществ — тип и число участников, например, Group, 269,136 members, для профилей друзей или
            пользователями, которые не являются возможными друзьями — название университета или город, для профиля
            текущего пользователя — That's you, для профилей возможных друзей — N mutual friends). global  integer,
            [1]поле возвращается, если объект был найден в глобальном поиске, всегда содержит 1
        """

        params = locals()
        method_name = self._base_method + 'getHints'
        return self._call(method_name, params)

