from ApiMethod import ApiMethod


class Newsfeed(ApiMethod):
    def __init__(self, access_token, v, session, calls_per_second):
        super(Newsfeed, self).__init__(access_token, v, session, calls_per_second)
        self._base_method = 'newsfeed.'

    def addBan(self, user_ids: str = None, group_ids: str = None) -> dict:
        """
        Запрещает показывать новости от заданных пользователей и групп в ленте новостей текущего пользователя.

        :param user_ids: перечисленные через запятую идентификаторы друзей пользователя, новости от которых
            необходимо скрыть из ленты новостей текущего пользователя.
        :param group_ids: перечисленные через запятую идентификаторы групп пользователя, новости от которых
            необходимо скрыть из ленты новостей текущего пользователя.

        :return: После успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'addBan'
        return self._call(method_name, params)

    def deleteBan(self, user_ids: str = None, group_ids: str = None) -> dict:
        """
        Разрешает показывать новости от заданных пользователей и групп в ленте новостей текущего пользователя.

        :param user_ids: идентификаторы пользователей, новости от которых необходимо вернуть в ленту.
        :param group_ids: идентификаторы сообществ, новости от которых необходимо вернуть в ленту.

        :return: После успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'deleteBan'
        return self._call(method_name, params)

    def deleteList(self, list_id: str = None) -> dict:
        """
        Метод позволяет удалить пользовательский список новостей

        :param list_id: числовой идентификатор списка

        :return
        """

        params = locals()
        method_name = self._base_method + 'deleteList'
        return self._call(method_name, params)

    def get(self, filters: str = None, return_banned: str = None, start_time: str = None, end_time: str = None,
            max_photos: str = None, source_ids: str = None, start_from: str = None, count: str = None,
            fields: str = None, section: str = None) -> dict:
        """
        Возвращает данные, необходимые для показа списка новостей для текущего пользователя.

        :param filters: перечисленные через запятую названия списков новостей, которые необходимо получить. В
            данный момент поддерживаются следующие списки новостей:   post — новые записи со стен;  photo — новые
            фотографии;  photo_tag — новые отметки на фотографиях;  wall_photo — новые фотографии на стенах;  friend
            — новые друзья;  note — новые заметки;  audio — записи сообществ и друзей, содержащие аудиозаписи, а
            также новые аудиозаписи, добавленные ими;  video — новые видеозаписи.   Если параметр не задан, то будут
            получены все возможные списки новостей.
        :param return_banned: 1 - включить в выдачу также скрытых из новостей пользователей. 0 - не возвращать
            скрытых пользователей.
        :param start_time: время в формате unixtime, начиная с которого следует получить новости для текущего
            пользователя.
        :param end_time: время в формате unixtime, до которого следует получить новости для текущего
            пользователя. Если параметр не задан, то он считается равным текущему времени.
        :param max_photos: Максимальное количество фотографий, информацию о которых необходимо вернуть. По
            умолчанию: 5, максимальное значение: 100.
        :param source_ids: перечисленные через запятую иcточники новостей, новости от которых необходимо
            получить.  Идентификаторы пользователей можно указывать в форматах <uid> или u<uid> где <uid> —
            идентификатор друга пользователя.  Идентификаторы сообществ можно указывать в форматах -<gid> или g<gid>
            где <gid> — идентификатор сообщества.  Помимо этого параметр может принимать строковые значения:
            friends - список друзей пользователя  groups - список групп, на которые подписан текущий пользователь
            pages - список публичных страниц, на который подписан тeкущий пользователь  following - список
            пользователей, на которых подписан текущий пользователь  list{идентификатор списка новостей} - список
            новостей. Вы можете найти все списки новостей пользователя используя метод newsfeed.getLists   Если
            параметр не задан, то считается, что он включает список всех друзей и групп пользователя, за исключением
            скрытых источников, которые можно получить методом newsfeed.getBanned.  Максимальное число символов —
            5000.
        :param start_from: Идентификатор, необходимый для получения следующей страницы результатов. Значение,
            необходимое для передачи в этом параметре, возвращается в поле ответа next_from.
        :param count: указывает, какое максимальное число новостей следует возвращать, но не более 100. По
            умолчанию 50.
        :param fields: список дополнительных полей для профилей и групп, которые необходимо вернуть. См. описание
            полей объекта user и описание полей объекта group.
        :param section:

        :return: После успешного выполнения возвращает объект, содержащий следующие поля:   items — массив
            новостей для текущего пользователя;  profiles — информация о пользователях, которые находятся в списке
            новостей;  groups — информация о группах, которые находятся в списке новостей;  new_offset — содержит
            offset, который необходимо передать, для того, чтобы получить следующую часть новостей;  next_from —
            содержит start_from, который необходимо передать, для того, чтобы получить следующую часть новостей.
            Позволяет избавиться от дубликатов, которые могут возникнуть при появлении новых новостей между вызовами
            этого метода.    Описание поля items Поле items содержит массив объектов, каждый из которых соответствует
            одной новости в ленте. Каждый из объектов содержит поля:   type — тип списка новости, соответствующий
            одному из значений параметра filters;  source_id — идентификатор источника новости (положительный —
            новость пользователя, отрицательный — новость группы);  date — время публикации новости в формате
            unixtime;  post_id — находится в записях со стен и содержит идентификатор записи на стене владельца;
            post_type — находится в записях со стен, содержит тип новости (post или copy);  final_post — передается в
            случае, если этот пост сделан при удалении;  copy_owner_id — находится в записях со стен, если сообщение
            является копией сообщения с чужой стены, и содержит идентификатор владельца стены, у которого было
            скопировано сообщение;  copy_post_id — находится в записях со стен, если сообщение является копией
            сообщения с чужой стены, и содержит идентификатор скопированного сообщения на стене его владельца;
            copy_history — массив, содержащий историю репостов для записи. Возвращается только в том случае, если
            запись является репостом. Каждый из объектов массива, в свою очередь, является объектом-записью
            стандартного формата.  copy_post_date — находится в записях со стен, если сообщение является копией
            сообщения с чужой стены, и содержит дату скопированного сообщения;  text — находится в записях со стен и
            содержит текст записи;  can_edit — содержит 1, если текущий пользователь может редактировать запись;
            can_delete — возвращается, если пользователь может удалить новость, всегда содержит 1;  comments —
            находится в записях со стен и содержит информацию о комментариях к записи, содержит поля:   count —
            количество комментариев,  can_post — информация о том, может ли текущий пользователь комментировать
            запись  (1 — может, 0 — не может);   likes — находится в записях со стен и содержит информацию о числе
            людей, которым понравилась данная запись, содержит поля:   count — число пользователей, которым
            понравилась запись,  user_likes — наличие отметки «Мне нравится» от текущего пользователя  (1 — есть, 0 —
            нет),  can_like — информация о том, может ли текущий пользователь поставить отметку «Мне нравится»  (1 —
            может, 0 — не может),  can_publish — информация о том, может ли текущий пользователь сделать репост
            записи  (1 — может, 0 — не может);   reposts — находится в записях со стен и содержит информацию о числе
            людей, которые скопировали данную запись на свою страницу, содержит поля:   count — число пользователей,
            сделавших репост;  user_reposted — наличие репоста от текущего пользователя (0 — нет, 1 — есть);
            attachments — находится в записях со стен и содержит массив объектов, которые прикреплены к текущей
            новости (фотография, ссылка и т.п.). Более подробная информация представлена на странице Описание поля
            attachments.  geo — находится в записях со стен, в которых имеется информация о местоположении, содержит
            поля:   place_id — идентификатор места;  title — название места;  type — тип места;  country_id —
            идентификатор страны;  city_id — идентификатор города;  address — строка с указанием адреса места в
            городе;  showmap — данный параметр указывается, если местоположение является прикреплённой картой.
            photos, photo_tags, notes, friends — находятся в объектах соответствующих типов (кроме записей со стен) и
            содержат информацию о количестве объектов и до 5 последних объектов, связанных с данной новостью.  Каждый
            из элементов массива в полях photos и photo_tags содержит поля:    id — идентификатор фотографии
            owner_id — идентификатор владельца фотографии  album_id — идентификатор альбома  src — адрес изображения
            для предпросмотра  src_big — адрес полноразмерного изображения  Каждый из элементов массива в поле notes
            содержит поля:   id — идентификатор заметки  owner_id — идентификатор владельца заметки  title —
            заголовок заметки  comments — количество комментариев к заметке  Каждый из элементов массива в поле
            friends содержит поля:   uid— идентификатор пользователя     Описание поля profiles Поле profiles
            содержит массив объектов пользователей с дополнительными полями:   photo — адрес фотографии пользователя
            размером 50x50px;  photo_medium_rec — адрес фотографии пользователя размером 100x100px;  screen_name —
            короткий адрес страницы пользователя (например, andrew или id6492).    Описание поля groups Поле groups
            содержит массив объектов сообществ, которые присутствуют в новостях.   Примечание Вы можете получить
            полный список фотографий, полученных с типом photo или photo_tag методом photos.get, указав параметры
            feed (дата события в поле date) и feed_type (тип события, photo или photo_tag) и uid — идентификатор
            пользователя, с которым произошло событие (поле source_id)
        """

        params = locals()
        method_name = self._base_method + 'get'
        return self._call(method_name, params)

    def getBanned(self, extended: str = None, fields: str = None, name_case: str = None) -> dict:
        """
        Возвращает список пользователей и групп, которые текущий пользователь скрыл из ленты новостей.

        :param extended: если этот параметр равен 1, возвращается дополнительная информация о пользователях и
            группах
        :param fields: список дополнительных полей профилей, которые необходимо вернуть. См. подробное описание.
            Доступные значения: sex, bdate, city, country, photo_50, photo_100, photo_200_orig, photo_200,
            photo_400_orig, photo_max, photo_max_orig, online, online_mobile, domain, has_mobile, contacts,
            connections, site, education, universities, schools, can_post, can_see_all_posts, can_see_audio,
            can_write_private_message, status, last_seen, common_count, relation, relatives, counters, screen_name,
            maiden_name, timezone, occupation,activities, interests, music, movies, tv, books, games, about, quotes
        :param name_case: падеж для склонения имени и фамилии пользователя. Возможные значения: именительный –
            nom, родительный – gen, дательный – dat, винительный – acc, творительный – ins, предложный – abl. По
            умолчанию nom.

        :return: В случае успеха возвращает объект, в котором содержатся поля groups и members или profiles, в
            зависимости от параметра extended.  Если extended=0:   В поле groups содержится массив идентификаторов
            сообществ, которые пользователь скрыл из ленты новостей. В поле members содержится массив идентификаторов
            пользователей, которых пользователь скрыл из ленты новостей.   Если extended=1:   В поле groups
            содержится массив объектов с информацией о сообществах. В поле profiles содержится массив объектов с
            информацией о пользователях
        """

        params = locals()
        method_name = self._base_method + 'getBanned'
        return self._call(method_name, params)

    def getComments(self, count: str = None, filters: str = None, reposts: str = None, start_time: str = None,
                    end_time: str = None, last_comments_count: str = None, start_from: str = None,
                    fields: str = None) -> dict:
        """
        Возвращает данные, необходимые для показа раздела комментариев в новостях пользователя.

        :param count: указывает, какое максимальное число новостей следует возвращать, но не более 100. По
            умолчанию 30. Для автоподгрузки Вы можете использовать возвращаемый данным методом параметр new_offset.
        :param filters: перечисленные через запятую типы объектов, изменения комментариев к которым нужно
            вернуть. В данный момент поддерживаются следующие списки новостей:    post — новые комментарии к записям
            со стен;  photo — новые комментарии к фотографиям;  video — новые комментарии к видеозаписям;  topic —
            новые сообщения в обсуждениях;  market — новые комментарии к товарам;  note — новые комментарии к
            заметкам. Если параметр не задан, то будут получены все возможные списки новостей.
        :param reposts: Идентификатор объекта, комментарии к репостам которого необходимо вернуть, например
            wall1_45486. Если указан данный параметр, параметр filters указывать необязательно.
        :param start_time: время в формате unixtime, начиная с которого следует получить новости для текущего
            пользователя. Если параметр не задан, то он считается равным значению времени, которое было сутки назад.
        :param end_time: время в формате unixtime, до которого следует получить новости для текущего
            пользователя. Если параметр не задан, то он считается равным текущему времени.
        :param last_comments_count: количество комментариев к записям, которые нужно получить.
        :param start_from: Идентификатор, необходимый для получения следующей страницы результатов. Значение,
            необходимое для передачи в этом параметре, возвращается в поле ответа next_from.
        :param fields: список дополнительных полей профилей, которые необходимо вернуть. См. подробное описание.
            Доступные значения: sex, bdate, city, country, photo_50, photo_100, photo_200_orig, photo_200,
            photo_400_orig, photo_max, photo_max_orig, online, online_mobile, domain, has_mobile, contacts,
            connections, site, education, universities, schools, can_post, can_see_all_posts, can_see_audio,
            can_write_private_message, status, last_seen, common_count, relation, relatives, counters, screen_name,
            maiden_name, timezone, occupation,activities, interests, music, movies, tv, books, games, about, quotes

        :return: В случае успеха возвращает объект, содержащий поля:   items — содержит массив новостей для
            текущего пользователя  profiles — содержит информацию о пользователях, которые находятся в списке
            новостей  groups — содержит информацию о группах, которые находятся в списке новостей  next_from —
            содержит текстовое поле, которое необходимо передать при подгрузке следующего блока обсуждений
            Описание поля items Поле items содержит массив объектов, каждый из которых соответствует одной новости в
            ленте. Каждый из объектов содержит поля:   type — тип списка новости, соответствующий одному из значений
            параметра filters  source_id — идентификатор источника новости (положительный — новость пользователя,
            отрицательный — новость сообщества)  date — время публикации новости в формате unixtime  post_id —
            находится в записях со стен и содержит идентификатор записи на стене владельца  copy_owner_id — находится
            в записях со стен, если сообщение является копией сообщения с чужой стены, и содержит идентификатор
            владельца стены, у которого было скопировано сообщение  copy_post_id — находится в записях со стен, если
            сообщение является копией сообщения с чужой стены, и содержит идентификатор скопированного сообщения на
            стене его владельца  text — находится в записях со стен и содержит текст записи  comments — находится в
            записях со стен и содержит информацию о комментариях к записи, содержит поля:   count — количество
            комментариев,  can_post — информация о том, может ли текущий пользователь комментировать запись (1 —
            может, 0 — не может);   likes — находится в записях со стен и содержит информацию о числе людей, которым
            понравилась данная запись, содержит поля:   count — число пользователей, которым понравилась запись,
            user_likes — наличие отметки «Мне нравится» от текущего пользователя (1 — есть, 0 — нет),  can_like —
            информация о том, может ли текущий пользователь поставить отметку «Мне нравится» (1 — может, 0 — не
            может),  can_publish — информация о том, может ли текущий пользователь сделать репост записи (1 — может,
            0 — не может);   attachment — находится в записях со стен и содержит объект, который присоединен к
            текущей новости (фотография, ссылка и т.п.). Более подробная информация представлена на странице Описание
            поля attachment.  geo — находится в записях со стен, в которых имеется информация о местоположении,
            содержит поля:   place_id — идентификатор места;  title — название места;  type — тип места;  country_id
            — идентификатор страны;  city_id — идентификатор города;  address — строка с указанием адреса места в
            городе;  showmap — данный параметр указывается, если местоположение является прикреплённой картой.
            photos, photo_tags, notes, friends — находятся в объектах соответствующих типов (кроме записей со стен) и
            содержат информацию о количестве объектов и до 5 последних объектов, связанных с данной новостью.  Каждый
            из элементов массива в полях photos и photo_tags содержит поля:   id — идентификатор фотографии;
            owner_id — идентификатор владельца фотографии;  album_id — идентификатор альбома;  photo_* — адреса
            различных размеров изображений для фотографии (75, 130, 604, 807, 1280, 2560 px)  Каждый из элементов
            массива в поле notes содержит поля:   id — идентификатор заметки;  owner_id — идентификатор владельца
            заметки;  title — заголовок заметки;  ncom — количество комментариев к заметке.  Каждый из элементов
            массива в поле friends содержит единственное поле   uid — идентификатор пользователя.     Описание поля
            profiles Поле profiles содержит массив объектов с информацией о данных пользователей, которые
            присутствуют в новостях.  Каждый из объектов содержит поля:   id — идентификатор пользователя;
            first_name — имя пользователя;  last_name — фамилия пользователя;  photo — адрес фотографии пользователя
            размером 50x50 px.    Описание поля groups Поле groups содержит массив объектов с информацией о
            сообществах, которые присутствуют в новостях. Каждый из объектов содержит поля:   id — идентификатор
            сообщества;  name — название сообщества;  photo — адрес логотипа группы шириной 50px
        """

        params = locals()
        method_name = self._base_method + 'getComments'
        return self._call(method_name, params)

    def getLists(self, list_ids: str = None, extended: str = None) -> dict:
        """
        Возвращает пользовательские списки новостей.

        :param list_ids: идентификаторы списков.
        :param extended: 1 — вернуть дополнительную информацию о списке (значения source_ids и no_reposts).

        :return: Метод возвращает список объектов с полями:   id – идентификатор списка;  title – название
            списка, заданное пользователем.   Если был передан параметр extended=1, дополнительно возвращаются поля:
            no_reposts — отключены ли копии постов;  source_ids — идентификаторы пользователей и сообществ,
            включенных в список.   Новости по отдельному списку могут быть получены методом newsfeed.get с
            использованием параметра source_ids
        """

        params = locals()
        method_name = self._base_method + 'getLists'
        return self._call(method_name, params)

    def getMentions(self, owner_id: str = None, start_time: str = None, end_time: str = None, offset: str = None,
                    count: str = None) -> dict:
        """
        Возвращает список записей пользователей на своих стенах, в которых упоминается указанный пользователь.

        :param owner_id: идентификатор пользователя или сообщества.
        :param start_time: время в формате unixtime начиная с которого следует получать упоминания о
            пользователе.  Если параметр не задан, то будут возвращены все упоминания о пользователе, если не задан
            параметр end_time, в противном случае упоминания с учетом параметра end_time.
        :param end_time: время, в формате unixtime, до которого следует получать упоминания о пользователе.  Если
            параметр не задан, то будут возвращены все упоминания о пользователе, если не задан параметр start_time,
            в противном случае упоминания с учетом параметра start_time.
        :param offset: смещение, необходимое для выборки определенного подмножества новостей. По умолчанию 0.
        :param count: количество возвращаемых записей. Если параметр не задан, то считается, что он равен 20.
            Максимальное значение параметра 50.

        :return: В случае успеха возвращает количество записей и массив соответствующих им объектов, каждый из
            которых содержит следующие поля:   id — идентификатор записи на стене пользователя;  from_id —
            идентификатор пользователя, написавшего запись;  date — время публикаии записи в формате unixtime;  text
            — текст записи;  likes — содержит информацию о числе людей, которым понравилась данная запись, и
            понравилась ли она текущему пользователю;  comments — содержит информацию о количестве комментариев к
            записи и возможности текущего пользователя оставлять комментарии к ней;  attachment — содержит объект,
            который присоединен к текущей новости ( фотография, ссылка и т.п.). Более подробная информация
            представлена на странице Описание поля attachment;  geo — находится в записях со стен, в которых имеется
            информация о местоположении, содержит поля:   place_id — идентификатор места;  title — название места;
            type — тип места;  country_id — идентификатор страны;  city_id — идентификатор города;  address — строка
            с указанием адреса места в городе;  showmap — данный параметр указывается, если местоположение является
            прикреплённой картой.   copy_owner_id — если запись является копией записи с чужой стены, то в поле
            содержится идентификатор владельца стены у которого была скопирована запись;  copy_post_id — если запись
            является копией записи с чужой стены, то в поле содержится идентфикатор скопированной записи на стене ее
            владельца
        """

        params = locals()
        method_name = self._base_method + 'getMentions'
        return self._call(method_name, params)

    def getRecommended(self, start_time: str = None, end_time: str = None, max_photos: str = None,
                       start_from: str = None, count: str = None, fields: str = None) -> dict:
        """
        Получает список новостей, рекомендованных пользователю.

        :param start_time: время в формате unixtime, начиная с которого следует получить новости для текущего
            пользователя. Если параметр не задан, то он считается равным значению времени, которое было сутки назад.
        :param end_time: время в формате unixtime, до которого следует получить новости для текущего
            пользователя. Если параметр не задан, то он считается равным текущему времени.
        :param max_photos: Максимальное количество фотографий, информацию о которых необходимо вернуть. По
            умолчанию 5.
        :param start_from: Идентификатор, необходимый для получения следующей страницы результатов. Значение,
            необходимое для передачи в этом параметре, возвращается в поле ответа next_from.
        :param count: указывает, какое максимальное число новостей следует возвращать, но не более 100. По
            умолчанию 50.
        :param fields: список дополнительных полей профилей, которые необходимо вернуть. См. подробное описание.
            Доступные значения: sex, bdate, city, country, photo_50, photo_100, photo_200_orig, photo_200,
            photo_400_orig, photo_max, photo_max_orig, online, online_mobile, domain, has_mobile, contacts,
            connections, site, education, universities, schools, can_post, can_see_all_posts, can_see_audio,
            can_write_private_message, status, last_seen, common_count, relation, relatives, counters, screen_name,
            maiden_name, timezone, occupation,activities, interests, music, movies, tv, books, games, about, quotes

        :return: После успешного выполнения возвращает объект, содержащий следующие поля:   items — массив
            новостей для текущего пользователя;  profiles — информация о пользователях, которые находятся в списке
            новостей;  groups — информация о группах, которые находятся в списке новостей;  new_offset — содержит
            offset, который необходимо передать, для того, чтобы получить следующую часть новостей;  new_from —
            содержит from, который необходимо передать, для того, чтобы получить следующую часть новостей. Позволяет
            избавиться от дубликатов, которые могут возникнуть при появлении новых новостей между вызовами этого
            метода.    Описание поля items Поле items содержит массив объектов, каждый из которых соответствует одной
            новости в ленте. Каждый из объектов содержит поля:   type — тип списка новости, соответствующий одному из
            значений параметра filters;  source_id — идентификатор источника новости (положительный — новость
            пользователя, отрицательный — новость группы);  date — время публикации новости в формате unixtime;
            post_id — находится в записях со стен и содержит идентификатор записи на стене владельца;  copy_owner_id
            — находится в записях со стен, если сообщение является копией сообщения с чужой стены, и содержит
            идентификатор владельца стены, у которого было скопировано сообщение;  copy_post_id — находится в записях
            со стен, если сообщение является копией сообщения с чужой стены, и содержит идентификатор скопированного
            сообщения на стене его владельца;  copy_post_date — находится в записях со стен, если сообщение является
            копией сообщения с чужой стены, и содержит дату скопированного сообщения;  text — находится в записях со
            стен и содержит текст записи;  comments — находится в записях со стен и содержит информацию о
            комментариях к записи, содержит поля:   count — количество комментариев,  can_post — информация о том,
            может ли текущий пользователь комментировать запись  (1 — может, 0 — не может);   likes — находится в
            записях со стен и содержит информацию о числе людей, которым понравилась данная запись, содержит поля:
            count — число пользователей, которым понравилась запись,  user_likes — наличие отметки «Мне нравится» от
            текущего пользователя  (1 — есть, 0 — нет),  can_like — информация о том, может ли текущий пользователь
            поставить отметку «Мне нравится»  (1 — может, 0 — не может),  can_publish — информация о том, может ли
            текущий пользователь сделать репост записи  (1 — может, 0 — не может);   reposts — находится в записях со
            стен и содержит информацию о числе людей, которые скопировали данную запись на свою страницу, содержит
            поля:   count — число пользователей, сделавших репост;  user_reposted — наличие репоста от текущего
            пользователя (0 — нет, 1 — есть);   attachments — находится в записях со стен и содержит массив объектов,
            которые прикреплены к текущей новости (фотография, ссылка и т.п.). Более подробная информация
            представлена на странице Описание поля attachments.  geo — находится в записях со стен, в которых имеется
            информация о местоположении, содержит поля:   place_id — идентификатор места;  title — название места;
            type — тип места;  country_id — идентификатор страны;  city_id — идентификатор города;  address — строка
            с указанием адреса места в городе;  showmap — данный параметр указывается, если местоположение является
            прикреплённой картой.      photos, photo_tags, notes, friends — находятся в объектах соответствующих
            типов (кроме записей со стен) и содержат информацию о количестве объектов и до 5 последних объектов,
            связанных с данной новостью.   Каждый из элементов массива в полях photos и photo_tags содержит поля:
            id — идентификатор фотографии  owner_id — идентификатор владельца фотографии  album_id — идентификатор
            альбома  photo_75 - адрес изображения размером 75 пикселей  photo_130 - адрес изображения размером 130
            пикселей  photo_604 - адрес изображения размером 604 пикселей  photo_807 - адрес изображения размером 807
            пикселей  photo_1280 - адрес изображения размером 1280 пикселей    Каждый из элементов массива в поле
            notes содержит поля:     id — идентификатор заметки  owner_id — идентификатор владельца заметки  title —
            заголовок заметки  comments — количество комментариев к заметке    Каждый из элементов массива в поле
            friends содержит поля:     uid— идентификатор пользователя     Описание поля profiles Поле profiles
            содержит массив объектов user с информацией о данных пользователей, которые присутствуют в новостях.
            Каждый из объектов содержит следующие поля:   id — идентификатор пользователя;  first_name — имя
            пользователя;  last_name — фамилия пользователя;  photo — адрес фотографии пользователя размером 50x50px;
            photo_medium_rec — адрес фотографии пользователя размером 100x100px;  screen_name — короткий адрес
            страницы пользователя (например, andrew или id6492).    Описание поля groups Поле groups содержит массив
            объектов group с информацией о сообществах, которые присутствуют в новостях. Каждый из объектов содержит
            следующие поля:   id — идентификатор сообщества;  name — название сообщества;  is_closed — флаг,
            определяющий является ли группа закрытой;  photo — адрес логотипа группы шириной 50px;  photo_medium —
            адрес логотипа группы шириной 100px;  photo_big — адрес логотипа группы шириной 200px;  screen_name —
            короткий адрес страницы сообщества (например, apiclub или club1).    Примечание Вы можете получить полный
            список фотографий, полученных с типом photo или photo_tag методом photos.get, указав параметры feed (дата
            события в поле date) и feed_type (тип события, photo или photo_tag) и uid — идентификатор пользователя, с
            которым произошло событие (поле source_id)
        """

        params = locals()
        method_name = self._base_method + 'getRecommended'
        return self._call(method_name, params)

    def getSuggestedSources(self, offset: str = None, count: str = None, shuffle: str = None,
                            fields: str = None) -> dict:
        """
        Возвращает сообщества и пользователей, на которые текущему пользователю рекомендуется подписаться.

        :param offset: отступ, необходимый для выборки определенного подмножества сообществ или пользователей.
        :param count: количество сообществ или пользователей, которое необходимо вернуть.
        :param shuffle: перемешивать ли возвращаемый список.
        :param fields: список дополнительных полей, которые необходимо вернуть. См. возможные поля для
            пользователей и сообществ.

        :return: Список объектов пользователей и групп
        """

        params = locals()
        method_name = self._base_method + 'getSuggestedSources'
        return self._call(method_name, params)

    def ignoreItem(self, type: str = None, owner_id: str = None, item_id: str = None) -> dict:
        """
        Позволяет скрыть объект из ленты новостей.

        :param type: Тип объекта. Возможные значения:   wall — запись на стене;  tag — отметка на фотографии;
            profilephoto — фотография профиля;  video — видеозапись;  photo — фотография;  audio — аудиозапись.
        :param owner_id: Идентификатор владельца объекта (пользователь или сообщество). Обратите внимание,
            идентификатор сообщества в параметре owner_id необходимо указывать со знаком "-" — например, owner_id=-1
            соответствует идентификатору сообщества ВКонтакте API (club1)
        :param item_id: Идентификатор объекта.

        :return: В результате успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'ignoreItem'
        return self._call(method_name, params)

    def saveList(self, list_id: str = None, title: str = None, source_ids: str = None, no_reposts: str = None) -> dict:
        """
        Метод позволяет создавать или редактировать пользовательские списки для просмотра новостей.

        :param list_id: числовой идентификатор списка (если не передан, будет назначен автоматически).
        :param title: название списка.
        :param source_ids: идентификаторы пользователей и сообществ, которые должны быть включены в список.
            Идентификаторы сообществ нужно указывать со знаком «минус».
        :param no_reposts: нужно ли отображать копии постов в списке (1 — не нужно).

        :return: После успешного выполнения возвращает идентификатор созданного или отредактированного списка
        """

        params = locals()
        method_name = self._base_method + 'saveList'
        return self._call(method_name, params)

    def search(self, q: str = None, extended: str = None, count: str = None, latitude: str = None,
               longitude: str = None, start_time: str = None, end_time: str = None, start_from: str = None,
               fields: str = None) -> dict:
        """
        Возвращает результаты поиска по статусам. Новости возвращаются в порядке от более новых к более старым.

        :param q: поисковой запрос, например, "New Year".
        :param extended: 1, если необходимо получить информацию о пользователе или сообществе, разместившем
            запись. По умолчанию: 0.
        :param count: указывает, какое максимальное число записей следует возвращать. Обратите внимание — даже
            при использовании параметра offset для получения информации доступны только первые 1000 результатов.
        :param latitude: географическая широта точки, в радиусе от которой необходимо производить поиск, заданная
            в градусах (от -90 до 90).
        :param longitude: географическая долгота точки, в радиусе от которой необходимо производить поиск,
            заданная в градусах (от -180 до 180).
        :param start_time: время в формате unixtime, начиная с которого следует получить новости для текущего
            пользователя. Если параметр не задан, то он считается равным значению времени, которое было сутки назад.
        :param end_time: время в формате unixtime, до которого следует получить новости для текущего
            пользователя. Если параметр не задан, то он считается равным текущему времени.
        :param start_from: Идентификатор, необходимый для получения следующей страницы результатов. Значение,
            необходимое для передачи в этом параметре, возвращается в поле ответа next_from.
        :param fields: список дополнительных полей для профилей и групп, которые необходимо вернуть. См. описание
            полей объекта user и описание полей объекта group.  Обратите внимание, этот параметр учитывается только
            при extended=1.

        :return: В случае успеха возвращает общее количество записей и массив объектов, каждый из которых
            содержит поля:   id — локальный идентификатор записи (для конкретного владельца);  owner_id —
            идентификатор владельца стены, на которой размещена запись. Если стена принадлежит сообществу, то данный
            параметр равен -gid (идентификатор сообщества со знаком минус);  from_id — идентификатор автора записи;
            date — время публикации записи в формате unixtime;  text — текст записи;  comments — содержит информацию
            о количестве комментариев к записи. Для Desktop-приложений дополнительно содержит следующую информацию:
            может ли текущий пользователь добавить комментарии к записи;   likes — содержит информацию о числе людей,
            которым понравилась данная запись. Для Desktop-приложений дополнительно содержит следующую информацию:
            понравилась ли запись текущему пользователю;  может ли текущий пользователь добавить запись в спиcок Мне
            нравится;  может ли текущий пользователь опубликовать у себя запись.   attachments — находится в записях
            со стен и содержит массив объектов, которые прикреплены к текущей новости (фотография, ссылка и т.п.).
            Более подробная информация представлена на странице описания поля attachments.  geo — находится в записях
            со стен, в которых имеется информация о местоположении, содержит поля:   type — тип отметки;  coordinates
            — географические координаты места;  place — объект с полями:   pid — идентификатор места;  title —
            название места;  latitude — географическая широта;  longitude — географическая долгота;  created — дата
            добавления;  icon — значок места;  type — тип места;  address — строка с указанием адреса места в городе;
            country — идентификатор страны;  city — идентификатор города;   showmap — данный параметр указывается,
            если местоположение является прикреплённой картой.    В случае, если передан параметр extended,
            дополнительно будут переданы поля profiles и groups, содержащие информацию о пользователях и сообществах.
            Каждый из объектов в массиве profiles содержит следующие поля:   id — идентификатор пользователя;
            first_name — имя пользователя;  last_name — фамилия пользователя;  photo — адрес фотографии пользователя
            размером 50x50px;  photo_medium_rec — адрес фотографии пользователя размером 100x100px;  screen_name —
            короткий адрес страницы пользователя (например, andrew или id6492).   Каждый из объектов в массиве groups
            содержит следующие поля:   id — идентификатор сообщества;  name — название сообщества;  is_closed — флаг,
            определяющий является ли группа закрытой;  photo — адрес логотипа группы шириной 50px;  photo_medium —
            адрес логотипа группы шириной 100px;  photo_big — адрес логотипа группы шириной 200px;  screen_name —
            короткий адрес страницы сообщества (например, apiclub или club1)
        """

        params = locals()
        method_name = self._base_method + 'search'
        return self._call(method_name, params)

    def unignoreItem(self, type: str = None, owner_id: str = None, item_id: str = None) -> dict:
        """
        Позволяет вернуть ранее скрытый объект в ленту новостей.

        :param type: Тип объекта. Возможные значения:   wall — запись на стене;  tag — отметка на фотографии;
            profilephoto — фотография профиля;  video — видеозапись;  photo — фотография;  audio — аудиозапись.
        :param owner_id: Идентификатор владельца объекта (пользователь или сообщество). Обратите внимание,
            идентификатор сообщества в параметре owner_id необходимо указывать со знаком "-" — например, owner_id=-1
            соответствует идентификатору сообщества ВКонтакте API (club1)
        :param item_id: Идентификатор объекта.

        :return: В результате успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'unignoreItem'
        return self._call(method_name, params)

    def unsubscribe(self, type: str = None, owner_id: str = None, item_id: str = None) -> dict:
        """
        Отписывает текущего пользователя от комментариев к заданному объекту.

        :param type: тип объекта, от комментариев к которому необходимо отписаться.  Возможные типы: post —
            запись на стене пользователя или группы; photo — фотография; video — видеозапись; topic — обсуждение;
            note — заметка; market — товар.
        :param owner_id: идентификатор владельца объекта.
        :param item_id: идентификатор объекта.

        :return: После успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'unsubscribe'
        return self._call(method_name, params)
