from ApiMethod import ApiMethod

class Ads(ApiMethod):
    def __init__(self, access_token, v, session, calls_per_second):
        super(Ads, self).__init__(access_token, v, session, calls_per_second)
        self._base_method = 'ads.'

    def addOfficeUsers(self, account_id: str = None, data: str = None) -> dict:
        """
        Добавляет администраторов и/или наблюдателей в рекламный кабинет.

        :param account_id: идентификатор рекламного кабинета.
        :param data: сериализованный JSON-массив объектов, описывающих добавляемых администраторов. Описание
            объектов user_specification см. ниже.

        :return: Возвращает массив значений - ответов на каждый запрос в массиве data. Соответствующее значение в
            выходном массиве равно true, если администратор успешно добавлен, и false в другом случае
        """

        params = locals()
        method_name = self._base_method + 'addOfficeUsers'
        return self._call(method_name, params)

    def checkLink(self, account_id: str = None, link_type: str = None, link_url: str = None,
                  campaign_id: str = None) -> dict:
        """
        Проверяет ссылку на рекламируемый объект.

        :param account_id: идентификатор рекламного кабинета.
        :param link_type: вид рекламируемого объекта:   community — сообщество;  post — запись в сообществе;
            application — приложение ВКонтакте;  video — видеозапись;  site — внешний сайт.
        :param link_url: ссылка на рекламируемый объект.
        :param campaign_id: id кампании, в которой будет создаваться объявление.

        :return: Возвращается структура со следующими полями:   status — статус ссылки:   allowed — ссылку
            допустимо использовать в рекламных объявлениях;  disallowed — ссылку недопустимо использовать для
            указанного вида рекламируемого объекта;  in_progress — ссылка проверяется, необходимо немного подождать.
            description (если status равен disallowed, необязательное поле) — описание причины недопустимости
            использования ссылки.  redirect_url (если конечная ссылка отличается от исходной и если status равен
            allowed) — конечная ссылка
        """

        params = locals()
        method_name = self._base_method + 'checkLink'
        return self._call(method_name, params)

    def createAds(self, account_id: str = None, data: str = None) -> dict:
        """
        Создает рекламные объявления.

        :param account_id: идентификатор рекламного кабинета.
        :param data: сериализованный JSON-массив объектов, описывающих создаваемые объявления. Описание объектов
            ad_specification см. ниже.  Максимальное допустимое количество объявлений,  создаваемых с помощью одного
            запроса — 5. Если нужно больше, то можно использовать execute.  Пример значения data: [{
                "campaign_id": 123456,      "ad_format": 1,      "cost_type": 0,      "cpc": 2.00,
                "category1_id" : 5,      "title": "Test Title",      "link_url" : "https://mysite.com",      "name":
            "My ad"  }]

        :return: Возвращает массив объектов - ответов на каждый запрос в массиве data. Соответствующий объект в
            выходном массиве имеет свойство id, соответствующее id созданного объявления (или 0 в случае неудачи), а
            также, возможно, поля error_code и error_desc, описывающие ошибку, при ее возникновении. Наличие
            одновременно ненулевого id и error_code говорит о том, что объявление было создано, однако, возможно, не
            все параметры установлены (например, объявление не запущено)
        """

        params = locals()
        method_name = self._base_method + 'createAds'
        return self._call(method_name, params)

    def createCampaigns(self, account_id: str = None, data: str = None) -> dict:
        """
        Создает рекламные кампании.

        :param account_id: идентификатор рекламного кабинета.
        :param data: сериализованный JSON-массив объектов, описывающих создаваемые кампании. Описание объектов
            campaign_specification см. ниже.

        :return: Возвращает массив ответов на запросы в массиве data. Соответствующий объект в выходном массиве
            содержит id созданной кампании (ноль в случае неудачи), и поля error_code и error_desc в случае
            возникновения ошибки. Ненулевой id и наличие error_code 602 говорит о том, что кампания создана, но,
            возможно, некоторые поля не были ей присвоены по причине их некорректности
        """

        params = locals()
        method_name = self._base_method + 'createCampaigns'
        return self._call(method_name, params)

    def createClients(self, account_id: str = None, data: str = None) -> dict:
        """
        Создаёт клиентов рекламного агентства.

        :param account_id: id рекламного кабинета.
        :param data: сериализованный JSON-массив объектов, описывающих создаваемые кампании. Описание объектов
            client_specification см. ниже.

        :return: Возвращает массив ответов на запросы в массиве data. Соответствующий объект в выходном массиве
            содержит id созданного клиента (ноль в случае неудачи), и поля error_code и error_desc в случае
            возникновения ошибки. Ненулевой id и наличие error_code 602 говорит о том, что клиент создан, но,
            возможно, некоторые поля не были ему присвоены по причине их некорректности
        """

        params = locals()
        method_name = self._base_method + 'createClients'
        return self._call(method_name, params)

    def createLookalikeRequest(self, account_id: str = None, client_id: str = None, source_type: str = None,
                               retargeting_group_id: str = None) -> dict:
        """
        Создаёт запрос на поиск похожей аудитории.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Только для рекламных агентств.  идентификатор клиента, для которого будет создаваться
            аудитория.
        :param source_type: Тип источника исходной аудитории. На данный момент может принимать единственное
            значение retargeting_group.
        :param retargeting_group_id: Только для источника типа retargeting_group: идентификатор аудитории
            ретаргетинга.

        :return: Поле request_id, в котором указан идентификатор созданного запроса на поиск похожей аудитории
        """

        params = locals()
        method_name = self._base_method + 'createLookalikeRequest'
        return self._call(method_name, params)

    def createTargetGroup(self, account_id: str = None, client_id: str = None, name: str = None, lifetime: str = None,
                          target_pixel_id: str = None, target_pixel_rules: str = None) -> dict:
        """
        Создает аудиторию для ретаргетинга рекламных объявлений на пользователей, которые посетили сайт рекламодателя
        (просмотрели информации о товаре, зарегистрировались и т.д.).

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Только для рекламных агентств.  id клиента, в рекламном кабинете которого будет
            создаваться аудитория.
        :param name: название аудитории ретаргетинга — строка до 64 символов.
        :param lifetime: Количество дней, через которое пользователи, добавляемые в аудиторию, будут
            автоматически исключены из нее.
        :param target_pixel_id: идентификатор пикселя, если требуется собирать аудиторию с веб-сайта.
        :param target_pixel_rules: массив правил для пополнения аудитории из пикселя. Имеет вид:  [      {"type":
            args},      {"type": args},      ...      {"type": args}  ]

        :return: Возвращает объект со следующими полями:   id — идентификатор аудитории
        """

        params = locals()
        method_name = self._base_method + 'createTargetGroup'
        return self._call(method_name, params)

    def createTargetPixel(self, account_id: str = None, client_id: str = None, name: str = None, domain: str = None,
                          category_id: str = None) -> dict:
        """
        Создаёт пиксель ретаргетинга.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Только для рекламных агентств.  id клиента, в рекламном кабинете которого будет
            создаваться пиксель.
        :param name: название пикселя — строка до 64 символов.
        :param domain: домен сайта, на котором будет размещен пиксель.
        :param category_id: идентификатор категории сайта, на котором будет размещен пиксель. Для получения
            списка возможных идентификаторов следует использовать метод ads.getSuggestions (раздел
            interest_categories_v2).

        :return: Возвращает объект со следующими полями:   id — идентификатор пикселя  pixel — код для размещения
            на сайте рекламодател
        """

        params = locals()
        method_name = self._base_method + 'createTargetPixel'
        return self._call(method_name, params)

    def deleteAds(self, account_id: str = None, ids: str = None) -> dict:
        """
        Архивирует рекламные объявления.

        :param account_id: идентификатор рекламного кабинета.
        :param ids: сериализованный JSON-массив, содержащий идентификаторы объявлений.

        :return: Возвращает массив ответов на каждый запрос. Каждый ответ является либо 0, что означает успешное
            удаление, либо код ошибки
        """

        params = locals()
        method_name = self._base_method + 'deleteAds'
        return self._call(method_name, params)

    def deleteCampaigns(self, account_id: str = None, ids: str = None) -> dict:
        """
        Архивирует рекламные кампании.

        :param account_id: идентификатор рекламного кабинета.
        :param ids: сериализованный JSON-массив, содержащий id удаляемых кампаний.

        :return: Возвращает массив ответов на каждый запрос. Каждый ответ является либо 0, что означает успешное
            удаление, либо код ошибки
        """

        params = locals()
        method_name = self._base_method + 'deleteCampaigns'
        return self._call(method_name, params)

    def deleteClients(self, account_id: str = None, ids: str = None) -> dict:
        """
        Архивирует клиентов рекламного агентства.

        :param account_id: идентификатор рекламного кабинета.
        :param ids: сериализованный JSON-массив, содержащий id удаляемых клиентов.

        :return: Возвращает массив ответов на каждый запрос. Каждый ответ является либо 0, что означает успешное
            удаление, либо код ошибки
        """

        params = locals()
        method_name = self._base_method + 'deleteClients'
        return self._call(method_name, params)

    def deleteTargetGroup(self, account_id: str = None, client_id: str = None, target_group_id: str = None) -> dict:
        """
        Удаляет аудиторию ретаргетинга.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Только для рекламных агентств.  id клиента, в рекламном кабинете которого будет
            удаляться аудитория.
        :param target_group_id: идентификатор аудитории.

        :return: В случае успеха метод возвратит 1
        """

        params = locals()
        method_name = self._base_method + 'deleteTargetGroup'
        return self._call(method_name, params)

    def deleteTargetPixel(self, account_id: str = None, client_id: str = None, target_pixel_id: str = None) -> dict:
        """
        Удаляет пиксель ретаргетинга.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Только для рекламных агентств.  id клиента, в рекламном кабинете которого будет
            удаляться пиксель.
        :param target_pixel_id: идентификатор пикселя.

        :return: В случае успеха метод возвратит 1
        """

        params = locals()
        method_name = self._base_method + 'deleteTargetPixel'
        return self._call(method_name, params)

    def getAccounts(self) -> dict:
        """
        Возвращает список рекламных кабинетов.



        :return: Возвращает массив объектов, описывающих рекламные кабинеты. Каждый объект содержит следующие
            поля:  account_id  integerидентификатор рекламного кабинета. account_type  stringтип рекламного кабинета.
            Возможные значения:   general — обычный;  agency — агентский. account_status  integer, [0,1]статус
            рекламного кабинета. Возможные значения:   1 — активен;  0 — неактивен. access_role  stringправа
            пользователя в рекламном кабинете. Возможные значения:   admin — главный администратор;  manager —
            администратор;  reports — наблюдатель
        """

        params = locals()
        method_name = self._base_method + 'getAccounts'
        return self._call(method_name, params)

    def getAds(self, account_id: str = None, client_id: str = None, include_deleted: str = None,
               campaign_ids: str = None, ad_ids: str = None, limit: str = None, offset: str = None) -> dict:
        """
        Возвращает список рекламных объявлений.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Доступно и обязательно для рекламных агентств. Идентификатор клиента, у которого
            запрашиваются рекламные объявления.
        :param include_deleted: Флаг, задающий необходимость вывода архивных объявлений.   0 — выводить только
            активные объявления;  1 — выводить все объявления.
        :param campaign_ids: фильтр по рекламным кампаниям.  Сериализованный JSON-массив, содержащий id кампаний.
            Если параметр равен null, то будут выводиться рекламные объявления всех кампаний.
        :param ad_ids: фильтр по рекламным объявлениям.  Сериализованный JSON-массив, содержащий id объявлений.
            Если параметр равен null, то будут выводиться все рекламные объявления.
        :param limit: ограничение на количество возвращаемых объявлений. Используется, только если параметр
            ad_ids равен null, а параметр campaign_ids содержит id только одной кампании.
        :param offset: смещение. Используется в тех же случаях, что и параметр limit.

        :return: Возвращает массив объектов, описывающих основные характеристики объявления.  Дополнительные
            характеристики можно получить при помощи метода ads.getAdsLayout.  Каждый объект содержит следующие поля:
            id  integerидентификатор объявления. campaign_id  integerидентификатор кампании. ad_format  integerформат
            объявления. Возможные значения:   1 — изображение и текст;  2 — большое изображение;  3 — эксклюзивный
            формат;  4 — продвижение сообществ или приложений, квадратное изображение;  5 — приложение в новостной
            ленте (устаревший);  6 — мобильное приложение;  9 — запись в сообществе;  11 — адаптивный формат;  12 —
            истории. cost_type  integer, [0,1,3]тип оплаты. Возможные значения:   0 — оплата за переходы;  1 — оплата
            за показы;  3 — оптимизированная оплата за показы. cpc  integer(если cost_type = 0) цена за переход в
            копейках. cpm  integer(если cost_type = 1) цена за 1000 показов в копейках. ocpm  integer(если cost_type
            = 3) цена за действие для oCPM в копейках. goal_type  integer, [1,2,3]тип цели. Возможные значения:   1 —
            показы;  2 — переходы;  3 — отправка заявок;  5 — вступления в сообщество. impressions_limit
            integer(если задано) ограничение количества показов данного объявления на одного пользователя. Может
            присутствовать для некоторых форматов объявлений, для которых разрешена установка точного значения.
            impressions_limited  integer, [1](если задано) признак того, что количество показов объявления на одного
            пользователя ограничено. Может присутствовать для некоторых объявлений, для которых разрешена установка
            ограничения, но не разрешена установка точного значения. 1 — не более 100 показов на одного пользователя.
            ad_platform(если значение применимо к данному формату объявления) рекламные площадки, на которых будет
            показываться объявление. Возможные значения:   (если ad_format равен 1)   0 — ВКонтакте и сайты-партнёры;
            1 — только ВКонтакте.   (если ad_format равен 9)   all — все площадки;  desktop — полная версия сайта;
            mobile — мобильный сайт и приложения.   (если ad_format равен 11)   all — все площадки;  desktop — полная
            версия сайта;  mobile — мобильный сайт и приложения. ad_platform_no_wall  integer, [1]1 — для объявления
            задано ограничение «Не показывать на стенах сообществ». ad_platform_no_ad_network  integer, [1]1 — для
            объявления задано ограничение «Не показывать в рекламной сети». all_limit  integerобщий лимит объявления
            в рублях. 0 — лимит не задан. day_limit  integerдневной лимит объявления в рублях. 0 — лимит не задан.
            autobiddingавтоматическое управление ценой:   0 — выключено;  1 — включено.  флаг, может принимать
            значения 0 или 1 autobidding_max_cost  integerмаксимальное ограничение автоматической ставки в копейках
            category1_id  integerID тематики или подраздела тематики объявления. См. ads.getCategories. category2_id
            integerID тематики или подраздела тематики объявления. Дополнительная тематика. status  integerстатус
            объявления. Возможные значения:     0 — объявление остановлено;  1 — объявление запущено;  2 — объявление
            удалено. name  stringназвание объявления. approved  integerстатус модерации объявления. Возможные
            значения:     0 — объявление не проходило модерацию;  1 — объявление ожидает модерации;  2 — объявление
            одобрено;  3 — объявление отклонено. video  integer, [1]1 — объявление является видеорекламой.
            disclaimer_medical  integer, [1]1 — включено отображение предупреждения:  «Есть противопоказания.
            Требуется консультация специалиста.» disclaimer_specialist  integer, [1]1 — включено отображение
            предупреждения:  «Необходима консультация специалистов.» disclaimer_supplements  integer, [1]1 — включено
            отображение предупреждения:  «БАД. Не является лекарственным препаратом.» weekly_schedule_hours
            arrayрасписание показа объявления по часам. Массив из семи строк. Каждая из строк соответствует дню
            недели и содержит последовательность символов 0 или 1. 0 — не показывать объявление в час, номер которого
            равен позиции символа. 1 — показывать. weekly_schedule_use_holidays  integer, [0,1]1 — использовать
            расписание воскресенья в праздничные дни. events_retargeting_groups  arrayТолько для ad_format = 9 и 11.
            Описание событий, собираемых в группы ретаргетинга. Массив объектов, где ключом является id группы
            ретаргетинга, а значением - массив событий. Допустимые значений для событий:   1 — просмотр промопоста;
            2 — переход по ссылке или переход в сообщество;  3 — переход в сообщество;  4 — подписка на сообщество;
            5 — отписка от новостей сообщества;  6 — скрытие или жалоба;  10 — запуск видео;  11 — досмотр видео до
            3с;  12 — досмотр видео до 25%;  13 — досмотр видео до 50%;  14 — досмотр видео до 75%;  15 — досмотр
            видео до 100%;  20 — лайк продвигаемой записи;  21 — репост продвигаемой записи
        """

        params = locals()
        method_name = self._base_method + 'getAds'
        return self._call(method_name, params)

    def getAdsLayout(self, account_id: str = None, client_id: str = None, include_deleted: str = None,
                     campaign_ids: str = None, ad_ids: str = None, limit: str = None, offset: str = None) -> dict:
        """
        Возвращает описания внешнего вида рекламных объявлений.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Для рекламных агентств. Идентификатор клиента, у которого запрашиваются рекламные
            объявления.
        :param include_deleted: Флаг, задающий необходимость вывода архивных объявлений.   0 — выводить только
            активные объявления;  1 — выводить все объявления.
        :param campaign_ids: фильтр по рекламным кампаниям. Сериализованный JSON-массив, содержащий id кампаний.
            Если параметр равен null, то будут выводиться рекламные объявления всех кампаний.
        :param ad_ids: фильтр по рекламным объявлениям. Сериализованный JSON-массив, содержащий id объявлений.
            Если параметр равен null, то будут выводиться все рекламные объявления.
        :param limit: ограничение на количество возвращаемых объявлений. Используется, только если параметр
            ad_ids равен null, а параметр campaign_ids содержит id только одной кампании.
        :param offset: смещение. Используется в тех же случаях, что и параметр limit.

        :return: Возвращает массив объектов, описывающих дополнительные характеристики объявления.  Основные
            характеристики можно получить при помощи метода ads.getAds.  Каждый объект содержит следующие поля:  id
            integerидентификатор объявления. campaign_id integerидентификатор кампании. ad_format  integerформат
            объявления. Возможные значения:   1 — изображение и текст;  2 — большое изображение;  3 — эксклюзивный
            формат;  4 — продвижение сообществ или приложений, квадратное изображение;  5 — приложение в новостной
            ленте (устаревший);  6 — мобильное приложение;  7 — специальный формат приложений;  8 — специальный
            формат сообществ;  9 — запись в сообществе;  10 — витрина приложений;  11 — адаптивный формат. cost_type
            integer, [0,1,3]тип оплаты. Возможные значения:   0 — оплата за переходы;  1 — оплата за показы;  3 —
            оптимизированная оплата за показы. goal_type  integer, [1,2,3]тип цели. Возможные значения:   1 — показы;
            2 — переходы;  3 — отправка заявок. video  integer, [1]1 — объявление является видеорекламой.
            repeat_video  integer, [0,1]зацикливание видео. Возможные значения:   0 — не зацикливать видео;  1 —
            зацикливать видео. title stringзаголовок объявления. description  stringописание объявления. link_url
            stringссылка на рекламируемый объект. link_domain  stringдомен рекламируемого сайта. link_title
            stringзаголовок рядом с кнопкой/ссылкой. link_button stringидентификатор кнопки объявления. Список
            возможных значений. preview_link  stringссылка, перейдя по которой можно просмотреть рекламное объявление
            так, как оно выглядит на сайте. Ссылка доступна в течение 30 минут после выполнения метода
            ads.getAdsLayout. image_src  stringurl изображения объявления. image_src_2x  stringurl изображения
            двойного разрешения. icon_src  stringurl логотипа объявления. icon_src_2x  stringurl логотипа двойного
            разрешения
        """

        params = locals()
        method_name = self._base_method + 'getAdsLayout'
        return self._call(method_name, params)

    def getAdsTargeting(self, account_id: str = None, client_id: str = None, include_deleted: str = None,
                        campaign_ids: str = None, ad_ids: str = None, limit: str = None, offset: str = None) -> dict:
        """
        Возвращает параметры таргетинга рекламных объявлений

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Для рекламных агентств. id клиента, у которого запрашиваются рекламные объявления.
        :param include_deleted: Флаг, задающий необходимость вывода архивных объявлений.   0 — выводить только
            активные объявления;  1 — выводить все объявления.
        :param campaign_ids: фильтр по рекламным кампаниям.  Сериализованный JSON-массив, содержащий id кампаний.
            Если параметр равен null, то будут выводиться рекламные объявления всех кампаний.
        :param ad_ids: фильтр по рекламным объявлениям.  Сериализованный JSON-массив, содержащий id объявлений.
            Если параметр равен null, то будут выводиться все рекламные объявления.
        :param limit: ограничение на количество возвращаемых объявлений. Используется, только если параметр
            ad_ids равен null, а параметр campaign_ids содержит id только одной кампании.
        :param offset: смещение, необходимо для выборки определенного подмножества значений.

        :return: Возвращает массив объектов - описаний таргетинга объявлений.  Отрицательные id в поле cities
            означают id регионов, взятых с обратным знаком.  Поле count содержит размер целевой аудитории на момент
            сохранения объявления
        """

        params = locals()
        method_name = self._base_method + 'getAdsTargeting'
        return self._call(method_name, params)

    def getBudget(self, account_id: str = None) -> dict:
        """
        Возвращает текущий бюджет рекламного кабинета.

        :param account_id: идентификатор рекламного кабинета.

        :return: Возвращает единственное число — оставшийся бюджет в указанном рекламном кабинете
        """

        params = locals()
        method_name = self._base_method + 'getBudget'
        return self._call(method_name, params)

    def getCampaigns(self, account_id: str = None, client_id: str = None, include_deleted: str = None,
                     campaign_ids: str = None, fields: str = None) -> dict:
        """
        Возвращает список кампаний рекламного кабинета.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Обязателен для рекламных агентств, в остальных случаях не используется. Идентификатор
            клиента, у которого запрашиваются рекламные кампании.
        :param include_deleted: Флаг, задающий необходимость вывода архивных объявлений.   0 — выводить только
            активные кампании;  1 — выводить все кампании.
        :param campaign_ids: Фильтр выводимых рекламных кампаний.  Сериализованный JSON-массив, содержащий id
            кампаний. Выводиться будут только кампании, присутствующие в campaign_ids и являющиеся кампаниями
            указанного рекламного кабинета. Если параметр равен строке null, то выводиться будут все кампании.
        :param fields:

        :return: Возвращает массив объектов campaign, каждый из которых содержит следующие поля:   id —
            идентификатор кампании  type — тип кампании   normal — обычная кампания, в которой можно создавать любые
            объявления, кроме описанных в следующих пунктах;  vk_apps_managed — кампания, в которой можно
            рекламировать только администрируемые Вами приложения и у которой есть отдельный бюджет;  mobile_apps —
            кампания, в которой можно рекламировать только мобильные приложения;  promoted_posts — кампания, в
            которой можно рекламировать только записи в сообществе;  adaptive_ads — кампания, в которой можно
            рекламировать только объявления адаптивного формата.   name — название кампании  status — статус кампании
            0 — кампания остановлена  1 — кампания запущена  2 — кампания удалена   day_limit — дневной лимит
            кампании в рублях   0 — лимит не задан   all_limit — общий лимит кампании в рублях   0 — лимит не задан
            start_time — время запуска кампании в формате unixtime   0 — время не задано   stop_time — время
            остановки кампании в формате unixtime   0 — время не задан
        """

        params = locals()
        method_name = self._base_method + 'getCampaigns'
        return self._call(method_name, params)

    def getCategories(self, lang: str = None) -> dict:
        """
        Позволяет получить возможные тематики рекламных объявлений.

        :param lang: язык, на котором нужно вернуть результаты. Список поддерживаемых языков Вы можете найти на
            странице Запросы к API.

        :return: После успешного выполнения возвращает два массива объектов — v1 и v2, каждый из которых содержит
            объекты, описывающие тематики в следующем формате:   id — идентификатор тематики;  name — название
            тематики;  subcategories[subcategory] (если есть хотя бы один подраздел) — список подразделов. Массив
            объектов, каждый из которых содержит следующие поля:   id — идентификатор подраздела;  name — название
            подраздела.    Массив v1 включает устаревшие тематики. Актуальный список содержится в массиве v2
        """

        params = locals()
        method_name = self._base_method + 'getCategories'
        return self._call(method_name, params)

    def getClients(self, account_id: str = None) -> dict:
        """
        Возвращает список клиентов рекламного агентства.

        :param account_id: идентификатор рекламного кабинета.

        :return: Возвращает массив объектов client — клиентов агентства с номером account_id, каждый из которых
            содержит следующие поля:   id — идентификатор клиента;  name — название клиента;  day_limit — дневной
            лимит клиента в рублях;  all_limit — общий лимит клиента в рублях
        """

        params = locals()
        method_name = self._base_method + 'getClients'
        return self._call(method_name, params)

    def getDemographics(self, account_id: str = None, ids_type: str = None, ids: str = None, period: str = None,
                        date_from: str = None, date_to: str = None) -> dict:
        """
        Возвращает демографическую статистику по рекламным объявлениям или кампаниям.

        :param account_id: идентификатор рекламного кабинета.
        :param ids_type: Тип запрашиваемых объектов, которые перечислены в параметре ids:   ad — объявления;
            campaign — кампании.
        :param ids: Перечисленные через запятую id запрашиваемых объявлений или кампаний, в зависимости от того,
            что указано в параметре ids_type. Максимум 2000 объектов.
        :param period: способ группировки данных по датам:   day — статистика по дням;  month — статистика по
            месяцам;  overall — статистика за всё время.  Временные ограничения задаются параметрами date_from и
            date_to.
        :param date_from: Начальная дата выводимой статистики. Используется разный формат дат для разного
            значения параметра period:   day: YYYY-MM-DD, пример: 2011-09-27 - 27 сентября 2011   0 — день создания;
            month: YYYY-MM, пример: 2011-09 - сентябрь 2011   0 — месяц создания;   overall: 0
        :param date_to: Конечная дата выводимой статистики. Используется разный формат дат для разного значения
            параметра period:   day: YYYY-MM-DD, пример: 2011-09-27 - 27 сентября 2011   0 — текущий день;   month:
            YYYY-MM, пример: 2011-09 - сентябрь 2011   0 — текущий месяц;   overall: 0

        :return: Каждый запрашиваемый объект имеет следующие поля:   id — id объекта из параметра ids  type — тип
            объекта из параметра ids_type  stats — список структур описывающих статистику объекта за один временной
            период (конкретный временной период присутствует в списке, если по нему есть какая-то статистика)
            Структура в списке stats имеет следующие поля:   day (если period равен day) — день в формате YYYY-MM-DD
            month (если period равен month) — месяц в формате YYYY-MM  overall (если period равен overall) — 1  sex —
            список структур, описывающих статистику по полу  age — список структур, описывающих статистику по
            возрасту  sex_age — список структур, описывающих статистику по полу и возрасту  cities — список структур,
            описывающих статистику по городам  Структура в списках sex, age, sex_age, cities имеет следующие поля:
            impressions_rate — часть аудитории, просмотревшая объявление, от 0 до 1  clicks_rate — часть аудитории,
            кликнувшая по объявлению, от 0 до 1  value — значение демографического показателя, имеет разные возможные
            значения для разных показателей   sex (f — женщины, m — мужчины)  age — один из следующих промежутков:
            12-18, 18-21, 21-24, 24-27, 27-30, 30-35, 35-45, 45-100  sex_age — комбинация значений sex и age,
            разделённых точкой с запятой, пример: m;21-24  cities — id города или other для остальных городов   name
            — наглядное название значения указанного в value (только для городов
        """

        params = locals()
        method_name = self._base_method + 'getDemographics'
        return self._call(method_name, params)

    def getFloodStats(self, account_id: str = None) -> dict:
        """
        Возвращает информацию о текущем состоянии счетчика — количество оставшихся запусков методов и время до
        следующего обнуления счетчика в секундах.

        :param account_id: идентификатор рекламного кабинета.

        :return: Возвращает объект, содержащий следующие поля:   left — количество оставшихся методов;  refresh —
            время до следующего обновления в секундах
        """

        params = locals()
        method_name = self._base_method + 'getFloodStats'
        return self._call(method_name, params)

    def getLookalikeRequests(self, account_id: str = None, client_id: str = None, requests_ids: str = None,
                             offset: str = None, limit: str = None, sort_by: str = None) -> dict:
        """
        Возвращает список запросов на поиск похожей аудитории.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Только для рекламных агентств.  идентификатор клиента, для которого возвращаются
            запросы.
        :param requests_ids: Список идентификаторов запрашиваемых запросов через запятую. Максимальное количество
            идентификаторов в списке – 200.  Если этот параметр пуст, возвращаться будут все запросы.
        :param offset: Смещение. Используется в связке с параметром limit.
        :param limit: Ограничение на количество возвращаемых запросов на поиск похожей аудитории. Используется в
            связке с параметром offset.   0 — вернуть только количество запросов в кабинете (у клиента в случае
            агентства).
        :param sort_by: Сортировка элементов. Возможные значения:   id – сортировать по возрастанию
            идентификаторов  update_time – сортировать по убыванию времени последнего обновления статуса

        :return: Если limit не равен 0, то возвращается объект с двумя полями:    count — количество запросов на
            поиск похожей аудитории в данном кабинете.  items — список объектов-запросов на поиск похожей аудитории
            запрошенного размера с запрошенным сдвигом.   При limit равном 0, возвращается только поле count.
            Описание запроса на поиск похожей аудитории – объект со следующими полями:   id — идентификатор запроса
            на поиск похожей аудитории. Является уникальным только в рамках конкретного кабинета (клиента в случае
            агентства).  create_time — timestamp даты создания запроса.  update_time — timestamp даты последнего
            обновления статуса запроса.  status — текущий статус запроса, может принимать следующие значения:
            search_in_progress, search_done, search_failed, save_in_progress, save_done, save_failed.
            scheduled_delete_time — timestamp даты запланированного удаления запроса.  source_type — тип источника
            исходной аудитории для поиска похожей аудитории. Может принимать только значение retargeting_group.
            source_retargeting_group_id — при source_type равном retargeting_group в данном поле указан идентификатор
            аудитории ретаргетинга с исходной аудиторией.  source_name — имя источника исходной аудитории. При
            source_type равном retargeting_group в данном поле указано название аудитории ретаргетинга на момент
            создания запроса.  audience_count — размер исходной аудитории.  save_audience_levels — Список доступных
            размеров аудитории для сохранения. Присутствует только после успешного поиска похожей аудитории. Поля:
            level — используется в качестве параметра level в ads.saveLookalikeRequestResult  audience_count — размер
            похожей аудитории в данной опции
        """

        params = locals()
        method_name = self._base_method + 'getLookalikeRequests'
        return self._call(method_name, params)

    def getOfficeUsers(self, account_id: str = None) -> dict:
        """
        Возвращает список администраторов и наблюдателей рекламного кабинета.

        :param account_id: идентификатор рекламного кабинета.

        :return: Возвращает массив объектов - описаний пользователей рекламного кабинета. Каждый объект содержит
            массив описаний прав доступа к конкретным клиентам. Описание содержит два поля: client_id — id клиента и
            role — строка admin, manager или reports. Для admin client_id не указывается
        """

        params = locals()
        method_name = self._base_method + 'getOfficeUsers'
        return self._call(method_name, params)

    def getPostsReach(self, account_id: str = None, ids_type: str = None, ids: str = None) -> dict:
        """
        Возвращает подробную статистику по охвату рекламных записей из объявлений и кампаний для продвижения записей
        сообщества.

        :param account_id: идентификатор рекламного кабинета.
        :param ids_type: Тип запрашиваемых объектов, которые перечислены в параметре ids:   ad — объявления;
            campaign — кампании.
        :param ids: Перечисленные через запятую id запрашиваемых объявлений или кампаний, в зависимости от того,
            что указано в параметре ids_type. Максимум 100 объектов.

        :return: Возвращает массив объектов, описывающих охват. Каждый объект содержит следующие поля:  id
            integerID объекта из параметра ids. reach_subscribers  integerохват подписчиков. reach_total
            integerсуммарный охват. links  integerпереходы по ссылке. to_group  integerпереходы в сообщество.
            join_group  integerвступления в сообщество. report  integerколичество жалоб на запись. hide
            integerколичество скрытий записи. unsubscribe  integerколичество отписавшихся участников.
            video_views_start*  integerколичество стартов просмотра видео. video_views_3s*  integerколичество
            досмотров видео до 3 секунд. video_views_25p*  integerколичество досмотров видео до 25 процентов.
            video_views_50p*  integerколичество досмотров видео до 50 процентов. video_views_75p*  integerколичество
            досмотров видео до 75 процентов. video_views_100p*  integerколичество досмотров видео до 100 процентов.
            * — поля с данными по статистике видео возвращаются только для объявлений или кампаний с видео, созданных
            после 26 января 2017 года
        """

        params = locals()
        method_name = self._base_method + 'getPostsReach'
        return self._call(method_name, params)

    def getRejectionReason(self, account_id: str = None, ad_id: str = None) -> dict:
        """
        Возвращает причину, по которой указанному объявлению было отказано в прохождении премодерации.

        :param account_id: идентификатор рекламного кабинета.
        :param ad_id: идентификатор рекламного объявления.

        :return: Возвращает объект, который может содержать поле comment, содержащее текстовый комментарий
            модератора, и/или массив rules, содержащий описание нарушенных объявлением правил. Ответ обязательно
            содержит хотя бы одно из полей comment или rules. Каждый элемент массива rules состоит из поля title
            (текстового пояснения) и массива paragraphs, каждый элемент которого содержит отдельный пункт правил.
            Элементы массива paragraphs могут содержать простую html-разметку
        """

        params = locals()
        method_name = self._base_method + 'getRejectionReason'
        return self._call(method_name, params)

    def getStatistics(self, account_id: str = None, ids_type: str = None, ids: str = None, period: str = None,
                      date_from: str = None, date_to: str = None, stats_fields: str = None) -> dict:
        """
        Возвращает статистику показателей эффективности по рекламным объявлениям, кампаниям, клиентам или всему
        кабинету.

        :param account_id: идентификатор рекламного кабинета.
        :param ids_type: Тип запрашиваемых объектов, которые перечислены в параметре ids:   ad — объявления;
            campaign — кампании;  client — клиенты;  office — кабинет.
        :param ids: Перечисленные через запятую id запрашиваемых объявлений, кампаний, клиентов или кабинета, в
            зависимости от того, что указано в параметре ids_type. Максимум 2000 объектов.
        :param period: Способ группировки данных по датам:   day — статистика по дням;  month — статистика по
            месяцам;  overall — статистика за всё время;  Временные ограничения задаются параметрами date_from и
            date_to.
        :param date_from: Начальная дата выводимой статистики. Используется разный формат дат для разного
            значения параметра period:   day: YYYY-MM-DD, пример: 2011-09-27 - 27 сентября 2011   0 — день создания;
            month: YYYY-MM, пример: 2011-09 - сентябрь 2011   0 — месяц создания;   overall: 0
        :param date_to: Конечная дата выводимой статистики. Используется разный формат дат для разного значения
            параметра period:   day: YYYY-MM-DD, пример: 2011-09-27 - 27 сентября 2011   0 — текущий день;   month:
            YYYY-MM, пример: 2011-09 - сентябрь 2011   0 — текущий месяц;   overall: 0
        :param stats_fields: Дополнительные статистики:   views_times — распределение количества показов на
            пользователя. Доступно для типов ad и campaign, содержащих только рекламные записи

        :return: Каждый запрашиваемый объект имеет следующие поля:   id — id объекта из параметра ids  type — тип
            объекта из параметра ids_type  stats — список структур описывающих статистику объекта за один временной
            период (конкретный временной период присутствует в списке, если по нему есть какая-то статистика)
            Структура в списке stats имеет следующие поля:     day (если period равен day) — день в формате YYYY-MM-
            DD  month (если period равен month) — день в формате YYYY-MM  overall (если period равен overall) — 1
            spent — потраченные средства  impressions — просмотры  clicks — клики  reach (если ids_type равен ad или
            campaign и period равен day или month) — охват  join_rate (если ids_type равен ad или campaign) —
            вступления в группу, событие, подписки на публичную страницу или установки приложения (только если в
            объявлении указана прямая ссылка на соответствующую страницу ВКонтакте
        """

        params = locals()
        method_name = self._base_method + 'getStatistics'
        return self._call(method_name, params)

    def getSuggestions(self, section: str = None, ids: str = None, q: str = None, country: str = None,
                       cities: str = None, lang: str = None) -> dict:
        """
        Возвращает набор подсказок для различных параметров таргетинга.

        :param section: Раздел, по которому запрашиваются подсказки.  Поддерживаются следующие значения:
            countries — страны;   q — необязательный параметр;   1 — возвращается полный список стран;  не задан —
            возвращается краткий список стран;    regions — регионы;   country — обязательный параметр;  q —
            обязательный параметр;   cities — города.   country — обязательный параметр;  q — необязательный
            параметр;   districts — районы   cities — обязательный параметр;   stations — станции метро   cities —
            обязательный параметр;   streets — улицы   cities — обязательный параметр;  q — обязательный параметр;
            schools — учебные заведения: школы, университеты, факультеты, кафедры   cities — обязательный параметр;
            q — обязательный параметр;   interest_categories_v2 — категории интересов;  interest_categories —
            устаревшие категории интересов;  positions — должности (профессии);   q — необязательный параметр;
            religions — религиозные взгляды;  user_devices — устройства;  user_os — операционные системы;
            user_browsers — интернет-браузеры.
        :param ids: ID объектов, разделённые запятыми. Служит для расшифровки ID, возвращаемых в методе
            ads.getAdsTargeting. Если задан этот параметр, то параметры q, country, cities не должны передаваться,
            таким образом отменяется их обязательность для конкретного раздела. Объекты возвращаются в том же
            порядке, в каком они были заданы в этом параметре.
        :param q: -фильтр запроса
        :param country: ID страны, в которой ищутся объекты.
        :param cities: ID городов, в которых ищутся объекты, разделенные запятыми.
        :param lang: Язык возвращаемых строковых значений. Поддерживаемые языки:   ru — русский;  ua —
            украинский;  en — английский.

        :return: Возвращает список объектов (подсказок), удовлетворяющих запросу.  Для разделов countries,
            positions, interest_categories, religions, user_devices, user_os, user_browsers ответ возвращается в виде
            массива объектов со следующими полями:   id — идентификатор объекта  name — название объекта   Для
            раздела regions ответ возвращается в виде массива объектов со следующими полями:   id — идентификатор
            региона  name — название региона  type (необязательное) — название типа региона (область, автономный
            округ, край)   Для разделов cities, districts, streets ответ возвращается в виде массива объектов со
            следующими полями:   id — идентификатор объекта  name — название объекта  parent — название города или
            страны, в котором находится объект   Для раздела schools ответ возвращается в виде массива объектов со
            следующими полями:   id — идентификатор учебного заведения  name — название учебного заведения  desc —
            полное название учебного заведения  type — тип учебного заведения   school — школа  university —
            университет  faculty — факультет  chair — кафедра   parent — название города, в котором находится учебное
            заведение   Для раздела interests ответ возвращается в виде массива строк
        """

        params = locals()
        method_name = self._base_method + 'getSuggestions'
        return self._call(method_name, params)

    def getTargetGroups(self, account_id: str = None, client_id: str = None, extended: str = None) -> dict:
        """
        Возвращает список аудиторий ретаргетинга.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Только для рекламных агентств.  id клиента, в рекламном кабинете которого находятся
            аудитории.
        :param extended: если 1, в результатах будет указан код для размещения на сайте.  Устаревший параметр.
            Используется только для старых групп ретаргетинга, которые пополнялись без помощи пикселя. Для новых
            аудиторий его следует опускать.

        :return: Возвращает массив объектов, описывающих группы ретаргетинга. Каждый объект содержит следующие
            поля:   id (integer) — идентификатор аудитории;  name (string) — название аудитории ретаргетинга;
            last_updated (integer) — дата и время последнего пополнения аудитории в формате Unixtime;  is_audience
            (integer, 1) — 1, если группа является аудиторией (т.е.может быть пополнена при помощи пикселя);
            is_shared (integer, 1) — 1, если группа является копией (см. метод ads.shareTargetGroup);  audience_count
            (integer) — приблизительное количество пользователей, входящих в аудиторию;  lifetime (integer) —
            количество дней, через которое пользователи, добавляемые в аудиторию ретаргетинга, будут автоматически
            исключены из неё;  file_source (integer, 1) — признак пополнения аудитории через файл;  api_source
            (integer, 1) — признак пополнения аудитории через метод ads.importTargetContacts;  lookalike_source
            (integer, 1) — признак аудитории, полученной при помощи Look-a-Like.     pixel (string) — код для
            размещения на сайте рекламодателя. Возвращается, если параметр extended = 1 (только для старых групп).
            domain (string) — домен сайта, где размещен код учета пользователей (только для старых групп)
        """

        params = locals()
        method_name = self._base_method + 'getTargetGroups'
        return self._call(method_name, params)

    def getTargetPixels(self, account_id: str = None, client_id: str = None) -> dict:
        """
        Возвращает список пикселей ретаргетинга.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Только для рекламных агентств.  id клиента, в рекламном кабинете которого находятся
            пиксели.

        :return: Возвращает массив объектов, каждый из которых содержит следующие поля:   target_pixel_id
            (integer) — идентификатор пикселя;  name (string) — название пикселя;  last_updated (integer) — дата и
            время последнего использования пикселя в формате Unixtime;  domain (string) — домен сайта, где размещен
            пиксель;  category_id (integer) — идентификатор категории сайта, где размещён пиксель (см. раздел
            interest_categories метода ads.getSuggestions);  pixel (string) — код для размещения на сайте
            рекламодателя
        """

        params = locals()
        method_name = self._base_method + 'getTargetPixels'
        return self._call(method_name, params)

    def getTargetingStats(self, account_id: str = None, client_id: str = None, criteria: str = None, ad_id: str = None,
                          ad_format: str = None, ad_platform: str = None, ad_platform_no_wall: str = None,
                          ad_platform_no_ad_network: str = None, link_url: str = None, link_domain: str = None) -> dict:
        """
        Возвращает размер целевой аудитории таргетинга, а также рекомендованные значения CPC и CPM.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: обязательный параметр для агентских кабинетов
        :param criteria: сериализованный JSON-объект, описывающий параметры таргетинга. Описание объекта criteria
            см. ниже. Игнорируется, если задан параметр ad_id.
        :param ad_id: идентификатор рекламного объявления, чьи параметры таргетинга требуется анализировать. Если
            задан этот параметр, criteria игнорируется.
        :param ad_format: формат объявления:   1 — изображение и текст;  2 — большое изображение;  3 —
            эксклюзивный формат;  4 — продвижение сообществ или приложений, квадратное изображение;  7 — специальный
            формат приложений;  8 — специальный формат сообществ;  9 — запись в сообществе;  10 — витрина приложений;
            11 — адаптивный формат.
        :param ad_platform: рекламные площадки, на которых будет показываться объявление:   (если ad_format равен
            1):   0 — ВКонтакте и сайты-партнёры;  1 — только ВКонтакте.   (если ad_format равен 9):   all — все
            площадки;  desktop — полная версия сайта;  mobile — мобильный сайт и приложения.   (если ad_format равен
            11):   all — все площадки;  desktop — полная версия сайта;  mobile — мобильный сайт и приложения.
        :param ad_platform_no_wall: Для ad_format = 9 и 11.  1 — не показывать объявление на стенах сообществ. По
            умолчанию: 0.
        :param ad_platform_no_ad_network: Для ad_format = 9 и 11.  1 — не показывать объявление в рекламной сети.
            По умолчанию: 0.
        :param link_url: ссылка на рекламируемый объект.
        :param link_domain: домен рекламируемого объекта.

        :return: Возвращает объект, описывающий целевую аудиторию и содержащий следующие поля:   audience_count
            (integer) — размер целевой аудитории  recommended_cpc (number) — рекомендованная цена для объявлений за
            клики, указана в рублях с копейками в дробной части. 0 — для форматов, для которых недоступна оплата за
            клики.  recommended_cpm (number)— рекомендованная цена для объявлений за показы, указана в рублях с
            копейками в дробной части.  recommended_cpc_50 (number) — рекомендованная цена для объявлений за клики, с
            прогнозом на достижение 50% охвата за первую неделю.  recommended_cpm_50 (number)— рекомендованная цена
            для объявлений за показы, с прогнозом на достижение 50% охвата за первую неделю.  recommended_cpc_70
            (number) — рекомендованная цена для объявлений за клики, с прогнозом на достижение 70% охвата за первую
            неделю.  recommended_cpm_70 (number)— рекомендованная цена для объявлений за показы, с расчетом на
            достижение 70% охвата за первую неделю.  recommended_cpc_90 (number) — рекомендованная цена для
            объявлений за клики, с прогнозом на достижение 90% охвата за первую неделю.  recommended_cpm_90 (number)—
            рекомендованная цена для объявлений за показы, с прогнозом на достижение 90% охвата за первую неделю.
            Обратите внимание, минимальный размер целевой аудитории — 100 человек. Если заданным критериям
            соответствует меньшее количество пользователей, размер аудитории будет считаться равным нулю
        """

        params = locals()
        method_name = self._base_method + 'getTargetingStats'
        return self._call(method_name, params)

    def getUploadURL(self, ad_format: str = None, icon: str = None) -> dict:
        """
        Возвращает URL-адрес для загрузки фотографии рекламного объявления.

        :param ad_format: формат объявления:   1 — изображение и текст;  2 — большое изображение;  3 —
            эксклюзивный формат;  4 — продвижение сообществ или приложений, квадратное изображение;  5 — приложение в
            новостной ленте (устаревший);  6 — мобильное приложение;  11 — адаптивный формат.   Для формата
            объявления «запись в сообществе» этот метод не используется, т.к. фотографии являются частью записи со
            стены сообщества. См. методы ads.createAds и wall.postAdsStealth
        :param icon: 1 — получить URL для загрузки логотипа, а не основного изображения. Используется только для
            ad_format = 11.

        :return: Возвращает url-адрес для загрузки изображения
        """

        params = locals()
        method_name = self._base_method + 'getUploadURL'
        return self._call(method_name, params)

    def getVideoUploadURL(self) -> dict:
        """
        Возвращает URL-адрес для загрузки видеозаписи рекламного объявления.

        :return: Возвращает url-адрес для загрузки видеоролика
        """

        params = locals()
        method_name = self._base_method + 'getVideoUploadURL'
        return self._call(method_name, params)

    def importTargetContacts(self, account_id: str = None, client_id: str = None, target_group_id: str = None,
                             contacts: str = None) -> dict:
        """
        Импортирует список контактов рекламодателя для учета зарегистрированных во ВКонтакте пользователей в аудитории
        ретаргетинга.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Только для рекламных агентств.  id клиента, в рекламном кабинете которого находится
            аудитория.
        :param target_group_id: идентификатор аудитории таргетинга.
        :param contacts: список телефонов, email адресов или идентификаторов пользователей, указанных через
            запятую. Также принимаются их MD5-хеши.

        :return: Возвращает количество обработанных контактов
        """

        params = locals()
        method_name = self._base_method + 'importTargetContacts'
        return self._call(method_name, params)

    def removeOfficeUsers(self, account_id: str = None, ids: str = None) -> dict:
        """
        Удаляет администраторов и/или наблюдателей из рекламного кабинета.

        :param account_id: идентификатор рекламного кабинета.
        :param ids: сериализованный JSON-массив, содержащий id удаляемых администраторов.

        :return: Возвращает массив значений - ответов на каждый запрос в массиве data. Соответствующее значение в
            выходном массиве равно true, если администратор успешно удален, и false в другом случае
        """

        params = locals()
        method_name = self._base_method + 'removeOfficeUsers'
        return self._call(method_name, params)

    def removeTargetContacts(self, account_id: str = None, client_id: str = None, target_group_id: str = None,
                             contacts: str = None) -> dict:
        """
        Принимает запрос на исключение контактов рекламодателя из аудитории ретаргетинга.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Только для рекламных агентств.  id клиента, в рекламном кабинете которого находится
            аудитория.
        :param target_group_id: идентификатор аудитории таргетинга.
        :param contacts: список телефонов, email адресов или идентификаторов пользователей, указанных через
            запятую. Также принимаются их MD5-хеши.

        :return: Возвращает 1 в случае успешного принятия заявки на исключение аудитории
        """

        params = locals()
        method_name = self._base_method + 'removeTargetContacts'
        return self._call(method_name, params)

    def saveLookalikeRequestResult(self, account_id: str = None, client_id: str = None, request_id: str = None,
                                   level: str = None) -> dict:
        """
        Сохраняет результат поиска похожей аудитории.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Только для рекламных агентств.  идентификатор клиента, для которого будут сохраняться
            аудитория.
        :param request_id: Идентификатор запроса на поиск похожей аудитории. Получить список всех запросов на
            поиск похожей аудитории для данного кабинета можно с помощью ads.getLookalikeRequests
        :param level: Уровень конкретного размера похожей аудитории для сохранения. Получить список всех
            доступных размеров аудиторий можно с помощью ads.getLookalikeRequests.

        :return: Возвращает объект с полями:    retargeting_group_id – идентификатор группы ретаргетинга, в
            которую будет сохранена запрошенная похожая аудитория.  audience_count – размер запрошенной похожей
            аудитории
        """

        params = locals()
        method_name = self._base_method + 'saveLookalikeRequestResult'
        return self._call(method_name, params)

    def shareTargetGroup(self, account_id: str = None, client_id: str = None, target_group_id: str = None,
                         share_with_client_id: str = None) -> dict:
        """
        Предоставляет доступ к аудитории ретаргетинга другому рекламному кабинету. В результате выполнения метода
        возвращается идентификатор аудитории для указанного кабинета.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Только для рекламных агентств.  id клиента, в рекламном кабинете которого находится
            исходная аудитория.
        :param target_group_id: идентификатор исходной аудитории.
        :param share_with_client_id: id клиента, рекламному кабинету которого необходимо предоставить доступ к
            аудитории.

        :return: Возвращает объект со следующими полями:   id — идентификатор аудитории
        """

        params = locals()
        method_name = self._base_method + 'shareTargetGroup'
        return self._call(method_name, params)

    def updateAds(self, account_id: str = None, data: str = None) -> dict:
        """
        Редактирует рекламные объявления.

        :param account_id: идентификатор рекламного кабинета.
        :param data: сериализованный JSON-массив объектов, описывающих изменения в объявлениях. Описание объектов
            ad_edit_specification см. ниже.  Максимальное допустимое количество объявлений,  редактируемых с помощью
            одного запроса — 5. Если нужно больше, то можно использовать execute.

        :return: Возвращает массив ответов на каждый запрос в массиве data. Соответствующий объект в выходном
            массиве содержит идентификатор изменяемого объявления и, в случае возникновения ошибки, поля error_code и
            error_desc
        """

        params = locals()
        method_name = self._base_method + 'updateAds'
        return self._call(method_name, params)

    def updateCampaigns(self, account_id: str = None, data: str = None) -> dict:
        """
        Редактирует рекламные кампании.

        :param account_id: идентификатор рекламного кабинета.
        :param data: Сериализованный JSON-массив объектов, описывающих изменения в кампаниях. Описание объектов
            campaign_mod_specification см. ниже.

        :return: Возвращает массив ответов на каждый запрос в массиве data. Соответствующий объект в выходном
            массиве содержит идентификатор изменяемого клиента и, в случае возникновения ошибки, поля error_code и
            error_desc
        """

        params = locals()
        method_name = self._base_method + 'updateCampaigns'
        return self._call(method_name, params)

    def updateClients(self, account_id: str = None, data: str = None) -> dict:
        """
        Редактирует клиентов рекламного агентства.

        :param account_id: идентификатор рекламного кабинета.
        :param data: сериализованный JSON-массив объектов, описывающих изменения в клиентах. Описание объектов
            client_mod_specification см. ниже.

        :return: Возвращает массив ответов на каждый запрос в массиве data. Соответствующий объект в выходном
            массиве содержит id изменяемого клиента и, в случае возникновения ошибки, поля error_code и error_desc
        """

        params = locals()
        method_name = self._base_method + 'updateClients'
        return self._call(method_name, params)

    def updateTargetGroup(self, account_id: str = None, client_id: str = None, target_group_id: str = None,
                          name: str = None, domain: str = None, lifetime: str = None, target_pixel_id: str = None,
                          target_pixel_rules: str = None) -> dict:
        """
        Редактирует аудиторию ретаргетинга.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Только для рекламных агентств.  id клиента, в рекламном кабинете которого будет
            редактироваться аудитория.
        :param target_group_id: идентификатор аудитории.
        :param name: новое название аудитории ретаргетинга — строка до 64 символов.
        :param domain: Домен сайта, на котором будет размещен код учета пользователей.  Устаревший параметр.
            Используется только для старых групп ретаргетинга, которые пополнялись без помощи пикселя. Для новых
            аудиторий его следует опускать, иначе будет возвращена ошибка.
        :param lifetime: Количество дней, через которое пользователи, добавляемые в аудиторию, будут
            автоматически исключены из нее.
        :param target_pixel_id: Передайте в этом параметре идентификатор пикселя, если требуется собирать
            аудиторию с веб-сайта.
        :param target_pixel_rules: Закодированный в JSON массив правил, в соответствии с которыми будет
            пополняться аудитория из пикселя. Подробнее см. документацию метода ads.createTargetGroup.

        :return: В случае успеха метод возвратит 1
        """

        params = locals()
        method_name = self._base_method + 'updateTargetGroup'
        return self._call(method_name, params)

    def updateTargetPixel(self, account_id: str = None, client_id: str = None, target_pixel_id: str = None,
                          name: str = None, domain: str = None, category_id: str = None) -> dict:
        """
        Редактирует пиксель ретаргетинга.

        :param account_id: идентификатор рекламного кабинета.
        :param client_id: Только для рекламных агентств.  id клиента, в рекламном кабинете которого находится
            пиксель.
        :param target_pixel_id: идентификатор пикселя.
        :param name: новое название пикселя — строка до 64 символов.
        :param domain: новый домен сайта, на котором будет размещен код пикселя.
        :param category_id: новый идентификатор категории сайта, на котором будет размещен пиксель. Для получения
            списка возможных идентификаторов можно использовать метод ads.getSuggestions (раздел
            interest_categories).

        :return: После успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'updateTargetPixel'
        return self._call(method_name, params)

