#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.pfx',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20211031',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    'Easy context prefixes for messages.',
  long_description =
    ('Dynamic message prefixes providing execution context.\n'    
 '\n'    
 '*Latest release 20211031*:\n'    
 'Pfx.prefixify_exception: skip attributes which are None.\n'    
 '\n'    
 'The primary facility here is `Pfx`,\n'    
 'a context manager which maintains a per thread stack of context prefixes.\n'    
 'There are also decorators for functions.\n'    
 'This stack is used to prefix logging messages and exception text with '    
 'context.\n'    
 '\n'    
 'Usage is like this:\n'    
 '\n'    
 '    from cs.logutils import setup_logging, info\n'    
 '    from cs.pfx import Pfx\n'    
 '    ...\n'    
 '    setup_logging()\n'    
 '    ...\n'    
 '    def parser(filename):\n'    
 '      with Pfx(filename):\n'    
 '        with open(filename) as f:\n'    
 '          for lineno, line in enumerate(f, 1):\n'    
 '            with Pfx(lineno) as P:\n'    
 '              if line_is_invalid(line):\n'    
 '                raise ValueError("problem!")\n'    
 '              info("line = %r", line)\n'    
 '\n'    
 'This produces log messages like:\n'    
 '\n'    
 "    datafile: 1: line = 'foo\\n'\n"    
 '\n'    
 'and exception messages like:\n'    
 '\n'    
 '    datafile: 17: problem!\n'    
 '\n'    
 'which lets one put just the relevant complaint in exception and log\n'    
 'messages and get useful calling context on the output.\n'    
 'This does make for wordier logs and exceptions\n'    
 'but used with a little discretion produces far more debuggable results.\n'    
 '\n'    
 '## Class `Pfx`\n'    
 '\n'    
 'A context manager to maintain a per-thread stack of message prefixes.\n'    
 '\n'    
 '### Method `Pfx.__init__(self, mark, *args, **kwargs)`\n'    
 '\n'    
 'Initialise a new Pfx instance.\n'    
 '\n'    
 'Parameters:\n'    
 '* `mark`: message prefix string\n'    
 '* `args`: if not empty, apply to the prefix string with `%`\n'    
 '* `absolute`: optional keyword argument, default `False`. If\n'    
 '  true, this message forms the base of the message prefixes;\n'    
 '  earlier prefixes will be suppressed.\n'    
 '* `loggers`: which loggers should receive log messages.\n'    
 '* `print`: if true, print the `mark` on entry to the `with` suite.\n'    
 '  This may be a `bool`, implying `print()` if `True`,\n'    
 '  a callable which works like `print()`,\n'    
 '  or a file-like object which implies using `print(...,file=print)`.\n'    
 '\n'    
 '*Note*:\n'    
 'the `mark` and `args` are only combined if the `Pfx` instance gets used,\n'    
 'for example for logging or to annotate an exception.\n'    
 'Otherwise, they are not combined.\n'    
 'Therefore the values interpolated are as they are when the `Pfx` is used,\n'    
 'not necessarily as they were when the `Pfx` was created.\n'    
 'If the `args` are subject to change and you require the original values,\n'    
 'apply them to `mark` immediately, for example:\n'    
 '\n'    
 "    with Pfx('message %s ...' % (arg1, arg2, ...)):\n"    
 '\n'    
 'This is a bit more expensive as it incurs the formatting cost\n'    
 'whenever you enter the `with` clause.\n'    
 'The common usage is:\n'    
 '\n'    
 "    with Pfx('message %s ...', arg1, arg2, ...):\n"    
 '\n'    
 '### Method `Pfx.critical(*a, **kw)`\n'    
 '\n'    
 'Emit a critical log message.\n'    
 '\n'    
 '### Method `Pfx.debug(*a, **kw)`\n'    
 '\n'    
 'Emit a debug log message.\n'    
 '\n'    
 '### Method `Pfx.error(*a, **kw)`\n'    
 '\n'    
 'Emit an error log message.\n'    
 '\n'    
 '### Method `Pfx.exception(*a, **kw)`\n'    
 '\n'    
 "Log an exception message to this Pfx's loggers.\n"    
 '\n'    
 '### Method `Pfx.info(*a, **kw)`\n'    
 '\n'    
 'Emit an info log message.\n'    
 '\n'    
 '### Method `Pfx.log(*a, **kw)`\n'    
 '\n'    
 "Log a message at an arbitrary log level to this Pfx's loggers.\n"    
 '\n'    
 '### Property `Pfx.loggers`\n'    
 '\n'    
 'Return the loggers to use for this Pfx instance.\n'    
 '\n'    
 '### Method `Pfx.logto(self, new_loggers)`\n'    
 '\n'    
 'Define the Loggers anew.\n'    
 '\n'    
 '### Method `Pfx.partial(self, func, *a, **kw)`\n'    
 '\n'    
 'Return a function that will run the supplied function `func`\n'    
 'within a surrounding Pfx context with the current mark string.\n'    
 '\n'    
 'This is intended for deferred call facilities like\n'    
 'WorkerThreadPool, Later, and futures.\n'    
 '\n'    
 '### Method `Pfx.prefixify(text)`\n'    
 '\n'    
 'Return `text` with the current prefix prepended.\n'    
 'Return `text` unchanged if it is not a string.\n'    
 '\n'    
 '### Method `Pfx.prefixify_exception(e)`\n'    
 '\n'    
 'Modify the supplied exception `e` with the current prefix.\n'    
 'Return `True` if modified, `False` if unable to modify.\n'    
 '\n'    
 '### Property `Pfx.umark`\n'    
 '\n'    
 'Return the unicode message mark for use with this Pfx.\n'    
 '\n'    
 'This is used by Pfx._state.prefix to compute the full prefix.\n'    
 '\n'    
 '### Method `Pfx.warning(*a, **kw)`\n'    
 '\n'    
 'Emit a warning log message.\n'    
 '\n'    
 '## Function `pfx(*da, **dkw)`\n'    
 '\n'    
 'General purpose @pfx for generators, methods etc.\n'    
 '\n'    
 'Parameters:\n'    
 '* `func`: the function or generator function to decorate\n'    
 '* `message`: optional prefix to use instead of the function name\n'    
 '* `message_args`: optional arguments to embed in the preifx using `%`\n'    
 '\n'    
 'Example usage:\n'    
 '\n'    
 '    @pfx\n'    
 '    def f(....):\n'    
 '        ....\n'    
 '\n'    
 '## Function `pfx_call(func, *a, **kw)`\n'    
 '\n'    
 'Call `func(*a,**kw)` within an enclosing `Pfx` context manager\n'    
 'reciting the function name and arguments.\n'    
 '\n'    
 'Example:\n'    
 '\n'    
 '    >>> import os\n'    
 '    >>> pfx_call(os.rename, "oldname", "newname")\n'    
 '\n'    
 '## Function `pfx_iter(tag, iterable)`\n'    
 '\n'    
 'Wrapper for iterables to prefix exceptions with `tag`.\n'    
 '\n'    
 '## Function `pfx_method(*da, **dkw)`\n'    
 '\n'    
 'Decorator to provide a `Pfx` context for an instance method prefixing\n'    
 '*classname.methodname*.\n'    
 '\n'    
 'If `use_str` is true (default `False`)\n'    
 'use `str(self)` instead of `classname`.\n'    
 '\n'    
 'If `with_args` is true (default `False`)\n'    
 'include the specified arguments in the `Pfx` context.\n'    
 'If `with_args` is `True`, this includes all the arguments.\n'    
 'Otherwise `with_args` should be a sequence of argument references:\n'    
 'an `int` specifies one of the positional arguments\n'    
 'and a string specifies one of the keyword arguments.\n'    
 '\n'    
 'Examples:\n'    
 '\n'    
 '    class O:\n'    
 '        # just use "O.foo"\n'    
 '        @pfx_method\n'    
 '        def foo(self, .....):\n'    
 '            ....\n'    
 '        # use the value of self instead of the class name\n'    
 '        @pfx_method(use_str=True)\n'    
 '        def foo2(self, .....):\n'    
 '            ....\n'    
 '        # include all the arguments\n'    
 '        @pfx_method(with_args=True)\n'    
 '        def foo3(self, a, b, c, *, x=1, y):\n'    
 '            ....\n'    
 '        # include the "b", "c" and "x" arguments\n'    
 "        @pfx_method(with_args=[1,2,'x'])\n"    
 '        def foo3(self, a, b, c, *, x=1, y):\n'    
 '            ....\n'    
 '\n'    
 '## Class `PfxCallInfo(Pfx)`\n'    
 '\n'    
 'Subclass of Pfx to insert current function and caller into messages.\n'    
 '\n'    
 '## Function `pfxprint(*a, **kw)`\n'    
 '\n'    
 'Call `print()` with the current prefix.\n'    
 '\n'    
 '## Function `PfxThread(target=None, **kw)`\n'    
 '\n'    
 'Factory function returning a Thread\n'    
 'which presents the current prefix as context.\n'    
 '\n'    
 '## Function `prefix()`\n'    
 '\n'    
 'Return the current Pfx prefix.\n'    
 '\n'    
 '## Function `PrePfx(tag, *args)`\n'    
 '\n'    
 'Push a temporary value for Pfx._state._ur_prefix to enloundenify messages.\n'    
 '\n'    
 '## Function `unpfx(s, sep=None)`\n'    
 '\n'    
 'Strip the leading prefix from the string `s`\n'    
 'using the prefix delimiter `sep`\n'    
 "(default from `DEFAULT_SEPARATOR`: `': '`).\n"    
 '\n'    
 'This is a simple hack to support reporting error messages\n'    
 'which have had a preifx applied,\n'    
 'and fails accordingly if the base message itself contains the separator.\n'    
 '\n'    
 '## Function `XP(msg, *args, **kwargs)`\n'    
 '\n'    
 'Variation on `cs.x.X`\n'    
 'which prefixes the message with the current Pfx prefix.\n'    
 '\n'    
 '## Function `XX(prepfx, msg, *args, **kwargs)`\n'    
 '\n'    
 'Trite wrapper for `XP()` to transiently insert a leading prefix string.\n'    
 '\n'    
 'Example:\n'    
 '\n'    
 '    XX("NOTE!", "some message")\n'    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20211031*:\n'    
 'Pfx.prefixify_exception: skip attributes which are None.\n'    
 '\n'    
 '*Release 20210913*:\n'    
 'Pfx: do not fiddle with LookupError.args[0], it is the key.\n'    
 '\n'    
 '*Release 20210906*:\n'    
 '* New pfxprint which calls print() with the current prefix.\n'    
 '* Pfx.prefixify_exception: catch unexpected OSError.args value and report.\n'    
 '* @pfx: use pfx_call if there is no presupplied message argument.\n'    
 '\n'    
 '*Release 20210801*:\n'    
 'Bugfix for @pfx.\n'    
 '\n'    
 '*Release 20210731*:\n'    
 '* Pfx.__exit__: special handling for some exception types.\n'    
 '* New pfx_call(func,*a,**kw) function to concisely wrap single function '    
 'calls.\n'    
 '\n'    
 '*Release 20210717*:\n'    
 '@pfx_method: new optional decorator argument "with_args" to include some or '    
 'all arguments in the Pfx context.\n'    
 '\n'    
 '*Release 20201227*:\n'    
 '* Pfx: new print=False option to issue a print() or other call on entry to '    
 'the with-suite eg with Pfx(....,print=verbose).\n'    
 '* Pfx: print= now also accepts a file-like object.\n'    
 '\n'    
 '*Release 20201105*:\n'    
 '@pfx: bugfix for generator functions.\n'    
 '\n'    
 '*Release 20201025*:\n'    
 '* Refactor @pfx using @cs.deco.contextdecorator.\n'    
 '* New unpfx() function, a crude hack to strip an applpied cs.pfx prefix from '    
 'a string.\n'    
 '* XP: just shim cs.x.X as callers expect, toss dubious extra functionality.\n'    
 '* exception(): plumb keyword arguments.\n'    
 '\n'    
 '*Release 20200517*:\n'    
 '* @pfx: handle normal functions and also generators, improve behaviour with '    
 'the wrapped docstring.\n'    
 '* @pfx_method: @pfx for methods.\n'    
 '* @pfxtag obsoleted by new @pfx.\n'    
 '\n'    
 '*Release 20191004*:\n'    
 '@pfx_method: new optional `use_str` parameter to use str(self) instead of '    
 'type(self).__name__; now requires @cs.deco.decorator\n'    
 '\n'    
 '*Release 20190905*:\n'    
 '* Pfx.__exit__: simplify prefixify_exc() logic, prefixify all suitable '    
 'attributes.\n'    
 '* New @pfx_method decorator for instance methods.\n'    
 '\n'    
 '*Release 20190607*:\n'    
 'Pfx.__exit__ improved exception attribute handling.\n'    
 '\n'    
 '*Release 20190403*:\n'    
 'Debugging aid: Pfx.umark: emit stack traceback on format conversion error.\n'    
 '\n'    
 '*Release 20190327*:\n'    
 '* @pfx: set __name__ on the wrapper function.\n'    
 '* Bugfix some references to the internal prefixify function.\n'    
 '\n'    
 '*Release 20190324*:\n'    
 'Pfx.__exit__: apply the prefix to all the standard attributes where present, '    
 'improves some message behaviour for some exception types.\n'    
 '\n'    
 '*Release 20181231*:\n'    
 'Bugfix for an infinite regress.\n'    
 '\n'    
 '*Release 20181109*:\n'    
 '* Update @contextmanager formalism to use try/finally for the cleanup '    
 'phase.\n'    
 '* New decorator @gen to manage Pfx state across generator iterations; pretty '    
 'clunky.\n'    
 '* Better fallback handling.\n'    
 '* Some docstring updates.\n'    
 '\n'    
 '*Release 20170910*:\n'    
 'Slight linting.\n'    
 '\n'    
 '*Release 20170903.1*:\n'    
 'corrections to the module docstring\n'    
 '\n'    
 '*Release 20170903*:\n'    
 'Initial release for PyPI.'),
  install_requires = ['cs.deco', 'cs.py.func>=20210913', 'cs.py3', 'cs.x'],
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.pfx'],
)
