"""AWS Route53 related constants."""

AWS_SERVICE_HOSTED_ZONES = {
    "cloudfront": "Z2FDTNDATAQYW2",  # Cloudfront
    "s3_website": {  # S3 with static website
        "us-east-1": "Z3AQBSTGFYJSTF",
        "us-east-2": "Z2O1EMRO9K5GLX",
        "us-west-1": "Z2F56UZL2M1ACD",
        "us-west-2": "Z3BJ6K6RIION7M",
        "ap-northeast-1": "Z2M4EHUR26P7ZW",
        "ap-northeast-2": "Z3W03O7B5YMIYP",
        "ap-northeast-3": "Z2YQB5RD63NC85",
        "ap-southeast-1": "Z3O0J2DXBE1FTB",
        "ap-southeast-2": "Z1WCIGYICN2BYD",
        "ap-south-1": "Z11RGJOFQNVJUP",
        "eu-west-1": "Z1BKCTXD74EZPE",
        "eu-west-2": "Z3GKZC51ZF0DB4",
        "eu-west-3": "Z3R1K369G5AVDG",
        "eu-central-1": "Z21DNDUVLTQW6Q",
        "sa-east-1": "Z7KQH4QJS55SO",
        "ca-central-1": "Z1QDHH18159H29",
        "me-south-1": "Z2BBQYZJUSSK8Q",
        "af-south-1": "Z11GT3Q7H5JZKS",
    },
    "api_gateway": {  # API Gateway
        "us-east-1": "Z1UJRXOUMOOFQ8",
        "us-east-2": "ZOJJZC49E0EPZ",
        "us-west-1": "Z2MUQ32089INYE",
        "us-west-2": "Z2OJLYMUO9EFXC",
        "ap-northeast-1": "Z1YSHQZHG15GKL",
        "ap-northeast-2": "Z20JF4UZKIW1U8",
        "ap-southeast-1": "ZL327KTPIQFUL",
        "ap-southeast-2": "Z2RPCDW04V8134",
        "ap-south-1": "Z3VO1THU9YC4UR",
        "eu-west-1": "ZLY8HYME6SFDD",
        "eu-west-2": "ZJ5UAJN8Y3Z2Q",
        "eu-west-3": "Z3KY65QIEKYHQQ",
        "eu-central-1": "Z1U9ULNL0V5AJ3",
        "sa-east-1": "ZCMLWB8V5SYIT",
        "ca-central-1": "Z19DQILCVRWHZC",
        "me-south-1": "Z31Z5GOMECCQCV",
        "af-south-1": "Z1FOI1FXQRO6CD",
    },
    "elasticbeanstalk": {  # Elastic Beanstalk
        "us-east-1": "Z117KPS5GTRQ2G",
        "us-east-2": "Z14LCN19Q5QHIC",
        "us-west-1": "Z1LQECGX5PH1X",
        "us-west-2": "Z38NKT9BP95V3O",
        "ap-northeast-1": "Z1R25G3KIG2GBW",
        "ap-northeast-2": "Z3JE5OI70TWKCP",
        "ap-southeast-1": "Z16FZ9L249IFLT",
        "ap-southeast-2": "Z2PCDNR3VC2G1N",
        "ap-south-1": "Z18NTBI3Y7N9TZ",
        "eu-west-1": "Z2NYPWQ7DFZAZH",
        "eu-west-2": "Z1GKAAAUGATPF1",
        "eu-west-3": "Z1LW3ZB5I28O68",
        "eu-central-1": "Z1FRNW7UH4DEZJ",
        "sa-east-1": "Z10X7K2B4QSOFV",
        "ca-central-1": "Z1QDHH18159H29",
        "me-south-1": "Z3NTJTCZ7YREHW",
        "af-south-1": "Z13X6CMU3ZR8SH",
    },
    "appsync": {  # AppSync
        "us-east-1": "Z1P66ISYGSKC4F",
        "us-east-2": "Z7I6XT5GD93VF",
        "us-west-1": "Z3WHC1DSMS7JGS",
        "us-west-2": "Z2RB0JRZQULDI",
        "ap-northeast-1": "Z15FA7QTZKVTE1",
        "ap-northeast-2": "Z2SDZG7TS5RQCD",
        "ap-southeast-1": "ZON7DMCY9TL69",
        "ap-southeast-2": "Z2A8D54X37CUD8",
        "ap-south-1": "Z1L4A8C0FP41X1",
        "eu-west-1": "Z18R54LFE6LBUT",
        "eu-west-2": "Z2CRZZFATM5MEG",
        "eu-west-3": "Z1YMI1KZOFZNGI",
        "eu-central-1": "Z31O8ZN09A9C53",
        "sa-east-1": "Z106SSYVP7YH8S",
        "ca-central-1": "Z203ST2E40QFWH",
        "me-south-1": "Z3TH0DZZ8NPI1K",
        "af-south-1": "Z3O9G3HZ51AEXN",
    },
    "elb": {  # Application Load Balancer and Classic Load Balancer
        "us-east-1": "Z35SXDOTRQ7X7K",
        "us-east-2": "Z3AADJGX6KTTL2",
        "us-west-1": "Z368ELLRRE2KJ0",
        "us-west-2": "Z1H1FL5HABSF5",
        "ap-northeast-1": "Z14GRHDCWA56QT",
        "ap-northeast-2": "Z3JE5OI70TWKCP",
        "ap-southeast-1": "Z1LMS91P8CMLE5",
        "ap-southeast-2": "Z1GM3OXH4ZPM65",
        "ap-south-1": "Z18NTBI3Y7N9TZ",
        "eu-west-1": "Z32O12XQLNTSW2",
        "eu-west-2": "Z33MTJ483KN6FU",
        "eu-west-3": "Z2IFOLAFXWLO4F",
        "eu-central-1": "Z215JYRZR1TBD5",
        "sa-east-1": "ZTK26PT1VY4CU",
        "ca-central-1": "ZQSVJUPU6J1EY",
        "me-south-1": "Z3QSRYVP46NYYV",
        "af-south-1": "Z203XCE67M25XG",
    },
    "nlb": {  # Network Load Balancer
        "us-east-1": "Z26RNL4JYFTOTI",
        "us-east-2": "ZLMOA37VPKANP",
        "us-west-1": "Z24FKFUX50B4VW",
        "us-west-2": "Z18D5FSROUN65G",
        "ap-northeast-1": "Z1R25G3KIG2GBW",
        "ap-northeast-2": "Z232D6QH1NK2GB",
        "ap-southeast-1": "ZKVM4W9LS7TM",
        "ap-southeast-2": "ZCT6FZBF4DROD",
        "ap-south-1": "ZVDDRBQ08TROA",
        "eu-west-1": "Z32O12XQLNTSW2",
        "eu-west-2": "Z33MTJ483KN6FU",
        "eu-west-3": "Z2IFOLAFXWLO4F",
        "eu-central-1": "Z1LXJX6V5MMRA9",
        "sa-east-1": "ZTK26PT1VY4CU",
        "ca-central-1": "ZQSVJUPU6J1EY",
        "me-south-1": "Z3QSRYVP46NYYV",
        "af-south-1": "Z203XCE67M25XG",
    },
}
