from typing import Any

from pydantic import BaseModel, Field

from chainsaws.aws.shared.config import APIConfig


class IAMAPIConfig(APIConfig):
    """IAM API configuration."""

    max_retries: int = Field(
        3,
        description="Maximum number of API call retries",
    )
    timeout: int = Field(
        30,
        description="Timeout for API calls in seconds",
    )


class RoleConfig(BaseModel):
    """IAM Role configuration."""

    name: str = Field(..., description="Role name")
    trust_policy: dict[str, Any] = Field(
        ...,
        description="Trust policy document",
    )
    description: str = Field(
        "Generated by Chainsaws IAM API",
        description="Role description",
    )


class RolePolicyConfig(BaseModel):
    """IAM Role Policy configuration."""

    role_name: str = Field(..., description="Role name")
    policy_name: str = Field(..., description="Policy name")
    policy_document: dict[str, Any] = Field(
        ...,
        description="Policy document",
    )
