# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, constr


class VideoFilesDownloadModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    video_id: Optional[StrictStr] = Field(None, alias="videoId", description="The unique identifier of the video")
    url: Optional[constr(strict=True, max_length=200)] = Field(None, description="The URL where the file can be found")
    __properties = ["videoId", "url"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VideoFilesDownloadModel:
        """Create an instance of VideoFilesDownloadModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "video_id",
                "url",
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VideoFilesDownloadModel:
        """Create an instance of VideoFilesDownloadModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return VideoFilesDownloadModel.parse_obj(obj)

        _obj = VideoFilesDownloadModel.parse_obj({"video_id": obj.get("videoId"), "url": obj.get("url")})
        return _obj
