# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictStr


class TransferComponent(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    person_id: Optional[StrictStr] = Field(None, alias="personId", description="The uuid of the person")
    from_entity_group_id: Optional[StrictStr] = Field(
        None, alias="fromEntityGroupId", description="The uuid of the source entity group"
    )
    to_entity_group_id: Optional[StrictStr] = Field(
        None, alias="toEntityGroupId", description="The uuid of the destination entity group"
    )
    extra_allowances: Optional[StrictStr] = Field(
        None, alias="extraAllowances", description="Details of additional allowances included in the transfer"
    )
    __properties = ["personId", "fromEntityGroupId", "toEntityGroupId", "extraAllowances"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransferComponent:
        """Create an instance of TransferComponent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransferComponent:
        """Create an instance of TransferComponent from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TransferComponent.parse_obj(obj)

        _obj = TransferComponent.parse_obj(
            {
                "person_id": obj.get("personId"),
                "from_entity_group_id": obj.get("fromEntityGroupId"),
                "to_entity_group_id": obj.get("toEntityGroupId"),
                "extra_allowances": obj.get("extraAllowances"),
            }
        )
        return _obj
