# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import List, Optional

from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictStr, validator

from atriumsports.datacore.openapi.models.head_to_head_identification import HeadToHeadIdentification
from atriumsports.datacore.openapi.models.head_to_head_identification_for_subsequent_checks import (
    HeadToHeadIdentificationForSubsequentChecks,
)
from atriumsports.datacore.openapi.models.head_to_head_resolution import HeadToHeadResolution
from atriumsports.datacore.openapi.models.head_to_head_resolution_for_extra_depth_h2h_s import (
    HeadToHeadResolutionForExtraDepthH2hS,
)
from atriumsports.datacore.openapi.models.sorting import Sorting


class StandingConfiguration(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    wins_home_points: Optional[StrictFloat] = Field(None, alias="winsHomePoints", description="Points for Home Win")
    losses_home_points: Optional[StrictFloat] = Field(
        None, alias="lossesHomePoints", description="Points for Home Loss"
    )
    draws_home_scored_points: Optional[StrictFloat] = Field(
        None, alias="drawsHomeScoredPoints", description="Points for Home Draw where entity scored"
    )
    draws_home_zero_points: Optional[StrictFloat] = Field(
        None, alias="drawsHomeZeroPoints", description="Points for Home Draw with zero score"
    )
    forfeit_won_by_home_points: Optional[StrictFloat] = Field(
        None, alias="forfeitWonByHomePoints", description="Points for won by Forfeit at home"
    )
    forfeits_won_by_home_points: Optional[StrictFloat] = Field(
        None, alias="forfeitsWonByHomePoints", description="Points for won by Forfeit at home"
    )
    forfeit_given_home_points: Optional[StrictFloat] = Field(
        None, alias="forfeitGivenHomePoints", description="Points for giving a forfeit at home"
    )
    wins_away_points: Optional[StrictFloat] = Field(None, alias="winsAwayPoints", description="Points for Away Win")
    losses_away_points: Optional[StrictFloat] = Field(
        None, alias="lossesAwayPoints", description="Points for Away Loss"
    )
    draws_away_scored_points: Optional[StrictFloat] = Field(
        None, alias="drawsAwayScoredPoints", description="Points for Away Draw where entity scored"
    )
    draws_away_zero_points: Optional[StrictFloat] = Field(
        None, alias="drawsAwayZeroPoints", description="Points for Away Draw with zero score"
    )
    forfeit_won_by_away_points: Optional[StrictFloat] = Field(
        None, alias="forfeitWonByAwayPoints", description="Points for won by Forfeit at away"
    )
    forfeit_given_away_points: Optional[StrictFloat] = Field(
        None, alias="forfeitGivenAwayPoints", description="Points for giving a forfeit at away"
    )
    bye_points: Optional[StrictFloat] = Field(None, alias="byePoints", description="Points for bye")
    bye_is_played: Optional[StrictBool] = Field(None, alias="byeIsPlayed", description="Is a Bye added to played ?")
    bye_added_wins: Optional[StrictBool] = Field(None, alias="byeAddedWins", description="Is a Bye added to won count?")
    forfeit_won_by_added_wins: Optional[StrictBool] = Field(
        None, alias="forfeitWonByAddedWins", description="Is a forfeit won by (received) included in won count ?"
    )
    forfeit_won_by_added_played: Optional[StrictBool] = Field(
        None, alias="forfeitWonByAddedPlayed", description="Is a forfeit won by (received) included in played count ?"
    )
    forfeit_given_added_losses: Optional[StrictBool] = Field(
        None, alias="forfeitGivenAddedLosses", description="Is a forfeit given included in losses count ?"
    )
    forfeit_given_added_played: Optional[StrictBool] = Field(
        None, alias="forfeitGivenAddedPlayed", description="Is a forfeit given included in played count ?"
    )
    streak: Optional[StrictStr] = Field(None, description="How is a streak calculated ?")
    sorts: Optional[List[Sorting]] = Field(None, description="Sortings")
    head_to_head_identification: Optional[List[HeadToHeadIdentification]] = Field(
        None, alias="headToHeadIdentification", description="Head to head identifications"
    )
    head_to_head_identification_subsequent: Optional[List[HeadToHeadIdentificationForSubsequentChecks]] = Field(
        None,
        alias="headToHeadIdentificationSubsequent",
        description="Head to head identifications for subsequent checks",
    )
    head_to_head_use_adjustments: Optional[StrictBool] = Field(
        None,
        alias="headToHeadUseAdjustments",
        description="Apply Standing Adjustments when performing Head to head resolutions?",
    )
    head_to_head_single_round: Optional[StrictBool] = Field(
        None, alias="headToHeadSingleRound", description="Only use single round for Head to head resolutions?"
    )
    head_to_head_resolutions: Optional[List[HeadToHeadResolution]] = Field(
        None, alias="headToHeadResolutions", description="Head to head resolutions"
    )
    head_to_head_resolutions_subsequent: Optional[List[HeadToHeadResolutionForExtraDepthH2hS]] = Field(
        None, alias="headToHeadResolutionsSubsequent", description="Head to head resolutions for extra depth h2h's"
    )
    __properties = [
        "winsHomePoints",
        "lossesHomePoints",
        "drawsHomeScoredPoints",
        "drawsHomeZeroPoints",
        "forfeitWonByHomePoints",
        "forfeitsWonByHomePoints",
        "forfeitGivenHomePoints",
        "winsAwayPoints",
        "lossesAwayPoints",
        "drawsAwayScoredPoints",
        "drawsAwayZeroPoints",
        "forfeitWonByAwayPoints",
        "forfeitGivenAwayPoints",
        "byePoints",
        "byeIsPlayed",
        "byeAddedWins",
        "forfeitWonByAddedWins",
        "forfeitWonByAddedPlayed",
        "forfeitGivenAddedLosses",
        "forfeitGivenAddedPlayed",
        "streak",
        "sorts",
        "headToHeadIdentification",
        "headToHeadIdentificationSubsequent",
        "headToHeadUseAdjustments",
        "headToHeadSingleRound",
        "headToHeadResolutions",
        "headToHeadResolutionsSubsequent",
    ]

    @validator("streak")
    def streak_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("WON", "NONLOST"):
            raise ValueError("must validate the enum values ('WON', 'NONLOST')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StandingConfiguration:
        """Create an instance of StandingConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in sorts (list)
        _items = []
        if self.sorts:
            for _item in self.sorts:
                if _item:
                    _items.append(_item.to_dict())
            _dict["sorts"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in head_to_head_identification (list)
        _items = []
        if self.head_to_head_identification:
            for _item in self.head_to_head_identification:
                if _item:
                    _items.append(_item.to_dict())
            _dict["headToHeadIdentification"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in head_to_head_identification_subsequent (list)
        _items = []
        if self.head_to_head_identification_subsequent:
            for _item in self.head_to_head_identification_subsequent:
                if _item:
                    _items.append(_item.to_dict())
            _dict["headToHeadIdentificationSubsequent"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in head_to_head_resolutions (list)
        _items = []
        if self.head_to_head_resolutions:
            for _item in self.head_to_head_resolutions:
                if _item:
                    _items.append(_item.to_dict())
            _dict["headToHeadResolutions"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in head_to_head_resolutions_subsequent (list)
        _items = []
        if self.head_to_head_resolutions_subsequent:
            for _item in self.head_to_head_resolutions_subsequent:
                if _item:
                    _items.append(_item.to_dict())
            _dict["headToHeadResolutionsSubsequent"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StandingConfiguration:
        """Create an instance of StandingConfiguration from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StandingConfiguration.parse_obj(obj)

        _obj = StandingConfiguration.parse_obj(
            {
                "wins_home_points": obj.get("winsHomePoints"),
                "losses_home_points": obj.get("lossesHomePoints"),
                "draws_home_scored_points": obj.get("drawsHomeScoredPoints"),
                "draws_home_zero_points": obj.get("drawsHomeZeroPoints"),
                "forfeit_won_by_home_points": obj.get("forfeitWonByHomePoints"),
                "forfeits_won_by_home_points": obj.get("forfeitsWonByHomePoints"),
                "forfeit_given_home_points": obj.get("forfeitGivenHomePoints"),
                "wins_away_points": obj.get("winsAwayPoints"),
                "losses_away_points": obj.get("lossesAwayPoints"),
                "draws_away_scored_points": obj.get("drawsAwayScoredPoints"),
                "draws_away_zero_points": obj.get("drawsAwayZeroPoints"),
                "forfeit_won_by_away_points": obj.get("forfeitWonByAwayPoints"),
                "forfeit_given_away_points": obj.get("forfeitGivenAwayPoints"),
                "bye_points": obj.get("byePoints"),
                "bye_is_played": obj.get("byeIsPlayed"),
                "bye_added_wins": obj.get("byeAddedWins"),
                "forfeit_won_by_added_wins": obj.get("forfeitWonByAddedWins"),
                "forfeit_won_by_added_played": obj.get("forfeitWonByAddedPlayed"),
                "forfeit_given_added_losses": obj.get("forfeitGivenAddedLosses"),
                "forfeit_given_added_played": obj.get("forfeitGivenAddedPlayed"),
                "streak": obj.get("streak"),
                "sorts": [Sorting.from_dict(_item) for _item in obj.get("sorts")]
                if obj.get("sorts") is not None
                else None,
                "head_to_head_identification": [
                    HeadToHeadIdentification.from_dict(_item) for _item in obj.get("headToHeadIdentification")
                ]
                if obj.get("headToHeadIdentification") is not None
                else None,
                "head_to_head_identification_subsequent": [
                    HeadToHeadIdentificationForSubsequentChecks.from_dict(_item)
                    for _item in obj.get("headToHeadIdentificationSubsequent")
                ]
                if obj.get("headToHeadIdentificationSubsequent") is not None
                else None,
                "head_to_head_use_adjustments": obj.get("headToHeadUseAdjustments"),
                "head_to_head_single_round": obj.get("headToHeadSingleRound"),
                "head_to_head_resolutions": [
                    HeadToHeadResolution.from_dict(_item) for _item in obj.get("headToHeadResolutions")
                ]
                if obj.get("headToHeadResolutions") is not None
                else None,
                "head_to_head_resolutions_subsequent": [
                    HeadToHeadResolutionForExtraDepthH2hS.from_dict(_item)
                    for _item in obj.get("headToHeadResolutionsSubsequent")
                ]
                if obj.get("headToHeadResolutionsSubsequent") is not None
                else None,
            }
        )
        return _obj
