# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.fixture_entities_model_conference import FixtureEntitiesModelConference
from atriumsports.datacore.openapi.models.fixture_entities_model_division import FixtureEntitiesModelDivision
from atriumsports.datacore.openapi.models.fixture_entities_model_entity import FixtureEntitiesModelEntity
from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.fixtures_model_round import FixturesModelRound
from atriumsports.datacore.openapi.models.season_fixture_stages_pools_list_model_pool import (
    SeasonFixtureStagesPoolsListModelPool,
)
from atriumsports.datacore.openapi.models.season_fixture_stages_pools_list_model_stage import (
    SeasonFixtureStagesPoolsListModelStage,
)
from atriumsports.datacore.openapi.models.standing_adjustments_model_organization import (
    StandingAdjustmentsModelOrganization,
)


class StandingAdjustmentsModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    standing_adjustment_id: Optional[StrictStr] = Field(
        None, alias="standingAdjustmentId", description="The unique identifier of the adjustment"
    )
    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    entity: Optional[FixtureEntitiesModelEntity] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[StandingAdjustmentsModelOrganization] = None
    round_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="roundCode", description="A unique code for the round. (Unique for season)"
    )
    round: Optional[FixturesModelRound] = None
    round_number: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="roundNumber", description="The number given to the round"
    )
    stage_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="stageCode", description="A unique code for the stage. (Unique for season)"
    )
    stage: Optional[SeasonFixtureStagesPoolsListModelStage] = None
    pool_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="poolCode", description="A unique code for the pool. (Unique for season)"
    )
    pool: Optional[SeasonFixtureStagesPoolsListModelPool] = None
    division_id: Optional[StrictStr] = Field(
        None, alias="divisionId", description="The unique identifier of the division"
    )
    division: Optional[FixtureEntitiesModelDivision] = None
    conference_id: Optional[StrictStr] = Field(
        None, alias="conferenceId", description="The unique identifier of the conference"
    )
    conference: Optional[FixtureEntitiesModelConference] = None
    apply_to_all_standings: Optional[StrictBool] = Field(
        None, alias="applyToAllStandings", description="Apply to all generated standing types ?"
    )
    adjustment_group: Optional[StrictStr] = Field(
        None,
        alias="adjustmentGroup",
        description="Adjustment Group >- `IN_CONFERENCE` In Conference >- `IN_DIVISION` In Division >- `OUT_CONFERENCE` Out Conference >- `OUT_DIVISION` Out Division >- `OVERALL` Overall ",
    )
    adjustment_type: Optional[StrictStr] = Field(
        None,
        alias="adjustmentType",
        description="Adjustment Type >- `ADD_MINUS` Add/Subtract Value >- `SET` Set Value ",
    )
    adjustment_field: Optional[StrictStr] = Field(
        None,
        alias="adjustmentField",
        description="Adjustment field to calculate standings >- `byes` Byes >- `draws` Games Drawn >- `drawsAway` Games Drawn (Away) >- `drawsHome` Games Drawn (Home) >- `forfeitsGiven` Forfeits Given >- `forfeitsWonBy` Forfeits Won >- `highestScoreAgainst` Highest Score Against >- `highestScoreAgainstAway` Highest Score Against (Away) >- `highestScoreAgainstHome` Highest Score Against (Home) >- `highestScoreFor` Highest Score For >- `highestScoreForAway` Highest Score For (Away) >- `highestScoreForHome` Highest Score For (Home) >- `losses` Games Lost >- `lossesAway` Games Lost (Away) >- `lossesHome` Games Lost (Home) >- `lowestScoreAgainst` Lowest Score Against >- `lowestScoreAgainstAway` Lowest Score Against (Away) >- `lowestScoreAgainstHome` Lowest Score Against (Home) >- `lowestScoreFor` Lowest Score For >- `lowestScoreForAway` Lowest Score For (Away) >- `lowestScoreForHome` Lowest Score For (Home) >- `percentage` For versus Against Percentage >- `percentageAway` For versus Against Percentage (Away) >- `percentageHome` For versus Against Percentage (Home) >- `played` Games Played >- `playedAway` Games Played (Away) >- `playedHome` Games Played (Home) >- `pointDifference` Point Difference >- `pointDifferenceAway` Point Difference (Away) >- `pointDifferenceHome` Point Difference (Home) >- `position` Standings Position >- `scoredAgainst` Score Against >- `scoredAgainstAway` Score Against (Away) >- `scoredAgainstHome` Score Against (Home) >- `scoredFor` Score For >- `scoredForAway` Score For (Away) >- `scoredForHome` Score For (Home) >- `streak` Winning Streak for competitor >- `streakAway` Winning Streak for competitor (Away) >- `streakHome` Winning Streak for competitor (Home) >- `washouts` Washouts >- `winPercentage` Win Percentage >- `winPercentageAway` Win Percentage (Away) >- `winPercentageHome` Win Percentage (Home) >- `wins` Games Won >- `winsAway` Games Won (Away) >- `winsHome` Games Won (Home) ",
    )
    adjustment_value: Optional[StrictFloat] = Field(
        None, alias="adjustmentValue", description="Value of the adjustment field"
    )
    reason_type: Optional[StrictStr] = Field(None, alias="reasonType", description="Reason type of the adjustment")
    reason_description: Optional[StrictStr] = Field(
        None, alias="reasonDescription", description="Reason for the adjustment"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "standingAdjustmentId",
        "seasonId",
        "season",
        "entityId",
        "entity",
        "organizationId",
        "organization",
        "roundCode",
        "round",
        "roundNumber",
        "stageCode",
        "stage",
        "poolCode",
        "pool",
        "divisionId",
        "division",
        "conferenceId",
        "conference",
        "applyToAllStandings",
        "adjustmentGroup",
        "adjustmentType",
        "adjustmentField",
        "adjustmentValue",
        "reasonType",
        "reasonDescription",
        "updated",
        "added",
    ]

    @validator("adjustment_group")
    def adjustment_group_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("OVERALL", "IN_CONFERENCE", "OUT_CONFERENCE", "IN_DIVISION", "OUT_DIVISION"):
            raise ValueError(
                "must validate the enum values ('OVERALL', 'IN_CONFERENCE', 'OUT_CONFERENCE', 'IN_DIVISION', 'OUT_DIVISION')"
            )
        return v

    @validator("adjustment_type")
    def adjustment_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("SET", "ADD_MINUS"):
            raise ValueError("must validate the enum values ('SET', 'ADD_MINUS')")
        return v

    @validator("adjustment_field")
    def adjustment_field_validate_enum(cls, v):
        if v is None:
            return v

        if v not in (
            "position",
            "played",
            "playedHome",
            "playedAway",
            "wins",
            "winsHome",
            "winsAway",
            "losses",
            "lossesHome",
            "lossesAway",
            "draws",
            "drawsHome",
            "drawsAway",
            "washouts",
            "byes",
            "forfeitsGiven",
            "forfeitsWonBy",
            "winPercentage",
            "winPercentageHome",
            "winPercentageAway",
            "scoredFor",
            "scoredForHome",
            "scoredForAway",
            "scoredAgainst",
            "scoredAgainstHome",
            "scoredAgainstAway",
            "percentage",
            "percentageHome",
            "percentageAway",
            "pointDifference",
            "pointDifferenceHome",
            "pointDifferenceAway",
            "lowestScoreFor",
            "lowestScoreForHome",
            "lowestScoreForAway",
            "highestScoreFor",
            "highestScoreForHome",
            "highestScoreForAway",
            "lowestScoreAgainst",
            "lowestScoreAgainstHome",
            "lowestScoreAgainstAway",
            "highestScoreAgainst",
            "highestScoreAgainstHome",
            "highestScoreAgainstAway",
            "streak",
            "streakHome",
            "streakAway",
        ):
            raise ValueError(
                "must validate the enum values ('position', 'played', 'playedHome', 'playedAway', 'wins', 'winsHome', 'winsAway', 'losses', 'lossesHome', 'lossesAway', 'draws', 'drawsHome', 'drawsAway', 'washouts', 'byes', 'forfeitsGiven', 'forfeitsWonBy', 'winPercentage', 'winPercentageHome', 'winPercentageAway', 'scoredFor', 'scoredForHome', 'scoredForAway', 'scoredAgainst', 'scoredAgainstHome', 'scoredAgainstAway', 'percentage', 'percentageHome', 'percentageAway', 'pointDifference', 'pointDifferenceHome', 'pointDifferenceAway', 'lowestScoreFor', 'lowestScoreForHome', 'lowestScoreForAway', 'highestScoreFor', 'highestScoreForHome', 'highestScoreForAway', 'lowestScoreAgainst', 'lowestScoreAgainstHome', 'lowestScoreAgainstAway', 'highestScoreAgainst', 'highestScoreAgainstHome', 'highestScoreAgainstAway', 'streak', 'streakHome', 'streakAway')"
            )
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StandingAdjustmentsModel:
        """Create an instance of StandingAdjustmentsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict["entity"] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of round
        if self.round:
            _dict["round"] = self.round.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stage
        if self.stage:
            _dict["stage"] = self.stage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pool
        if self.pool:
            _dict["pool"] = self.pool.to_dict()
        # override the default output from pydantic by calling `to_dict()` of division
        if self.division:
            _dict["division"] = self.division.to_dict()
        # override the default output from pydantic by calling `to_dict()` of conference
        if self.conference:
            _dict["conference"] = self.conference.to_dict()
        # set to None if round_code (nullable) is None
        if self.round_code is None:
            _dict["roundCode"] = None

        # set to None if round_number (nullable) is None
        if self.round_number is None:
            _dict["roundNumber"] = None

        # set to None if stage_code (nullable) is None
        if self.stage_code is None:
            _dict["stageCode"] = None

        # set to None if pool_code (nullable) is None
        if self.pool_code is None:
            _dict["poolCode"] = None

        # set to None if division_id (nullable) is None
        if self.division_id is None:
            _dict["divisionId"] = None

        # set to None if conference_id (nullable) is None
        if self.conference_id is None:
            _dict["conferenceId"] = None

        # set to None if reason_description (nullable) is None
        if self.reason_description is None:
            _dict["reasonDescription"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StandingAdjustmentsModel:
        """Create an instance of StandingAdjustmentsModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StandingAdjustmentsModel.parse_obj(obj)

        _obj = StandingAdjustmentsModel.parse_obj(
            {
                "standing_adjustment_id": obj.get("standingAdjustmentId"),
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "entity_id": obj.get("entityId"),
                "entity": FixtureEntitiesModelEntity.from_dict(obj.get("entity"))
                if obj.get("entity") is not None
                else None,
                "organization_id": obj.get("organizationId"),
                "organization": StandingAdjustmentsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "round_code": obj.get("roundCode"),
                "round": FixturesModelRound.from_dict(obj.get("round")) if obj.get("round") is not None else None,
                "round_number": obj.get("roundNumber"),
                "stage_code": obj.get("stageCode"),
                "stage": SeasonFixtureStagesPoolsListModelStage.from_dict(obj.get("stage"))
                if obj.get("stage") is not None
                else None,
                "pool_code": obj.get("poolCode"),
                "pool": SeasonFixtureStagesPoolsListModelPool.from_dict(obj.get("pool"))
                if obj.get("pool") is not None
                else None,
                "division_id": obj.get("divisionId"),
                "division": FixtureEntitiesModelDivision.from_dict(obj.get("division"))
                if obj.get("division") is not None
                else None,
                "conference_id": obj.get("conferenceId"),
                "conference": FixtureEntitiesModelConference.from_dict(obj.get("conference"))
                if obj.get("conference") is not None
                else None,
                "apply_to_all_standings": obj.get("applyToAllStandings"),
                "adjustment_group": obj.get("adjustmentGroup"),
                "adjustment_type": obj.get("adjustmentType"),
                "adjustment_field": obj.get("adjustmentField"),
                "adjustment_value": obj.get("adjustmentValue"),
                "reason_type": obj.get("reasonType"),
                "reason_description": obj.get("reasonDescription"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
