# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictStr, constr, validator


class StandingAdjustmentPostBody(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    standing_adjustment_id: Optional[StrictStr] = Field(
        None, alias="standingAdjustmentId", description="The unique identifier of the adjustment"
    )
    season_id: StrictStr = Field(..., alias="seasonId", description="The unique identifier of the season")
    entity_id: StrictStr = Field(..., alias="entityId", description="The unique identifier of the entity")
    round_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="roundCode", description="A unique code for the round. (Unique for season)"
    )
    round_number: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="roundNumber", description="The number given to the round"
    )
    stage_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="stageCode", description="A unique code for the stage. (Unique for season)"
    )
    pool_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="poolCode", description="A unique code for the pool. (Unique for season)"
    )
    division_id: Optional[StrictStr] = Field(
        None, alias="divisionId", description="The unique identifier of the division"
    )
    conference_id: Optional[StrictStr] = Field(
        None, alias="conferenceId", description="The unique identifier of the conference"
    )
    apply_to_all_standings: Optional[StrictBool] = Field(
        None, alias="applyToAllStandings", description="Apply to all generated standing types ?"
    )
    adjustment_group: Optional[StrictStr] = Field(
        None,
        alias="adjustmentGroup",
        description="Adjustment Group >- `IN_CONFERENCE` In Conference >- `IN_DIVISION` In Division >- `OUT_CONFERENCE` Out Conference >- `OUT_DIVISION` Out Division >- `OVERALL` Overall ",
    )
    adjustment_type: StrictStr = Field(
        ..., alias="adjustmentType", description="Adjustment Type >- `ADD_MINUS` Add/Subtract Value >- `SET` Set Value "
    )
    adjustment_field: StrictStr = Field(
        ...,
        alias="adjustmentField",
        description="Adjustment field to calculate standings >- `byes` Byes >- `draws` Games Drawn >- `drawsAway` Games Drawn (Away) >- `drawsHome` Games Drawn (Home) >- `forfeitsGiven` Forfeits Given >- `forfeitsWonBy` Forfeits Won >- `highestScoreAgainst` Highest Score Against >- `highestScoreAgainstAway` Highest Score Against (Away) >- `highestScoreAgainstHome` Highest Score Against (Home) >- `highestScoreFor` Highest Score For >- `highestScoreForAway` Highest Score For (Away) >- `highestScoreForHome` Highest Score For (Home) >- `losses` Games Lost >- `lossesAway` Games Lost (Away) >- `lossesHome` Games Lost (Home) >- `lowestScoreAgainst` Lowest Score Against >- `lowestScoreAgainstAway` Lowest Score Against (Away) >- `lowestScoreAgainstHome` Lowest Score Against (Home) >- `lowestScoreFor` Lowest Score For >- `lowestScoreForAway` Lowest Score For (Away) >- `lowestScoreForHome` Lowest Score For (Home) >- `percentage` For versus Against Percentage >- `percentageAway` For versus Against Percentage (Away) >- `percentageHome` For versus Against Percentage (Home) >- `played` Games Played >- `playedAway` Games Played (Away) >- `playedHome` Games Played (Home) >- `pointDifference` Point Difference >- `pointDifferenceAway` Point Difference (Away) >- `pointDifferenceHome` Point Difference (Home) >- `position` Standings Position >- `scoredAgainst` Score Against >- `scoredAgainstAway` Score Against (Away) >- `scoredAgainstHome` Score Against (Home) >- `scoredFor` Score For >- `scoredForAway` Score For (Away) >- `scoredForHome` Score For (Home) >- `streak` Winning Streak for competitor >- `streakAway` Winning Streak for competitor (Away) >- `streakHome` Winning Streak for competitor (Home) >- `washouts` Washouts >- `winPercentage` Win Percentage >- `winPercentageAway` Win Percentage (Away) >- `winPercentageHome` Win Percentage (Home) >- `wins` Games Won >- `winsAway` Games Won (Away) >- `winsHome` Games Won (Home) ",
    )
    adjustment_value: StrictFloat = Field(..., alias="adjustmentValue", description="Value of the adjustment field")
    reason_type: StrictStr = Field(..., alias="reasonType", description="Reason type of the adjustment")
    reason_description: Optional[StrictStr] = Field(
        None, alias="reasonDescription", description="Reason for the adjustment"
    )
    __properties = [
        "standingAdjustmentId",
        "seasonId",
        "entityId",
        "roundCode",
        "roundNumber",
        "stageCode",
        "poolCode",
        "divisionId",
        "conferenceId",
        "applyToAllStandings",
        "adjustmentGroup",
        "adjustmentType",
        "adjustmentField",
        "adjustmentValue",
        "reasonType",
        "reasonDescription",
    ]

    @validator("adjustment_group")
    def adjustment_group_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("OVERALL", "IN_CONFERENCE", "OUT_CONFERENCE", "IN_DIVISION", "OUT_DIVISION"):
            raise ValueError(
                "must validate the enum values ('OVERALL', 'IN_CONFERENCE', 'OUT_CONFERENCE', 'IN_DIVISION', 'OUT_DIVISION')"
            )
        return v

    @validator("adjustment_type")
    def adjustment_type_validate_enum(cls, v):
        if v not in ("SET", "ADD_MINUS"):
            raise ValueError("must validate the enum values ('SET', 'ADD_MINUS')")
        return v

    @validator("adjustment_field")
    def adjustment_field_validate_enum(cls, v):
        if v not in (
            "position",
            "played",
            "playedHome",
            "playedAway",
            "wins",
            "winsHome",
            "winsAway",
            "losses",
            "lossesHome",
            "lossesAway",
            "draws",
            "drawsHome",
            "drawsAway",
            "washouts",
            "byes",
            "forfeitsGiven",
            "forfeitsWonBy",
            "winPercentage",
            "winPercentageHome",
            "winPercentageAway",
            "scoredFor",
            "scoredForHome",
            "scoredForAway",
            "scoredAgainst",
            "scoredAgainstHome",
            "scoredAgainstAway",
            "percentage",
            "percentageHome",
            "percentageAway",
            "pointDifference",
            "pointDifferenceHome",
            "pointDifferenceAway",
            "lowestScoreFor",
            "lowestScoreForHome",
            "lowestScoreForAway",
            "highestScoreFor",
            "highestScoreForHome",
            "highestScoreForAway",
            "lowestScoreAgainst",
            "lowestScoreAgainstHome",
            "lowestScoreAgainstAway",
            "highestScoreAgainst",
            "highestScoreAgainstHome",
            "highestScoreAgainstAway",
            "streak",
            "streakHome",
            "streakAway",
        ):
            raise ValueError(
                "must validate the enum values ('position', 'played', 'playedHome', 'playedAway', 'wins', 'winsHome', 'winsAway', 'losses', 'lossesHome', 'lossesAway', 'draws', 'drawsHome', 'drawsAway', 'washouts', 'byes', 'forfeitsGiven', 'forfeitsWonBy', 'winPercentage', 'winPercentageHome', 'winPercentageAway', 'scoredFor', 'scoredForHome', 'scoredForAway', 'scoredAgainst', 'scoredAgainstHome', 'scoredAgainstAway', 'percentage', 'percentageHome', 'percentageAway', 'pointDifference', 'pointDifferenceHome', 'pointDifferenceAway', 'lowestScoreFor', 'lowestScoreForHome', 'lowestScoreForAway', 'highestScoreFor', 'highestScoreForHome', 'highestScoreForAway', 'lowestScoreAgainst', 'lowestScoreAgainstHome', 'lowestScoreAgainstAway', 'highestScoreAgainst', 'highestScoreAgainstHome', 'highestScoreAgainstAway', 'streak', 'streakHome', 'streakAway')"
            )
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StandingAdjustmentPostBody:
        """Create an instance of StandingAdjustmentPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if round_code (nullable) is None
        if self.round_code is None:
            _dict["roundCode"] = None

        # set to None if round_number (nullable) is None
        if self.round_number is None:
            _dict["roundNumber"] = None

        # set to None if stage_code (nullable) is None
        if self.stage_code is None:
            _dict["stageCode"] = None

        # set to None if pool_code (nullable) is None
        if self.pool_code is None:
            _dict["poolCode"] = None

        # set to None if division_id (nullable) is None
        if self.division_id is None:
            _dict["divisionId"] = None

        # set to None if conference_id (nullable) is None
        if self.conference_id is None:
            _dict["conferenceId"] = None

        # set to None if reason_description (nullable) is None
        if self.reason_description is None:
            _dict["reasonDescription"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StandingAdjustmentPostBody:
        """Create an instance of StandingAdjustmentPostBody from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StandingAdjustmentPostBody.parse_obj(obj)

        _obj = StandingAdjustmentPostBody.parse_obj(
            {
                "standing_adjustment_id": obj.get("standingAdjustmentId"),
                "season_id": obj.get("seasonId"),
                "entity_id": obj.get("entityId"),
                "round_code": obj.get("roundCode"),
                "round_number": obj.get("roundNumber"),
                "stage_code": obj.get("stageCode"),
                "pool_code": obj.get("poolCode"),
                "division_id": obj.get("divisionId"),
                "conference_id": obj.get("conferenceId"),
                "apply_to_all_standings": obj.get("applyToAllStandings"),
                "adjustment_group": obj.get("adjustmentGroup"),
                "adjustment_type": obj.get("adjustmentType"),
                "adjustment_field": obj.get("adjustmentField"),
                "adjustment_value": obj.get("adjustmentValue"),
                "reason_type": obj.get("reasonType"),
                "reason_description": obj.get("reasonDescription"),
            }
        )
        return _obj
