# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import date, datetime
from inspect import getfullargspec
from typing import List, Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, conint, constr, validator

from atriumsports.datacore.openapi.models.fixture_entities_model_conference import FixtureEntitiesModelConference
from atriumsports.datacore.openapi.models.fixture_entities_model_division import FixtureEntitiesModelDivision
from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.season_series_competitor import SeasonSeriesCompetitor
from atriumsports.datacore.openapi.models.season_series_model_organization import SeasonSeriesModelOrganization


class SeasonSeriesModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    series_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="seriesCode", description="A unique code for the season series. (Unique for season)"
    )
    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[SeasonSeriesModelOrganization] = None
    conference_id: Optional[StrictStr] = Field(
        None, alias="conferenceId", description="The unique identifier of the conference"
    )
    conference: Optional[FixtureEntitiesModelConference] = None
    division_id: Optional[StrictStr] = Field(
        None, alias="divisionId", description="The unique identifier of the division"
    )
    division: Optional[FixtureEntitiesModelDivision] = None
    name_local: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLocal",
        description="The name of the series in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    abbreviation_local: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="abbreviationLocal",
        description="An abbreviation/short name in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLatin",
        description="The name of the series in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    abbreviation_latin: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="abbreviationLatin",
        description="An abbreviation/short name in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    status: Optional[constr(strict=True, max_length=30)] = Field(
        None, description="Status >- `ACTIVE` Active >- `COMPLETE` Complete >- `NOT_STARTED` Not Started "
    )
    series_type: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="seriesType",
        description="The type of series >- `BEST_OF` Best of >- `HOME_AND_AWAY` Home and Away >- `KNOCKOUT` Knockout ",
    )
    best_of: Optional[conint(strict=True)] = Field(None, alias="bestOf", description="Best of number")
    series_number: Optional[conint(strict=True)] = Field(
        None, alias="seriesNumber", description="User defined series number"
    )
    max_fixtures_number: Optional[StrictInt] = Field(
        None, alias="maxFixturesNumber", description="The maximum number of games within a playoff series"
    )
    series_order: Optional[conint(strict=True)] = Field(
        None, alias="seriesOrder", description="User defined sort order of the series"
    )
    start_date: Optional[date] = Field(None, alias="startDate", description="Series start date")
    end_date: Optional[date] = Field(None, alias="endDate", description="Series end date")
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    competitors: Optional[List[SeasonSeriesCompetitor]] = Field(
        None, description="Array of competitors in the series. A competitor may have a results and a ranking"
    )
    __properties = [
        "seriesCode",
        "seasonId",
        "season",
        "organizationId",
        "organization",
        "conferenceId",
        "conference",
        "divisionId",
        "division",
        "nameLocal",
        "abbreviationLocal",
        "nameLatin",
        "abbreviationLatin",
        "status",
        "seriesType",
        "bestOf",
        "seriesNumber",
        "maxFixturesNumber",
        "seriesOrder",
        "startDate",
        "endDate",
        "externalId",
        "updated",
        "added",
        "competitors",
    ]

    @validator("status")
    def status_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("NOT_STARTED", "ACTIVE", "COMPLETE"):
            raise ValueError("must validate the enum values ('NOT_STARTED', 'ACTIVE', 'COMPLETE')")
        return v

    @validator("series_type")
    def series_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("BEST_OF", "HOME_AND_AWAY", "KNOCKOUT"):
            raise ValueError("must validate the enum values ('BEST_OF', 'HOME_AND_AWAY', 'KNOCKOUT')")
        return v

    @validator("external_id")
    def external_id_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[0-9A-Za-z\/_-]+$", v):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonSeriesModel:
        """Create an instance of SeasonSeriesModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of conference
        if self.conference:
            _dict["conference"] = self.conference.to_dict()
        # override the default output from pydantic by calling `to_dict()` of division
        if self.division:
            _dict["division"] = self.division.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in competitors (list)
        _items = []
        if self.competitors:
            for _item in self.competitors:
                if _item:
                    _items.append(_item.to_dict())
            _dict["competitors"] = _items
        # set to None if conference_id (nullable) is None
        if self.conference_id is None:
            _dict["conferenceId"] = None

        # set to None if division_id (nullable) is None
        if self.division_id is None:
            _dict["divisionId"] = None

        # set to None if abbreviation_local (nullable) is None
        if self.abbreviation_local is None:
            _dict["abbreviationLocal"] = None

        # set to None if name_latin (nullable) is None
        if self.name_latin is None:
            _dict["nameLatin"] = None

        # set to None if abbreviation_latin (nullable) is None
        if self.abbreviation_latin is None:
            _dict["abbreviationLatin"] = None

        # set to None if best_of (nullable) is None
        if self.best_of is None:
            _dict["bestOf"] = None

        # set to None if series_number (nullable) is None
        if self.series_number is None:
            _dict["seriesNumber"] = None

        # set to None if max_fixtures_number (nullable) is None
        if self.max_fixtures_number is None:
            _dict["maxFixturesNumber"] = None

        # set to None if series_order (nullable) is None
        if self.series_order is None:
            _dict["seriesOrder"] = None

        # set to None if start_date (nullable) is None
        if self.start_date is None:
            _dict["startDate"] = None

        # set to None if end_date (nullable) is None
        if self.end_date is None:
            _dict["endDate"] = None

        # set to None if external_id (nullable) is None
        if self.external_id is None:
            _dict["externalId"] = None

        # set to None if competitors (nullable) is None
        if self.competitors is None:
            _dict["competitors"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonSeriesModel:
        """Create an instance of SeasonSeriesModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SeasonSeriesModel.parse_obj(obj)

        _obj = SeasonSeriesModel.parse_obj(
            {
                "series_code": obj.get("seriesCode"),
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "organization_id": obj.get("organizationId"),
                "organization": SeasonSeriesModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "conference_id": obj.get("conferenceId"),
                "conference": FixtureEntitiesModelConference.from_dict(obj.get("conference"))
                if obj.get("conference") is not None
                else None,
                "division_id": obj.get("divisionId"),
                "division": FixtureEntitiesModelDivision.from_dict(obj.get("division"))
                if obj.get("division") is not None
                else None,
                "name_local": obj.get("nameLocal"),
                "abbreviation_local": obj.get("abbreviationLocal"),
                "name_latin": obj.get("nameLatin"),
                "abbreviation_latin": obj.get("abbreviationLatin"),
                "status": obj.get("status"),
                "series_type": obj.get("seriesType"),
                "best_of": obj.get("bestOf"),
                "series_number": obj.get("seriesNumber"),
                "max_fixtures_number": obj.get("maxFixturesNumber"),
                "series_order": obj.get("seriesOrder"),
                "start_date": obj.get("startDate"),
                "end_date": obj.get("endDate"),
                "external_id": obj.get("externalId"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
                "competitors": [SeasonSeriesCompetitor.from_dict(_item) for _item in obj.get("competitors")]
                if obj.get("competitors") is not None
                else None,
            }
        )
        return _obj
