# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, conint, constr, validator


class RoundPostBody(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    season_id: StrictStr = Field(..., alias="seasonId", description="The unique identifier of the season")
    round_code: constr(strict=True, max_length=30) = Field(
        ..., alias="roundCode", description="A unique code for the round. (Unique for season)"
    )
    pool_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="poolCode", description="A unique code for the pool. (Unique for season)"
    )
    stage_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="stageCode", description="A unique code for the stage. (Unique for season)"
    )
    round_number: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="roundNumber", description="The number given to the round"
    )
    name_local: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        alias="nameLocal",
        description="The name of the round in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_latin: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        alias="nameLatin",
        description="The name of the round in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    abbreviation_local: Optional[constr(strict=True, max_length=10)] = Field(
        None,
        alias="abbreviationLocal",
        description="An abbreviation/short name in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    abbreviation_latin: Optional[constr(strict=True, max_length=10)] = Field(
        None,
        alias="abbreviationLatin",
        description="An abbreviation/short name in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    round_order: Optional[conint(strict=True, le=999)] = Field(
        None, alias="roundOrder", description="User defined sort order of the stage"
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    __properties = [
        "seasonId",
        "roundCode",
        "poolCode",
        "stageCode",
        "roundNumber",
        "nameLocal",
        "nameLatin",
        "abbreviationLocal",
        "abbreviationLatin",
        "roundOrder",
        "externalId",
    ]

    @validator("external_id")
    def external_id_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[0-9A-Za-z\/_-]+$", v):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RoundPostBody:
        """Create an instance of RoundPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if pool_code (nullable) is None
        if self.pool_code is None:
            _dict["poolCode"] = None

        # set to None if stage_code (nullable) is None
        if self.stage_code is None:
            _dict["stageCode"] = None

        # set to None if round_number (nullable) is None
        if self.round_number is None:
            _dict["roundNumber"] = None

        # set to None if name_local (nullable) is None
        if self.name_local is None:
            _dict["nameLocal"] = None

        # set to None if name_latin (nullable) is None
        if self.name_latin is None:
            _dict["nameLatin"] = None

        # set to None if abbreviation_local (nullable) is None
        if self.abbreviation_local is None:
            _dict["abbreviationLocal"] = None

        # set to None if abbreviation_latin (nullable) is None
        if self.abbreviation_latin is None:
            _dict["abbreviationLatin"] = None

        # set to None if round_order (nullable) is None
        if self.round_order is None:
            _dict["roundOrder"] = None

        # set to None if external_id (nullable) is None
        if self.external_id is None:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RoundPostBody:
        """Create an instance of RoundPostBody from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return RoundPostBody.parse_obj(obj)

        _obj = RoundPostBody.parse_obj(
            {
                "season_id": obj.get("seasonId"),
                "round_code": obj.get("roundCode"),
                "pool_code": obj.get("poolCode"),
                "stage_code": obj.get("stageCode"),
                "round_number": obj.get("roundNumber"),
                "name_local": obj.get("nameLocal"),
                "name_latin": obj.get("nameLatin"),
                "abbreviation_local": obj.get("abbreviationLocal"),
                "abbreviation_latin": obj.get("abbreviationLatin"),
                "round_order": obj.get("roundOrder"),
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
