# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr


class RankingRowsPutBody(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    organization_id: Optional[constr(strict=True, max_length=5, min_length=5)] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    ranking_id: Optional[StrictStr] = Field(None, alias="rankingId", description="The unique identifier of the ranking")
    ranking_run_id: Optional[StrictStr] = Field(
        None, alias="rankingRunId", description="The unique identifier of the ranking run"
    )
    entity_id: Optional[StrictStr] = Field(
        None, alias="entityId", description="The entity that this ranking run is linked to"
    )
    position: Optional[StrictInt] = Field(None, description="Position")
    force_order: Optional[StrictInt] = Field(None, alias="forceOrder", description="Sort order to help ties")
    points: Optional[StrictInt] = Field(None, description="Points")
    points_string: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="pointsString", description="Points String"
    )
    __properties = [
        "organizationId",
        "rankingId",
        "rankingRunId",
        "entityId",
        "position",
        "forceOrder",
        "points",
        "pointsString",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RankingRowsPutBody:
        """Create an instance of RankingRowsPutBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if organization_id (nullable) is None
        if self.organization_id is None:
            _dict["organizationId"] = None

        # set to None if position (nullable) is None
        if self.position is None:
            _dict["position"] = None

        # set to None if force_order (nullable) is None
        if self.force_order is None:
            _dict["forceOrder"] = None

        # set to None if points (nullable) is None
        if self.points is None:
            _dict["points"] = None

        # set to None if points_string (nullable) is None
        if self.points_string is None:
            _dict["pointsString"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RankingRowsPutBody:
        """Create an instance of RankingRowsPutBody from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return RankingRowsPutBody.parse_obj(obj)

        _obj = RankingRowsPutBody.parse_obj(
            {
                "organization_id": obj.get("organizationId"),
                "ranking_id": obj.get("rankingId"),
                "ranking_run_id": obj.get("rankingRunId"),
                "entity_id": obj.get("entityId"),
                "position": obj.get("position"),
                "force_order": obj.get("forceOrder"),
                "points": obj.get("points"),
                "points_string": obj.get("pointsString"),
            }
        )
        return _obj
