# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictFloat, StrictStr, validator


class PersonAdditionalDetails(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    height: Optional[StrictFloat] = Field(None, description="Height in cms")
    weight: Optional[StrictFloat] = Field(None, description="Weight in kgs")
    dominant_hand: Optional[StrictStr] = Field(None, alias="dominantHand", description="Dominant hand")
    dominant_foot: Optional[StrictStr] = Field(None, alias="dominantFoot", description="Dominant foot")
    home_town: Optional[StrictStr] = Field(None, alias="homeTown", description="Hometown")
    college: Optional[StrictStr] = Field(None, description="College")
    representation: Optional[StrictStr] = Field(None, description="Representation")
    junior_association_league: Optional[StrictStr] = Field(
        None, alias="juniorAssociationLeague", description="Junior Association / League"
    )
    __properties = [
        "height",
        "weight",
        "dominantHand",
        "dominantFoot",
        "homeTown",
        "college",
        "representation",
        "juniorAssociationLeague",
    ]

    @validator("dominant_hand")
    def dominant_hand_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("LEFT", "RIGHT"):
            raise ValueError("must validate the enum values ('LEFT', 'RIGHT')")
        return v

    @validator("dominant_foot")
    def dominant_foot_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("LEFT", "RIGHT"):
            raise ValueError("must validate the enum values ('LEFT', 'RIGHT')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PersonAdditionalDetails:
        """Create an instance of PersonAdditionalDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if height (nullable) is None
        if self.height is None:
            _dict["height"] = None

        # set to None if weight (nullable) is None
        if self.weight is None:
            _dict["weight"] = None

        # set to None if dominant_hand (nullable) is None
        if self.dominant_hand is None:
            _dict["dominantHand"] = None

        # set to None if dominant_foot (nullable) is None
        if self.dominant_foot is None:
            _dict["dominantFoot"] = None

        # set to None if home_town (nullable) is None
        if self.home_town is None:
            _dict["homeTown"] = None

        # set to None if college (nullable) is None
        if self.college is None:
            _dict["college"] = None

        # set to None if representation (nullable) is None
        if self.representation is None:
            _dict["representation"] = None

        # set to None if junior_association_league (nullable) is None
        if self.junior_association_league is None:
            _dict["juniorAssociationLeague"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PersonAdditionalDetails:
        """Create an instance of PersonAdditionalDetails from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PersonAdditionalDetails.parse_obj(obj)

        _obj = PersonAdditionalDetails.parse_obj(
            {
                "height": obj.get("height"),
                "weight": obj.get("weight"),
                "dominant_hand": obj.get("dominantHand"),
                "dominant_foot": obj.get("dominantFoot"),
                "home_town": obj.get("homeTown"),
                "college": obj.get("college"),
                "representation": obj.get("representation"),
                "junior_association_league": obj.get("juniorAssociationLeague"),
            }
        )
        return _obj
