# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from inspect import getfullargspec
from typing import List, Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.images_model import ImagesModel


class OrganizationsModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    organization_id: Optional[constr(strict=True, max_length=5, min_length=5)] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    abbreviation_local: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="abbreviationLocal",
        description="An abbreviation/short name in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_local: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLocal",
        description="The name of the organization in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    abbreviation_latin: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="abbreviationLatin",
        description="An abbreviation/short name in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLatin",
        description="The name of the organization in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    country_code: Optional[constr(strict=True, max_length=3, min_length=3)] = Field(
        None,
        alias="countryCode",
        description="Country code of the organization. We recommend you use ISO-3166-1:alpha3 (upper case) values where available.",
    )
    region_type: Optional[StrictStr] = Field(
        None,
        alias="regionType",
        description="How geographically relevant is this organization >- `INTERNATIONAL` Multiple countries >- `INTERSTATE` Cross state >- `LOCAL` Local area >- `NATIONAL` One country >- `STATE` One state ",
    )
    default_locale: Optional[constr(strict=True, max_length=5, min_length=5)] = Field(
        None, alias="defaultLocale", description="The locale of the video"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    images: Optional[List[ImagesModel]] = None
    __properties = [
        "organizationId",
        "abbreviationLocal",
        "nameLocal",
        "abbreviationLatin",
        "nameLatin",
        "countryCode",
        "regionType",
        "defaultLocale",
        "updated",
        "added",
        "images",
    ]

    @validator("region_type")
    def region_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("LOCAL", "STATE", "INTERSTATE", "NATIONAL", "INTERNATIONAL"):
            raise ValueError(
                "must validate the enum values ('LOCAL', 'STATE', 'INTERSTATE', 'NATIONAL', 'INTERNATIONAL')"
            )
        return v

    @validator("default_locale")
    def default_locale_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[a-z]{2,2}-[A-Z]{2,2}$", v):
            raise ValueError(r"must validate the regular expression /^[a-z]{2,2}-[A-Z]{2,2}$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationsModel:
        """Create an instance of OrganizationsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item in self.images:
                if _item:
                    _items.append(_item.to_dict())
            _dict["images"] = _items
        # set to None if abbreviation_local (nullable) is None
        if self.abbreviation_local is None:
            _dict["abbreviationLocal"] = None

        # set to None if abbreviation_latin (nullable) is None
        if self.abbreviation_latin is None:
            _dict["abbreviationLatin"] = None

        # set to None if name_latin (nullable) is None
        if self.name_latin is None:
            _dict["nameLatin"] = None

        # set to None if country_code (nullable) is None
        if self.country_code is None:
            _dict["countryCode"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationsModel:
        """Create an instance of OrganizationsModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationsModel.parse_obj(obj)

        _obj = OrganizationsModel.parse_obj(
            {
                "organization_id": obj.get("organizationId"),
                "abbreviation_local": obj.get("abbreviationLocal"),
                "name_local": obj.get("nameLocal"),
                "abbreviation_latin": obj.get("abbreviationLatin"),
                "name_latin": obj.get("nameLatin"),
                "country_code": obj.get("countryCode"),
                "region_type": obj.get("regionType"),
                "default_locale": obj.get("defaultLocale"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
                "images": [ImagesModel.from_dict(_item) for _item in obj.get("images")]
                if obj.get("images") is not None
                else None,
            }
        )
        return _obj
