# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, constr, validator


class ImagesPutBody(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    rating: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        description="The rating given to the quality of the image.  All images are LOW by default but are set ad MEDIUM if they are large enough and have transparency.  Images are only marked as HIGH if they have been manually reviewed.  You should take your use-case into account when you go to use the image. >- `HIGH` High >- `LOW` Low >- `MEDIUM` Medium ",
    )
    __properties = ["rating"]

    @validator("rating")
    def rating_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("LOW", "MEDIUM", "HIGH"):
            raise ValueError("must validate the enum values ('LOW', 'MEDIUM', 'HIGH')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ImagesPutBody:
        """Create an instance of ImagesPutBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ImagesPutBody:
        """Create an instance of ImagesPutBody from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ImagesPutBody.parse_obj(obj)

        _obj = ImagesPutBody.parse_obj({"rating": obj.get("rating")})
        return _obj
